% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{pdftools}
\alias{pdftools}
\alias{pdf_info}
\alias{pdf_text}
\alias{pdf_data}
\alias{pdf_fonts}
\alias{pdf_attachments}
\alias{pdf_toc}
\alias{pdf_pagesize}
\title{PDF utilities}
\usage{
pdf_info(pdf, opw = "", upw = "")

pdf_text(pdf, opw = "", upw = "")

pdf_data(pdf, opw = "", upw = "")

pdf_fonts(pdf, opw = "", upw = "")

pdf_attachments(pdf, opw = "", upw = "")

pdf_toc(pdf, opw = "", upw = "")

pdf_pagesize(pdf, opw = "", upw = "")
}
\arguments{
\item{pdf}{file path or raw vector with pdf data}

\item{opw}{string with owner password to open pdf}

\item{upw}{string with user password to open pdf}
}
\description{
Utilities based on libpoppler for extracting text, fonts, attachments
and metadata from a pdf file.
}
\details{
The \code{\link{pdf_text}} function renders all textboxes on a text canvas
and returns a character vector of equal length to the number of pages in the
PDF file. On the other hand, \code{\link{pdf_data}} is more low level and
returns one data frame per page, containing one row for each textbox in the PDF.

Note that \code{\link{pdf_data}} requires a recent version of libpoppler
which might not be available on all Linux systems.
When using \code{\link{pdf_data}} in R packages, condition use on
\code{poppler_config()$has_pdf_data} which shows if this function can be
used on the current system. For Ubuntu 16.04 (Xenial) and 18.04 (Bionic)
you can use \href{https://github.com/ropensci/pdftools#installation}{the PPA}
with backports of Poppler 0.74.0.

Poppler is pretty verbose when encountering minor errors in PDF files,
in especially \code{\link{pdf_text}}. These messages are usually safe
to ignore, use \code{\link{suppressMessages}} to hide them altogether.
}
\examples{
# Just a random pdf file
pdf_file <- file.path(R.home("doc"), "NEWS.pdf")
info <- pdf_info(pdf_file)
text <- pdf_text(pdf_file)
fonts <- pdf_fonts(pdf_file)
files <- pdf_attachments(pdf_file)
}
\seealso{
Other pdftools: 
\code{\link{pdf_ocr_text}()},
\code{\link{qpdf}},
\code{\link{rendering}}
}
\concept{pdftools}
