% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfRowsToList.R
\name{dfRowsToList}
\alias{dfRowsToList}
\alias{dfRowToList}
\title{Convert a data.frame row to list of parameter-value-lists.}
\usage{
dfRowsToList(df, par.set, enforce.col.types = FALSE, ...)

dfRowToList(df, par.set, i, enforce.col.types = FALSE, ...)
}
\arguments{
\item{df}{(\code{data.frame})\cr
Data.frame, potentially from \code{\link[=OptPathDF]{OptPathDF()}}.
Columns are assumed to be in the same order as par.set.}

\item{par.set}{\link{ParamSet}\cr
Parameter set.}

\item{enforce.col.types}{(\code{logical(1)})\cr
Should all \code{df} columns be initially converted to the type returned by
\code{getParamTypes(df, df.cols = TRUE)}. This can help to work with
\dQuote{non-standard} data.frames where the types are slightly
\dQuote{off}. But note that there is no guarantee that this will work if
the types are really wrong and there is no naturally correct way to convert
them. Default is \code{FALSE}.}

\item{...}{(any)\cr
Arguments passed to \code{\link[BBmisc:convertDataFrameCols]{BBmisc::convertDataFrameCols()}}}

\item{i}{(\code{integer(1)})\cr
Row index.}
}
\value{
\code{\link{list}}. Named by parameter ids.
}
\description{
Please note that (naturally) the columns of \code{df} have to be of
the correct type w.r.t. the corresponding parameter. The only exception are
integer parameters where the corresponding columns in \code{df} are allowed to be
numerics. And also see the argument \code{enforce.col.types} as a way around this
restriction.

\tabular{ll}{
numeric(vector)   \tab  \code{numeric}  \cr
integer(vector)   \tab  \code{integer}  \cr
discrete(vector)  \tab  \code{factor} (names of values = levels) \cr
logical(vector)   \tab  \code{logical}
}

Dependent parameters whose requirements are not satisfied are represented by
a scalar NA in the output.
}
