% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pptx_slide_manip.R
\name{on_slide}
\alias{on_slide}
\title{Change current slide}
\usage{
on_slide(x, index)
}
\arguments{
\item{x}{an rpptx object}

\item{index}{slide index}
}
\description{
Change current slide index of an rpptx object.
}
\examples{
doc <- read_pptx()
doc <- add_slide(doc, layout = "Title and Content", master = "Office Theme")
doc <- add_slide(doc, layout = "Title and Content", master = "Office Theme")
doc <- add_slide(doc, layout = "Title and Content", master = "Office Theme")
doc <- on_slide(doc, index = 1)
doc <- ph_with(
  x = doc, "First title",
  location = ph_location_type(type = "title")
)
doc <- on_slide(doc, index = 3)
doc <- ph_with(
  x = doc, "Third title",
  location = ph_location_type(type = "title")
)

file <- tempfile(fileext = ".pptx")
print(doc, target = file)
}
\seealso{
\code{\link[=read_pptx]{read_pptx()}}, \code{\link[=ph_with]{ph_with()}}

Other functions slide manipulation: 
\code{\link{add_slide}()},
\code{\link{move_slide}()},
\code{\link{remove_slide}()},
\code{\link{set_notes}()}
}
\concept{functions slide manipulation}
