% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_residuals.R
\name{get_residuals}
\alias{get_residuals}
\alias{get_residuals.default}
\title{Extract model residuals}
\usage{
get_residuals(x, ...)

\method{get_residuals}{default}(x, weighted = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{x}{A model.}

\item{...}{Passed down to \code{residuals()}, if possible.}

\item{weighted}{Logical, if \code{TRUE}, returns weighted residuals.}

\item{verbose}{Toggle warnings and messages.}
}
\value{
The residuals, or \code{NULL} if this information could not be accessed.
}
\description{
Returns the residuals from regression models.
}
\note{
This function returns the default type of residuals, i.e. for the
response from linear models, the deviance residuals for models of class
\code{glm} etc. To access different types, pass down the \code{type} argument
(see 'Examples').
\cr \cr
This function is a robust alternative to \code{residuals()}, as it works
for some special model objects that otherwise do not respond properly to
calling \code{residuals()}.
}
\examples{
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
get_residuals(m)

m <- glm(vs ~ wt + cyl + mpg, data = mtcars, family = binomial())
get_residuals(m) # type = "deviance" by default
get_residuals(m, type = "response")
}
