% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{validate_outcomes_are_univariate}
\alias{validate_outcomes_are_univariate}
\alias{check_outcomes_are_univariate}
\title{Ensure that the outcome is univariate}
\usage{
validate_outcomes_are_univariate(outcomes)

check_outcomes_are_univariate(outcomes)
}
\arguments{
\item{outcomes}{An object to check.}
}
\value{
\code{validate_outcomes_are_univariate()} returns \code{outcomes} invisibly.

\code{check_outcomes_are_univariate()} returns a named list of two components,
\code{ok} and \code{n_cols}.
}
\description{
validate - asserts the following:
\itemize{
\item \code{outcomes} must have 1 column. Atomic vectors are treated as
1 column matrices.
}

check - returns the following:
\itemize{
\item \code{ok} A logical. Does the check pass?
\item \code{n_cols} A single numeric. The actual number of columns.
}
}
\details{
The expected way to use this validation function is to supply it the
\verb{$outcomes} element of the result of a call to \code{\link[=mold]{mold()}}.
}
\section{Validation}{


hardhat provides validation functions at two levels.
\itemize{
\item \verb{check_*()}:  \emph{check a condition, and return a list}. The list
always contains at least one element, \code{ok}, a logical that specifies if the
check passed. Each check also has check specific elements in the returned
list that can be used to construct meaningful error messages.
\item \verb{validate_*()}: \emph{check a condition, and error if it does not pass}. These
functions call their corresponding check function, and
then provide a default error message. If you, as a developer, want a
different error message, then call the \verb{check_*()} function yourself,
and provide your own validation function.
}
}

\examples{
validate_outcomes_are_univariate(data.frame(x = 1))

try(validate_outcomes_are_univariate(mtcars))
}
\seealso{
Other validation functions: 
\code{\link{validate_column_names}()},
\code{\link{validate_no_formula_duplication}()},
\code{\link{validate_outcomes_are_binary}()},
\code{\link{validate_outcomes_are_factors}()},
\code{\link{validate_outcomes_are_numeric}()},
\code{\link{validate_prediction_size}()},
\code{\link{validate_predictors_are_numeric}()}
}
\concept{validation functions}
