% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_stress.R, R/layouts.R
\name{layout_focus}
\alias{layout_focus}
\alias{layout_with_focus}
\alias{layout_igraph_focus}
\title{radial focus layout}
\usage{
layout_with_focus(g, v, weights = NA, iter = 500, tol = 1e-04)

layout_igraph_focus(g, v, weights = NA, iter = 500, tol = 1e-04, circular)
}
\arguments{
\item{g}{igraph object}

\item{v}{id of focal node to be placed in the center}

\item{weights}{possibly a numeric vector with edge weights. If this is NULL and the graph has a weight edge attribute, then the attribute is used. If this is NA then no weights are used (even if the graph has a weight attribute). By default, weights are ignored. See details for more.}

\item{iter}{number of iterations during stress optimization}

\item{tol}{stopping criterion for stress optimization}

\item{circular}{not used}
}
\value{
a list containing xy coordinates and the distances to the focal node
}
\description{
arrange nodes in concentric circles around a focal node according to their distance from the focus.
}
\details{
Be careful when using weights. In most cases, the inverse of the edge weights should be used to ensure that the endpoints of an edges with higher weights are closer together (weights=1/E(g)$weight).
}
\examples{
library(igraph)
g <- sample_gnp(10, 0.4)
coords <- layout_with_focus(g, v = 1)
coords
}
\references{
Brandes, U., & Pich, C. (2011). More flexible radial layout. \emph{Journal of Graph Algorithms and Applications}, 15(1), 157-173.
}
\seealso{
\link{layout_focus_group}
The layout_igraph_* function should not be used directly. It is only used as an argument for plotting with 'igraph'.
'ggraph' natively supports the layout.
}
