% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_hist_binning_CV.R
\name{hist_binning_CV}
\alias{hist_binning_CV}
\title{hist_binning_CV}
\usage{
hist_binning_CV(actual, predicted, n_bins = 15, n_folds = 10, seed, input)
}
\arguments{
\item{actual}{vector of observed class labels (0/1)}

\item{predicted}{vector of uncalibrated predictions}

\item{n_bins}{number of bins used in the histogram binning scheme, Default: 15}

\item{n_folds}{number of folds in the cross-validation, Default: 10}

\item{seed}{random seed to alternate the split of data set partitions}

\item{input}{specify if the input was scaled or transformed, scaled=1, transformed=2}
}
\value{
list object containing the following components:
\item{error}{list object that summarizes discrimination and calibration errors obtained during the CV}
\item{type}{"hist"}
\item{probs_CV}{vector of calibrated predictions that was used during the CV}
\item{actual_CV}{respective vector of true values (0 or 1) that was used during the CV}
}
\description{
trains and evaluates the histogram binning calibration model repeated \code{folds}-Cross-Validation (CV).
The \code{predicted} values are partitioned into n subsets. A histogram binning model is constructed on (n-1) subsets; the remaining set is used
for testing the model. All test set predictions are merged and used to compute error metrics for the model.
}
