% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{enzymes}
\alias{enzymes}
\title{Liver Enzyme Data}
\format{
A data frame with 218 rows and the following 6 columns:
\itemize{
\item \code{Patient}: Patient ID
\item \code{Group}: Four diagnostic groups were considered: acute viral
hepatitis (1), persistent chronic hepatitis (2), aggressive chronic
hepatitis (3) and post-necrotic cirrhosis (4).
\item \code{AST}: Aspartate aminotransferase (in U/L)
\item \code{ALT}: Alanine aminotransferase (in U/L)
\item \code{GLDH}: Glutamate dehydrogenase (in U/L)
\item \code{OCT}: Ornithine carbamyltransferase (in U/L)
}
}
\source{
Data from Albert and Harris (1984, Chapter 5, Appendix I), and is
also provided by the
\href{https://cran.r-project.org/package=pmlr}{\pkg{pmlr}} R package.
}
\usage{
enzymes
}
\description{
Liver enzyme data collected from 218 patients with liver disease
(Plomteux, 1980). The laboratory profile consists of enzymatic
activity measured for four liver enzymes: aspartate
aminotransferase (\code{AST}), alanine aminotransferase (\code{ALT}),
glutamate dehydrogenase (\code{GLDH}) and ornithine carbamyltransferase
(\code{OCT}).
}
\references{
Albert A, Harris E K (1984). \emph{Multivariate Interpretation of
Clinical Laboratory Data}. Dekker: New York.

Plomteux G (1980). Multivariate analysis of an enzyme profile for
the differential diagnosis of viral hepatitis. \emph{Clinical
Chemistry}, \strong{26}, 1897-1899.
}
\keyword{datasets}
