% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BreakpointGRanges.R
\name{findTransitiveCalls}
\alias{findTransitiveCalls}
\title{Identifies potential transitive imprecise calls that can be explained by
traversing multiple breakpoints.}
\usage{
findTransitiveCalls(
  transitiveGr,
  subjectGr,
  maximumImpreciseInsertSize = 700,
  minimumTraversedBreakpoints = 2,
  maximumTraversedBreakpoints = 6,
  positionalMargin = 8,
  insertionLengthMargin = 50,
  insLen = transitiveGr$insLen,
  impreciseTransitiveCalls = (transitiveGr$HOMLEN == 0 | is.null(transitiveGr$HOMLEN))
    & start(transitiveGr) != end(transitiveGr),
  impreciseSubjectCalls = (subjectGr$HOMLEN == 0 | is.null(subjectGr$HOMLEN)) &
    start(subjectGr) != end(subjectGr),
  allowImprecise = FALSE
)
}
\arguments{
\item{transitiveGr}{a breakpoint GRanges object containing imprecise calls}

\item{subjectGr}{breakpoints to traverse}

\item{maximumImpreciseInsertSize}{Expected number of bases to traverse imprecise calls.}

\item{minimumTraversedBreakpoints}{Minimum number of traversed breakpoints to consider a transitive}

\item{maximumTraversedBreakpoints}{Maximum number of breakpoints to traverse when looking for an explanation of the transitive calls}

\item{positionalMargin}{Allowable margin of error when matching call positional overlaps.
A non-zero margin allows for matching of breakpoint with imperfect homology.}

\item{insertionLengthMargin}{Allowable difference in length between the inserted sequence and the traversed
path length.
Defaults to 50bp to allow for long read indel errors.}

\item{insLen}{Integer vector of same length as `transitiveGr` indicating the number
of bases inserted at the breakpoint.

Defaults to transitiveGr$insLen which will be present if the GRanges
was loaded from a VCF using breakpointRanges()}

\item{impreciseTransitiveCalls}{Boolean vector of same length as `transitiveGr` indicating which calls
are imprecise calls. Defaults to calls with a non-zero interval size
that have no homology.}

\item{impreciseSubjectCalls}{Boolean vector of same length as `subjectGr` indicating which calls
are imprecise calls. Defaults to calls with a non-zero interval size
that have no homology.}

\item{allowImprecise}{Allow traversal of imprecise calls.
Defaults to FALSE as to prevent spurious results which skip
some breakpoints when traversing multiple breakpoints
E.g. An A-D transitive from an underlying A-B-C-D rearrangement
will include A-B-D and A-C-D results if allowImprecise=TRUE.}
}
\value{
`DataFrame` containing the transitive calls traversed with the following columns:
| column | meaning | 
| ------ | ------- | 
| transitive_breakpoint_name | Name of the transitive breakpoint a path was found for |
| total_distance | Total length (in bp) of the path |
| traversed_breakpoint_names | `CharacterList` of names of breakpoint traversed in the path |
| distance_to_traversed_breakpoint | `IntegerList` of distances from start of path to end of traversing breakpoint |
}
\description{
Transitive calls are imprecise breakpoints or breakpoints with inserted sequence
that can be explained by a sequence of breakpoints.
That is, A-C calls in which additional sequence may be between A and C that
can be explained by A-B-C.
}
