# Generated by tests/testthat/generate_tests_helper_script.R
# do not edit by hand


# Make a matrix with different features
mat <- matrix(rnorm(16 * 6), nrow = 16, ncol = 6)
mat[1,1] <- 0
mat[2,3] <- NA
mat[3,3] <- -Inf
mat[5,4] <- NaN
mat[5,1] <- Inf
mat[6,2] <- 0
mat[6,5] <- 0



test_that("colAlls works ", {

	matrixStats_formals <- formals(matrixStats::colAlls)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colAlls)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colAlls(x = mat)
	ms_res_def_1 <- matrixStats::colAlls(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colAlls(x = mat, rows = NULL, cols = NULL, value = TRUE, na.rm = TRUE, dim. = dim(mat))
	ms_res_1 <- matrixStats::colAlls(x = mat, rows = NULL, cols = NULL, value = TRUE, na.rm = TRUE, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colAlls(x = mat, rows = 1:3, cols = c(2, 4), value = FALSE, na.rm = FALSE, dim. = dim(mat))
	ms_res_2 <- matrixStats::colAlls(x = mat, rows = 1:3, cols = c(2, 4), value = FALSE, na.rm = FALSE, dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- colAlls(x = mat, rows = NULL, cols = NULL, value = 0, na.rm = TRUE, dim. = dim(mat))
	ms_res_3 <- matrixStats::colAlls(x = mat, rows = NULL, cols = NULL, value = 0, na.rm = TRUE, dim. = dim(mat))
	expect_equal(mg_res_3, ms_res_3)
})


test_that("colAnyNAs works ", {

	matrixStats_formals <- formals(matrixStats::colAnyNAs)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colAnyNAs)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colAnyNAs(x = mat)
	ms_res_def_1 <- matrixStats::colAnyNAs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colAnyNAs(x = mat, rows = NULL, cols = NULL)
	ms_res_1 <- matrixStats::colAnyNAs(x = mat, rows = NULL, cols = NULL)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colAnyNAs(x = mat, rows = 1:3, cols = c(2, 4))
	ms_res_2 <- matrixStats::colAnyNAs(x = mat, rows = 1:3, cols = c(2, 4))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colAnys works ", {

	matrixStats_formals <- formals(matrixStats::colAnys)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colAnys)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colAnys(x = mat)
	ms_res_def_1 <- matrixStats::colAnys(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colAnys(x = mat, rows = NULL, cols = NULL, value = TRUE, na.rm = TRUE, dim. = dim(mat))
	ms_res_1 <- matrixStats::colAnys(x = mat, rows = NULL, cols = NULL, value = TRUE, na.rm = TRUE, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colAnys(x = mat, rows = 1:3, cols = c(2, 4), value = FALSE, na.rm = FALSE, dim. = dim(mat))
	ms_res_2 <- matrixStats::colAnys(x = mat, rows = 1:3, cols = c(2, 4), value = FALSE, na.rm = FALSE, dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- colAnys(x = mat, rows = NULL, cols = NULL, value = 0, na.rm = TRUE, dim. = dim(mat))
	ms_res_3 <- matrixStats::colAnys(x = mat, rows = NULL, cols = NULL, value = 0, na.rm = TRUE, dim. = dim(mat))
	expect_equal(mg_res_3, ms_res_3)
})


test_that("colAvgsPerRowSet works ", {

	matrixStats_formals <- formals(matrixStats::colAvgsPerRowSet)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colAvgsPerRowSet)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	S <- matrix(1:nrow(mat), ncol = 2)
	mg_res_def_1 <- colAvgsPerRowSet(X = mat, S = S, FUN = colMeans)
	ms_res_def_1 <- matrixStats::colAvgsPerRowSet(X = mat, S = S, FUN = colMeans)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_def_2 <- colAvgsPerRowSet(X = mat, S = S, FUN = colVars)
	ms_res_def_2 <- matrixStats::colAvgsPerRowSet(X = mat, S = S, FUN = colVars)
	expect_equal(mg_res_def_2, ms_res_def_2)

	mg_res_1 <- colAvgsPerRowSet(X = mat, W = NULL, cols = NULL, S = S, FUN = colMeans, na.rm = TRUE, tFUN = FALSE)
	ms_res_1 <- matrixStats::colAvgsPerRowSet(X = mat, W = NULL, cols = NULL, S = S, FUN = colMeans, na.rm = TRUE, tFUN = FALSE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colAvgsPerRowSet(X = mat, W = NULL, cols = 1:2, S = S, FUN = colVars, na.rm = FALSE, tFUN = FALSE)
	ms_res_2 <- matrixStats::colAvgsPerRowSet(X = mat, W = NULL, cols = 1:2, S = S, FUN = colVars, na.rm = FALSE, tFUN = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colCollapse works ", {

	matrixStats_formals <- formals(matrixStats::colCollapse)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colCollapse)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colCollapse(x = mat, idxs = 1)
	ms_res_def_1 <- matrixStats::colCollapse(x = mat, idxs = 1)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_def_2 <- colCollapse(x = mat, idxs = 2:3)
	ms_res_def_2 <- matrixStats::colCollapse(x = mat, idxs = 2:3)
	expect_equal(mg_res_def_2, ms_res_def_2)

	mg_res_1 <- colCollapse(x = mat, idxs = 1, cols = NULL, dim. = dim(mat))
	ms_res_1 <- matrixStats::colCollapse(x = mat, idxs = 1, cols = NULL, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colCollapse(x = mat, idxs = 2:3, cols = c(2, 4), dim. = dim(mat))
	ms_res_2 <- matrixStats::colCollapse(x = mat, idxs = 2:3, cols = c(2, 4), dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colCounts works ", {

	matrixStats_formals <- formals(matrixStats::colCounts)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colCounts)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colCounts(x = mat)
	ms_res_def_1 <- matrixStats::colCounts(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colCounts(x = mat, rows = NULL, cols = NULL, value = TRUE, na.rm = TRUE, dim. = dim(mat))
	ms_res_1 <- matrixStats::colCounts(x = mat, rows = NULL, cols = NULL, value = TRUE, na.rm = TRUE, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colCounts(x = mat, rows = 1:3, cols = c(2, 4), value = FALSE, na.rm = FALSE, dim. = dim(mat))
	ms_res_2 <- matrixStats::colCounts(x = mat, rows = 1:3, cols = c(2, 4), value = FALSE, na.rm = FALSE, dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- colCounts(x = mat, rows = NULL, cols = NULL, value = 0, na.rm = TRUE, dim. = dim(mat))
	ms_res_3 <- matrixStats::colCounts(x = mat, rows = NULL, cols = NULL, value = 0, na.rm = TRUE, dim. = dim(mat))
	expect_equal(mg_res_3, ms_res_3)
})


test_that("colCummaxs works ", {

	matrixStats_formals <- formals(matrixStats::colCummaxs)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colCummaxs)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colCummaxs(x = mat)
	ms_res_def_1 <- matrixStats::colCummaxs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colCummaxs(x = mat, rows = NULL, cols = NULL, dim. = dim(mat))
	ms_res_1 <- matrixStats::colCummaxs(x = mat, rows = NULL, cols = NULL, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colCummaxs(x = mat, rows = 1:3, cols = c(2, 4), dim. = dim(mat))
	ms_res_2 <- matrixStats::colCummaxs(x = mat, rows = 1:3, cols = c(2, 4), dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colCummins works ", {

	matrixStats_formals <- formals(matrixStats::colCummins)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colCummins)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colCummins(x = mat)
	ms_res_def_1 <- matrixStats::colCummins(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colCummins(x = mat, rows = NULL, cols = NULL, dim. = dim(mat))
	ms_res_1 <- matrixStats::colCummins(x = mat, rows = NULL, cols = NULL, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colCummins(x = mat, rows = 1:3, cols = c(2, 4), dim. = dim(mat))
	ms_res_2 <- matrixStats::colCummins(x = mat, rows = 1:3, cols = c(2, 4), dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colCumprods works ", {

	matrixStats_formals <- formals(matrixStats::colCumprods)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colCumprods)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colCumprods(x = mat)
	ms_res_def_1 <- matrixStats::colCumprods(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colCumprods(x = mat, rows = NULL, cols = NULL, dim. = dim(mat))
	ms_res_1 <- matrixStats::colCumprods(x = mat, rows = NULL, cols = NULL, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colCumprods(x = mat, rows = 1:3, cols = c(2, 4), dim. = dim(mat))
	ms_res_2 <- matrixStats::colCumprods(x = mat, rows = 1:3, cols = c(2, 4), dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colCumsums works ", {

	matrixStats_formals <- formals(matrixStats::colCumsums)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colCumsums)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colCumsums(x = mat)
	ms_res_def_1 <- matrixStats::colCumsums(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colCumsums(x = mat, rows = NULL, cols = NULL, dim. = dim(mat))
	ms_res_1 <- matrixStats::colCumsums(x = mat, rows = NULL, cols = NULL, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colCumsums(x = mat, rows = 1:3, cols = c(2, 4), dim. = dim(mat))
	ms_res_2 <- matrixStats::colCumsums(x = mat, rows = 1:3, cols = c(2, 4), dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colDiffs works ", {

	matrixStats_formals <- formals(matrixStats::colDiffs)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colDiffs)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colDiffs(x = mat)
	ms_res_def_1 <- matrixStats::colDiffs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colDiffs(x = mat, rows = NULL, cols = NULL, lag = 1, differences = 1, dim. = dim(mat))
	ms_res_1 <- matrixStats::colDiffs(x = mat, rows = NULL, cols = NULL, lag = 1, differences = 1, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colDiffs(x = mat, rows = 1:3, cols = c(2, 4), lag = 3, differences = 2, dim. = dim(mat))
	ms_res_2 <- matrixStats::colDiffs(x = mat, rows = 1:3, cols = c(2, 4), lag = 3, differences = 2, dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colIQRDiffs works ", {

	matrixStats_formals <- formals(matrixStats::colIQRDiffs)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colIQRDiffs)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colIQRDiffs(x = mat)
	ms_res_def_1 <- matrixStats::colIQRDiffs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colIQRDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0)
	ms_res_1 <- matrixStats::colIQRDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colIQRDiffs(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, diff = 2, trim = 0.333333333333333)
	ms_res_2 <- matrixStats::colIQRDiffs(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, diff = 2, trim = 0.333333333333333)
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- colIQRDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5)
	ms_res_3 <- matrixStats::colIQRDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5)
	expect_equal(mg_res_3, ms_res_3)
})


test_that("colIQRs works ", {

	matrixStats_formals <- formals(matrixStats::colIQRs)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colIQRs)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colIQRs(x = mat)
	ms_res_def_1 <- matrixStats::colIQRs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colIQRs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE)
	ms_res_1 <- matrixStats::colIQRs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colIQRs(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE)
	ms_res_2 <- matrixStats::colIQRs(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colLogSumExps works ", {

	matrixStats_formals <- formals(matrixStats::colLogSumExps)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colLogSumExps)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colLogSumExps(lx = mat)
	ms_res_def_1 <- matrixStats::colLogSumExps(lx = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colLogSumExps(lx = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat))
	ms_res_1 <- matrixStats::colLogSumExps(lx = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colLogSumExps(lx = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, dim. = dim(mat))
	ms_res_2 <- matrixStats::colLogSumExps(lx = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colMadDiffs works ", {

	matrixStats_formals <- formals(matrixStats::colMadDiffs)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colMadDiffs)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colMadDiffs(x = mat)
	ms_res_def_1 <- matrixStats::colMadDiffs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colMadDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0)
	ms_res_1 <- matrixStats::colMadDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colMadDiffs(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, diff = 2, trim = 0.333333333333333)
	ms_res_2 <- matrixStats::colMadDiffs(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, diff = 2, trim = 0.333333333333333)
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- colMadDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5)
	ms_res_3 <- matrixStats::colMadDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5)
	expect_equal(mg_res_3, ms_res_3)
})


test_that("colMads works ", {

	matrixStats_formals <- formals(matrixStats::colMads)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colMads)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colMads(x = mat)
	ms_res_def_1 <- matrixStats::colMads(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colMads(x = mat, rows = NULL, cols = NULL, center = NULL, constant = 1.4826, na.rm = TRUE, dim. = dim(mat))
	ms_res_1 <- matrixStats::colMads(x = mat, rows = NULL, cols = NULL, center = NULL, constant = 1.4826, na.rm = TRUE, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colMads(x = mat, rows = 1:3, cols = c(2, 4), center = colMeans(mat[1:3, ]), constant = 5, na.rm = FALSE, dim. = dim(mat))
	ms_res_2 <- matrixStats::colMads(x = mat, rows = 1:3, cols = c(2, 4), center = colMeans(mat[1:3, ]), constant = 5, na.rm = FALSE, dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colMaxs works ", {

	matrixStats_formals <- formals(matrixStats::colMaxs)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colMaxs)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colMaxs(x = mat)
	ms_res_def_1 <- matrixStats::colMaxs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colMaxs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat))
	ms_res_1 <- matrixStats::colMaxs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colMaxs(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, dim. = dim(mat))
	ms_res_2 <- matrixStats::colMaxs(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colMeans2 works ", {

	matrixStats_formals <- formals(matrixStats::colMeans2)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colMeans2)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colMeans2(x = mat)
	ms_res_def_1 <- matrixStats::colMeans2(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colMeans2(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat))
	ms_res_1 <- matrixStats::colMeans2(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colMeans2(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, dim. = dim(mat))
	ms_res_2 <- matrixStats::colMeans2(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colMedians works ", {

	matrixStats_formals <- formals(matrixStats::colMedians)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colMedians)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colMedians(x = mat)
	ms_res_def_1 <- matrixStats::colMedians(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colMedians(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat))
	ms_res_1 <- matrixStats::colMedians(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colMedians(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, dim. = dim(mat))
	ms_res_2 <- matrixStats::colMedians(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colMins works ", {

	matrixStats_formals <- formals(matrixStats::colMins)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colMins)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colMins(x = mat)
	ms_res_def_1 <- matrixStats::colMins(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colMins(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat))
	ms_res_1 <- matrixStats::colMins(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colMins(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, dim. = dim(mat))
	ms_res_2 <- matrixStats::colMins(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colOrderStats works ", {

	matrixStats_formals <- formals(matrixStats::colOrderStats)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colOrderStats)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mat[is.na(mat)] <- 4.1
	mg_res_def_1 <- colOrderStats(x = mat, which = 2)
	ms_res_def_1 <- matrixStats::colOrderStats(x = mat, which = 2)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_def_2 <- colOrderStats(x = mat, which = 1)
	ms_res_def_2 <- matrixStats::colOrderStats(x = mat, which = 1)
	expect_equal(mg_res_def_2, ms_res_def_2)

	mg_res_1 <- colOrderStats(x = mat, rows = NULL, cols = NULL, which = 2, dim. = dim(mat))
	ms_res_1 <- matrixStats::colOrderStats(x = mat, rows = NULL, cols = NULL, which = 2, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colOrderStats(x = mat, rows = 1:3, cols = c(2, 4), which = 1, dim. = dim(mat))
	ms_res_2 <- matrixStats::colOrderStats(x = mat, rows = 1:3, cols = c(2, 4), which = 1, dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colProds works ", {

	matrixStats_formals <- formals(matrixStats::colProds)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colProds)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colProds(x = mat)
	ms_res_def_1 <- matrixStats::colProds(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colProds(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, method = 'direct')
	ms_res_1 <- matrixStats::colProds(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, method = 'direct')
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colProds(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, method = 'expSumLog')
	ms_res_2 <- matrixStats::colProds(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, method = 'expSumLog')
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colQuantiles works ", {

	matrixStats_formals <- formals(matrixStats::colQuantiles)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colQuantiles)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colQuantiles(x = mat)
	ms_res_def_1 <- matrixStats::colQuantiles(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colQuantiles(x = mat, rows = NULL, cols = NULL, probs = seq(from = 0, to = 1, by = 0.25), na.rm = TRUE, type = 7, drop = TRUE)
	ms_res_1 <- matrixStats::colQuantiles(x = mat, rows = NULL, cols = NULL, probs = seq(from = 0, to = 1, by = 0.25), na.rm = TRUE, type = 7, drop = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colQuantiles(x = mat, rows = 1:3, cols = c(2, 4), probs = 0.1, na.rm = FALSE, type = 3, drop = FALSE)
	ms_res_2 <- matrixStats::colQuantiles(x = mat, rows = 1:3, cols = c(2, 4), probs = 0.1, na.rm = FALSE, type = 3, drop = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colRanges works ", {

	matrixStats_formals <- formals(matrixStats::colRanges)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colRanges)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colRanges(x = mat)
	ms_res_def_1 <- matrixStats::colRanges(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colRanges(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat))
	ms_res_1 <- matrixStats::colRanges(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colRanges(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, dim. = dim(mat))
	ms_res_2 <- matrixStats::colRanges(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colRanks works ", {

	matrixStats_formals <- formals(matrixStats::colRanks)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colRanks)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colRanks(x = mat)
	ms_res_def_1 <- matrixStats::colRanks(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colRanks(x = mat, rows = NULL, cols = NULL, ties.method = 'max', dim. = dim(mat), preserveShape = FALSE)
	ms_res_1 <- matrixStats::colRanks(x = mat, rows = NULL, cols = NULL, ties.method = 'max', dim. = dim(mat), preserveShape = FALSE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colRanks(x = mat, rows = 1:3, cols = c(2, 4), ties.method = 'first', dim. = dim(mat), preserveShape = TRUE)
	ms_res_2 <- matrixStats::colRanks(x = mat, rows = 1:3, cols = c(2, 4), ties.method = 'first', dim. = dim(mat), preserveShape = TRUE)
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- colRanks(x = mat, rows = NULL, cols = NULL, ties.method = 'dense', dim. = dim(mat), preserveShape = FALSE)
	ms_res_3 <- matrixStats::colRanks(x = mat, rows = NULL, cols = NULL, ties.method = 'dense', dim. = dim(mat), preserveShape = FALSE)
	expect_equal(mg_res_3, ms_res_3)
})


test_that("colSdDiffs works ", {

	matrixStats_formals <- formals(matrixStats::colSdDiffs)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colSdDiffs)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colSdDiffs(x = mat)
	ms_res_def_1 <- matrixStats::colSdDiffs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colSdDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0)
	ms_res_1 <- matrixStats::colSdDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colSdDiffs(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, diff = 2, trim = 0.333333333333333)
	ms_res_2 <- matrixStats::colSdDiffs(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, diff = 2, trim = 0.333333333333333)
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- colSdDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5)
	ms_res_3 <- matrixStats::colSdDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5)
	expect_equal(mg_res_3, ms_res_3)
})


test_that("colSds works ", {

	matrixStats_formals <- formals(matrixStats::colSds)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colSds)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colSds(x = mat)
	ms_res_def_1 <- matrixStats::colSds(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colSds(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, center = NULL, dim. = dim(mat))
	ms_res_1 <- matrixStats::colSds(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, center = NULL, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colSds(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, center = colMeans(mat[1:3, ]), dim. = dim(mat))
	ms_res_2 <- matrixStats::colSds(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, center = colMeans(mat[1:3, ]), dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colSums2 works ", {

	matrixStats_formals <- formals(matrixStats::colSums2)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colSums2)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colSums2(x = mat)
	ms_res_def_1 <- matrixStats::colSums2(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colSums2(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat))
	ms_res_1 <- matrixStats::colSums2(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colSums2(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, dim. = dim(mat))
	ms_res_2 <- matrixStats::colSums2(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colTabulates works ", {

	matrixStats_formals <- formals(matrixStats::colTabulates)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colTabulates)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mat <- array(suppressWarnings(as.integer(mat)), dim(mat))
	mg_res_def_1 <- colTabulates(x = mat)
	ms_res_def_1 <- matrixStats::colTabulates(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colTabulates(x = mat, rows = NULL, cols = NULL, values = 0)
	ms_res_1 <- matrixStats::colTabulates(x = mat, rows = NULL, cols = NULL, values = 0)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colTabulates(x = mat, rows = 1:3, cols = c(2, 4), values = c(0, 1))
	ms_res_2 <- matrixStats::colTabulates(x = mat, rows = 1:3, cols = c(2, 4), values = c(0, 1))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colVarDiffs works ", {

	matrixStats_formals <- formals(matrixStats::colVarDiffs)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colVarDiffs)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colVarDiffs(x = mat)
	ms_res_def_1 <- matrixStats::colVarDiffs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colVarDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0)
	ms_res_1 <- matrixStats::colVarDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colVarDiffs(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, diff = 2, trim = 0.333333333333333)
	ms_res_2 <- matrixStats::colVarDiffs(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, diff = 2, trim = 0.333333333333333)
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- colVarDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5)
	ms_res_3 <- matrixStats::colVarDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5)
	expect_equal(mg_res_3, ms_res_3)
})


test_that("colVars works ", {

	matrixStats_formals <- formals(matrixStats::colVars)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colVars)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colVars(x = mat)
	ms_res_def_1 <- matrixStats::colVars(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colVars(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, center = NULL, dim. = dim(mat))
	ms_res_1 <- matrixStats::colVars(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, center = NULL, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colVars(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, center = colMeans(mat[1:3, ]), dim. = dim(mat))
	ms_res_2 <- matrixStats::colVars(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, center = colMeans(mat[1:3, ]), dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colWeightedMads works ", {

	matrixStats_formals <- formals(matrixStats::colWeightedMads)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colWeightedMads)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colWeightedMads(x = mat)
	ms_res_def_1 <- matrixStats::colWeightedMads(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colWeightedMads(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE, constant = 1.4826, center = NULL)
	ms_res_1 <- matrixStats::colWeightedMads(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE, constant = 1.4826, center = NULL)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colWeightedMads(x = mat, w = NULL, rows = 1:3, cols = c(2, 4), na.rm = FALSE, constant = 5, center = rep(6, ncol(mat)))
	ms_res_2 <- matrixStats::colWeightedMads(x = mat, w = NULL, rows = 1:3, cols = c(2, 4), na.rm = FALSE, constant = 5, center = rep(6, ncol(mat)))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colWeightedMeans works ", {

	matrixStats_formals <- formals(matrixStats::colWeightedMeans)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colWeightedMeans)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colWeightedMeans(x = mat)
	ms_res_def_1 <- matrixStats::colWeightedMeans(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colWeightedMeans(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE)
	ms_res_1 <- matrixStats::colWeightedMeans(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colWeightedMeans(x = mat, w = NULL, rows = 1:3, cols = c(2, 4), na.rm = FALSE)
	ms_res_2 <- matrixStats::colWeightedMeans(x = mat, w = NULL, rows = 1:3, cols = c(2, 4), na.rm = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colWeightedMedians works ", {

	matrixStats_formals <- formals(matrixStats::colWeightedMedians)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colWeightedMedians)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colWeightedMedians(x = mat)
	ms_res_def_1 <- matrixStats::colWeightedMedians(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colWeightedMedians(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE)
	ms_res_1 <- matrixStats::colWeightedMedians(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colWeightedMedians(x = mat, w = NULL, rows = 1:3, cols = c(2, 4), na.rm = FALSE)
	ms_res_2 <- matrixStats::colWeightedMedians(x = mat, w = NULL, rows = 1:3, cols = c(2, 4), na.rm = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colWeightedSds works ", {

	matrixStats_formals <- formals(matrixStats::colWeightedSds)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colWeightedSds)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colWeightedSds(x = mat)
	ms_res_def_1 <- matrixStats::colWeightedSds(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colWeightedSds(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE)
	ms_res_1 <- matrixStats::colWeightedSds(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colWeightedSds(x = mat, w = NULL, rows = 1:3, cols = c(2, 4), na.rm = FALSE)
	ms_res_2 <- matrixStats::colWeightedSds(x = mat, w = NULL, rows = 1:3, cols = c(2, 4), na.rm = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("colWeightedVars works ", {

	matrixStats_formals <- formals(matrixStats::colWeightedVars)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_colWeightedVars)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- colWeightedVars(x = mat)
	ms_res_def_1 <- matrixStats::colWeightedVars(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- colWeightedVars(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE)
	ms_res_1 <- matrixStats::colWeightedVars(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- colWeightedVars(x = mat, w = NULL, rows = 1:3, cols = c(2, 4), na.rm = FALSE)
	ms_res_2 <- matrixStats::colWeightedVars(x = mat, w = NULL, rows = 1:3, cols = c(2, 4), na.rm = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowAlls works ", {

	matrixStats_formals <- formals(matrixStats::rowAlls)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowAlls)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- rowAlls(x = mat)
	ms_res_def_1 <- matrixStats::rowAlls(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowAlls(x = mat, rows = NULL, cols = NULL, value = TRUE, na.rm = TRUE, dim. = dim(mat))
	ms_res_1 <- matrixStats::rowAlls(x = mat, rows = NULL, cols = NULL, value = TRUE, na.rm = TRUE, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowAlls(x = mat, rows = 1:3, cols = c(2, 4), value = FALSE, na.rm = FALSE, dim. = dim(mat))
	ms_res_2 <- matrixStats::rowAlls(x = mat, rows = 1:3, cols = c(2, 4), value = FALSE, na.rm = FALSE, dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- rowAlls(x = mat, rows = NULL, cols = NULL, value = 0, na.rm = TRUE, dim. = dim(mat))
	ms_res_3 <- matrixStats::rowAlls(x = mat, rows = NULL, cols = NULL, value = 0, na.rm = TRUE, dim. = dim(mat))
	expect_equal(mg_res_3, ms_res_3)
})


test_that("rowAnyNAs works ", {

	matrixStats_formals <- formals(matrixStats::rowAnyNAs)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowAnyNAs)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- rowAnyNAs(x = mat)
	ms_res_def_1 <- matrixStats::rowAnyNAs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowAnyNAs(x = mat, rows = NULL, cols = NULL)
	ms_res_1 <- matrixStats::rowAnyNAs(x = mat, rows = NULL, cols = NULL)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowAnyNAs(x = mat, rows = 1:3, cols = c(2, 4))
	ms_res_2 <- matrixStats::rowAnyNAs(x = mat, rows = 1:3, cols = c(2, 4))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowAnys works ", {

	matrixStats_formals <- formals(matrixStats::rowAnys)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowAnys)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- rowAnys(x = mat)
	ms_res_def_1 <- matrixStats::rowAnys(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowAnys(x = mat, rows = NULL, cols = NULL, value = TRUE, na.rm = TRUE, dim. = dim(mat))
	ms_res_1 <- matrixStats::rowAnys(x = mat, rows = NULL, cols = NULL, value = TRUE, na.rm = TRUE, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowAnys(x = mat, rows = 1:3, cols = c(2, 4), value = FALSE, na.rm = FALSE, dim. = dim(mat))
	ms_res_2 <- matrixStats::rowAnys(x = mat, rows = 1:3, cols = c(2, 4), value = FALSE, na.rm = FALSE, dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- rowAnys(x = mat, rows = NULL, cols = NULL, value = 0, na.rm = TRUE, dim. = dim(mat))
	ms_res_3 <- matrixStats::rowAnys(x = mat, rows = NULL, cols = NULL, value = 0, na.rm = TRUE, dim. = dim(mat))
	expect_equal(mg_res_3, ms_res_3)
})


test_that("rowAvgsPerColSet works ", {

	matrixStats_formals <- formals(matrixStats::rowAvgsPerColSet)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowAvgsPerColSet)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	S <- matrix(1:ncol(mat), ncol = 2)
	mg_res_def_1 <- rowAvgsPerColSet(X = mat, S = S, FUN = rowMeans)
	ms_res_def_1 <- matrixStats::rowAvgsPerColSet(X = mat, S = S, FUN = rowMeans)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_def_2 <- rowAvgsPerColSet(X = mat, S = S, FUN = rowVars)
	ms_res_def_2 <- matrixStats::rowAvgsPerColSet(X = mat, S = S, FUN = rowVars)
	expect_equal(mg_res_def_2, ms_res_def_2)

	mg_res_1 <- rowAvgsPerColSet(X = mat, W = NULL, rows = NULL, S = S, FUN = rowMeans, na.rm = TRUE, tFUN = FALSE)
	ms_res_1 <- matrixStats::rowAvgsPerColSet(X = mat, W = NULL, rows = NULL, S = S, FUN = rowMeans, na.rm = TRUE, tFUN = FALSE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowAvgsPerColSet(X = mat, W = NULL, rows = 1:3, S = S, FUN = rowVars, na.rm = FALSE, tFUN = FALSE)
	ms_res_2 <- matrixStats::rowAvgsPerColSet(X = mat, W = NULL, rows = 1:3, S = S, FUN = rowVars, na.rm = FALSE, tFUN = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowCollapse works ", {

	matrixStats_formals <- formals(matrixStats::rowCollapse)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowCollapse)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- rowCollapse(x = mat, idxs = 1)
	ms_res_def_1 <- matrixStats::rowCollapse(x = mat, idxs = 1)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_def_2 <- rowCollapse(x = mat, idxs = 2:3)
	ms_res_def_2 <- matrixStats::rowCollapse(x = mat, idxs = 2:3)
	expect_equal(mg_res_def_2, ms_res_def_2)

	mg_res_1 <- rowCollapse(x = mat, idxs = 1, rows = NULL, dim. = dim(mat))
	ms_res_1 <- matrixStats::rowCollapse(x = mat, idxs = 1, rows = NULL, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowCollapse(x = mat, idxs = 2:3, rows = 1:3, dim. = dim(mat))
	ms_res_2 <- matrixStats::rowCollapse(x = mat, idxs = 2:3, rows = 1:3, dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowCounts works ", {

	matrixStats_formals <- formals(matrixStats::rowCounts)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowCounts)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- rowCounts(x = mat)
	ms_res_def_1 <- matrixStats::rowCounts(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowCounts(x = mat, rows = NULL, cols = NULL, value = TRUE, na.rm = TRUE, dim. = dim(mat))
	ms_res_1 <- matrixStats::rowCounts(x = mat, rows = NULL, cols = NULL, value = TRUE, na.rm = TRUE, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowCounts(x = mat, rows = 1:3, cols = c(2, 4), value = FALSE, na.rm = FALSE, dim. = dim(mat))
	ms_res_2 <- matrixStats::rowCounts(x = mat, rows = 1:3, cols = c(2, 4), value = FALSE, na.rm = FALSE, dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- rowCounts(x = mat, rows = NULL, cols = NULL, value = 0, na.rm = TRUE, dim. = dim(mat))
	ms_res_3 <- matrixStats::rowCounts(x = mat, rows = NULL, cols = NULL, value = 0, na.rm = TRUE, dim. = dim(mat))
	expect_equal(mg_res_3, ms_res_3)
})


test_that("rowCummaxs works ", {

	matrixStats_formals <- formals(matrixStats::rowCummaxs)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowCummaxs)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- rowCummaxs(x = mat)
	ms_res_def_1 <- matrixStats::rowCummaxs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowCummaxs(x = mat, rows = NULL, cols = NULL, dim. = dim(mat))
	ms_res_1 <- matrixStats::rowCummaxs(x = mat, rows = NULL, cols = NULL, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowCummaxs(x = mat, rows = 1:3, cols = c(2, 4), dim. = dim(mat))
	ms_res_2 <- matrixStats::rowCummaxs(x = mat, rows = 1:3, cols = c(2, 4), dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowCummins works ", {

	matrixStats_formals <- formals(matrixStats::rowCummins)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowCummins)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- rowCummins(x = mat)
	ms_res_def_1 <- matrixStats::rowCummins(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowCummins(x = mat, rows = NULL, cols = NULL, dim. = dim(mat))
	ms_res_1 <- matrixStats::rowCummins(x = mat, rows = NULL, cols = NULL, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowCummins(x = mat, rows = 1:3, cols = c(2, 4), dim. = dim(mat))
	ms_res_2 <- matrixStats::rowCummins(x = mat, rows = 1:3, cols = c(2, 4), dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowCumprods works ", {

	matrixStats_formals <- formals(matrixStats::rowCumprods)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowCumprods)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- rowCumprods(x = mat)
	ms_res_def_1 <- matrixStats::rowCumprods(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowCumprods(x = mat, rows = NULL, cols = NULL, dim. = dim(mat))
	ms_res_1 <- matrixStats::rowCumprods(x = mat, rows = NULL, cols = NULL, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowCumprods(x = mat, rows = 1:3, cols = c(2, 4), dim. = dim(mat))
	ms_res_2 <- matrixStats::rowCumprods(x = mat, rows = 1:3, cols = c(2, 4), dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowCumsums works ", {

	matrixStats_formals <- formals(matrixStats::rowCumsums)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowCumsums)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- rowCumsums(x = mat)
	ms_res_def_1 <- matrixStats::rowCumsums(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowCumsums(x = mat, rows = NULL, cols = NULL, dim. = dim(mat))
	ms_res_1 <- matrixStats::rowCumsums(x = mat, rows = NULL, cols = NULL, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowCumsums(x = mat, rows = 1:3, cols = c(2, 4), dim. = dim(mat))
	ms_res_2 <- matrixStats::rowCumsums(x = mat, rows = 1:3, cols = c(2, 4), dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowDiffs works ", {

	matrixStats_formals <- formals(matrixStats::rowDiffs)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowDiffs)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- rowDiffs(x = mat)
	ms_res_def_1 <- matrixStats::rowDiffs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowDiffs(x = mat, rows = NULL, cols = NULL, lag = 1, differences = 1, dim. = dim(mat))
	ms_res_1 <- matrixStats::rowDiffs(x = mat, rows = NULL, cols = NULL, lag = 1, differences = 1, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowDiffs(x = mat, rows = 1:3, cols = c(2, 4), lag = 3, differences = 2, dim. = dim(mat))
	ms_res_2 <- matrixStats::rowDiffs(x = mat, rows = 1:3, cols = c(2, 4), lag = 3, differences = 2, dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowIQRDiffs works ", {

	matrixStats_formals <- formals(matrixStats::rowIQRDiffs)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowIQRDiffs)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- rowIQRDiffs(x = mat)
	ms_res_def_1 <- matrixStats::rowIQRDiffs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowIQRDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0)
	ms_res_1 <- matrixStats::rowIQRDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowIQRDiffs(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, diff = 2, trim = 0.333333333333333)
	ms_res_2 <- matrixStats::rowIQRDiffs(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, diff = 2, trim = 0.333333333333333)
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- rowIQRDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5)
	ms_res_3 <- matrixStats::rowIQRDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5)
	expect_equal(mg_res_3, ms_res_3)
})


test_that("rowIQRs works ", {

	matrixStats_formals <- formals(matrixStats::rowIQRs)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowIQRs)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- rowIQRs(x = mat)
	ms_res_def_1 <- matrixStats::rowIQRs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowIQRs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE)
	ms_res_1 <- matrixStats::rowIQRs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowIQRs(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE)
	ms_res_2 <- matrixStats::rowIQRs(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowLogSumExps works ", {

	matrixStats_formals <- formals(matrixStats::rowLogSumExps)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowLogSumExps)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- rowLogSumExps(lx = mat)
	ms_res_def_1 <- matrixStats::rowLogSumExps(lx = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowLogSumExps(lx = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat))
	ms_res_1 <- matrixStats::rowLogSumExps(lx = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowLogSumExps(lx = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, dim. = dim(mat))
	ms_res_2 <- matrixStats::rowLogSumExps(lx = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowMadDiffs works ", {

	matrixStats_formals <- formals(matrixStats::rowMadDiffs)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowMadDiffs)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- rowMadDiffs(x = mat)
	ms_res_def_1 <- matrixStats::rowMadDiffs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowMadDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0)
	ms_res_1 <- matrixStats::rowMadDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowMadDiffs(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, diff = 2, trim = 0.333333333333333)
	ms_res_2 <- matrixStats::rowMadDiffs(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, diff = 2, trim = 0.333333333333333)
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- rowMadDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5)
	ms_res_3 <- matrixStats::rowMadDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5)
	expect_equal(mg_res_3, ms_res_3)
})


test_that("rowMads works ", {

	matrixStats_formals <- formals(matrixStats::rowMads)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowMads)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- rowMads(x = mat)
	ms_res_def_1 <- matrixStats::rowMads(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowMads(x = mat, rows = NULL, cols = NULL, center = NULL, constant = 1.4826, na.rm = TRUE, dim. = dim(mat))
	ms_res_1 <- matrixStats::rowMads(x = mat, rows = NULL, cols = NULL, center = NULL, constant = 1.4826, na.rm = TRUE, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowMads(x = mat, rows = 1:3, cols = c(2, 4), center = rowMeans(mat[, 2, drop = FALSE]), constant = 5, na.rm = FALSE, dim. = dim(mat))
	ms_res_2 <- matrixStats::rowMads(x = mat, rows = 1:3, cols = c(2, 4), center = rowMeans(mat[, 2, drop = FALSE]), constant = 5, na.rm = FALSE, dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowMaxs works ", {

	matrixStats_formals <- formals(matrixStats::rowMaxs)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowMaxs)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- rowMaxs(x = mat)
	ms_res_def_1 <- matrixStats::rowMaxs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowMaxs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat))
	ms_res_1 <- matrixStats::rowMaxs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowMaxs(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, dim. = dim(mat))
	ms_res_2 <- matrixStats::rowMaxs(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowMeans2 works ", {

	matrixStats_formals <- formals(matrixStats::rowMeans2)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowMeans2)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- rowMeans2(x = mat)
	ms_res_def_1 <- matrixStats::rowMeans2(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowMeans2(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat))
	ms_res_1 <- matrixStats::rowMeans2(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowMeans2(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, dim. = dim(mat))
	ms_res_2 <- matrixStats::rowMeans2(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowMedians works ", {

	matrixStats_formals <- formals(matrixStats::rowMedians)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowMedians)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- rowMedians(x = mat)
	ms_res_def_1 <- matrixStats::rowMedians(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowMedians(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat))
	ms_res_1 <- matrixStats::rowMedians(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowMedians(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, dim. = dim(mat))
	ms_res_2 <- matrixStats::rowMedians(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowMins works ", {

	matrixStats_formals <- formals(matrixStats::rowMins)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowMins)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- rowMins(x = mat)
	ms_res_def_1 <- matrixStats::rowMins(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowMins(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat))
	ms_res_1 <- matrixStats::rowMins(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowMins(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, dim. = dim(mat))
	ms_res_2 <- matrixStats::rowMins(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowOrderStats works ", {

	matrixStats_formals <- formals(matrixStats::rowOrderStats)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowOrderStats)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mat[is.na(mat)] <- 4.1
	mg_res_def_1 <- rowOrderStats(x = mat, which = 2)
	ms_res_def_1 <- matrixStats::rowOrderStats(x = mat, which = 2)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_def_2 <- rowOrderStats(x = mat, which = 1)
	ms_res_def_2 <- matrixStats::rowOrderStats(x = mat, which = 1)
	expect_equal(mg_res_def_2, ms_res_def_2)

	mg_res_1 <- rowOrderStats(x = mat, rows = NULL, cols = NULL, which = 2, dim. = dim(mat))
	ms_res_1 <- matrixStats::rowOrderStats(x = mat, rows = NULL, cols = NULL, which = 2, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowOrderStats(x = mat, rows = 1:3, cols = c(2, 4), which = 1, dim. = dim(mat))
	ms_res_2 <- matrixStats::rowOrderStats(x = mat, rows = 1:3, cols = c(2, 4), which = 1, dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowProds works ", {

	matrixStats_formals <- formals(matrixStats::rowProds)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowProds)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- rowProds(x = mat)
	ms_res_def_1 <- matrixStats::rowProds(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowProds(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, method = 'direct')
	ms_res_1 <- matrixStats::rowProds(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, method = 'direct')
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowProds(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, method = 'expSumLog')
	ms_res_2 <- matrixStats::rowProds(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, method = 'expSumLog')
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowQuantiles works ", {

	matrixStats_formals <- formals(matrixStats::rowQuantiles)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowQuantiles)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- rowQuantiles(x = mat)
	ms_res_def_1 <- matrixStats::rowQuantiles(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowQuantiles(x = mat, rows = NULL, cols = NULL, probs = seq(from = 0, to = 1, by = 0.25), na.rm = TRUE, type = 7, drop = TRUE)
	ms_res_1 <- matrixStats::rowQuantiles(x = mat, rows = NULL, cols = NULL, probs = seq(from = 0, to = 1, by = 0.25), na.rm = TRUE, type = 7, drop = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowQuantiles(x = mat, rows = 1:3, cols = c(2, 4), probs = 0.1, na.rm = FALSE, type = 3, drop = FALSE)
	ms_res_2 <- matrixStats::rowQuantiles(x = mat, rows = 1:3, cols = c(2, 4), probs = 0.1, na.rm = FALSE, type = 3, drop = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowRanges works ", {

	matrixStats_formals <- formals(matrixStats::rowRanges)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowRanges)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- rowRanges(x = mat)
	ms_res_def_1 <- matrixStats::rowRanges(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowRanges(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat))
	ms_res_1 <- matrixStats::rowRanges(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowRanges(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, dim. = dim(mat))
	ms_res_2 <- matrixStats::rowRanges(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowRanks works ", {

	matrixStats_formals <- formals(matrixStats::rowRanks)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowRanks)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- rowRanks(x = mat)
	ms_res_def_1 <- matrixStats::rowRanks(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowRanks(x = mat, rows = NULL, cols = NULL, ties.method = 'max', dim. = dim(mat))
	ms_res_1 <- matrixStats::rowRanks(x = mat, rows = NULL, cols = NULL, ties.method = 'max', dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowRanks(x = mat, rows = 1:3, cols = c(2, 4), ties.method = 'first', dim. = dim(mat))
	ms_res_2 <- matrixStats::rowRanks(x = mat, rows = 1:3, cols = c(2, 4), ties.method = 'first', dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- rowRanks(x = mat, rows = NULL, cols = NULL, ties.method = 'dense', dim. = dim(mat))
	ms_res_3 <- matrixStats::rowRanks(x = mat, rows = NULL, cols = NULL, ties.method = 'dense', dim. = dim(mat))
	expect_equal(mg_res_3, ms_res_3)
})


test_that("rowSdDiffs works ", {

	matrixStats_formals <- formals(matrixStats::rowSdDiffs)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowSdDiffs)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- rowSdDiffs(x = mat)
	ms_res_def_1 <- matrixStats::rowSdDiffs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowSdDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0)
	ms_res_1 <- matrixStats::rowSdDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowSdDiffs(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, diff = 2, trim = 0.333333333333333)
	ms_res_2 <- matrixStats::rowSdDiffs(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, diff = 2, trim = 0.333333333333333)
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- rowSdDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5)
	ms_res_3 <- matrixStats::rowSdDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5)
	expect_equal(mg_res_3, ms_res_3)
})


test_that("rowSds works ", {

	matrixStats_formals <- formals(matrixStats::rowSds)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowSds)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- rowSds(x = mat)
	ms_res_def_1 <- matrixStats::rowSds(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowSds(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, center = NULL, dim. = dim(mat))
	ms_res_1 <- matrixStats::rowSds(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, center = NULL, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowSds(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, center = rowMeans(mat[, 2, drop = FALSE]), dim. = dim(mat))
	ms_res_2 <- matrixStats::rowSds(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, center = rowMeans(mat[, 2, drop = FALSE]), dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowSums2 works ", {

	matrixStats_formals <- formals(matrixStats::rowSums2)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowSums2)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- rowSums2(x = mat)
	ms_res_def_1 <- matrixStats::rowSums2(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowSums2(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat))
	ms_res_1 <- matrixStats::rowSums2(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowSums2(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, dim. = dim(mat))
	ms_res_2 <- matrixStats::rowSums2(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowTabulates works ", {

	matrixStats_formals <- formals(matrixStats::rowTabulates)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowTabulates)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mat <- array(suppressWarnings(as.integer(mat)), dim(mat))
	mg_res_def_1 <- rowTabulates(x = mat)
	ms_res_def_1 <- matrixStats::rowTabulates(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowTabulates(x = mat, rows = NULL, cols = NULL, values = 0)
	ms_res_1 <- matrixStats::rowTabulates(x = mat, rows = NULL, cols = NULL, values = 0)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowTabulates(x = mat, rows = 1:3, cols = c(2, 4), values = c(0, 1))
	ms_res_2 <- matrixStats::rowTabulates(x = mat, rows = 1:3, cols = c(2, 4), values = c(0, 1))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowVarDiffs works ", {

	matrixStats_formals <- formals(matrixStats::rowVarDiffs)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowVarDiffs)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- rowVarDiffs(x = mat)
	ms_res_def_1 <- matrixStats::rowVarDiffs(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowVarDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0)
	ms_res_1 <- matrixStats::rowVarDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowVarDiffs(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, diff = 2, trim = 0.333333333333333)
	ms_res_2 <- matrixStats::rowVarDiffs(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, diff = 2, trim = 0.333333333333333)
	expect_equal(mg_res_2, ms_res_2)

	mg_res_3 <- rowVarDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5)
	ms_res_3 <- matrixStats::rowVarDiffs(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, diff = 1, trim = 0.5)
	expect_equal(mg_res_3, ms_res_3)
})


test_that("rowVars works ", {

	matrixStats_formals <- formals(matrixStats::rowVars)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowVars)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mg_res_def_1 <- rowVars(x = mat)
	ms_res_def_1 <- matrixStats::rowVars(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowVars(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, center = NULL, dim. = dim(mat))
	ms_res_1 <- matrixStats::rowVars(x = mat, rows = NULL, cols = NULL, na.rm = TRUE, center = NULL, dim. = dim(mat))
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowVars(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, center = rowMeans(mat[, 2, drop = FALSE]), dim. = dim(mat))
	ms_res_2 <- matrixStats::rowVars(x = mat, rows = 1:3, cols = c(2, 4), na.rm = FALSE, center = rowMeans(mat[, 2, drop = FALSE]), dim. = dim(mat))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowWeightedMads works ", {

	matrixStats_formals <- formals(matrixStats::rowWeightedMads)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowWeightedMads)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mat <- array(mat, dim(t(mat)))
	mg_res_def_1 <- rowWeightedMads(x = mat)
	ms_res_def_1 <- matrixStats::rowWeightedMads(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowWeightedMads(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE, constant = 1.4826, center = NULL)
	ms_res_1 <- matrixStats::rowWeightedMads(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE, constant = 1.4826, center = NULL)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowWeightedMads(x = mat, w = NULL, rows = 1:3, cols = c(2, 4), na.rm = FALSE, constant = 5, center = rep(6, nrow(mat)))
	ms_res_2 <- matrixStats::rowWeightedMads(x = mat, w = NULL, rows = 1:3, cols = c(2, 4), na.rm = FALSE, constant = 5, center = rep(6, nrow(mat)))
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowWeightedMeans works ", {

	matrixStats_formals <- formals(matrixStats::rowWeightedMeans)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowWeightedMeans)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mat <- array(mat, dim(t(mat)))
	mg_res_def_1 <- rowWeightedMeans(x = mat)
	ms_res_def_1 <- matrixStats::rowWeightedMeans(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowWeightedMeans(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE)
	ms_res_1 <- matrixStats::rowWeightedMeans(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowWeightedMeans(x = mat, w = NULL, rows = 1:3, cols = c(2, 4), na.rm = FALSE)
	ms_res_2 <- matrixStats::rowWeightedMeans(x = mat, w = NULL, rows = 1:3, cols = c(2, 4), na.rm = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowWeightedMedians works ", {

	matrixStats_formals <- formals(matrixStats::rowWeightedMedians)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowWeightedMedians)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mat <- array(mat, dim(t(mat)))
	mg_res_def_1 <- rowWeightedMedians(x = mat)
	ms_res_def_1 <- matrixStats::rowWeightedMedians(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowWeightedMedians(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE)
	ms_res_1 <- matrixStats::rowWeightedMedians(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowWeightedMedians(x = mat, w = NULL, rows = 1:3, cols = c(2, 4), na.rm = FALSE)
	ms_res_2 <- matrixStats::rowWeightedMedians(x = mat, w = NULL, rows = 1:3, cols = c(2, 4), na.rm = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowWeightedSds works ", {

	matrixStats_formals <- formals(matrixStats::rowWeightedSds)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowWeightedSds)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mat <- array(mat, dim(t(mat)))
	mg_res_def_1 <- rowWeightedSds(x = mat)
	ms_res_def_1 <- matrixStats::rowWeightedSds(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowWeightedSds(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE)
	ms_res_1 <- matrixStats::rowWeightedSds(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowWeightedSds(x = mat, w = NULL, rows = 1:3, cols = c(2, 4), na.rm = FALSE)
	ms_res_2 <- matrixStats::rowWeightedSds(x = mat, w = NULL, rows = 1:3, cols = c(2, 4), na.rm = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})


test_that("rowWeightedVars works ", {

	matrixStats_formals <- formals(matrixStats::rowWeightedVars)
	MatrixGenerics_default_method_formals <- formals(MatrixGenerics:::.matrixStats_rowWeightedVars)
	expect_identical(matrixStats_formals, MatrixGenerics_default_method_formals)

	mat <- array(mat, dim(t(mat)))
	mg_res_def_1 <- rowWeightedVars(x = mat)
	ms_res_def_1 <- matrixStats::rowWeightedVars(x = mat)
	expect_equal(mg_res_def_1, ms_res_def_1)

	mg_res_1 <- rowWeightedVars(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE)
	ms_res_1 <- matrixStats::rowWeightedVars(x = mat, w = 1:16, rows = NULL, cols = NULL, na.rm = TRUE)
	expect_equal(mg_res_1, ms_res_1)

	mg_res_2 <- rowWeightedVars(x = mat, w = NULL, rows = 1:3, cols = c(2, 4), na.rm = FALSE)
	ms_res_2 <- matrixStats::rowWeightedVars(x = mat, w = NULL, rows = 1:3, cols = c(2, 4), na.rm = FALSE)
	expect_equal(mg_res_2, ms_res_2)
})
