// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_RENDERER_HOST_COOKIE_UTILS_H_
#define CONTENT_BROWSER_RENDERER_HOST_COOKIE_UTILS_H_

#include "services/network/public/mojom/cookie_access_observer.mojom.h"

namespace content {

class RenderFrameHostImpl;
struct CookieAccessDetails;

// Sorts cookies into allowed (cookies that were included for the access
// attempt) and blocked (cookies that were excluded solely because they were
// blocked by the user's preferences). Cookies that are excluded independently
// of the user's cookie blocking settings are not included in either of the
// outputs.
void SplitCookiesIntoAllowedAndBlocked(
    const network::mojom::CookieAccessDetailsPtr& cookie_details,
    CookieAccessDetails* allowed,
    CookieAccessDetails* blocked);

// Logs SameSite cookie warnings to DevTools Issues Panel and logs event to
// UseCounters and UKM. Does not log to the JS console.
// TODO(crbug.com/977040): Remove when no longer needed.
void EmitSameSiteCookiesDeprecationWarning(
    RenderFrameHostImpl* rfh,
    const network::mojom::CookieAccessDetailsPtr& cookie_details);

}  // namespace content

#endif  // CONTENT_BROWSER_RENDERER_HOST_COOKIE_UTILS_H_
