# Chrome common word list

Chrome's common words list is derived from Peter Norvig's `count_1w.txt`
dataset, itself derived from Google's Web Trillion Word Corpus. See
https://norvig.com/ngrams/.

## `common_words.list`
This file contains a list of 10k most common English words, all of which are at
least 3 characters long, and containing no brands from the current top domain
list.

The file can be generated by running `generate_common_words.sh`.

## `brands_in_common_words_regex.list`
This file contains a list of `^BRAND$` patterns, where each `BRAND` was
identified by manually looking through overlaps between this list with the e2LDs
in `top_domains.list`.

The initial list of overlaps was generated with:
```
$ cut -f1 -d. top_domains.list | sort > top_domains_sorted.list
$ awk 'length($1) > 2 {print $1}' count_1w.txt \
  | head -n 10000 | sort | comm -12 - top_domains_sorted.list > overlap.list
```

I then manually filtered `overlap.list`, removing anything that wasn't
indisputably a brand and not also a valid English word (i.e. excluding any words
where there were common non-brand meanings as in "apple").

This approach isn't perfect -- the common words list still contains lots of
brands, but at least it doesn't contain brands that are in the current top
domain list. The final list also contains `|brands_in_common_words_regex.list|`
extra unfiltered words. I spot-checked the final entries of the list to ensure
no brands snuck in.

**This list should be regenerated whenever the top domains list is updated.**
