
from cron_descriptor.ExpressionValidator import ExpressionValidator

"""
Tests validator
"""

valid = [
    "57,59 * * 1 * 1",
    "1,2,3-15 * * 1 * 1",
    "1-2,2,3-15 * * 1 * 1",
    "* 1,59 * 1 * 1",
    "* 1,2,3-15 * 1 * 1",
    "* 1-2,2,3-15 * 1 * 1",
    "* * 1 ? * *",
    "* 1-12 ? * *",
    "* 1/12 ? * *",
    "* 1-5/12 ? * *",
    "* 1,23 ? * *",
    "* 1,2,7-23 ? * *",
    "* 1-2,2,7-23 ? * *",
    "* * ? * *",
    "* * 1 * *",
    "* * 31 * *",
    "* * 1-2/31 * *",
    "* * 1,20 * *",
    "* * LW * *",
    "* * 1W * *",
    "* * 31W * *",
    "* * ? 1 *",
    "* * ? 12 *",
    "* * ? JAN *",
    "* * ? 1-12 *",
    "* * ? JAN-DEC *",
    "* * ? 1/12 *",
    "* * ? 1-5/12 *",
    "* * ? 1,2,3 *",
    "* * ? 1,Feb,3 *",
    "* * ? 1,5,6-12 *",
    "* * ? 1-2,5,6-12 *",
    "* * ? JAN-FEB,5,6-12 *",
    "* * ? * 0",
    "* * ? * 6",
    "* * ? * SUN",
    "* * ? * 0/6",
    "* * ? * 0-1/6",
    "* * ? * 0-1",
    "* * ? * MON-wed",
    "* * ? * MON-wed,sun,4",
    "* * ? * MON,3",
    "* * ? * 2L",
    "* * ? * 6L",
    "* * ? * 0#3",
    "* * ? * * 1970",
    "* * ? * * 2099",
    "* * ? * * 1970-2099",
    "* * ? * * 1970/129",
    "* * * ? * * 1970-2001/129",
    "* * * ? * * 1970,1971,2099",
    "* * * ? * * 1970-1971,1972,2000-2002",
    "* * * * * 2013",
]

invalid = [

    "0-59 * * 1 * 1",     # invalid DOW range
    "1-2/59 * * 1 * 1",   # invalid step
    "* * /31 * *",        # stray slash
    "* * l-31 * *",       # lowercase 'l'
    "* * lw * *",         # lowercase 'lw'
    "* * ? * /6",         # stray slash
    "* * ? * * /129",     # stray slash
    "* /12 ? * *",        # stray slash
    "* * W21 * * 0/2",    # W before number
]

def test_validator_expression() -> None:
    for expression in valid:
        ExpressionValidator().validate(expression)

