/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.EventSetDescriptor;
import java.beans.beancontext.BeanContext;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.converters.ArffLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.DatabaseLoader;
import weka.core.converters.FileSourcedConverter;
import weka.core.converters.IncrementalConverter;
import weka.gui.Logger;
import weka.gui.beans.AbstractDataSource;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSource;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.InstanceListener;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.Messages;
import weka.gui.beans.Startable;
import weka.gui.beans.StructureProducer;
import weka.gui.beans.Visible;
import weka.gui.beans.WekaWrapper;

public class Loader
extends AbstractDataSource
implements Startable,
WekaWrapper,
EventConstraints,
BeanCommon,
EnvironmentHandler,
StructureProducer {
    private static final long serialVersionUID = 1993738191961163027L;
    private transient Instances m_dataSet;
    private transient Instances m_dataFormat;
    protected String m_globalInfo;
    private LoadThread m_ioThread;
    private static int IDLE = 0;
    private static int BATCH_LOADING = 1;
    private static int INCREMENTAL_LOADING = 2;
    private int m_state = IDLE;
    private weka.core.converters.Loader m_Loader = new ArffLoader();
    private InstanceEvent m_ie = new InstanceEvent(this);
    private int m_instanceEventTargets = 0;
    private int m_dataSetEventTargets = 0;
    private boolean m_dbSet = false;
    protected transient Logger m_log;
    protected transient Environment m_env;
    protected boolean m_stopped = false;

    public String globalInfo() {
        return this.m_globalInfo;
    }

    public Loader() {
        this.setLoader(this.m_Loader);
        this.appearanceFinal();
    }

    public void setDB(boolean flag) {
        this.m_dbSet = flag;
    }

    protected void appearanceFinal() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        Messages.getInstance();
        JButton goButton = new JButton(Messages.getString("Loader_AppearanceFinal_GoButton_JButton_Text"));
        this.add((Component)goButton, "Center");
        goButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Loader.this.startLoading();
            }
        });
    }

    protected void appearanceDesign() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    public void setBeanContext(BeanContext bc) {
        super.setBeanContext(bc);
        if (this.m_design) {
            this.appearanceDesign();
        } else {
            this.appearanceFinal();
        }
    }

    public void setLoader(weka.core.converters.Loader loader) {
        boolean loadImages = true;
        if (loader.getClass().getName().compareTo(this.m_Loader.getClass().getName()) == 0) {
            loadImages = false;
        }
        this.m_Loader = loader;
        String loaderName = loader.getClass().toString();
        loaderName = loaderName.substring(loaderName.lastIndexOf(46) + 1, loaderName.length());
        if (loadImages) {
            if (this.m_Loader instanceof Visible) {
                this.m_visual = ((Visible)((Object)this.m_Loader)).getVisual();
            } else if (!this.m_visual.loadIcons("weka/gui/beans/icons/" + loaderName + ".gif", "weka/gui/beans/icons/" + loaderName + "_animated.gif")) {
                this.useDefaultVisual();
            }
        }
        this.m_visual.setText(loaderName);
        this.m_globalInfo = KnowledgeFlowApp.getGlobalInfo(this.m_Loader);
    }

    protected void newFileSelected() throws Exception {
        if (!(this.m_Loader instanceof DatabaseLoader)) {
            this.newStructure();
        }
    }

    protected void newStructure() throws Exception {
        if (this.m_Loader instanceof EnvironmentHandler && this.m_env != null) {
            try {
                ((EnvironmentHandler)((Object)this.m_Loader)).setEnvironment(this.m_env);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_dataFormat = this.m_Loader.getStructure();
    }

    public Instances getStructure(String eventName) {
        if (!eventName.equals("dataSet") && !eventName.equals("instance")) {
            return null;
        }
        if (this.m_dataSetEventTargets > 0 && !eventName.equals("dataSet")) {
            return null;
        }
        if (this.m_dataSetEventTargets == 0 && !eventName.equals("instance")) {
            return null;
        }
        try {
            this.newStructure();
        }
        catch (Exception ex) {
            System.err.println("[KnowledgeFlow/Loader] Warning: " + ex.getMessage());
            this.m_dataFormat = null;
        }
        return this.m_dataFormat;
    }

    public weka.core.converters.Loader getLoader() {
        return this.m_Loader;
    }

    public void setWrappedAlgorithm(Object algorithm) {
        if (!(algorithm instanceof weka.core.converters.Loader)) {
            StringBuilder stringBuilder = new StringBuilder().append(algorithm.getClass());
            Messages.getInstance();
            throw new IllegalArgumentException(stringBuilder.append(Messages.getString("Loader_SetWrappedAlgorithm_IllegalArgumentException_Text")).toString());
        }
        this.setLoader((weka.core.converters.Loader)algorithm);
    }

    public Object getWrappedAlgorithm() {
        return this.getLoader();
    }

    protected void notifyStructureAvailable(Instances structure) {
        if (this.m_dataSetEventTargets > 0 && structure != null) {
            DataSetEvent dse = new DataSetEvent(this, structure);
            this.notifyDataSetLoaded(dse);
        } else if (this.m_instanceEventTargets > 0 && structure != null) {
            this.m_ie.setStructure(structure);
            this.notifyInstanceLoaded(this.m_ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyDataSetLoaded(DataSetEvent e) {
        Vector l;
        Loader loader = this;
        synchronized (loader) {
            l = (Vector)this.m_listeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((DataSourceListener)l.elementAt(i)).acceptDataSet(e);
            }
            this.m_dataSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyInstanceLoaded(InstanceEvent e) {
        Vector l;
        Loader loader = this;
        synchronized (loader) {
            l = (Vector)this.m_listeners.clone();
        }
        if (l.size() > 0) {
            for (int i = 0; i < l.size(); ++i) {
                ((InstanceListener)l.elementAt(i)).acceptInstance(e);
            }
            this.m_dataSet = null;
        }
    }

    public void startLoading() {
        if (this.m_ioThread == null) {
            this.m_state = BATCH_LOADING;
            this.m_ioThread = new LoadThread(this);
            this.m_ioThread.setPriority(1);
            this.m_ioThread.start();
        } else {
            this.m_ioThread = null;
            this.m_state = IDLE;
        }
    }

    public void start() throws Exception {
        this.startLoading();
        this.block(true);
    }

    public String getStartMessage() {
        boolean ok = true;
        Messages.getInstance();
        String entry = Messages.getString("Loader_GetStartMessage_Entry_Text");
        if (this.m_ioThread == null) {
            if (this.m_Loader instanceof FileSourcedConverter) {
                String temp = ((FileSourcedConverter)((Object)this.m_Loader)).retrieveFile().getPath();
                Environment env = this.m_env == null ? Environment.getSystemWide() : this.m_env;
                try {
                    temp = env.substitute(temp);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                File tempF = new File(temp);
                if (!tempF.isFile()) {
                    ok = false;
                }
            }
            if (!ok) {
                entry = "$" + entry;
            }
        }
        return entry;
    }

    private synchronized void block(boolean tf) {
        if (tf) {
            try {
                if (this.m_ioThread.isAlive() && this.m_state != IDLE) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    public boolean eventGeneratable(String eventName) {
        if (eventName.compareTo("instance") == 0) {
            if (!(this.m_Loader instanceof IncrementalConverter)) {
                return false;
            }
            if (this.m_dataSetEventTargets > 0) {
                return false;
            }
        }
        if (eventName.compareTo("dataSet") == 0) {
            if (!(this.m_Loader instanceof BatchConverter)) {
                return false;
            }
            if (this.m_instanceEventTargets > 0) {
                return false;
            }
        }
        return true;
    }

    public synchronized void addDataSourceListener(DataSourceListener dsl) {
        super.addDataSourceListener(dsl);
        ++this.m_dataSetEventTargets;
        try {
            if (this.m_Loader instanceof DatabaseLoader && this.m_dbSet && this.m_dataFormat == null || !(this.m_Loader instanceof DatabaseLoader) && this.m_dataFormat == null) {
                this.m_dataFormat = this.m_Loader.getStructure();
                this.m_dbSet = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.notifyStructureAvailable(this.m_dataFormat);
    }

    public synchronized void removeDataSourceListener(DataSourceListener dsl) {
        super.removeDataSourceListener(dsl);
        --this.m_dataSetEventTargets;
    }

    public synchronized void addInstanceListener(InstanceListener dsl) {
        super.addInstanceListener(dsl);
        ++this.m_instanceEventTargets;
        try {
            if (this.m_Loader instanceof DatabaseLoader && this.m_dbSet && this.m_dataFormat == null || !(this.m_Loader instanceof DatabaseLoader) && this.m_dataFormat == null) {
                this.m_dataFormat = this.m_Loader.getStructure();
                this.m_dbSet = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.notifyStructureAvailable(this.m_dataFormat);
    }

    public synchronized void removeInstanceListener(InstanceListener dsl) {
        super.removeInstanceListener(dsl);
        --this.m_instanceEventTargets;
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame();
            jf.getContentPane().setLayout(new BorderLayout());
            Loader tv = new Loader();
            jf.getContentPane().add((Component)tv, "Center");
            jf.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.setSize(800, 600);
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.m_Loader != null) {
            try {
                this.m_Loader.reset();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    public String getCustomName() {
        return this.m_visual.getText();
    }

    public void setLog(Logger logger) {
        this.m_log = logger;
    }

    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    public boolean connectionAllowed(EventSetDescriptor esd) {
        return false;
    }

    public boolean connectionAllowed(String eventName) {
        return false;
    }

    public void connectionNotification(String eventName, Object source) {
    }

    public void disconnectionNotification(String eventName, Object source) {
    }

    public void stop() {
        this.m_stopped = true;
    }

    public boolean isBusy() {
        return this.m_ioThread != null;
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|" + (this.m_Loader instanceof OptionHandler ? Utils.joinOptions(((OptionHandler)((Object)this.m_Loader)).getOptions()) + "|" : "");
    }

    private void readObject(ObjectInputStream aStream) throws IOException, ClassNotFoundException {
        aStream.defaultReadObject();
        this.m_env = Environment.getSystemWide();
    }

    private class LoadThread
    extends Thread {
        private DataSource m_DP;

        public LoadThread(DataSource dp) {
            this.m_DP = dp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                block26: {
                    try {
                        Loader.this.m_visual.setAnimated();
                        boolean instanceGeneration = true;
                        if (Loader.this.m_dataSetEventTargets > 0) {
                            instanceGeneration = false;
                            Loader.this.m_state = BATCH_LOADING;
                        }
                        if (Loader.this.m_Loader instanceof EnvironmentHandler && Loader.this.m_env != null) {
                            ((EnvironmentHandler)((Object)Loader.this.m_Loader)).setEnvironment(Loader.this.m_env);
                        }
                        String msg = Loader.this.statusMessagePrefix();
                        if (Loader.this.m_Loader instanceof FileSourcedConverter) {
                            StringBuilder stringBuilder = new StringBuilder().append(msg);
                            Messages.getInstance();
                            msg = stringBuilder.append(Messages.getString("Loader_LoadThread_Msg_Text_First")).append(((FileSourcedConverter)((Object)Loader.this.m_Loader)).retrieveFile().getName()).toString();
                        } else {
                            StringBuilder stringBuilder = new StringBuilder().append(msg);
                            Messages.getInstance();
                            msg = stringBuilder.append(Messages.getString("Loader_LoadThread_Msg_Text_Second")).toString();
                        }
                        if (Loader.this.m_log != null) {
                            Loader.this.m_log.statusMessage(msg);
                        }
                        if (instanceGeneration) {
                            Loader.this.m_state = INCREMENTAL_LOADING;
                            Instance nextInstance = null;
                            Instances structure = null;
                            try {
                                Loader.this.m_Loader.reset();
                                Loader.this.m_Loader.setRetrieval(2);
                                structure = Loader.this.m_Loader.getStructure();
                                Loader.this.notifyStructureAvailable(structure);
                            }
                            catch (IOException e) {
                                if (Loader.this.m_log != null) {
                                    Logger logger = Loader.this.m_log;
                                    StringBuilder stringBuilder = new StringBuilder().append(Loader.this.statusMessagePrefix());
                                    Messages.getInstance();
                                    logger.statusMessage(stringBuilder.append(Messages.getString("Loader_LoadThread_StatusMessage_Text_First")).toString());
                                    Logger logger2 = Loader.this.m_log;
                                    StringBuilder stringBuilder2 = new StringBuilder();
                                    Messages.getInstance();
                                    logger2.logMessage(stringBuilder2.append(Messages.getString("Loader_LoadThread_StatusMessage_Text_Second")).append(Loader.this.statusMessagePrefix()).append(" ").append(e.getMessage()).toString());
                                }
                                e.printStackTrace();
                            }
                            try {
                                nextInstance = Loader.this.m_Loader.getNextInstance(structure);
                            }
                            catch (IOException e) {
                                if (Loader.this.m_log != null) {
                                    Logger logger = Loader.this.m_log;
                                    StringBuilder stringBuilder = new StringBuilder().append(Loader.this.statusMessagePrefix());
                                    Messages.getInstance();
                                    logger.statusMessage(stringBuilder.append(Messages.getString("Loader_LoadThread_StatusMessage_Text_Third")).toString());
                                    Logger logger3 = Loader.this.m_log;
                                    StringBuilder stringBuilder3 = new StringBuilder();
                                    Messages.getInstance();
                                    logger3.logMessage(stringBuilder3.append(Messages.getString("Loader_LoadThread_StatusMessage_Text_Fourth")).append(Loader.this.statusMessagePrefix()).append(" ").append(e.getMessage()).toString());
                                }
                                e.printStackTrace();
                            }
                            int z = 0;
                            while (nextInstance != null && !Loader.this.m_stopped) {
                                nextInstance.setDataset(structure);
                                Loader.this.m_ie.setStatus(1);
                                Loader.this.m_ie.setInstance(nextInstance);
                                nextInstance = Loader.this.m_Loader.getNextInstance(structure);
                                if (nextInstance == null) {
                                    Loader.this.m_ie.setStatus(2);
                                }
                                Loader.this.notifyInstanceLoaded(Loader.this.m_ie);
                                if (++z % 10000 != 0 || Loader.this.m_log == null) continue;
                                Logger logger = Loader.this.m_log;
                                StringBuilder stringBuilder = new StringBuilder().append(Loader.this.statusMessagePrefix());
                                Messages.getInstance();
                                StringBuilder stringBuilder4 = stringBuilder.append(Messages.getString("Loader_LoadThread_StatusMessage_Text_Fifth")).append(z);
                                Messages.getInstance();
                                logger.statusMessage(stringBuilder4.append(Messages.getString("Loader_LoadThread_StatusMessage_Text_Sixth")).toString());
                            }
                            Loader.this.m_visual.setStatic();
                            break block26;
                        }
                        Loader.this.m_Loader.reset();
                        Loader.this.m_Loader.setRetrieval(1);
                        Loader.this.m_dataSet = Loader.this.m_Loader.getDataSet();
                        Loader.this.m_visual.setStatic();
                        if (Loader.this.m_log != null) {
                            Logger logger = Loader.this.m_log;
                            StringBuilder stringBuilder = new StringBuilder();
                            Messages.getInstance();
                            StringBuilder stringBuilder5 = stringBuilder.append(Messages.getString("Loader_LoadThread_LogMessage_Text_First")).append(Loader.this.statusMessagePrefix());
                            Messages.getInstance();
                            logger.logMessage(stringBuilder5.append(Messages.getString("Loader_LoadThread_LogMessage_Text_Second")).append(Loader.this.m_dataSet.relationName()).toString());
                        }
                        Loader.this.notifyDataSetLoaded(new DataSetEvent(this.m_DP, Loader.this.m_dataSet));
                    }
                    catch (Exception ex) {
                        if (Loader.this.m_log != null) {
                            Logger logger = Loader.this.m_log;
                            StringBuilder stringBuilder = new StringBuilder().append(Loader.this.statusMessagePrefix());
                            Messages.getInstance();
                            logger.statusMessage(stringBuilder.append(Messages.getString("Loader_LoadThread_StatusMessage_Text_Seventh")).toString());
                            Logger logger4 = Loader.this.m_log;
                            StringBuilder stringBuilder6 = new StringBuilder();
                            Messages.getInstance();
                            logger4.logMessage(stringBuilder6.append(Messages.getString("Loader_LoadThread_StatusMessage_Text_Eighth")).append(Loader.this.statusMessagePrefix()).append(" ").append(ex.getMessage()).toString());
                        }
                        ex.printStackTrace();
                        Object var7_11 = null;
                        if (Thread.currentThread().isInterrupted() && Loader.this.m_log != null) {
                            Logger logger = Loader.this.m_log;
                            StringBuilder stringBuilder = new StringBuilder();
                            Messages.getInstance();
                            StringBuilder stringBuilder7 = stringBuilder.append(Messages.getString("Loader_LoadThread_LogMessage_Text_Third")).append(Loader.this.statusMessagePrefix());
                            Messages.getInstance();
                            logger.logMessage(stringBuilder7.append(Messages.getString("Loader_LoadThread_LogMessage_Text_Fourth")).toString());
                        }
                        Loader.this.m_ioThread = null;
                        Loader.this.m_visual.setStatic();
                        Loader.this.m_state = IDLE;
                        Loader.this.m_stopped = false;
                        if (Loader.this.m_log != null) {
                            Logger logger = Loader.this.m_log;
                            StringBuilder stringBuilder = new StringBuilder().append(Loader.this.statusMessagePrefix());
                            Messages.getInstance();
                            logger.statusMessage(stringBuilder.append(Messages.getString("Loader_LoadThread_StatusMessage_Text_Nineth")).toString());
                        }
                        Loader.this.block(false);
                        return;
                    }
                }
                Object var7_10 = null;
                if (Thread.currentThread().isInterrupted() && Loader.this.m_log != null) {
                    Logger logger = Loader.this.m_log;
                    StringBuilder stringBuilder = new StringBuilder();
                    Messages.getInstance();
                    StringBuilder stringBuilder8 = stringBuilder.append(Messages.getString("Loader_LoadThread_LogMessage_Text_Third")).append(Loader.this.statusMessagePrefix());
                    Messages.getInstance();
                    logger.logMessage(stringBuilder8.append(Messages.getString("Loader_LoadThread_LogMessage_Text_Fourth")).toString());
                }
                Loader.this.m_ioThread = null;
                Loader.this.m_visual.setStatic();
                Loader.this.m_state = IDLE;
                Loader.this.m_stopped = false;
                if (Loader.this.m_log != null) {
                    Logger logger = Loader.this.m_log;
                    StringBuilder stringBuilder = new StringBuilder().append(Loader.this.statusMessagePrefix());
                    Messages.getInstance();
                    logger.statusMessage(stringBuilder.append(Messages.getString("Loader_LoadThread_StatusMessage_Text_Nineth")).toString());
                }
                Loader.this.block(false);
                return;
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                if (Thread.currentThread().isInterrupted() && Loader.this.m_log != null) {
                    Logger logger = Loader.this.m_log;
                    StringBuilder stringBuilder = new StringBuilder();
                    Messages.getInstance();
                    StringBuilder stringBuilder9 = stringBuilder.append(Messages.getString("Loader_LoadThread_LogMessage_Text_Third")).append(Loader.this.statusMessagePrefix());
                    Messages.getInstance();
                    logger.logMessage(stringBuilder9.append(Messages.getString("Loader_LoadThread_LogMessage_Text_Fourth")).toString());
                }
                Loader.this.m_ioThread = null;
                Loader.this.m_visual.setStatic();
                Loader.this.m_state = IDLE;
                Loader.this.m_stopped = false;
                if (Loader.this.m_log != null) {
                    Logger logger = Loader.this.m_log;
                    StringBuilder stringBuilder = new StringBuilder().append(Loader.this.statusMessagePrefix());
                    Messages.getInstance();
                    logger.statusMessage(stringBuilder.append(Messages.getString("Loader_LoadThread_StatusMessage_Text_Nineth")).toString());
                }
                Loader.this.block(false);
                throw throwable;
            }
        }
    }
}

