## Copyright (C) 1995-2007 R Core Team
## Copyright (C) 2019, 2023, 2024 Andrew Janke
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; If not, see <http://www.gnu.org/licenses/>.

# This is based on the freeny dataset from R’s datasets package

classdef freeny < tblish.internal.dataset

  methods

    function this = freeny
      this.name = "freeny";
      this.summary = "Freeny's Revenue Data";
    endfunction

    function out = load (this)
      date = [datetime(1962, 4, 1):calmonths(3):datetime(1971, 10, 1)]';
      y = [8.79236, 8.79137, 8.81486, ...
        8.81301, 8.90751, 8.93673,  ...
        8.96161, 8.96044, 9.00868, 9.03049, ...
        9.06906, 9.05871, 9.10698, ...
        9.12685, 9.17096, 9.18665, ...
        9.23823, 9.26487, 9.28436, ...
        9.31378, 9.35025, 9.35835, ...
        9.39767, 9.4215, 9.44223, 9.48721, ...
        9.52374, 9.5398, 9.58123, ...
        9.60048, 9.64496, 9.6439, ...
        9.69405, 9.69958, 9.68683, ...
        9.71774, 9.74924, 9.77536, ...
        9.79424]';
      x = [8.79636, 8.79236, 8.79137, ...
        8.81486, 8.81301, 8.90751, ...
        8.93673, 8.96161, 8.96044, 9.00868, ...
        9.03049, 9.06906, 9.05871, ...
        9.10698, 9.12685, 9.17096, ...
        9.18665, 9.23823, 9.26487, ...
        9.28436, 9.31378, 9.35025, ...
        9.35835, 9.39767, 9.4215, 9.44223, ...
        9.48721, 9.52374, 9.5398, ...
        9.58123, 9.60048, 9.64496, ...
        9.6439, 9.69405, 9.69958, ...
        9.68683, 9.71774, 9.74924, ...
        9.77536, 4.70997, 4.70217, ...
        4.68944, 4.68558, 4.64019, ...
        4.62553, 4.61991, 4.61654, 4.61407, ...
        4.60766, 4.60227, 4.5896, 4.57592, ...
        4.58661, 4.57997, 4.57176, ...
        4.56104, 4.54906, 4.53957, ...
        4.51018, 4.50352, 4.4936, 4.46505, ...
        4.44924, 4.43966, 4.42025, ...
        4.4106, 4.41151, 4.3981, ...
        4.38513, 4.3732, 4.3277, ...
        4.32023, 4.30909, 4.30909, ...
        4.30552, 4.29627, 4.27839, ...
        4.27789, 5.8211, 5.82558, ...
        5.83112, 5.84046, 5.85036, ...
        5.86464, 5.87769, 5.89763, ...
        5.92574, 5.94232, 5.95365, ...
        5.9612, 5.97805, 6.00377, ...
        6.02829, 6.03475, 6.03906, ...
        6.05046, 6.05563, 6.06093, ...
        6.07103, 6.08018, 6.08858, ...
        6.10199, 6.11207, 6.11596, ...
        6.12129, 6.122, 6.13119, ...
        6.14705, 6.15336, 6.15627, ...
        6.16274, 6.17369, 6.16135, ...
        6.18231, 6.18768, 6.19377, ...
        6.2003, 12.9699, 12.9733, 12.9774, ...
        12.9806, 12.9831, 12.9854, 12.99, 12.9943, ...
        12.9992, 13.0033, 13.0099, 13.0159, 13.0212, 13.0265, ...
        13.0351, 13.0429, 13.0497, 13.0551, 13.0634, ...
        13.0693, 13.0737, 13.077, 13.0849, ...
        13.0918, 13.095, 13.0984, 13.1089, ...
        13.1169, 13.1222, 13.1266, 13.1356, ...
        13.1415, 13.1444, 13.1459, ...
        13.152, 13.1593, 13.1579, 13.1625, 13.1664];
      x = reshape (x, [39 4]);
      t = table(date, y, x(:,1), x(:,2), x(:,3), x(:,4), ...
        "VariableNames", {"date", "y", "lag_quarterly_revenue", "price_index", ...
        "income_level", "market_potential"});
      out = t;
    endfunction

  endmethods

endclassdef
