/* +------------------------------------------------------------------------+
   |                     Mobile Robot Programming Toolkit (MRPT)            |
   |                          https://www.mrpt.org/                         |
   |                                                                        |
   | Copyright (c) 2005-2021, Individual contributors, see AUTHORS file     |
   | See: https://www.mrpt.org/Authors - All rights reserved.               |
   | Released under BSD License. See: https://www.mrpt.org/License          |
   +------------------------------------------------------------------------+ */

#include "COdometryParams.h"

#include <wx/msgdlg.h>
#include "xRawLogViewerMain.h"

//(*InternalHeaders(COdometryParams)
#include <wx/intl.h>
#include <wx/string.h>
//*)

//(*IdInit(COdometryParams)
const long COdometryParams::ID_STATICTEXT1 = wxNewId();
const long COdometryParams::ID_STATICTEXT2 = wxNewId();
const long COdometryParams::ID_TEXTCTRL1 = wxNewId();
const long COdometryParams::ID_STATICTEXT3 = wxNewId();
const long COdometryParams::ID_STATICTEXT4 = wxNewId();
const long COdometryParams::ID_TEXTCTRL2 = wxNewId();
const long COdometryParams::ID_STATICTEXT5 = wxNewId();
const long COdometryParams::ID_STATICTEXT6 = wxNewId();
const long COdometryParams::ID_TEXTCTRL3 = wxNewId();
const long COdometryParams::ID_STATICTEXT7 = wxNewId();
const long COdometryParams::ID_BUTTON1 = wxNewId();
const long COdometryParams::ID_BUTTON2 = wxNewId();
//*)

BEGIN_EVENT_TABLE(COdometryParams, wxDialog)
//(*EventTable(COdometryParams)
//*)
END_EVENT_TABLE()

COdometryParams::COdometryParams(
	wxWindow* parent, wxWindowID id, const wxPoint&, const wxSize& size)
{
	//(*Initialize(COdometryParams)
	wxFlexGridSizer* FlexGridSizer3;
	wxFlexGridSizer* FlexGridSizer2;
	wxFlexGridSizer* FlexGridSizer1;

	Create(
		parent, id, _("Recalculate odometry"), wxDefaultPosition, wxDefaultSize,
		wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetClientSize(wxDefaultSize);
	Move(wxDefaultPosition);
	FlexGridSizer1 = new wxFlexGridSizer(0, 1, 0, 0);
	StaticText1 = new wxStaticText(
		this, ID_STATICTEXT1,
		_("Odometry increments will be recomputed from the\n encoder ticks, "
		  "using these new parameters:"),
		wxDefaultPosition, wxDefaultSize, wxALIGN_CENTRE, _T("ID_STATICTEXT1"));
	FlexGridSizer1->Add(
		StaticText1, 1,
		wxALL | wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer2 = new wxFlexGridSizer(3, 3, 0, 0);
	FlexGridSizer2->AddGrowableCol(1);
	StaticText2 = new wxStaticText(
		this, ID_STATICTEXT2, _("K_left="), wxDefaultPosition, wxDefaultSize, 0,
		_T("ID_STATICTEXT2"));
	FlexGridSizer2->Add(
		StaticText2, 1, wxALL | wxALIGN_RIGHT | wxALIGN_CENTER_VERTICAL, 5);
	edKL = new wxTextCtrl(
		this, ID_TEXTCTRL1, _("7.00e-6"), wxDefaultPosition, wxDefaultSize, 0,
		wxDefaultValidator, _T("ID_TEXTCTRL1"));
	FlexGridSizer2->Add(
		edKL, 1, wxALL | wxEXPAND | wxALIGN_LEFT | wxALIGN_TOP, 5);
	StaticText3 = new wxStaticText(
		this, ID_STATICTEXT3, _("meters/tick"), wxDefaultPosition,
		wxDefaultSize, 0, _T("ID_STATICTEXT3"));
	FlexGridSizer2->Add(
		StaticText3, 1, wxALL | wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL, 5);
	StaticText4 = new wxStaticText(
		this, ID_STATICTEXT4, _("K_right="), wxDefaultPosition, wxDefaultSize,
		0, _T("ID_STATICTEXT4"));
	FlexGridSizer2->Add(
		StaticText4, 1, wxALL | wxALIGN_RIGHT | wxALIGN_CENTER_VERTICAL, 5);
	edKR = new wxTextCtrl(
		this, ID_TEXTCTRL2, _("7.00e-6"), wxDefaultPosition, wxDefaultSize, 0,
		wxDefaultValidator, _T("ID_TEXTCTRL2"));
	FlexGridSizer2->Add(
		edKR, 1, wxALL | wxEXPAND | wxALIGN_LEFT | wxALIGN_TOP, 5);
	StaticText5 = new wxStaticText(
		this, ID_STATICTEXT5, _("meters/tick"), wxDefaultPosition,
		wxDefaultSize, 0, _T("ID_STATICTEXT5"));
	FlexGridSizer2->Add(
		StaticText5, 1, wxALL | wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL, 5);
	StaticText6 = new wxStaticText(
		this, ID_STATICTEXT6, _("Distance between wheels="), wxDefaultPosition,
		wxDefaultSize, 0, _T("ID_STATICTEXT6"));
	FlexGridSizer2->Add(
		StaticText6, 1, wxALL | wxALIGN_RIGHT | wxALIGN_CENTER_VERTICAL, 5);
	edD = new wxTextCtrl(
		this, ID_TEXTCTRL3, _("0.41"), wxDefaultPosition, wxDefaultSize, 0,
		wxDefaultValidator, _T("ID_TEXTCTRL3"));
	FlexGridSizer2->Add(
		edD, 1, wxALL | wxEXPAND | wxALIGN_LEFT | wxALIGN_TOP, 5);
	StaticText7 = new wxStaticText(
		this, ID_STATICTEXT7, _("meters"), wxDefaultPosition, wxDefaultSize, 0,
		_T("ID_STATICTEXT7"));
	FlexGridSizer2->Add(
		StaticText7, 1, wxALL | wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(
		FlexGridSizer2, 1, wxALL | wxEXPAND | wxALIGN_LEFT | wxALIGN_TOP, 0);
	FlexGridSizer3 = new wxFlexGridSizer(0, 3, 0, 0);
	FlexGridSizer3->AddGrowableCol(0);
	FlexGridSizer3->Add(
		-1, -1, 1, wxALL | wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL,
		5);
	btnOk = new wxButton(
		this, ID_BUTTON1, _("OK"), wxDefaultPosition, wxDefaultSize, 0,
		wxDefaultValidator, _T("ID_BUTTON1"));
	FlexGridSizer3->Add(
		btnOk, 1, wxALL | wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL,
		5);
	btnCancel = new wxButton(
		this, ID_BUTTON2, _("Cancel"), wxDefaultPosition, wxDefaultSize, 0,
		wxDefaultValidator, _T("ID_BUTTON2"));
	FlexGridSizer3->Add(
		btnCancel, 1,
		wxALL | wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(
		FlexGridSizer3, 1, wxALL | wxEXPAND | wxALIGN_LEFT | wxALIGN_TOP, 0);
	SetSizer(FlexGridSizer1);
	FlexGridSizer1->Fit(this);
	FlexGridSizer1->SetSizeHints(this);
	Center();

	Bind(wxEVT_BUTTON, &COdometryParams::OnbtnOkClick, this, ID_BUTTON1);
	Bind(wxEVT_BUTTON, &COdometryParams::OnbtnCancelClick, this, ID_BUTTON2);
	//*)
}

COdometryParams::~COdometryParams()
{
	//(*Destroy(COdometryParams)
	//*)
}

void COdometryParams::OnbtnOkClick(wxCommandEvent&) { EndModal(1); }
void COdometryParams::OnbtnCancelClick(wxCommandEvent&) { EndModal(0); }
