/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.builder;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.lisaac.ldt.LisaacMessages;
import org.lisaac.ldt.builder.ILisaacErrorHandler;
import org.lisaac.ldt.model.LisaacModel;
import org.lisaac.ldt.model.Position;

public class LisaacBuilder
extends IncrementalProjectBuilder {
    private LisaacModel model;
    public static final String BUILDER_ID = "org.lisaac.ldt.builder";
    private static final String MARKER_TYPE = "org.lisaac.ldt.lisaacProblem";

    public static void addMarker(IFile file, String msg, Position position, int severity) {
        IMarker marker = LisaacBuilder.addMarker(file, msg, position.getLine(), severity);
        if (marker != null && position.hasRange()) {
            try {
                marker.setAttribute("charStart", position.getCharStart());
                marker.setAttribute("charEnd", position.getCharEnd());
            }
            catch (CoreException coreException) {}
        }
    }

    public static IMarker addMarker(IFile file, String message, int lineNumber, int severity) {
        try {
            IMarker marker = file.createMarker(MARKER_TYPE);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            if (lineNumber == -1) {
                lineNumber = 1;
            }
            marker.setAttribute("lineNumber", lineNumber);
            return marker;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        this.model = LisaacModel.getModel(project);
        if (this.model == null) {
            this.model = new LisaacModel(project);
        }
        monitor.beginTask(LisaacMessages.getString("LisaacBuilder.2"), 100);
        this.model.refreshPresentation();
        monitor.worked(1);
        if (kind == 15) {
            this.model.refreshPath();
            monitor.worked(10);
            IFolder bin = project.getFolder("lib");
            if (bin.exists()) {
                bin.delete(true, monitor);
            }
        }
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.model.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    private void buildLisaacFile(IResource resource, IProgressMonitor monitor) {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            if (file.isHidden()) {
                return;
            }
            if (resource.getName().endsWith(".li")) {
                LisaacBuilder.deleteMarkers(file);
                try {
                    LisaacErrorHandler reporter = new LisaacErrorHandler(file);
                    this.model.parsePrototype(file, file.getContents(), reporter);
                }
                catch (Exception exception) {}
            } else if (resource.getName().endsWith(".lip")) {
                LisaacBuilder.deleteMarkers(file);
                try {
                    LisaacErrorHandler reporter = new LisaacErrorHandler(file);
                    this.model.parseLip(file.getName(), file.getContents(), reporter);
                }
                catch (Exception exception) {}
            }
            monitor.worked(1);
        }
    }

    private void removeLisaacFile(IResource resource) {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            if (resource.getName().endsWith(".li")) {
                LisaacBuilder.deleteMarkers(file);
                try {
                    this.model.removePrototype((IResource)file);
                }
                catch (Exception exception) {}
            } else if (resource.getName().endsWith(".lip")) {
                LisaacBuilder.deleteMarkers(file);
                try {
                    this.model.removeLip((IResource)file);
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void deleteMarkers(IFile file) {
        try {
            file.deleteMarkers(MARKER_TYPE, false, 0);
        }
        catch (CoreException coreException) {}
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            if (this.model.getProject() != null) {
                this.model.getProject().accept((IResourceVisitor)new LisaacResourceVisitor(monitor));
                monitor.done();
            }
        }
        catch (CoreException coreException) {}
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new LisaacDeltaVisitor(monitor));
        monitor.done();
    }

    class LisaacDeltaVisitor
    implements IResourceDeltaVisitor {
        IProgressMonitor monitor;

        LisaacDeltaVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    LisaacBuilder.this.buildLisaacFile(resource, this.monitor);
                    break;
                }
                case 2: {
                    LisaacBuilder.this.removeLisaacFile(resource);
                    break;
                }
                case 4: {
                    LisaacBuilder.this.buildLisaacFile(resource, this.monitor);
                }
            }
            return true;
        }
    }

    class LisaacErrorHandler
    implements ILisaacErrorHandler {
        private IFile file;
        private boolean doReport;

        public LisaacErrorHandler(IFile file) {
            this.file = file;
            this.doReport = true;
        }

        public void syntaxError(String msg, Position position) {
            if (this.doReport) {
                LisaacBuilder.addMarker(this.file, msg, position, 2);
            }
        }

        public void semanticError(String msg, Position position) {
            if (this.doReport) {
                LisaacBuilder.addMarker(this.file, msg, position, 2);
            }
        }

        public void fatalError(String msg, Position position) {
            if (this.doReport) {
                LisaacBuilder.addMarker(this.file, msg, position, 2);
            }
        }

        public void warning(String msg, Position position) {
            if (this.doReport) {
                LisaacBuilder.addMarker(this.file, msg, position, 1);
            }
        }

        public void enableErrorReport(boolean enable) {
            this.doReport = enable;
        }
    }

    class LisaacResourceVisitor
    implements IResourceVisitor {
        IProgressMonitor monitor;

        LisaacResourceVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResource resource) {
            LisaacBuilder.this.buildLisaacFile(resource, this.monitor);
            return true;
        }
    }
}

