/* 
 * File: setupwidget.h
 *
 * GKrellM 2 Plugin to control XMMS2
 * Copyright (c) 2005-2008 Johannes Heimansberg
 *
 * requires GKrellM 2 and XMMS2
 *
 * Released under the GNU General Public License v2
 */
#include <gtk/gtk.h>

typedef struct _SetupWidget {
	GtkWidget *box;
	GtkWidget *frame1, *frame2, *table1, *table2;
	/* xmms2d setup widgets */
	GtkWidget *label_ipc_path, *entry_ipc_path;
	/* gkrellxmms2 setup widgets */
	GtkWidget *checkbox_show_volume_slider;
	GtkWidget *checkbox_auto_reconnect;
	GtkWidget *label_scroll_speed, *hscale_scroll_speed;
} SetupWidget;

const char *setup_widget_get_ipc_path(SetupWidget *sw);
void        setup_widget_set_ipc_path(SetupWidget *sw, char *path);
void        setup_widget_set_scroll_speed(SetupWidget *sw, int speed);
int         setup_widget_get_scroll_speed(SetupWidget *sw);
void        setup_widget_set_auto_reconnect(SetupWidget *sw, gboolean value);
gboolean    setup_widget_get_auto_reconnect(SetupWidget *sw);
GtkWidget  *setup_widget_create(SetupWidget *sw);
