// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/datastore/admin/v1/datastore_admin.proto

package admin

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Operation types.
type OperationType int32

const (
	// Unspecified.
	OperationType_OPERATION_TYPE_UNSPECIFIED OperationType = 0
	// ExportEntities.
	OperationType_EXPORT_ENTITIES OperationType = 1
	// ImportEntities.
	OperationType_IMPORT_ENTITIES OperationType = 2
	// CreateIndex.
	OperationType_CREATE_INDEX OperationType = 3
	// DeleteIndex.
	OperationType_DELETE_INDEX OperationType = 4
)

var OperationType_name = map[int32]string{
	0: "OPERATION_TYPE_UNSPECIFIED",
	1: "EXPORT_ENTITIES",
	2: "IMPORT_ENTITIES",
	3: "CREATE_INDEX",
	4: "DELETE_INDEX",
}

var OperationType_value = map[string]int32{
	"OPERATION_TYPE_UNSPECIFIED": 0,
	"EXPORT_ENTITIES":            1,
	"IMPORT_ENTITIES":            2,
	"CREATE_INDEX":               3,
	"DELETE_INDEX":               4,
}

func (x OperationType) String() string {
	return proto.EnumName(OperationType_name, int32(x))
}

func (OperationType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_891b89db06fa8774, []int{0}
}

// The various possible states for an ongoing Operation.
type CommonMetadata_State int32

const (
	// Unspecified.
	CommonMetadata_STATE_UNSPECIFIED CommonMetadata_State = 0
	// Request is being prepared for processing.
	CommonMetadata_INITIALIZING CommonMetadata_State = 1
	// Request is actively being processed.
	CommonMetadata_PROCESSING CommonMetadata_State = 2
	// Request is in the process of being cancelled after user called
	// google.longrunning.Operations.CancelOperation on the operation.
	CommonMetadata_CANCELLING CommonMetadata_State = 3
	// Request has been processed and is in its finalization stage.
	CommonMetadata_FINALIZING CommonMetadata_State = 4
	// Request has completed successfully.
	CommonMetadata_SUCCESSFUL CommonMetadata_State = 5
	// Request has finished being processed, but encountered an error.
	CommonMetadata_FAILED CommonMetadata_State = 6
	// Request has finished being cancelled after user called
	// google.longrunning.Operations.CancelOperation.
	CommonMetadata_CANCELLED CommonMetadata_State = 7
)

var CommonMetadata_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "INITIALIZING",
	2: "PROCESSING",
	3: "CANCELLING",
	4: "FINALIZING",
	5: "SUCCESSFUL",
	6: "FAILED",
	7: "CANCELLED",
}

var CommonMetadata_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"INITIALIZING":      1,
	"PROCESSING":        2,
	"CANCELLING":        3,
	"FINALIZING":        4,
	"SUCCESSFUL":        5,
	"FAILED":            6,
	"CANCELLED":         7,
}

func (x CommonMetadata_State) String() string {
	return proto.EnumName(CommonMetadata_State_name, int32(x))
}

func (CommonMetadata_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_891b89db06fa8774, []int{0, 0}
}

// Metadata common to all Datastore Admin operations.
type CommonMetadata struct {
	// The time that work began on the operation.
	StartTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time the operation ended, either successfully or otherwise.
	EndTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The type of the operation. Can be used as a filter in
	// ListOperationsRequest.
	OperationType OperationType `protobuf:"varint,3,opt,name=operation_type,json=operationType,proto3,enum=google.datastore.admin.v1.OperationType" json:"operation_type,omitempty"`
	// The client-assigned labels which were provided when the operation was
	// created. May also include additional labels.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The current state of the Operation.
	State                CommonMetadata_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.datastore.admin.v1.CommonMetadata_State" json:"state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *CommonMetadata) Reset()         { *m = CommonMetadata{} }
func (m *CommonMetadata) String() string { return proto.CompactTextString(m) }
func (*CommonMetadata) ProtoMessage()    {}
func (*CommonMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_891b89db06fa8774, []int{0}
}

func (m *CommonMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommonMetadata.Unmarshal(m, b)
}
func (m *CommonMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommonMetadata.Marshal(b, m, deterministic)
}
func (m *CommonMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommonMetadata.Merge(m, src)
}
func (m *CommonMetadata) XXX_Size() int {
	return xxx_messageInfo_CommonMetadata.Size(m)
}
func (m *CommonMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CommonMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CommonMetadata proto.InternalMessageInfo

func (m *CommonMetadata) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *CommonMetadata) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *CommonMetadata) GetOperationType() OperationType {
	if m != nil {
		return m.OperationType
	}
	return OperationType_OPERATION_TYPE_UNSPECIFIED
}

func (m *CommonMetadata) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *CommonMetadata) GetState() CommonMetadata_State {
	if m != nil {
		return m.State
	}
	return CommonMetadata_STATE_UNSPECIFIED
}

// Measures the progress of a particular metric.
type Progress struct {
	// The amount of work that has been completed. Note that this may be greater
	// than work_estimated.
	WorkCompleted int64 `protobuf:"varint,1,opt,name=work_completed,json=workCompleted,proto3" json:"work_completed,omitempty"`
	// An estimate of how much work needs to be performed. May be zero if the
	// work estimate is unavailable.
	WorkEstimated        int64    `protobuf:"varint,2,opt,name=work_estimated,json=workEstimated,proto3" json:"work_estimated,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Progress) Reset()         { *m = Progress{} }
func (m *Progress) String() string { return proto.CompactTextString(m) }
func (*Progress) ProtoMessage()    {}
func (*Progress) Descriptor() ([]byte, []int) {
	return fileDescriptor_891b89db06fa8774, []int{1}
}

func (m *Progress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Progress.Unmarshal(m, b)
}
func (m *Progress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Progress.Marshal(b, m, deterministic)
}
func (m *Progress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Progress.Merge(m, src)
}
func (m *Progress) XXX_Size() int {
	return xxx_messageInfo_Progress.Size(m)
}
func (m *Progress) XXX_DiscardUnknown() {
	xxx_messageInfo_Progress.DiscardUnknown(m)
}

var xxx_messageInfo_Progress proto.InternalMessageInfo

func (m *Progress) GetWorkCompleted() int64 {
	if m != nil {
		return m.WorkCompleted
	}
	return 0
}

func (m *Progress) GetWorkEstimated() int64 {
	if m != nil {
		return m.WorkEstimated
	}
	return 0
}

// The request for
// [google.datastore.admin.v1.DatastoreAdmin.ExportEntities][google.datastore.admin.v1.DatastoreAdmin.ExportEntities].
type ExportEntitiesRequest struct {
	// Required. Project ID against which to make the request.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Client-assigned labels.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Description of what data from the project is included in the export.
	EntityFilter *EntityFilter `protobuf:"bytes,3,opt,name=entity_filter,json=entityFilter,proto3" json:"entity_filter,omitempty"`
	// Required. Location for the export metadata and data files.
	//
	// The full resource URL of the external storage location. Currently, only
	// Google Cloud Storage is supported. So output_url_prefix should be of the
	// form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the
	// name of the Cloud Storage bucket and `NAMESPACE_PATH` is an optional Cloud
	// Storage namespace path (this is not a Cloud Datastore namespace). For more
	// information about Cloud Storage namespace paths, see
	// [Object name
	// considerations](https://cloud.google.com/storage/docs/naming#object-considerations).
	//
	// The resulting files will be nested deeper than the specified URL prefix.
	// The final output URL will be provided in the
	// [google.datastore.admin.v1.ExportEntitiesResponse.output_url][google.datastore.admin.v1.ExportEntitiesResponse.output_url] field. That
	// value should be used for subsequent ImportEntities operations.
	//
	// By nesting the data files deeper, the same Cloud Storage bucket can be used
	// in multiple ExportEntities operations without conflict.
	OutputUrlPrefix      string   `protobuf:"bytes,4,opt,name=output_url_prefix,json=outputUrlPrefix,proto3" json:"output_url_prefix,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExportEntitiesRequest) Reset()         { *m = ExportEntitiesRequest{} }
func (m *ExportEntitiesRequest) String() string { return proto.CompactTextString(m) }
func (*ExportEntitiesRequest) ProtoMessage()    {}
func (*ExportEntitiesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_891b89db06fa8774, []int{2}
}

func (m *ExportEntitiesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportEntitiesRequest.Unmarshal(m, b)
}
func (m *ExportEntitiesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportEntitiesRequest.Marshal(b, m, deterministic)
}
func (m *ExportEntitiesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportEntitiesRequest.Merge(m, src)
}
func (m *ExportEntitiesRequest) XXX_Size() int {
	return xxx_messageInfo_ExportEntitiesRequest.Size(m)
}
func (m *ExportEntitiesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportEntitiesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExportEntitiesRequest proto.InternalMessageInfo

func (m *ExportEntitiesRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ExportEntitiesRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *ExportEntitiesRequest) GetEntityFilter() *EntityFilter {
	if m != nil {
		return m.EntityFilter
	}
	return nil
}

func (m *ExportEntitiesRequest) GetOutputUrlPrefix() string {
	if m != nil {
		return m.OutputUrlPrefix
	}
	return ""
}

// The request for
// [google.datastore.admin.v1.DatastoreAdmin.ImportEntities][google.datastore.admin.v1.DatastoreAdmin.ImportEntities].
type ImportEntitiesRequest struct {
	// Required. Project ID against which to make the request.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Client-assigned labels.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. The full resource URL of the external storage location. Currently, only
	// Google Cloud Storage is supported. So input_url should be of the form:
	// `gs://BUCKET_NAME[/NAMESPACE_PATH]/OVERALL_EXPORT_METADATA_FILE`, where
	// `BUCKET_NAME` is the name of the Cloud Storage bucket, `NAMESPACE_PATH` is
	// an optional Cloud Storage namespace path (this is not a Cloud Datastore
	// namespace), and `OVERALL_EXPORT_METADATA_FILE` is the metadata file written
	// by the ExportEntities operation. For more information about Cloud Storage
	// namespace paths, see
	// [Object name
	// considerations](https://cloud.google.com/storage/docs/naming#object-considerations).
	//
	// For more information, see
	// [google.datastore.admin.v1.ExportEntitiesResponse.output_url][google.datastore.admin.v1.ExportEntitiesResponse.output_url].
	InputUrl string `protobuf:"bytes,3,opt,name=input_url,json=inputUrl,proto3" json:"input_url,omitempty"`
	// Optionally specify which kinds/namespaces are to be imported. If provided,
	// the list must be a subset of the EntityFilter used in creating the export,
	// otherwise a FAILED_PRECONDITION error will be returned. If no filter is
	// specified then all entities from the export are imported.
	EntityFilter         *EntityFilter `protobuf:"bytes,4,opt,name=entity_filter,json=entityFilter,proto3" json:"entity_filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ImportEntitiesRequest) Reset()         { *m = ImportEntitiesRequest{} }
func (m *ImportEntitiesRequest) String() string { return proto.CompactTextString(m) }
func (*ImportEntitiesRequest) ProtoMessage()    {}
func (*ImportEntitiesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_891b89db06fa8774, []int{3}
}

func (m *ImportEntitiesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportEntitiesRequest.Unmarshal(m, b)
}
func (m *ImportEntitiesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportEntitiesRequest.Marshal(b, m, deterministic)
}
func (m *ImportEntitiesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportEntitiesRequest.Merge(m, src)
}
func (m *ImportEntitiesRequest) XXX_Size() int {
	return xxx_messageInfo_ImportEntitiesRequest.Size(m)
}
func (m *ImportEntitiesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportEntitiesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ImportEntitiesRequest proto.InternalMessageInfo

func (m *ImportEntitiesRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ImportEntitiesRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *ImportEntitiesRequest) GetInputUrl() string {
	if m != nil {
		return m.InputUrl
	}
	return ""
}

func (m *ImportEntitiesRequest) GetEntityFilter() *EntityFilter {
	if m != nil {
		return m.EntityFilter
	}
	return nil
}

// The response for
// [google.datastore.admin.v1.DatastoreAdmin.ExportEntities][google.datastore.admin.v1.DatastoreAdmin.ExportEntities].
type ExportEntitiesResponse struct {
	// Location of the output metadata file. This can be used to begin an import
	// into Cloud Datastore (this project or another project). See
	// [google.datastore.admin.v1.ImportEntitiesRequest.input_url][google.datastore.admin.v1.ImportEntitiesRequest.input_url].
	// Only present if the operation completed successfully.
	OutputUrl            string   `protobuf:"bytes,1,opt,name=output_url,json=outputUrl,proto3" json:"output_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExportEntitiesResponse) Reset()         { *m = ExportEntitiesResponse{} }
func (m *ExportEntitiesResponse) String() string { return proto.CompactTextString(m) }
func (*ExportEntitiesResponse) ProtoMessage()    {}
func (*ExportEntitiesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_891b89db06fa8774, []int{4}
}

func (m *ExportEntitiesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportEntitiesResponse.Unmarshal(m, b)
}
func (m *ExportEntitiesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportEntitiesResponse.Marshal(b, m, deterministic)
}
func (m *ExportEntitiesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportEntitiesResponse.Merge(m, src)
}
func (m *ExportEntitiesResponse) XXX_Size() int {
	return xxx_messageInfo_ExportEntitiesResponse.Size(m)
}
func (m *ExportEntitiesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportEntitiesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExportEntitiesResponse proto.InternalMessageInfo

func (m *ExportEntitiesResponse) GetOutputUrl() string {
	if m != nil {
		return m.OutputUrl
	}
	return ""
}

// Metadata for ExportEntities operations.
type ExportEntitiesMetadata struct {
	// Metadata common to all Datastore Admin operations.
	Common *CommonMetadata `protobuf:"bytes,1,opt,name=common,proto3" json:"common,omitempty"`
	// An estimate of the number of entities processed.
	ProgressEntities *Progress `protobuf:"bytes,2,opt,name=progress_entities,json=progressEntities,proto3" json:"progress_entities,omitempty"`
	// An estimate of the number of bytes processed.
	ProgressBytes *Progress `protobuf:"bytes,3,opt,name=progress_bytes,json=progressBytes,proto3" json:"progress_bytes,omitempty"`
	// Description of which entities are being exported.
	EntityFilter *EntityFilter `protobuf:"bytes,4,opt,name=entity_filter,json=entityFilter,proto3" json:"entity_filter,omitempty"`
	// Location for the export metadata and data files. This will be the same
	// value as the
	// [google.datastore.admin.v1.ExportEntitiesRequest.output_url_prefix][google.datastore.admin.v1.ExportEntitiesRequest.output_url_prefix]
	// field. The final output location is provided in
	// [google.datastore.admin.v1.ExportEntitiesResponse.output_url][google.datastore.admin.v1.ExportEntitiesResponse.output_url].
	OutputUrlPrefix      string   `protobuf:"bytes,5,opt,name=output_url_prefix,json=outputUrlPrefix,proto3" json:"output_url_prefix,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExportEntitiesMetadata) Reset()         { *m = ExportEntitiesMetadata{} }
func (m *ExportEntitiesMetadata) String() string { return proto.CompactTextString(m) }
func (*ExportEntitiesMetadata) ProtoMessage()    {}
func (*ExportEntitiesMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_891b89db06fa8774, []int{5}
}

func (m *ExportEntitiesMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportEntitiesMetadata.Unmarshal(m, b)
}
func (m *ExportEntitiesMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportEntitiesMetadata.Marshal(b, m, deterministic)
}
func (m *ExportEntitiesMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportEntitiesMetadata.Merge(m, src)
}
func (m *ExportEntitiesMetadata) XXX_Size() int {
	return xxx_messageInfo_ExportEntitiesMetadata.Size(m)
}
func (m *ExportEntitiesMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportEntitiesMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ExportEntitiesMetadata proto.InternalMessageInfo

func (m *ExportEntitiesMetadata) GetCommon() *CommonMetadata {
	if m != nil {
		return m.Common
	}
	return nil
}

func (m *ExportEntitiesMetadata) GetProgressEntities() *Progress {
	if m != nil {
		return m.ProgressEntities
	}
	return nil
}

func (m *ExportEntitiesMetadata) GetProgressBytes() *Progress {
	if m != nil {
		return m.ProgressBytes
	}
	return nil
}

func (m *ExportEntitiesMetadata) GetEntityFilter() *EntityFilter {
	if m != nil {
		return m.EntityFilter
	}
	return nil
}

func (m *ExportEntitiesMetadata) GetOutputUrlPrefix() string {
	if m != nil {
		return m.OutputUrlPrefix
	}
	return ""
}

// Metadata for ImportEntities operations.
type ImportEntitiesMetadata struct {
	// Metadata common to all Datastore Admin operations.
	Common *CommonMetadata `protobuf:"bytes,1,opt,name=common,proto3" json:"common,omitempty"`
	// An estimate of the number of entities processed.
	ProgressEntities *Progress `protobuf:"bytes,2,opt,name=progress_entities,json=progressEntities,proto3" json:"progress_entities,omitempty"`
	// An estimate of the number of bytes processed.
	ProgressBytes *Progress `protobuf:"bytes,3,opt,name=progress_bytes,json=progressBytes,proto3" json:"progress_bytes,omitempty"`
	// Description of which entities are being imported.
	EntityFilter *EntityFilter `protobuf:"bytes,4,opt,name=entity_filter,json=entityFilter,proto3" json:"entity_filter,omitempty"`
	// The location of the import metadata file. This will be the same value as
	// the [google.datastore.admin.v1.ExportEntitiesResponse.output_url][google.datastore.admin.v1.ExportEntitiesResponse.output_url] field.
	InputUrl             string   `protobuf:"bytes,5,opt,name=input_url,json=inputUrl,proto3" json:"input_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImportEntitiesMetadata) Reset()         { *m = ImportEntitiesMetadata{} }
func (m *ImportEntitiesMetadata) String() string { return proto.CompactTextString(m) }
func (*ImportEntitiesMetadata) ProtoMessage()    {}
func (*ImportEntitiesMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_891b89db06fa8774, []int{6}
}

func (m *ImportEntitiesMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportEntitiesMetadata.Unmarshal(m, b)
}
func (m *ImportEntitiesMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportEntitiesMetadata.Marshal(b, m, deterministic)
}
func (m *ImportEntitiesMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportEntitiesMetadata.Merge(m, src)
}
func (m *ImportEntitiesMetadata) XXX_Size() int {
	return xxx_messageInfo_ImportEntitiesMetadata.Size(m)
}
func (m *ImportEntitiesMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportEntitiesMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ImportEntitiesMetadata proto.InternalMessageInfo

func (m *ImportEntitiesMetadata) GetCommon() *CommonMetadata {
	if m != nil {
		return m.Common
	}
	return nil
}

func (m *ImportEntitiesMetadata) GetProgressEntities() *Progress {
	if m != nil {
		return m.ProgressEntities
	}
	return nil
}

func (m *ImportEntitiesMetadata) GetProgressBytes() *Progress {
	if m != nil {
		return m.ProgressBytes
	}
	return nil
}

func (m *ImportEntitiesMetadata) GetEntityFilter() *EntityFilter {
	if m != nil {
		return m.EntityFilter
	}
	return nil
}

func (m *ImportEntitiesMetadata) GetInputUrl() string {
	if m != nil {
		return m.InputUrl
	}
	return ""
}

// Identifies a subset of entities in a project. This is specified as
// combinations of kinds and namespaces (either or both of which may be all, as
// described in the following examples).
// Example usage:
//
// Entire project:
//   kinds=[], namespace_ids=[]
//
// Kinds Foo and Bar in all namespaces:
//   kinds=['Foo', 'Bar'], namespace_ids=[]
//
// Kinds Foo and Bar only in the default namespace:
//   kinds=['Foo', 'Bar'], namespace_ids=['']
//
// Kinds Foo and Bar in both the default and Baz namespaces:
//   kinds=['Foo', 'Bar'], namespace_ids=['', 'Baz']
//
// The entire Baz namespace:
//   kinds=[], namespace_ids=['Baz']
type EntityFilter struct {
	// If empty, then this represents all kinds.
	Kinds []string `protobuf:"bytes,1,rep,name=kinds,proto3" json:"kinds,omitempty"`
	// An empty list represents all namespaces. This is the preferred
	// usage for projects that don't use namespaces.
	//
	// An empty string element represents the default namespace. This should be
	// used if the project has data in non-default namespaces, but doesn't want to
	// include them.
	// Each namespace in this list must be unique.
	NamespaceIds         []string `protobuf:"bytes,2,rep,name=namespace_ids,json=namespaceIds,proto3" json:"namespace_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EntityFilter) Reset()         { *m = EntityFilter{} }
func (m *EntityFilter) String() string { return proto.CompactTextString(m) }
func (*EntityFilter) ProtoMessage()    {}
func (*EntityFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_891b89db06fa8774, []int{7}
}

func (m *EntityFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EntityFilter.Unmarshal(m, b)
}
func (m *EntityFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EntityFilter.Marshal(b, m, deterministic)
}
func (m *EntityFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EntityFilter.Merge(m, src)
}
func (m *EntityFilter) XXX_Size() int {
	return xxx_messageInfo_EntityFilter.Size(m)
}
func (m *EntityFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_EntityFilter.DiscardUnknown(m)
}

var xxx_messageInfo_EntityFilter proto.InternalMessageInfo

func (m *EntityFilter) GetKinds() []string {
	if m != nil {
		return m.Kinds
	}
	return nil
}

func (m *EntityFilter) GetNamespaceIds() []string {
	if m != nil {
		return m.NamespaceIds
	}
	return nil
}

// The request for [google.datastore.admin.v1.DatastoreAdmin.GetIndex][google.datastore.admin.v1.DatastoreAdmin.GetIndex].
type GetIndexRequest struct {
	// Project ID against which to make the request.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The resource ID of the index to get.
	IndexId              string   `protobuf:"bytes,3,opt,name=index_id,json=indexId,proto3" json:"index_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetIndexRequest) Reset()         { *m = GetIndexRequest{} }
func (m *GetIndexRequest) String() string { return proto.CompactTextString(m) }
func (*GetIndexRequest) ProtoMessage()    {}
func (*GetIndexRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_891b89db06fa8774, []int{8}
}

func (m *GetIndexRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetIndexRequest.Unmarshal(m, b)
}
func (m *GetIndexRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetIndexRequest.Marshal(b, m, deterministic)
}
func (m *GetIndexRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetIndexRequest.Merge(m, src)
}
func (m *GetIndexRequest) XXX_Size() int {
	return xxx_messageInfo_GetIndexRequest.Size(m)
}
func (m *GetIndexRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetIndexRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetIndexRequest proto.InternalMessageInfo

func (m *GetIndexRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *GetIndexRequest) GetIndexId() string {
	if m != nil {
		return m.IndexId
	}
	return ""
}

// The request for
// [google.datastore.admin.v1.DatastoreAdmin.ListIndexes][google.datastore.admin.v1.DatastoreAdmin.ListIndexes].
type ListIndexesRequest struct {
	// Project ID against which to make the request.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	Filter    string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of items to return.  If zero, then all results will be
	// returned.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken            string   `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListIndexesRequest) Reset()         { *m = ListIndexesRequest{} }
func (m *ListIndexesRequest) String() string { return proto.CompactTextString(m) }
func (*ListIndexesRequest) ProtoMessage()    {}
func (*ListIndexesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_891b89db06fa8774, []int{9}
}

func (m *ListIndexesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListIndexesRequest.Unmarshal(m, b)
}
func (m *ListIndexesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListIndexesRequest.Marshal(b, m, deterministic)
}
func (m *ListIndexesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListIndexesRequest.Merge(m, src)
}
func (m *ListIndexesRequest) XXX_Size() int {
	return xxx_messageInfo_ListIndexesRequest.Size(m)
}
func (m *ListIndexesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListIndexesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListIndexesRequest proto.InternalMessageInfo

func (m *ListIndexesRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ListIndexesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListIndexesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListIndexesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response for
// [google.datastore.admin.v1.DatastoreAdmin.ListIndexes][google.datastore.admin.v1.DatastoreAdmin.ListIndexes].
type ListIndexesResponse struct {
	// The indexes.
	Indexes []*Index `protobuf:"bytes,1,rep,name=indexes,proto3" json:"indexes,omitempty"`
	// The standard List next-page token.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListIndexesResponse) Reset()         { *m = ListIndexesResponse{} }
func (m *ListIndexesResponse) String() string { return proto.CompactTextString(m) }
func (*ListIndexesResponse) ProtoMessage()    {}
func (*ListIndexesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_891b89db06fa8774, []int{10}
}

func (m *ListIndexesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListIndexesResponse.Unmarshal(m, b)
}
func (m *ListIndexesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListIndexesResponse.Marshal(b, m, deterministic)
}
func (m *ListIndexesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListIndexesResponse.Merge(m, src)
}
func (m *ListIndexesResponse) XXX_Size() int {
	return xxx_messageInfo_ListIndexesResponse.Size(m)
}
func (m *ListIndexesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListIndexesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListIndexesResponse proto.InternalMessageInfo

func (m *ListIndexesResponse) GetIndexes() []*Index {
	if m != nil {
		return m.Indexes
	}
	return nil
}

func (m *ListIndexesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Metadata for Index operations.
type IndexOperationMetadata struct {
	// Metadata common to all Datastore Admin operations.
	Common *CommonMetadata `protobuf:"bytes,1,opt,name=common,proto3" json:"common,omitempty"`
	// An estimate of the number of entities processed.
	ProgressEntities *Progress `protobuf:"bytes,2,opt,name=progress_entities,json=progressEntities,proto3" json:"progress_entities,omitempty"`
	// The index resource ID that this operation is acting on.
	IndexId              string   `protobuf:"bytes,3,opt,name=index_id,json=indexId,proto3" json:"index_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IndexOperationMetadata) Reset()         { *m = IndexOperationMetadata{} }
func (m *IndexOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*IndexOperationMetadata) ProtoMessage()    {}
func (*IndexOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_891b89db06fa8774, []int{11}
}

func (m *IndexOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IndexOperationMetadata.Unmarshal(m, b)
}
func (m *IndexOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IndexOperationMetadata.Marshal(b, m, deterministic)
}
func (m *IndexOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IndexOperationMetadata.Merge(m, src)
}
func (m *IndexOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_IndexOperationMetadata.Size(m)
}
func (m *IndexOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_IndexOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_IndexOperationMetadata proto.InternalMessageInfo

func (m *IndexOperationMetadata) GetCommon() *CommonMetadata {
	if m != nil {
		return m.Common
	}
	return nil
}

func (m *IndexOperationMetadata) GetProgressEntities() *Progress {
	if m != nil {
		return m.ProgressEntities
	}
	return nil
}

func (m *IndexOperationMetadata) GetIndexId() string {
	if m != nil {
		return m.IndexId
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.datastore.admin.v1.OperationType", OperationType_name, OperationType_value)
	proto.RegisterEnum("google.datastore.admin.v1.CommonMetadata_State", CommonMetadata_State_name, CommonMetadata_State_value)
	proto.RegisterType((*CommonMetadata)(nil), "google.datastore.admin.v1.CommonMetadata")
	proto.RegisterMapType((map[string]string)(nil), "google.datastore.admin.v1.CommonMetadata.LabelsEntry")
	proto.RegisterType((*Progress)(nil), "google.datastore.admin.v1.Progress")
	proto.RegisterType((*ExportEntitiesRequest)(nil), "google.datastore.admin.v1.ExportEntitiesRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.datastore.admin.v1.ExportEntitiesRequest.LabelsEntry")
	proto.RegisterType((*ImportEntitiesRequest)(nil), "google.datastore.admin.v1.ImportEntitiesRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.datastore.admin.v1.ImportEntitiesRequest.LabelsEntry")
	proto.RegisterType((*ExportEntitiesResponse)(nil), "google.datastore.admin.v1.ExportEntitiesResponse")
	proto.RegisterType((*ExportEntitiesMetadata)(nil), "google.datastore.admin.v1.ExportEntitiesMetadata")
	proto.RegisterType((*ImportEntitiesMetadata)(nil), "google.datastore.admin.v1.ImportEntitiesMetadata")
	proto.RegisterType((*EntityFilter)(nil), "google.datastore.admin.v1.EntityFilter")
	proto.RegisterType((*GetIndexRequest)(nil), "google.datastore.admin.v1.GetIndexRequest")
	proto.RegisterType((*ListIndexesRequest)(nil), "google.datastore.admin.v1.ListIndexesRequest")
	proto.RegisterType((*ListIndexesResponse)(nil), "google.datastore.admin.v1.ListIndexesResponse")
	proto.RegisterType((*IndexOperationMetadata)(nil), "google.datastore.admin.v1.IndexOperationMetadata")
}

func init() {
	proto.RegisterFile("google/datastore/admin/v1/datastore_admin.proto", fileDescriptor_891b89db06fa8774)
}

var fileDescriptor_891b89db06fa8774 = []byte{
	// 1370 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x57, 0x4b, 0x6f, 0x1b, 0x55,
	0x14, 0x66, 0xec, 0x38, 0x89, 0x4f, 0x62, 0xc7, 0xbd, 0x25, 0xc1, 0x35, 0x84, 0x9a, 0x89, 0x0a,
	0x69, 0x94, 0xce, 0x34, 0x81, 0x0a, 0x1a, 0x10, 0xd2, 0xc4, 0x99, 0x54, 0x03, 0xae, 0x63, 0x8d,
	0x1d, 0x14, 0xba, 0x19, 0x4d, 0xec, 0x1b, 0x77, 0xc8, 0xbc, 0x98, 0xb9, 0x4e, 0xe2, 0x56, 0xdd,
	0xb0, 0x41, 0x08, 0x89, 0x05, 0x2c, 0x60, 0xc1, 0x2f, 0x60, 0xc9, 0x9a, 0x1f, 0x80, 0xca, 0x0e,
	0x76, 0x5d, 0xb1, 0xe8, 0x96, 0x15, 0x12, 0x6b, 0x74, 0xef, 0x3c, 0xfc, 0x88, 0x1f, 0x81, 0x22,
	0xc4, 0x82, 0x9d, 0xcf, 0xb9, 0xe7, 0x3b, 0xaf, 0x7b, 0xcf, 0xe7, 0x33, 0x20, 0xb6, 0x1c, 0xa7,
	0x65, 0x62, 0xb1, 0xa9, 0x13, 0xdd, 0x27, 0x8e, 0x87, 0x45, 0xbd, 0x69, 0x19, 0xb6, 0x78, 0xb2,
	0xd1, 0x55, 0x69, 0x4c, 0x25, 0xb8, 0x9e, 0x43, 0x1c, 0x74, 0x25, 0x00, 0x08, 0xf1, 0xa9, 0x10,
	0x9c, 0x9e, 0x6c, 0x14, 0x5e, 0x0a, 0x7d, 0xe9, 0xae, 0x21, 0xea, 0xb6, 0xed, 0x10, 0x9d, 0x18,
	0x8e, 0xed, 0x07, 0xc0, 0xc2, 0x0b, 0x3d, 0xa7, 0x0d, 0xd3, 0xc0, 0x36, 0x09, 0x0f, 0xae, 0xf6,
	0x1c, 0x1c, 0x19, 0xd8, 0x6c, 0x6a, 0x87, 0xf8, 0xbe, 0x7e, 0x62, 0x38, 0x5e, 0x68, 0x70, 0x6d,
	0x74, 0x8e, 0x86, 0xdd, 0xc4, 0x67, 0xa1, 0xd9, 0x4a, 0x68, 0x66, 0x3a, 0x76, 0xcb, 0x6b, 0xdb,
	0xb6, 0x61, 0xb7, 0x44, 0xc7, 0xc5, 0x5e, 0x5f, 0x16, 0x51, 0x30, 0x26, 0x1d, 0xb6, 0x8f, 0x44,
	0x62, 0x58, 0xd8, 0x27, 0xba, 0xe5, 0x06, 0x06, 0xfc, 0xf7, 0x53, 0x90, 0x2d, 0x39, 0x96, 0xe5,
	0xd8, 0x77, 0x31, 0xd1, 0x69, 0x48, 0x74, 0x1b, 0xc0, 0x27, 0xba, 0x47, 0x34, 0x6a, 0x9b, 0xe7,
	0x8a, 0xdc, 0xea, 0xdc, 0x66, 0x41, 0x08, 0xfb, 0x10, 0x39, 0x12, 0xea, 0x91, 0x23, 0x35, 0xcd,
	0xac, 0xa9, 0x8c, 0x6e, 0xc1, 0x2c, 0xb6, 0x9b, 0x01, 0x30, 0x31, 0x11, 0x38, 0x83, 0xed, 0x26,
	0x83, 0xed, 0x41, 0x36, 0xce, 0x5c, 0x23, 0x1d, 0x17, 0xe7, 0x93, 0x45, 0x6e, 0x35, 0xbb, 0xb9,
	0x2a, 0x8c, 0xec, 0xbe, 0xb0, 0x17, 0x01, 0xea, 0x1d, 0x17, 0xab, 0x19, 0xa7, 0x57, 0x44, 0x77,
	0x61, 0xda, 0xd4, 0x0f, 0xb1, 0xe9, 0xe7, 0xa7, 0x8a, 0xc9, 0xd5, 0xb9, 0xcd, 0x5b, 0x63, 0x1c,
	0xf5, 0x57, 0x2f, 0x94, 0x19, 0x4e, 0xb6, 0x89, 0xd7, 0x51, 0x43, 0x27, 0x48, 0x86, 0x94, 0x4f,
	0x74, 0x82, 0xf3, 0x29, 0x96, 0x96, 0x78, 0x71, 0x6f, 0x35, 0x0a, 0x53, 0x03, 0x74, 0xe1, 0x36,
	0xcc, 0xf5, 0x78, 0x47, 0x39, 0x48, 0x1e, 0xe3, 0x0e, 0x6b, 0x70, 0x5a, 0xa5, 0x3f, 0xd1, 0xf3,
	0x90, 0x3a, 0xd1, 0xcd, 0x76, 0xd0, 0xbb, 0xb4, 0x1a, 0x08, 0x5b, 0x89, 0xb7, 0x38, 0xfe, 0x73,
	0x0e, 0x52, 0xcc, 0x17, 0x5a, 0x84, 0x4b, 0xb5, 0xba, 0x54, 0x97, 0xb5, 0xfd, 0x4a, 0xad, 0x2a,
	0x97, 0x94, 0x5d, 0x45, 0xde, 0xc9, 0x3d, 0x87, 0x72, 0x30, 0xaf, 0x54, 0x94, 0xba, 0x22, 0x95,
	0x95, 0x7b, 0x4a, 0xe5, 0x4e, 0x8e, 0x43, 0x59, 0x80, 0xaa, 0xba, 0x57, 0x92, 0x6b, 0x35, 0x2a,
	0x27, 0xa8, 0x5c, 0x92, 0x2a, 0x25, 0xb9, 0x5c, 0xa6, 0x72, 0x92, 0xca, 0xbb, 0x4a, 0x25, 0xb2,
	0x9f, 0xa2, 0x72, 0x6d, 0xbf, 0x44, 0xed, 0x77, 0xf7, 0xcb, 0xb9, 0x14, 0x02, 0x98, 0xde, 0x95,
	0x94, 0xb2, 0xbc, 0x93, 0x9b, 0x46, 0x19, 0x48, 0x87, 0x58, 0x79, 0x27, 0x37, 0xc3, 0x1f, 0xc0,
	0x6c, 0xd5, 0x73, 0x5a, 0x1e, 0xf6, 0x7d, 0x74, 0x0d, 0xb2, 0xa7, 0x8e, 0x77, 0xac, 0x35, 0x1c,
	0xcb, 0x35, 0x31, 0xc1, 0x4d, 0x56, 0x50, 0x52, 0xcd, 0x50, 0x6d, 0x29, 0x52, 0xc6, 0x66, 0xd8,
	0x27, 0x86, 0xa5, 0x53, 0xb3, 0x44, 0xd7, 0x4c, 0x8e, 0x94, 0xfc, 0x4f, 0x09, 0x58, 0x94, 0xcf,
	0x5c, 0xc7, 0x23, 0xb2, 0x4d, 0x0c, 0x62, 0x60, 0x5f, 0xc5, 0x1f, 0xb7, 0xb1, 0x4f, 0x10, 0x0f,
	0xe0, 0x7a, 0xce, 0x47, 0xb8, 0x41, 0x34, 0x23, 0x88, 0x91, 0xde, 0x4e, 0xfe, 0x2a, 0x25, 0xd4,
	0x74, 0xa8, 0x56, 0x9a, 0xa8, 0x1e, 0x5f, 0x7b, 0x82, 0x5d, 0xfb, 0x3b, 0x63, 0x2e, 0x6a, 0x68,
	0x94, 0xa1, 0xb7, 0x5f, 0x86, 0x0c, 0xa6, 0x66, 0x1d, 0xed, 0xc8, 0x30, 0x09, 0xf6, 0xd8, 0xe3,
	0x9c, 0xdb, 0x7c, 0x6d, 0x9c, 0x73, 0x66, 0xbf, 0xcb, 0xcc, 0xd5, 0x79, 0xdc, 0x23, 0x21, 0x11,
	0x2e, 0x39, 0x6d, 0xe2, 0xb6, 0x89, 0xd6, 0xf6, 0x4c, 0xcd, 0xf5, 0xf0, 0x91, 0x71, 0x96, 0x9f,
	0xea, 0x96, 0xb3, 0x10, 0x9c, 0xee, 0x7b, 0x66, 0x95, 0x9d, 0x3d, 0xcb, 0xab, 0xf9, 0x21, 0x01,
	0x8b, 0x8a, 0xf5, 0x6f, 0x74, 0x73, 0x68, 0x94, 0xa1, 0xdd, 0x2c, 0x42, 0xda, 0xb0, 0xc3, 0xf2,
	0x59, 0x27, 0xc3, 0xc0, 0xb3, 0x4c, 0xbb, 0xef, 0x99, 0xe7, 0xfb, 0x3d, 0xf5, 0x0c, 0xfd, 0x7e,
	0x96, 0xf6, 0xbd, 0x09, 0x4b, 0x83, 0xaf, 0xc4, 0x77, 0x1d, 0xdb, 0xc7, 0x68, 0x19, 0xa0, 0x7b,
	0x89, 0xa1, 0xb3, 0x74, 0x7c, 0x71, 0xfc, 0xef, 0x89, 0x41, 0x64, 0x4c, 0xae, 0x12, 0x4c, 0x37,
	0x18, 0x45, 0x84, 0xc4, 0x7a, 0xfd, 0xc2, 0x5c, 0xa2, 0x86, 0x40, 0x54, 0x85, 0x4b, 0x6e, 0x38,
	0x7d, 0x1a, 0x0e, 0xfd, 0x87, 0x6c, 0xbb, 0x32, 0xc6, 0x5b, 0x34, 0xb1, 0x6a, 0x2e, 0x42, 0x47,
	0xc9, 0xa1, 0xf7, 0x20, 0x1b, 0x7b, 0x3c, 0xec, 0x10, 0xec, 0x87, 0x4f, 0xfc, 0x42, 0xee, 0x32,
	0x11, 0x74, 0x9b, 0x22, 0xff, 0xd9, 0xdb, 0x43, 0x6b, 0xc3, 0xa6, 0x25, 0xc5, 0xfa, 0x3d, 0x38,
	0x28, 0xfc, 0xd3, 0x04, 0x2c, 0xf5, 0xbf, 0xc3, 0xff, 0xbb, 0xfe, 0xf7, 0xba, 0xfe, 0x62, 0xef,
	0x8c, 0x06, 0xdd, 0x8e, 0xc7, 0x93, 0x57, 0x60, 0xbe, 0x17, 0x4a, 0xe7, 0xe7, 0xd8, 0xb0, 0x9b,
	0x7e, 0x9e, 0x2b, 0x26, 0xe9, 0xfc, 0x30, 0x01, 0xad, 0x40, 0xc6, 0xd6, 0x2d, 0xec, 0xbb, 0x7a,
	0x03, 0x6b, 0x46, 0x33, 0xe0, 0x90, 0xb4, 0x3a, 0x1f, 0x2b, 0x95, 0xa6, 0xcf, 0xbf, 0x0f, 0x0b,
	0x77, 0x30, 0x51, 0xe8, 0x52, 0x13, 0x11, 0xd3, 0xf2, 0x79, 0x62, 0xea, 0xe5, 0xa4, 0x2b, 0x30,
	0xcb, 0x76, 0x20, 0x7a, 0xc8, 0xc8, 0x43, 0x9d, 0x61, 0xb2, 0xd2, 0xe4, 0x3f, 0xe5, 0x00, 0x95,
	0x0d, 0x3f, 0x70, 0xd7, 0x65, 0xba, 0x09, 0x0e, 0x97, 0x60, 0xba, 0x87, 0xd5, 0xd3, 0x6a, 0x28,
	0xd1, 0x16, 0xb8, 0x7a, 0x0b, 0x6b, 0xbe, 0xf1, 0x00, 0xb3, 0x66, 0xa6, 0xd4, 0x59, 0xaa, 0xa8,
	0x19, 0x0f, 0xd8, 0xf8, 0xb3, 0x43, 0xe2, 0x1c, 0x63, 0x3b, 0x6c, 0x10, 0x33, 0xaf, 0x53, 0x05,
	0xdf, 0x81, 0xcb, 0x7d, 0x89, 0x84, 0xa4, 0xb1, 0x05, 0x41, 0xae, 0x38, 0x68, 0xd5, 0xdc, 0x66,
	0x71, 0x1c, 0xa1, 0xb2, 0xa6, 0x44, 0x00, 0xf4, 0x2a, 0x2c, 0xd8, 0xf8, 0x8c, 0x68, 0x3d, 0x61,
	0x03, 0xba, 0xca, 0x50, 0x75, 0x35, 0x0e, 0xfd, 0x23, 0x07, 0x4b, 0x0c, 0x1a, 0xaf, 0x47, 0xff,
	0xed, 0x19, 0x18, 0x7d, 0x9f, 0x6b, 0x8f, 0x20, 0xd3, 0xb7, 0xe3, 0xa1, 0x97, 0xa1, 0xb0, 0x57,
	0x95, 0x55, 0xa9, 0xae, 0xec, 0x55, 0xb4, 0xfa, 0x87, 0xd5, 0xc1, 0x15, 0xe8, 0x32, 0x2c, 0xc8,
	0x07, 0xd5, 0x3d, 0xb5, 0xae, 0xc9, 0x95, 0xba, 0x52, 0x57, 0xe4, 0x5a, 0x8e, 0xa3, 0x4a, 0xe5,
	0x6e, 0xbf, 0x32, 0x41, 0x97, 0xa5, 0x92, 0x2a, 0xd3, 0x25, 0x4a, 0xa9, 0xec, 0xc8, 0x07, 0xb9,
	0x24, 0xd5, 0xec, 0xc8, 0x65, 0x39, 0xd6, 0x4c, 0x6d, 0x7e, 0x3b, 0x03, 0xd9, 0x9d, 0xa8, 0x16,
	0x89, 0x96, 0x82, 0xfe, 0xe0, 0x20, 0xdb, 0x4f, 0xeb, 0xe8, 0xe6, 0x5f, 0xdd, 0x30, 0x0a, 0xcb,
	0x11, 0xa2, 0x67, 0x6f, 0xef, 0x2e, 0xb3, 0xfc, 0x97, 0xdc, 0x63, 0xe9, 0xe6, 0xc8, 0xff, 0x9d,
	0x11, 0xff, 0x2a, 0x4f, 0xa4, 0x8d, 0xee, 0x1b, 0x5f, 0x0f, 0xfe, 0x68, 0xd7, 0xfb, 0xf8, 0x60,
	0xfd, 0x1c, 0x8b, 0x7e, 0xf2, 0xcb, 0xd3, 0xaf, 0x12, 0xd7, 0xf8, 0x22, 0xfd, 0xac, 0x08, 0xc1,
	0xbe, 0xf8, 0xb0, 0xeb, 0xe6, 0xd1, 0x16, 0x66, 0xb1, 0xb6, 0xb8, 0x35, 0xf4, 0x1b, 0x07, 0xd9,
	0x7e, 0x66, 0x1d, 0x5b, 0xf8, 0xd0, 0x65, 0x60, 0x52, 0xe1, 0x9f, 0x71, 0x8f, 0x25, 0x11, 0x16,
	0x07, 0xbf, 0x16, 0x64, 0xcb, 0x25, 0x1d, 0x34, 0x82, 0xd7, 0x9f, 0x48, 0xd7, 0xcf, 0xd7, 0x1d,
	0x33, 0x57, 0x7f, 0x07, 0x26, 0xd7, 0x6b, 0x58, 0x51, 0xbd, 0x5f, 0x70, 0x30, 0x1b, 0x11, 0x13,
	0x5a, 0x1b, 0x53, 0xe9, 0x00, 0x7b, 0x15, 0x26, 0x4e, 0x34, 0xff, 0x06, 0xcb, 0x43, 0x40, 0xeb,
	0x23, 0xf3, 0x10, 0xc3, 0x99, 0x17, 0x1f, 0x46, 0x93, 0xf1, 0x08, 0x7d, 0xcd, 0xc1, 0x5c, 0x0f,
	0xa5, 0xa0, 0x1b, 0x63, 0xe2, 0x9c, 0xe7, 0xc0, 0x82, 0x70, 0x51, 0xf3, 0xe0, 0x99, 0xf1, 0xd7,
	0x59, 0x92, 0x2b, 0xe8, 0x95, 0x89, 0x49, 0x16, 0x4e, 0x1e, 0x4b, 0xf9, 0xae, 0xd7, 0x20, 0x8c,
	0xee, 0x1a, 0xbe, 0xd0, 0x70, 0xac, 0x9f, 0xa5, 0x83, 0xfb, 0x84, 0xb8, 0xfe, 0x96, 0x28, 0x9e,
	0x9e, 0x9e, 0x0e, 0x1c, 0x8a, 0x7a, 0x9b, 0xdc, 0x17, 0x1b, 0xa6, 0xd3, 0x6e, 0xde, 0x70, 0x4d,
	0x9d, 0x1c, 0x39, 0x9e, 0xb5, 0x3e, 0xc9, 0x3c, 0x8e, 0xb4, 0xfd, 0x0d, 0x07, 0xcb, 0x0d, 0xc7,
	0x1a, 0x5d, 0xd8, 0xf6, 0xe5, 0xfe, 0xe9, 0xad, 0xd2, 0x17, 0x55, 0xe5, 0xee, 0xbd, 0x1b, 0x22,
	0x5a, 0x8e, 0xa9, 0xdb, 0x2d, 0xc1, 0xf1, 0x5a, 0x62, 0x0b, 0xdb, 0xec, 0xbd, 0x89, 0xdd, 0x90,
	0x43, 0x3e, 0xbe, 0xdf, 0x66, 0x3f, 0xbe, 0x4b, 0x5c, 0xbd, 0x13, 0x38, 0x28, 0xd1, 0xd4, 0x85,
	0x38, 0x88, 0xc0, 0xa2, 0x08, 0x1f, 0x6c, 0x1c, 0x4e, 0x33, 0x67, 0xaf, 0xff, 0x19, 0x00, 0x00,
	0xff, 0xff, 0x18, 0xf8, 0x31, 0x9d, 0x6c, 0x10, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DatastoreAdminClient is the client API for DatastoreAdmin service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DatastoreAdminClient interface {
	// Exports a copy of all or a subset of entities from Google Cloud Datastore
	// to another storage system, such as Google Cloud Storage. Recent updates to
	// entities may not be reflected in the export. The export occurs in the
	// background and its progress can be monitored and managed via the
	// Operation resource that is created. The output of an export may only be
	// used once the associated operation is done. If an export operation is
	// cancelled before completion it may leave partial data behind in Google
	// Cloud Storage.
	ExportEntities(ctx context.Context, in *ExportEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Imports entities into Google Cloud Datastore. Existing entities with the
	// same key are overwritten. The import occurs in the background and its
	// progress can be monitored and managed via the Operation resource that is
	// created. If an ImportEntities operation is cancelled, it is possible
	// that a subset of the data has already been imported to Cloud Datastore.
	ImportEntities(ctx context.Context, in *ImportEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets an index.
	GetIndex(ctx context.Context, in *GetIndexRequest, opts ...grpc.CallOption) (*Index, error)
	// Lists the indexes that match the specified filters.  Datastore uses an
	// eventually consistent query to fetch the list of indexes and may
	// occasionally return stale results.
	ListIndexes(ctx context.Context, in *ListIndexesRequest, opts ...grpc.CallOption) (*ListIndexesResponse, error)
}

type datastoreAdminClient struct {
	cc grpc.ClientConnInterface
}

func NewDatastoreAdminClient(cc grpc.ClientConnInterface) DatastoreAdminClient {
	return &datastoreAdminClient{cc}
}

func (c *datastoreAdminClient) ExportEntities(ctx context.Context, in *ExportEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.datastore.admin.v1.DatastoreAdmin/ExportEntities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreAdminClient) ImportEntities(ctx context.Context, in *ImportEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.datastore.admin.v1.DatastoreAdmin/ImportEntities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreAdminClient) GetIndex(ctx context.Context, in *GetIndexRequest, opts ...grpc.CallOption) (*Index, error) {
	out := new(Index)
	err := c.cc.Invoke(ctx, "/google.datastore.admin.v1.DatastoreAdmin/GetIndex", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreAdminClient) ListIndexes(ctx context.Context, in *ListIndexesRequest, opts ...grpc.CallOption) (*ListIndexesResponse, error) {
	out := new(ListIndexesResponse)
	err := c.cc.Invoke(ctx, "/google.datastore.admin.v1.DatastoreAdmin/ListIndexes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DatastoreAdminServer is the server API for DatastoreAdmin service.
type DatastoreAdminServer interface {
	// Exports a copy of all or a subset of entities from Google Cloud Datastore
	// to another storage system, such as Google Cloud Storage. Recent updates to
	// entities may not be reflected in the export. The export occurs in the
	// background and its progress can be monitored and managed via the
	// Operation resource that is created. The output of an export may only be
	// used once the associated operation is done. If an export operation is
	// cancelled before completion it may leave partial data behind in Google
	// Cloud Storage.
	ExportEntities(context.Context, *ExportEntitiesRequest) (*longrunning.Operation, error)
	// Imports entities into Google Cloud Datastore. Existing entities with the
	// same key are overwritten. The import occurs in the background and its
	// progress can be monitored and managed via the Operation resource that is
	// created. If an ImportEntities operation is cancelled, it is possible
	// that a subset of the data has already been imported to Cloud Datastore.
	ImportEntities(context.Context, *ImportEntitiesRequest) (*longrunning.Operation, error)
	// Gets an index.
	GetIndex(context.Context, *GetIndexRequest) (*Index, error)
	// Lists the indexes that match the specified filters.  Datastore uses an
	// eventually consistent query to fetch the list of indexes and may
	// occasionally return stale results.
	ListIndexes(context.Context, *ListIndexesRequest) (*ListIndexesResponse, error)
}

// UnimplementedDatastoreAdminServer can be embedded to have forward compatible implementations.
type UnimplementedDatastoreAdminServer struct {
}

func (*UnimplementedDatastoreAdminServer) ExportEntities(ctx context.Context, req *ExportEntitiesRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportEntities not implemented")
}
func (*UnimplementedDatastoreAdminServer) ImportEntities(ctx context.Context, req *ImportEntitiesRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportEntities not implemented")
}
func (*UnimplementedDatastoreAdminServer) GetIndex(ctx context.Context, req *GetIndexRequest) (*Index, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIndex not implemented")
}
func (*UnimplementedDatastoreAdminServer) ListIndexes(ctx context.Context, req *ListIndexesRequest) (*ListIndexesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListIndexes not implemented")
}

func RegisterDatastoreAdminServer(s *grpc.Server, srv DatastoreAdminServer) {
	s.RegisterService(&_DatastoreAdmin_serviceDesc, srv)
}

func _DatastoreAdmin_ExportEntities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportEntitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreAdminServer).ExportEntities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.admin.v1.DatastoreAdmin/ExportEntities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreAdminServer).ExportEntities(ctx, req.(*ExportEntitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatastoreAdmin_ImportEntities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportEntitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreAdminServer).ImportEntities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.admin.v1.DatastoreAdmin/ImportEntities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreAdminServer).ImportEntities(ctx, req.(*ImportEntitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatastoreAdmin_GetIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreAdminServer).GetIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.admin.v1.DatastoreAdmin/GetIndex",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreAdminServer).GetIndex(ctx, req.(*GetIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatastoreAdmin_ListIndexes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIndexesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreAdminServer).ListIndexes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.admin.v1.DatastoreAdmin/ListIndexes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreAdminServer).ListIndexes(ctx, req.(*ListIndexesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DatastoreAdmin_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.datastore.admin.v1.DatastoreAdmin",
	HandlerType: (*DatastoreAdminServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ExportEntities",
			Handler:    _DatastoreAdmin_ExportEntities_Handler,
		},
		{
			MethodName: "ImportEntities",
			Handler:    _DatastoreAdmin_ImportEntities_Handler,
		},
		{
			MethodName: "GetIndex",
			Handler:    _DatastoreAdmin_GetIndex_Handler,
		},
		{
			MethodName: "ListIndexes",
			Handler:    _DatastoreAdmin_ListIndexes_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/datastore/admin/v1/datastore_admin.proto",
}
