// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/irm/v1alpha2/incidents.proto

package irm

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Describes whether the alerting condition is still firing.
type Signal_State int32

const (
	// Unspecified
	Signal_STATE_UNSPECIFIED Signal_State = 0
	// Firing
	Signal_STATE_OPEN Signal_State = 1
	// Non-firing
	Signal_STATE_CLOSED Signal_State = 2
)

var Signal_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "STATE_OPEN",
	2: "STATE_CLOSED",
}

var Signal_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"STATE_OPEN":        1,
	"STATE_CLOSED":      2,
}

func (x Signal_State) String() string {
	return proto.EnumName(Signal_State_name, int32(x))
}

func (Signal_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{1, 0}
}

// Specifies the escalation level of this incident, within the IRM protocol
// for handling incidents.
type Incident_EscalationLevel int32

const (
	// The incident has not been escalated. This is the value used by all new
	// and legacy incidents.
	Incident_ESCALATION_LEVEL_UNSPECIFIED Incident_EscalationLevel = 0
	// The incident has been escalated to the organizational level.
	Incident_ESCALATION_LEVEL_ORGANIZATION Incident_EscalationLevel = 1
)

var Incident_EscalationLevel_name = map[int32]string{
	0: "ESCALATION_LEVEL_UNSPECIFIED",
	1: "ESCALATION_LEVEL_ORGANIZATION",
}

var Incident_EscalationLevel_value = map[string]int32{
	"ESCALATION_LEVEL_UNSPECIFIED":  0,
	"ESCALATION_LEVEL_ORGANIZATION": 1,
}

func (x Incident_EscalationLevel) String() string {
	return proto.EnumName(Incident_EscalationLevel_name, int32(x))
}

func (Incident_EscalationLevel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{5, 0}
}

// Severity of an incident.
type Incident_Severity int32

const (
	// Severity is not specified.
	Incident_SEVERITY_UNSPECIFIED Incident_Severity = 0
	// Huge incident.
	Incident_SEVERITY_HUGE Incident_Severity = 1
	// Major incident.
	Incident_SEVERITY_MAJOR Incident_Severity = 2
	// Medium incident.
	Incident_SEVERITY_MEDIUM Incident_Severity = 3
	// Minor incident.
	Incident_SEVERITY_MINOR Incident_Severity = 4
	// Negligible incident.
	Incident_SEVERITY_NEGLIGIBLE Incident_Severity = 5
)

var Incident_Severity_name = map[int32]string{
	0: "SEVERITY_UNSPECIFIED",
	1: "SEVERITY_HUGE",
	2: "SEVERITY_MAJOR",
	3: "SEVERITY_MEDIUM",
	4: "SEVERITY_MINOR",
	5: "SEVERITY_NEGLIGIBLE",
}

var Incident_Severity_value = map[string]int32{
	"SEVERITY_UNSPECIFIED": 0,
	"SEVERITY_HUGE":        1,
	"SEVERITY_MAJOR":       2,
	"SEVERITY_MEDIUM":      3,
	"SEVERITY_MINOR":       4,
	"SEVERITY_NEGLIGIBLE":  5,
}

func (x Incident_Severity) String() string {
	return proto.EnumName(Incident_Severity_name, int32(x))
}

func (Incident_Severity) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{5, 1}
}

// Stage of an incident.
type Incident_Stage int32

const (
	// This is the default value if no stage has been specified.
	// Note: The caller of the API should set the stage to DETECTED.
	Incident_STAGE_UNSPECIFIED Incident_Stage = 0
	// The incident has been detected. This is the initial stage of a new
	// incident.
	// Note: The caller still has to set the stage manually.
	Incident_STAGE_DETECTED Incident_Stage = 4
	// This incident has been formally characterized.
	Incident_STAGE_TRIAGED Incident_Stage = 1
	// This incident has been mitigated, i.e. does not affect the service level
	// anymore.
	Incident_STAGE_MITIGATED Incident_Stage = 2
	// This incident has been fully resolved, i.e. there are no immediate
	// follow-up tasks.
	Incident_STAGE_RESOLVED Incident_Stage = 3
	// Postmortem for the incident was written.
	Incident_STAGE_DOCUMENTED Incident_Stage = 5
	// Stage for an incident with `duplicate_incident`. This incident is not
	// authoritative anymore and the `duplicate_incident` should be used to
	// determine the stage.
	Incident_STAGE_DUPLICATE Incident_Stage = 6
)

var Incident_Stage_name = map[int32]string{
	0: "STAGE_UNSPECIFIED",
	4: "STAGE_DETECTED",
	1: "STAGE_TRIAGED",
	2: "STAGE_MITIGATED",
	3: "STAGE_RESOLVED",
	5: "STAGE_DOCUMENTED",
	6: "STAGE_DUPLICATE",
}

var Incident_Stage_value = map[string]int32{
	"STAGE_UNSPECIFIED": 0,
	"STAGE_DETECTED":    4,
	"STAGE_TRIAGED":     1,
	"STAGE_MITIGATED":   2,
	"STAGE_RESOLVED":    3,
	"STAGE_DOCUMENTED":  5,
	"STAGE_DUPLICATE":   6,
}

func (x Incident_Stage) String() string {
	return proto.EnumName(Incident_Stage_name, int32(x))
}

func (Incident_Stage) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{5, 2}
}

// The type of channel/venue for incident communications.
type Incident_CommunicationVenue_ChannelType int32

const (
	// An unspecified communication channel.
	Incident_CommunicationVenue_CHANNEL_TYPE_UNSPECIFIED Incident_CommunicationVenue_ChannelType = 0
	// A communication channel that is represented by a generic URI.
	Incident_CommunicationVenue_CHANNEL_TYPE_URI Incident_CommunicationVenue_ChannelType = 1
	// A communication channel that represents a Slack channel.
	Incident_CommunicationVenue_CHANNEL_TYPE_SLACK Incident_CommunicationVenue_ChannelType = 5
)

var Incident_CommunicationVenue_ChannelType_name = map[int32]string{
	0: "CHANNEL_TYPE_UNSPECIFIED",
	1: "CHANNEL_TYPE_URI",
	5: "CHANNEL_TYPE_SLACK",
}

var Incident_CommunicationVenue_ChannelType_value = map[string]int32{
	"CHANNEL_TYPE_UNSPECIFIED": 0,
	"CHANNEL_TYPE_URI":         1,
	"CHANNEL_TYPE_SLACK":       5,
}

func (x Incident_CommunicationVenue_ChannelType) String() string {
	return proto.EnumName(Incident_CommunicationVenue_ChannelType_name, int32(x))
}

func (Incident_CommunicationVenue_ChannelType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{5, 0, 0}
}

// List of possible roles.
type IncidentRole_Type int32

const (
	// The role is unspecified.
	IncidentRole_TYPE_UNSPECIFIED IncidentRole_Type = 0
	// Incident Commander: Manages response plan, near-term and long-term
	// objectives, establishes priorities, and delegates tasks as needed.
	IncidentRole_TYPE_INCIDENT_COMMANDER IncidentRole_Type = 1
	// Communications Lead: Keeps everybody outside and within the response team
	// informed.
	IncidentRole_TYPE_COMMUNICATIONS_LEAD IncidentRole_Type = 2
	// Operations Lead: Figures out what to do, and gets it done.
	IncidentRole_TYPE_OPERATIONS_LEAD IncidentRole_Type = 3
	// External Customer Communications Lead: Responsible for communicating
	// incident details to customers/public.
	IncidentRole_TYPE_EXTERNAL_CUSTOMER_COMMUNICATIONS_LEAD IncidentRole_Type = 4
	// Primary Oncall: Responds to the initial page and handles all
	// responsibilities for pre-escalated incidents.
	IncidentRole_TYPE_PRIMARY_ONCALL IncidentRole_Type = 5
	// Secondary Oncall: Helps the primary oncall if necessary; mostly useful
	// for pre-escalated incidents.
	IncidentRole_TYPE_SECONDARY_ONCALL IncidentRole_Type = 6
	// User-specified roles. One example is a Planning Lead, who keeps track of
	// the incident. Another is an assistant Incident Commander.
	IncidentRole_TYPE_OTHER IncidentRole_Type = 7
)

var IncidentRole_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "TYPE_INCIDENT_COMMANDER",
	2: "TYPE_COMMUNICATIONS_LEAD",
	3: "TYPE_OPERATIONS_LEAD",
	4: "TYPE_EXTERNAL_CUSTOMER_COMMUNICATIONS_LEAD",
	5: "TYPE_PRIMARY_ONCALL",
	6: "TYPE_SECONDARY_ONCALL",
	7: "TYPE_OTHER",
}

var IncidentRole_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED":                           0,
	"TYPE_INCIDENT_COMMANDER":                    1,
	"TYPE_COMMUNICATIONS_LEAD":                   2,
	"TYPE_OPERATIONS_LEAD":                       3,
	"TYPE_EXTERNAL_CUSTOMER_COMMUNICATIONS_LEAD": 4,
	"TYPE_PRIMARY_ONCALL":                        5,
	"TYPE_SECONDARY_ONCALL":                      6,
	"TYPE_OTHER":                                 7,
}

func (x IncidentRole_Type) String() string {
	return proto.EnumName(IncidentRole_Type_name, int32(x))
}

func (IncidentRole_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{6, 0}
}

// Possible types of an artifact.
type Artifact_Type int32

const (
	// External type is unspecified.
	Artifact_TYPE_UNSPECIFIED Artifact_Type = 0
	// URL.
	Artifact_TYPE_URL Artifact_Type = 1
	// A JIRA issue.
	Artifact_TYPE_JIRA_ISSUE Artifact_Type = 4
)

var Artifact_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "TYPE_URL",
	4: "TYPE_JIRA_ISSUE",
}

var Artifact_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"TYPE_URL":         1,
	"TYPE_JIRA_ISSUE":  4,
}

func (x Artifact_Type) String() string {
	return proto.EnumName(Artifact_Type_name, int32(x))
}

func (Artifact_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{8, 0}
}

// Types of changes that users can subscribe to in an incident.
type Subscription_EventType int32

const (
	// An event_type that's not specified is an error.
	Subscription_EVENT_TYPE_UNSPECIFIED Subscription_EventType = 0
	// The incident's title has changed.
	Subscription_EVENT_TYPE_TITLE_CHANGE Subscription_EventType = 1
	// The incident's synopsis has changed.
	Subscription_EVENT_TYPE_SYNOPSIS_CHANGE Subscription_EventType = 2
	// The incident's stage has changed.
	Subscription_EVENT_TYPE_STAGE_CHANGE Subscription_EventType = 3
	// The incident's severity has changed.
	Subscription_EVENT_TYPE_SEVERITY_CHANGE Subscription_EventType = 4
	// A new annotation has been added to the incident.
	Subscription_EVENT_TYPE_ANNOTATION_ADD Subscription_EventType = 5
	// An annotation has been modified.
	Subscription_EVENT_TYPE_ANNOTATION_CHANGE Subscription_EventType = 6
)

var Subscription_EventType_name = map[int32]string{
	0: "EVENT_TYPE_UNSPECIFIED",
	1: "EVENT_TYPE_TITLE_CHANGE",
	2: "EVENT_TYPE_SYNOPSIS_CHANGE",
	3: "EVENT_TYPE_STAGE_CHANGE",
	4: "EVENT_TYPE_SEVERITY_CHANGE",
	5: "EVENT_TYPE_ANNOTATION_ADD",
	6: "EVENT_TYPE_ANNOTATION_CHANGE",
}

var Subscription_EventType_value = map[string]int32{
	"EVENT_TYPE_UNSPECIFIED":       0,
	"EVENT_TYPE_TITLE_CHANGE":      1,
	"EVENT_TYPE_SYNOPSIS_CHANGE":   2,
	"EVENT_TYPE_STAGE_CHANGE":      3,
	"EVENT_TYPE_SEVERITY_CHANGE":   4,
	"EVENT_TYPE_ANNOTATION_ADD":    5,
	"EVENT_TYPE_ANNOTATION_CHANGE": 6,
}

func (x Subscription_EventType) String() string {
	return proto.EnumName(Subscription_EventType_name, int32(x))
}

func (Subscription_EventType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{10, 0}
}

// A user of the IRM app.
type User struct {
	// One of several ways to uniquely identify a user.
	//
	// Types that are valid to be assigned to User:
	//	*User_UserId
	//	*User_Email
	User                 isUser_User `protobuf_oneof:"user"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *User) Reset()         { *m = User{} }
func (m *User) String() string { return proto.CompactTextString(m) }
func (*User) ProtoMessage()    {}
func (*User) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{0}
}

func (m *User) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_User.Unmarshal(m, b)
}
func (m *User) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_User.Marshal(b, m, deterministic)
}
func (m *User) XXX_Merge(src proto.Message) {
	xxx_messageInfo_User.Merge(m, src)
}
func (m *User) XXX_Size() int {
	return xxx_messageInfo_User.Size(m)
}
func (m *User) XXX_DiscardUnknown() {
	xxx_messageInfo_User.DiscardUnknown(m)
}

var xxx_messageInfo_User proto.InternalMessageInfo

type isUser_User interface {
	isUser_User()
}

type User_UserId struct {
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3,oneof"`
}

type User_Email struct {
	Email string `protobuf:"bytes,2,opt,name=email,proto3,oneof"`
}

func (*User_UserId) isUser_User() {}

func (*User_Email) isUser_User() {}

func (m *User) GetUser() isUser_User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *User) GetUserId() string {
	if x, ok := m.GetUser().(*User_UserId); ok {
		return x.UserId
	}
	return ""
}

func (m *User) GetEmail() string {
	if x, ok := m.GetUser().(*User_Email); ok {
		return x.Email
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*User) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*User_UserId)(nil),
		(*User_Email)(nil),
	}
}

// A signal is a message calling attention to a (potential) incident. An example
// is a page based on a Stackdriver Alerting policy.
type Signal struct {
	// Resource name of the signal, for example,
	// "projects/{project_id_or_number}/signals/{signal_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Etag to validate the object is unchanged for a read-modify-write operation.
	// An empty etag will overwrite other changes.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// Resource name of the incident this signal is currently assigned to.
	// May be empty if signal is unassigned.
	Incident string `protobuf:"bytes,3,opt,name=incident,proto3" json:"incident,omitempty"`
	// Output only. Time this signal was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time this signal was closed. This field is not populated
	// while the signal is still firing.
	CloseTime *timestamp.Timestamp `protobuf:"bytes,10,opt,name=close_time,json=closeTime,proto3" json:"close_time,omitempty"`
	// The time this Signal was first detected. This is identical to create_time
	// for Signals created by Stackdriver Alerting.
	DetectTime *timestamp.Timestamp `protobuf:"bytes,15,opt,name=detect_time,json=detectTime,proto3" json:"detect_time,omitempty"`
	// Output only. The user that created this signal for manually created
	// signals. Empty if this signal was generated by a system (for example,
	// Stackdriver Alerting).
	Creator *User `protobuf:"bytes,5,opt,name=creator,proto3" json:"creator,omitempty"`
	// One-line summary of the signal.
	// Immutable.
	Title string `protobuf:"bytes,6,opt,name=title,proto3" json:"title,omitempty"`
	// Content type string. 'text/plain' is currently the only supported content
	// type for Signals created via the API. Signals created by Stackdriver
	// Alerting support 'text/html' as well. Immutable for Signals created by
	// Stackdriver Alerting.
	ContentType string `protobuf:"bytes,7,opt,name=content_type,json=contentType,proto3" json:"content_type,omitempty"`
	// Full message of the signal.
	// Immutable for Signals created by Stackdriver Alerting.
	Content string `protobuf:"bytes,8,opt,name=content,proto3" json:"content,omitempty"`
	// The state of this signal.
	// For Signals created by Stackdriver Alerting this field is output only.
	SignalState Signal_State `protobuf:"varint,9,opt,name=signal_state,json=signalState,proto3,enum=google.cloud.irm.v1alpha2.Signal_State" json:"signal_state,omitempty"`
	// A set of artifacts to additional resources for this Signal. For example, a
	// link to Stackdriver logging for the Signal.
	// Immutable for Signals created by Stackdriver Alerting.
	SignalArtifacts      []*Signal_SignalArtifact `protobuf:"bytes,16,rep,name=signal_artifacts,json=signalArtifacts,proto3" json:"signal_artifacts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *Signal) Reset()         { *m = Signal{} }
func (m *Signal) String() string { return proto.CompactTextString(m) }
func (*Signal) ProtoMessage()    {}
func (*Signal) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{1}
}

func (m *Signal) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Signal.Unmarshal(m, b)
}
func (m *Signal) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Signal.Marshal(b, m, deterministic)
}
func (m *Signal) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Signal.Merge(m, src)
}
func (m *Signal) XXX_Size() int {
	return xxx_messageInfo_Signal.Size(m)
}
func (m *Signal) XXX_DiscardUnknown() {
	xxx_messageInfo_Signal.DiscardUnknown(m)
}

var xxx_messageInfo_Signal proto.InternalMessageInfo

func (m *Signal) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Signal) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *Signal) GetIncident() string {
	if m != nil {
		return m.Incident
	}
	return ""
}

func (m *Signal) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Signal) GetCloseTime() *timestamp.Timestamp {
	if m != nil {
		return m.CloseTime
	}
	return nil
}

func (m *Signal) GetDetectTime() *timestamp.Timestamp {
	if m != nil {
		return m.DetectTime
	}
	return nil
}

func (m *Signal) GetCreator() *User {
	if m != nil {
		return m.Creator
	}
	return nil
}

func (m *Signal) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Signal) GetContentType() string {
	if m != nil {
		return m.ContentType
	}
	return ""
}

func (m *Signal) GetContent() string {
	if m != nil {
		return m.Content
	}
	return ""
}

func (m *Signal) GetSignalState() Signal_State {
	if m != nil {
		return m.SignalState
	}
	return Signal_STATE_UNSPECIFIED
}

func (m *Signal) GetSignalArtifacts() []*Signal_SignalArtifact {
	if m != nil {
		return m.SignalArtifacts
	}
	return nil
}

// An artifact associated with the Signal.
type Signal_SignalArtifact struct {
	// The type of resource linked to
	//
	// Types that are valid to be assigned to ArtifactType:
	//	*Signal_SignalArtifact_UserType
	ArtifactType isSignal_SignalArtifact_ArtifactType `protobuf_oneof:"artifact_type"`
	// The URI for the artifact.
	Uri                  string   `protobuf:"bytes,3,opt,name=uri,proto3" json:"uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Signal_SignalArtifact) Reset()         { *m = Signal_SignalArtifact{} }
func (m *Signal_SignalArtifact) String() string { return proto.CompactTextString(m) }
func (*Signal_SignalArtifact) ProtoMessage()    {}
func (*Signal_SignalArtifact) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{1, 0}
}

func (m *Signal_SignalArtifact) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Signal_SignalArtifact.Unmarshal(m, b)
}
func (m *Signal_SignalArtifact) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Signal_SignalArtifact.Marshal(b, m, deterministic)
}
func (m *Signal_SignalArtifact) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Signal_SignalArtifact.Merge(m, src)
}
func (m *Signal_SignalArtifact) XXX_Size() int {
	return xxx_messageInfo_Signal_SignalArtifact.Size(m)
}
func (m *Signal_SignalArtifact) XXX_DiscardUnknown() {
	xxx_messageInfo_Signal_SignalArtifact.DiscardUnknown(m)
}

var xxx_messageInfo_Signal_SignalArtifact proto.InternalMessageInfo

type isSignal_SignalArtifact_ArtifactType interface {
	isSignal_SignalArtifact_ArtifactType()
}

type Signal_SignalArtifact_UserType struct {
	UserType string `protobuf:"bytes,2,opt,name=user_type,json=userType,proto3,oneof"`
}

func (*Signal_SignalArtifact_UserType) isSignal_SignalArtifact_ArtifactType() {}

func (m *Signal_SignalArtifact) GetArtifactType() isSignal_SignalArtifact_ArtifactType {
	if m != nil {
		return m.ArtifactType
	}
	return nil
}

func (m *Signal_SignalArtifact) GetUserType() string {
	if x, ok := m.GetArtifactType().(*Signal_SignalArtifact_UserType); ok {
		return x.UserType
	}
	return ""
}

func (m *Signal_SignalArtifact) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Signal_SignalArtifact) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Signal_SignalArtifact_UserType)(nil),
	}
}

// A text annotation by a user.
type Annotation struct {
	// Resource name of the annotation, for example,
	// "projects/{project_id_or_number}/incidents/{incident_id}/annotations/{annotation_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Author of the annotation.
	Author *User `protobuf:"bytes,2,opt,name=author,proto3" json:"author,omitempty"`
	// Output only. Time the annotation was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Content of the annotation.
	Content string `protobuf:"bytes,4,opt,name=content,proto3" json:"content,omitempty"`
	// Content type of the annotation, for example, 'text/plain'
	// or 'text/markdown'.
	ContentType          string   `protobuf:"bytes,5,opt,name=content_type,json=contentType,proto3" json:"content_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Annotation) Reset()         { *m = Annotation{} }
func (m *Annotation) String() string { return proto.CompactTextString(m) }
func (*Annotation) ProtoMessage()    {}
func (*Annotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{2}
}

func (m *Annotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Annotation.Unmarshal(m, b)
}
func (m *Annotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Annotation.Marshal(b, m, deterministic)
}
func (m *Annotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Annotation.Merge(m, src)
}
func (m *Annotation) XXX_Size() int {
	return xxx_messageInfo_Annotation.Size(m)
}
func (m *Annotation) XXX_DiscardUnknown() {
	xxx_messageInfo_Annotation.DiscardUnknown(m)
}

var xxx_messageInfo_Annotation proto.InternalMessageInfo

func (m *Annotation) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Annotation) GetAuthor() *User {
	if m != nil {
		return m.Author
	}
	return nil
}

func (m *Annotation) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Annotation) GetContent() string {
	if m != nil {
		return m.Content
	}
	return ""
}

func (m *Annotation) GetContentType() string {
	if m != nil {
		return m.ContentType
	}
	return ""
}

// A tag by a user.
type Tag struct {
	// Resource name of a tag, for example,
	// "projects/{project_id_or_number}/incidents/{incident_id}/tags/{tag_id}"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Display name of the resource (for example, "cause:rollout"). Immutable.
	DisplayName          string   `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Tag) Reset()         { *m = Tag{} }
func (m *Tag) String() string { return proto.CompactTextString(m) }
func (*Tag) ProtoMessage()    {}
func (*Tag) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{3}
}

func (m *Tag) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Tag.Unmarshal(m, b)
}
func (m *Tag) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Tag.Marshal(b, m, deterministic)
}
func (m *Tag) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Tag.Merge(m, src)
}
func (m *Tag) XXX_Size() int {
	return xxx_messageInfo_Tag.Size(m)
}
func (m *Tag) XXX_DiscardUnknown() {
	xxx_messageInfo_Tag.DiscardUnknown(m)
}

var xxx_messageInfo_Tag proto.InternalMessageInfo

func (m *Tag) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Tag) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

// Synopsis is a summary of an incident and it contains a textual content,
// an author and a last updated timestamp.
type Synopsis struct {
	// Content type string, for example, 'text/plain' or 'text/markdown'.
	ContentType string `protobuf:"bytes,1,opt,name=content_type,json=contentType,proto3" json:"content_type,omitempty"`
	// Textual content of the synopsis. It can be plain text or markdown as
	// indicated by the content_type.
	Content string `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
	// Last updated timestamp.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Author of the synopsis.
	Author               *User    `protobuf:"bytes,4,opt,name=author,proto3" json:"author,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Synopsis) Reset()         { *m = Synopsis{} }
func (m *Synopsis) String() string { return proto.CompactTextString(m) }
func (*Synopsis) ProtoMessage()    {}
func (*Synopsis) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{4}
}

func (m *Synopsis) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Synopsis.Unmarshal(m, b)
}
func (m *Synopsis) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Synopsis.Marshal(b, m, deterministic)
}
func (m *Synopsis) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Synopsis.Merge(m, src)
}
func (m *Synopsis) XXX_Size() int {
	return xxx_messageInfo_Synopsis.Size(m)
}
func (m *Synopsis) XXX_DiscardUnknown() {
	xxx_messageInfo_Synopsis.DiscardUnknown(m)
}

var xxx_messageInfo_Synopsis proto.InternalMessageInfo

func (m *Synopsis) GetContentType() string {
	if m != nil {
		return m.ContentType
	}
	return ""
}

func (m *Synopsis) GetContent() string {
	if m != nil {
		return m.Content
	}
	return ""
}

func (m *Synopsis) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *Synopsis) GetAuthor() *User {
	if m != nil {
		return m.Author
	}
	return nil
}

// Representation of an incident.
type Incident struct {
	// Output only. Resource name of the incident, for example,
	// "projects/{project_id_or_number}/incidents/{incident_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// One-line summary of the incident.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Escalation level of the incident.
	EscalationLevel Incident_EscalationLevel `protobuf:"varint,3,opt,name=escalation_level,json=escalationLevel,proto3,enum=google.cloud.irm.v1alpha2.Incident_EscalationLevel" json:"escalation_level,omitempty"`
	// Etag to validate the object is unchanged for a read-modify-write operation.
	// An empty etag will overwrite other changes.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
	// Severity of the incident.
	Severity Incident_Severity `protobuf:"varint,5,opt,name=severity,proto3,enum=google.cloud.irm.v1alpha2.Incident_Severity" json:"severity,omitempty"`
	// Stage of the incident.
	Stage Incident_Stage `protobuf:"varint,6,opt,name=stage,proto3,enum=google.cloud.irm.v1alpha2.Incident_Stage" json:"stage,omitempty"`
	// Resource name of the incident this incident is a duplicate of. Empty if
	// this incident is not a duplicate.
	// An incident can only be a duplicate of an incident that is not marked as a
	// duplicate already. Setting this to a non-empty value must also set the
	// stage to `STAGE_DUPLICATE`. Unsetting this value value must also update
	// `stage` to a value other than `STAGE_DUPLICATE`.
	DuplicateIncident string `protobuf:"bytes,9,opt,name=duplicate_incident,json=duplicateIncident,proto3" json:"duplicate_incident,omitempty"`
	// Output only. Time this incident started. Used to measure the 'elapsed
	// time'. Start time of an incident is the earliest creation time of any of
	// its Signals or the create time of the incident if no Signals are assigned.
	StartTime *timestamp.Timestamp `protobuf:"bytes,7,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Synopsis of this incident.
	Synopsis *Synopsis `protobuf:"bytes,8,opt,name=synopsis,proto3" json:"synopsis,omitempty"`
	// Location of communications for this incident. This is informational
	// only; IRM does not use this to send messages.
	CommunicationVenue   *Incident_CommunicationVenue `protobuf:"bytes,10,opt,name=communication_venue,json=communicationVenue,proto3" json:"communication_venue,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *Incident) Reset()         { *m = Incident{} }
func (m *Incident) String() string { return proto.CompactTextString(m) }
func (*Incident) ProtoMessage()    {}
func (*Incident) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{5}
}

func (m *Incident) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Incident.Unmarshal(m, b)
}
func (m *Incident) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Incident.Marshal(b, m, deterministic)
}
func (m *Incident) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Incident.Merge(m, src)
}
func (m *Incident) XXX_Size() int {
	return xxx_messageInfo_Incident.Size(m)
}
func (m *Incident) XXX_DiscardUnknown() {
	xxx_messageInfo_Incident.DiscardUnknown(m)
}

var xxx_messageInfo_Incident proto.InternalMessageInfo

func (m *Incident) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Incident) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Incident) GetEscalationLevel() Incident_EscalationLevel {
	if m != nil {
		return m.EscalationLevel
	}
	return Incident_ESCALATION_LEVEL_UNSPECIFIED
}

func (m *Incident) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *Incident) GetSeverity() Incident_Severity {
	if m != nil {
		return m.Severity
	}
	return Incident_SEVERITY_UNSPECIFIED
}

func (m *Incident) GetStage() Incident_Stage {
	if m != nil {
		return m.Stage
	}
	return Incident_STAGE_UNSPECIFIED
}

func (m *Incident) GetDuplicateIncident() string {
	if m != nil {
		return m.DuplicateIncident
	}
	return ""
}

func (m *Incident) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *Incident) GetSynopsis() *Synopsis {
	if m != nil {
		return m.Synopsis
	}
	return nil
}

func (m *Incident) GetCommunicationVenue() *Incident_CommunicationVenue {
	if m != nil {
		return m.CommunicationVenue
	}
	return nil
}

// CommunicationVenue is a record of where conversations about an incident
// are happening.
type Incident_CommunicationVenue struct {
	// A URI to the web interface of the channel.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// A name representing the channel in IRM UI.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The type of channel/venue for incident communications.
	ChannelType          Incident_CommunicationVenue_ChannelType `protobuf:"varint,3,opt,name=channel_type,json=channelType,proto3,enum=google.cloud.irm.v1alpha2.Incident_CommunicationVenue_ChannelType" json:"channel_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                `json:"-"`
	XXX_unrecognized     []byte                                  `json:"-"`
	XXX_sizecache        int32                                   `json:"-"`
}

func (m *Incident_CommunicationVenue) Reset()         { *m = Incident_CommunicationVenue{} }
func (m *Incident_CommunicationVenue) String() string { return proto.CompactTextString(m) }
func (*Incident_CommunicationVenue) ProtoMessage()    {}
func (*Incident_CommunicationVenue) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{5, 0}
}

func (m *Incident_CommunicationVenue) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Incident_CommunicationVenue.Unmarshal(m, b)
}
func (m *Incident_CommunicationVenue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Incident_CommunicationVenue.Marshal(b, m, deterministic)
}
func (m *Incident_CommunicationVenue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Incident_CommunicationVenue.Merge(m, src)
}
func (m *Incident_CommunicationVenue) XXX_Size() int {
	return xxx_messageInfo_Incident_CommunicationVenue.Size(m)
}
func (m *Incident_CommunicationVenue) XXX_DiscardUnknown() {
	xxx_messageInfo_Incident_CommunicationVenue.DiscardUnknown(m)
}

var xxx_messageInfo_Incident_CommunicationVenue proto.InternalMessageInfo

func (m *Incident_CommunicationVenue) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *Incident_CommunicationVenue) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Incident_CommunicationVenue) GetChannelType() Incident_CommunicationVenue_ChannelType {
	if m != nil {
		return m.ChannelType
	}
	return Incident_CommunicationVenue_CHANNEL_TYPE_UNSPECIFIED
}

// Describes a role that can be assigned to an incident.
type IncidentRole struct {
	// The type of role. The role type is immutable in role assignments. Each role
	// type can only be used once per incident, except for TYPE_OTHER.
	Type IncidentRole_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.irm.v1alpha2.IncidentRole_Type" json:"type,omitempty"`
	// Output only and empty unless TYPE_OTHER is used. Title of the role. For
	// TYPE_OTHER, must be unique within an incident.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Output only and empty unless TYPE_OTHER is used. Description of the role.
	Description          string   `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IncidentRole) Reset()         { *m = IncidentRole{} }
func (m *IncidentRole) String() string { return proto.CompactTextString(m) }
func (*IncidentRole) ProtoMessage()    {}
func (*IncidentRole) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{6}
}

func (m *IncidentRole) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IncidentRole.Unmarshal(m, b)
}
func (m *IncidentRole) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IncidentRole.Marshal(b, m, deterministic)
}
func (m *IncidentRole) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IncidentRole.Merge(m, src)
}
func (m *IncidentRole) XXX_Size() int {
	return xxx_messageInfo_IncidentRole.Size(m)
}
func (m *IncidentRole) XXX_DiscardUnknown() {
	xxx_messageInfo_IncidentRole.DiscardUnknown(m)
}

var xxx_messageInfo_IncidentRole proto.InternalMessageInfo

func (m *IncidentRole) GetType() IncidentRole_Type {
	if m != nil {
		return m.Type
	}
	return IncidentRole_TYPE_UNSPECIFIED
}

func (m *IncidentRole) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *IncidentRole) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// Stores the assignee of a role as well as the proposed next assignee.
type IncidentRoleAssignment struct {
	// Output only. Resource name such as
	// "projects/{project_id_or_number}/incidents/{incident_id}/role_assignments/{role_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Etag for this version of the resource. Must be specified in
	// update requests and match the current version in storage. Must not be
	// modified by the client.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// The role that is or will be assigned.
	Role *IncidentRole `protobuf:"bytes,3,opt,name=role,proto3" json:"role,omitempty"`
	// The user this role is assigned to. This field can only be directly set
	// during creation request. Subsequent updates are done via the
	// IncidentRoleHandover methods.
	Assignee *User `protobuf:"bytes,4,opt,name=assignee,proto3" json:"assignee,omitempty"`
	// The recipient of a requested role handoff. This field can only be directly
	// set during creation request. Subsequent updates are done via the
	// IncidentRoleHandover methods.
	//
	// `assignee` is always the current role-holder, and `proposed_assignee` is
	// used to track unfinished assignments and handoffs. Let's say Bob assigns
	// Alice to a role. Then the fields are:
	//   `assignee`: nil, `proposed_assignee`: Alice
	// If Alice accepts, then the fields are:
	//   `assignee`: Alice, `proposed_assignee`: nil
	// If she cancels, then the RoleAssignment is deleted.
	// Let's say Alice has the role. Then the fields are:
	//   `assignee`: Alice, `proposed_assignee`: nil
	// If Alice becomes incapacitated and Bob requests Carol to take over, then
	// the fields are:
	//   `assignee`: Alice, `proposed_assignee`: Carol
	// After Carol accepts the handover, the fields are:
	//   `assignee`: Carol, `proposed_assignee`: nil
	// Or if Carol refuses the handover, the fields are:
	//   `assignee`: Alice, `proposed_assignee`: nil
	ProposedAssignee     *User    `protobuf:"bytes,5,opt,name=proposed_assignee,json=proposedAssignee,proto3" json:"proposed_assignee,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IncidentRoleAssignment) Reset()         { *m = IncidentRoleAssignment{} }
func (m *IncidentRoleAssignment) String() string { return proto.CompactTextString(m) }
func (*IncidentRoleAssignment) ProtoMessage()    {}
func (*IncidentRoleAssignment) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{7}
}

func (m *IncidentRoleAssignment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IncidentRoleAssignment.Unmarshal(m, b)
}
func (m *IncidentRoleAssignment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IncidentRoleAssignment.Marshal(b, m, deterministic)
}
func (m *IncidentRoleAssignment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IncidentRoleAssignment.Merge(m, src)
}
func (m *IncidentRoleAssignment) XXX_Size() int {
	return xxx_messageInfo_IncidentRoleAssignment.Size(m)
}
func (m *IncidentRoleAssignment) XXX_DiscardUnknown() {
	xxx_messageInfo_IncidentRoleAssignment.DiscardUnknown(m)
}

var xxx_messageInfo_IncidentRoleAssignment proto.InternalMessageInfo

func (m *IncidentRoleAssignment) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *IncidentRoleAssignment) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *IncidentRoleAssignment) GetRole() *IncidentRole {
	if m != nil {
		return m.Role
	}
	return nil
}

func (m *IncidentRoleAssignment) GetAssignee() *User {
	if m != nil {
		return m.Assignee
	}
	return nil
}

func (m *IncidentRoleAssignment) GetProposedAssignee() *User {
	if m != nil {
		return m.ProposedAssignee
	}
	return nil
}

// External artifact associated to an incident.
type Artifact struct {
	// Output only. Resource name such as
	// "projects/{project_id_or_number}/incidents/{incident_id}/artifacts/{artifact_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// User provided name of an artifact.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. Etag for this version of the resource. Must be specified in
	// update requests and match the current version in storage. Must not be
	// modified by the client.
	Etag string `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
	// URL to access the artifact.
	Url string `protobuf:"bytes,4,opt,name=url,proto3" json:"url,omitempty"`
	// Type of this artifact.
	Type                 Artifact_Type `protobuf:"varint,5,opt,name=type,proto3,enum=google.cloud.irm.v1alpha2.Artifact_Type" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *Artifact) Reset()         { *m = Artifact{} }
func (m *Artifact) String() string { return proto.CompactTextString(m) }
func (*Artifact) ProtoMessage()    {}
func (*Artifact) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{8}
}

func (m *Artifact) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Artifact.Unmarshal(m, b)
}
func (m *Artifact) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Artifact.Marshal(b, m, deterministic)
}
func (m *Artifact) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Artifact.Merge(m, src)
}
func (m *Artifact) XXX_Size() int {
	return xxx_messageInfo_Artifact.Size(m)
}
func (m *Artifact) XXX_DiscardUnknown() {
	xxx_messageInfo_Artifact.DiscardUnknown(m)
}

var xxx_messageInfo_Artifact proto.InternalMessageInfo

func (m *Artifact) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Artifact) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Artifact) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *Artifact) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *Artifact) GetType() Artifact_Type {
	if m != nil {
		return m.Type
	}
	return Artifact_TYPE_UNSPECIFIED
}

// Communication Channels are mechanisms used to receive notifications
// about changes to incidents.
type CommunicationChannel struct {
	// An endpoint describes how messages will be delivered.
	//
	// Types that are valid to be assigned to Endpoint:
	//	*CommunicationChannel_Email_
	//	*CommunicationChannel_NotificationChannel_
	Endpoint             isCommunicationChannel_Endpoint `protobuf_oneof:"endpoint"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *CommunicationChannel) Reset()         { *m = CommunicationChannel{} }
func (m *CommunicationChannel) String() string { return proto.CompactTextString(m) }
func (*CommunicationChannel) ProtoMessage()    {}
func (*CommunicationChannel) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{9}
}

func (m *CommunicationChannel) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommunicationChannel.Unmarshal(m, b)
}
func (m *CommunicationChannel) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommunicationChannel.Marshal(b, m, deterministic)
}
func (m *CommunicationChannel) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommunicationChannel.Merge(m, src)
}
func (m *CommunicationChannel) XXX_Size() int {
	return xxx_messageInfo_CommunicationChannel.Size(m)
}
func (m *CommunicationChannel) XXX_DiscardUnknown() {
	xxx_messageInfo_CommunicationChannel.DiscardUnknown(m)
}

var xxx_messageInfo_CommunicationChannel proto.InternalMessageInfo

type isCommunicationChannel_Endpoint interface {
	isCommunicationChannel_Endpoint()
}

type CommunicationChannel_Email_ struct {
	Email *CommunicationChannel_Email `protobuf:"bytes,1,opt,name=email,proto3,oneof"`
}

type CommunicationChannel_NotificationChannel_ struct {
	NotificationChannel *CommunicationChannel_NotificationChannel `protobuf:"bytes,2,opt,name=notification_channel,json=notificationChannel,proto3,oneof"`
}

func (*CommunicationChannel_Email_) isCommunicationChannel_Endpoint() {}

func (*CommunicationChannel_NotificationChannel_) isCommunicationChannel_Endpoint() {}

func (m *CommunicationChannel) GetEndpoint() isCommunicationChannel_Endpoint {
	if m != nil {
		return m.Endpoint
	}
	return nil
}

func (m *CommunicationChannel) GetEmail() *CommunicationChannel_Email {
	if x, ok := m.GetEndpoint().(*CommunicationChannel_Email_); ok {
		return x.Email
	}
	return nil
}

func (m *CommunicationChannel) GetNotificationChannel() *CommunicationChannel_NotificationChannel {
	if x, ok := m.GetEndpoint().(*CommunicationChannel_NotificationChannel_); ok {
		return x.NotificationChannel
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*CommunicationChannel) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*CommunicationChannel_Email_)(nil),
		(*CommunicationChannel_NotificationChannel_)(nil),
	}
}

// A communication channel that delivers messages to an email address.
type CommunicationChannel_Email struct {
	// The email address, for example, "user@example.com".
	Address              string   `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommunicationChannel_Email) Reset()         { *m = CommunicationChannel_Email{} }
func (m *CommunicationChannel_Email) String() string { return proto.CompactTextString(m) }
func (*CommunicationChannel_Email) ProtoMessage()    {}
func (*CommunicationChannel_Email) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{9, 0}
}

func (m *CommunicationChannel_Email) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommunicationChannel_Email.Unmarshal(m, b)
}
func (m *CommunicationChannel_Email) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommunicationChannel_Email.Marshal(b, m, deterministic)
}
func (m *CommunicationChannel_Email) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommunicationChannel_Email.Merge(m, src)
}
func (m *CommunicationChannel_Email) XXX_Size() int {
	return xxx_messageInfo_CommunicationChannel_Email.Size(m)
}
func (m *CommunicationChannel_Email) XXX_DiscardUnknown() {
	xxx_messageInfo_CommunicationChannel_Email.DiscardUnknown(m)
}

var xxx_messageInfo_CommunicationChannel_Email proto.InternalMessageInfo

func (m *CommunicationChannel_Email) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

// A communication channel that delivers messages to a Stackdriver
// notification channel.
type CommunicationChannel_NotificationChannel struct {
	// Stackdriver notification channel name.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommunicationChannel_NotificationChannel) Reset() {
	*m = CommunicationChannel_NotificationChannel{}
}
func (m *CommunicationChannel_NotificationChannel) String() string { return proto.CompactTextString(m) }
func (*CommunicationChannel_NotificationChannel) ProtoMessage()    {}
func (*CommunicationChannel_NotificationChannel) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{9, 1}
}

func (m *CommunicationChannel_NotificationChannel) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommunicationChannel_NotificationChannel.Unmarshal(m, b)
}
func (m *CommunicationChannel_NotificationChannel) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommunicationChannel_NotificationChannel.Marshal(b, m, deterministic)
}
func (m *CommunicationChannel_NotificationChannel) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommunicationChannel_NotificationChannel.Merge(m, src)
}
func (m *CommunicationChannel_NotificationChannel) XXX_Size() int {
	return xxx_messageInfo_CommunicationChannel_NotificationChannel.Size(m)
}
func (m *CommunicationChannel_NotificationChannel) XXX_DiscardUnknown() {
	xxx_messageInfo_CommunicationChannel_NotificationChannel.DiscardUnknown(m)
}

var xxx_messageInfo_CommunicationChannel_NotificationChannel proto.InternalMessageInfo

func (m *CommunicationChannel_NotificationChannel) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A subscription allows users to get notifications about changes to
// an incident.
type Subscription struct {
	// Output only. Resource name such as
	// "projects/{project_id_or_number}/incidents/{incident_id}/subscriptions/{subscription_id}".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Etag for this version of the resource. Must be specified in
	// update requests and match the current version in storage. Must not be
	// modified by the client.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// A communications channel to send subscription messages to.
	SubscriptionChannel *CommunicationChannel `protobuf:"bytes,3,opt,name=subscription_channel,json=subscriptionChannel,proto3" json:"subscription_channel,omitempty"`
	// Types of events this subscription receives notifications for.
	EventTypes           []Subscription_EventType `protobuf:"varint,4,rep,packed,name=event_types,json=eventTypes,proto3,enum=google.cloud.irm.v1alpha2.Subscription_EventType" json:"event_types,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *Subscription) Reset()         { *m = Subscription{} }
func (m *Subscription) String() string { return proto.CompactTextString(m) }
func (*Subscription) ProtoMessage()    {}
func (*Subscription) Descriptor() ([]byte, []int) {
	return fileDescriptor_7ed49c995593d5b8, []int{10}
}

func (m *Subscription) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Subscription.Unmarshal(m, b)
}
func (m *Subscription) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Subscription.Marshal(b, m, deterministic)
}
func (m *Subscription) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Subscription.Merge(m, src)
}
func (m *Subscription) XXX_Size() int {
	return xxx_messageInfo_Subscription.Size(m)
}
func (m *Subscription) XXX_DiscardUnknown() {
	xxx_messageInfo_Subscription.DiscardUnknown(m)
}

var xxx_messageInfo_Subscription proto.InternalMessageInfo

func (m *Subscription) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Subscription) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *Subscription) GetSubscriptionChannel() *CommunicationChannel {
	if m != nil {
		return m.SubscriptionChannel
	}
	return nil
}

func (m *Subscription) GetEventTypes() []Subscription_EventType {
	if m != nil {
		return m.EventTypes
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.irm.v1alpha2.Signal_State", Signal_State_name, Signal_State_value)
	proto.RegisterEnum("google.cloud.irm.v1alpha2.Incident_EscalationLevel", Incident_EscalationLevel_name, Incident_EscalationLevel_value)
	proto.RegisterEnum("google.cloud.irm.v1alpha2.Incident_Severity", Incident_Severity_name, Incident_Severity_value)
	proto.RegisterEnum("google.cloud.irm.v1alpha2.Incident_Stage", Incident_Stage_name, Incident_Stage_value)
	proto.RegisterEnum("google.cloud.irm.v1alpha2.Incident_CommunicationVenue_ChannelType", Incident_CommunicationVenue_ChannelType_name, Incident_CommunicationVenue_ChannelType_value)
	proto.RegisterEnum("google.cloud.irm.v1alpha2.IncidentRole_Type", IncidentRole_Type_name, IncidentRole_Type_value)
	proto.RegisterEnum("google.cloud.irm.v1alpha2.Artifact_Type", Artifact_Type_name, Artifact_Type_value)
	proto.RegisterEnum("google.cloud.irm.v1alpha2.Subscription_EventType", Subscription_EventType_name, Subscription_EventType_value)
	proto.RegisterType((*User)(nil), "google.cloud.irm.v1alpha2.User")
	proto.RegisterType((*Signal)(nil), "google.cloud.irm.v1alpha2.Signal")
	proto.RegisterType((*Signal_SignalArtifact)(nil), "google.cloud.irm.v1alpha2.Signal.SignalArtifact")
	proto.RegisterType((*Annotation)(nil), "google.cloud.irm.v1alpha2.Annotation")
	proto.RegisterType((*Tag)(nil), "google.cloud.irm.v1alpha2.Tag")
	proto.RegisterType((*Synopsis)(nil), "google.cloud.irm.v1alpha2.Synopsis")
	proto.RegisterType((*Incident)(nil), "google.cloud.irm.v1alpha2.Incident")
	proto.RegisterType((*Incident_CommunicationVenue)(nil), "google.cloud.irm.v1alpha2.Incident.CommunicationVenue")
	proto.RegisterType((*IncidentRole)(nil), "google.cloud.irm.v1alpha2.IncidentRole")
	proto.RegisterType((*IncidentRoleAssignment)(nil), "google.cloud.irm.v1alpha2.IncidentRoleAssignment")
	proto.RegisterType((*Artifact)(nil), "google.cloud.irm.v1alpha2.Artifact")
	proto.RegisterType((*CommunicationChannel)(nil), "google.cloud.irm.v1alpha2.CommunicationChannel")
	proto.RegisterType((*CommunicationChannel_Email)(nil), "google.cloud.irm.v1alpha2.CommunicationChannel.Email")
	proto.RegisterType((*CommunicationChannel_NotificationChannel)(nil), "google.cloud.irm.v1alpha2.CommunicationChannel.NotificationChannel")
	proto.RegisterType((*Subscription)(nil), "google.cloud.irm.v1alpha2.Subscription")
}

func init() {
	proto.RegisterFile("google/cloud/irm/v1alpha2/incidents.proto", fileDescriptor_7ed49c995593d5b8)
}

var fileDescriptor_7ed49c995593d5b8 = []byte{
	// 1872 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x58, 0x5f, 0x6f, 0xdb, 0xc8,
	0x11, 0x0f, 0xf5, 0xcf, 0xf2, 0xc8, 0x67, 0x33, 0x6b, 0x9f, 0x23, 0xeb, 0x92, 0xc6, 0x51, 0x1e,
	0xe2, 0x14, 0xad, 0xd4, 0xd3, 0xa1, 0x2d, 0xce, 0x0e, 0x90, 0xd0, 0xd2, 0x9e, 0xcd, 0x94, 0xa6,
	0x8c, 0x25, 0x6d, 0xd4, 0x77, 0xc0, 0x11, 0x34, 0xb5, 0x91, 0x79, 0xa0, 0x48, 0x81, 0xa4, 0x8c,
	0x1a, 0x86, 0x51, 0xa0, 0xaf, 0xc5, 0x3d, 0xf5, 0xa9, 0x1f, 0xa1, 0x1f, 0xa1, 0x0f, 0x45, 0xdf,
	0xfa, 0x39, 0x8a, 0x02, 0x7d, 0xf1, 0x53, 0x1f, 0xfb, 0x78, 0xd8, 0xe5, 0x92, 0xa6, 0x65, 0x9d,
	0x23, 0xdf, 0x93, 0xb8, 0x33, 0xf3, 0x9b, 0x9d, 0x9d, 0x99, 0x9d, 0x99, 0x15, 0xbc, 0x1e, 0x06,
	0xc1, 0xd0, 0xa3, 0x6d, 0xc7, 0x0b, 0x26, 0x83, 0xb6, 0x1b, 0x8e, 0xda, 0xe7, 0x9f, 0xdb, 0xde,
	0xf8, 0xcc, 0xee, 0xb4, 0x5d, 0xdf, 0x71, 0x07, 0xd4, 0x8f, 0xa3, 0xd6, 0x38, 0x0c, 0xe2, 0x00,
	0x6d, 0x24, 0xa2, 0x2d, 0x2e, 0xda, 0x72, 0xc3, 0x51, 0x2b, 0x15, 0x6d, 0x3c, 0x15, 0x5a, 0xec,
	0xb1, 0xdb, 0xb6, 0x7d, 0x3f, 0x88, 0xed, 0xd8, 0x0d, 0x7c, 0x01, 0x6c, 0x3c, 0xcf, 0x71, 0x3f,
	0xb8, 0xd4, 0x1b, 0x58, 0xa7, 0xf4, 0xcc, 0x3e, 0x77, 0x83, 0x50, 0x08, 0x6c, 0xe4, 0x04, 0x42,
	0x1a, 0x05, 0x93, 0xd0, 0xa1, 0x53, 0x58, 0xbe, 0x3a, 0x9d, 0x7c, 0x68, 0xc7, 0xee, 0x88, 0x46,
	0xb1, 0x3d, 0x1a, 0x27, 0x02, 0x4d, 0x05, 0x4a, 0x47, 0x11, 0x0d, 0xd1, 0x06, 0x2c, 0x4c, 0x22,
	0x1a, 0x5a, 0xee, 0xa0, 0x2e, 0x6d, 0x4a, 0x5b, 0x8b, 0xfb, 0x8f, 0x48, 0x85, 0x11, 0xd4, 0x01,
	0x5a, 0x87, 0x32, 0x1d, 0xd9, 0xae, 0x57, 0x2f, 0x08, 0x46, 0xb2, 0xdc, 0xad, 0x40, 0x89, 0x49,
	0x34, 0xff, 0x52, 0x81, 0x8a, 0xe1, 0x0e, 0x7d, 0xdb, 0x43, 0x08, 0x4a, 0xbe, 0x3d, 0xa2, 0x89,
	0x0a, 0xc2, 0xbf, 0x19, 0x8d, 0xc6, 0xf6, 0x30, 0x41, 0x13, 0xfe, 0x8d, 0x1a, 0x50, 0x4d, 0xdd,
	0x53, 0x2f, 0x72, 0x7a, 0xb6, 0x46, 0x3b, 0x50, 0x73, 0x42, 0x6a, 0xc7, 0xd4, 0x62, 0xb6, 0xd6,
	0x4b, 0x9b, 0xd2, 0x56, 0xad, 0xd3, 0x68, 0x09, 0xef, 0xa5, 0x07, 0x69, 0x99, 0xe9, 0x41, 0x08,
	0x24, 0xe2, 0x8c, 0x80, 0xbe, 0x04, 0x70, 0xbc, 0x20, 0x12, 0x58, 0xf8, 0x28, 0x76, 0x91, 0x4b,
	0x73, 0xe8, 0x0e, 0xd4, 0x06, 0x34, 0xa6, 0x4e, 0x9c, 0x60, 0x57, 0x3e, 0xbe, 0x6f, 0x22, 0x2e,
	0xf6, 0x5d, 0xe0, 0x56, 0x04, 0x61, 0xbd, 0xcc, 0x81, 0xcf, 0x5b, 0x3f, 0x1a, 0xee, 0x16, 0x73,
	0x38, 0x49, 0xe5, 0xd1, 0x1a, 0x94, 0x63, 0x37, 0xf6, 0x68, 0xbd, 0xc2, 0x1d, 0x91, 0x2c, 0xd0,
	0x0b, 0x58, 0x72, 0x02, 0x3f, 0xa6, 0x7e, 0x6c, 0xc5, 0x17, 0x63, 0x5a, 0x5f, 0xe0, 0xcc, 0x9a,
	0xa0, 0x99, 0x17, 0x63, 0x8a, 0xea, 0xb0, 0x20, 0x96, 0xf5, 0x2a, 0xe7, 0xa6, 0x4b, 0xf4, 0x1e,
	0x96, 0x22, 0x1e, 0x10, 0x2b, 0x8a, 0xed, 0x98, 0xd6, 0x17, 0x37, 0xa5, 0xad, 0xe5, 0xce, 0xab,
	0x7b, 0x4c, 0x4a, 0xe2, 0xd7, 0x32, 0x98, 0x38, 0xa9, 0x25, 0x60, 0xbe, 0x40, 0xdf, 0x80, 0x2c,
	0x74, 0xd9, 0x61, 0xec, 0x7e, 0xb0, 0x9d, 0x38, 0xaa, 0xcb, 0x9b, 0xc5, 0xad, 0x5a, 0xe7, 0x57,
	0x73, 0xe8, 0xe3, 0x3f, 0x8a, 0x00, 0x92, 0x95, 0xe8, 0xd6, 0x3a, 0x6a, 0x10, 0x58, 0xbe, 0x2d,
	0x82, 0x9e, 0xc1, 0x22, 0xcf, 0x43, 0x7e, 0xe8, 0x34, 0xe1, 0xaa, 0x8c, 0xc4, 0xcf, 0x2c, 0x43,
	0x71, 0x12, 0xba, 0x22, 0x67, 0xd8, 0xe7, 0xee, 0x0a, 0x7c, 0x92, 0x1a, 0xc6, 0x41, 0xcd, 0x77,
	0x50, 0x4e, 0x2c, 0xff, 0x14, 0x1e, 0x1b, 0xa6, 0x62, 0x62, 0xeb, 0x48, 0x37, 0x0e, 0x71, 0x57,
	0xfd, 0x4a, 0xc5, 0x3d, 0xf9, 0x11, 0x5a, 0x06, 0x48, 0xc8, 0xfd, 0x43, 0xac, 0xcb, 0x12, 0x92,
	0x61, 0x29, 0x59, 0x77, 0xb5, 0xbe, 0x81, 0x7b, 0x72, 0x61, 0xbb, 0x7b, 0xad, 0xbc, 0x83, 0x0d,
	0x76, 0x9e, 0xe4, 0x80, 0xf6, 0xd8, 0x8d, 0x5a, 0x4e, 0x30, 0x6a, 0x8b, 0x2c, 0x7f, 0x39, 0x0e,
	0x83, 0xef, 0xa8, 0x13, 0x47, 0xed, 0x4b, 0xf1, 0x75, 0xd5, 0x4e, 0x4e, 0x16, 0xb5, 0x2f, 0x93,
	0x8f, 0xab, 0xe6, 0xdf, 0x0b, 0x00, 0x4a, 0x76, 0x97, 0x67, 0xde, 0x8c, 0xdf, 0x42, 0xc5, 0x9e,
	0xc4, 0x67, 0x41, 0xc8, 0x0f, 0x3a, 0x47, 0xce, 0x08, 0xf1, 0xe9, 0x2b, 0x52, 0x7c, 0xd0, 0x15,
	0xc9, 0xa5, 0x4d, 0xe9, 0x76, 0xda, 0x4c, 0xe7, 0x5c, 0xf9, 0x4e, 0xce, 0x6d, 0x0f, 0xae, 0x15,
	0x1b, 0x9e, 0xcd, 0x70, 0x4d, 0xee, 0xa8, 0xef, 0x66, 0xb8, 0x27, 0x2b, 0x86, 0xed, 0xcb, 0xf4,
	0xf3, 0x2a, 0x5f, 0xea, 0xda, 0x97, 0x37, 0x8b, 0xab, 0xe6, 0xf7, 0x12, 0x14, 0x4d, 0x7b, 0x38,
	0xd3, 0x69, 0x2f, 0x60, 0x69, 0xe0, 0x46, 0x63, 0xcf, 0xbe, 0xb0, 0x38, 0x2f, 0x29, 0x2b, 0x35,
	0x41, 0xd3, 0xed, 0x11, 0xdd, 0xee, 0x5f, 0x2b, 0x1a, 0xac, 0xcf, 0x30, 0x92, 0xe9, 0xec, 0xcc,
	0x6b, 0x5d, 0x6c, 0x0f, 0xa3, 0xf6, 0x65, 0x6c, 0x0f, 0xaf, 0x9a, 0xff, 0x90, 0xa0, 0x6a, 0x5c,
	0xf8, 0xc1, 0x38, 0x72, 0xa3, 0x3b, 0x5e, 0x92, 0xee, 0xbd, 0x99, 0x85, 0xdb, 0x2e, 0xde, 0x81,
	0xda, 0x64, 0x3c, 0x78, 0x48, 0xe4, 0x12, 0x71, 0x1e, 0xb9, 0x9b, 0x7c, 0x29, 0x3d, 0x28, 0x5f,
	0x9a, 0x7f, 0x03, 0xa8, 0xaa, 0x69, 0x7d, 0x7d, 0x92, 0x77, 0xea, 0x6e, 0xf1, 0xdf, 0x4a, 0x51,
	0x78, 0x36, 0x2b, 0x44, 0x85, 0x7c, 0x21, 0xfa, 0x16, 0x64, 0x1a, 0x39, 0xb6, 0xc7, 0x43, 0x63,
	0x79, 0xf4, 0x9c, 0x7a, 0xdc, 0xec, 0xe5, 0xce, 0x17, 0xf7, 0x6c, 0x9f, 0xee, 0xd6, 0xc2, 0x19,
	0x56, 0x63, 0x50, 0xb2, 0x42, 0x6f, 0x13, 0xb2, 0xf6, 0x50, 0xca, 0xb5, 0x87, 0x7d, 0xa8, 0x46,
	0xf4, 0x9c, 0x86, 0x6e, 0x7c, 0xc1, 0x93, 0x70, 0xb9, 0xf3, 0x8b, 0x79, 0xf6, 0x32, 0x04, 0x86,
	0x64, 0x68, 0xf4, 0x16, 0xca, 0x51, 0x6c, 0x0f, 0x93, 0xe2, 0xba, 0xdc, 0x79, 0x3d, 0x97, 0x1a,
	0x06, 0x20, 0x09, 0x0e, 0xfd, 0x12, 0xd0, 0x60, 0x32, 0xf6, 0x5c, 0x87, 0xc5, 0x2c, 0xeb, 0x59,
	0x8b, 0xdc, 0xd8, 0xc7, 0x19, 0x27, 0x73, 0xee, 0x97, 0x00, 0x51, 0x6c, 0x87, 0xa2, 0x87, 0x2c,
	0x7c, 0xbc, 0xff, 0x70, 0x69, 0x1e, 0xdd, 0xb7, 0x50, 0x8d, 0x44, 0x8e, 0xf1, 0x7a, 0x5e, 0xeb,
	0xbc, 0xbc, 0xaf, 0xc0, 0x0a, 0x51, 0x92, 0x81, 0xd0, 0x10, 0x56, 0x9d, 0x60, 0x34, 0x9a, 0xf8,
	0xcc, 0x24, 0x16, 0xac, 0x73, 0xea, 0x4f, 0xd2, 0x26, 0xf8, 0x9b, 0x79, 0x4e, 0xde, 0xcd, 0xc3,
	0x8f, 0x19, 0x9a, 0x20, 0xe7, 0x0e, 0xad, 0xf1, 0xe7, 0x02, 0xa0, 0xbb, 0xa2, 0x69, 0x6d, 0x96,
	0xb2, 0xda, 0x3c, 0xc7, 0x5d, 0x45, 0x14, 0x96, 0x9c, 0x33, 0xdb, 0xf7, 0xa9, 0x97, 0xdc, 0xa6,
	0x24, 0xb5, 0x76, 0x7f, 0x9a, 0xb5, 0xad, 0x6e, 0xa2, 0x8a, 0x5d, 0x42, 0x52, 0x73, 0x6e, 0x16,
	0xcd, 0x13, 0xa8, 0xe5, 0x78, 0xe8, 0x29, 0xd4, 0xbb, 0xfb, 0x8a, 0xae, 0x63, 0xcd, 0x32, 0x4f,
	0x0e, 0xa7, 0x3b, 0xc4, 0x1a, 0xc8, 0xb7, 0xb9, 0x44, 0x95, 0x25, 0xb4, 0x0e, 0xe8, 0x16, 0xd5,
	0xd0, 0x94, 0xee, 0xef, 0xe4, 0x72, 0xf3, 0x18, 0x56, 0xa6, 0x92, 0x1c, 0x6d, 0xc2, 0x53, 0x6c,
	0x74, 0x15, 0x4d, 0x31, 0xd5, 0xbe, 0x6e, 0x69, 0xf8, 0x18, 0x6b, 0x53, 0x5b, 0xbc, 0x80, 0x67,
	0x77, 0x24, 0xfa, 0x64, 0x4f, 0xd1, 0xd5, 0xaf, 0x39, 0x49, 0x96, 0x58, 0x11, 0xac, 0xa6, 0x19,
	0x8d, 0xea, 0xb0, 0x66, 0xe0, 0x63, 0x4c, 0x54, 0xf3, 0x64, 0x4a, 0xd3, 0x63, 0xf8, 0x24, 0xe3,
	0xec, 0x1f, 0xed, 0x61, 0x59, 0x42, 0x08, 0x96, 0x33, 0xd2, 0x81, 0xf2, 0xbe, 0x4f, 0xe4, 0x02,
	0x5a, 0x85, 0x95, 0x1b, 0x1a, 0xee, 0xa9, 0x47, 0x07, 0x72, 0xf1, 0xb6, 0xa0, 0xaa, 0xf7, 0x89,
	0x5c, 0x42, 0x4f, 0x60, 0x35, 0xa3, 0xe9, 0x78, 0x4f, 0x53, 0xf7, 0xd4, 0x5d, 0x0d, 0xcb, 0xe5,
	0xe6, 0x5f, 0x25, 0xde, 0x58, 0x87, 0x69, 0x63, 0xdd, 0x9b, 0x76, 0x1b, 0xd3, 0xc6, 0xc9, 0x3d,
	0x6c, 0xe2, 0xae, 0x89, 0x7b, 0x72, 0x89, 0x5b, 0xc7, 0x69, 0x26, 0x51, 0x95, 0x3d, 0xdc, 0x93,
	0x25, 0x6e, 0x09, 0x27, 0x1d, 0xa8, 0xa6, 0xba, 0xa7, 0x30, 0xb9, 0xc2, 0x0d, 0x96, 0x60, 0xa3,
	0xaf, 0x1d, 0xe3, 0x9e, 0x5c, 0x64, 0x61, 0x10, 0xfa, 0xfa, 0xdd, 0xa3, 0x03, 0xac, 0x33, 0xc9,
	0xf2, 0x0d, 0xbc, 0x77, 0x74, 0xa8, 0xa9, 0x5d, 0xc5, 0xc4, 0x72, 0x65, 0x5b, 0xbd, 0x56, 0xbe,
	0x82, 0xcf, 0x66, 0x54, 0xfc, 0xec, 0x62, 0xbe, 0x9a, 0xb3, 0xec, 0x37, 0xff, 0x57, 0x80, 0xa5,
	0x14, 0x45, 0x02, 0x8f, 0xa2, 0x77, 0x50, 0xca, 0xea, 0xfc, 0x7c, 0x85, 0x88, 0xc1, 0x5a, 0x3c,
	0x07, 0x39, 0xf2, 0x47, 0x0a, 0xeb, 0x26, 0x9b, 0x37, 0x23, 0x27, 0x74, 0xc7, 0x2c, 0x71, 0xc4,
	0x48, 0x93, 0x27, 0x35, 0xff, 0x2b, 0x41, 0xc9, 0x4c, 0x14, 0xc8, 0x33, 0xd2, 0xf4, 0x33, 0x78,
	0xc2, 0xa9, 0xaa, 0xde, 0x55, 0x7b, 0x58, 0x37, 0xad, 0x6e, 0xff, 0xe0, 0x40, 0xd1, 0x7b, 0x98,
	0xc8, 0x12, 0xcb, 0x70, 0xce, 0x64, 0xb4, 0x23, 0x9d, 0xf9, 0x49, 0xed, 0xeb, 0x86, 0xa5, 0x61,
	0x85, 0xb9, 0xbb, 0x0e, 0x6b, 0x9c, 0xdb, 0x3f, 0xc4, 0x24, 0xcf, 0x29, 0xa2, 0x16, 0xfc, 0x9c,
	0x73, 0xf0, 0xef, 0x4d, 0x4c, 0x74, 0x45, 0xb3, 0xba, 0x47, 0x86, 0xd9, 0x3f, 0xc0, 0x64, 0xa6,
	0x26, 0x9e, 0x2e, 0x5c, 0xfe, 0x90, 0xa8, 0x07, 0x0a, 0x39, 0xb1, 0xfa, 0x7a, 0x57, 0xd1, 0x34,
	0xb9, 0x8c, 0x36, 0xe0, 0xd3, 0xe4, 0x9a, 0xe0, 0x6e, 0x5f, 0xef, 0xe5, 0x58, 0x15, 0x36, 0x81,
	0x25, 0xbb, 0x9b, 0xfb, 0x98, 0xc8, 0x0b, 0xcd, 0xef, 0x8b, 0xb0, 0x9e, 0xf7, 0x9d, 0x12, 0xb1,
	0x21, 0x6a, 0xc4, 0xc2, 0x36, 0xef, 0x83, 0x62, 0x07, 0x4a, 0x61, 0xe0, 0xa5, 0x0d, 0xf5, 0xd5,
	0x9c, 0x41, 0x22, 0x1c, 0x84, 0x76, 0xa0, 0x6a, 0xf3, 0x2d, 0x29, 0x9d, 0xb7, 0xb3, 0x66, 0x00,
	0xa4, 0xc1, 0xe3, 0x71, 0x18, 0x8c, 0x83, 0x88, 0x0e, 0xac, 0x4c, 0xcb, 0x9c, 0x6f, 0x00, 0x39,
	0x45, 0x2a, 0x02, 0xb8, 0xfd, 0x27, 0xe9, 0x5a, 0xf9, 0x23, 0xbc, 0xbe, 0x27, 0x93, 0xa7, 0x1c,
	0x44, 0xee, 0xe4, 0xb5, 0xe5, 0x0e, 0xac, 0x20, 0xb4, 0xfc, 0xc9, 0xe8, 0x94, 0x86, 0x33, 0x93,
	0xdc, 0x72, 0x07, 0x57, 0x6d, 0x76, 0x72, 0x61, 0xf0, 0x28, 0x61, 0x73, 0x8a, 0x3b, 0xb8, 0x6a,
	0xfe, 0xab, 0x00, 0xd5, 0x6c, 0x20, 0xff, 0x69, 0x33, 0x58, 0x16, 0xa4, 0x62, 0x2e, 0x48, 0xbc,
	0x41, 0x78, 0xa2, 0xd3, 0xb3, 0x4f, 0xf4, 0x46, 0xdc, 0xad, 0xa4, 0xc9, 0x6f, 0xdd, 0xe3, 0xaf,
	0xd4, 0x9e, 0xdc, 0xbd, 0x6a, 0xbe, 0xbd, 0xf7, 0x7a, 0x2c, 0x41, 0x55, 0x54, 0x6f, 0x2d, 0xa9,
	0x3a, 0x7c, 0xf5, 0x5e, 0x25, 0x8a, 0xa5, 0x1a, 0xc6, 0x11, 0x96, 0x4b, 0xdb, 0xdf, 0x5e, 0x2b,
	0xdf, 0xcc, 0x2c, 0x1b, 0xd9, 0xe9, 0xdf, 0xcc, 0x3d, 0xcb, 0xa6, 0x6f, 0x9a, 0xf6, 0x65, 0xfa,
	0xc9, 0xdf, 0x00, 0x6b, 0xb7, 0xba, 0x94, 0xe8, 0x41, 0xe8, 0x20, 0x7d, 0x52, 0x4b, 0x3c, 0x51,
	0x7e, 0x7d, 0xcf, 0xc1, 0x67, 0xe1, 0x5b, 0x98, 0x81, 0xb3, 0x97, 0x38, 0xfa, 0x03, 0xac, 0xf9,
	0x41, 0xec, 0x7e, 0x48, 0x1b, 0xbf, 0xe8, 0x7c, 0xe2, 0x59, 0xd1, 0x7d, 0xa8, 0x76, 0x3d, 0xa7,
	0x4b, 0xd0, 0xf6, 0x1f, 0x91, 0x55, 0xff, 0x2e, 0xb9, 0xf1, 0x02, 0xca, 0xdc, 0x16, 0x36, 0xf2,
	0xda, 0x83, 0x41, 0x48, 0xa3, 0x48, 0x64, 0x4a, 0xba, 0x6c, 0xbc, 0x86, 0xd5, 0x19, 0x0a, 0x67,
	0xe5, 0xd5, 0x2e, 0x40, 0x95, 0xfa, 0x83, 0x71, 0xe0, 0xfa, 0x71, 0xf3, 0x9f, 0x25, 0x58, 0x32,
	0x26, 0xa7, 0x59, 0x35, 0x9c, 0xbb, 0x14, 0x9c, 0xc2, 0x5a, 0x94, 0xc3, 0x65, 0xce, 0x48, 0x4a,
	0x43, 0xfb, 0x81, 0xce, 0x20, 0xab, 0x79, 0x65, 0xa9, 0xf1, 0x04, 0x6a, 0xf4, 0x3c, 0x7d, 0x01,
	0x44, 0xf5, 0xd2, 0x66, 0x71, 0x6b, 0xb9, 0xf3, 0xf9, 0x7d, 0xe3, 0x5a, 0x4e, 0x49, 0x0b, 0x9f,
	0x8b, 0x87, 0x02, 0x01, 0x9a, 0x7e, 0x46, 0xcd, 0xff, 0x48, 0xb0, 0x98, 0x71, 0x50, 0x03, 0xd6,
	0xf1, 0x31, 0x2b, 0xea, 0xb3, 0x0b, 0x7f, 0x8e, 0x67, 0xaa, 0xa6, 0x86, 0x2d, 0x36, 0x9a, 0xf0,
	0xe6, 0xff, 0x33, 0x68, 0xe4, 0x98, 0xc6, 0x89, 0xde, 0x3f, 0x34, 0x54, 0x23, 0xe5, 0x17, 0xa6,
	0xc0, 0x49, 0x2b, 0x15, 0xcc, 0xe2, 0x34, 0x38, 0x9d, 0x03, 0x04, 0xbf, 0x84, 0x9e, 0xc1, 0x46,
	0x8e, 0xaf, 0xe8, 0x7a, 0xdf, 0x4c, 0x26, 0x18, 0xa5, 0xc7, 0x7a, 0x33, 0x9b, 0x7b, 0x66, 0xb2,
	0x85, 0x82, 0xca, 0xf6, 0x77, 0xd7, 0xca, 0x10, 0x9e, 0xcf, 0x7a, 0x5a, 0xe7, 0x43, 0xdd, 0x9b,
	0xf7, 0xd6, 0xe5, 0x63, 0xc3, 0xde, 0xde, 0xb9, 0xe5, 0xd5, 0xee, 0x19, 0xbc, 0x74, 0x82, 0x74,
	0x23, 0x1e, 0x8e, 0x88, 0x86, 0xe7, 0xae, 0x43, 0x6f, 0xc2, 0x62, 0x8f, 0xdd, 0x43, 0xe9, 0xeb,
	0x37, 0x42, 0x64, 0x18, 0x78, 0xb6, 0x3f, 0x6c, 0x05, 0xe1, 0xb0, 0x3d, 0xa4, 0x3e, 0x9f, 0xd6,
	0xdb, 0x37, 0x66, 0xce, 0xf8, 0x8f, 0x6f, 0xc7, 0x0d, 0x47, 0xff, 0x97, 0xa4, 0xd3, 0x0a, 0x97,
	0xfd, 0xe2, 0x87, 0x00, 0x00, 0x00, 0xff, 0xff, 0x53, 0xa2, 0xc7, 0xc9, 0x0e, 0x14, 0x00, 0x00,
}
