package authoring

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/satori/go.uuid"
	"io"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/cognitiveservices/v3.0/luis/authoring"

// OperationStatusType enumerates the values for operation status type.
type OperationStatusType string

const (
	// Failed ...
	Failed OperationStatusType = "Failed"
	// FAILED ...
	FAILED OperationStatusType = "FAILED"
	// Success ...
	Success OperationStatusType = "Success"
)

// PossibleOperationStatusTypeValues returns an array of possible values for the OperationStatusType const type.
func PossibleOperationStatusTypeValues() []OperationStatusType {
	return []OperationStatusType{Failed, FAILED, Success}
}

// ReadableType enumerates the values for readable type.
type ReadableType string

const (
	// ReadableTypeChildEntityExtractor ...
	ReadableTypeChildEntityExtractor ReadableType = "Child Entity Extractor"
	// ReadableTypeClosedListEntityExtractor ...
	ReadableTypeClosedListEntityExtractor ReadableType = "Closed List Entity Extractor"
	// ReadableTypeCompositeEntityExtractor ...
	ReadableTypeCompositeEntityExtractor ReadableType = "Composite Entity Extractor"
	// ReadableTypeEntityExtractor ...
	ReadableTypeEntityExtractor ReadableType = "Entity Extractor"
	// ReadableTypeHierarchicalChildEntityExtractor ...
	ReadableTypeHierarchicalChildEntityExtractor ReadableType = "Hierarchical Child Entity Extractor"
	// ReadableTypeHierarchicalEntityExtractor ...
	ReadableTypeHierarchicalEntityExtractor ReadableType = "Hierarchical Entity Extractor"
	// ReadableTypeIntentClassifier ...
	ReadableTypeIntentClassifier ReadableType = "Intent Classifier"
	// ReadableTypeListEntityExtractor ...
	ReadableTypeListEntityExtractor ReadableType = "List Entity Extractor"
	// ReadableTypePatternAnyEntityExtractor ...
	ReadableTypePatternAnyEntityExtractor ReadableType = "Pattern.Any Entity Extractor"
	// ReadableTypePrebuiltEntityExtractor ...
	ReadableTypePrebuiltEntityExtractor ReadableType = "Prebuilt Entity Extractor"
	// ReadableTypeRegexEntityExtractor ...
	ReadableTypeRegexEntityExtractor ReadableType = "Regex Entity Extractor"
)

// PossibleReadableTypeValues returns an array of possible values for the ReadableType const type.
func PossibleReadableTypeValues() []ReadableType {
	return []ReadableType{ReadableTypeChildEntityExtractor, ReadableTypeClosedListEntityExtractor, ReadableTypeCompositeEntityExtractor, ReadableTypeEntityExtractor, ReadableTypeHierarchicalChildEntityExtractor, ReadableTypeHierarchicalEntityExtractor, ReadableTypeIntentClassifier, ReadableTypeListEntityExtractor, ReadableTypePatternAnyEntityExtractor, ReadableTypePrebuiltEntityExtractor, ReadableTypeRegexEntityExtractor}
}

// ReadableType1 enumerates the values for readable type 1.
type ReadableType1 string

const (
	// ReadableType1ChildEntityExtractor ...
	ReadableType1ChildEntityExtractor ReadableType1 = "Child Entity Extractor"
	// ReadableType1ClosedListEntityExtractor ...
	ReadableType1ClosedListEntityExtractor ReadableType1 = "Closed List Entity Extractor"
	// ReadableType1CompositeEntityExtractor ...
	ReadableType1CompositeEntityExtractor ReadableType1 = "Composite Entity Extractor"
	// ReadableType1EntityExtractor ...
	ReadableType1EntityExtractor ReadableType1 = "Entity Extractor"
	// ReadableType1HierarchicalChildEntityExtractor ...
	ReadableType1HierarchicalChildEntityExtractor ReadableType1 = "Hierarchical Child Entity Extractor"
	// ReadableType1HierarchicalEntityExtractor ...
	ReadableType1HierarchicalEntityExtractor ReadableType1 = "Hierarchical Entity Extractor"
	// ReadableType1IntentClassifier ...
	ReadableType1IntentClassifier ReadableType1 = "Intent Classifier"
	// ReadableType1ListEntityExtractor ...
	ReadableType1ListEntityExtractor ReadableType1 = "List Entity Extractor"
	// ReadableType1PatternAnyEntityExtractor ...
	ReadableType1PatternAnyEntityExtractor ReadableType1 = "Pattern.Any Entity Extractor"
	// ReadableType1PrebuiltEntityExtractor ...
	ReadableType1PrebuiltEntityExtractor ReadableType1 = "Prebuilt Entity Extractor"
	// ReadableType1RegexEntityExtractor ...
	ReadableType1RegexEntityExtractor ReadableType1 = "Regex Entity Extractor"
)

// PossibleReadableType1Values returns an array of possible values for the ReadableType1 const type.
func PossibleReadableType1Values() []ReadableType1 {
	return []ReadableType1{ReadableType1ChildEntityExtractor, ReadableType1ClosedListEntityExtractor, ReadableType1CompositeEntityExtractor, ReadableType1EntityExtractor, ReadableType1HierarchicalChildEntityExtractor, ReadableType1HierarchicalEntityExtractor, ReadableType1IntentClassifier, ReadableType1ListEntityExtractor, ReadableType1PatternAnyEntityExtractor, ReadableType1PrebuiltEntityExtractor, ReadableType1RegexEntityExtractor}
}

// ReadableType10 enumerates the values for readable type 10.
type ReadableType10 string

const (
	// ReadableType10ChildEntityExtractor ...
	ReadableType10ChildEntityExtractor ReadableType10 = "Child Entity Extractor"
	// ReadableType10ClosedListEntityExtractor ...
	ReadableType10ClosedListEntityExtractor ReadableType10 = "Closed List Entity Extractor"
	// ReadableType10CompositeEntityExtractor ...
	ReadableType10CompositeEntityExtractor ReadableType10 = "Composite Entity Extractor"
	// ReadableType10EntityExtractor ...
	ReadableType10EntityExtractor ReadableType10 = "Entity Extractor"
	// ReadableType10HierarchicalChildEntityExtractor ...
	ReadableType10HierarchicalChildEntityExtractor ReadableType10 = "Hierarchical Child Entity Extractor"
	// ReadableType10HierarchicalEntityExtractor ...
	ReadableType10HierarchicalEntityExtractor ReadableType10 = "Hierarchical Entity Extractor"
	// ReadableType10IntentClassifier ...
	ReadableType10IntentClassifier ReadableType10 = "Intent Classifier"
	// ReadableType10ListEntityExtractor ...
	ReadableType10ListEntityExtractor ReadableType10 = "List Entity Extractor"
	// ReadableType10PatternAnyEntityExtractor ...
	ReadableType10PatternAnyEntityExtractor ReadableType10 = "Pattern.Any Entity Extractor"
	// ReadableType10PrebuiltEntityExtractor ...
	ReadableType10PrebuiltEntityExtractor ReadableType10 = "Prebuilt Entity Extractor"
	// ReadableType10RegexEntityExtractor ...
	ReadableType10RegexEntityExtractor ReadableType10 = "Regex Entity Extractor"
)

// PossibleReadableType10Values returns an array of possible values for the ReadableType10 const type.
func PossibleReadableType10Values() []ReadableType10 {
	return []ReadableType10{ReadableType10ChildEntityExtractor, ReadableType10ClosedListEntityExtractor, ReadableType10CompositeEntityExtractor, ReadableType10EntityExtractor, ReadableType10HierarchicalChildEntityExtractor, ReadableType10HierarchicalEntityExtractor, ReadableType10IntentClassifier, ReadableType10ListEntityExtractor, ReadableType10PatternAnyEntityExtractor, ReadableType10PrebuiltEntityExtractor, ReadableType10RegexEntityExtractor}
}

// ReadableType11 enumerates the values for readable type 11.
type ReadableType11 string

const (
	// ReadableType11ChildEntityExtractor ...
	ReadableType11ChildEntityExtractor ReadableType11 = "Child Entity Extractor"
	// ReadableType11ClosedListEntityExtractor ...
	ReadableType11ClosedListEntityExtractor ReadableType11 = "Closed List Entity Extractor"
	// ReadableType11CompositeEntityExtractor ...
	ReadableType11CompositeEntityExtractor ReadableType11 = "Composite Entity Extractor"
	// ReadableType11EntityExtractor ...
	ReadableType11EntityExtractor ReadableType11 = "Entity Extractor"
	// ReadableType11HierarchicalChildEntityExtractor ...
	ReadableType11HierarchicalChildEntityExtractor ReadableType11 = "Hierarchical Child Entity Extractor"
	// ReadableType11HierarchicalEntityExtractor ...
	ReadableType11HierarchicalEntityExtractor ReadableType11 = "Hierarchical Entity Extractor"
	// ReadableType11IntentClassifier ...
	ReadableType11IntentClassifier ReadableType11 = "Intent Classifier"
	// ReadableType11ListEntityExtractor ...
	ReadableType11ListEntityExtractor ReadableType11 = "List Entity Extractor"
	// ReadableType11PatternAnyEntityExtractor ...
	ReadableType11PatternAnyEntityExtractor ReadableType11 = "Pattern.Any Entity Extractor"
	// ReadableType11PrebuiltEntityExtractor ...
	ReadableType11PrebuiltEntityExtractor ReadableType11 = "Prebuilt Entity Extractor"
	// ReadableType11RegexEntityExtractor ...
	ReadableType11RegexEntityExtractor ReadableType11 = "Regex Entity Extractor"
)

// PossibleReadableType11Values returns an array of possible values for the ReadableType11 const type.
func PossibleReadableType11Values() []ReadableType11 {
	return []ReadableType11{ReadableType11ChildEntityExtractor, ReadableType11ClosedListEntityExtractor, ReadableType11CompositeEntityExtractor, ReadableType11EntityExtractor, ReadableType11HierarchicalChildEntityExtractor, ReadableType11HierarchicalEntityExtractor, ReadableType11IntentClassifier, ReadableType11ListEntityExtractor, ReadableType11PatternAnyEntityExtractor, ReadableType11PrebuiltEntityExtractor, ReadableType11RegexEntityExtractor}
}

// ReadableType2 enumerates the values for readable type 2.
type ReadableType2 string

const (
	// ReadableType2ChildEntityExtractor ...
	ReadableType2ChildEntityExtractor ReadableType2 = "Child Entity Extractor"
	// ReadableType2ClosedListEntityExtractor ...
	ReadableType2ClosedListEntityExtractor ReadableType2 = "Closed List Entity Extractor"
	// ReadableType2CompositeEntityExtractor ...
	ReadableType2CompositeEntityExtractor ReadableType2 = "Composite Entity Extractor"
	// ReadableType2EntityExtractor ...
	ReadableType2EntityExtractor ReadableType2 = "Entity Extractor"
	// ReadableType2HierarchicalChildEntityExtractor ...
	ReadableType2HierarchicalChildEntityExtractor ReadableType2 = "Hierarchical Child Entity Extractor"
	// ReadableType2HierarchicalEntityExtractor ...
	ReadableType2HierarchicalEntityExtractor ReadableType2 = "Hierarchical Entity Extractor"
	// ReadableType2IntentClassifier ...
	ReadableType2IntentClassifier ReadableType2 = "Intent Classifier"
	// ReadableType2ListEntityExtractor ...
	ReadableType2ListEntityExtractor ReadableType2 = "List Entity Extractor"
	// ReadableType2PatternAnyEntityExtractor ...
	ReadableType2PatternAnyEntityExtractor ReadableType2 = "Pattern.Any Entity Extractor"
	// ReadableType2PrebuiltEntityExtractor ...
	ReadableType2PrebuiltEntityExtractor ReadableType2 = "Prebuilt Entity Extractor"
	// ReadableType2RegexEntityExtractor ...
	ReadableType2RegexEntityExtractor ReadableType2 = "Regex Entity Extractor"
)

// PossibleReadableType2Values returns an array of possible values for the ReadableType2 const type.
func PossibleReadableType2Values() []ReadableType2 {
	return []ReadableType2{ReadableType2ChildEntityExtractor, ReadableType2ClosedListEntityExtractor, ReadableType2CompositeEntityExtractor, ReadableType2EntityExtractor, ReadableType2HierarchicalChildEntityExtractor, ReadableType2HierarchicalEntityExtractor, ReadableType2IntentClassifier, ReadableType2ListEntityExtractor, ReadableType2PatternAnyEntityExtractor, ReadableType2PrebuiltEntityExtractor, ReadableType2RegexEntityExtractor}
}

// ReadableType3 enumerates the values for readable type 3.
type ReadableType3 string

const (
	// ReadableType3ChildEntityExtractor ...
	ReadableType3ChildEntityExtractor ReadableType3 = "Child Entity Extractor"
	// ReadableType3ClosedListEntityExtractor ...
	ReadableType3ClosedListEntityExtractor ReadableType3 = "Closed List Entity Extractor"
	// ReadableType3CompositeEntityExtractor ...
	ReadableType3CompositeEntityExtractor ReadableType3 = "Composite Entity Extractor"
	// ReadableType3EntityExtractor ...
	ReadableType3EntityExtractor ReadableType3 = "Entity Extractor"
	// ReadableType3HierarchicalChildEntityExtractor ...
	ReadableType3HierarchicalChildEntityExtractor ReadableType3 = "Hierarchical Child Entity Extractor"
	// ReadableType3HierarchicalEntityExtractor ...
	ReadableType3HierarchicalEntityExtractor ReadableType3 = "Hierarchical Entity Extractor"
	// ReadableType3IntentClassifier ...
	ReadableType3IntentClassifier ReadableType3 = "Intent Classifier"
	// ReadableType3ListEntityExtractor ...
	ReadableType3ListEntityExtractor ReadableType3 = "List Entity Extractor"
	// ReadableType3PatternAnyEntityExtractor ...
	ReadableType3PatternAnyEntityExtractor ReadableType3 = "Pattern.Any Entity Extractor"
	// ReadableType3PrebuiltEntityExtractor ...
	ReadableType3PrebuiltEntityExtractor ReadableType3 = "Prebuilt Entity Extractor"
	// ReadableType3RegexEntityExtractor ...
	ReadableType3RegexEntityExtractor ReadableType3 = "Regex Entity Extractor"
)

// PossibleReadableType3Values returns an array of possible values for the ReadableType3 const type.
func PossibleReadableType3Values() []ReadableType3 {
	return []ReadableType3{ReadableType3ChildEntityExtractor, ReadableType3ClosedListEntityExtractor, ReadableType3CompositeEntityExtractor, ReadableType3EntityExtractor, ReadableType3HierarchicalChildEntityExtractor, ReadableType3HierarchicalEntityExtractor, ReadableType3IntentClassifier, ReadableType3ListEntityExtractor, ReadableType3PatternAnyEntityExtractor, ReadableType3PrebuiltEntityExtractor, ReadableType3RegexEntityExtractor}
}

// ReadableType4 enumerates the values for readable type 4.
type ReadableType4 string

const (
	// ReadableType4ChildEntityExtractor ...
	ReadableType4ChildEntityExtractor ReadableType4 = "Child Entity Extractor"
	// ReadableType4ClosedListEntityExtractor ...
	ReadableType4ClosedListEntityExtractor ReadableType4 = "Closed List Entity Extractor"
	// ReadableType4CompositeEntityExtractor ...
	ReadableType4CompositeEntityExtractor ReadableType4 = "Composite Entity Extractor"
	// ReadableType4EntityExtractor ...
	ReadableType4EntityExtractor ReadableType4 = "Entity Extractor"
	// ReadableType4HierarchicalChildEntityExtractor ...
	ReadableType4HierarchicalChildEntityExtractor ReadableType4 = "Hierarchical Child Entity Extractor"
	// ReadableType4HierarchicalEntityExtractor ...
	ReadableType4HierarchicalEntityExtractor ReadableType4 = "Hierarchical Entity Extractor"
	// ReadableType4IntentClassifier ...
	ReadableType4IntentClassifier ReadableType4 = "Intent Classifier"
	// ReadableType4ListEntityExtractor ...
	ReadableType4ListEntityExtractor ReadableType4 = "List Entity Extractor"
	// ReadableType4PatternAnyEntityExtractor ...
	ReadableType4PatternAnyEntityExtractor ReadableType4 = "Pattern.Any Entity Extractor"
	// ReadableType4PrebuiltEntityExtractor ...
	ReadableType4PrebuiltEntityExtractor ReadableType4 = "Prebuilt Entity Extractor"
	// ReadableType4RegexEntityExtractor ...
	ReadableType4RegexEntityExtractor ReadableType4 = "Regex Entity Extractor"
)

// PossibleReadableType4Values returns an array of possible values for the ReadableType4 const type.
func PossibleReadableType4Values() []ReadableType4 {
	return []ReadableType4{ReadableType4ChildEntityExtractor, ReadableType4ClosedListEntityExtractor, ReadableType4CompositeEntityExtractor, ReadableType4EntityExtractor, ReadableType4HierarchicalChildEntityExtractor, ReadableType4HierarchicalEntityExtractor, ReadableType4IntentClassifier, ReadableType4ListEntityExtractor, ReadableType4PatternAnyEntityExtractor, ReadableType4PrebuiltEntityExtractor, ReadableType4RegexEntityExtractor}
}

// ReadableType5 enumerates the values for readable type 5.
type ReadableType5 string

const (
	// ReadableType5ChildEntityExtractor ...
	ReadableType5ChildEntityExtractor ReadableType5 = "Child Entity Extractor"
	// ReadableType5ClosedListEntityExtractor ...
	ReadableType5ClosedListEntityExtractor ReadableType5 = "Closed List Entity Extractor"
	// ReadableType5CompositeEntityExtractor ...
	ReadableType5CompositeEntityExtractor ReadableType5 = "Composite Entity Extractor"
	// ReadableType5EntityExtractor ...
	ReadableType5EntityExtractor ReadableType5 = "Entity Extractor"
	// ReadableType5HierarchicalChildEntityExtractor ...
	ReadableType5HierarchicalChildEntityExtractor ReadableType5 = "Hierarchical Child Entity Extractor"
	// ReadableType5HierarchicalEntityExtractor ...
	ReadableType5HierarchicalEntityExtractor ReadableType5 = "Hierarchical Entity Extractor"
	// ReadableType5IntentClassifier ...
	ReadableType5IntentClassifier ReadableType5 = "Intent Classifier"
	// ReadableType5ListEntityExtractor ...
	ReadableType5ListEntityExtractor ReadableType5 = "List Entity Extractor"
	// ReadableType5PatternAnyEntityExtractor ...
	ReadableType5PatternAnyEntityExtractor ReadableType5 = "Pattern.Any Entity Extractor"
	// ReadableType5PrebuiltEntityExtractor ...
	ReadableType5PrebuiltEntityExtractor ReadableType5 = "Prebuilt Entity Extractor"
	// ReadableType5RegexEntityExtractor ...
	ReadableType5RegexEntityExtractor ReadableType5 = "Regex Entity Extractor"
)

// PossibleReadableType5Values returns an array of possible values for the ReadableType5 const type.
func PossibleReadableType5Values() []ReadableType5 {
	return []ReadableType5{ReadableType5ChildEntityExtractor, ReadableType5ClosedListEntityExtractor, ReadableType5CompositeEntityExtractor, ReadableType5EntityExtractor, ReadableType5HierarchicalChildEntityExtractor, ReadableType5HierarchicalEntityExtractor, ReadableType5IntentClassifier, ReadableType5ListEntityExtractor, ReadableType5PatternAnyEntityExtractor, ReadableType5PrebuiltEntityExtractor, ReadableType5RegexEntityExtractor}
}

// ReadableType6 enumerates the values for readable type 6.
type ReadableType6 string

const (
	// ReadableType6ChildEntityExtractor ...
	ReadableType6ChildEntityExtractor ReadableType6 = "Child Entity Extractor"
	// ReadableType6ClosedListEntityExtractor ...
	ReadableType6ClosedListEntityExtractor ReadableType6 = "Closed List Entity Extractor"
	// ReadableType6CompositeEntityExtractor ...
	ReadableType6CompositeEntityExtractor ReadableType6 = "Composite Entity Extractor"
	// ReadableType6EntityExtractor ...
	ReadableType6EntityExtractor ReadableType6 = "Entity Extractor"
	// ReadableType6HierarchicalChildEntityExtractor ...
	ReadableType6HierarchicalChildEntityExtractor ReadableType6 = "Hierarchical Child Entity Extractor"
	// ReadableType6HierarchicalEntityExtractor ...
	ReadableType6HierarchicalEntityExtractor ReadableType6 = "Hierarchical Entity Extractor"
	// ReadableType6IntentClassifier ...
	ReadableType6IntentClassifier ReadableType6 = "Intent Classifier"
	// ReadableType6ListEntityExtractor ...
	ReadableType6ListEntityExtractor ReadableType6 = "List Entity Extractor"
	// ReadableType6PatternAnyEntityExtractor ...
	ReadableType6PatternAnyEntityExtractor ReadableType6 = "Pattern.Any Entity Extractor"
	// ReadableType6PrebuiltEntityExtractor ...
	ReadableType6PrebuiltEntityExtractor ReadableType6 = "Prebuilt Entity Extractor"
	// ReadableType6RegexEntityExtractor ...
	ReadableType6RegexEntityExtractor ReadableType6 = "Regex Entity Extractor"
)

// PossibleReadableType6Values returns an array of possible values for the ReadableType6 const type.
func PossibleReadableType6Values() []ReadableType6 {
	return []ReadableType6{ReadableType6ChildEntityExtractor, ReadableType6ClosedListEntityExtractor, ReadableType6CompositeEntityExtractor, ReadableType6EntityExtractor, ReadableType6HierarchicalChildEntityExtractor, ReadableType6HierarchicalEntityExtractor, ReadableType6IntentClassifier, ReadableType6ListEntityExtractor, ReadableType6PatternAnyEntityExtractor, ReadableType6PrebuiltEntityExtractor, ReadableType6RegexEntityExtractor}
}

// ReadableType7 enumerates the values for readable type 7.
type ReadableType7 string

const (
	// ReadableType7ChildEntityExtractor ...
	ReadableType7ChildEntityExtractor ReadableType7 = "Child Entity Extractor"
	// ReadableType7ClosedListEntityExtractor ...
	ReadableType7ClosedListEntityExtractor ReadableType7 = "Closed List Entity Extractor"
	// ReadableType7CompositeEntityExtractor ...
	ReadableType7CompositeEntityExtractor ReadableType7 = "Composite Entity Extractor"
	// ReadableType7EntityExtractor ...
	ReadableType7EntityExtractor ReadableType7 = "Entity Extractor"
	// ReadableType7HierarchicalChildEntityExtractor ...
	ReadableType7HierarchicalChildEntityExtractor ReadableType7 = "Hierarchical Child Entity Extractor"
	// ReadableType7HierarchicalEntityExtractor ...
	ReadableType7HierarchicalEntityExtractor ReadableType7 = "Hierarchical Entity Extractor"
	// ReadableType7IntentClassifier ...
	ReadableType7IntentClassifier ReadableType7 = "Intent Classifier"
	// ReadableType7ListEntityExtractor ...
	ReadableType7ListEntityExtractor ReadableType7 = "List Entity Extractor"
	// ReadableType7PatternAnyEntityExtractor ...
	ReadableType7PatternAnyEntityExtractor ReadableType7 = "Pattern.Any Entity Extractor"
	// ReadableType7PrebuiltEntityExtractor ...
	ReadableType7PrebuiltEntityExtractor ReadableType7 = "Prebuilt Entity Extractor"
	// ReadableType7RegexEntityExtractor ...
	ReadableType7RegexEntityExtractor ReadableType7 = "Regex Entity Extractor"
)

// PossibleReadableType7Values returns an array of possible values for the ReadableType7 const type.
func PossibleReadableType7Values() []ReadableType7 {
	return []ReadableType7{ReadableType7ChildEntityExtractor, ReadableType7ClosedListEntityExtractor, ReadableType7CompositeEntityExtractor, ReadableType7EntityExtractor, ReadableType7HierarchicalChildEntityExtractor, ReadableType7HierarchicalEntityExtractor, ReadableType7IntentClassifier, ReadableType7ListEntityExtractor, ReadableType7PatternAnyEntityExtractor, ReadableType7PrebuiltEntityExtractor, ReadableType7RegexEntityExtractor}
}

// ReadableType8 enumerates the values for readable type 8.
type ReadableType8 string

const (
	// ReadableType8ChildEntityExtractor ...
	ReadableType8ChildEntityExtractor ReadableType8 = "Child Entity Extractor"
	// ReadableType8ClosedListEntityExtractor ...
	ReadableType8ClosedListEntityExtractor ReadableType8 = "Closed List Entity Extractor"
	// ReadableType8CompositeEntityExtractor ...
	ReadableType8CompositeEntityExtractor ReadableType8 = "Composite Entity Extractor"
	// ReadableType8EntityExtractor ...
	ReadableType8EntityExtractor ReadableType8 = "Entity Extractor"
	// ReadableType8HierarchicalChildEntityExtractor ...
	ReadableType8HierarchicalChildEntityExtractor ReadableType8 = "Hierarchical Child Entity Extractor"
	// ReadableType8HierarchicalEntityExtractor ...
	ReadableType8HierarchicalEntityExtractor ReadableType8 = "Hierarchical Entity Extractor"
	// ReadableType8IntentClassifier ...
	ReadableType8IntentClassifier ReadableType8 = "Intent Classifier"
	// ReadableType8ListEntityExtractor ...
	ReadableType8ListEntityExtractor ReadableType8 = "List Entity Extractor"
	// ReadableType8PatternAnyEntityExtractor ...
	ReadableType8PatternAnyEntityExtractor ReadableType8 = "Pattern.Any Entity Extractor"
	// ReadableType8PrebuiltEntityExtractor ...
	ReadableType8PrebuiltEntityExtractor ReadableType8 = "Prebuilt Entity Extractor"
	// ReadableType8RegexEntityExtractor ...
	ReadableType8RegexEntityExtractor ReadableType8 = "Regex Entity Extractor"
)

// PossibleReadableType8Values returns an array of possible values for the ReadableType8 const type.
func PossibleReadableType8Values() []ReadableType8 {
	return []ReadableType8{ReadableType8ChildEntityExtractor, ReadableType8ClosedListEntityExtractor, ReadableType8CompositeEntityExtractor, ReadableType8EntityExtractor, ReadableType8HierarchicalChildEntityExtractor, ReadableType8HierarchicalEntityExtractor, ReadableType8IntentClassifier, ReadableType8ListEntityExtractor, ReadableType8PatternAnyEntityExtractor, ReadableType8PrebuiltEntityExtractor, ReadableType8RegexEntityExtractor}
}

// ReadableType9 enumerates the values for readable type 9.
type ReadableType9 string

const (
	// ReadableType9ChildEntityExtractor ...
	ReadableType9ChildEntityExtractor ReadableType9 = "Child Entity Extractor"
	// ReadableType9ClosedListEntityExtractor ...
	ReadableType9ClosedListEntityExtractor ReadableType9 = "Closed List Entity Extractor"
	// ReadableType9CompositeEntityExtractor ...
	ReadableType9CompositeEntityExtractor ReadableType9 = "Composite Entity Extractor"
	// ReadableType9EntityExtractor ...
	ReadableType9EntityExtractor ReadableType9 = "Entity Extractor"
	// ReadableType9HierarchicalChildEntityExtractor ...
	ReadableType9HierarchicalChildEntityExtractor ReadableType9 = "Hierarchical Child Entity Extractor"
	// ReadableType9HierarchicalEntityExtractor ...
	ReadableType9HierarchicalEntityExtractor ReadableType9 = "Hierarchical Entity Extractor"
	// ReadableType9IntentClassifier ...
	ReadableType9IntentClassifier ReadableType9 = "Intent Classifier"
	// ReadableType9ListEntityExtractor ...
	ReadableType9ListEntityExtractor ReadableType9 = "List Entity Extractor"
	// ReadableType9PatternAnyEntityExtractor ...
	ReadableType9PatternAnyEntityExtractor ReadableType9 = "Pattern.Any Entity Extractor"
	// ReadableType9PrebuiltEntityExtractor ...
	ReadableType9PrebuiltEntityExtractor ReadableType9 = "Prebuilt Entity Extractor"
	// ReadableType9RegexEntityExtractor ...
	ReadableType9RegexEntityExtractor ReadableType9 = "Regex Entity Extractor"
)

// PossibleReadableType9Values returns an array of possible values for the ReadableType9 const type.
func PossibleReadableType9Values() []ReadableType9 {
	return []ReadableType9{ReadableType9ChildEntityExtractor, ReadableType9ClosedListEntityExtractor, ReadableType9CompositeEntityExtractor, ReadableType9EntityExtractor, ReadableType9HierarchicalChildEntityExtractor, ReadableType9HierarchicalEntityExtractor, ReadableType9IntentClassifier, ReadableType9ListEntityExtractor, ReadableType9PatternAnyEntityExtractor, ReadableType9PrebuiltEntityExtractor, ReadableType9RegexEntityExtractor}
}

// Status enumerates the values for status.
type Status string

const (
	// StatusFail ...
	StatusFail Status = "Fail"
	// StatusInProgress ...
	StatusInProgress Status = "InProgress"
	// StatusQueued ...
	StatusQueued Status = "Queued"
	// StatusSuccess ...
	StatusSuccess Status = "Success"
	// StatusUpToDate ...
	StatusUpToDate Status = "UpToDate"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{StatusFail, StatusInProgress, StatusQueued, StatusSuccess, StatusUpToDate}
}

// Status1 enumerates the values for status 1.
type Status1 string

const (
	// Status1Fail ...
	Status1Fail Status1 = "Fail"
	// Status1InProgress ...
	Status1InProgress Status1 = "InProgress"
	// Status1Queued ...
	Status1Queued Status1 = "Queued"
	// Status1Success ...
	Status1Success Status1 = "Success"
	// Status1UpToDate ...
	Status1UpToDate Status1 = "UpToDate"
)

// PossibleStatus1Values returns an array of possible values for the Status1 const type.
func PossibleStatus1Values() []Status1 {
	return []Status1{Status1Fail, Status1InProgress, Status1Queued, Status1Success, Status1UpToDate}
}

// TrainingStatus enumerates the values for training status.
type TrainingStatus string

const (
	// InProgress ...
	InProgress TrainingStatus = "InProgress"
	// NeedsTraining ...
	NeedsTraining TrainingStatus = "NeedsTraining"
	// Trained ...
	Trained TrainingStatus = "Trained"
)

// PossibleTrainingStatusValues returns an array of possible values for the TrainingStatus const type.
func PossibleTrainingStatusValues() []TrainingStatus {
	return []TrainingStatus{InProgress, NeedsTraining, Trained}
}

// ApplicationCreateObject properties for creating a new LUIS Application
type ApplicationCreateObject struct {
	// Culture - The culture for the new application. It is the language that your app understands and speaks. E.g.: "en-us". Note: the culture cannot be changed after the app is created.
	Culture *string `json:"culture,omitempty"`
	// Domain - The domain for the new application. Optional. E.g.: Comics.
	Domain *string `json:"domain,omitempty"`
	// Description - Description of the new application. Optional.
	Description *string `json:"description,omitempty"`
	// InitialVersionID - The initial version ID. Optional. Default value is: "0.1"
	InitialVersionID *string `json:"initialVersionId,omitempty"`
	// UsageScenario - Defines the scenario for the new application. Optional. E.g.: IoT.
	UsageScenario *string `json:"usageScenario,omitempty"`
	// Name - The name for the new application.
	Name *string `json:"name,omitempty"`
}

// ApplicationInfoResponse response containing the Application Info.
type ApplicationInfoResponse struct {
	autorest.Response `json:"-"`
	// ID - The ID (GUID) of the application.
	ID *uuid.UUID `json:"id,omitempty"`
	// Name - The name of the application.
	Name *string `json:"name,omitempty"`
	// Description - The description of the application.
	Description *string `json:"description,omitempty"`
	// Culture - The culture of the application. For example, "en-us".
	Culture *string `json:"culture,omitempty"`
	// UsageScenario - Defines the scenario for the new application. Optional. For example, IoT.
	UsageScenario *string `json:"usageScenario,omitempty"`
	// Domain - The domain for the new application. Optional. For example, Comics.
	Domain *string `json:"domain,omitempty"`
	// VersionsCount - Amount of model versions within the application.
	VersionsCount *int32 `json:"versionsCount,omitempty"`
	// CreatedDateTime - The version's creation timestamp.
	CreatedDateTime *string `json:"createdDateTime,omitempty"`
	// Endpoints - The Runtime endpoint URL for this model version.
	Endpoints interface{} `json:"endpoints,omitempty"`
	// EndpointHitsCount - Number of calls made to this endpoint.
	EndpointHitsCount *int32 `json:"endpointHitsCount,omitempty"`
	// ActiveVersion - The version ID currently marked as active.
	ActiveVersion *string `json:"activeVersion,omitempty"`
}

// ApplicationPublishObject object model for publishing a specific application version.
type ApplicationPublishObject struct {
	// VersionID - The version ID to publish.
	VersionID *string `json:"versionId,omitempty"`
	// IsStaging - Indicates if the staging slot should be used, instead of the Production one.
	IsStaging *bool `json:"isStaging,omitempty"`
}

// ApplicationSettings the application settings.
type ApplicationSettings struct {
	autorest.Response `json:"-"`
	// ID - The application ID.
	ID *uuid.UUID `json:"id,omitempty"`
	// IsPublic - Setting your application as public allows other people to use your application's endpoint using their own keys for billing purposes.
	IsPublic *bool `json:"public,omitempty"`
}

// ApplicationSettingUpdateObject object model for updating an application's settings.
type ApplicationSettingUpdateObject struct {
	// IsPublic - Setting your application as public allows other people to use your application's endpoint using their own keys.
	IsPublic *bool `json:"public,omitempty"`
}

// ApplicationUpdateObject object model for updating the name or description of an application.
type ApplicationUpdateObject struct {
	// Name - The application's new name.
	Name *string `json:"name,omitempty"`
	// Description - The application's new description.
	Description *string `json:"description,omitempty"`
}

// AppVersionSettingObject object model of an application version setting.
type AppVersionSettingObject struct {
	// Name - The application version setting name.
	Name *string `json:"name,omitempty"`
	// Value - The application version setting value.
	Value *string `json:"value,omitempty"`
}

// AvailableCulture available culture for using in a new application.
type AvailableCulture struct {
	// Name - The language name.
	Name *string `json:"name,omitempty"`
	// Code - The ISO value for the language.
	Code *string `json:"code,omitempty"`
}

// AvailablePrebuiltEntityModel available Prebuilt entity model for using in an application.
type AvailablePrebuiltEntityModel struct {
	// Name - The entity name.
	Name *string `json:"name,omitempty"`
	// Description - The entity description and usage information.
	Description *string `json:"description,omitempty"`
	// Examples - Usage examples.
	Examples *string `json:"examples,omitempty"`
}

// AzureAccountInfoObject defines the Azure account information object.
type AzureAccountInfoObject struct {
	// AzureSubscriptionID - The id for the Azure subscription.
	AzureSubscriptionID *string `json:"azureSubscriptionId,omitempty"`
	// ResourceGroup - The Azure resource group name.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// AccountName - The Azure account name.
	AccountName *string `json:"accountName,omitempty"`
}

// BatchLabelExample response when adding a batch of labeled example utterances.
type BatchLabelExample struct {
	Value    *LabelExampleResponse `json:"value,omitempty"`
	HasError *bool                 `json:"hasError,omitempty"`
	Error    *OperationStatus      `json:"error,omitempty"`
}

// ChildEntity the base child entity type.
type ChildEntity struct {
	// ID - The ID (GUID) belonging to a child entity.
	ID *uuid.UUID `json:"id,omitempty"`
	// Name - The name of a child entity.
	Name *string `json:"name,omitempty"`
	// InstanceOf - Instance of Model.
	InstanceOf *string `json:"instanceOf,omitempty"`
	// TypeID - The type ID of the Entity Model.
	TypeID *int32 `json:"typeId,omitempty"`
	// ReadableType - Possible values include: 'ReadableType1EntityExtractor', 'ReadableType1ChildEntityExtractor', 'ReadableType1HierarchicalEntityExtractor', 'ReadableType1HierarchicalChildEntityExtractor', 'ReadableType1CompositeEntityExtractor', 'ReadableType1ListEntityExtractor', 'ReadableType1PrebuiltEntityExtractor', 'ReadableType1IntentClassifier', 'ReadableType1PatternAnyEntityExtractor', 'ReadableType1ClosedListEntityExtractor', 'ReadableType1RegexEntityExtractor'
	ReadableType ReadableType1 `json:"readableType,omitempty"`
	// Children - List of children
	Children *[]ChildEntity `json:"children,omitempty"`
}

// ChildEntityModelCreateObject a child entity extractor create object.
type ChildEntityModelCreateObject struct {
	// Children - Child entities.
	Children *[]ChildEntityModelCreateObject `json:"children,omitempty"`
	// Name - Entity name.
	Name *string `json:"name,omitempty"`
	// InstanceOf - The instance of model name
	InstanceOf *string `json:"instanceOf,omitempty"`
}

// ClosedList exported Model - A list entity.
type ClosedList struct {
	// Name - Name of the list entity.
	Name *string `json:"name,omitempty"`
	// SubLists - Sublists for the list entity.
	SubLists *[]SubClosedList `json:"subLists,omitempty"`
	Roles    *[]string        `json:"roles,omitempty"`
}

// ClosedListEntityExtractor list Entity Extractor.
type ClosedListEntityExtractor struct {
	autorest.Response `json:"-"`
	// ID - The ID of the Entity Model.
	ID *uuid.UUID `json:"id,omitempty"`
	// Name - Name of the Entity Model.
	Name *string `json:"name,omitempty"`
	// TypeID - The type ID of the Entity Model.
	TypeID *int32 `json:"typeId,omitempty"`
	// ReadableType - Possible values include: 'ReadableType5EntityExtractor', 'ReadableType5ChildEntityExtractor', 'ReadableType5HierarchicalEntityExtractor', 'ReadableType5HierarchicalChildEntityExtractor', 'ReadableType5CompositeEntityExtractor', 'ReadableType5ListEntityExtractor', 'ReadableType5PrebuiltEntityExtractor', 'ReadableType5IntentClassifier', 'ReadableType5PatternAnyEntityExtractor', 'ReadableType5ClosedListEntityExtractor', 'ReadableType5RegexEntityExtractor'
	ReadableType ReadableType5 `json:"readableType,omitempty"`
	Roles        *[]EntityRole `json:"roles,omitempty"`
	// SubLists - List of sublists.
	SubLists *[]SubClosedListResponse `json:"subLists,omitempty"`
}

// ClosedListModelCreateObject object model for creating a list entity.
type ClosedListModelCreateObject struct {
	// SubLists - Sublists for the feature.
	SubLists *[]WordListObject `json:"subLists,omitempty"`
	// Name - Name of the list entity.
	Name *string `json:"name,omitempty"`
}

// ClosedListModelPatchObject object model for adding a batch of sublists to an existing list entity.
type ClosedListModelPatchObject struct {
	// SubLists - Sublists to add.
	SubLists *[]WordListObject `json:"subLists,omitempty"`
}

// ClosedListModelUpdateObject object model for updating a list entity.
type ClosedListModelUpdateObject struct {
	// SubLists - The new sublists for the feature.
	SubLists *[]WordListObject `json:"subLists,omitempty"`
	// Name - The new name of the list entity.
	Name *string `json:"name,omitempty"`
}

// CollaboratorsArray ...
type CollaboratorsArray struct {
	// Emails - The email address of the users.
	Emails *[]string `json:"emails,omitempty"`
}

// CompositeChildModelCreateObject ...
type CompositeChildModelCreateObject struct {
	Name *string `json:"name,omitempty"`
}

// CompositeEntityExtractor a Composite Entity Extractor.
type CompositeEntityExtractor struct {
	autorest.Response `json:"-"`
	// ID - The ID of the Entity Model.
	ID *uuid.UUID `json:"id,omitempty"`
	// Name - Name of the Entity Model.
	Name *string `json:"name,omitempty"`
	// TypeID - The type ID of the Entity Model.
	TypeID *int32 `json:"typeId,omitempty"`
	// ReadableType - Possible values include: 'ReadableType4EntityExtractor', 'ReadableType4ChildEntityExtractor', 'ReadableType4HierarchicalEntityExtractor', 'ReadableType4HierarchicalChildEntityExtractor', 'ReadableType4CompositeEntityExtractor', 'ReadableType4ListEntityExtractor', 'ReadableType4PrebuiltEntityExtractor', 'ReadableType4IntentClassifier', 'ReadableType4PatternAnyEntityExtractor', 'ReadableType4ClosedListEntityExtractor', 'ReadableType4RegexEntityExtractor'
	ReadableType ReadableType4 `json:"readableType,omitempty"`
	Roles        *[]EntityRole `json:"roles,omitempty"`
	// Children - List of child entities.
	Children *[]ChildEntity `json:"children,omitempty"`
}

// CompositeEntityModel a composite entity extractor.
type CompositeEntityModel struct {
	// Children - Child entities.
	Children *[]string `json:"children,omitempty"`
	// Name - Entity name.
	Name *string `json:"name,omitempty"`
}

// CustomPrebuiltModel a Custom Prebuilt model.
type CustomPrebuiltModel struct {
	// ID - The ID of the Entity Model.
	ID *uuid.UUID `json:"id,omitempty"`
	// Name - Name of the Entity Model.
	Name *string `json:"name,omitempty"`
	// TypeID - The type ID of the Entity Model.
	TypeID *int32 `json:"typeId,omitempty"`
	// ReadableType - Possible values include: 'ReadableType7EntityExtractor', 'ReadableType7ChildEntityExtractor', 'ReadableType7HierarchicalEntityExtractor', 'ReadableType7HierarchicalChildEntityExtractor', 'ReadableType7CompositeEntityExtractor', 'ReadableType7ListEntityExtractor', 'ReadableType7PrebuiltEntityExtractor', 'ReadableType7IntentClassifier', 'ReadableType7PatternAnyEntityExtractor', 'ReadableType7ClosedListEntityExtractor', 'ReadableType7RegexEntityExtractor'
	ReadableType ReadableType7 `json:"readableType,omitempty"`
	// CustomPrebuiltDomainName - The domain name.
	CustomPrebuiltDomainName *string `json:"customPrebuiltDomainName,omitempty"`
	// CustomPrebuiltModelName - The intent name or entity name.
	CustomPrebuiltModelName *string       `json:"customPrebuiltModelName,omitempty"`
	Roles                   *[]EntityRole `json:"roles,omitempty"`
}

// EndpointInfo the base class "ProductionOrStagingEndpointInfo" inherits from.
type EndpointInfo struct {
	// VersionID - The version ID to publish.
	VersionID *string `json:"versionId,omitempty"`
	// IsStaging - Indicates if the staging slot should be used, instead of the Production one.
	IsStaging *bool `json:"isStaging,omitempty"`
	// EndpointURL - The Runtime endpoint URL for this model version.
	EndpointURL *string `json:"endpointUrl,omitempty"`
	// Region - The target region that the application is published to.
	Region *string `json:"region,omitempty"`
	// AssignedEndpointKey - The endpoint key.
	AssignedEndpointKey *string `json:"assignedEndpointKey,omitempty"`
	// EndpointRegion - The endpoint's region.
	EndpointRegion *string `json:"endpointRegion,omitempty"`
	// FailedRegions - Regions where publishing failed.
	FailedRegions *string `json:"failedRegions,omitempty"`
	// PublishedDateTime - Timestamp when was last published.
	PublishedDateTime *string `json:"publishedDateTime,omitempty"`
}

// EnqueueTrainingResponse response model when requesting to train the model.
type EnqueueTrainingResponse struct {
	autorest.Response `json:"-"`
	// StatusID - The train request status ID.
	StatusID *int32 `json:"statusId,omitempty"`
	// Status - Possible values include: 'StatusQueued', 'StatusInProgress', 'StatusUpToDate', 'StatusFail', 'StatusSuccess'
	Status Status `json:"status,omitempty"`
}

// EntitiesSuggestionExample predicted/suggested entity.
type EntitiesSuggestionExample struct {
	// Text - The utterance. For example, "What's the weather like in seattle?"
	Text *string `json:"text,omitempty"`
	// TokenizedText - The utterance tokenized.
	TokenizedText *[]string `json:"tokenizedText,omitempty"`
	// IntentPredictions - Predicted/suggested intents.
	IntentPredictions *[]IntentPrediction `json:"intentPredictions,omitempty"`
	// EntityPredictions - Predicted/suggested entities.
	EntityPredictions *[]EntityPrediction `json:"entityPredictions,omitempty"`
}

// EntityExtractor entity Extractor.
type EntityExtractor struct {
	// ID - The ID of the Entity Model.
	ID *uuid.UUID `json:"id,omitempty"`
	// Name - Name of the Entity Model.
	Name *string `json:"name,omitempty"`
	// TypeID - The type ID of the Entity Model.
	TypeID *int32 `json:"typeId,omitempty"`
	// ReadableType - Possible values include: 'ReadableType8EntityExtractor', 'ReadableType8ChildEntityExtractor', 'ReadableType8HierarchicalEntityExtractor', 'ReadableType8HierarchicalChildEntityExtractor', 'ReadableType8CompositeEntityExtractor', 'ReadableType8ListEntityExtractor', 'ReadableType8PrebuiltEntityExtractor', 'ReadableType8IntentClassifier', 'ReadableType8PatternAnyEntityExtractor', 'ReadableType8ClosedListEntityExtractor', 'ReadableType8RegexEntityExtractor'
	ReadableType ReadableType8 `json:"readableType,omitempty"`
	Roles        *[]EntityRole `json:"roles,omitempty"`
	// CustomPrebuiltDomainName - The domain name.
	CustomPrebuiltDomainName *string `json:"customPrebuiltDomainName,omitempty"`
	// CustomPrebuiltModelName - The intent name or entity name.
	CustomPrebuiltModelName *string `json:"customPrebuiltModelName,omitempty"`
}

// EntityLabel defines the entity type and position of the extracted entity within the example.
type EntityLabel struct {
	// EntityName - The entity type.
	EntityName *string `json:"entityName,omitempty"`
	// StartTokenIndex - The index within the utterance where the extracted entity starts.
	StartTokenIndex *int32 `json:"startTokenIndex,omitempty"`
	// EndTokenIndex - The index within the utterance where the extracted entity ends.
	EndTokenIndex *int32 `json:"endTokenIndex,omitempty"`
	// Role - The role of the predicted entity.
	Role *string `json:"role,omitempty"`
	// RoleID - The role id for the predicted entity.
	RoleID   *uuid.UUID     `json:"roleId,omitempty"`
	Children *[]EntityLabel `json:"children,omitempty"`
}

// EntityLabelObject defines the entity type and position of the extracted entity within the example.
type EntityLabelObject struct {
	// EntityName - The entity type.
	EntityName *string `json:"entityName,omitempty"`
	// StartCharIndex - The index within the utterance where the extracted entity starts.
	StartCharIndex *int32 `json:"startCharIndex,omitempty"`
	// EndCharIndex - The index within the utterance where the extracted entity ends.
	EndCharIndex *int32 `json:"endCharIndex,omitempty"`
	// Role - The role the entity plays in the utterance.
	Role *string `json:"role,omitempty"`
	// Children - The identified entities within the example utterance.
	Children *[]EntityLabelObject `json:"children,omitempty"`
}

// EntityModelCreateObject an entity extractor create object.
type EntityModelCreateObject struct {
	// Children - Child entities.
	Children *[]ChildEntityModelCreateObject `json:"children,omitempty"`
	// Name - Entity name.
	Name *string `json:"name,omitempty"`
}

// EntityModelInfo an Entity Extractor model info.
type EntityModelInfo struct {
	Roles *[]EntityRole `json:"roles,omitempty"`
	// ID - The ID of the Entity Model.
	ID *uuid.UUID `json:"id,omitempty"`
	// Name - Name of the Entity Model.
	Name *string `json:"name,omitempty"`
	// TypeID - The type ID of the Entity Model.
	TypeID *int32 `json:"typeId,omitempty"`
	// ReadableType - Possible values include: 'ReadableTypeEntityExtractor', 'ReadableTypeChildEntityExtractor', 'ReadableTypeHierarchicalEntityExtractor', 'ReadableTypeHierarchicalChildEntityExtractor', 'ReadableTypeCompositeEntityExtractor', 'ReadableTypeListEntityExtractor', 'ReadableTypePrebuiltEntityExtractor', 'ReadableTypeIntentClassifier', 'ReadableTypePatternAnyEntityExtractor', 'ReadableTypeClosedListEntityExtractor', 'ReadableTypeRegexEntityExtractor'
	ReadableType ReadableType `json:"readableType,omitempty"`
}

// EntityModelUpdateObject an entity extractor update object.
type EntityModelUpdateObject struct {
	// Name - Entity name.
	Name *string `json:"name,omitempty"`
	// InstanceOf - The instance of model name
	InstanceOf *string `json:"instanceOf,omitempty"`
}

// EntityPrediction a suggested entity.
type EntityPrediction struct {
	// EntityName - The entity's name
	EntityName *string `json:"entityName,omitempty"`
	// StartTokenIndex - The index within the utterance where the extracted entity starts.
	StartTokenIndex *int32 `json:"startTokenIndex,omitempty"`
	// EndTokenIndex - The index within the utterance where the extracted entity ends.
	EndTokenIndex *int32 `json:"endTokenIndex,omitempty"`
	// Phrase - The actual token(s) that comprise the entity.
	Phrase   *string             `json:"phrase,omitempty"`
	Children *[]EntityPrediction `json:"children,omitempty"`
}

// EntityRole entity extractor role
type EntityRole struct {
	autorest.Response `json:"-"`
	// ID - The entity role ID.
	ID *uuid.UUID `json:"id,omitempty"`
	// Name - The entity role name.
	Name *string `json:"name,omitempty"`
}

// EntityRoleCreateObject object model for creating an entity role.
type EntityRoleCreateObject struct {
	// Name - The entity role name.
	Name *string `json:"name,omitempty"`
}

// EntityRoleUpdateObject object model for updating an entity role.
type EntityRoleUpdateObject struct {
	// Name - The entity role name.
	Name *string `json:"name,omitempty"`
}

// ErrorResponse error response when invoking an operation on the API.
type ErrorResponse struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	ErrorType            *string                `json:"errorType,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorResponse.
func (er ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if er.ErrorType != nil {
		objectMap["errorType"] = er.ErrorType
	}
	for k, v := range er.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ErrorResponse struct.
func (er *ErrorResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if er.AdditionalProperties == nil {
					er.AdditionalProperties = make(map[string]interface{})
				}
				er.AdditionalProperties[k] = additionalProperties
			}
		case "errorType":
			if v != nil {
				var errorType string
				err = json.Unmarshal(*v, &errorType)
				if err != nil {
					return err
				}
				er.ErrorType = &errorType
			}
		}
	}

	return nil
}

// ExampleLabelObject a labeled example utterance.
type ExampleLabelObject struct {
	// Text - The example utterance.
	Text *string `json:"text,omitempty"`
	// EntityLabels - The identified entities within the example utterance.
	EntityLabels *[]EntityLabelObject `json:"entityLabels,omitempty"`
	// IntentName - The identified intent representing the example utterance.
	IntentName *string `json:"intentName,omitempty"`
}

// ExplicitListItem explicit (exception) list item
type ExplicitListItem struct {
	autorest.Response `json:"-"`
	// ID - The explicit list item ID.
	ID *int64 `json:"id,omitempty"`
	// ExplicitListItem - The explicit list item value.
	ExplicitListItem *string `json:"explicitListItem,omitempty"`
}

// ExplicitListItemCreateObject object model for creating an explicit (exception) list item.
type ExplicitListItemCreateObject struct {
	// ExplicitListItem - The explicit list item.
	ExplicitListItem *string `json:"explicitListItem,omitempty"`
}

// ExplicitListItemUpdateObject model object for updating an explicit (exception) list item.
type ExplicitListItemUpdateObject struct {
	// ExplicitListItem - The explicit list item.
	ExplicitListItem *string `json:"explicitListItem,omitempty"`
}

// FeatureInfoObject the base class Features-related response objects inherit from.
type FeatureInfoObject struct {
	// ID - A six-digit ID used for Features.
	ID *int32 `json:"id,omitempty"`
	// Name - The name of the Feature.
	Name *string `json:"name,omitempty"`
	// IsActive - Indicates if the feature is enabled.
	IsActive *bool `json:"isActive,omitempty"`
	// EnabledForAllModels - Indicates if the feature is enabled for all models in the application.
	EnabledForAllModels *bool `json:"enabledForAllModels,omitempty"`
}

// FeaturesResponseObject model Features, including Patterns and Phraselists.
type FeaturesResponseObject struct {
	autorest.Response  `json:"-"`
	PhraselistFeatures *[]PhraseListFeatureInfo `json:"phraselistFeatures,omitempty"`
	PatternFeatures    *[]PatternFeatureInfo    `json:"patternFeatures,omitempty"`
}

// HierarchicalChildEntity a Hierarchical Child Entity.
type HierarchicalChildEntity struct {
	autorest.Response `json:"-"`
	// ID - The ID (GUID) belonging to a child entity.
	ID *uuid.UUID `json:"id,omitempty"`
	// Name - The name of a child entity.
	Name *string `json:"name,omitempty"`
	// InstanceOf - Instance of Model.
	InstanceOf *string `json:"instanceOf,omitempty"`
	// TypeID - The type ID of the Entity Model.
	TypeID *int32 `json:"typeId,omitempty"`
	// ReadableType - Possible values include: 'ReadableType1EntityExtractor', 'ReadableType1ChildEntityExtractor', 'ReadableType1HierarchicalEntityExtractor', 'ReadableType1HierarchicalChildEntityExtractor', 'ReadableType1CompositeEntityExtractor', 'ReadableType1ListEntityExtractor', 'ReadableType1PrebuiltEntityExtractor', 'ReadableType1IntentClassifier', 'ReadableType1PatternAnyEntityExtractor', 'ReadableType1ClosedListEntityExtractor', 'ReadableType1RegexEntityExtractor'
	ReadableType ReadableType1 `json:"readableType,omitempty"`
	// Children - List of children
	Children *[]ChildEntity `json:"children,omitempty"`
}

// HierarchicalChildModelUpdateObject ...
type HierarchicalChildModelUpdateObject struct {
	Name *string `json:"name,omitempty"`
}

// HierarchicalEntityExtractor hierarchical Entity Extractor.
type HierarchicalEntityExtractor struct {
	autorest.Response `json:"-"`
	// ID - The ID of the Entity Model.
	ID *uuid.UUID `json:"id,omitempty"`
	// Name - Name of the Entity Model.
	Name *string `json:"name,omitempty"`
	// TypeID - The type ID of the Entity Model.
	TypeID *int32 `json:"typeId,omitempty"`
	// ReadableType - Possible values include: 'ReadableType3EntityExtractor', 'ReadableType3ChildEntityExtractor', 'ReadableType3HierarchicalEntityExtractor', 'ReadableType3HierarchicalChildEntityExtractor', 'ReadableType3CompositeEntityExtractor', 'ReadableType3ListEntityExtractor', 'ReadableType3PrebuiltEntityExtractor', 'ReadableType3IntentClassifier', 'ReadableType3PatternAnyEntityExtractor', 'ReadableType3ClosedListEntityExtractor', 'ReadableType3RegexEntityExtractor'
	ReadableType ReadableType3 `json:"readableType,omitempty"`
	Roles        *[]EntityRole `json:"roles,omitempty"`
	// Children - List of child entities.
	Children *[]ChildEntity `json:"children,omitempty"`
}

// HierarchicalModel ...
type HierarchicalModel struct {
	Name     *string                        `json:"name,omitempty"`
	Children *[]JSONChild                   `json:"children,omitempty"`
	Features *[]JSONModelFeatureInformation `json:"features,omitempty"`
	Roles    *[]string                      `json:"roles,omitempty"`
	Inherits *PrebuiltDomainObject          `json:"inherits,omitempty"`
}

// HierarchicalModelV2 ...
type HierarchicalModelV2 struct {
	Name     *string               `json:"name,omitempty"`
	Children *[]string             `json:"children,omitempty"`
	Inherits *PrebuiltDomainObject `json:"inherits,omitempty"`
	Roles    *[]string             `json:"roles,omitempty"`
}

// Int32 ...
type Int32 struct {
	autorest.Response `json:"-"`
	Value             *int32 `json:"value,omitempty"`
}

// Int64 ...
type Int64 struct {
	autorest.Response `json:"-"`
	Value             *int64 `json:"value,omitempty"`
}

// IntentClassifier intent Classifier.
type IntentClassifier struct {
	autorest.Response `json:"-"`
	// CustomPrebuiltDomainName - The domain name.
	CustomPrebuiltDomainName *string `json:"customPrebuiltDomainName,omitempty"`
	// CustomPrebuiltModelName - The intent name or entity name.
	CustomPrebuiltModelName *string `json:"customPrebuiltModelName,omitempty"`
	// ID - The ID of the Entity Model.
	ID *uuid.UUID `json:"id,omitempty"`
	// Name - Name of the Entity Model.
	Name *string `json:"name,omitempty"`
	// TypeID - The type ID of the Entity Model.
	TypeID *int32 `json:"typeId,omitempty"`
	// ReadableType - Possible values include: 'ReadableTypeEntityExtractor', 'ReadableTypeChildEntityExtractor', 'ReadableTypeHierarchicalEntityExtractor', 'ReadableTypeHierarchicalChildEntityExtractor', 'ReadableTypeCompositeEntityExtractor', 'ReadableTypeListEntityExtractor', 'ReadableTypePrebuiltEntityExtractor', 'ReadableTypeIntentClassifier', 'ReadableTypePatternAnyEntityExtractor', 'ReadableTypeClosedListEntityExtractor', 'ReadableTypeRegexEntityExtractor'
	ReadableType ReadableType `json:"readableType,omitempty"`
}

// IntentPrediction a suggested intent.
type IntentPrediction struct {
	// Name - The intent's name
	Name *string `json:"name,omitempty"`
	// Score - The intent's score, based on the prediction model.
	Score *float64 `json:"score,omitempty"`
}

// IntentsSuggestionExample predicted/suggested intent.
type IntentsSuggestionExample struct {
	// Text - The utterance. For example, "What's the weather like in seattle?"
	Text *string `json:"text,omitempty"`
	// TokenizedText - The tokenized utterance.
	TokenizedText *[]string `json:"tokenizedText,omitempty"`
	// IntentPredictions - Predicted/suggested intents.
	IntentPredictions *[]IntentPrediction `json:"intentPredictions,omitempty"`
	// EntityPredictions - Predicted/suggested entities.
	EntityPredictions *[]EntityPrediction `json:"entityPredictions,omitempty"`
}

// JSONChild ...
type JSONChild struct {
	Name       *string                        `json:"name,omitempty"`
	InstanceOf *string                        `json:"instanceOf,omitempty"`
	Children   *[]JSONChild                   `json:"children,omitempty"`
	Features   *[]JSONModelFeatureInformation `json:"features,omitempty"`
}

// JSONEntity exported Model - Extracted Entity from utterance.
type JSONEntity struct {
	// StartPos - The index within the utterance where the extracted entity starts.
	StartPos *int32 `json:"startPos,omitempty"`
	// EndPos - The index within the utterance where the extracted entity ends.
	EndPos *int32 `json:"endPos,omitempty"`
	// Entity - The entity name.
	Entity *string `json:"entity,omitempty"`
	// Role - The role the entity plays in the utterance.
	Role     *string       `json:"role,omitempty"`
	Children *[]JSONEntity `json:"children,omitempty"`
}

// JSONModelFeature exported Model - Phraselist Model Feature.
type JSONModelFeature struct {
	// Activated - Indicates if the feature is enabled.
	Activated *bool `json:"activated,omitempty"`
	// Name - The Phraselist name.
	Name *string `json:"name,omitempty"`
	// Words - List of comma-separated phrases that represent the Phraselist.
	Words *string `json:"words,omitempty"`
	// Mode - An interchangeable phrase list feature serves as a list of synonyms for training. A non-exchangeable phrase list serves as separate features for training. So, if your non-interchangeable phrase list contains 5 phrases, they will be mapped to 5 separate features. You can think of the non-interchangeable phrase list as an additional bag of words to add to LUIS existing vocabulary features. It is used as a lexicon lookup feature where its value is 1 if the lexicon contains a given word or 0 if it doesn’t.  Default value is true.
	Mode *bool `json:"mode,omitempty"`
	// EnabledForAllModels - Indicates if the Phraselist is enabled for all models in the application.
	EnabledForAllModels *bool `json:"enabledForAllModels,omitempty"`
}

// JSONModelFeatureInformation an object containing the model feature information either the model name or
// feature name.
type JSONModelFeatureInformation struct {
	// ModelName - The name of the model used.
	ModelName *string `json:"modelName,omitempty"`
	// FeatureName - The name of the feature used.
	FeatureName *string `json:"featureName,omitempty"`
}

// JSONRegexFeature exported Model - A Pattern feature.
type JSONRegexFeature struct {
	// Pattern - The Regular Expression to match.
	Pattern *string `json:"pattern,omitempty"`
	// Activated - Indicates if the Pattern feature is enabled.
	Activated *bool `json:"activated,omitempty"`
	// Name - Name of the feature.
	Name *string `json:"name,omitempty"`
}

// JSONUtterance exported Model - Utterance that was used to train the model.
type JSONUtterance struct {
	// Text - The utterance.
	Text *string `json:"text,omitempty"`
	// Intent - The matched intent.
	Intent *string `json:"intent,omitempty"`
	// Entities - The matched entities.
	Entities *[]JSONEntity `json:"entities,omitempty"`
}

// LabeledUtterance a prediction and label pair of an example.
type LabeledUtterance struct {
	// ID - ID of Labeled Utterance.
	ID *int32 `json:"id,omitempty"`
	// Text - The utterance. For example, "What's the weather like in seattle?"
	Text *string `json:"text,omitempty"`
	// TokenizedText - The utterance tokenized.
	TokenizedText *[]string `json:"tokenizedText,omitempty"`
	// IntentLabel - The intent matching the example.
	IntentLabel *string `json:"intentLabel,omitempty"`
	// EntityLabels - The entities matching the example.
	EntityLabels *[]EntityLabel `json:"entityLabels,omitempty"`
	// IntentPredictions - List of suggested intents.
	IntentPredictions *[]IntentPrediction `json:"intentPredictions,omitempty"`
	// EntityPredictions - List of suggested entities.
	EntityPredictions *[]EntityPrediction `json:"entityPredictions,omitempty"`
}

// LabelExampleResponse response when adding a labeled example utterance.
type LabelExampleResponse struct {
	autorest.Response `json:"-"`
	// UtteranceText - The example utterance.
	UtteranceText *string `json:"UtteranceText,omitempty"`
	// ExampleID - The newly created sample ID.
	ExampleID *int32 `json:"ExampleId,omitempty"`
}

// LabelTextObject an object containing the example utterance's text.
type LabelTextObject struct {
	// ID - The ID of the Label.
	ID *int32 `json:"id,omitempty"`
	// Text - The text of the label.
	Text *string `json:"text,omitempty"`
}

// ListApplicationInfoResponse ...
type ListApplicationInfoResponse struct {
	autorest.Response `json:"-"`
	Value             *[]ApplicationInfoResponse `json:"value,omitempty"`
}

// ListAppVersionSettingObject ...
type ListAppVersionSettingObject struct {
	autorest.Response `json:"-"`
	Value             *[]AppVersionSettingObject `json:"value,omitempty"`
}

// ListAvailableCulture ...
type ListAvailableCulture struct {
	autorest.Response `json:"-"`
	Value             *[]AvailableCulture `json:"value,omitempty"`
}

// ListAvailablePrebuiltEntityModel ...
type ListAvailablePrebuiltEntityModel struct {
	autorest.Response `json:"-"`
	Value             *[]AvailablePrebuiltEntityModel `json:"value,omitempty"`
}

// ListAzureAccountInfoObject ...
type ListAzureAccountInfoObject struct {
	autorest.Response `json:"-"`
	Value             *[]AzureAccountInfoObject `json:"value,omitempty"`
}

// ListBatchLabelExample ...
type ListBatchLabelExample struct {
	autorest.Response `json:"-"`
	Value             *[]BatchLabelExample `json:"value,omitempty"`
}

// ListClosedListEntityExtractor ...
type ListClosedListEntityExtractor struct {
	autorest.Response `json:"-"`
	Value             *[]ClosedListEntityExtractor `json:"value,omitempty"`
}

// ListCompositeEntityExtractor ...
type ListCompositeEntityExtractor struct {
	autorest.Response `json:"-"`
	Value             *[]CompositeEntityExtractor `json:"value,omitempty"`
}

// ListCustomPrebuiltModel ...
type ListCustomPrebuiltModel struct {
	autorest.Response `json:"-"`
	Value             *[]CustomPrebuiltModel `json:"value,omitempty"`
}

// ListEntitiesSuggestionExample ...
type ListEntitiesSuggestionExample struct {
	autorest.Response `json:"-"`
	Value             *[]EntitiesSuggestionExample `json:"value,omitempty"`
}

// ListEntityExtractor ...
type ListEntityExtractor struct {
	autorest.Response `json:"-"`
	Value             *[]EntityExtractor `json:"value,omitempty"`
}

// ListEntityRole ...
type ListEntityRole struct {
	autorest.Response `json:"-"`
	Value             *[]EntityRole `json:"value,omitempty"`
}

// ListExplicitListItem ...
type ListExplicitListItem struct {
	autorest.Response `json:"-"`
	Value             *[]ExplicitListItem `json:"value,omitempty"`
}

// ListHierarchicalEntityExtractor ...
type ListHierarchicalEntityExtractor struct {
	autorest.Response `json:"-"`
	Value             *[]HierarchicalEntityExtractor `json:"value,omitempty"`
}

// ListIntentClassifier ...
type ListIntentClassifier struct {
	autorest.Response `json:"-"`
	Value             *[]IntentClassifier `json:"value,omitempty"`
}

// ListIntentsSuggestionExample ...
type ListIntentsSuggestionExample struct {
	autorest.Response `json:"-"`
	Value             *[]IntentsSuggestionExample `json:"value,omitempty"`
}

// ListLabeledUtterance ...
type ListLabeledUtterance struct {
	autorest.Response `json:"-"`
	Value             *[]LabeledUtterance `json:"value,omitempty"`
}

// ListLabelTextObject ...
type ListLabelTextObject struct {
	autorest.Response `json:"-"`
	Value             *[]LabelTextObject `json:"value,omitempty"`
}

// ListModelFeatureInformation ...
type ListModelFeatureInformation struct {
	autorest.Response `json:"-"`
	Value             *[]ModelFeatureInformation `json:"value,omitempty"`
}

// ListModelInfoResponse ...
type ListModelInfoResponse struct {
	autorest.Response `json:"-"`
	Value             *[]ModelInfoResponse `json:"value,omitempty"`
}

// ListModelTrainingInfo ...
type ListModelTrainingInfo struct {
	autorest.Response `json:"-"`
	Value             *[]ModelTrainingInfo `json:"value,omitempty"`
}

// ListNDepthEntityExtractor ...
type ListNDepthEntityExtractor struct {
	autorest.Response `json:"-"`
	Value             *[]NDepthEntityExtractor `json:"value,omitempty"`
}

// ListPatternAnyEntityExtractor ...
type ListPatternAnyEntityExtractor struct {
	autorest.Response `json:"-"`
	Value             *[]PatternAnyEntityExtractor `json:"value,omitempty"`
}

// ListPatternRuleInfo ...
type ListPatternRuleInfo struct {
	autorest.Response `json:"-"`
	Value             *[]PatternRuleInfo `json:"value,omitempty"`
}

// ListPhraseListFeatureInfo ...
type ListPhraseListFeatureInfo struct {
	autorest.Response `json:"-"`
	Value             *[]PhraseListFeatureInfo `json:"value,omitempty"`
}

// ListPrebuiltDomain ...
type ListPrebuiltDomain struct {
	autorest.Response `json:"-"`
	Value             *[]PrebuiltDomain `json:"value,omitempty"`
}

// ListPrebuiltEntityExtractor ...
type ListPrebuiltEntityExtractor struct {
	autorest.Response `json:"-"`
	Value             *[]PrebuiltEntityExtractor `json:"value,omitempty"`
}

// ListRegexEntityExtractor ...
type ListRegexEntityExtractor struct {
	autorest.Response `json:"-"`
	Value             *[]RegexEntityExtractor `json:"value,omitempty"`
}

// ListString ...
type ListString struct {
	autorest.Response `json:"-"`
	Value             *[]string `json:"value,omitempty"`
}

// ListUUID ...
type ListUUID struct {
	autorest.Response `json:"-"`
	Value             *[]uuid.UUID `json:"value,omitempty"`
}

// ListVersionInfo ...
type ListVersionInfo struct {
	autorest.Response `json:"-"`
	Value             *[]VersionInfo `json:"value,omitempty"`
}

// LuisApp exported Model - An exported LUIS Application.
type LuisApp struct {
	autorest.Response `json:"-"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Name - The name of the application.
	Name *string `json:"name,omitempty"`
	// VersionID - The version ID of the application that was exported.
	VersionID *string `json:"versionId,omitempty"`
	// Desc - The description of the application.
	Desc *string `json:"desc,omitempty"`
	// Culture - The culture of the application. E.g.: en-us.
	Culture *string `json:"culture,omitempty"`
	// Intents - List of intents.
	Intents *[]HierarchicalModel `json:"intents,omitempty"`
	// Entities - List of entities.
	Entities *[]HierarchicalModel `json:"entities,omitempty"`
	// ClosedLists - List of list entities.
	ClosedLists *[]ClosedList `json:"closedLists,omitempty"`
	// Composites - List of composite entities.
	Composites *[]HierarchicalModel `json:"composites,omitempty"`
	// Hierarchicals - List of hierarchical entities.
	Hierarchicals *[]HierarchicalModel `json:"hierarchicals,omitempty"`
	// PatternAnyEntities - List of Pattern.Any entities.
	PatternAnyEntities *[]PatternAny `json:"patternAnyEntities,omitempty"`
	// RegexEntities - List of regular expression entities.
	RegexEntities *[]RegexEntity `json:"regex_entities,omitempty"`
	// PrebuiltEntities - List of prebuilt entities.
	PrebuiltEntities *[]PrebuiltEntity `json:"prebuiltEntities,omitempty"`
	// RegexFeatures - List of pattern features.
	RegexFeatures *[]JSONRegexFeature `json:"regex_features,omitempty"`
	// Phraselists - List of model features.
	Phraselists *[]JSONModelFeature `json:"phraselists,omitempty"`
	// Patterns - List of patterns.
	Patterns *[]PatternRule `json:"patterns,omitempty"`
	// Utterances - List of example utterances.
	Utterances *[]JSONUtterance `json:"utterances,omitempty"`
}

// MarshalJSON is the custom marshaler for LuisApp.
func (la LuisApp) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if la.Name != nil {
		objectMap["name"] = la.Name
	}
	if la.VersionID != nil {
		objectMap["versionId"] = la.VersionID
	}
	if la.Desc != nil {
		objectMap["desc"] = la.Desc
	}
	if la.Culture != nil {
		objectMap["culture"] = la.Culture
	}
	if la.Intents != nil {
		objectMap["intents"] = la.Intents
	}
	if la.Entities != nil {
		objectMap["entities"] = la.Entities
	}
	if la.ClosedLists != nil {
		objectMap["closedLists"] = la.ClosedLists
	}
	if la.Composites != nil {
		objectMap["composites"] = la.Composites
	}
	if la.Hierarchicals != nil {
		objectMap["hierarchicals"] = la.Hierarchicals
	}
	if la.PatternAnyEntities != nil {
		objectMap["patternAnyEntities"] = la.PatternAnyEntities
	}
	if la.RegexEntities != nil {
		objectMap["regex_entities"] = la.RegexEntities
	}
	if la.PrebuiltEntities != nil {
		objectMap["prebuiltEntities"] = la.PrebuiltEntities
	}
	if la.RegexFeatures != nil {
		objectMap["regex_features"] = la.RegexFeatures
	}
	if la.Phraselists != nil {
		objectMap["phraselists"] = la.Phraselists
	}
	if la.Patterns != nil {
		objectMap["patterns"] = la.Patterns
	}
	if la.Utterances != nil {
		objectMap["utterances"] = la.Utterances
	}
	for k, v := range la.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LuisApp struct.
func (la *LuisApp) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if la.AdditionalProperties == nil {
					la.AdditionalProperties = make(map[string]interface{})
				}
				la.AdditionalProperties[k] = additionalProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				la.Name = &name
			}
		case "versionId":
			if v != nil {
				var versionID string
				err = json.Unmarshal(*v, &versionID)
				if err != nil {
					return err
				}
				la.VersionID = &versionID
			}
		case "desc":
			if v != nil {
				var desc string
				err = json.Unmarshal(*v, &desc)
				if err != nil {
					return err
				}
				la.Desc = &desc
			}
		case "culture":
			if v != nil {
				var culture string
				err = json.Unmarshal(*v, &culture)
				if err != nil {
					return err
				}
				la.Culture = &culture
			}
		case "intents":
			if v != nil {
				var intents []HierarchicalModel
				err = json.Unmarshal(*v, &intents)
				if err != nil {
					return err
				}
				la.Intents = &intents
			}
		case "entities":
			if v != nil {
				var entities []HierarchicalModel
				err = json.Unmarshal(*v, &entities)
				if err != nil {
					return err
				}
				la.Entities = &entities
			}
		case "closedLists":
			if v != nil {
				var closedLists []ClosedList
				err = json.Unmarshal(*v, &closedLists)
				if err != nil {
					return err
				}
				la.ClosedLists = &closedLists
			}
		case "composites":
			if v != nil {
				var composites []HierarchicalModel
				err = json.Unmarshal(*v, &composites)
				if err != nil {
					return err
				}
				la.Composites = &composites
			}
		case "hierarchicals":
			if v != nil {
				var hierarchicals []HierarchicalModel
				err = json.Unmarshal(*v, &hierarchicals)
				if err != nil {
					return err
				}
				la.Hierarchicals = &hierarchicals
			}
		case "patternAnyEntities":
			if v != nil {
				var patternAnyEntities []PatternAny
				err = json.Unmarshal(*v, &patternAnyEntities)
				if err != nil {
					return err
				}
				la.PatternAnyEntities = &patternAnyEntities
			}
		case "regex_entities":
			if v != nil {
				var regexEntities []RegexEntity
				err = json.Unmarshal(*v, &regexEntities)
				if err != nil {
					return err
				}
				la.RegexEntities = &regexEntities
			}
		case "prebuiltEntities":
			if v != nil {
				var prebuiltEntities []PrebuiltEntity
				err = json.Unmarshal(*v, &prebuiltEntities)
				if err != nil {
					return err
				}
				la.PrebuiltEntities = &prebuiltEntities
			}
		case "regex_features":
			if v != nil {
				var regexFeatures []JSONRegexFeature
				err = json.Unmarshal(*v, &regexFeatures)
				if err != nil {
					return err
				}
				la.RegexFeatures = &regexFeatures
			}
		case "phraselists":
			if v != nil {
				var phraselists []JSONModelFeature
				err = json.Unmarshal(*v, &phraselists)
				if err != nil {
					return err
				}
				la.Phraselists = &phraselists
			}
		case "patterns":
			if v != nil {
				var patterns []PatternRule
				err = json.Unmarshal(*v, &patterns)
				if err != nil {
					return err
				}
				la.Patterns = &patterns
			}
		case "utterances":
			if v != nil {
				var utterances []JSONUtterance
				err = json.Unmarshal(*v, &utterances)
				if err != nil {
					return err
				}
				la.Utterances = &utterances
			}
		}
	}

	return nil
}

// LuisAppV2 exported Model - An exported LUIS Application.
type LuisAppV2 struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// LuisSchemaVersion - Luis schema deserialization version.
	LuisSchemaVersion *string `json:"luis_schema_version,omitempty"`
	// Name - The name of the application.
	Name *string `json:"name,omitempty"`
	// VersionID - The version ID of the application that was exported.
	VersionID *string `json:"versionId,omitempty"`
	// Desc - The description of the application.
	Desc *string `json:"desc,omitempty"`
	// Culture - The culture of the application. E.g.: en-us.
	Culture *string `json:"culture,omitempty"`
	// Intents - List of intents.
	Intents *[]HierarchicalModelV2 `json:"intents,omitempty"`
	// Entities - List of entities.
	Entities *[]HierarchicalModelV2 `json:"entities,omitempty"`
	// ClosedLists - List of list entities.
	ClosedLists *[]ClosedList `json:"closedLists,omitempty"`
	// Composites - List of composite entities.
	Composites *[]HierarchicalModelV2 `json:"composites,omitempty"`
	// PatternAnyEntities - List of Pattern.Any entities.
	PatternAnyEntities *[]PatternAny `json:"patternAnyEntities,omitempty"`
	// RegexEntities - List of regular expression entities.
	RegexEntities *[]RegexEntity `json:"regex_entities,omitempty"`
	// PrebuiltEntities - List of prebuilt entities.
	PrebuiltEntities *[]PrebuiltEntity `json:"prebuiltEntities,omitempty"`
	// RegexFeatures - List of pattern features.
	RegexFeatures *[]JSONRegexFeature `json:"regex_features,omitempty"`
	// ModelFeatures - List of model features.
	ModelFeatures *[]JSONModelFeature `json:"model_features,omitempty"`
	// Patterns - List of patterns.
	Patterns *[]PatternRule `json:"patterns,omitempty"`
	// Utterances - List of example utterances.
	Utterances *[]JSONUtterance `json:"utterances,omitempty"`
}

// MarshalJSON is the custom marshaler for LuisAppV2.
func (lav LuisAppV2) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lav.LuisSchemaVersion != nil {
		objectMap["luis_schema_version"] = lav.LuisSchemaVersion
	}
	if lav.Name != nil {
		objectMap["name"] = lav.Name
	}
	if lav.VersionID != nil {
		objectMap["versionId"] = lav.VersionID
	}
	if lav.Desc != nil {
		objectMap["desc"] = lav.Desc
	}
	if lav.Culture != nil {
		objectMap["culture"] = lav.Culture
	}
	if lav.Intents != nil {
		objectMap["intents"] = lav.Intents
	}
	if lav.Entities != nil {
		objectMap["entities"] = lav.Entities
	}
	if lav.ClosedLists != nil {
		objectMap["closedLists"] = lav.ClosedLists
	}
	if lav.Composites != nil {
		objectMap["composites"] = lav.Composites
	}
	if lav.PatternAnyEntities != nil {
		objectMap["patternAnyEntities"] = lav.PatternAnyEntities
	}
	if lav.RegexEntities != nil {
		objectMap["regex_entities"] = lav.RegexEntities
	}
	if lav.PrebuiltEntities != nil {
		objectMap["prebuiltEntities"] = lav.PrebuiltEntities
	}
	if lav.RegexFeatures != nil {
		objectMap["regex_features"] = lav.RegexFeatures
	}
	if lav.ModelFeatures != nil {
		objectMap["model_features"] = lav.ModelFeatures
	}
	if lav.Patterns != nil {
		objectMap["patterns"] = lav.Patterns
	}
	if lav.Utterances != nil {
		objectMap["utterances"] = lav.Utterances
	}
	for k, v := range lav.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for LuisAppV2 struct.
func (lav *LuisAppV2) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		default:
			if v != nil {
				var additionalProperties interface{}
				err = json.Unmarshal(*v, &additionalProperties)
				if err != nil {
					return err
				}
				if lav.AdditionalProperties == nil {
					lav.AdditionalProperties = make(map[string]interface{})
				}
				lav.AdditionalProperties[k] = additionalProperties
			}
		case "luis_schema_version":
			if v != nil {
				var luisSchemaVersion string
				err = json.Unmarshal(*v, &luisSchemaVersion)
				if err != nil {
					return err
				}
				lav.LuisSchemaVersion = &luisSchemaVersion
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				lav.Name = &name
			}
		case "versionId":
			if v != nil {
				var versionID string
				err = json.Unmarshal(*v, &versionID)
				if err != nil {
					return err
				}
				lav.VersionID = &versionID
			}
		case "desc":
			if v != nil {
				var desc string
				err = json.Unmarshal(*v, &desc)
				if err != nil {
					return err
				}
				lav.Desc = &desc
			}
		case "culture":
			if v != nil {
				var culture string
				err = json.Unmarshal(*v, &culture)
				if err != nil {
					return err
				}
				lav.Culture = &culture
			}
		case "intents":
			if v != nil {
				var intents []HierarchicalModelV2
				err = json.Unmarshal(*v, &intents)
				if err != nil {
					return err
				}
				lav.Intents = &intents
			}
		case "entities":
			if v != nil {
				var entities []HierarchicalModelV2
				err = json.Unmarshal(*v, &entities)
				if err != nil {
					return err
				}
				lav.Entities = &entities
			}
		case "closedLists":
			if v != nil {
				var closedLists []ClosedList
				err = json.Unmarshal(*v, &closedLists)
				if err != nil {
					return err
				}
				lav.ClosedLists = &closedLists
			}
		case "composites":
			if v != nil {
				var composites []HierarchicalModelV2
				err = json.Unmarshal(*v, &composites)
				if err != nil {
					return err
				}
				lav.Composites = &composites
			}
		case "patternAnyEntities":
			if v != nil {
				var patternAnyEntities []PatternAny
				err = json.Unmarshal(*v, &patternAnyEntities)
				if err != nil {
					return err
				}
				lav.PatternAnyEntities = &patternAnyEntities
			}
		case "regex_entities":
			if v != nil {
				var regexEntities []RegexEntity
				err = json.Unmarshal(*v, &regexEntities)
				if err != nil {
					return err
				}
				lav.RegexEntities = &regexEntities
			}
		case "prebuiltEntities":
			if v != nil {
				var prebuiltEntities []PrebuiltEntity
				err = json.Unmarshal(*v, &prebuiltEntities)
				if err != nil {
					return err
				}
				lav.PrebuiltEntities = &prebuiltEntities
			}
		case "regex_features":
			if v != nil {
				var regexFeatures []JSONRegexFeature
				err = json.Unmarshal(*v, &regexFeatures)
				if err != nil {
					return err
				}
				lav.RegexFeatures = &regexFeatures
			}
		case "model_features":
			if v != nil {
				var modelFeatures []JSONModelFeature
				err = json.Unmarshal(*v, &modelFeatures)
				if err != nil {
					return err
				}
				lav.ModelFeatures = &modelFeatures
			}
		case "patterns":
			if v != nil {
				var patterns []PatternRule
				err = json.Unmarshal(*v, &patterns)
				if err != nil {
					return err
				}
				lav.Patterns = &patterns
			}
		case "utterances":
			if v != nil {
				var utterances []JSONUtterance
				err = json.Unmarshal(*v, &utterances)
				if err != nil {
					return err
				}
				lav.Utterances = &utterances
			}
		}
	}

	return nil
}

// ModelCreateObject object model for creating a new entity extractor.
type ModelCreateObject struct {
	// Name - Name of the new entity extractor.
	Name *string `json:"name,omitempty"`
}

// ModelFeatureInformation an object containing the model feature information either the model name or
// feature name.
type ModelFeatureInformation struct {
	// ModelName - The name of the model used.
	ModelName *string `json:"modelName,omitempty"`
	// FeatureName - The name of the feature used.
	FeatureName *string `json:"featureName,omitempty"`
	IsRequired  *bool   `json:"isRequired,omitempty"`
}

// ModelInfo base type used in entity types.
type ModelInfo struct {
	// ID - The ID of the Entity Model.
	ID *uuid.UUID `json:"id,omitempty"`
	// Name - Name of the Entity Model.
	Name *string `json:"name,omitempty"`
	// TypeID - The type ID of the Entity Model.
	TypeID *int32 `json:"typeId,omitempty"`
	// ReadableType - Possible values include: 'ReadableTypeEntityExtractor', 'ReadableTypeChildEntityExtractor', 'ReadableTypeHierarchicalEntityExtractor', 'ReadableTypeHierarchicalChildEntityExtractor', 'ReadableTypeCompositeEntityExtractor', 'ReadableTypeListEntityExtractor', 'ReadableTypePrebuiltEntityExtractor', 'ReadableTypeIntentClassifier', 'ReadableTypePatternAnyEntityExtractor', 'ReadableTypeClosedListEntityExtractor', 'ReadableTypeRegexEntityExtractor'
	ReadableType ReadableType `json:"readableType,omitempty"`
}

// ModelInfoResponse an application model info.
type ModelInfoResponse struct {
	// ID - The ID of the Entity Model.
	ID *uuid.UUID `json:"id,omitempty"`
	// Name - Name of the Entity Model.
	Name *string `json:"name,omitempty"`
	// TypeID - The type ID of the Entity Model.
	TypeID *int32 `json:"typeId,omitempty"`
	// ReadableType - Possible values include: 'ReadableType2EntityExtractor', 'ReadableType2ChildEntityExtractor', 'ReadableType2HierarchicalEntityExtractor', 'ReadableType2HierarchicalChildEntityExtractor', 'ReadableType2CompositeEntityExtractor', 'ReadableType2ListEntityExtractor', 'ReadableType2PrebuiltEntityExtractor', 'ReadableType2IntentClassifier', 'ReadableType2PatternAnyEntityExtractor', 'ReadableType2ClosedListEntityExtractor', 'ReadableType2RegexEntityExtractor'
	ReadableType ReadableType2 `json:"readableType,omitempty"`
	Roles        *[]EntityRole `json:"roles,omitempty"`
	// Children - List of child entities.
	Children *[]ChildEntity `json:"children,omitempty"`
	// SubLists - List of sublists.
	SubLists *[]SubClosedListResponse `json:"subLists,omitempty"`
	// CustomPrebuiltDomainName - The domain name.
	CustomPrebuiltDomainName *string `json:"customPrebuiltDomainName,omitempty"`
	// CustomPrebuiltModelName - The intent name or entity name.
	CustomPrebuiltModelName *string `json:"customPrebuiltModelName,omitempty"`
	// RegexPattern - The Regular Expression entity pattern.
	RegexPattern *string             `json:"regexPattern,omitempty"`
	ExplicitList *[]ExplicitListItem `json:"explicitList,omitempty"`
}

// ModelTrainingDetails model Training Details.
type ModelTrainingDetails struct {
	// StatusID - The train request status ID.
	StatusID *int32 `json:"statusId,omitempty"`
	// Status - Possible values include: 'Status1Queued', 'Status1InProgress', 'Status1UpToDate', 'Status1Fail', 'Status1Success'
	Status Status1 `json:"status,omitempty"`
	// ExampleCount - The count of examples used to train the model.
	ExampleCount *int32 `json:"exampleCount,omitempty"`
	// TrainingDateTime - When the model was trained.
	TrainingDateTime *date.Time `json:"trainingDateTime,omitempty"`
	// FailureReason - Reason for the training failure.
	FailureReason *string `json:"failureReason,omitempty"`
}

// ModelTrainingInfo model Training Info.
type ModelTrainingInfo struct {
	// ModelID - The ID (GUID) of the model.
	ModelID *uuid.UUID            `json:"modelId,omitempty"`
	Details *ModelTrainingDetails `json:"details,omitempty"`
}

// ModelUpdateObject object model for updating an intent classifier.
type ModelUpdateObject struct {
	// Name - The entity's new name.
	Name *string `json:"name,omitempty"`
}

// NDepthEntityExtractor n-Depth Entity Extractor.
type NDepthEntityExtractor struct {
	autorest.Response `json:"-"`
	// ID - The ID of the Entity Model.
	ID *uuid.UUID `json:"id,omitempty"`
	// Name - Name of the Entity Model.
	Name *string `json:"name,omitempty"`
	// TypeID - The type ID of the Entity Model.
	TypeID *int32 `json:"typeId,omitempty"`
	// ReadableType - Possible values include: 'ReadableType9EntityExtractor', 'ReadableType9ChildEntityExtractor', 'ReadableType9HierarchicalEntityExtractor', 'ReadableType9HierarchicalChildEntityExtractor', 'ReadableType9CompositeEntityExtractor', 'ReadableType9ListEntityExtractor', 'ReadableType9PrebuiltEntityExtractor', 'ReadableType9IntentClassifier', 'ReadableType9PatternAnyEntityExtractor', 'ReadableType9ClosedListEntityExtractor', 'ReadableType9RegexEntityExtractor'
	ReadableType ReadableType9 `json:"readableType,omitempty"`
	Roles        *[]EntityRole `json:"roles,omitempty"`
	// CustomPrebuiltDomainName - The domain name.
	CustomPrebuiltDomainName *string `json:"customPrebuiltDomainName,omitempty"`
	// CustomPrebuiltModelName - The intent name or entity name.
	CustomPrebuiltModelName *string        `json:"customPrebuiltModelName,omitempty"`
	Children                *[]ChildEntity `json:"children,omitempty"`
}

// OperationError operation error details when invoking an operation on the API.
type OperationError struct {
	Code    *string `json:"code,omitempty"`
	Message *string `json:"message,omitempty"`
}

// OperationStatus response of an Operation status.
type OperationStatus struct {
	autorest.Response `json:"-"`
	// Code - Status Code. Possible values include: 'Failed', 'FAILED', 'Success'
	Code OperationStatusType `json:"code,omitempty"`
	// Message - Status details.
	Message *string `json:"message,omitempty"`
}

// PatternAny pattern.Any Entity Extractor.
type PatternAny struct {
	Name         *string   `json:"name,omitempty"`
	ExplicitList *[]string `json:"explicitList,omitempty"`
	Roles        *[]string `json:"roles,omitempty"`
}

// PatternAnyEntityExtractor pattern.Any Entity Extractor.
type PatternAnyEntityExtractor struct {
	autorest.Response `json:"-"`
	// ID - The ID of the Entity Model.
	ID *uuid.UUID `json:"id,omitempty"`
	// Name - Name of the Entity Model.
	Name *string `json:"name,omitempty"`
	// TypeID - The type ID of the Entity Model.
	TypeID *int32 `json:"typeId,omitempty"`
	// ReadableType - Possible values include: 'ReadableType11EntityExtractor', 'ReadableType11ChildEntityExtractor', 'ReadableType11HierarchicalEntityExtractor', 'ReadableType11HierarchicalChildEntityExtractor', 'ReadableType11CompositeEntityExtractor', 'ReadableType11ListEntityExtractor', 'ReadableType11PrebuiltEntityExtractor', 'ReadableType11IntentClassifier', 'ReadableType11PatternAnyEntityExtractor', 'ReadableType11ClosedListEntityExtractor', 'ReadableType11RegexEntityExtractor'
	ReadableType ReadableType11      `json:"readableType,omitempty"`
	Roles        *[]EntityRole       `json:"roles,omitempty"`
	ExplicitList *[]ExplicitListItem `json:"explicitList,omitempty"`
}

// PatternAnyModelCreateObject model object for creating a Pattern.Any entity model.
type PatternAnyModelCreateObject struct {
	// Name - The model name.
	Name *string `json:"name,omitempty"`
	// ExplicitList - The Pattern.Any explicit list.
	ExplicitList *[]string `json:"explicitList,omitempty"`
}

// PatternAnyModelUpdateObject model object for updating a Pattern.Any entity model.
type PatternAnyModelUpdateObject struct {
	// Name - The model name.
	Name *string `json:"name,omitempty"`
	// ExplicitList - The Pattern.Any explicit list.
	ExplicitList *[]string `json:"explicitList,omitempty"`
}

// PatternFeatureInfo pattern feature.
type PatternFeatureInfo struct {
	// Pattern - The Regular Expression to match.
	Pattern *string `json:"pattern,omitempty"`
	// ID - A six-digit ID used for Features.
	ID *int32 `json:"id,omitempty"`
	// Name - The name of the Feature.
	Name *string `json:"name,omitempty"`
	// IsActive - Indicates if the feature is enabled.
	IsActive *bool `json:"isActive,omitempty"`
	// EnabledForAllModels - Indicates if the feature is enabled for all models in the application.
	EnabledForAllModels *bool `json:"enabledForAllModels,omitempty"`
}

// PatternRule pattern
type PatternRule struct {
	// Pattern - The pattern text.
	Pattern *string `json:"pattern,omitempty"`
	// Intent - The intent's name where the pattern belongs to.
	Intent *string `json:"intent,omitempty"`
}

// PatternRuleCreateObject object model for creating a pattern
type PatternRuleCreateObject struct {
	// Pattern - The pattern text.
	Pattern *string `json:"pattern,omitempty"`
	// Intent - The intent's name which the pattern belongs to.
	Intent *string `json:"intent,omitempty"`
}

// PatternRuleInfo pattern rule
type PatternRuleInfo struct {
	autorest.Response `json:"-"`
	// ID - The pattern ID.
	ID *uuid.UUID `json:"id,omitempty"`
	// Pattern - The pattern text.
	Pattern *string `json:"pattern,omitempty"`
	// Intent - The intent's name where the pattern belongs to.
	Intent *string `json:"intent,omitempty"`
}

// PatternRuleUpdateObject object model for updating a pattern.
type PatternRuleUpdateObject struct {
	// ID - The pattern ID.
	ID *uuid.UUID `json:"id,omitempty"`
	// Pattern - The pattern text.
	Pattern *string `json:"pattern,omitempty"`
	// Intent - The intent's name which the pattern belongs to.
	Intent *string `json:"intent,omitempty"`
}

// PersonalAssistantsResponse response containing user's endpoint keys and the endpoint URLs of the
// prebuilt Cortana applications.
type PersonalAssistantsResponse struct {
	autorest.Response `json:"-"`
	EndpointKeys      *[]uuid.UUID       `json:"endpointKeys,omitempty"`
	EndpointUrls      map[string]*string `json:"endpointUrls"`
}

// MarshalJSON is the custom marshaler for PersonalAssistantsResponse.
func (par PersonalAssistantsResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if par.EndpointKeys != nil {
		objectMap["endpointKeys"] = par.EndpointKeys
	}
	if par.EndpointUrls != nil {
		objectMap["endpointUrls"] = par.EndpointUrls
	}
	return json.Marshal(objectMap)
}

// PhraselistCreateObject object model for creating a phraselist model.
type PhraselistCreateObject struct {
	// Phrases - List of comma-separated phrases that represent the Phraselist.
	Phrases *string `json:"phrases,omitempty"`
	// Name - The Phraselist name.
	Name *string `json:"name,omitempty"`
	// IsExchangeable - An interchangeable phrase list feature serves as a list of synonyms for training. A non-exchangeable phrase list serves as separate features for training. So, if your non-interchangeable phrase list contains 5 phrases, they will be mapped to 5 separate features. You can think of the non-interchangeable phrase list as an additional bag of words to add to LUIS existing vocabulary features. It is used as a lexicon lookup feature where its value is 1 if the lexicon contains a given word or 0 if it doesn’t.  Default value is true.
	IsExchangeable *bool `json:"isExchangeable,omitempty"`
	// EnabledForAllModels - Indicates if the Phraselist is enabled for all models in the application.
	EnabledForAllModels *bool `json:"enabledForAllModels,omitempty"`
}

// PhraseListFeatureInfo phraselist Feature.
type PhraseListFeatureInfo struct {
	autorest.Response `json:"-"`
	// Phrases - A list of comma-separated values.
	Phrases *string `json:"phrases,omitempty"`
	// IsExchangeable - An exchangeable phrase list feature are serves as single feature to the LUIS underlying training algorithm. It is used as a lexicon lookup feature where its value is 1 if the lexicon contains a given word or 0 if it doesn’t. Think of an exchangeable as a synonyms list. A non-exchangeable phrase list feature has all the phrases in the list serve as separate features to the underlying training algorithm. So, if you your phrase list feature contains 5 phrases, they will be mapped to 5 separate features. You can think of the non-exchangeable phrase list feature as an additional bag of words that you are willing to add to LUIS existing vocabulary features. Think of a non-exchangeable as set of different words. Default value is true.
	IsExchangeable *bool `json:"isExchangeable,omitempty"`
	// ID - A six-digit ID used for Features.
	ID *int32 `json:"id,omitempty"`
	// Name - The name of the Feature.
	Name *string `json:"name,omitempty"`
	// IsActive - Indicates if the feature is enabled.
	IsActive *bool `json:"isActive,omitempty"`
	// EnabledForAllModels - Indicates if the feature is enabled for all models in the application.
	EnabledForAllModels *bool `json:"enabledForAllModels,omitempty"`
}

// PhraselistUpdateObject object model for updating a Phraselist.
type PhraselistUpdateObject struct {
	// Phrases - List of comma-separated phrases that represent the Phraselist.
	Phrases *string `json:"phrases,omitempty"`
	// Name - The Phraselist name.
	Name *string `json:"name,omitempty"`
	// IsActive - Indicates if the Phraselist is enabled.
	IsActive *bool `json:"isActive,omitempty"`
	// IsExchangeable - An exchangeable phrase list feature are serves as single feature to the LUIS underlying training algorithm. It is used as a lexicon lookup feature where its value is 1 if the lexicon contains a given word or 0 if it doesn’t. Think of an exchangeable as a synonyms list. A non-exchangeable phrase list feature has all the phrases in the list serve as separate features to the underlying training algorithm. So, if you your phrase list feature contains 5 phrases, they will be mapped to 5 separate features. You can think of the non-exchangeable phrase list feature as an additional bag of words that you are willing to add to LUIS existing vocabulary features. Think of a non-exchangeable as set of different words. Default value is true.
	IsExchangeable *bool `json:"isExchangeable,omitempty"`
	// EnabledForAllModels - Indicates if the Phraselist is enabled for all models in the application.
	EnabledForAllModels *bool `json:"enabledForAllModels,omitempty"`
}

// PrebuiltDomain prebuilt Domain.
type PrebuiltDomain struct {
	Name        *string               `json:"name,omitempty"`
	Culture     *string               `json:"culture,omitempty"`
	Description *string               `json:"description,omitempty"`
	Examples    *string               `json:"examples,omitempty"`
	Intents     *[]PrebuiltDomainItem `json:"intents,omitempty"`
	Entities    *[]PrebuiltDomainItem `json:"entities,omitempty"`
}

// PrebuiltDomainCreateBaseObject a model object containing the name of the custom prebuilt entity and the
// name of the domain to which this model belongs.
type PrebuiltDomainCreateBaseObject struct {
	// DomainName - The domain name.
	DomainName *string `json:"domainName,omitempty"`
}

// PrebuiltDomainCreateObject a prebuilt domain create object containing the name and culture of the
// domain.
type PrebuiltDomainCreateObject struct {
	// DomainName - The domain name.
	DomainName *string `json:"domainName,omitempty"`
	// Culture - The culture of the new domain.
	Culture *string `json:"culture,omitempty"`
}

// PrebuiltDomainItem ...
type PrebuiltDomainItem struct {
	Name        *string `json:"name,omitempty"`
	Description *string `json:"description,omitempty"`
	Examples    *string `json:"examples,omitempty"`
}

// PrebuiltDomainModelCreateObject a model object containing the name of the custom prebuilt intent or
// entity and the name of the domain to which this model belongs.
type PrebuiltDomainModelCreateObject struct {
	// DomainName - The domain name.
	DomainName *string `json:"domainName,omitempty"`
	// ModelName - The intent name or entity name.
	ModelName *string `json:"modelName,omitempty"`
}

// PrebuiltDomainObject ...
type PrebuiltDomainObject struct {
	DomainName *string `json:"domain_name,omitempty"`
	ModelName  *string `json:"model_name,omitempty"`
}

// PrebuiltEntity prebuilt Entity Extractor.
type PrebuiltEntity struct {
	Name  *string   `json:"name,omitempty"`
	Roles *[]string `json:"roles,omitempty"`
}

// PrebuiltEntityExtractor prebuilt Entity Extractor.
type PrebuiltEntityExtractor struct {
	autorest.Response `json:"-"`
	// ID - The ID of the Entity Model.
	ID *uuid.UUID `json:"id,omitempty"`
	// Name - Name of the Entity Model.
	Name *string `json:"name,omitempty"`
	// TypeID - The type ID of the Entity Model.
	TypeID *int32 `json:"typeId,omitempty"`
	// ReadableType - Possible values include: 'ReadableType6EntityExtractor', 'ReadableType6ChildEntityExtractor', 'ReadableType6HierarchicalEntityExtractor', 'ReadableType6HierarchicalChildEntityExtractor', 'ReadableType6CompositeEntityExtractor', 'ReadableType6ListEntityExtractor', 'ReadableType6PrebuiltEntityExtractor', 'ReadableType6IntentClassifier', 'ReadableType6PatternAnyEntityExtractor', 'ReadableType6ClosedListEntityExtractor', 'ReadableType6RegexEntityExtractor'
	ReadableType ReadableType6 `json:"readableType,omitempty"`
	Roles        *[]EntityRole `json:"roles,omitempty"`
}

// ProductionOrStagingEndpointInfo ...
type ProductionOrStagingEndpointInfo struct {
	autorest.Response `json:"-"`
	// VersionID - The version ID to publish.
	VersionID *string `json:"versionId,omitempty"`
	// IsStaging - Indicates if the staging slot should be used, instead of the Production one.
	IsStaging *bool `json:"isStaging,omitempty"`
	// EndpointURL - The Runtime endpoint URL for this model version.
	EndpointURL *string `json:"endpointUrl,omitempty"`
	// Region - The target region that the application is published to.
	Region *string `json:"region,omitempty"`
	// AssignedEndpointKey - The endpoint key.
	AssignedEndpointKey *string `json:"assignedEndpointKey,omitempty"`
	// EndpointRegion - The endpoint's region.
	EndpointRegion *string `json:"endpointRegion,omitempty"`
	// FailedRegions - Regions where publishing failed.
	FailedRegions *string `json:"failedRegions,omitempty"`
	// PublishedDateTime - Timestamp when was last published.
	PublishedDateTime *string `json:"publishedDateTime,omitempty"`
}

// PublishSettings the application publish settings.
type PublishSettings struct {
	autorest.Response `json:"-"`
	// ID - The application ID.
	ID *uuid.UUID `json:"id,omitempty"`
	// IsSentimentAnalysisEnabled - Setting sentiment analysis as true returns the sentiment of the input utterance along with the response
	IsSentimentAnalysisEnabled *bool `json:"sentimentAnalysis,omitempty"`
	// IsSpeechEnabled - Enables speech priming in your app
	IsSpeechEnabled *bool `json:"speech,omitempty"`
	// IsSpellCheckerEnabled - Enables spell checking of the utterance.
	IsSpellCheckerEnabled *bool `json:"spellChecker,omitempty"`
}

// PublishSettingUpdateObject object model for updating an application's publish settings.
type PublishSettingUpdateObject struct {
	// SentimentAnalysis - Setting sentiment analysis as true returns the Sentiment of the input utterance along with the response
	SentimentAnalysis *bool `json:"sentimentAnalysis,omitempty"`
	// Speech - Setting speech as public enables speech priming in your app
	Speech *bool `json:"speech,omitempty"`
	// SpellChecker - Setting spell checker as public enables spell checking the input utterance.
	SpellChecker *bool `json:"spellChecker,omitempty"`
}

// ReadCloser ...
type ReadCloser struct {
	autorest.Response `json:"-"`
	Value             *io.ReadCloser `json:"value,omitempty"`
}

// RegexEntity regular Expression Entity Extractor.
type RegexEntity struct {
	Name         *string   `json:"name,omitempty"`
	RegexPattern *string   `json:"regexPattern,omitempty"`
	Roles        *[]string `json:"roles,omitempty"`
}

// RegexEntityExtractor regular Expression Entity Extractor.
type RegexEntityExtractor struct {
	autorest.Response `json:"-"`
	// ID - The ID of the Entity Model.
	ID *uuid.UUID `json:"id,omitempty"`
	// Name - Name of the Entity Model.
	Name *string `json:"name,omitempty"`
	// TypeID - The type ID of the Entity Model.
	TypeID *int32 `json:"typeId,omitempty"`
	// ReadableType - Possible values include: 'ReadableType10EntityExtractor', 'ReadableType10ChildEntityExtractor', 'ReadableType10HierarchicalEntityExtractor', 'ReadableType10HierarchicalChildEntityExtractor', 'ReadableType10CompositeEntityExtractor', 'ReadableType10ListEntityExtractor', 'ReadableType10PrebuiltEntityExtractor', 'ReadableType10IntentClassifier', 'ReadableType10PatternAnyEntityExtractor', 'ReadableType10ClosedListEntityExtractor', 'ReadableType10RegexEntityExtractor'
	ReadableType ReadableType10 `json:"readableType,omitempty"`
	Roles        *[]EntityRole  `json:"roles,omitempty"`
	// RegexPattern - The Regular Expression entity pattern.
	RegexPattern *string `json:"regexPattern,omitempty"`
}

// RegexModelCreateObject model object for creating a regular expression entity model.
type RegexModelCreateObject struct {
	// RegexPattern - The regular expression entity pattern.
	RegexPattern *string `json:"regexPattern,omitempty"`
	// Name - The model name.
	Name *string `json:"name,omitempty"`
}

// RegexModelUpdateObject model object for updating a regular expression entity model.
type RegexModelUpdateObject struct {
	// RegexPattern - The regular expression entity pattern.
	RegexPattern *string `json:"regexPattern,omitempty"`
	// Name - The model name.
	Name *string `json:"name,omitempty"`
}

// SetString ...
type SetString struct {
	autorest.Response `json:"-"`
	Value             map[string]*string `json:"value"`
}

// MarshalJSON is the custom marshaler for SetString.
func (ss SetString) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ss.Value != nil {
		objectMap["value"] = ss.Value
	}
	return json.Marshal(objectMap)
}

// String ...
type String struct {
	autorest.Response `json:"-"`
	Value             *string `json:"value,omitempty"`
}

// SubClosedList sublist of items for a list entity.
type SubClosedList struct {
	// CanonicalForm - The standard form that the list represents.
	CanonicalForm *string `json:"canonicalForm,omitempty"`
	// List - List of synonym words.
	List *[]string `json:"list,omitempty"`
}

// SubClosedListResponse sublist of items for a list entity.
type SubClosedListResponse struct {
	// ID - The sublist ID
	ID *int32 `json:"id,omitempty"`
	// CanonicalForm - The standard form that the list represents.
	CanonicalForm *string `json:"canonicalForm,omitempty"`
	// List - List of synonym words.
	List *[]string `json:"list,omitempty"`
}

// TaskUpdateObject object model for cloning an application's version.
type TaskUpdateObject struct {
	// Version - The new version for the cloned model.
	Version *string `json:"version,omitempty"`
}

// UserAccessList list of user permissions.
type UserAccessList struct {
	// Owner - The email address of owner of the application.
	Owner  *string   `json:"owner,omitempty"`
	Emails *[]string `json:"emails,omitempty"`
}

// UserCollaborator ...
type UserCollaborator struct {
	// Email - The email address of the user.
	Email *string `json:"email,omitempty"`
}

// UUID ...
type UUID struct {
	autorest.Response `json:"-"`
	Value             *uuid.UUID `json:"value,omitempty"`
}

// VersionInfo object model of an application version.
type VersionInfo struct {
	autorest.Response `json:"-"`
	// Version - The version ID. E.g.: "0.1"
	Version *string `json:"version,omitempty"`
	// CreatedDateTime - The version's creation timestamp.
	CreatedDateTime *date.Time `json:"createdDateTime,omitempty"`
	// LastModifiedDateTime - Timestamp of the last update.
	LastModifiedDateTime *date.Time `json:"lastModifiedDateTime,omitempty"`
	// LastTrainedDateTime - Timestamp of the last time the model was trained.
	LastTrainedDateTime *date.Time `json:"lastTrainedDateTime,omitempty"`
	// LastPublishedDateTime - Timestamp when was last published.
	LastPublishedDateTime *date.Time `json:"lastPublishedDateTime,omitempty"`
	// EndpointURL - The Runtime endpoint URL for this model version.
	EndpointURL *string `json:"endpointUrl,omitempty"`
	// AssignedEndpointKey - The endpoint key.
	AssignedEndpointKey map[string]*string `json:"assignedEndpointKey"`
	// ExternalAPIKeys - External keys.
	ExternalAPIKeys interface{} `json:"externalApiKeys,omitempty"`
	// IntentsCount - Number of intents in this model.
	IntentsCount *int32 `json:"intentsCount,omitempty"`
	// EntitiesCount - Number of entities in this model.
	EntitiesCount *int32 `json:"entitiesCount,omitempty"`
	// EndpointHitsCount - Number of calls made to this endpoint.
	EndpointHitsCount *int32 `json:"endpointHitsCount,omitempty"`
	// TrainingStatus - The current training status. Possible values include: 'NeedsTraining', 'InProgress', 'Trained'
	TrainingStatus TrainingStatus `json:"trainingStatus,omitempty"`
}

// MarshalJSON is the custom marshaler for VersionInfo.
func (vi VersionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vi.Version != nil {
		objectMap["version"] = vi.Version
	}
	if vi.CreatedDateTime != nil {
		objectMap["createdDateTime"] = vi.CreatedDateTime
	}
	if vi.LastModifiedDateTime != nil {
		objectMap["lastModifiedDateTime"] = vi.LastModifiedDateTime
	}
	if vi.LastTrainedDateTime != nil {
		objectMap["lastTrainedDateTime"] = vi.LastTrainedDateTime
	}
	if vi.LastPublishedDateTime != nil {
		objectMap["lastPublishedDateTime"] = vi.LastPublishedDateTime
	}
	if vi.EndpointURL != nil {
		objectMap["endpointUrl"] = vi.EndpointURL
	}
	if vi.AssignedEndpointKey != nil {
		objectMap["assignedEndpointKey"] = vi.AssignedEndpointKey
	}
	if vi.ExternalAPIKeys != nil {
		objectMap["externalApiKeys"] = vi.ExternalAPIKeys
	}
	if vi.IntentsCount != nil {
		objectMap["intentsCount"] = vi.IntentsCount
	}
	if vi.EntitiesCount != nil {
		objectMap["entitiesCount"] = vi.EntitiesCount
	}
	if vi.EndpointHitsCount != nil {
		objectMap["endpointHitsCount"] = vi.EndpointHitsCount
	}
	if vi.TrainingStatus != "" {
		objectMap["trainingStatus"] = vi.TrainingStatus
	}
	return json.Marshal(objectMap)
}

// WordListBaseUpdateObject object model for updating one of the list entity's sublists.
type WordListBaseUpdateObject struct {
	// CanonicalForm - The standard form that the list represents.
	CanonicalForm *string `json:"canonicalForm,omitempty"`
	// List - List of synonym words.
	List *[]string `json:"list,omitempty"`
}

// WordListObject sublist of items for a list entity.
type WordListObject struct {
	// CanonicalForm - The standard form that the list represents.
	CanonicalForm *string `json:"canonicalForm,omitempty"`
	// List - List of synonym words.
	List *[]string `json:"list,omitempty"`
}
