// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package util

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

type A struct{}

func (A) FA() {}

type AI interface {
	FA()
}

func TestConvertInterface(t *testing.T) {
	length := 10
	input := make([]A, length)
	output := ConvertMap(input, func(a A) AI { return a })
	assert.EqualValues(t, length, len(output))
}
