// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package f3

import (
	"code.forgejo.org/f3/gof3/v3/f3"
	"code.forgejo.org/f3/gof3/v3/kind"
)

const (
	KindAttachment     = f3.ResourceAttachment
	KindAttachments    = f3.ResourceAttachments
	KindComment        = f3.ResourceComment
	KindComments       = f3.ResourceComments
	KindForge          = f3.ResourceForge
	KindIssue          = f3.ResourceIssue
	KindIssues         = f3.ResourceIssues
	KindLabel          = f3.ResourceLabel
	KindLabels         = f3.ResourceLabels
	KindMilestone      = f3.ResourceMilestone
	KindMilestones     = f3.ResourceMilestones
	KindOrganization   = f3.ResourceOrganization
	KindOrganizations  = f3.ResourceOrganizations
	KindProject        = f3.ResourceProject
	KindProjects       = f3.ResourceProjects
	KindPullRequest    = f3.ResourcePullRequest
	KindPullRequests   = f3.ResourcePullRequests
	KindReaction       = f3.ResourceReaction
	KindReactions      = f3.ResourceReactions
	KindRelease        = f3.ResourceRelease
	KindReleases       = f3.ResourceReleases
	KindRepository     = f3.ResourceRepository
	KindRepositories   = f3.ResourceRepositories
	KindReview         = f3.ResourceReview
	KindReviews        = f3.ResourceReviews
	KindReviewComment  = f3.ResourceReviewComment
	KindReviewComments = f3.ResourceReviewComments
	KindTopic          = f3.ResourceTopic
	KindTopics         = f3.ResourceTopics
	KindUser           = f3.ResourceUser
	KindUsers          = f3.ResourceUsers
)

var isContainer = map[kind.Kind]bool{
	kind.KindRoot:      true,
	KindAttachments:    true,
	KindComments:       true,
	KindIssues:         true,
	KindLabels:         true,
	KindMilestones:     true,
	KindOrganizations:  true,
	KindProjects:       true,
	KindPullRequests:   true,
	KindReactions:      true,
	KindReleases:       true,
	KindRepositories:   true,
	KindReviews:        true,
	KindReviewComments: true,
	KindTopics:         true,
	KindUsers:          true,
}

var childrenKind = map[kind.Kind]kind.Kind{
	kind.KindRoot:      KindForge,
	KindAttachments:    KindAttachment,
	KindComments:       KindComment,
	KindIssues:         KindIssue,
	KindLabels:         KindLabel,
	KindMilestones:     KindMilestone,
	KindOrganizations:  KindOrganization,
	KindProjects:       KindProject,
	KindPullRequests:   KindPullRequest,
	KindReactions:      KindReaction,
	KindReleases:       KindRelease,
	KindRepositories:   KindRepository,
	KindReviews:        KindReview,
	KindReviewComments: KindReviewComment,
	KindTopics:         KindTopic,
	KindUsers:          KindUser,
}

var containerChildFixedID = map[kind.Kind]bool{
	kind.KindRoot:      true,
	KindAttachments:    false,
	KindComments:       false,
	KindForge:          true,
	KindIssues:         false,
	KindLabels:         false,
	KindMilestones:     false,
	KindOrganizations:  false,
	KindProjects:       false,
	KindPullRequests:   false,
	KindReactions:      false,
	KindReleases:       false,
	KindRepositories:   false,
	KindReviewComments: false,
	KindReviews:        false,
	KindTopics:         false,
	KindUsers:          false,
}
