// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package forgejo

import (
	"context"
	"fmt"

	f3_tree "code.forgejo.org/f3/gof3/v3/tree/f3"
	"code.forgejo.org/f3/gof3/v3/tree/generic"
)

type reviewComments struct {
	container
}

func (o *reviewComments) ListPage(ctx context.Context, page int) generic.ChildrenSlice {
	if page > 1 {
		return generic.NewChildrenSlice(0)
	}

	owner := f3_tree.GetOwnerName(o.GetNode())
	project := f3_tree.GetProjectName(o.GetNode())
	pullRequest := f3_tree.GetPullRequestID(o.GetNode())
	review := f3_tree.GetReviewID(o.GetNode())

	reviewComments, _, err := o.getClient().ListPullReviewComments(owner, project, pullRequest, review)
	if err != nil {
		panic(fmt.Errorf("error while listing reviewComments: %v", err))
	}

	return f3_tree.ConvertListed(ctx, o.GetNode(), f3_tree.ConvertToAny(reviewComments...)...)
}

func newReviewComments() generic.NodeDriverInterface {
	return &reviewComments{}
}
