// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package f3

import (
	"strings"
)

type PullRequestBranch struct {
	Ref        string     `json:"ref"`
	SHA        string     `json:"sha"`
	Repository *Reference `json:"repository"`
}

func (o PullRequestBranch) Equal(other PullRequestBranch) bool {
	if o.SHA != other.SHA {
		return false
	}
	ref := strings.TrimSuffix(o.Ref, o.SHA)
	otherRef := strings.TrimSuffix(other.Ref, o.SHA)
	return ref == otherRef
}

func (o *PullRequestBranch) GetReferences() References {
	return References{o.Repository}
}
