// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package api

import (
	"context"

	"code.forgejo.org/f3/gof3/v3/path"
	"code.forgejo.org/f3/gof3/v3/tree/generic"
	"code.forgejo.org/f3/gof3/v3/util"
)

func TreeMirror(ctx context.Context, originTree, destinationTree generic.TreeInterface, p path.Path, options *generic.MirrorOptions) error {
	err := util.PanicToError(func() {
		generic.TreeMirror(ctx, originTree, destinationTree, p, options)
	})
	if err != nil {
		originTree.Error(err.Error())
		originTree.Debug(err.Stack())
	}
	return err
}
