//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armstorsimple1200series

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ManagersClient contains the methods for the Managers group.
// Don't use this type directly, use NewManagersClient() instead.
type ManagersClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewManagersClient creates a new instance of ManagersClient with the specified values.
// subscriptionID - The subscription id
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewManagersClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ManagersClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &ManagersClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// CreateExtendedInfo - Creates the extended info of the manager.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// resourceGroupName - The resource group name
// managerName - The manager name
// managerExtendedInfo - The manager extended information.
// options - ManagersClientCreateExtendedInfoOptions contains the optional parameters for the ManagersClient.CreateExtendedInfo
// method.
func (client *ManagersClient) CreateExtendedInfo(ctx context.Context, resourceGroupName string, managerName string, managerExtendedInfo ManagerExtendedInfo, options *ManagersClientCreateExtendedInfoOptions) (ManagersClientCreateExtendedInfoResponse, error) {
	req, err := client.createExtendedInfoCreateRequest(ctx, resourceGroupName, managerName, managerExtendedInfo, options)
	if err != nil {
		return ManagersClientCreateExtendedInfoResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagersClientCreateExtendedInfoResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ManagersClientCreateExtendedInfoResponse{}, runtime.NewResponseError(resp)
	}
	return client.createExtendedInfoHandleResponse(resp)
}

// createExtendedInfoCreateRequest creates the CreateExtendedInfo request.
func (client *ManagersClient) createExtendedInfoCreateRequest(ctx context.Context, resourceGroupName string, managerName string, managerExtendedInfo ManagerExtendedInfo, options *ManagersClientCreateExtendedInfoOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/extendedInformation/vaultExtendedInfo"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, managerExtendedInfo)
}

// createExtendedInfoHandleResponse handles the CreateExtendedInfo response.
func (client *ManagersClient) createExtendedInfoHandleResponse(resp *http.Response) (ManagersClientCreateExtendedInfoResponse, error) {
	result := ManagersClientCreateExtendedInfoResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagerExtendedInfo); err != nil {
		return ManagersClientCreateExtendedInfoResponse{}, err
	}
	return result, nil
}

// CreateOrUpdate - Creates or updates the manager.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// resourceGroupName - The resource group name
// managerName - The manager name
// manager - The manager.
// options - ManagersClientCreateOrUpdateOptions contains the optional parameters for the ManagersClient.CreateOrUpdate method.
func (client *ManagersClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, managerName string, manager Manager, options *ManagersClientCreateOrUpdateOptions) (ManagersClientCreateOrUpdateResponse, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, managerName, manager, options)
	if err != nil {
		return ManagersClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagersClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return ManagersClientCreateOrUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateHandleResponse(resp)
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *ManagersClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, managerName string, manager Manager, options *ManagersClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, manager)
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *ManagersClient) createOrUpdateHandleResponse(resp *http.Response) (ManagersClientCreateOrUpdateResponse, error) {
	result := ManagersClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Manager); err != nil {
		return ManagersClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Deletes the manager.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// resourceGroupName - The resource group name
// managerName - The manager name
// options - ManagersClientDeleteOptions contains the optional parameters for the ManagersClient.Delete method.
func (client *ManagersClient) Delete(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientDeleteOptions) (ManagersClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, managerName, options)
	if err != nil {
		return ManagersClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagersClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return ManagersClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return ManagersClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ManagersClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteExtendedInfo - Deletes the extended info of the manager.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// resourceGroupName - The resource group name
// managerName - The manager name
// options - ManagersClientDeleteExtendedInfoOptions contains the optional parameters for the ManagersClient.DeleteExtendedInfo
// method.
func (client *ManagersClient) DeleteExtendedInfo(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientDeleteExtendedInfoOptions) (ManagersClientDeleteExtendedInfoResponse, error) {
	req, err := client.deleteExtendedInfoCreateRequest(ctx, resourceGroupName, managerName, options)
	if err != nil {
		return ManagersClientDeleteExtendedInfoResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagersClientDeleteExtendedInfoResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusNoContent) {
		return ManagersClientDeleteExtendedInfoResponse{}, runtime.NewResponseError(resp)
	}
	return ManagersClientDeleteExtendedInfoResponse{}, nil
}

// deleteExtendedInfoCreateRequest creates the DeleteExtendedInfo request.
func (client *ManagersClient) deleteExtendedInfoCreateRequest(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientDeleteExtendedInfoOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/extendedInformation/vaultExtendedInfo"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Returns the properties of the specified manager name.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// resourceGroupName - The resource group name
// managerName - The manager name
// options - ManagersClientGetOptions contains the optional parameters for the ManagersClient.Get method.
func (client *ManagersClient) Get(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientGetOptions) (ManagersClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, managerName, options)
	if err != nil {
		return ManagersClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagersClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ManagersClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *ManagersClient) getCreateRequest(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ManagersClient) getHandleResponse(resp *http.Response) (ManagersClientGetResponse, error) {
	result := ManagersClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Manager); err != nil {
		return ManagersClientGetResponse{}, err
	}
	return result, nil
}

// GetEncryptionKey - Returns the symmetric encryption key of the manager.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// resourceGroupName - The resource group name
// managerName - The manager name
// options - ManagersClientGetEncryptionKeyOptions contains the optional parameters for the ManagersClient.GetEncryptionKey
// method.
func (client *ManagersClient) GetEncryptionKey(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientGetEncryptionKeyOptions) (ManagersClientGetEncryptionKeyResponse, error) {
	req, err := client.getEncryptionKeyCreateRequest(ctx, resourceGroupName, managerName, options)
	if err != nil {
		return ManagersClientGetEncryptionKeyResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagersClientGetEncryptionKeyResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ManagersClientGetEncryptionKeyResponse{}, runtime.NewResponseError(resp)
	}
	return client.getEncryptionKeyHandleResponse(resp)
}

// getEncryptionKeyCreateRequest creates the GetEncryptionKey request.
func (client *ManagersClient) getEncryptionKeyCreateRequest(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientGetEncryptionKeyOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/getEncryptionKey"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getEncryptionKeyHandleResponse handles the GetEncryptionKey response.
func (client *ManagersClient) getEncryptionKeyHandleResponse(resp *http.Response) (ManagersClientGetEncryptionKeyResponse, error) {
	result := ManagersClientGetEncryptionKeyResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SymmetricEncryptedSecret); err != nil {
		return ManagersClientGetEncryptionKeyResponse{}, err
	}
	return result, nil
}

// GetEncryptionSettings - Returns the encryption settings of the manager.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// resourceGroupName - The resource group name
// managerName - The manager name
// options - ManagersClientGetEncryptionSettingsOptions contains the optional parameters for the ManagersClient.GetEncryptionSettings
// method.
func (client *ManagersClient) GetEncryptionSettings(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientGetEncryptionSettingsOptions) (ManagersClientGetEncryptionSettingsResponse, error) {
	req, err := client.getEncryptionSettingsCreateRequest(ctx, resourceGroupName, managerName, options)
	if err != nil {
		return ManagersClientGetEncryptionSettingsResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagersClientGetEncryptionSettingsResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ManagersClientGetEncryptionSettingsResponse{}, runtime.NewResponseError(resp)
	}
	return client.getEncryptionSettingsHandleResponse(resp)
}

// getEncryptionSettingsCreateRequest creates the GetEncryptionSettings request.
func (client *ManagersClient) getEncryptionSettingsCreateRequest(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientGetEncryptionSettingsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/encryptionSettings/default"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getEncryptionSettingsHandleResponse handles the GetEncryptionSettings response.
func (client *ManagersClient) getEncryptionSettingsHandleResponse(resp *http.Response) (ManagersClientGetEncryptionSettingsResponse, error) {
	result := ManagersClientGetEncryptionSettingsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EncryptionSettings); err != nil {
		return ManagersClientGetEncryptionSettingsResponse{}, err
	}
	return result, nil
}

// GetExtendedInfo - Returns the extended information of the specified manager name.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// resourceGroupName - The resource group name
// managerName - The manager name
// options - ManagersClientGetExtendedInfoOptions contains the optional parameters for the ManagersClient.GetExtendedInfo
// method.
func (client *ManagersClient) GetExtendedInfo(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientGetExtendedInfoOptions) (ManagersClientGetExtendedInfoResponse, error) {
	req, err := client.getExtendedInfoCreateRequest(ctx, resourceGroupName, managerName, options)
	if err != nil {
		return ManagersClientGetExtendedInfoResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagersClientGetExtendedInfoResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ManagersClientGetExtendedInfoResponse{}, runtime.NewResponseError(resp)
	}
	return client.getExtendedInfoHandleResponse(resp)
}

// getExtendedInfoCreateRequest creates the GetExtendedInfo request.
func (client *ManagersClient) getExtendedInfoCreateRequest(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientGetExtendedInfoOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/extendedInformation/vaultExtendedInfo"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getExtendedInfoHandleResponse handles the GetExtendedInfo response.
func (client *ManagersClient) getExtendedInfoHandleResponse(resp *http.Response) (ManagersClientGetExtendedInfoResponse, error) {
	result := ManagersClientGetExtendedInfoResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagerExtendedInfo); err != nil {
		return ManagersClientGetExtendedInfoResponse{}, err
	}
	return result, nil
}

// NewListPager - Retrieves all the managers in a subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// options - ManagersClientListOptions contains the optional parameters for the ManagersClient.List method.
func (client *ManagersClient) NewListPager(options *ManagersClientListOptions) *runtime.Pager[ManagersClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagersClientListResponse]{
		More: func(page ManagersClientListResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *ManagersClientListResponse) (ManagersClientListResponse, error) {
			req, err := client.listCreateRequest(ctx, options)
			if err != nil {
				return ManagersClientListResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ManagersClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ManagersClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
	})
}

// listCreateRequest creates the List request.
func (client *ManagersClient) listCreateRequest(ctx context.Context, options *ManagersClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.StorSimple/managers"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *ManagersClient) listHandleResponse(resp *http.Response) (ManagersClientListResponse, error) {
	result := ManagersClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagerList); err != nil {
		return ManagersClientListResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - Retrieves all the managers in a resource group.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// resourceGroupName - The resource group name
// options - ManagersClientListByResourceGroupOptions contains the optional parameters for the ManagersClient.ListByResourceGroup
// method.
func (client *ManagersClient) NewListByResourceGroupPager(resourceGroupName string, options *ManagersClientListByResourceGroupOptions) *runtime.Pager[ManagersClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagersClientListByResourceGroupResponse]{
		More: func(page ManagersClientListByResourceGroupResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *ManagersClientListByResourceGroupResponse) (ManagersClientListByResourceGroupResponse, error) {
			req, err := client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			if err != nil {
				return ManagersClientListByResourceGroupResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ManagersClientListByResourceGroupResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ManagersClientListByResourceGroupResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *ManagersClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *ManagersClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *ManagersClient) listByResourceGroupHandleResponse(resp *http.Response) (ManagersClientListByResourceGroupResponse, error) {
	result := ManagersClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagerList); err != nil {
		return ManagersClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListMetricDefinitionPager - Retrieves metric definition of all metrics aggregated at manager.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// resourceGroupName - The resource group name
// managerName - The manager name
// options - ManagersClientListMetricDefinitionOptions contains the optional parameters for the ManagersClient.ListMetricDefinition
// method.
func (client *ManagersClient) NewListMetricDefinitionPager(resourceGroupName string, managerName string, options *ManagersClientListMetricDefinitionOptions) *runtime.Pager[ManagersClientListMetricDefinitionResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagersClientListMetricDefinitionResponse]{
		More: func(page ManagersClientListMetricDefinitionResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *ManagersClientListMetricDefinitionResponse) (ManagersClientListMetricDefinitionResponse, error) {
			req, err := client.listMetricDefinitionCreateRequest(ctx, resourceGroupName, managerName, options)
			if err != nil {
				return ManagersClientListMetricDefinitionResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ManagersClientListMetricDefinitionResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ManagersClientListMetricDefinitionResponse{}, runtime.NewResponseError(resp)
			}
			return client.listMetricDefinitionHandleResponse(resp)
		},
	})
}

// listMetricDefinitionCreateRequest creates the ListMetricDefinition request.
func (client *ManagersClient) listMetricDefinitionCreateRequest(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientListMetricDefinitionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/metricsDefinitions"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMetricDefinitionHandleResponse handles the ListMetricDefinition response.
func (client *ManagersClient) listMetricDefinitionHandleResponse(resp *http.Response) (ManagersClientListMetricDefinitionResponse, error) {
	result := ManagersClientListMetricDefinitionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MetricDefinitionList); err != nil {
		return ManagersClientListMetricDefinitionResponse{}, err
	}
	return result, nil
}

// NewListMetricsPager - Gets the manager metrics
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// resourceGroupName - The resource group name
// managerName - The manager name
// options - ManagersClientListMetricsOptions contains the optional parameters for the ManagersClient.ListMetrics method.
func (client *ManagersClient) NewListMetricsPager(resourceGroupName string, managerName string, options *ManagersClientListMetricsOptions) *runtime.Pager[ManagersClientListMetricsResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagersClientListMetricsResponse]{
		More: func(page ManagersClientListMetricsResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *ManagersClientListMetricsResponse) (ManagersClientListMetricsResponse, error) {
			req, err := client.listMetricsCreateRequest(ctx, resourceGroupName, managerName, options)
			if err != nil {
				return ManagersClientListMetricsResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return ManagersClientListMetricsResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ManagersClientListMetricsResponse{}, runtime.NewResponseError(resp)
			}
			return client.listMetricsHandleResponse(resp)
		},
	})
}

// listMetricsCreateRequest creates the ListMetrics request.
func (client *ManagersClient) listMetricsCreateRequest(ctx context.Context, resourceGroupName string, managerName string, options *ManagersClientListMetricsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/metrics"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listMetricsHandleResponse handles the ListMetrics response.
func (client *ManagersClient) listMetricsHandleResponse(resp *http.Response) (ManagersClientListMetricsResponse, error) {
	result := ManagersClientListMetricsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.MetricList); err != nil {
		return ManagersClientListMetricsResponse{}, err
	}
	return result, nil
}

// Update - Updates the StorSimple Manager.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// resourceGroupName - The resource group name
// managerName - The manager name
// parameters - The manager update parameters.
// options - ManagersClientUpdateOptions contains the optional parameters for the ManagersClient.Update method.
func (client *ManagersClient) Update(ctx context.Context, resourceGroupName string, managerName string, parameters ManagerPatch, options *ManagersClientUpdateOptions) (ManagersClientUpdateResponse, error) {
	req, err := client.updateCreateRequest(ctx, resourceGroupName, managerName, parameters, options)
	if err != nil {
		return ManagersClientUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagersClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ManagersClientUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateHandleResponse(resp)
}

// updateCreateRequest creates the Update request.
func (client *ManagersClient) updateCreateRequest(ctx context.Context, resourceGroupName string, managerName string, parameters ManagerPatch, options *ManagersClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// updateHandleResponse handles the Update response.
func (client *ManagersClient) updateHandleResponse(resp *http.Response) (ManagersClientUpdateResponse, error) {
	result := ManagersClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Manager); err != nil {
		return ManagersClientUpdateResponse{}, err
	}
	return result, nil
}

// UpdateExtendedInfo - Updates the extended info of the manager.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// resourceGroupName - The resource group name
// managerName - The manager name
// ifMatch - Pass the ETag of ExtendedInfo fetched from GET call
// managerExtendedInfo - The manager extended information.
// options - ManagersClientUpdateExtendedInfoOptions contains the optional parameters for the ManagersClient.UpdateExtendedInfo
// method.
func (client *ManagersClient) UpdateExtendedInfo(ctx context.Context, resourceGroupName string, managerName string, ifMatch string, managerExtendedInfo ManagerExtendedInfo, options *ManagersClientUpdateExtendedInfoOptions) (ManagersClientUpdateExtendedInfoResponse, error) {
	req, err := client.updateExtendedInfoCreateRequest(ctx, resourceGroupName, managerName, ifMatch, managerExtendedInfo, options)
	if err != nil {
		return ManagersClientUpdateExtendedInfoResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagersClientUpdateExtendedInfoResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ManagersClientUpdateExtendedInfoResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateExtendedInfoHandleResponse(resp)
}

// updateExtendedInfoCreateRequest creates the UpdateExtendedInfo request.
func (client *ManagersClient) updateExtendedInfoCreateRequest(ctx context.Context, resourceGroupName string, managerName string, ifMatch string, managerExtendedInfo ManagerExtendedInfo, options *ManagersClientUpdateExtendedInfoOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/extendedInformation/vaultExtendedInfo"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["If-Match"] = []string{ifMatch}
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, managerExtendedInfo)
}

// updateExtendedInfoHandleResponse handles the UpdateExtendedInfo response.
func (client *ManagersClient) updateExtendedInfoHandleResponse(resp *http.Response) (ManagersClientUpdateExtendedInfoResponse, error) {
	result := ManagersClientUpdateExtendedInfoResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagerExtendedInfo); err != nil {
		return ManagersClientUpdateExtendedInfoResponse{}, err
	}
	return result, nil
}

// UploadRegistrationCertificate - Upload Vault Cred Certificate. Returns UploadCertificateResponse
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-10-01
// certificateName - Certificate Name
// resourceGroupName - The resource group name
// managerName - The manager name
// uploadCertificateRequestrequest - UploadCertificateRequest Request
// options - ManagersClientUploadRegistrationCertificateOptions contains the optional parameters for the ManagersClient.UploadRegistrationCertificate
// method.
func (client *ManagersClient) UploadRegistrationCertificate(ctx context.Context, certificateName string, resourceGroupName string, managerName string, uploadCertificateRequestrequest UploadCertificateRequest, options *ManagersClientUploadRegistrationCertificateOptions) (ManagersClientUploadRegistrationCertificateResponse, error) {
	req, err := client.uploadRegistrationCertificateCreateRequest(ctx, certificateName, resourceGroupName, managerName, uploadCertificateRequestrequest, options)
	if err != nil {
		return ManagersClientUploadRegistrationCertificateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return ManagersClientUploadRegistrationCertificateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ManagersClientUploadRegistrationCertificateResponse{}, runtime.NewResponseError(resp)
	}
	return client.uploadRegistrationCertificateHandleResponse(resp)
}

// uploadRegistrationCertificateCreateRequest creates the UploadRegistrationCertificate request.
func (client *ManagersClient) uploadRegistrationCertificateCreateRequest(ctx context.Context, certificateName string, resourceGroupName string, managerName string, uploadCertificateRequestrequest UploadCertificateRequest, options *ManagersClientUploadRegistrationCertificateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorSimple/managers/{managerName}/certificates/{certificateName}"
	if certificateName == "" {
		return nil, errors.New("parameter certificateName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{certificateName}", url.PathEscape(certificateName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if managerName == "" {
		return nil, errors.New("parameter managerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managerName}", url.PathEscape(managerName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-10-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, uploadCertificateRequestrequest)
}

// uploadRegistrationCertificateHandleResponse handles the UploadRegistrationCertificate response.
func (client *ManagersClient) uploadRegistrationCertificateHandleResponse(resp *http.Response) (ManagersClientUploadRegistrationCertificateResponse, error) {
	result := ManagersClientUploadRegistrationCertificateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.UploadCertificateResponse); err != nil {
		return ManagersClientUploadRegistrationCertificateResponse{}, err
	}
	return result, nil
}
