//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmonitor

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// AlertRuleIncidentsClient contains the methods for the AlertRuleIncidents group.
// Don't use this type directly, use NewAlertRuleIncidentsClient() instead.
type AlertRuleIncidentsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewAlertRuleIncidentsClient creates a new instance of AlertRuleIncidentsClient with the specified values.
// subscriptionID - The ID of the target subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewAlertRuleIncidentsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*AlertRuleIncidentsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &AlertRuleIncidentsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// Get - Gets an incident associated to an alert rule
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2016-03-01
// resourceGroupName - The name of the resource group. The name is case insensitive.
// ruleName - The name of the rule.
// incidentName - The name of the incident to retrieve.
// options - AlertRuleIncidentsClientGetOptions contains the optional parameters for the AlertRuleIncidentsClient.Get method.
func (client *AlertRuleIncidentsClient) Get(ctx context.Context, resourceGroupName string, ruleName string, incidentName string, options *AlertRuleIncidentsClientGetOptions) (AlertRuleIncidentsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, ruleName, incidentName, options)
	if err != nil {
		return AlertRuleIncidentsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return AlertRuleIncidentsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return AlertRuleIncidentsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *AlertRuleIncidentsClient) getCreateRequest(ctx context.Context, resourceGroupName string, ruleName string, incidentName string, options *AlertRuleIncidentsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/alertrules/{ruleName}/incidents/{incidentName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if ruleName == "" {
		return nil, errors.New("parameter ruleName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ruleName}", url.PathEscape(ruleName))
	if incidentName == "" {
		return nil, errors.New("parameter incidentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{incidentName}", url.PathEscape(incidentName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *AlertRuleIncidentsClient) getHandleResponse(resp *http.Response) (AlertRuleIncidentsClientGetResponse, error) {
	result := AlertRuleIncidentsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Incident); err != nil {
		return AlertRuleIncidentsClientGetResponse{}, err
	}
	return result, nil
}

// NewListByAlertRulePager - Gets a list of incidents associated to an alert rule
// Generated from API version 2016-03-01
// resourceGroupName - The name of the resource group. The name is case insensitive.
// ruleName - The name of the rule.
// options - AlertRuleIncidentsClientListByAlertRuleOptions contains the optional parameters for the AlertRuleIncidentsClient.ListByAlertRule
// method.
func (client *AlertRuleIncidentsClient) NewListByAlertRulePager(resourceGroupName string, ruleName string, options *AlertRuleIncidentsClientListByAlertRuleOptions) *runtime.Pager[AlertRuleIncidentsClientListByAlertRuleResponse] {
	return runtime.NewPager(runtime.PagingHandler[AlertRuleIncidentsClientListByAlertRuleResponse]{
		More: func(page AlertRuleIncidentsClientListByAlertRuleResponse) bool {
			return false
		},
		Fetcher: func(ctx context.Context, page *AlertRuleIncidentsClientListByAlertRuleResponse) (AlertRuleIncidentsClientListByAlertRuleResponse, error) {
			req, err := client.listByAlertRuleCreateRequest(ctx, resourceGroupName, ruleName, options)
			if err != nil {
				return AlertRuleIncidentsClientListByAlertRuleResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return AlertRuleIncidentsClientListByAlertRuleResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return AlertRuleIncidentsClientListByAlertRuleResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByAlertRuleHandleResponse(resp)
		},
	})
}

// listByAlertRuleCreateRequest creates the ListByAlertRule request.
func (client *AlertRuleIncidentsClient) listByAlertRuleCreateRequest(ctx context.Context, resourceGroupName string, ruleName string, options *AlertRuleIncidentsClientListByAlertRuleOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.insights/alertrules/{ruleName}/incidents"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if ruleName == "" {
		return nil, errors.New("parameter ruleName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{ruleName}", url.PathEscape(ruleName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByAlertRuleHandleResponse handles the ListByAlertRule response.
func (client *AlertRuleIncidentsClient) listByAlertRuleHandleResponse(resp *http.Response) (AlertRuleIncidentsClientListByAlertRuleResponse, error) {
	result := AlertRuleIncidentsClientListByAlertRuleResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.IncidentListResult); err != nil {
		return AlertRuleIncidentsClientListByAlertRuleResponse{}, err
	}
	return result, nil
}
