//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armlogic

const (
	moduleName    = "armlogic"
	moduleVersion = "v1.0.0"
)

// APIDeploymentParameterVisibility - The Api deployment parameter visibility.
type APIDeploymentParameterVisibility string

const (
	APIDeploymentParameterVisibilityDefault      APIDeploymentParameterVisibility = "Default"
	APIDeploymentParameterVisibilityInternal     APIDeploymentParameterVisibility = "Internal"
	APIDeploymentParameterVisibilityNotSpecified APIDeploymentParameterVisibility = "NotSpecified"
)

// PossibleAPIDeploymentParameterVisibilityValues returns the possible values for the APIDeploymentParameterVisibility const type.
func PossibleAPIDeploymentParameterVisibilityValues() []APIDeploymentParameterVisibility {
	return []APIDeploymentParameterVisibility{
		APIDeploymentParameterVisibilityDefault,
		APIDeploymentParameterVisibilityInternal,
		APIDeploymentParameterVisibilityNotSpecified,
	}
}

// APITier - The Api tier.
type APITier string

const (
	APITierEnterprise   APITier = "Enterprise"
	APITierNotSpecified APITier = "NotSpecified"
	APITierPremium      APITier = "Premium"
	APITierStandard     APITier = "Standard"
)

// PossibleAPITierValues returns the possible values for the APITier const type.
func PossibleAPITierValues() []APITier {
	return []APITier{
		APITierEnterprise,
		APITierNotSpecified,
		APITierPremium,
		APITierStandard,
	}
}

type APIType string

const (
	APITypeNotSpecified APIType = "NotSpecified"
	APITypeRest         APIType = "Rest"
	APITypeSoap         APIType = "Soap"
)

// PossibleAPITypeValues returns the possible values for the APIType const type.
func PossibleAPITypeValues() []APIType {
	return []APIType{
		APITypeNotSpecified,
		APITypeRest,
		APITypeSoap,
	}
}

// AgreementType - The agreement type.
type AgreementType string

const (
	AgreementTypeNotSpecified AgreementType = "NotSpecified"
	AgreementTypeAS2          AgreementType = "AS2"
	AgreementTypeX12          AgreementType = "X12"
	AgreementTypeEdifact      AgreementType = "Edifact"
)

// PossibleAgreementTypeValues returns the possible values for the AgreementType const type.
func PossibleAgreementTypeValues() []AgreementType {
	return []AgreementType{
		AgreementTypeNotSpecified,
		AgreementTypeAS2,
		AgreementTypeX12,
		AgreementTypeEdifact,
	}
}

// AzureAsyncOperationState - The Azure async operation state.
type AzureAsyncOperationState string

const (
	AzureAsyncOperationStateCanceled  AzureAsyncOperationState = "Canceled"
	AzureAsyncOperationStateFailed    AzureAsyncOperationState = "Failed"
	AzureAsyncOperationStatePending   AzureAsyncOperationState = "Pending"
	AzureAsyncOperationStateSucceeded AzureAsyncOperationState = "Succeeded"
)

// PossibleAzureAsyncOperationStateValues returns the possible values for the AzureAsyncOperationState const type.
func PossibleAzureAsyncOperationStateValues() []AzureAsyncOperationState {
	return []AzureAsyncOperationState{
		AzureAsyncOperationStateCanceled,
		AzureAsyncOperationStateFailed,
		AzureAsyncOperationStatePending,
		AzureAsyncOperationStateSucceeded,
	}
}

// DayOfWeek - The day of the week.
type DayOfWeek string

const (
	DayOfWeekSunday    DayOfWeek = "Sunday"
	DayOfWeekMonday    DayOfWeek = "Monday"
	DayOfWeekTuesday   DayOfWeek = "Tuesday"
	DayOfWeekWednesday DayOfWeek = "Wednesday"
	DayOfWeekThursday  DayOfWeek = "Thursday"
	DayOfWeekFriday    DayOfWeek = "Friday"
	DayOfWeekSaturday  DayOfWeek = "Saturday"
)

// PossibleDayOfWeekValues returns the possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{
		DayOfWeekSunday,
		DayOfWeekMonday,
		DayOfWeekTuesday,
		DayOfWeekWednesday,
		DayOfWeekThursday,
		DayOfWeekFriday,
		DayOfWeekSaturday,
	}
}

type DaysOfWeek string

const (
	DaysOfWeekSunday    DaysOfWeek = "Sunday"
	DaysOfWeekMonday    DaysOfWeek = "Monday"
	DaysOfWeekTuesday   DaysOfWeek = "Tuesday"
	DaysOfWeekWednesday DaysOfWeek = "Wednesday"
	DaysOfWeekThursday  DaysOfWeek = "Thursday"
	DaysOfWeekFriday    DaysOfWeek = "Friday"
	DaysOfWeekSaturday  DaysOfWeek = "Saturday"
)

// PossibleDaysOfWeekValues returns the possible values for the DaysOfWeek const type.
func PossibleDaysOfWeekValues() []DaysOfWeek {
	return []DaysOfWeek{
		DaysOfWeekSunday,
		DaysOfWeekMonday,
		DaysOfWeekTuesday,
		DaysOfWeekWednesday,
		DaysOfWeekThursday,
		DaysOfWeekFriday,
		DaysOfWeekSaturday,
	}
}

// EdifactCharacterSet - The edifact character set.
type EdifactCharacterSet string

const (
	EdifactCharacterSetKECA         EdifactCharacterSet = "KECA"
	EdifactCharacterSetNotSpecified EdifactCharacterSet = "NotSpecified"
	EdifactCharacterSetUNOA         EdifactCharacterSet = "UNOA"
	EdifactCharacterSetUNOB         EdifactCharacterSet = "UNOB"
	EdifactCharacterSetUNOC         EdifactCharacterSet = "UNOC"
	EdifactCharacterSetUNOD         EdifactCharacterSet = "UNOD"
	EdifactCharacterSetUNOE         EdifactCharacterSet = "UNOE"
	EdifactCharacterSetUNOF         EdifactCharacterSet = "UNOF"
	EdifactCharacterSetUNOG         EdifactCharacterSet = "UNOG"
	EdifactCharacterSetUNOH         EdifactCharacterSet = "UNOH"
	EdifactCharacterSetUNOI         EdifactCharacterSet = "UNOI"
	EdifactCharacterSetUNOJ         EdifactCharacterSet = "UNOJ"
	EdifactCharacterSetUNOK         EdifactCharacterSet = "UNOK"
	EdifactCharacterSetUNOX         EdifactCharacterSet = "UNOX"
	EdifactCharacterSetUNOY         EdifactCharacterSet = "UNOY"
)

// PossibleEdifactCharacterSetValues returns the possible values for the EdifactCharacterSet const type.
func PossibleEdifactCharacterSetValues() []EdifactCharacterSet {
	return []EdifactCharacterSet{
		EdifactCharacterSetKECA,
		EdifactCharacterSetNotSpecified,
		EdifactCharacterSetUNOA,
		EdifactCharacterSetUNOB,
		EdifactCharacterSetUNOC,
		EdifactCharacterSetUNOD,
		EdifactCharacterSetUNOE,
		EdifactCharacterSetUNOF,
		EdifactCharacterSetUNOG,
		EdifactCharacterSetUNOH,
		EdifactCharacterSetUNOI,
		EdifactCharacterSetUNOJ,
		EdifactCharacterSetUNOK,
		EdifactCharacterSetUNOX,
		EdifactCharacterSetUNOY,
	}
}

// EdifactDecimalIndicator - The edifact decimal indicator.
type EdifactDecimalIndicator string

const (
	EdifactDecimalIndicatorNotSpecified EdifactDecimalIndicator = "NotSpecified"
	EdifactDecimalIndicatorComma        EdifactDecimalIndicator = "Comma"
	EdifactDecimalIndicatorDecimal      EdifactDecimalIndicator = "Decimal"
)

// PossibleEdifactDecimalIndicatorValues returns the possible values for the EdifactDecimalIndicator const type.
func PossibleEdifactDecimalIndicatorValues() []EdifactDecimalIndicator {
	return []EdifactDecimalIndicator{
		EdifactDecimalIndicatorNotSpecified,
		EdifactDecimalIndicatorComma,
		EdifactDecimalIndicatorDecimal,
	}
}

// EncryptionAlgorithm - The encryption algorithm.
type EncryptionAlgorithm string

const (
	EncryptionAlgorithmAES128       EncryptionAlgorithm = "AES128"
	EncryptionAlgorithmAES192       EncryptionAlgorithm = "AES192"
	EncryptionAlgorithmAES256       EncryptionAlgorithm = "AES256"
	EncryptionAlgorithmDES3         EncryptionAlgorithm = "DES3"
	EncryptionAlgorithmNone         EncryptionAlgorithm = "None"
	EncryptionAlgorithmNotSpecified EncryptionAlgorithm = "NotSpecified"
	EncryptionAlgorithmRC2          EncryptionAlgorithm = "RC2"
)

// PossibleEncryptionAlgorithmValues returns the possible values for the EncryptionAlgorithm const type.
func PossibleEncryptionAlgorithmValues() []EncryptionAlgorithm {
	return []EncryptionAlgorithm{
		EncryptionAlgorithmAES128,
		EncryptionAlgorithmAES192,
		EncryptionAlgorithmAES256,
		EncryptionAlgorithmDES3,
		EncryptionAlgorithmNone,
		EncryptionAlgorithmNotSpecified,
		EncryptionAlgorithmRC2,
	}
}

// ErrorResponseCode - The error response code.
type ErrorResponseCode string

const (
	ErrorResponseCodeIntegrationServiceEnvironmentNotFound ErrorResponseCode = "IntegrationServiceEnvironmentNotFound"
	ErrorResponseCodeInternalServerError                   ErrorResponseCode = "InternalServerError"
	ErrorResponseCodeInvalidOperationID                    ErrorResponseCode = "InvalidOperationId"
	ErrorResponseCodeNotSpecified                          ErrorResponseCode = "NotSpecified"
)

// PossibleErrorResponseCodeValues returns the possible values for the ErrorResponseCode const type.
func PossibleErrorResponseCodeValues() []ErrorResponseCode {
	return []ErrorResponseCode{
		ErrorResponseCodeIntegrationServiceEnvironmentNotFound,
		ErrorResponseCodeInternalServerError,
		ErrorResponseCodeInvalidOperationID,
		ErrorResponseCodeNotSpecified,
	}
}

// EventLevel - The event level.
type EventLevel string

const (
	EventLevelLogAlways     EventLevel = "LogAlways"
	EventLevelCritical      EventLevel = "Critical"
	EventLevelError         EventLevel = "Error"
	EventLevelWarning       EventLevel = "Warning"
	EventLevelInformational EventLevel = "Informational"
	EventLevelVerbose       EventLevel = "Verbose"
)

// PossibleEventLevelValues returns the possible values for the EventLevel const type.
func PossibleEventLevelValues() []EventLevel {
	return []EventLevel{
		EventLevelLogAlways,
		EventLevelCritical,
		EventLevelError,
		EventLevelWarning,
		EventLevelInformational,
		EventLevelVerbose,
	}
}

// HashingAlgorithm - The signing or hashing algorithm.
type HashingAlgorithm string

const (
	HashingAlgorithmMD5          HashingAlgorithm = "MD5"
	HashingAlgorithmNone         HashingAlgorithm = "None"
	HashingAlgorithmNotSpecified HashingAlgorithm = "NotSpecified"
	HashingAlgorithmSHA1         HashingAlgorithm = "SHA1"
	HashingAlgorithmSHA2256      HashingAlgorithm = "SHA2256"
	HashingAlgorithmSHA2384      HashingAlgorithm = "SHA2384"
	HashingAlgorithmSHA2512      HashingAlgorithm = "SHA2512"
)

// PossibleHashingAlgorithmValues returns the possible values for the HashingAlgorithm const type.
func PossibleHashingAlgorithmValues() []HashingAlgorithm {
	return []HashingAlgorithm{
		HashingAlgorithmMD5,
		HashingAlgorithmNone,
		HashingAlgorithmNotSpecified,
		HashingAlgorithmSHA1,
		HashingAlgorithmSHA2256,
		HashingAlgorithmSHA2384,
		HashingAlgorithmSHA2512,
	}
}

// IntegrationAccountSKUName - The integration account sku name.
type IntegrationAccountSKUName string

const (
	IntegrationAccountSKUNameBasic        IntegrationAccountSKUName = "Basic"
	IntegrationAccountSKUNameFree         IntegrationAccountSKUName = "Free"
	IntegrationAccountSKUNameNotSpecified IntegrationAccountSKUName = "NotSpecified"
	IntegrationAccountSKUNameStandard     IntegrationAccountSKUName = "Standard"
)

// PossibleIntegrationAccountSKUNameValues returns the possible values for the IntegrationAccountSKUName const type.
func PossibleIntegrationAccountSKUNameValues() []IntegrationAccountSKUName {
	return []IntegrationAccountSKUName{
		IntegrationAccountSKUNameBasic,
		IntegrationAccountSKUNameFree,
		IntegrationAccountSKUNameNotSpecified,
		IntegrationAccountSKUNameStandard,
	}
}

// IntegrationServiceEnvironmentAccessEndpointType - The integration service environment access endpoint type.
type IntegrationServiceEnvironmentAccessEndpointType string

const (
	IntegrationServiceEnvironmentAccessEndpointTypeExternal     IntegrationServiceEnvironmentAccessEndpointType = "External"
	IntegrationServiceEnvironmentAccessEndpointTypeInternal     IntegrationServiceEnvironmentAccessEndpointType = "Internal"
	IntegrationServiceEnvironmentAccessEndpointTypeNotSpecified IntegrationServiceEnvironmentAccessEndpointType = "NotSpecified"
)

// PossibleIntegrationServiceEnvironmentAccessEndpointTypeValues returns the possible values for the IntegrationServiceEnvironmentAccessEndpointType const type.
func PossibleIntegrationServiceEnvironmentAccessEndpointTypeValues() []IntegrationServiceEnvironmentAccessEndpointType {
	return []IntegrationServiceEnvironmentAccessEndpointType{
		IntegrationServiceEnvironmentAccessEndpointTypeExternal,
		IntegrationServiceEnvironmentAccessEndpointTypeInternal,
		IntegrationServiceEnvironmentAccessEndpointTypeNotSpecified,
	}
}

// IntegrationServiceEnvironmentNetworkDependencyCategoryType - The integration service environment network dependency category
// type.
type IntegrationServiceEnvironmentNetworkDependencyCategoryType string

const (
	IntegrationServiceEnvironmentNetworkDependencyCategoryTypeAccessEndpoints                         IntegrationServiceEnvironmentNetworkDependencyCategoryType = "AccessEndpoints"
	IntegrationServiceEnvironmentNetworkDependencyCategoryTypeAzureActiveDirectory                    IntegrationServiceEnvironmentNetworkDependencyCategoryType = "AzureActiveDirectory"
	IntegrationServiceEnvironmentNetworkDependencyCategoryTypeAzureManagement                         IntegrationServiceEnvironmentNetworkDependencyCategoryType = "AzureManagement"
	IntegrationServiceEnvironmentNetworkDependencyCategoryTypeAzureStorage                            IntegrationServiceEnvironmentNetworkDependencyCategoryType = "AzureStorage"
	IntegrationServiceEnvironmentNetworkDependencyCategoryTypeDiagnosticLogsAndMetrics                IntegrationServiceEnvironmentNetworkDependencyCategoryType = "DiagnosticLogsAndMetrics"
	IntegrationServiceEnvironmentNetworkDependencyCategoryTypeIntegrationServiceEnvironmentConnectors IntegrationServiceEnvironmentNetworkDependencyCategoryType = "IntegrationServiceEnvironmentConnectors"
	IntegrationServiceEnvironmentNetworkDependencyCategoryTypeNotSpecified                            IntegrationServiceEnvironmentNetworkDependencyCategoryType = "NotSpecified"
	IntegrationServiceEnvironmentNetworkDependencyCategoryTypeRecoveryService                         IntegrationServiceEnvironmentNetworkDependencyCategoryType = "RecoveryService"
	IntegrationServiceEnvironmentNetworkDependencyCategoryTypeRedisCache                              IntegrationServiceEnvironmentNetworkDependencyCategoryType = "RedisCache"
	IntegrationServiceEnvironmentNetworkDependencyCategoryTypeRegionalService                         IntegrationServiceEnvironmentNetworkDependencyCategoryType = "RegionalService"
	IntegrationServiceEnvironmentNetworkDependencyCategoryTypeSQL                                     IntegrationServiceEnvironmentNetworkDependencyCategoryType = "SQL"
	IntegrationServiceEnvironmentNetworkDependencyCategoryTypeSSLCertificateVerification              IntegrationServiceEnvironmentNetworkDependencyCategoryType = "SSLCertificateVerification"
)

// PossibleIntegrationServiceEnvironmentNetworkDependencyCategoryTypeValues returns the possible values for the IntegrationServiceEnvironmentNetworkDependencyCategoryType const type.
func PossibleIntegrationServiceEnvironmentNetworkDependencyCategoryTypeValues() []IntegrationServiceEnvironmentNetworkDependencyCategoryType {
	return []IntegrationServiceEnvironmentNetworkDependencyCategoryType{
		IntegrationServiceEnvironmentNetworkDependencyCategoryTypeAccessEndpoints,
		IntegrationServiceEnvironmentNetworkDependencyCategoryTypeAzureActiveDirectory,
		IntegrationServiceEnvironmentNetworkDependencyCategoryTypeAzureManagement,
		IntegrationServiceEnvironmentNetworkDependencyCategoryTypeAzureStorage,
		IntegrationServiceEnvironmentNetworkDependencyCategoryTypeDiagnosticLogsAndMetrics,
		IntegrationServiceEnvironmentNetworkDependencyCategoryTypeIntegrationServiceEnvironmentConnectors,
		IntegrationServiceEnvironmentNetworkDependencyCategoryTypeNotSpecified,
		IntegrationServiceEnvironmentNetworkDependencyCategoryTypeRecoveryService,
		IntegrationServiceEnvironmentNetworkDependencyCategoryTypeRedisCache,
		IntegrationServiceEnvironmentNetworkDependencyCategoryTypeRegionalService,
		IntegrationServiceEnvironmentNetworkDependencyCategoryTypeSQL,
		IntegrationServiceEnvironmentNetworkDependencyCategoryTypeSSLCertificateVerification,
	}
}

// IntegrationServiceEnvironmentNetworkDependencyHealthState - The integration service environment network dependency health
// state.
type IntegrationServiceEnvironmentNetworkDependencyHealthState string

const (
	IntegrationServiceEnvironmentNetworkDependencyHealthStateHealthy      IntegrationServiceEnvironmentNetworkDependencyHealthState = "Healthy"
	IntegrationServiceEnvironmentNetworkDependencyHealthStateNotSpecified IntegrationServiceEnvironmentNetworkDependencyHealthState = "NotSpecified"
	IntegrationServiceEnvironmentNetworkDependencyHealthStateUnhealthy    IntegrationServiceEnvironmentNetworkDependencyHealthState = "Unhealthy"
	IntegrationServiceEnvironmentNetworkDependencyHealthStateUnknown      IntegrationServiceEnvironmentNetworkDependencyHealthState = "Unknown"
)

// PossibleIntegrationServiceEnvironmentNetworkDependencyHealthStateValues returns the possible values for the IntegrationServiceEnvironmentNetworkDependencyHealthState const type.
func PossibleIntegrationServiceEnvironmentNetworkDependencyHealthStateValues() []IntegrationServiceEnvironmentNetworkDependencyHealthState {
	return []IntegrationServiceEnvironmentNetworkDependencyHealthState{
		IntegrationServiceEnvironmentNetworkDependencyHealthStateHealthy,
		IntegrationServiceEnvironmentNetworkDependencyHealthStateNotSpecified,
		IntegrationServiceEnvironmentNetworkDependencyHealthStateUnhealthy,
		IntegrationServiceEnvironmentNetworkDependencyHealthStateUnknown,
	}
}

// IntegrationServiceEnvironmentNetworkEndPointAccessibilityState - The integration service environment network endpoint accessibility
// state.
type IntegrationServiceEnvironmentNetworkEndPointAccessibilityState string

const (
	IntegrationServiceEnvironmentNetworkEndPointAccessibilityStateAvailable    IntegrationServiceEnvironmentNetworkEndPointAccessibilityState = "Available"
	IntegrationServiceEnvironmentNetworkEndPointAccessibilityStateNotAvailable IntegrationServiceEnvironmentNetworkEndPointAccessibilityState = "NotAvailable"
	IntegrationServiceEnvironmentNetworkEndPointAccessibilityStateNotSpecified IntegrationServiceEnvironmentNetworkEndPointAccessibilityState = "NotSpecified"
	IntegrationServiceEnvironmentNetworkEndPointAccessibilityStateUnknown      IntegrationServiceEnvironmentNetworkEndPointAccessibilityState = "Unknown"
)

// PossibleIntegrationServiceEnvironmentNetworkEndPointAccessibilityStateValues returns the possible values for the IntegrationServiceEnvironmentNetworkEndPointAccessibilityState const type.
func PossibleIntegrationServiceEnvironmentNetworkEndPointAccessibilityStateValues() []IntegrationServiceEnvironmentNetworkEndPointAccessibilityState {
	return []IntegrationServiceEnvironmentNetworkEndPointAccessibilityState{
		IntegrationServiceEnvironmentNetworkEndPointAccessibilityStateAvailable,
		IntegrationServiceEnvironmentNetworkEndPointAccessibilityStateNotAvailable,
		IntegrationServiceEnvironmentNetworkEndPointAccessibilityStateNotSpecified,
		IntegrationServiceEnvironmentNetworkEndPointAccessibilityStateUnknown,
	}
}

// IntegrationServiceEnvironmentSKUName - The integration service environment sku name.
type IntegrationServiceEnvironmentSKUName string

const (
	IntegrationServiceEnvironmentSKUNameDeveloper    IntegrationServiceEnvironmentSKUName = "Developer"
	IntegrationServiceEnvironmentSKUNameNotSpecified IntegrationServiceEnvironmentSKUName = "NotSpecified"
	IntegrationServiceEnvironmentSKUNamePremium      IntegrationServiceEnvironmentSKUName = "Premium"
)

// PossibleIntegrationServiceEnvironmentSKUNameValues returns the possible values for the IntegrationServiceEnvironmentSKUName const type.
func PossibleIntegrationServiceEnvironmentSKUNameValues() []IntegrationServiceEnvironmentSKUName {
	return []IntegrationServiceEnvironmentSKUName{
		IntegrationServiceEnvironmentSKUNameDeveloper,
		IntegrationServiceEnvironmentSKUNameNotSpecified,
		IntegrationServiceEnvironmentSKUNamePremium,
	}
}

// IntegrationServiceEnvironmentSKUScaleType - The integration service environment sku scale type.
type IntegrationServiceEnvironmentSKUScaleType string

const (
	IntegrationServiceEnvironmentSKUScaleTypeAutomatic IntegrationServiceEnvironmentSKUScaleType = "Automatic"
	IntegrationServiceEnvironmentSKUScaleTypeManual    IntegrationServiceEnvironmentSKUScaleType = "Manual"
	IntegrationServiceEnvironmentSKUScaleTypeNone      IntegrationServiceEnvironmentSKUScaleType = "None"
)

// PossibleIntegrationServiceEnvironmentSKUScaleTypeValues returns the possible values for the IntegrationServiceEnvironmentSKUScaleType const type.
func PossibleIntegrationServiceEnvironmentSKUScaleTypeValues() []IntegrationServiceEnvironmentSKUScaleType {
	return []IntegrationServiceEnvironmentSKUScaleType{
		IntegrationServiceEnvironmentSKUScaleTypeAutomatic,
		IntegrationServiceEnvironmentSKUScaleTypeManual,
		IntegrationServiceEnvironmentSKUScaleTypeNone,
	}
}

// KeyType - The key type.
type KeyType string

const (
	KeyTypeNotSpecified KeyType = "NotSpecified"
	KeyTypePrimary      KeyType = "Primary"
	KeyTypeSecondary    KeyType = "Secondary"
)

// PossibleKeyTypeValues returns the possible values for the KeyType const type.
func PossibleKeyTypeValues() []KeyType {
	return []KeyType{
		KeyTypeNotSpecified,
		KeyTypePrimary,
		KeyTypeSecondary,
	}
}

// ManagedServiceIdentityType - Type of managed service identity. The type 'SystemAssigned' includes an implicitly created
// identity. The type 'None' will remove any identities from the resource.
type ManagedServiceIdentityType string

const (
	ManagedServiceIdentityTypeNone           ManagedServiceIdentityType = "None"
	ManagedServiceIdentityTypeSystemAssigned ManagedServiceIdentityType = "SystemAssigned"
	ManagedServiceIdentityTypeUserAssigned   ManagedServiceIdentityType = "UserAssigned"
)

// PossibleManagedServiceIdentityTypeValues returns the possible values for the ManagedServiceIdentityType const type.
func PossibleManagedServiceIdentityTypeValues() []ManagedServiceIdentityType {
	return []ManagedServiceIdentityType{
		ManagedServiceIdentityTypeNone,
		ManagedServiceIdentityTypeSystemAssigned,
		ManagedServiceIdentityTypeUserAssigned,
	}
}

// MapType - The map type.
type MapType string

const (
	MapTypeLiquid       MapType = "Liquid"
	MapTypeNotSpecified MapType = "NotSpecified"
	MapTypeXslt         MapType = "Xslt"
	MapTypeXslt20       MapType = "Xslt20"
	MapTypeXslt30       MapType = "Xslt30"
)

// PossibleMapTypeValues returns the possible values for the MapType const type.
func PossibleMapTypeValues() []MapType {
	return []MapType{
		MapTypeLiquid,
		MapTypeNotSpecified,
		MapTypeXslt,
		MapTypeXslt20,
		MapTypeXslt30,
	}
}

// MessageFilterType - The message filter type.
type MessageFilterType string

const (
	MessageFilterTypeExclude      MessageFilterType = "Exclude"
	MessageFilterTypeInclude      MessageFilterType = "Include"
	MessageFilterTypeNotSpecified MessageFilterType = "NotSpecified"
)

// PossibleMessageFilterTypeValues returns the possible values for the MessageFilterType const type.
func PossibleMessageFilterTypeValues() []MessageFilterType {
	return []MessageFilterType{
		MessageFilterTypeExclude,
		MessageFilterTypeInclude,
		MessageFilterTypeNotSpecified,
	}
}

// OpenAuthenticationProviderType - Open authentication policy provider type.
type OpenAuthenticationProviderType string

const (
	OpenAuthenticationProviderTypeAAD OpenAuthenticationProviderType = "AAD"
)

// PossibleOpenAuthenticationProviderTypeValues returns the possible values for the OpenAuthenticationProviderType const type.
func PossibleOpenAuthenticationProviderTypeValues() []OpenAuthenticationProviderType {
	return []OpenAuthenticationProviderType{
		OpenAuthenticationProviderTypeAAD,
	}
}

// ParameterType - The parameter type.
type ParameterType string

const (
	ParameterTypeArray        ParameterType = "Array"
	ParameterTypeBool         ParameterType = "Bool"
	ParameterTypeFloat        ParameterType = "Float"
	ParameterTypeInt          ParameterType = "Int"
	ParameterTypeNotSpecified ParameterType = "NotSpecified"
	ParameterTypeObject       ParameterType = "Object"
	ParameterTypeSecureObject ParameterType = "SecureObject"
	ParameterTypeSecureString ParameterType = "SecureString"
	ParameterTypeString       ParameterType = "String"
)

// PossibleParameterTypeValues returns the possible values for the ParameterType const type.
func PossibleParameterTypeValues() []ParameterType {
	return []ParameterType{
		ParameterTypeArray,
		ParameterTypeBool,
		ParameterTypeFloat,
		ParameterTypeInt,
		ParameterTypeNotSpecified,
		ParameterTypeObject,
		ParameterTypeSecureObject,
		ParameterTypeSecureString,
		ParameterTypeString,
	}
}

// PartnerType - The partner type.
type PartnerType string

const (
	PartnerTypeB2B          PartnerType = "B2B"
	PartnerTypeNotSpecified PartnerType = "NotSpecified"
)

// PossiblePartnerTypeValues returns the possible values for the PartnerType const type.
func PossiblePartnerTypeValues() []PartnerType {
	return []PartnerType{
		PartnerTypeB2B,
		PartnerTypeNotSpecified,
	}
}

// RecurrenceFrequency - The recurrence frequency.
type RecurrenceFrequency string

const (
	RecurrenceFrequencyDay          RecurrenceFrequency = "Day"
	RecurrenceFrequencyHour         RecurrenceFrequency = "Hour"
	RecurrenceFrequencyMinute       RecurrenceFrequency = "Minute"
	RecurrenceFrequencyMonth        RecurrenceFrequency = "Month"
	RecurrenceFrequencyNotSpecified RecurrenceFrequency = "NotSpecified"
	RecurrenceFrequencySecond       RecurrenceFrequency = "Second"
	RecurrenceFrequencyWeek         RecurrenceFrequency = "Week"
	RecurrenceFrequencyYear         RecurrenceFrequency = "Year"
)

// PossibleRecurrenceFrequencyValues returns the possible values for the RecurrenceFrequency const type.
func PossibleRecurrenceFrequencyValues() []RecurrenceFrequency {
	return []RecurrenceFrequency{
		RecurrenceFrequencyDay,
		RecurrenceFrequencyHour,
		RecurrenceFrequencyMinute,
		RecurrenceFrequencyMonth,
		RecurrenceFrequencyNotSpecified,
		RecurrenceFrequencySecond,
		RecurrenceFrequencyWeek,
		RecurrenceFrequencyYear,
	}
}

// SKUName - The sku name.
type SKUName string

const (
	SKUNameBasic        SKUName = "Basic"
	SKUNameFree         SKUName = "Free"
	SKUNameNotSpecified SKUName = "NotSpecified"
	SKUNamePremium      SKUName = "Premium"
	SKUNameShared       SKUName = "Shared"
	SKUNameStandard     SKUName = "Standard"
)

// PossibleSKUNameValues returns the possible values for the SKUName const type.
func PossibleSKUNameValues() []SKUName {
	return []SKUName{
		SKUNameBasic,
		SKUNameFree,
		SKUNameNotSpecified,
		SKUNamePremium,
		SKUNameShared,
		SKUNameStandard,
	}
}

// SchemaType - The schema type.
type SchemaType string

const (
	SchemaTypeNotSpecified SchemaType = "NotSpecified"
	SchemaTypeXML          SchemaType = "Xml"
)

// PossibleSchemaTypeValues returns the possible values for the SchemaType const type.
func PossibleSchemaTypeValues() []SchemaType {
	return []SchemaType{
		SchemaTypeNotSpecified,
		SchemaTypeXML,
	}
}

// SegmentTerminatorSuffix - The segment terminator suffix.
type SegmentTerminatorSuffix string

const (
	SegmentTerminatorSuffixNotSpecified SegmentTerminatorSuffix = "NotSpecified"
	SegmentTerminatorSuffixNone         SegmentTerminatorSuffix = "None"
	SegmentTerminatorSuffixCR           SegmentTerminatorSuffix = "CR"
	SegmentTerminatorSuffixLF           SegmentTerminatorSuffix = "LF"
	SegmentTerminatorSuffixCRLF         SegmentTerminatorSuffix = "CRLF"
)

// PossibleSegmentTerminatorSuffixValues returns the possible values for the SegmentTerminatorSuffix const type.
func PossibleSegmentTerminatorSuffixValues() []SegmentTerminatorSuffix {
	return []SegmentTerminatorSuffix{
		SegmentTerminatorSuffixNotSpecified,
		SegmentTerminatorSuffixNone,
		SegmentTerminatorSuffixCR,
		SegmentTerminatorSuffixLF,
		SegmentTerminatorSuffixCRLF,
	}
}

// SigningAlgorithm - The signing or hashing algorithm.
type SigningAlgorithm string

const (
	SigningAlgorithmDefault      SigningAlgorithm = "Default"
	SigningAlgorithmNotSpecified SigningAlgorithm = "NotSpecified"
	SigningAlgorithmSHA1         SigningAlgorithm = "SHA1"
	SigningAlgorithmSHA2256      SigningAlgorithm = "SHA2256"
	SigningAlgorithmSHA2384      SigningAlgorithm = "SHA2384"
	SigningAlgorithmSHA2512      SigningAlgorithm = "SHA2512"
)

// PossibleSigningAlgorithmValues returns the possible values for the SigningAlgorithm const type.
func PossibleSigningAlgorithmValues() []SigningAlgorithm {
	return []SigningAlgorithm{
		SigningAlgorithmDefault,
		SigningAlgorithmNotSpecified,
		SigningAlgorithmSHA1,
		SigningAlgorithmSHA2256,
		SigningAlgorithmSHA2384,
		SigningAlgorithmSHA2512,
	}
}

// StatusAnnotation - The status annotation.
type StatusAnnotation string

const (
	StatusAnnotationNotSpecified StatusAnnotation = "NotSpecified"
	StatusAnnotationPreview      StatusAnnotation = "Preview"
	StatusAnnotationProduction   StatusAnnotation = "Production"
)

// PossibleStatusAnnotationValues returns the possible values for the StatusAnnotation const type.
func PossibleStatusAnnotationValues() []StatusAnnotation {
	return []StatusAnnotation{
		StatusAnnotationNotSpecified,
		StatusAnnotationPreview,
		StatusAnnotationProduction,
	}
}

// SwaggerSchemaType - The swagger schema type.
type SwaggerSchemaType string

const (
	SwaggerSchemaTypeArray   SwaggerSchemaType = "Array"
	SwaggerSchemaTypeBoolean SwaggerSchemaType = "Boolean"
	SwaggerSchemaTypeFile    SwaggerSchemaType = "File"
	SwaggerSchemaTypeInteger SwaggerSchemaType = "Integer"
	SwaggerSchemaTypeNull    SwaggerSchemaType = "Null"
	SwaggerSchemaTypeNumber  SwaggerSchemaType = "Number"
	SwaggerSchemaTypeObject  SwaggerSchemaType = "Object"
	SwaggerSchemaTypeString  SwaggerSchemaType = "String"
)

// PossibleSwaggerSchemaTypeValues returns the possible values for the SwaggerSchemaType const type.
func PossibleSwaggerSchemaTypeValues() []SwaggerSchemaType {
	return []SwaggerSchemaType{
		SwaggerSchemaTypeArray,
		SwaggerSchemaTypeBoolean,
		SwaggerSchemaTypeFile,
		SwaggerSchemaTypeInteger,
		SwaggerSchemaTypeNull,
		SwaggerSchemaTypeNumber,
		SwaggerSchemaTypeObject,
		SwaggerSchemaTypeString,
	}
}

// TrackEventsOperationOptions - The track events operation options.
type TrackEventsOperationOptions string

const (
	TrackEventsOperationOptionsDisableSourceInfoEnrich TrackEventsOperationOptions = "DisableSourceInfoEnrich"
	TrackEventsOperationOptionsNone                    TrackEventsOperationOptions = "None"
)

// PossibleTrackEventsOperationOptionsValues returns the possible values for the TrackEventsOperationOptions const type.
func PossibleTrackEventsOperationOptionsValues() []TrackEventsOperationOptions {
	return []TrackEventsOperationOptions{
		TrackEventsOperationOptionsDisableSourceInfoEnrich,
		TrackEventsOperationOptionsNone,
	}
}

// TrackingRecordType - The tracking record type.
type TrackingRecordType string

const (
	TrackingRecordTypeAS2MDN                               TrackingRecordType = "AS2MDN"
	TrackingRecordTypeAS2Message                           TrackingRecordType = "AS2Message"
	TrackingRecordTypeCustom                               TrackingRecordType = "Custom"
	TrackingRecordTypeEdifactFunctionalGroup               TrackingRecordType = "EdifactFunctionalGroup"
	TrackingRecordTypeEdifactFunctionalGroupAcknowledgment TrackingRecordType = "EdifactFunctionalGroupAcknowledgment"
	TrackingRecordTypeEdifactInterchange                   TrackingRecordType = "EdifactInterchange"
	TrackingRecordTypeEdifactInterchangeAcknowledgment     TrackingRecordType = "EdifactInterchangeAcknowledgment"
	TrackingRecordTypeEdifactTransactionSet                TrackingRecordType = "EdifactTransactionSet"
	TrackingRecordTypeEdifactTransactionSetAcknowledgment  TrackingRecordType = "EdifactTransactionSetAcknowledgment"
	TrackingRecordTypeNotSpecified                         TrackingRecordType = "NotSpecified"
	TrackingRecordTypeX12FunctionalGroup                   TrackingRecordType = "X12FunctionalGroup"
	TrackingRecordTypeX12FunctionalGroupAcknowledgment     TrackingRecordType = "X12FunctionalGroupAcknowledgment"
	TrackingRecordTypeX12Interchange                       TrackingRecordType = "X12Interchange"
	TrackingRecordTypeX12InterchangeAcknowledgment         TrackingRecordType = "X12InterchangeAcknowledgment"
	TrackingRecordTypeX12TransactionSet                    TrackingRecordType = "X12TransactionSet"
	TrackingRecordTypeX12TransactionSetAcknowledgment      TrackingRecordType = "X12TransactionSetAcknowledgment"
)

// PossibleTrackingRecordTypeValues returns the possible values for the TrackingRecordType const type.
func PossibleTrackingRecordTypeValues() []TrackingRecordType {
	return []TrackingRecordType{
		TrackingRecordTypeAS2MDN,
		TrackingRecordTypeAS2Message,
		TrackingRecordTypeCustom,
		TrackingRecordTypeEdifactFunctionalGroup,
		TrackingRecordTypeEdifactFunctionalGroupAcknowledgment,
		TrackingRecordTypeEdifactInterchange,
		TrackingRecordTypeEdifactInterchangeAcknowledgment,
		TrackingRecordTypeEdifactTransactionSet,
		TrackingRecordTypeEdifactTransactionSetAcknowledgment,
		TrackingRecordTypeNotSpecified,
		TrackingRecordTypeX12FunctionalGroup,
		TrackingRecordTypeX12FunctionalGroupAcknowledgment,
		TrackingRecordTypeX12Interchange,
		TrackingRecordTypeX12InterchangeAcknowledgment,
		TrackingRecordTypeX12TransactionSet,
		TrackingRecordTypeX12TransactionSetAcknowledgment,
	}
}

// TrailingSeparatorPolicy - The trailing separator policy.
type TrailingSeparatorPolicy string

const (
	TrailingSeparatorPolicyMandatory    TrailingSeparatorPolicy = "Mandatory"
	TrailingSeparatorPolicyNotAllowed   TrailingSeparatorPolicy = "NotAllowed"
	TrailingSeparatorPolicyNotSpecified TrailingSeparatorPolicy = "NotSpecified"
	TrailingSeparatorPolicyOptional     TrailingSeparatorPolicy = "Optional"
)

// PossibleTrailingSeparatorPolicyValues returns the possible values for the TrailingSeparatorPolicy const type.
func PossibleTrailingSeparatorPolicyValues() []TrailingSeparatorPolicy {
	return []TrailingSeparatorPolicy{
		TrailingSeparatorPolicyMandatory,
		TrailingSeparatorPolicyNotAllowed,
		TrailingSeparatorPolicyNotSpecified,
		TrailingSeparatorPolicyOptional,
	}
}

// UsageIndicator - The usage indicator.
type UsageIndicator string

const (
	UsageIndicatorInformation  UsageIndicator = "Information"
	UsageIndicatorNotSpecified UsageIndicator = "NotSpecified"
	UsageIndicatorProduction   UsageIndicator = "Production"
	UsageIndicatorTest         UsageIndicator = "Test"
)

// PossibleUsageIndicatorValues returns the possible values for the UsageIndicator const type.
func PossibleUsageIndicatorValues() []UsageIndicator {
	return []UsageIndicator{
		UsageIndicatorInformation,
		UsageIndicatorNotSpecified,
		UsageIndicatorProduction,
		UsageIndicatorTest,
	}
}

// WorkflowProvisioningState - The workflow provisioning state.
type WorkflowProvisioningState string

const (
	WorkflowProvisioningStateAccepted      WorkflowProvisioningState = "Accepted"
	WorkflowProvisioningStateCanceled      WorkflowProvisioningState = "Canceled"
	WorkflowProvisioningStateCompleted     WorkflowProvisioningState = "Completed"
	WorkflowProvisioningStateCreated       WorkflowProvisioningState = "Created"
	WorkflowProvisioningStateCreating      WorkflowProvisioningState = "Creating"
	WorkflowProvisioningStateDeleted       WorkflowProvisioningState = "Deleted"
	WorkflowProvisioningStateDeleting      WorkflowProvisioningState = "Deleting"
	WorkflowProvisioningStateFailed        WorkflowProvisioningState = "Failed"
	WorkflowProvisioningStateInProgress    WorkflowProvisioningState = "InProgress"
	WorkflowProvisioningStateMoving        WorkflowProvisioningState = "Moving"
	WorkflowProvisioningStateNotSpecified  WorkflowProvisioningState = "NotSpecified"
	WorkflowProvisioningStatePending       WorkflowProvisioningState = "Pending"
	WorkflowProvisioningStateReady         WorkflowProvisioningState = "Ready"
	WorkflowProvisioningStateRegistered    WorkflowProvisioningState = "Registered"
	WorkflowProvisioningStateRegistering   WorkflowProvisioningState = "Registering"
	WorkflowProvisioningStateRenewing      WorkflowProvisioningState = "Renewing"
	WorkflowProvisioningStateRunning       WorkflowProvisioningState = "Running"
	WorkflowProvisioningStateSucceeded     WorkflowProvisioningState = "Succeeded"
	WorkflowProvisioningStateUnregistered  WorkflowProvisioningState = "Unregistered"
	WorkflowProvisioningStateUnregistering WorkflowProvisioningState = "Unregistering"
	WorkflowProvisioningStateUpdating      WorkflowProvisioningState = "Updating"
	WorkflowProvisioningStateWaiting       WorkflowProvisioningState = "Waiting"
)

// PossibleWorkflowProvisioningStateValues returns the possible values for the WorkflowProvisioningState const type.
func PossibleWorkflowProvisioningStateValues() []WorkflowProvisioningState {
	return []WorkflowProvisioningState{
		WorkflowProvisioningStateAccepted,
		WorkflowProvisioningStateCanceled,
		WorkflowProvisioningStateCompleted,
		WorkflowProvisioningStateCreated,
		WorkflowProvisioningStateCreating,
		WorkflowProvisioningStateDeleted,
		WorkflowProvisioningStateDeleting,
		WorkflowProvisioningStateFailed,
		WorkflowProvisioningStateInProgress,
		WorkflowProvisioningStateMoving,
		WorkflowProvisioningStateNotSpecified,
		WorkflowProvisioningStatePending,
		WorkflowProvisioningStateReady,
		WorkflowProvisioningStateRegistered,
		WorkflowProvisioningStateRegistering,
		WorkflowProvisioningStateRenewing,
		WorkflowProvisioningStateRunning,
		WorkflowProvisioningStateSucceeded,
		WorkflowProvisioningStateUnregistered,
		WorkflowProvisioningStateUnregistering,
		WorkflowProvisioningStateUpdating,
		WorkflowProvisioningStateWaiting,
	}
}

// WorkflowState - The workflow state.
type WorkflowState string

const (
	WorkflowStateCompleted    WorkflowState = "Completed"
	WorkflowStateDeleted      WorkflowState = "Deleted"
	WorkflowStateDisabled     WorkflowState = "Disabled"
	WorkflowStateEnabled      WorkflowState = "Enabled"
	WorkflowStateNotSpecified WorkflowState = "NotSpecified"
	WorkflowStateSuspended    WorkflowState = "Suspended"
)

// PossibleWorkflowStateValues returns the possible values for the WorkflowState const type.
func PossibleWorkflowStateValues() []WorkflowState {
	return []WorkflowState{
		WorkflowStateCompleted,
		WorkflowStateDeleted,
		WorkflowStateDisabled,
		WorkflowStateEnabled,
		WorkflowStateNotSpecified,
		WorkflowStateSuspended,
	}
}

// WorkflowStatus - The workflow status.
type WorkflowStatus string

const (
	WorkflowStatusAborted      WorkflowStatus = "Aborted"
	WorkflowStatusCancelled    WorkflowStatus = "Cancelled"
	WorkflowStatusFailed       WorkflowStatus = "Failed"
	WorkflowStatusFaulted      WorkflowStatus = "Faulted"
	WorkflowStatusIgnored      WorkflowStatus = "Ignored"
	WorkflowStatusNotSpecified WorkflowStatus = "NotSpecified"
	WorkflowStatusPaused       WorkflowStatus = "Paused"
	WorkflowStatusRunning      WorkflowStatus = "Running"
	WorkflowStatusSkipped      WorkflowStatus = "Skipped"
	WorkflowStatusSucceeded    WorkflowStatus = "Succeeded"
	WorkflowStatusSuspended    WorkflowStatus = "Suspended"
	WorkflowStatusTimedOut     WorkflowStatus = "TimedOut"
	WorkflowStatusWaiting      WorkflowStatus = "Waiting"
)

// PossibleWorkflowStatusValues returns the possible values for the WorkflowStatus const type.
func PossibleWorkflowStatusValues() []WorkflowStatus {
	return []WorkflowStatus{
		WorkflowStatusAborted,
		WorkflowStatusCancelled,
		WorkflowStatusFailed,
		WorkflowStatusFaulted,
		WorkflowStatusIgnored,
		WorkflowStatusNotSpecified,
		WorkflowStatusPaused,
		WorkflowStatusRunning,
		WorkflowStatusSkipped,
		WorkflowStatusSucceeded,
		WorkflowStatusSuspended,
		WorkflowStatusTimedOut,
		WorkflowStatusWaiting,
	}
}

// WorkflowTriggerProvisioningState - The workflow trigger provisioning state.
type WorkflowTriggerProvisioningState string

const (
	WorkflowTriggerProvisioningStateAccepted      WorkflowTriggerProvisioningState = "Accepted"
	WorkflowTriggerProvisioningStateCanceled      WorkflowTriggerProvisioningState = "Canceled"
	WorkflowTriggerProvisioningStateCompleted     WorkflowTriggerProvisioningState = "Completed"
	WorkflowTriggerProvisioningStateCreated       WorkflowTriggerProvisioningState = "Created"
	WorkflowTriggerProvisioningStateCreating      WorkflowTriggerProvisioningState = "Creating"
	WorkflowTriggerProvisioningStateDeleted       WorkflowTriggerProvisioningState = "Deleted"
	WorkflowTriggerProvisioningStateDeleting      WorkflowTriggerProvisioningState = "Deleting"
	WorkflowTriggerProvisioningStateFailed        WorkflowTriggerProvisioningState = "Failed"
	WorkflowTriggerProvisioningStateMoving        WorkflowTriggerProvisioningState = "Moving"
	WorkflowTriggerProvisioningStateNotSpecified  WorkflowTriggerProvisioningState = "NotSpecified"
	WorkflowTriggerProvisioningStateReady         WorkflowTriggerProvisioningState = "Ready"
	WorkflowTriggerProvisioningStateRegistered    WorkflowTriggerProvisioningState = "Registered"
	WorkflowTriggerProvisioningStateRegistering   WorkflowTriggerProvisioningState = "Registering"
	WorkflowTriggerProvisioningStateRunning       WorkflowTriggerProvisioningState = "Running"
	WorkflowTriggerProvisioningStateSucceeded     WorkflowTriggerProvisioningState = "Succeeded"
	WorkflowTriggerProvisioningStateUnregistered  WorkflowTriggerProvisioningState = "Unregistered"
	WorkflowTriggerProvisioningStateUnregistering WorkflowTriggerProvisioningState = "Unregistering"
	WorkflowTriggerProvisioningStateUpdating      WorkflowTriggerProvisioningState = "Updating"
)

// PossibleWorkflowTriggerProvisioningStateValues returns the possible values for the WorkflowTriggerProvisioningState const type.
func PossibleWorkflowTriggerProvisioningStateValues() []WorkflowTriggerProvisioningState {
	return []WorkflowTriggerProvisioningState{
		WorkflowTriggerProvisioningStateAccepted,
		WorkflowTriggerProvisioningStateCanceled,
		WorkflowTriggerProvisioningStateCompleted,
		WorkflowTriggerProvisioningStateCreated,
		WorkflowTriggerProvisioningStateCreating,
		WorkflowTriggerProvisioningStateDeleted,
		WorkflowTriggerProvisioningStateDeleting,
		WorkflowTriggerProvisioningStateFailed,
		WorkflowTriggerProvisioningStateMoving,
		WorkflowTriggerProvisioningStateNotSpecified,
		WorkflowTriggerProvisioningStateReady,
		WorkflowTriggerProvisioningStateRegistered,
		WorkflowTriggerProvisioningStateRegistering,
		WorkflowTriggerProvisioningStateRunning,
		WorkflowTriggerProvisioningStateSucceeded,
		WorkflowTriggerProvisioningStateUnregistered,
		WorkflowTriggerProvisioningStateUnregistering,
		WorkflowTriggerProvisioningStateUpdating,
	}
}

// WsdlImportMethod - The WSDL import method.
type WsdlImportMethod string

const (
	WsdlImportMethodNotSpecified    WsdlImportMethod = "NotSpecified"
	WsdlImportMethodSoapPassThrough WsdlImportMethod = "SoapPassThrough"
	WsdlImportMethodSoapToRest      WsdlImportMethod = "SoapToRest"
)

// PossibleWsdlImportMethodValues returns the possible values for the WsdlImportMethod const type.
func PossibleWsdlImportMethodValues() []WsdlImportMethod {
	return []WsdlImportMethod{
		WsdlImportMethodNotSpecified,
		WsdlImportMethodSoapPassThrough,
		WsdlImportMethodSoapToRest,
	}
}

// X12CharacterSet - The X12 character set.
type X12CharacterSet string

const (
	X12CharacterSetBasic        X12CharacterSet = "Basic"
	X12CharacterSetExtended     X12CharacterSet = "Extended"
	X12CharacterSetNotSpecified X12CharacterSet = "NotSpecified"
	X12CharacterSetUTF8         X12CharacterSet = "UTF8"
)

// PossibleX12CharacterSetValues returns the possible values for the X12CharacterSet const type.
func PossibleX12CharacterSetValues() []X12CharacterSet {
	return []X12CharacterSet{
		X12CharacterSetBasic,
		X12CharacterSetExtended,
		X12CharacterSetNotSpecified,
		X12CharacterSetUTF8,
	}
}

// X12DateFormat - The x12 date format.
type X12DateFormat string

const (
	X12DateFormatCCYYMMDD     X12DateFormat = "CCYYMMDD"
	X12DateFormatNotSpecified X12DateFormat = "NotSpecified"
	X12DateFormatYYMMDD       X12DateFormat = "YYMMDD"
)

// PossibleX12DateFormatValues returns the possible values for the X12DateFormat const type.
func PossibleX12DateFormatValues() []X12DateFormat {
	return []X12DateFormat{
		X12DateFormatCCYYMMDD,
		X12DateFormatNotSpecified,
		X12DateFormatYYMMDD,
	}
}

// X12TimeFormat - The x12 time format.
type X12TimeFormat string

const (
	X12TimeFormatHHMM         X12TimeFormat = "HHMM"
	X12TimeFormatHHMMSS       X12TimeFormat = "HHMMSS"
	X12TimeFormatHHMMSSd      X12TimeFormat = "HHMMSSd"
	X12TimeFormatHHMMSSdd     X12TimeFormat = "HHMMSSdd"
	X12TimeFormatNotSpecified X12TimeFormat = "NotSpecified"
)

// PossibleX12TimeFormatValues returns the possible values for the X12TimeFormat const type.
func PossibleX12TimeFormatValues() []X12TimeFormat {
	return []X12TimeFormat{
		X12TimeFormatHHMM,
		X12TimeFormatHHMMSS,
		X12TimeFormatHHMMSSd,
		X12TimeFormatHHMMSSdd,
		X12TimeFormatNotSpecified,
	}
}
