//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armfrontdoor

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// FrontendEndpointsClient contains the methods for the FrontendEndpoints group.
// Don't use this type directly, use NewFrontendEndpointsClient() instead.
type FrontendEndpointsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewFrontendEndpointsClient creates a new instance of FrontendEndpointsClient with the specified values.
// subscriptionID - The subscription credentials which uniquely identify the Microsoft Azure subscription. The subscription
// ID forms part of the URI for every service call.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewFrontendEndpointsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*FrontendEndpointsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &FrontendEndpointsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginDisableHTTPS - Disables a frontendEndpoint for HTTPS traffic
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-05-01
// resourceGroupName - Name of the Resource group within the Azure subscription.
// frontDoorName - Name of the Front Door which is globally unique.
// frontendEndpointName - Name of the Frontend endpoint which is unique within the Front Door.
// options - FrontendEndpointsClientBeginDisableHTTPSOptions contains the optional parameters for the FrontendEndpointsClient.BeginDisableHTTPS
// method.
func (client *FrontendEndpointsClient) BeginDisableHTTPS(ctx context.Context, resourceGroupName string, frontDoorName string, frontendEndpointName string, options *FrontendEndpointsClientBeginDisableHTTPSOptions) (*runtime.Poller[FrontendEndpointsClientDisableHTTPSResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.disableHTTPS(ctx, resourceGroupName, frontDoorName, frontendEndpointName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller(resp, client.pl, &runtime.NewPollerOptions[FrontendEndpointsClientDisableHTTPSResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
		})
	} else {
		return runtime.NewPollerFromResumeToken[FrontendEndpointsClientDisableHTTPSResponse](options.ResumeToken, client.pl, nil)
	}
}

// DisableHTTPS - Disables a frontendEndpoint for HTTPS traffic
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-05-01
func (client *FrontendEndpointsClient) disableHTTPS(ctx context.Context, resourceGroupName string, frontDoorName string, frontendEndpointName string, options *FrontendEndpointsClientBeginDisableHTTPSOptions) (*http.Response, error) {
	req, err := client.disableHTTPSCreateRequest(ctx, resourceGroupName, frontDoorName, frontendEndpointName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// disableHTTPSCreateRequest creates the DisableHTTPS request.
func (client *FrontendEndpointsClient) disableHTTPSCreateRequest(ctx context.Context, resourceGroupName string, frontDoorName string, frontendEndpointName string, options *FrontendEndpointsClientBeginDisableHTTPSOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/frontDoors/{frontDoorName}/frontendEndpoints/{frontendEndpointName}/disableHttps"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if frontDoorName == "" {
		return nil, errors.New("parameter frontDoorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{frontDoorName}", url.PathEscape(frontDoorName))
	if frontendEndpointName == "" {
		return nil, errors.New("parameter frontendEndpointName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{frontendEndpointName}", url.PathEscape(frontendEndpointName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// BeginEnableHTTPS - Enables a frontendEndpoint for HTTPS traffic
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-05-01
// resourceGroupName - Name of the Resource group within the Azure subscription.
// frontDoorName - Name of the Front Door which is globally unique.
// frontendEndpointName - Name of the Frontend endpoint which is unique within the Front Door.
// customHTTPSConfiguration - The configuration specifying how to enable HTTPS
// options - FrontendEndpointsClientBeginEnableHTTPSOptions contains the optional parameters for the FrontendEndpointsClient.BeginEnableHTTPS
// method.
func (client *FrontendEndpointsClient) BeginEnableHTTPS(ctx context.Context, resourceGroupName string, frontDoorName string, frontendEndpointName string, customHTTPSConfiguration CustomHTTPSConfiguration, options *FrontendEndpointsClientBeginEnableHTTPSOptions) (*runtime.Poller[FrontendEndpointsClientEnableHTTPSResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.enableHTTPS(ctx, resourceGroupName, frontDoorName, frontendEndpointName, customHTTPSConfiguration, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller(resp, client.pl, &runtime.NewPollerOptions[FrontendEndpointsClientEnableHTTPSResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
		})
	} else {
		return runtime.NewPollerFromResumeToken[FrontendEndpointsClientEnableHTTPSResponse](options.ResumeToken, client.pl, nil)
	}
}

// EnableHTTPS - Enables a frontendEndpoint for HTTPS traffic
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-05-01
func (client *FrontendEndpointsClient) enableHTTPS(ctx context.Context, resourceGroupName string, frontDoorName string, frontendEndpointName string, customHTTPSConfiguration CustomHTTPSConfiguration, options *FrontendEndpointsClientBeginEnableHTTPSOptions) (*http.Response, error) {
	req, err := client.enableHTTPSCreateRequest(ctx, resourceGroupName, frontDoorName, frontendEndpointName, customHTTPSConfiguration, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// enableHTTPSCreateRequest creates the EnableHTTPS request.
func (client *FrontendEndpointsClient) enableHTTPSCreateRequest(ctx context.Context, resourceGroupName string, frontDoorName string, frontendEndpointName string, customHTTPSConfiguration CustomHTTPSConfiguration, options *FrontendEndpointsClientBeginEnableHTTPSOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/frontDoors/{frontDoorName}/frontendEndpoints/{frontendEndpointName}/enableHttps"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if frontDoorName == "" {
		return nil, errors.New("parameter frontDoorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{frontDoorName}", url.PathEscape(frontDoorName))
	if frontendEndpointName == "" {
		return nil, errors.New("parameter frontendEndpointName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{frontendEndpointName}", url.PathEscape(frontendEndpointName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, customHTTPSConfiguration)
}

// Get - Gets a Frontend endpoint with the specified name within the specified Front Door.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-05-01
// resourceGroupName - Name of the Resource group within the Azure subscription.
// frontDoorName - Name of the Front Door which is globally unique.
// frontendEndpointName - Name of the Frontend endpoint which is unique within the Front Door.
// options - FrontendEndpointsClientGetOptions contains the optional parameters for the FrontendEndpointsClient.Get method.
func (client *FrontendEndpointsClient) Get(ctx context.Context, resourceGroupName string, frontDoorName string, frontendEndpointName string, options *FrontendEndpointsClientGetOptions) (FrontendEndpointsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, frontDoorName, frontendEndpointName, options)
	if err != nil {
		return FrontendEndpointsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return FrontendEndpointsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return FrontendEndpointsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *FrontendEndpointsClient) getCreateRequest(ctx context.Context, resourceGroupName string, frontDoorName string, frontendEndpointName string, options *FrontendEndpointsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/frontDoors/{frontDoorName}/frontendEndpoints/{frontendEndpointName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if frontDoorName == "" {
		return nil, errors.New("parameter frontDoorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{frontDoorName}", url.PathEscape(frontDoorName))
	if frontendEndpointName == "" {
		return nil, errors.New("parameter frontendEndpointName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{frontendEndpointName}", url.PathEscape(frontendEndpointName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *FrontendEndpointsClient) getHandleResponse(resp *http.Response) (FrontendEndpointsClientGetResponse, error) {
	result := FrontendEndpointsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FrontendEndpoint); err != nil {
		return FrontendEndpointsClientGetResponse{}, err
	}
	return result, nil
}

// NewListByFrontDoorPager - Lists all of the frontend endpoints within a Front Door.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2020-05-01
// resourceGroupName - Name of the Resource group within the Azure subscription.
// frontDoorName - Name of the Front Door which is globally unique.
// options - FrontendEndpointsClientListByFrontDoorOptions contains the optional parameters for the FrontendEndpointsClient.ListByFrontDoor
// method.
func (client *FrontendEndpointsClient) NewListByFrontDoorPager(resourceGroupName string, frontDoorName string, options *FrontendEndpointsClientListByFrontDoorOptions) *runtime.Pager[FrontendEndpointsClientListByFrontDoorResponse] {
	return runtime.NewPager(runtime.PagingHandler[FrontendEndpointsClientListByFrontDoorResponse]{
		More: func(page FrontendEndpointsClientListByFrontDoorResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *FrontendEndpointsClientListByFrontDoorResponse) (FrontendEndpointsClientListByFrontDoorResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByFrontDoorCreateRequest(ctx, resourceGroupName, frontDoorName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return FrontendEndpointsClientListByFrontDoorResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return FrontendEndpointsClientListByFrontDoorResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return FrontendEndpointsClientListByFrontDoorResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByFrontDoorHandleResponse(resp)
		},
	})
}

// listByFrontDoorCreateRequest creates the ListByFrontDoor request.
func (client *FrontendEndpointsClient) listByFrontDoorCreateRequest(ctx context.Context, resourceGroupName string, frontDoorName string, options *FrontendEndpointsClientListByFrontDoorOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/frontDoors/{frontDoorName}/frontendEndpoints"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if frontDoorName == "" {
		return nil, errors.New("parameter frontDoorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{frontDoorName}", url.PathEscape(frontDoorName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-05-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByFrontDoorHandleResponse handles the ListByFrontDoor response.
func (client *FrontendEndpointsClient) listByFrontDoorHandleResponse(resp *http.Response) (FrontendEndpointsClientListByFrontDoorResponse, error) {
	result := FrontendEndpointsClientListByFrontDoorResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.FrontendEndpointsListResult); err != nil {
		return FrontendEndpointsClientListByFrontDoorResponse{}, err
	}
	return result, nil
}
