//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdatafactory

import "time"

// AccessPolicyResponse - Get Data Plane read only token response definition.
type AccessPolicyResponse struct {
	// Data Plane read only access token.
	AccessToken *string `json:"accessToken,omitempty"`

	// Data Plane service base URL.
	DataPlaneURL *string `json:"dataPlaneUrl,omitempty"`

	// The user access policy.
	Policy *UserAccessPolicy `json:"policy,omitempty"`
}

// ActivityClassification provides polymorphic access to related types.
// Call the interface's GetActivity() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *Activity, *AppendVariableActivity, *AzureDataExplorerCommandActivity, *AzureFunctionActivity, *AzureMLBatchExecutionActivity,
// - *AzureMLExecutePipelineActivity, *AzureMLUpdateResourceActivity, *ControlActivity, *CopyActivity, *CustomActivity, *DataLakeAnalyticsUSQLActivity,
// - *DatabricksNotebookActivity, *DatabricksSparkJarActivity, *DatabricksSparkPythonActivity, *DeleteActivity, *ExecuteDataFlowActivity,
// - *ExecutePipelineActivity, *ExecuteSSISPackageActivity, *ExecuteWranglingDataflowActivity, *ExecutionActivity, *FailActivity,
// - *FilterActivity, *ForEachActivity, *GetMetadataActivity, *HDInsightHiveActivity, *HDInsightMapReduceActivity, *HDInsightPigActivity,
// - *HDInsightSparkActivity, *HDInsightStreamingActivity, *IfConditionActivity, *LookupActivity, *SQLServerStoredProcedureActivity,
// - *ScriptActivity, *SetVariableActivity, *SwitchActivity, *SynapseNotebookActivity, *SynapseSparkJobDefinitionActivity,
// - *UntilActivity, *ValidationActivity, *WaitActivity, *WebActivity, *WebHookActivity
type ActivityClassification interface {
	// GetActivity returns the Activity content of the underlying type.
	GetActivity() *Activity
}

// Activity - A pipeline activity.
type Activity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type Activity.
func (a *Activity) GetActivity() *Activity { return a }

// ActivityDependency - Activity dependency information.
type ActivityDependency struct {
	// REQUIRED; Activity name.
	Activity *string `json:"activity,omitempty"`

	// REQUIRED; Match-Condition for the dependency.
	DependencyConditions []*DependencyCondition `json:"dependencyConditions,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}
}

// ActivityPolicy - Execution policy for an activity.
type ActivityPolicy struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with resultType integer), minimum: 0.
	Retry interface{} `json:"retry,omitempty"`

	// Interval between each retry attempt (in seconds). The default is 30 sec.
	RetryIntervalInSeconds *int32 `json:"retryIntervalInSeconds,omitempty"`

	// When set to true, Input from activity is considered as secure and will not be logged to monitoring.
	SecureInput *bool `json:"secureInput,omitempty"`

	// When set to true, Output from activity is considered as secure and will not be logged to monitoring.
	SecureOutput *bool `json:"secureOutput,omitempty"`

	// Specifies the timeout for the activity to run. The default timeout is 7 days. Type: string (or Expression with resultType
	// string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	Timeout interface{} `json:"timeout,omitempty"`
}

// ActivityRun - Information about an activity run in a pipeline.
type ActivityRun struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// READ-ONLY; The name of the activity.
	ActivityName *string `json:"activityName,omitempty" azure:"ro"`

	// READ-ONLY; The end time of the activity run in 'ISO 8601' format.
	ActivityRunEnd *time.Time `json:"activityRunEnd,omitempty" azure:"ro"`

	// READ-ONLY; The id of the activity run.
	ActivityRunID *string `json:"activityRunId,omitempty" azure:"ro"`

	// READ-ONLY; The start time of the activity run in 'ISO 8601' format.
	ActivityRunStart *time.Time `json:"activityRunStart,omitempty" azure:"ro"`

	// READ-ONLY; The type of the activity.
	ActivityType *string `json:"activityType,omitempty" azure:"ro"`

	// READ-ONLY; The duration of the activity run.
	DurationInMs *int32 `json:"durationInMs,omitempty" azure:"ro"`

	// READ-ONLY; The error if any from the activity run.
	Error interface{} `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; The input for the activity.
	Input interface{} `json:"input,omitempty" azure:"ro"`

	// READ-ONLY; The name of the compute linked service.
	LinkedServiceName *string `json:"linkedServiceName,omitempty" azure:"ro"`

	// READ-ONLY; The output for the activity.
	Output interface{} `json:"output,omitempty" azure:"ro"`

	// READ-ONLY; The name of the pipeline.
	PipelineName *string `json:"pipelineName,omitempty" azure:"ro"`

	// READ-ONLY; The id of the pipeline run.
	PipelineRunID *string `json:"pipelineRunId,omitempty" azure:"ro"`

	// READ-ONLY; The status of the activity run.
	Status *string `json:"status,omitempty" azure:"ro"`
}

// ActivityRunsClientQueryByPipelineRunOptions contains the optional parameters for the ActivityRunsClient.QueryByPipelineRun
// method.
type ActivityRunsClientQueryByPipelineRunOptions struct {
	// placeholder for future optional parameters
}

// ActivityRunsQueryResponse - A list activity runs.
type ActivityRunsQueryResponse struct {
	// REQUIRED; List of activity runs.
	Value []*ActivityRun `json:"value,omitempty"`

	// The continuation token for getting the next page of results, if any remaining results exist, null otherwise.
	ContinuationToken *string `json:"continuationToken,omitempty"`
}

// AddDataFlowToDebugSessionResponse - Response body structure for starting data flow debug session.
type AddDataFlowToDebugSessionResponse struct {
	// The ID of data flow debug job version.
	JobVersion *string `json:"jobVersion,omitempty"`
}

// AmazonMWSLinkedService - Amazon Marketplace Web Service linked service.
type AmazonMWSLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Amazon Marketplace Web Service linked service properties.
	TypeProperties *AmazonMWSLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AmazonMWSLinkedService.
func (a *AmazonMWSLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AmazonMWSLinkedServiceTypeProperties - Amazon Marketplace Web Service linked service properties.
type AmazonMWSLinkedServiceTypeProperties struct {
	// REQUIRED; The access key id used to access data.
	AccessKeyID interface{} `json:"accessKeyId,omitempty"`

	// REQUIRED; The endpoint of the Amazon MWS server, (i.e. mws.amazonservices.com)
	Endpoint interface{} `json:"endpoint,omitempty"`

	// REQUIRED; The Amazon Marketplace ID you want to retrieve data from. To retrieve data from multiple Marketplace IDs, separate
	// them with a comma (,). (i.e. A2EUQ1WTGCTBG2)
	MarketplaceID interface{} `json:"marketplaceID,omitempty"`

	// REQUIRED; The Amazon seller ID.
	SellerID interface{} `json:"sellerID,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The Amazon MWS authentication token.
	MwsAuthToken SecretBaseClassification `json:"mwsAuthToken,omitempty"`

	// The secret key used to access data.
	SecretKey SecretBaseClassification `json:"secretKey,omitempty"`

	// Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
	UseEncryptedEndpoints interface{} `json:"useEncryptedEndpoints,omitempty"`

	// Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting
	// over SSL. The default value is true.
	UseHostVerification interface{} `json:"useHostVerification,omitempty"`

	// Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
	UsePeerVerification interface{} `json:"usePeerVerification,omitempty"`
}

// AmazonMWSObjectDataset - Amazon Marketplace Web Service dataset.
type AmazonMWSObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type AmazonMWSObjectDataset.
func (a *AmazonMWSObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 a.Type,
		Description:          a.Description,
		Structure:            a.Structure,
		Schema:               a.Schema,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		Folder:               a.Folder,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AmazonMWSSource - A copy activity Amazon Marketplace Web Service source.
type AmazonMWSSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type AmazonMWSSource.
func (a *AmazonMWSSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     a.Type,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type AmazonMWSSource.
func (a *AmazonMWSSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             a.QueryTimeout,
		AdditionalColumns:        a.AdditionalColumns,
		Type:                     a.Type,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AmazonRdsForLinkedServiceTypeProperties - AmazonRdsForOracle database linked service properties.
type AmazonRdsForLinkedServiceTypeProperties struct {
	// REQUIRED; The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The Azure key vault secret reference of password in connection string.
	Password SecretBaseClassification `json:"password,omitempty"`
}

// AmazonRdsForOracleLinkedService - AmazonRdsForOracle database.
type AmazonRdsForOracleLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; AmazonRdsForOracle database linked service properties.
	TypeProperties *AmazonRdsForLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AmazonRdsForOracleLinkedService.
func (a *AmazonRdsForOracleLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AmazonRdsForOraclePartitionSettings - The settings that will be leveraged for AmazonRdsForOracle source partitioning.
type AmazonRdsForOraclePartitionSettings struct {
	// The name of the column in integer type that will be used for proceeding range partitioning. Type: string (or Expression
	// with resultType string).
	PartitionColumnName interface{} `json:"partitionColumnName,omitempty"`

	// The minimum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type:
	// string (or Expression with resultType string).
	PartitionLowerBound interface{} `json:"partitionLowerBound,omitempty"`

	// Names of the physical partitions of AmazonRdsForOracle table.
	PartitionNames interface{} `json:"partitionNames,omitempty"`

	// The maximum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type:
	// string (or Expression with resultType string).
	PartitionUpperBound interface{} `json:"partitionUpperBound,omitempty"`
}

// AmazonRdsForOracleSource - A copy activity AmazonRdsForOracle source.
type AmazonRdsForOracleSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// AmazonRdsForOracle reader query. Type: string (or Expression with resultType string).
	OracleReaderQuery interface{} `json:"oracleReaderQuery,omitempty"`

	// The partition mechanism that will be used for AmazonRdsForOracle read in parallel. Type: string (or Expression with resultType
	// string).
	PartitionOption interface{} `json:"partitionOption,omitempty"`

	// The settings that will be leveraged for AmazonRdsForOracle source partitioning.
	PartitionSettings *AmazonRdsForOraclePartitionSettings `json:"partitionSettings,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type AmazonRdsForOracleSource.
func (a *AmazonRdsForOracleSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     a.Type,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AmazonRdsForOracleTableDataset - The AmazonRdsForOracle database dataset.
type AmazonRdsForOracleTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// AmazonRdsForOracle dataset properties.
	TypeProperties *AmazonRdsForOracleTableDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type AmazonRdsForOracleTableDataset.
func (a *AmazonRdsForOracleTableDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 a.Type,
		Description:          a.Description,
		Structure:            a.Structure,
		Schema:               a.Schema,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		Folder:               a.Folder,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AmazonRdsForOracleTableDatasetTypeProperties - AmazonRdsForOracle dataset properties.
type AmazonRdsForOracleTableDatasetTypeProperties struct {
	// The schema name of the AmazonRdsForOracle database. Type: string (or Expression with resultType string).
	Schema interface{} `json:"schema,omitempty"`

	// The table name of the AmazonRdsForOracle database. Type: string (or Expression with resultType string).
	Table interface{} `json:"table,omitempty"`
}

// AmazonRdsForSQLServerLinkedService - Amazon RDS for SQL Server linked service.
type AmazonRdsForSQLServerLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Amazon RDS for SQL Server linked service properties.
	TypeProperties *AmazonRdsForSQLServerLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AmazonRdsForSQLServerLinkedService.
func (a *AmazonRdsForSQLServerLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AmazonRdsForSQLServerLinkedServiceTypeProperties - Amazon Rds for SQL Server linked service properties.
type AmazonRdsForSQLServerLinkedServiceTypeProperties struct {
	// REQUIRED; The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`

	// Sql always encrypted properties.
	AlwaysEncryptedSettings *SQLAlwaysEncryptedProperties `json:"alwaysEncryptedSettings,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The on-premises Windows authentication password.
	Password SecretBaseClassification `json:"password,omitempty"`

	// The on-premises Windows authentication user name. Type: string (or Expression with resultType string).
	UserName interface{} `json:"userName,omitempty"`
}

// AmazonRdsForSQLServerSource - A copy activity Amazon RDS for SQL Server source.
type AmazonRdsForSQLServerSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// The partition mechanism that will be used for Sql read in parallel. Possible values include: "None", "PhysicalPartitionsOfTable",
	// "DynamicRange".
	PartitionOption interface{} `json:"partitionOption,omitempty"`

	// The settings that will be leveraged for Sql source partitioning.
	PartitionSettings *SQLPartitionSettings `json:"partitionSettings,omitempty"`

	// Which additional types to produce.
	ProduceAdditionalTypes interface{} `json:"produceAdditionalTypes,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// SQL reader query. Type: string (or Expression with resultType string).
	SQLReaderQuery interface{} `json:"sqlReaderQuery,omitempty"`

	// Name of the stored procedure for a SQL Database source. This cannot be used at the same time as SqlReaderQuery. Type: string
	// (or Expression with resultType string).
	SQLReaderStoredProcedureName interface{} `json:"sqlReaderStoredProcedureName,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`

	// Value and type setting for stored procedure parameters. Example: "{Parameter1: {value: "1", type: "int"}}".
	StoredProcedureParameters interface{} `json:"storedProcedureParameters,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type AmazonRdsForSQLServerSource.
func (a *AmazonRdsForSQLServerSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     a.Type,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type AmazonRdsForSQLServerSource.
func (a *AmazonRdsForSQLServerSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             a.QueryTimeout,
		AdditionalColumns:        a.AdditionalColumns,
		Type:                     a.Type,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AmazonRdsForSQLServerTableDataset - The Amazon RDS for SQL Server dataset.
type AmazonRdsForSQLServerTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// The Amazon RDS for SQL Server dataset properties.
	TypeProperties *AmazonRdsForSQLServerTableDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type AmazonRdsForSQLServerTableDataset.
func (a *AmazonRdsForSQLServerTableDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 a.Type,
		Description:          a.Description,
		Structure:            a.Structure,
		Schema:               a.Schema,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		Folder:               a.Folder,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AmazonRdsForSQLServerTableDatasetTypeProperties - The Amazon RDS for SQL Server dataset properties.
type AmazonRdsForSQLServerTableDatasetTypeProperties struct {
	// The schema name of the SQL Server dataset. Type: string (or Expression with resultType string).
	Schema interface{} `json:"schema,omitempty"`

	// The table name of the SQL Server dataset. Type: string (or Expression with resultType string).
	Table interface{} `json:"table,omitempty"`
}

// AmazonRedshiftLinkedService - Linked service for Amazon Redshift.
type AmazonRedshiftLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Amazon Redshift linked service properties.
	TypeProperties *AmazonRedshiftLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AmazonRedshiftLinkedService.
func (a *AmazonRedshiftLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AmazonRedshiftLinkedServiceTypeProperties - Amazon Redshift linked service properties.
type AmazonRedshiftLinkedServiceTypeProperties struct {
	// REQUIRED; The database name of the Amazon Redshift source. Type: string (or Expression with resultType string).
	Database interface{} `json:"database,omitempty"`

	// REQUIRED; The name of the Amazon Redshift server. Type: string (or Expression with resultType string).
	Server interface{} `json:"server,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The password of the Amazon Redshift source.
	Password SecretBaseClassification `json:"password,omitempty"`

	// The TCP port number that the Amazon Redshift server uses to listen for client connections. The default value is 5439. Type:
	// integer (or Expression with resultType integer).
	Port interface{} `json:"port,omitempty"`

	// The username of the Amazon Redshift source. Type: string (or Expression with resultType string).
	Username interface{} `json:"username,omitempty"`
}

// AmazonRedshiftSource - A copy activity source for Amazon Redshift Source.
type AmazonRedshiftSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Database query. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// The Amazon S3 settings needed for the interim Amazon S3 when copying from Amazon Redshift with unload. With this, data
	// from Amazon Redshift source will be unloaded into S3 first and then copied into
	// the targeted sink from the interim S3.
	RedshiftUnloadSettings *RedshiftUnloadSettings `json:"redshiftUnloadSettings,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type AmazonRedshiftSource.
func (a *AmazonRedshiftSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     a.Type,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type AmazonRedshiftSource.
func (a *AmazonRedshiftSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             a.QueryTimeout,
		AdditionalColumns:        a.AdditionalColumns,
		Type:                     a.Type,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AmazonRedshiftTableDataset - The Amazon Redshift table dataset.
type AmazonRedshiftTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Amazon Redshift table dataset properties.
	TypeProperties *AmazonRedshiftTableDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type AmazonRedshiftTableDataset.
func (a *AmazonRedshiftTableDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 a.Type,
		Description:          a.Description,
		Structure:            a.Structure,
		Schema:               a.Schema,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		Folder:               a.Folder,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AmazonRedshiftTableDatasetTypeProperties - Amazon Redshift table dataset properties.
type AmazonRedshiftTableDatasetTypeProperties struct {
	// The Amazon Redshift schema name. Type: string (or Expression with resultType string).
	Schema interface{} `json:"schema,omitempty"`

	// The Amazon Redshift table name. Type: string (or Expression with resultType string).
	Table interface{} `json:"table,omitempty"`

	// This property will be retired. Please consider using schema + table properties instead.
	TableName interface{} `json:"tableName,omitempty"`
}

// AmazonS3CompatibleLinkedService - Linked service for Amazon S3 Compatible.
type AmazonS3CompatibleLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Amazon S3 Compatible linked service properties.
	TypeProperties *AmazonS3CompatibleLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AmazonS3CompatibleLinkedService.
func (a *AmazonS3CompatibleLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AmazonS3CompatibleLinkedServiceTypeProperties - Amazon S3 Compatible linked service properties.
type AmazonS3CompatibleLinkedServiceTypeProperties struct {
	// The access key identifier of the Amazon S3 Compatible Identity and Access Management (IAM) user. Type: string (or Expression
	// with resultType string).
	AccessKeyID interface{} `json:"accessKeyId,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// If true, use S3 path-style access instead of virtual hosted-style access. Default value is false. Type: boolean (or Expression
	// with resultType boolean).
	ForcePathStyle interface{} `json:"forcePathStyle,omitempty"`

	// The secret access key of the Amazon S3 Compatible Identity and Access Management (IAM) user.
	SecretAccessKey SecretBaseClassification `json:"secretAccessKey,omitempty"`

	// This value specifies the endpoint to access with the Amazon S3 Compatible Connector. This is an optional property; change
	// it only if you want to try a different service endpoint or want to switch
	// between https and http. Type: string (or Expression with resultType string).
	ServiceURL interface{} `json:"serviceUrl,omitempty"`
}

// AmazonS3CompatibleLocation - The location of Amazon S3 Compatible dataset.
type AmazonS3CompatibleLocation struct {
	// REQUIRED; Type of dataset storage location.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Specify the bucketName of Amazon S3 Compatible. Type: string (or Expression with resultType string)
	BucketName interface{} `json:"bucketName,omitempty"`

	// Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`

	// Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath interface{} `json:"folderPath,omitempty"`

	// Specify the version of Amazon S3 Compatible. Type: string (or Expression with resultType string).
	Version interface{} `json:"version,omitempty"`
}

// GetDatasetLocation implements the DatasetLocationClassification interface for type AmazonS3CompatibleLocation.
func (a *AmazonS3CompatibleLocation) GetDatasetLocation() *DatasetLocation {
	return &DatasetLocation{
		Type:                 a.Type,
		FolderPath:           a.FolderPath,
		FileName:             a.FileName,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AmazonS3CompatibleReadSettings - Amazon S3 Compatible read settings.
type AmazonS3CompatibleReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression
	// with resultType boolean).
	DeleteFilesAfterCompletion interface{} `json:"deleteFilesAfterCompletion,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// Indicates whether to enable partition discovery.
	EnablePartitionDiscovery *bool `json:"enablePartitionDiscovery,omitempty"`

	// Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy.
	// Type: string (or Expression with resultType string).
	FileListPath interface{} `json:"fileListPath,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd interface{} `json:"modifiedDatetimeEnd,omitempty"`

	// The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart interface{} `json:"modifiedDatetimeStart,omitempty"`

	// Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath interface{} `json:"partitionRootPath,omitempty"`

	// The prefix filter for the S3 Compatible object name. Type: string (or Expression with resultType string).
	Prefix interface{} `json:"prefix,omitempty"`

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive interface{} `json:"recursive,omitempty"`

	// Amazon S3 Compatible wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName interface{} `json:"wildcardFileName,omitempty"`

	// Amazon S3 Compatible wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath interface{} `json:"wildcardFolderPath,omitempty"`
}

// GetStoreReadSettings implements the StoreReadSettingsClassification interface for type AmazonS3CompatibleReadSettings.
func (a *AmazonS3CompatibleReadSettings) GetStoreReadSettings() *StoreReadSettings {
	return &StoreReadSettings{
		Type:                     a.Type,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AmazonS3Dataset - A single Amazon Simple Storage Service (S3) object or a set of S3 objects.
type AmazonS3Dataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Amazon S3 dataset properties.
	TypeProperties *AmazonS3DatasetTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type AmazonS3Dataset.
func (a *AmazonS3Dataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 a.Type,
		Description:          a.Description,
		Structure:            a.Structure,
		Schema:               a.Schema,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		Folder:               a.Folder,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AmazonS3DatasetTypeProperties - Amazon S3 dataset properties.
type AmazonS3DatasetTypeProperties struct {
	// REQUIRED; The name of the Amazon S3 bucket. Type: string (or Expression with resultType string).
	BucketName interface{} `json:"bucketName,omitempty"`

	// The data compression method used for the Amazon S3 object.
	Compression *DatasetCompression `json:"compression,omitempty"`

	// The format of files.
	Format DatasetStorageFormatClassification `json:"format,omitempty"`

	// The key of the Amazon S3 object. Type: string (or Expression with resultType string).
	Key interface{} `json:"key,omitempty"`

	// The end of S3 object's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd interface{} `json:"modifiedDatetimeEnd,omitempty"`

	// The start of S3 object's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart interface{} `json:"modifiedDatetimeStart,omitempty"`

	// The prefix filter for the S3 object name. Type: string (or Expression with resultType string).
	Prefix interface{} `json:"prefix,omitempty"`

	// The version for the S3 object. Type: string (or Expression with resultType string).
	Version interface{} `json:"version,omitempty"`
}

// AmazonS3LinkedService - Linked service for Amazon S3.
type AmazonS3LinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Amazon S3 linked service properties.
	TypeProperties *AmazonS3LinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AmazonS3LinkedService.
func (a *AmazonS3LinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AmazonS3LinkedServiceTypeProperties - Amazon S3 linked service properties.
type AmazonS3LinkedServiceTypeProperties struct {
	// The access key identifier of the Amazon S3 Identity and Access Management (IAM) user. Type: string (or Expression with
	// resultType string).
	AccessKeyID interface{} `json:"accessKeyId,omitempty"`

	// The authentication type of S3. Allowed value: AccessKey (default) or TemporarySecurityCredentials. Type: string (or Expression
	// with resultType string).
	AuthenticationType interface{} `json:"authenticationType,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The secret access key of the Amazon S3 Identity and Access Management (IAM) user.
	SecretAccessKey SecretBaseClassification `json:"secretAccessKey,omitempty"`

	// This value specifies the endpoint to access with the S3 Connector. This is an optional property; change it only if you
	// want to try a different service endpoint or want to switch between https and
	// http. Type: string (or Expression with resultType string).
	ServiceURL interface{} `json:"serviceUrl,omitempty"`

	// The session token for the S3 temporary security credential.
	SessionToken SecretBaseClassification `json:"sessionToken,omitempty"`
}

// AmazonS3Location - The location of amazon S3 dataset.
type AmazonS3Location struct {
	// REQUIRED; Type of dataset storage location.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Specify the bucketName of amazon S3. Type: string (or Expression with resultType string)
	BucketName interface{} `json:"bucketName,omitempty"`

	// Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`

	// Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath interface{} `json:"folderPath,omitempty"`

	// Specify the version of amazon S3. Type: string (or Expression with resultType string).
	Version interface{} `json:"version,omitempty"`
}

// GetDatasetLocation implements the DatasetLocationClassification interface for type AmazonS3Location.
func (a *AmazonS3Location) GetDatasetLocation() *DatasetLocation {
	return &DatasetLocation{
		Type:                 a.Type,
		FolderPath:           a.FolderPath,
		FileName:             a.FileName,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AmazonS3ReadSettings - Amazon S3 read settings.
type AmazonS3ReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression
	// with resultType boolean).
	DeleteFilesAfterCompletion interface{} `json:"deleteFilesAfterCompletion,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// Indicates whether to enable partition discovery.
	EnablePartitionDiscovery *bool `json:"enablePartitionDiscovery,omitempty"`

	// Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy.
	// Type: string (or Expression with resultType string).
	FileListPath interface{} `json:"fileListPath,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd interface{} `json:"modifiedDatetimeEnd,omitempty"`

	// The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart interface{} `json:"modifiedDatetimeStart,omitempty"`

	// Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath interface{} `json:"partitionRootPath,omitempty"`

	// The prefix filter for the S3 object name. Type: string (or Expression with resultType string).
	Prefix interface{} `json:"prefix,omitempty"`

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive interface{} `json:"recursive,omitempty"`

	// AmazonS3 wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName interface{} `json:"wildcardFileName,omitempty"`

	// AmazonS3 wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath interface{} `json:"wildcardFolderPath,omitempty"`
}

// GetStoreReadSettings implements the StoreReadSettingsClassification interface for type AmazonS3ReadSettings.
func (a *AmazonS3ReadSettings) GetStoreReadSettings() *StoreReadSettings {
	return &StoreReadSettings{
		Type:                     a.Type,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AppFiguresLinkedService - Linked service for AppFigures.
type AppFiguresLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; AppFigures linked service properties.
	TypeProperties *AppFiguresLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AppFiguresLinkedService.
func (a *AppFiguresLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AppFiguresLinkedServiceTypeProperties - AppFigures linked service type properties.
type AppFiguresLinkedServiceTypeProperties struct {
	// REQUIRED; The client key for the AppFigures source.
	ClientKey SecretBaseClassification `json:"clientKey,omitempty"`

	// REQUIRED; The password of the AppFigures source.
	Password SecretBaseClassification `json:"password,omitempty"`

	// REQUIRED; The username of the Appfigures source.
	UserName interface{} `json:"userName,omitempty"`
}

// AppendVariableActivity - Append value for a Variable of type Array.
type AppendVariableActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Append Variable activity properties.
	TypeProperties *AppendVariableActivityTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type AppendVariableActivity.
func (a *AppendVariableActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 a.Name,
		Type:                 a.Type,
		Description:          a.Description,
		DependsOn:            a.DependsOn,
		UserProperties:       a.UserProperties,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// GetControlActivity implements the ControlActivityClassification interface for type AppendVariableActivity.
func (a *AppendVariableActivity) GetControlActivity() *ControlActivity {
	return &ControlActivity{
		Name:                 a.Name,
		Type:                 a.Type,
		Description:          a.Description,
		DependsOn:            a.DependsOn,
		UserProperties:       a.UserProperties,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AppendVariableActivityTypeProperties - AppendVariable activity properties.
type AppendVariableActivityTypeProperties struct {
	// Value to be appended. Could be a static value or Expression
	Value interface{} `json:"value,omitempty"`

	// Name of the variable whose value needs to be appended to.
	VariableName *string `json:"variableName,omitempty"`
}

// ArmIDWrapper - A wrapper for an ARM resource id
type ArmIDWrapper struct {
	// READ-ONLY
	ID *string `json:"id,omitempty" azure:"ro"`
}

// AsanaLinkedService - Linked service for Asana.
type AsanaLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Asana linked service properties.
	TypeProperties *AsanaLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AsanaLinkedService.
func (a *AsanaLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AsanaLinkedServiceTypeProperties - Asana linked service type properties.
type AsanaLinkedServiceTypeProperties struct {
	// REQUIRED; The api token for the Asana source.
	APIToken SecretBaseClassification `json:"apiToken,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// AvroDataset - Avro dataset.
type AvroDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Avro dataset properties.
	TypeProperties *AvroDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type AvroDataset.
func (a *AvroDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 a.Type,
		Description:          a.Description,
		Structure:            a.Structure,
		Schema:               a.Schema,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		Folder:               a.Folder,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AvroDatasetTypeProperties - Avro dataset properties.
type AvroDatasetTypeProperties struct {
	// REQUIRED; The location of the avro storage.
	Location DatasetLocationClassification `json:"location,omitempty"`

	// The data avroCompressionCodec. Type: string (or Expression with resultType string).
	AvroCompressionCodec interface{} `json:"avroCompressionCodec,omitempty"`
	AvroCompressionLevel *int32      `json:"avroCompressionLevel,omitempty"`
}

// AvroFormat - The data stored in Avro format.
type AvroFormat struct {
	// REQUIRED; Type of dataset storage format.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Deserializer. Type: string (or Expression with resultType string).
	Deserializer interface{} `json:"deserializer,omitempty"`

	// Serializer. Type: string (or Expression with resultType string).
	Serializer interface{} `json:"serializer,omitempty"`
}

// GetDatasetStorageFormat implements the DatasetStorageFormatClassification interface for type AvroFormat.
func (a *AvroFormat) GetDatasetStorageFormat() *DatasetStorageFormat {
	return &DatasetStorageFormat{
		Type:                 a.Type,
		Serializer:           a.Serializer,
		Deserializer:         a.Deserializer,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AvroSink - A copy activity Avro sink.
type AvroSink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// Avro format settings.
	FormatSettings *AvroWriteSettings `json:"formatSettings,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// Avro store settings.
	StoreSettings StoreWriteSettingsClassification `json:"storeSettings,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type AvroSink.
func (a *AvroSink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     a.Type,
		WriteBatchSize:           a.WriteBatchSize,
		WriteBatchTimeout:        a.WriteBatchTimeout,
		SinkRetryCount:           a.SinkRetryCount,
		SinkRetryWait:            a.SinkRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AvroSource - A copy activity Avro source.
type AvroSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`

	// Avro store settings.
	StoreSettings StoreReadSettingsClassification `json:"storeSettings,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type AvroSource.
func (a *AvroSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     a.Type,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AvroWriteSettings - Avro write settings.
type AvroWriteSettings struct {
	// REQUIRED; The write setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Specifies the file name pattern _. when copy from non-file based store without partitionOptions. Type: string (or Expression
	// with resultType string).
	FileNamePrefix interface{} `json:"fileNamePrefix,omitempty"`

	// Limit the written file's row count to be smaller than or equal to the specified count. Type: integer (or Expression with
	// resultType integer).
	MaxRowsPerFile interface{} `json:"maxRowsPerFile,omitempty"`

	// Top level record name in write result, which is required in AVRO spec.
	RecordName *string `json:"recordName,omitempty"`

	// Record namespace in the write result.
	RecordNamespace *string `json:"recordNamespace,omitempty"`
}

// GetFormatWriteSettings implements the FormatWriteSettingsClassification interface for type AvroWriteSettings.
func (a *AvroWriteSettings) GetFormatWriteSettings() *FormatWriteSettings {
	return &FormatWriteSettings{
		Type:                 a.Type,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzPowerShellSetup - The express custom setup of installing Azure PowerShell.
type AzPowerShellSetup struct {
	// REQUIRED; The type of custom setup.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Install Azure PowerShell type properties.
	TypeProperties *AzPowerShellSetupTypeProperties `json:"typeProperties,omitempty"`
}

// GetCustomSetupBase implements the CustomSetupBaseClassification interface for type AzPowerShellSetup.
func (a *AzPowerShellSetup) GetCustomSetupBase() *CustomSetupBase {
	return &CustomSetupBase{
		Type: a.Type,
	}
}

// AzPowerShellSetupTypeProperties - Installation of Azure PowerShell type properties.
type AzPowerShellSetupTypeProperties struct {
	// REQUIRED; The required version of Azure PowerShell to install.
	Version *string `json:"version,omitempty"`
}

// AzureBatchLinkedService - Azure Batch linked service.
type AzureBatchLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure Batch linked service properties.
	TypeProperties *AzureBatchLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureBatchLinkedService.
func (a *AzureBatchLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureBatchLinkedServiceTypeProperties - Azure Batch linked service properties.
type AzureBatchLinkedServiceTypeProperties struct {
	// REQUIRED; The Azure Batch account name. Type: string (or Expression with resultType string).
	AccountName interface{} `json:"accountName,omitempty"`

	// REQUIRED; The Azure Batch URI. Type: string (or Expression with resultType string).
	BatchURI interface{} `json:"batchUri,omitempty"`

	// REQUIRED; The Azure Storage linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; The Azure Batch pool name. Type: string (or Expression with resultType string).
	PoolName interface{} `json:"poolName,omitempty"`

	// The Azure Batch account access key.
	AccessKey SecretBaseClassification `json:"accessKey,omitempty"`

	// The credential reference containing authentication information.
	Credential *CredentialReference `json:"credential,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// AzureBlobDataset - The Azure Blob storage.
type AzureBlobDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Azure Blob dataset properties.
	TypeProperties *AzureBlobDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type AzureBlobDataset.
func (a *AzureBlobDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 a.Type,
		Description:          a.Description,
		Structure:            a.Structure,
		Schema:               a.Schema,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		Folder:               a.Folder,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureBlobDatasetTypeProperties - Azure Blob dataset properties.
type AzureBlobDatasetTypeProperties struct {
	// The data compression method used for the blob storage.
	Compression *DatasetCompression `json:"compression,omitempty"`

	// The name of the Azure Blob. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`

	// The path of the Azure Blob storage. Type: string (or Expression with resultType string).
	FolderPath interface{} `json:"folderPath,omitempty"`

	// The format of the Azure Blob storage.
	Format DatasetStorageFormatClassification `json:"format,omitempty"`

	// The end of Azure Blob's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd interface{} `json:"modifiedDatetimeEnd,omitempty"`

	// The start of Azure Blob's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart interface{} `json:"modifiedDatetimeStart,omitempty"`

	// The root of blob path. Type: string (or Expression with resultType string).
	TableRootLocation interface{} `json:"tableRootLocation,omitempty"`
}

// AzureBlobFSDataset - The Azure Data Lake Storage Gen2 storage.
type AzureBlobFSDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Azure Data Lake Storage Gen2 dataset properties.
	TypeProperties *AzureBlobFSDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type AzureBlobFSDataset.
func (a *AzureBlobFSDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 a.Type,
		Description:          a.Description,
		Structure:            a.Structure,
		Schema:               a.Schema,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		Folder:               a.Folder,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureBlobFSDatasetTypeProperties - Azure Data Lake Storage Gen2 dataset properties.
type AzureBlobFSDatasetTypeProperties struct {
	// The data compression method used for the blob storage.
	Compression *DatasetCompression `json:"compression,omitempty"`

	// The name of the Azure Data Lake Storage Gen2. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`

	// The path of the Azure Data Lake Storage Gen2 storage. Type: string (or Expression with resultType string).
	FolderPath interface{} `json:"folderPath,omitempty"`

	// The format of the Azure Data Lake Storage Gen2 storage.
	Format DatasetStorageFormatClassification `json:"format,omitempty"`
}

// AzureBlobFSLinkedService - Azure Data Lake Storage Gen2 linked service.
type AzureBlobFSLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure Data Lake Storage Gen2 linked service properties.
	TypeProperties *AzureBlobFSLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureBlobFSLinkedService.
func (a *AzureBlobFSLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureBlobFSLinkedServiceTypeProperties - Azure Data Lake Storage Gen2 linked service properties.
type AzureBlobFSLinkedServiceTypeProperties struct {
	// REQUIRED; Endpoint for the Azure Data Lake Storage Gen2 service. Type: string (or Expression with resultType string).
	URL interface{} `json:"url,omitempty"`

	// Account key for the Azure Data Lake Storage Gen2 service. Type: string (or Expression with resultType string).
	AccountKey interface{} `json:"accountKey,omitempty"`

	// Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment,
	// AzureGermany. Default value is the data factory regions’ cloud type. Type:
	// string (or Expression with resultType string).
	AzureCloudType interface{} `json:"azureCloudType,omitempty"`

	// The credential reference containing authentication information.
	Credential *CredentialReference `json:"credential,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
	// servicePrincipalCredential can be SecureString or
	// AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can
	// only be AzureKeyVaultSecretReference.
	ServicePrincipalCredential SecretBaseClassification `json:"servicePrincipalCredential,omitempty"`

	// The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret,
	// 'ServicePrincipalCert' for certificate. Type: string (or Expression with
	// resultType string).
	ServicePrincipalCredentialType interface{} `json:"servicePrincipalCredentialType,omitempty"`

	// The ID of the application used to authenticate against the Azure Data Lake Storage Gen2 account. Type: string (or Expression
	// with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`

	// The Key of the application used to authenticate against the Azure Data Lake Storage Gen2 account.
	ServicePrincipalKey SecretBaseClassification `json:"servicePrincipalKey,omitempty"`

	// The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`
}

// AzureBlobFSLocation - The location of azure blobFS dataset.
type AzureBlobFSLocation struct {
	// REQUIRED; Type of dataset storage location.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`

	// Specify the fileSystem of azure blobFS. Type: string (or Expression with resultType string).
	FileSystem interface{} `json:"fileSystem,omitempty"`

	// Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath interface{} `json:"folderPath,omitempty"`
}

// GetDatasetLocation implements the DatasetLocationClassification interface for type AzureBlobFSLocation.
func (a *AzureBlobFSLocation) GetDatasetLocation() *DatasetLocation {
	return &DatasetLocation{
		Type:                 a.Type,
		FolderPath:           a.FolderPath,
		FileName:             a.FileName,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureBlobFSReadSettings - Azure blobFS read settings.
type AzureBlobFSReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression
	// with resultType boolean).
	DeleteFilesAfterCompletion interface{} `json:"deleteFilesAfterCompletion,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// Indicates whether to enable partition discovery.
	EnablePartitionDiscovery *bool `json:"enablePartitionDiscovery,omitempty"`

	// Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy.
	// Type: string (or Expression with resultType string).
	FileListPath interface{} `json:"fileListPath,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd interface{} `json:"modifiedDatetimeEnd,omitempty"`

	// The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart interface{} `json:"modifiedDatetimeStart,omitempty"`

	// Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath interface{} `json:"partitionRootPath,omitempty"`

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive interface{} `json:"recursive,omitempty"`

	// Azure blobFS wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName interface{} `json:"wildcardFileName,omitempty"`

	// Azure blobFS wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath interface{} `json:"wildcardFolderPath,omitempty"`
}

// GetStoreReadSettings implements the StoreReadSettingsClassification interface for type AzureBlobFSReadSettings.
func (a *AzureBlobFSReadSettings) GetStoreReadSettings() *StoreReadSettings {
	return &StoreReadSettings{
		Type:                     a.Type,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AzureBlobFSSink - A copy activity Azure Data Lake Storage Gen2 sink.
type AzureBlobFSSink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// The type of copy behavior for copy sink.
	CopyBehavior interface{} `json:"copyBehavior,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
	Metadata []*MetadataItem `json:"metadata,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type AzureBlobFSSink.
func (a *AzureBlobFSSink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     a.Type,
		WriteBatchSize:           a.WriteBatchSize,
		WriteBatchTimeout:        a.WriteBatchTimeout,
		SinkRetryCount:           a.SinkRetryCount,
		SinkRetryWait:            a.SinkRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AzureBlobFSSource - A copy activity Azure BlobFS source.
type AzureBlobFSSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive interface{} `json:"recursive,omitempty"`

	// Number of header lines to skip from each blob. Type: integer (or Expression with resultType integer).
	SkipHeaderLineCount interface{} `json:"skipHeaderLineCount,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`

	// Treat empty as null. Type: boolean (or Expression with resultType boolean).
	TreatEmptyAsNull interface{} `json:"treatEmptyAsNull,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type AzureBlobFSSource.
func (a *AzureBlobFSSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     a.Type,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AzureBlobFSWriteSettings - Azure blobFS write settings.
type AzureBlobFSWriteSettings struct {
	// REQUIRED; The write setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Indicates the block size(MB) when writing data to blob. Type: integer (or Expression with resultType integer).
	BlockSizeInMB interface{} `json:"blockSizeInMB,omitempty"`

	// The type of copy behavior for copy sink.
	CopyBehavior interface{} `json:"copyBehavior,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
}

// GetStoreWriteSettings implements the StoreWriteSettingsClassification interface for type AzureBlobFSWriteSettings.
func (a *AzureBlobFSWriteSettings) GetStoreWriteSettings() *StoreWriteSettings {
	return &StoreWriteSettings{
		Type:                     a.Type,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		CopyBehavior:             a.CopyBehavior,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AzureBlobStorageLinkedService - The azure blob storage linked service.
type AzureBlobStorageLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure Blob Storage linked service properties.
	TypeProperties *AzureBlobStorageLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureBlobStorageLinkedService.
func (a *AzureBlobStorageLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureBlobStorageLinkedServiceTypeProperties - Azure Blob Storage linked service properties.
type AzureBlobStorageLinkedServiceTypeProperties struct {
	// The Azure key vault secret reference of accountKey in connection string.
	AccountKey *AzureKeyVaultSecretReference `json:"accountKey,omitempty"`

	// Specify the kind of your storage account. Allowed values are: Storage (general purpose v1), StorageV2 (general purpose
	// v2), BlobStorage, or BlockBlobStorage. Type: string (or Expression with
	// resultType string).
	AccountKind *string `json:"accountKind,omitempty"`

	// Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment,
	// AzureGermany. Default value is the data factory regions’ cloud type. Type:
	// string (or Expression with resultType string).
	AzureCloudType interface{} `json:"azureCloudType,omitempty"`

	// The connection string. It is mutually exclusive with sasUri, serviceEndpoint property. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`

	// The credential reference containing authentication information.
	Credential *CredentialReference `json:"credential,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential *string `json:"encryptedCredential,omitempty"`

	// The Azure key vault secret reference of sasToken in sas uri.
	SasToken *AzureKeyVaultSecretReference `json:"sasToken,omitempty"`

	// SAS URI of the Azure Blob Storage resource. It is mutually exclusive with connectionString, serviceEndpoint property. Type:
	// string, SecureString or AzureKeyVaultSecretReference.
	SasURI interface{} `json:"sasUri,omitempty"`

	// Blob service endpoint of the Azure Blob Storage resource. It is mutually exclusive with connectionString, sasUri property.
	ServiceEndpoint *string `json:"serviceEndpoint,omitempty"`

	// The ID of the service principal used to authenticate against Azure SQL Data Warehouse. Type: string (or Expression with
	// resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`

	// The key of the service principal used to authenticate against Azure SQL Data Warehouse.
	ServicePrincipalKey SecretBaseClassification `json:"servicePrincipalKey,omitempty"`

	// The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`
}

// AzureBlobStorageLocation - The location of azure blob dataset.
type AzureBlobStorageLocation struct {
	// REQUIRED; Type of dataset storage location.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Specify the container of azure blob. Type: string (or Expression with resultType string).
	Container interface{} `json:"container,omitempty"`

	// Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`

	// Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath interface{} `json:"folderPath,omitempty"`
}

// GetDatasetLocation implements the DatasetLocationClassification interface for type AzureBlobStorageLocation.
func (a *AzureBlobStorageLocation) GetDatasetLocation() *DatasetLocation {
	return &DatasetLocation{
		Type:                 a.Type,
		FolderPath:           a.FolderPath,
		FileName:             a.FileName,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureBlobStorageReadSettings - Azure blob read settings.
type AzureBlobStorageReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression
	// with resultType boolean).
	DeleteFilesAfterCompletion interface{} `json:"deleteFilesAfterCompletion,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// Indicates whether to enable partition discovery.
	EnablePartitionDiscovery *bool `json:"enablePartitionDiscovery,omitempty"`

	// Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy.
	// Type: string (or Expression with resultType string).
	FileListPath interface{} `json:"fileListPath,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd interface{} `json:"modifiedDatetimeEnd,omitempty"`

	// The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart interface{} `json:"modifiedDatetimeStart,omitempty"`

	// Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath interface{} `json:"partitionRootPath,omitempty"`

	// The prefix filter for the Azure Blob name. Type: string (or Expression with resultType string).
	Prefix interface{} `json:"prefix,omitempty"`

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive interface{} `json:"recursive,omitempty"`

	// Azure blob wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName interface{} `json:"wildcardFileName,omitempty"`

	// Azure blob wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath interface{} `json:"wildcardFolderPath,omitempty"`
}

// GetStoreReadSettings implements the StoreReadSettingsClassification interface for type AzureBlobStorageReadSettings.
func (a *AzureBlobStorageReadSettings) GetStoreReadSettings() *StoreReadSettings {
	return &StoreReadSettings{
		Type:                     a.Type,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AzureBlobStorageWriteSettings - Azure blob write settings.
type AzureBlobStorageWriteSettings struct {
	// REQUIRED; The write setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Indicates the block size(MB) when writing data to blob. Type: integer (or Expression with resultType integer).
	BlockSizeInMB interface{} `json:"blockSizeInMB,omitempty"`

	// The type of copy behavior for copy sink.
	CopyBehavior interface{} `json:"copyBehavior,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
}

// GetStoreWriteSettings implements the StoreWriteSettingsClassification interface for type AzureBlobStorageWriteSettings.
func (a *AzureBlobStorageWriteSettings) GetStoreWriteSettings() *StoreWriteSettings {
	return &StoreWriteSettings{
		Type:                     a.Type,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		CopyBehavior:             a.CopyBehavior,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AzureDataExplorerCommandActivity - Azure Data Explorer command activity.
type AzureDataExplorerCommandActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure Data Explorer command activity properties.
	TypeProperties *AzureDataExplorerCommandActivityTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type AzureDataExplorerCommandActivity.
func (a *AzureDataExplorerCommandActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 a.Name,
		Type:                 a.Type,
		Description:          a.Description,
		DependsOn:            a.DependsOn,
		UserProperties:       a.UserProperties,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type AzureDataExplorerCommandActivity.
func (a *AzureDataExplorerCommandActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		LinkedServiceName:    a.LinkedServiceName,
		Policy:               a.Policy,
		Name:                 a.Name,
		Type:                 a.Type,
		Description:          a.Description,
		DependsOn:            a.DependsOn,
		UserProperties:       a.UserProperties,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureDataExplorerCommandActivityTypeProperties - Azure Data Explorer command activity properties.
type AzureDataExplorerCommandActivityTypeProperties struct {
	// REQUIRED; A control command, according to the Azure Data Explorer command syntax. Type: string (or Expression with resultType
	// string).
	Command interface{} `json:"command,omitempty"`

	// Control command timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9]))..)
	CommandTimeout interface{} `json:"commandTimeout,omitempty"`
}

// AzureDataExplorerDatasetTypeProperties - Azure Data Explorer (Kusto) dataset properties.
type AzureDataExplorerDatasetTypeProperties struct {
	// The table name of the Azure Data Explorer database. Type: string (or Expression with resultType string).
	Table interface{} `json:"table,omitempty"`
}

// AzureDataExplorerLinkedService - Azure Data Explorer (Kusto) linked service.
type AzureDataExplorerLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure Data Explorer (Kusto) linked service properties.
	TypeProperties *AzureDataExplorerLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureDataExplorerLinkedService.
func (a *AzureDataExplorerLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureDataExplorerLinkedServiceTypeProperties - Azure Data Explorer (Kusto) linked service properties.
type AzureDataExplorerLinkedServiceTypeProperties struct {
	// REQUIRED; Database name for connection. Type: string (or Expression with resultType string).
	Database interface{} `json:"database,omitempty"`

	// REQUIRED; The endpoint of Azure Data Explorer (the engine's endpoint). URL will be in the format https://..kusto.windows.net.
	// Type: string (or Expression with resultType string)
	Endpoint interface{} `json:"endpoint,omitempty"`

	// The credential reference containing authentication information.
	Credential *CredentialReference `json:"credential,omitempty"`

	// The ID of the service principal used to authenticate against Azure Data Explorer. Type: string (or Expression with resultType
	// string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`

	// The key of the service principal used to authenticate against Kusto.
	ServicePrincipalKey SecretBaseClassification `json:"servicePrincipalKey,omitempty"`

	// The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`
}

// AzureDataExplorerSink - A copy activity Azure Data Explorer sink.
type AzureDataExplorerSink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// If set to true, any aggregation will be skipped. Default is false. Type: boolean.
	FlushImmediately interface{} `json:"flushImmediately,omitempty"`

	// An explicit column mapping description provided in a json format. Type: string.
	IngestionMappingAsJSON interface{} `json:"ingestionMappingAsJson,omitempty"`

	// A name of a pre-created csv mapping that was defined on the target Kusto table. Type: string.
	IngestionMappingName interface{} `json:"ingestionMappingName,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type AzureDataExplorerSink.
func (a *AzureDataExplorerSink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     a.Type,
		WriteBatchSize:           a.WriteBatchSize,
		WriteBatchTimeout:        a.WriteBatchTimeout,
		SinkRetryCount:           a.SinkRetryCount,
		SinkRetryWait:            a.SinkRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AzureDataExplorerSource - A copy activity Azure Data Explorer (Kusto) source.
type AzureDataExplorerSource struct {
	// REQUIRED; Database query. Should be a Kusto Query Language (KQL) query. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// The name of the Boolean option that controls whether truncation is applied to result-sets that go beyond a certain row-count
	// limit.
	NoTruncation interface{} `json:"noTruncation,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9]))..
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type AzureDataExplorerSource.
func (a *AzureDataExplorerSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     a.Type,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AzureDataExplorerTableDataset - The Azure Data Explorer (Kusto) dataset.
type AzureDataExplorerTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure Data Explorer (Kusto) dataset properties.
	TypeProperties *AzureDataExplorerDatasetTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type AzureDataExplorerTableDataset.
func (a *AzureDataExplorerTableDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 a.Type,
		Description:          a.Description,
		Structure:            a.Structure,
		Schema:               a.Schema,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		Folder:               a.Folder,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureDataLakeAnalyticsLinkedService - Azure Data Lake Analytics linked service.
type AzureDataLakeAnalyticsLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure Data Lake Analytics linked service properties.
	TypeProperties *AzureDataLakeAnalyticsLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureDataLakeAnalyticsLinkedService.
func (a *AzureDataLakeAnalyticsLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureDataLakeAnalyticsLinkedServiceTypeProperties - Azure Data Lake Analytics linked service properties.
type AzureDataLakeAnalyticsLinkedServiceTypeProperties struct {
	// REQUIRED; The Azure Data Lake Analytics account name. Type: string (or Expression with resultType string).
	AccountName interface{} `json:"accountName,omitempty"`

	// REQUIRED; The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType
	// string).
	Tenant interface{} `json:"tenant,omitempty"`

	// Azure Data Lake Analytics URI Type: string (or Expression with resultType string).
	DataLakeAnalyticsURI interface{} `json:"dataLakeAnalyticsUri,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// Data Lake Analytics account resource group name (if different from Data Factory account). Type: string (or Expression with
	// resultType string).
	ResourceGroupName interface{} `json:"resourceGroupName,omitempty"`

	// The ID of the application used to authenticate against the Azure Data Lake Analytics account. Type: string (or Expression
	// with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`

	// The Key of the application used to authenticate against the Azure Data Lake Analytics account.
	ServicePrincipalKey SecretBaseClassification `json:"servicePrincipalKey,omitempty"`

	// Data Lake Analytics account subscription ID (if different from Data Factory account). Type: string (or Expression with
	// resultType string).
	SubscriptionID interface{} `json:"subscriptionId,omitempty"`
}

// AzureDataLakeStoreDataset - Azure Data Lake Store dataset.
type AzureDataLakeStoreDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Azure Data Lake Store dataset properties.
	TypeProperties *AzureDataLakeStoreDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type AzureDataLakeStoreDataset.
func (a *AzureDataLakeStoreDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 a.Type,
		Description:          a.Description,
		Structure:            a.Structure,
		Schema:               a.Schema,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		Folder:               a.Folder,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureDataLakeStoreDatasetTypeProperties - Azure Data Lake Store dataset properties.
type AzureDataLakeStoreDatasetTypeProperties struct {
	// The data compression method used for the item(s) in the Azure Data Lake Store.
	Compression *DatasetCompression `json:"compression,omitempty"`

	// The name of the file in the Azure Data Lake Store. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`

	// Path to the folder in the Azure Data Lake Store. Type: string (or Expression with resultType string).
	FolderPath interface{} `json:"folderPath,omitempty"`

	// The format of the Data Lake Store.
	Format DatasetStorageFormatClassification `json:"format,omitempty"`
}

// AzureDataLakeStoreLinkedService - Azure Data Lake Store linked service.
type AzureDataLakeStoreLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure Data Lake Store linked service properties.
	TypeProperties *AzureDataLakeStoreLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureDataLakeStoreLinkedService.
func (a *AzureDataLakeStoreLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureDataLakeStoreLinkedServiceTypeProperties - Azure Data Lake Store linked service properties.
type AzureDataLakeStoreLinkedServiceTypeProperties struct {
	// REQUIRED; Data Lake Store service URI. Type: string (or Expression with resultType string).
	DataLakeStoreURI interface{} `json:"dataLakeStoreUri,omitempty"`

	// Data Lake Store account name. Type: string (or Expression with resultType string).
	AccountName interface{} `json:"accountName,omitempty"`

	// Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment,
	// AzureGermany. Default value is the data factory regions’ cloud type. Type:
	// string (or Expression with resultType string).
	AzureCloudType interface{} `json:"azureCloudType,omitempty"`

	// The credential reference containing authentication information.
	Credential *CredentialReference `json:"credential,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// Data Lake Store account resource group name (if different from Data Factory account). Type: string (or Expression with
	// resultType string).
	ResourceGroupName interface{} `json:"resourceGroupName,omitempty"`

	// The ID of the application used to authenticate against the Azure Data Lake Store account. Type: string (or Expression with
	// resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`

	// The Key of the application used to authenticate against the Azure Data Lake Store account.
	ServicePrincipalKey SecretBaseClassification `json:"servicePrincipalKey,omitempty"`

	// Data Lake Store account subscription ID (if different from Data Factory account). Type: string (or Expression with resultType
	// string).
	SubscriptionID interface{} `json:"subscriptionId,omitempty"`

	// The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`
}

// AzureDataLakeStoreLocation - The location of azure data lake store dataset.
type AzureDataLakeStoreLocation struct {
	// REQUIRED; Type of dataset storage location.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`

	// Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath interface{} `json:"folderPath,omitempty"`
}

// GetDatasetLocation implements the DatasetLocationClassification interface for type AzureDataLakeStoreLocation.
func (a *AzureDataLakeStoreLocation) GetDatasetLocation() *DatasetLocation {
	return &DatasetLocation{
		Type:                 a.Type,
		FolderPath:           a.FolderPath,
		FileName:             a.FileName,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureDataLakeStoreReadSettings - Azure data lake store read settings.
type AzureDataLakeStoreReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression
	// with resultType boolean).
	DeleteFilesAfterCompletion interface{} `json:"deleteFilesAfterCompletion,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// Indicates whether to enable partition discovery.
	EnablePartitionDiscovery *bool `json:"enablePartitionDiscovery,omitempty"`

	// Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy.
	// Type: string (or Expression with resultType string).
	FileListPath interface{} `json:"fileListPath,omitempty"`

	// Lists files after the value (exclusive) based on file/folder names’ lexicographical order. Applies under the folderPath
	// in data set, and filter files/sub-folders under the folderPath. Type: string (or
	// Expression with resultType string).
	ListAfter interface{} `json:"listAfter,omitempty"`

	// Lists files before the value (inclusive) based on file/folder names’ lexicographical order. Applies under the folderPath
	// in data set, and filter files/sub-folders under the folderPath. Type: string
	// (or Expression with resultType string).
	ListBefore interface{} `json:"listBefore,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd interface{} `json:"modifiedDatetimeEnd,omitempty"`

	// The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart interface{} `json:"modifiedDatetimeStart,omitempty"`

	// Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath interface{} `json:"partitionRootPath,omitempty"`

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive interface{} `json:"recursive,omitempty"`

	// ADLS wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName interface{} `json:"wildcardFileName,omitempty"`

	// ADLS wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath interface{} `json:"wildcardFolderPath,omitempty"`
}

// GetStoreReadSettings implements the StoreReadSettingsClassification interface for type AzureDataLakeStoreReadSettings.
func (a *AzureDataLakeStoreReadSettings) GetStoreReadSettings() *StoreReadSettings {
	return &StoreReadSettings{
		Type:                     a.Type,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AzureDataLakeStoreSink - A copy activity Azure Data Lake Store sink.
type AzureDataLakeStoreSink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// The type of copy behavior for copy sink.
	CopyBehavior interface{} `json:"copyBehavior,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// Single File Parallel.
	EnableAdlsSingleFileParallel interface{} `json:"enableAdlsSingleFileParallel,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type AzureDataLakeStoreSink.
func (a *AzureDataLakeStoreSink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     a.Type,
		WriteBatchSize:           a.WriteBatchSize,
		WriteBatchTimeout:        a.WriteBatchTimeout,
		SinkRetryCount:           a.SinkRetryCount,
		SinkRetryWait:            a.SinkRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AzureDataLakeStoreSource - A copy activity Azure Data Lake source.
type AzureDataLakeStoreSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive interface{} `json:"recursive,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type AzureDataLakeStoreSource.
func (a *AzureDataLakeStoreSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     a.Type,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AzureDataLakeStoreWriteSettings - Azure data lake store write settings.
type AzureDataLakeStoreWriteSettings struct {
	// REQUIRED; The write setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// The type of copy behavior for copy sink.
	CopyBehavior interface{} `json:"copyBehavior,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// Specifies the expiry time of the written files. The time is applied to the UTC time zone in the format of "2018-12-01T05:00:00Z".
	// Default value is NULL. Type: integer (or Expression with resultType
	// integer).
	ExpiryDateTime interface{} `json:"expiryDateTime,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
}

// GetStoreWriteSettings implements the StoreWriteSettingsClassification interface for type AzureDataLakeStoreWriteSettings.
func (a *AzureDataLakeStoreWriteSettings) GetStoreWriteSettings() *StoreWriteSettings {
	return &StoreWriteSettings{
		Type:                     a.Type,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		CopyBehavior:             a.CopyBehavior,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AzureDatabricksDeltaLakeDataset - Azure Databricks Delta Lake dataset.
type AzureDatabricksDeltaLakeDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Properties specific to this dataset type.
	TypeProperties *AzureDatabricksDeltaLakeDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type AzureDatabricksDeltaLakeDataset.
func (a *AzureDatabricksDeltaLakeDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 a.Type,
		Description:          a.Description,
		Structure:            a.Structure,
		Schema:               a.Schema,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		Folder:               a.Folder,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureDatabricksDeltaLakeDatasetTypeProperties - Azure Databricks Delta Lake Dataset Properties
type AzureDatabricksDeltaLakeDatasetTypeProperties struct {
	// The database name of delta table. Type: string (or Expression with resultType string).
	Database interface{} `json:"database,omitempty"`

	// The name of delta table. Type: string (or Expression with resultType string).
	Table interface{} `json:"table,omitempty"`
}

// AzureDatabricksDeltaLakeExportCommand - Azure Databricks Delta Lake export command settings.
type AzureDatabricksDeltaLakeExportCommand struct {
	// REQUIRED; The export setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Specify the date format for the csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string).
	DateFormat interface{} `json:"dateFormat,omitempty"`

	// Specify the timestamp format for the csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType
	// string).
	TimestampFormat interface{} `json:"timestampFormat,omitempty"`
}

// GetExportSettings implements the ExportSettingsClassification interface for type AzureDatabricksDeltaLakeExportCommand.
func (a *AzureDatabricksDeltaLakeExportCommand) GetExportSettings() *ExportSettings {
	return &ExportSettings{
		Type:                 a.Type,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureDatabricksDeltaLakeImportCommand - Azure Databricks Delta Lake import command settings.
type AzureDatabricksDeltaLakeImportCommand struct {
	// REQUIRED; The import setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Specify the date format for csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string).
	DateFormat interface{} `json:"dateFormat,omitempty"`

	// Specify the timestamp format for csv in Azure Databricks Delta Lake Copy. Type: string (or Expression with resultType string).
	TimestampFormat interface{} `json:"timestampFormat,omitempty"`
}

// GetImportSettings implements the ImportSettingsClassification interface for type AzureDatabricksDeltaLakeImportCommand.
func (a *AzureDatabricksDeltaLakeImportCommand) GetImportSettings() *ImportSettings {
	return &ImportSettings{
		Type:                 a.Type,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureDatabricksDeltaLakeLinkedService - Azure Databricks Delta Lake linked service.
type AzureDatabricksDeltaLakeLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure Databricks Delta Lake linked service properties.
	TypeProperties *AzureDatabricksDetltaLakeLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureDatabricksDeltaLakeLinkedService.
func (a *AzureDatabricksDeltaLakeLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureDatabricksDeltaLakeSink - A copy activity Azure Databricks Delta Lake sink.
type AzureDatabricksDeltaLakeSink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// Azure Databricks Delta Lake import settings.
	ImportSettings *AzureDatabricksDeltaLakeImportCommand `json:"importSettings,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// SQL pre-copy script. Type: string (or Expression with resultType string).
	PreCopyScript interface{} `json:"preCopyScript,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type AzureDatabricksDeltaLakeSink.
func (a *AzureDatabricksDeltaLakeSink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     a.Type,
		WriteBatchSize:           a.WriteBatchSize,
		WriteBatchTimeout:        a.WriteBatchTimeout,
		SinkRetryCount:           a.SinkRetryCount,
		SinkRetryWait:            a.SinkRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AzureDatabricksDeltaLakeSource - A copy activity Azure Databricks Delta Lake source.
type AzureDatabricksDeltaLakeSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// Azure Databricks Delta Lake export settings.
	ExportSettings *AzureDatabricksDeltaLakeExportCommand `json:"exportSettings,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Azure Databricks Delta Lake Sql query. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type AzureDatabricksDeltaLakeSource.
func (a *AzureDatabricksDeltaLakeSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     a.Type,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AzureDatabricksDetltaLakeLinkedServiceTypeProperties - Azure Databricks Delta Lake linked service properties.
type AzureDatabricksDetltaLakeLinkedServiceTypeProperties struct {
	// REQUIRED; .azuredatabricks.net, domain name of your Databricks deployment. Type: string (or Expression with resultType
	// string).
	Domain interface{} `json:"domain,omitempty"`

	// Access token for databricks REST API. Refer to https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string,
	// SecureString or AzureKeyVaultSecretReference.
	AccessToken SecretBaseClassification `json:"accessToken,omitempty"`

	// The id of an existing interactive cluster that will be used for all runs of this job. Type: string (or Expression with
	// resultType string).
	ClusterID interface{} `json:"clusterId,omitempty"`

	// The credential reference containing authentication information.
	Credential *CredentialReference `json:"credential,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// Workspace resource id for databricks REST API. Type: string (or Expression with resultType string).
	WorkspaceResourceID interface{} `json:"workspaceResourceId,omitempty"`
}

// AzureDatabricksLinkedService - Azure Databricks linked service.
type AzureDatabricksLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure Databricks linked service properties.
	TypeProperties *AzureDatabricksLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureDatabricksLinkedService.
func (a *AzureDatabricksLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureDatabricksLinkedServiceTypeProperties - Azure Databricks linked service properties.
type AzureDatabricksLinkedServiceTypeProperties struct {
	// REQUIRED; .azuredatabricks.net, domain name of your Databricks deployment. Type: string (or Expression with resultType
	// string).
	Domain interface{} `json:"domain,omitempty"`

	// Access token for databricks REST API. Refer to https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string
	// (or Expression with resultType string).
	AccessToken SecretBaseClassification `json:"accessToken,omitempty"`

	// Required to specify MSI, if using Workspace resource id for databricks REST API. Type: string (or Expression with resultType
	// string).
	Authentication interface{} `json:"authentication,omitempty"`

	// The credential reference containing authentication information.
	Credential *CredentialReference `json:"credential,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The id of an existing interactive cluster that will be used for all runs of this activity. Type: string (or Expression
	// with resultType string).
	ExistingClusterID interface{} `json:"existingClusterId,omitempty"`

	// The id of an existing instance pool that will be used for all runs of this activity. Type: string (or Expression with resultType
	// string).
	InstancePoolID interface{} `json:"instancePoolId,omitempty"`

	// Additional tags for cluster resources. This property is ignored in instance pool configurations.
	NewClusterCustomTags map[string]interface{} `json:"newClusterCustomTags,omitempty"`

	// The driver node type for the new job cluster. This property is ignored in instance pool configurations. Type: string (or
	// Expression with resultType string).
	NewClusterDriverNodeType interface{} `json:"newClusterDriverNodeType,omitempty"`

	// Enable the elastic disk on the new cluster. This property is now ignored, and takes the default elastic disk behavior in
	// Databricks (elastic disks are always enabled). Type: boolean (or Expression
	// with resultType boolean).
	NewClusterEnableElasticDisk interface{} `json:"newClusterEnableElasticDisk,omitempty"`

	// User-defined initialization scripts for the new cluster. Type: array of strings (or Expression with resultType array of
	// strings).
	NewClusterInitScripts interface{} `json:"newClusterInitScripts,omitempty"`

	// Specify a location to deliver Spark driver, worker, and event logs. Type: string (or Expression with resultType string).
	NewClusterLogDestination interface{} `json:"newClusterLogDestination,omitempty"`

	// The node type of the new job cluster. This property is required if newClusterVersion is specified and instancePoolId is
	// not specified. If instancePoolId is specified, this property is ignored. Type:
	// string (or Expression with resultType string).
	NewClusterNodeType interface{} `json:"newClusterNodeType,omitempty"`

	// If not using an existing interactive cluster, this specifies the number of worker nodes to use for the new job cluster
	// or instance pool. For new job clusters, this a string-formatted Int32, like '1'
	// means numOfWorker is 1 or '1:10' means auto-scale from 1 (min) to 10 (max). For instance pools, this is a string-formatted
	// Int32, and can only specify a fixed number of worker nodes, such as '2'.
	// Required if newClusterVersion is specified. Type: string (or Expression with resultType string).
	NewClusterNumOfWorker interface{} `json:"newClusterNumOfWorker,omitempty"`

	// A set of optional, user-specified Spark configuration key-value pairs.
	NewClusterSparkConf map[string]interface{} `json:"newClusterSparkConf,omitempty"`

	// A set of optional, user-specified Spark environment variables key-value pairs.
	NewClusterSparkEnvVars map[string]interface{} `json:"newClusterSparkEnvVars,omitempty"`

	// If not using an existing interactive cluster, this specifies the Spark version of a new job cluster or instance pool nodes
	// created for each run of this activity. Required if instancePoolId is
	// specified. Type: string (or Expression with resultType string).
	NewClusterVersion interface{} `json:"newClusterVersion,omitempty"`

	// The policy id for limiting the ability to configure clusters based on a user defined set of rules. Type: string (or Expression
	// with resultType string).
	PolicyID interface{} `json:"policyId,omitempty"`

	// Workspace resource id for databricks REST API. Type: string (or Expression with resultType string).
	WorkspaceResourceID interface{} `json:"workspaceResourceId,omitempty"`
}

// AzureFileStorageLinkedService - Azure File Storage linked service.
type AzureFileStorageLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure File Storage linked service properties.
	TypeProperties *AzureFileStorageLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureFileStorageLinkedService.
func (a *AzureFileStorageLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureFileStorageLinkedServiceTypeProperties - Azure File Storage linked service properties.
type AzureFileStorageLinkedServiceTypeProperties struct {
	// The Azure key vault secret reference of accountKey in connection string.
	AccountKey *AzureKeyVaultSecretReference `json:"accountKey,omitempty"`

	// The connection string. It is mutually exclusive with sasUri property. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The azure file share name. It is required when auth with accountKey/sasToken. Type: string (or Expression with resultType
	// string).
	FileShare interface{} `json:"fileShare,omitempty"`

	// Host name of the server. Type: string (or Expression with resultType string).
	Host interface{} `json:"host,omitempty"`

	// Password to logon the server.
	Password SecretBaseClassification `json:"password,omitempty"`

	// The Azure key vault secret reference of sasToken in sas uri.
	SasToken *AzureKeyVaultSecretReference `json:"sasToken,omitempty"`

	// SAS URI of the Azure File resource. It is mutually exclusive with connectionString property. Type: string, SecureString
	// or AzureKeyVaultSecretReference.
	SasURI interface{} `json:"sasUri,omitempty"`

	// The azure file share snapshot version. Type: string (or Expression with resultType string).
	Snapshot interface{} `json:"snapshot,omitempty"`

	// User ID to logon the server. Type: string (or Expression with resultType string).
	UserID interface{} `json:"userId,omitempty"`
}

// AzureFileStorageLocation - The location of file server dataset.
type AzureFileStorageLocation struct {
	// REQUIRED; Type of dataset storage location.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`

	// Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath interface{} `json:"folderPath,omitempty"`
}

// GetDatasetLocation implements the DatasetLocationClassification interface for type AzureFileStorageLocation.
func (a *AzureFileStorageLocation) GetDatasetLocation() *DatasetLocation {
	return &DatasetLocation{
		Type:                 a.Type,
		FolderPath:           a.FolderPath,
		FileName:             a.FileName,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureFileStorageReadSettings - Azure File Storage read settings.
type AzureFileStorageReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression
	// with resultType boolean).
	DeleteFilesAfterCompletion interface{} `json:"deleteFilesAfterCompletion,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// Indicates whether to enable partition discovery.
	EnablePartitionDiscovery *bool `json:"enablePartitionDiscovery,omitempty"`

	// Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy.
	// Type: string (or Expression with resultType string).
	FileListPath interface{} `json:"fileListPath,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd interface{} `json:"modifiedDatetimeEnd,omitempty"`

	// The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart interface{} `json:"modifiedDatetimeStart,omitempty"`

	// Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath interface{} `json:"partitionRootPath,omitempty"`

	// The prefix filter for the Azure File name starting from root path. Type: string (or Expression with resultType string).
	Prefix interface{} `json:"prefix,omitempty"`

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive interface{} `json:"recursive,omitempty"`

	// Azure File Storage wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName interface{} `json:"wildcardFileName,omitempty"`

	// Azure File Storage wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath interface{} `json:"wildcardFolderPath,omitempty"`
}

// GetStoreReadSettings implements the StoreReadSettingsClassification interface for type AzureFileStorageReadSettings.
func (a *AzureFileStorageReadSettings) GetStoreReadSettings() *StoreReadSettings {
	return &StoreReadSettings{
		Type:                     a.Type,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AzureFileStorageWriteSettings - Azure File Storage write settings.
type AzureFileStorageWriteSettings struct {
	// REQUIRED; The write setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// The type of copy behavior for copy sink.
	CopyBehavior interface{} `json:"copyBehavior,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
}

// GetStoreWriteSettings implements the StoreWriteSettingsClassification interface for type AzureFileStorageWriteSettings.
func (a *AzureFileStorageWriteSettings) GetStoreWriteSettings() *StoreWriteSettings {
	return &StoreWriteSettings{
		Type:                     a.Type,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		CopyBehavior:             a.CopyBehavior,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AzureFunctionActivity - Azure Function activity.
type AzureFunctionActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure Function activity properties.
	TypeProperties *AzureFunctionActivityTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type AzureFunctionActivity.
func (a *AzureFunctionActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 a.Name,
		Type:                 a.Type,
		Description:          a.Description,
		DependsOn:            a.DependsOn,
		UserProperties:       a.UserProperties,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type AzureFunctionActivity.
func (a *AzureFunctionActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		LinkedServiceName:    a.LinkedServiceName,
		Policy:               a.Policy,
		Name:                 a.Name,
		Type:                 a.Type,
		Description:          a.Description,
		DependsOn:            a.DependsOn,
		UserProperties:       a.UserProperties,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureFunctionActivityTypeProperties - Azure Function activity type properties.
type AzureFunctionActivityTypeProperties struct {
	// REQUIRED; Name of the Function that the Azure Function Activity will call. Type: string (or Expression with resultType
	// string)
	FunctionName interface{} `json:"functionName,omitempty"`

	// REQUIRED; Rest API method for target endpoint.
	Method *AzureFunctionActivityMethod `json:"method,omitempty"`

	// Represents the payload that will be sent to the endpoint. Required for POST/PUT method, not allowed for GET method Type:
	// string (or Expression with resultType string).
	Body interface{} `json:"body,omitempty"`

	// Represents the headers that will be sent to the request. For example, to set the language and type on a request: "headers"
	// : { "Accept-Language": "en-us", "Content-Type": "application/json" }. Type:
	// string (or Expression with resultType string).
	Headers interface{} `json:"headers,omitempty"`
}

// AzureFunctionLinkedService - Azure Function linked service.
type AzureFunctionLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure Function linked service properties.
	TypeProperties *AzureFunctionLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureFunctionLinkedService.
func (a *AzureFunctionLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureFunctionLinkedServiceTypeProperties - Azure Function linked service properties.
type AzureFunctionLinkedServiceTypeProperties struct {
	// REQUIRED; The endpoint of the Azure Function App. URL will be in the format https://.azurewebsites.net.
	FunctionAppURL interface{} `json:"functionAppUrl,omitempty"`

	// Type of authentication (Required to specify MSI) used to connect to AzureFunction. Type: string (or Expression with resultType
	// string).
	Authentication interface{} `json:"authentication,omitempty"`

	// The credential reference containing authentication information.
	Credential *CredentialReference `json:"credential,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// Function or Host key for Azure Function App.
	FunctionKey SecretBaseClassification `json:"functionKey,omitempty"`

	// Allowed token audiences for azure function.
	ResourceID interface{} `json:"resourceId,omitempty"`
}

// AzureKeyVaultLinkedService - Azure Key Vault linked service.
type AzureKeyVaultLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure Key Vault linked service properties.
	TypeProperties *AzureKeyVaultLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureKeyVaultLinkedService.
func (a *AzureKeyVaultLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureKeyVaultLinkedServiceTypeProperties - Azure Key Vault linked service properties.
type AzureKeyVaultLinkedServiceTypeProperties struct {
	// REQUIRED; The base URL of the Azure Key Vault. e.g. https://myakv.vault.azure.net Type: string (or Expression with resultType
	// string).
	BaseURL interface{} `json:"baseUrl,omitempty"`

	// The credential reference containing authentication information.
	Credential *CredentialReference `json:"credential,omitempty"`
}

// AzureKeyVaultSecretReference - Azure Key Vault secret reference.
type AzureKeyVaultSecretReference struct {
	// REQUIRED; The name of the secret in Azure Key Vault. Type: string (or Expression with resultType string).
	SecretName interface{} `json:"secretName,omitempty"`

	// REQUIRED; The Azure Key Vault linked service reference.
	Store *LinkedServiceReference `json:"store,omitempty"`

	// REQUIRED; Type of the secret.
	Type *string `json:"type,omitempty"`

	// The version of the secret in Azure Key Vault. The default value is the latest version of the secret. Type: string (or Expression
	// with resultType string).
	SecretVersion interface{} `json:"secretVersion,omitempty"`
}

// GetSecretBase implements the SecretBaseClassification interface for type AzureKeyVaultSecretReference.
func (a *AzureKeyVaultSecretReference) GetSecretBase() *SecretBase {
	return &SecretBase{
		Type: a.Type,
	}
}

// AzureMLBatchExecutionActivity - Azure ML Batch Execution activity.
type AzureMLBatchExecutionActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure ML Batch Execution activity properties.
	TypeProperties *AzureMLBatchExecutionActivityTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type AzureMLBatchExecutionActivity.
func (a *AzureMLBatchExecutionActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 a.Name,
		Type:                 a.Type,
		Description:          a.Description,
		DependsOn:            a.DependsOn,
		UserProperties:       a.UserProperties,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type AzureMLBatchExecutionActivity.
func (a *AzureMLBatchExecutionActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		LinkedServiceName:    a.LinkedServiceName,
		Policy:               a.Policy,
		Name:                 a.Name,
		Type:                 a.Type,
		Description:          a.Description,
		DependsOn:            a.DependsOn,
		UserProperties:       a.UserProperties,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureMLBatchExecutionActivityTypeProperties - Azure ML Batch Execution activity properties.
type AzureMLBatchExecutionActivityTypeProperties struct {
	// Key,Value pairs to be passed to the Azure ML Batch Execution Service endpoint. Keys must match the names of web service
	// parameters defined in the published Azure ML web service. Values will be passed
	// in the GlobalParameters property of the Azure ML batch execution request.
	GlobalParameters map[string]interface{} `json:"globalParameters,omitempty"`

	// Key,Value pairs, mapping the names of Azure ML endpoint's Web Service Inputs to AzureMLWebServiceFile objects specifying
	// the input Blob locations.. This information will be passed in the
	// WebServiceInputs property of the Azure ML batch execution request.
	WebServiceInputs map[string]*AzureMLWebServiceFile `json:"webServiceInputs,omitempty"`

	// Key,Value pairs, mapping the names of Azure ML endpoint's Web Service Outputs to AzureMLWebServiceFile objects specifying
	// the output Blob locations. This information will be passed in the
	// WebServiceOutputs property of the Azure ML batch execution request.
	WebServiceOutputs map[string]*AzureMLWebServiceFile `json:"webServiceOutputs,omitempty"`
}

// AzureMLExecutePipelineActivity - Azure ML Execute Pipeline activity.
type AzureMLExecutePipelineActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure ML Execute Pipeline activity properties.
	TypeProperties *AzureMLExecutePipelineActivityTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type AzureMLExecutePipelineActivity.
func (a *AzureMLExecutePipelineActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 a.Name,
		Type:                 a.Type,
		Description:          a.Description,
		DependsOn:            a.DependsOn,
		UserProperties:       a.UserProperties,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type AzureMLExecutePipelineActivity.
func (a *AzureMLExecutePipelineActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		LinkedServiceName:    a.LinkedServiceName,
		Policy:               a.Policy,
		Name:                 a.Name,
		Type:                 a.Type,
		Description:          a.Description,
		DependsOn:            a.DependsOn,
		UserProperties:       a.UserProperties,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureMLExecutePipelineActivityTypeProperties - Azure ML Execute Pipeline activity properties.
type AzureMLExecutePipelineActivityTypeProperties struct {
	// Whether to continue execution of other steps in the PipelineRun if a step fails. This information will be passed in the
	// continueOnStepFailure property of the published pipeline execution request.
	// Type: boolean (or Expression with resultType boolean).
	ContinueOnStepFailure interface{} `json:"continueOnStepFailure,omitempty"`

	// Dictionary used for changing data path assignments without retraining. Values will be passed in the dataPathAssignments
	// property of the published pipeline execution request. Type: object with key
	// value pairs (or Expression with resultType object).
	DataPathAssignments interface{} `json:"dataPathAssignments,omitempty"`

	// Run history experiment name of the pipeline run. This information will be passed in the ExperimentName property of the
	// published pipeline execution request. Type: string (or Expression with resultType
	// string).
	ExperimentName interface{} `json:"experimentName,omitempty"`

	// The parent Azure ML Service pipeline run id. This information will be passed in the ParentRunId property of the published
	// pipeline execution request. Type: string (or Expression with resultType
	// string).
	MlParentRunID interface{} `json:"mlParentRunId,omitempty"`

	// ID of the published Azure ML pipeline endpoint. Type: string (or Expression with resultType string).
	MlPipelineEndpointID interface{} `json:"mlPipelineEndpointId,omitempty"`

	// ID of the published Azure ML pipeline. Type: string (or Expression with resultType string).
	MlPipelineID interface{} `json:"mlPipelineId,omitempty"`

	// Key,Value pairs to be passed to the published Azure ML pipeline endpoint. Keys must match the names of pipeline parameters
	// defined in the published pipeline. Values will be passed in the
	// ParameterAssignments property of the published pipeline execution request. Type: object with key value pairs (or Expression
	// with resultType object).
	MlPipelineParameters interface{} `json:"mlPipelineParameters,omitempty"`

	// Version of the published Azure ML pipeline endpoint. Type: string (or Expression with resultType string).
	Version interface{} `json:"version,omitempty"`
}

// AzureMLLinkedService - Azure ML Studio Web Service linked service.
type AzureMLLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure ML Studio Web Service linked service properties.
	TypeProperties *AzureMLLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureMLLinkedService.
func (a *AzureMLLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureMLLinkedServiceTypeProperties - Azure ML Studio Web Service linked service properties.
type AzureMLLinkedServiceTypeProperties struct {
	// REQUIRED; The API key for accessing the Azure ML model endpoint.
	APIKey SecretBaseClassification `json:"apiKey,omitempty"`

	// REQUIRED; The Batch Execution REST URL for an Azure ML Studio Web Service endpoint. Type: string (or Expression with resultType
	// string).
	MlEndpoint interface{} `json:"mlEndpoint,omitempty"`

	// Type of authentication (Required to specify MSI) used to connect to AzureML. Type: string (or Expression with resultType
	// string).
	Authentication interface{} `json:"authentication,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The ID of the service principal used to authenticate against the ARM-based updateResourceEndpoint of an Azure ML Studio
	// web service. Type: string (or Expression with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`

	// The key of the service principal used to authenticate against the ARM-based updateResourceEndpoint of an Azure ML Studio
	// web service.
	ServicePrincipalKey SecretBaseClassification `json:"servicePrincipalKey,omitempty"`

	// The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`

	// The Update Resource REST URL for an Azure ML Studio Web Service endpoint. Type: string (or Expression with resultType string).
	UpdateResourceEndpoint interface{} `json:"updateResourceEndpoint,omitempty"`
}

// AzureMLServiceLinkedService - Azure ML Service linked service.
type AzureMLServiceLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure ML Service linked service properties.
	TypeProperties *AzureMLServiceLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureMLServiceLinkedService.
func (a *AzureMLServiceLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureMLServiceLinkedServiceTypeProperties - Azure ML Service linked service properties.
type AzureMLServiceLinkedServiceTypeProperties struct {
	// REQUIRED; Azure ML Service workspace name. Type: string (or Expression with resultType string).
	MlWorkspaceName interface{} `json:"mlWorkspaceName,omitempty"`

	// REQUIRED; Azure ML Service workspace resource group name. Type: string (or Expression with resultType string).
	ResourceGroupName interface{} `json:"resourceGroupName,omitempty"`

	// REQUIRED; Azure ML Service workspace subscription ID. Type: string (or Expression with resultType string).
	SubscriptionID interface{} `json:"subscriptionId,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The ID of the service principal used to authenticate against the endpoint of a published Azure ML Service pipeline. Type:
	// string (or Expression with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`

	// The key of the service principal used to authenticate against the endpoint of a published Azure ML Service pipeline.
	ServicePrincipalKey SecretBaseClassification `json:"servicePrincipalKey,omitempty"`

	// The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`
}

// AzureMLUpdateResourceActivity - Azure ML Update Resource management activity.
type AzureMLUpdateResourceActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure ML Update Resource management activity properties.
	TypeProperties *AzureMLUpdateResourceActivityTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type AzureMLUpdateResourceActivity.
func (a *AzureMLUpdateResourceActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 a.Name,
		Type:                 a.Type,
		Description:          a.Description,
		DependsOn:            a.DependsOn,
		UserProperties:       a.UserProperties,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type AzureMLUpdateResourceActivity.
func (a *AzureMLUpdateResourceActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		LinkedServiceName:    a.LinkedServiceName,
		Policy:               a.Policy,
		Name:                 a.Name,
		Type:                 a.Type,
		Description:          a.Description,
		DependsOn:            a.DependsOn,
		UserProperties:       a.UserProperties,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureMLUpdateResourceActivityTypeProperties - Azure ML Update Resource activity properties.
type AzureMLUpdateResourceActivityTypeProperties struct {
	// REQUIRED; The relative file path in trainedModelLinkedService to represent the .ilearner file that will be uploaded by
	// the update operation. Type: string (or Expression with resultType string).
	TrainedModelFilePath interface{} `json:"trainedModelFilePath,omitempty"`

	// REQUIRED; Name of Azure Storage linked service holding the .ilearner file that will be uploaded by the update operation.
	TrainedModelLinkedServiceName *LinkedServiceReference `json:"trainedModelLinkedServiceName,omitempty"`

	// REQUIRED; Name of the Trained Model module in the Web Service experiment to be updated. Type: string (or Expression with
	// resultType string).
	TrainedModelName interface{} `json:"trainedModelName,omitempty"`
}

// AzureMLWebServiceFile - Azure ML WebService Input/Output file
type AzureMLWebServiceFile struct {
	// REQUIRED; The relative file path, including container name, in the Azure Blob Storage specified by the LinkedService. Type:
	// string (or Expression with resultType string).
	FilePath interface{} `json:"filePath,omitempty"`

	// REQUIRED; Reference to an Azure Storage LinkedService, where Azure ML WebService Input/Output file located.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`
}

// AzureMariaDBLinkedService - Azure Database for MariaDB linked service.
type AzureMariaDBLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure Database for MariaDB linked service properties.
	TypeProperties *AzureMariaDBLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureMariaDBLinkedService.
func (a *AzureMariaDBLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureMariaDBLinkedServiceTypeProperties - Azure Database for MariaDB linked service properties.
type AzureMariaDBLinkedServiceTypeProperties struct {
	// An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The Azure key vault secret reference of password in connection string.
	Pwd *AzureKeyVaultSecretReference `json:"pwd,omitempty"`
}

// AzureMariaDBSource - A copy activity Azure MariaDB source.
type AzureMariaDBSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type AzureMariaDBSource.
func (a *AzureMariaDBSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     a.Type,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type AzureMariaDBSource.
func (a *AzureMariaDBSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             a.QueryTimeout,
		AdditionalColumns:        a.AdditionalColumns,
		Type:                     a.Type,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AzureMariaDBTableDataset - Azure Database for MariaDB dataset.
type AzureMariaDBTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type AzureMariaDBTableDataset.
func (a *AzureMariaDBTableDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 a.Type,
		Description:          a.Description,
		Structure:            a.Structure,
		Schema:               a.Schema,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		Folder:               a.Folder,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureMySQLLinkedService - Azure MySQL database linked service.
type AzureMySQLLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure MySQL database linked service properties.
	TypeProperties *AzureMySQLLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureMySQLLinkedService.
func (a *AzureMySQLLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureMySQLLinkedServiceTypeProperties - Azure MySQL database linked service properties.
type AzureMySQLLinkedServiceTypeProperties struct {
	// REQUIRED; The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The Azure key vault secret reference of password in connection string.
	Password *AzureKeyVaultSecretReference `json:"password,omitempty"`
}

// AzureMySQLSink - A copy activity Azure MySql sink.
type AzureMySQLSink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to execute before starting the copy. Type: string (or Expression with resultType string).
	PreCopyScript interface{} `json:"preCopyScript,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type AzureMySQLSink.
func (a *AzureMySQLSink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     a.Type,
		WriteBatchSize:           a.WriteBatchSize,
		WriteBatchTimeout:        a.WriteBatchTimeout,
		SinkRetryCount:           a.SinkRetryCount,
		SinkRetryWait:            a.SinkRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AzureMySQLSource - A copy activity Azure MySQL source.
type AzureMySQLSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Database query. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type AzureMySQLSource.
func (a *AzureMySQLSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     a.Type,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type AzureMySQLSource.
func (a *AzureMySQLSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             a.QueryTimeout,
		AdditionalColumns:        a.AdditionalColumns,
		Type:                     a.Type,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AzureMySQLTableDataset - The Azure MySQL database dataset.
type AzureMySQLTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure MySQL database dataset properties.
	TypeProperties *AzureMySQLTableDatasetTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type AzureMySQLTableDataset.
func (a *AzureMySQLTableDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 a.Type,
		Description:          a.Description,
		Structure:            a.Structure,
		Schema:               a.Schema,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		Folder:               a.Folder,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureMySQLTableDatasetTypeProperties - Azure MySQL database dataset properties.
type AzureMySQLTableDatasetTypeProperties struct {
	// The name of Azure MySQL database table. Type: string (or Expression with resultType string).
	Table interface{} `json:"table,omitempty"`

	// The Azure MySQL database table name. Type: string (or Expression with resultType string).
	TableName interface{} `json:"tableName,omitempty"`
}

// AzurePostgreSQLLinkedService - Azure PostgreSQL linked service.
type AzurePostgreSQLLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure PostgreSQL linked service properties.
	TypeProperties *AzurePostgreSQLLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzurePostgreSQLLinkedService.
func (a *AzurePostgreSQLLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzurePostgreSQLLinkedServiceTypeProperties - Azure PostgreSQL linked service properties.
type AzurePostgreSQLLinkedServiceTypeProperties struct {
	// An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The Azure key vault secret reference of password in connection string.
	Password *AzureKeyVaultSecretReference `json:"password,omitempty"`
}

// AzurePostgreSQLSink - A copy activity Azure PostgreSQL sink.
type AzurePostgreSQLSink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to execute before starting the copy. Type: string (or Expression with resultType string).
	PreCopyScript interface{} `json:"preCopyScript,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type AzurePostgreSQLSink.
func (a *AzurePostgreSQLSink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     a.Type,
		WriteBatchSize:           a.WriteBatchSize,
		WriteBatchTimeout:        a.WriteBatchTimeout,
		SinkRetryCount:           a.SinkRetryCount,
		SinkRetryWait:            a.SinkRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AzurePostgreSQLSource - A copy activity Azure PostgreSQL source.
type AzurePostgreSQLSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type AzurePostgreSQLSource.
func (a *AzurePostgreSQLSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     a.Type,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type AzurePostgreSQLSource.
func (a *AzurePostgreSQLSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             a.QueryTimeout,
		AdditionalColumns:        a.AdditionalColumns,
		Type:                     a.Type,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AzurePostgreSQLTableDataset - Azure PostgreSQL dataset.
type AzurePostgreSQLTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Properties specific to this dataset type.
	TypeProperties *AzurePostgreSQLTableDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type AzurePostgreSQLTableDataset.
func (a *AzurePostgreSQLTableDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 a.Type,
		Description:          a.Description,
		Structure:            a.Structure,
		Schema:               a.Schema,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		Folder:               a.Folder,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzurePostgreSQLTableDatasetTypeProperties - Azure PostgreSQL dataset properties.
type AzurePostgreSQLTableDatasetTypeProperties struct {
	// The schema name of the Azure PostgreSQL database. Type: string (or Expression with resultType string).
	Schema interface{} `json:"schema,omitempty"`

	// The table name of the Azure PostgreSQL database. Type: string (or Expression with resultType string).
	Table interface{} `json:"table,omitempty"`

	// The table name of the Azure PostgreSQL database which includes both schema and table. Type: string (or Expression with
	// resultType string).
	TableName interface{} `json:"tableName,omitempty"`
}

// AzureQueueSink - A copy activity Azure Queue sink.
type AzureQueueSink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type AzureQueueSink.
func (a *AzureQueueSink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     a.Type,
		WriteBatchSize:           a.WriteBatchSize,
		WriteBatchTimeout:        a.WriteBatchTimeout,
		SinkRetryCount:           a.SinkRetryCount,
		SinkRetryWait:            a.SinkRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AzureSQLDWLinkedService - Azure SQL Data Warehouse linked service.
type AzureSQLDWLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure SQL Data Warehouse linked service properties.
	TypeProperties *AzureSQLDWLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureSQLDWLinkedService.
func (a *AzureSQLDWLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureSQLDWLinkedServiceTypeProperties - Azure SQL Data Warehouse linked service properties.
type AzureSQLDWLinkedServiceTypeProperties struct {
	// REQUIRED; The connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type: string, SecureString
	// or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`

	// Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment,
	// AzureGermany. Default value is the data factory regions’ cloud type. Type:
	// string (or Expression with resultType string).
	AzureCloudType interface{} `json:"azureCloudType,omitempty"`

	// The credential reference containing authentication information.
	Credential *CredentialReference `json:"credential,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The Azure key vault secret reference of password in connection string.
	Password *AzureKeyVaultSecretReference `json:"password,omitempty"`

	// The ID of the service principal used to authenticate against Azure SQL Data Warehouse. Type: string (or Expression with
	// resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`

	// The key of the service principal used to authenticate against Azure SQL Data Warehouse.
	ServicePrincipalKey SecretBaseClassification `json:"servicePrincipalKey,omitempty"`

	// The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`
}

// AzureSQLDWTableDataset - The Azure SQL Data Warehouse dataset.
type AzureSQLDWTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Azure SQL Data Warehouse dataset properties.
	TypeProperties *AzureSQLDWTableDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type AzureSQLDWTableDataset.
func (a *AzureSQLDWTableDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 a.Type,
		Description:          a.Description,
		Structure:            a.Structure,
		Schema:               a.Schema,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		Folder:               a.Folder,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureSQLDWTableDatasetTypeProperties - Azure SQL Data Warehouse dataset properties.
type AzureSQLDWTableDatasetTypeProperties struct {
	// The schema name of the Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
	Schema interface{} `json:"schema,omitempty"`

	// The table name of the Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
	Table interface{} `json:"table,omitempty"`

	// This property will be retired. Please consider using schema + table properties instead.
	TableName interface{} `json:"tableName,omitempty"`
}

// AzureSQLDatabaseLinkedService - Microsoft Azure SQL Database linked service.
type AzureSQLDatabaseLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure SQL Database linked service properties.
	TypeProperties *AzureSQLDatabaseLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureSQLDatabaseLinkedService.
func (a *AzureSQLDatabaseLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureSQLDatabaseLinkedServiceTypeProperties - Azure SQL Database linked service properties.
type AzureSQLDatabaseLinkedServiceTypeProperties struct {
	// REQUIRED; The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`

	// Sql always encrypted properties.
	AlwaysEncryptedSettings *SQLAlwaysEncryptedProperties `json:"alwaysEncryptedSettings,omitempty"`

	// Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment,
	// AzureGermany. Default value is the data factory regions’ cloud type. Type:
	// string (or Expression with resultType string).
	AzureCloudType interface{} `json:"azureCloudType,omitempty"`

	// The credential reference containing authentication information.
	Credential *CredentialReference `json:"credential,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The Azure key vault secret reference of password in connection string.
	Password *AzureKeyVaultSecretReference `json:"password,omitempty"`

	// The ID of the service principal used to authenticate against Azure SQL Database. Type: string (or Expression with resultType
	// string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`

	// The key of the service principal used to authenticate against Azure SQL Database.
	ServicePrincipalKey SecretBaseClassification `json:"servicePrincipalKey,omitempty"`

	// The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`
}

// AzureSQLMILinkedService - Azure SQL Managed Instance linked service.
type AzureSQLMILinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure SQL Managed Instance linked service properties.
	TypeProperties *AzureSQLMILinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureSQLMILinkedService.
func (a *AzureSQLMILinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureSQLMILinkedServiceTypeProperties - Azure SQL Managed Instance linked service properties.
type AzureSQLMILinkedServiceTypeProperties struct {
	// REQUIRED; The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`

	// Sql always encrypted properties.
	AlwaysEncryptedSettings *SQLAlwaysEncryptedProperties `json:"alwaysEncryptedSettings,omitempty"`

	// Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment,
	// AzureGermany. Default value is the data factory regions’ cloud type. Type:
	// string (or Expression with resultType string).
	AzureCloudType interface{} `json:"azureCloudType,omitempty"`

	// The credential reference containing authentication information.
	Credential *CredentialReference `json:"credential,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The Azure key vault secret reference of password in connection string.
	Password *AzureKeyVaultSecretReference `json:"password,omitempty"`

	// The ID of the service principal used to authenticate against Azure SQL Managed Instance. Type: string (or Expression with
	// resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`

	// The key of the service principal used to authenticate against Azure SQL Managed Instance.
	ServicePrincipalKey SecretBaseClassification `json:"servicePrincipalKey,omitempty"`

	// The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`
}

// AzureSQLMITableDataset - The Azure SQL Managed Instance dataset.
type AzureSQLMITableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Azure SQL Managed Instance dataset properties.
	TypeProperties *AzureSQLMITableDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type AzureSQLMITableDataset.
func (a *AzureSQLMITableDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 a.Type,
		Description:          a.Description,
		Structure:            a.Structure,
		Schema:               a.Schema,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		Folder:               a.Folder,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureSQLMITableDatasetTypeProperties - Azure SQL Managed Instance dataset properties.
type AzureSQLMITableDatasetTypeProperties struct {
	// The schema name of the Azure SQL Managed Instance. Type: string (or Expression with resultType string).
	Schema interface{} `json:"schema,omitempty"`

	// The table name of the Azure SQL Managed Instance dataset. Type: string (or Expression with resultType string).
	Table interface{} `json:"table,omitempty"`

	// This property will be retired. Please consider using schema + table properties instead.
	TableName interface{} `json:"tableName,omitempty"`
}

// AzureSQLSink - A copy activity Azure SQL sink.
type AzureSQLSink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// SQL pre-copy script. Type: string (or Expression with resultType string).
	PreCopyScript interface{} `json:"preCopyScript,omitempty"`

	// SQL writer stored procedure name. Type: string (or Expression with resultType string).
	SQLWriterStoredProcedureName interface{} `json:"sqlWriterStoredProcedureName,omitempty"`

	// SQL writer table type. Type: string (or Expression with resultType string).
	SQLWriterTableType interface{} `json:"sqlWriterTableType,omitempty"`

	// Whether to use table lock during bulk copy. Type: boolean (or Expression with resultType boolean).
	SQLWriterUseTableLock interface{} `json:"sqlWriterUseTableLock,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// SQL stored procedure parameters.
	StoredProcedureParameters interface{} `json:"storedProcedureParameters,omitempty"`

	// The stored procedure parameter name of the table type. Type: string (or Expression with resultType string).
	StoredProcedureTableTypeParameterName interface{} `json:"storedProcedureTableTypeParameterName,omitempty"`

	// The option to handle sink table, such as autoCreate. For now only 'autoCreate' value is supported. Type: string (or Expression
	// with resultType string).
	TableOption interface{} `json:"tableOption,omitempty"`

	// SQL upsert settings.
	UpsertSettings *SQLUpsertSettings `json:"upsertSettings,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`

	// Write behavior when copying data into Azure SQL. Type: SqlWriteBehaviorEnum (or Expression with resultType SqlWriteBehaviorEnum)
	WriteBehavior interface{} `json:"writeBehavior,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type AzureSQLSink.
func (a *AzureSQLSink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     a.Type,
		WriteBatchSize:           a.WriteBatchSize,
		WriteBatchTimeout:        a.WriteBatchTimeout,
		SinkRetryCount:           a.SinkRetryCount,
		SinkRetryWait:            a.SinkRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AzureSQLSource - A copy activity Azure SQL source.
type AzureSQLSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// The partition mechanism that will be used for Sql read in parallel. Possible values include: "None", "PhysicalPartitionsOfTable",
	// "DynamicRange".
	PartitionOption interface{} `json:"partitionOption,omitempty"`

	// The settings that will be leveraged for Sql source partitioning.
	PartitionSettings *SQLPartitionSettings `json:"partitionSettings,omitempty"`

	// Which additional types to produce.
	ProduceAdditionalTypes interface{} `json:"produceAdditionalTypes,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// SQL reader query. Type: string (or Expression with resultType string).
	SQLReaderQuery interface{} `json:"sqlReaderQuery,omitempty"`

	// Name of the stored procedure for a SQL Database source. This cannot be used at the same time as SqlReaderQuery. Type: string
	// (or Expression with resultType string).
	SQLReaderStoredProcedureName interface{} `json:"sqlReaderStoredProcedureName,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`

	// Value and type setting for stored procedure parameters. Example: "{Parameter1: {value: "1", type: "int"}}".
	StoredProcedureParameters interface{} `json:"storedProcedureParameters,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type AzureSQLSource.
func (a *AzureSQLSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     a.Type,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type AzureSQLSource.
func (a *AzureSQLSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             a.QueryTimeout,
		AdditionalColumns:        a.AdditionalColumns,
		Type:                     a.Type,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AzureSQLTableDataset - The Azure SQL Server database dataset.
type AzureSQLTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Azure SQL dataset properties.
	TypeProperties *AzureSQLTableDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type AzureSQLTableDataset.
func (a *AzureSQLTableDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 a.Type,
		Description:          a.Description,
		Structure:            a.Structure,
		Schema:               a.Schema,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		Folder:               a.Folder,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureSQLTableDatasetTypeProperties - Azure SQL dataset properties.
type AzureSQLTableDatasetTypeProperties struct {
	// The schema name of the Azure SQL database. Type: string (or Expression with resultType string).
	Schema interface{} `json:"schema,omitempty"`

	// The table name of the Azure SQL database. Type: string (or Expression with resultType string).
	Table interface{} `json:"table,omitempty"`

	// This property will be retired. Please consider using schema + table properties instead.
	TableName interface{} `json:"tableName,omitempty"`
}

// AzureSearchIndexDataset - The Azure Search Index.
type AzureSearchIndexDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Properties specific to this dataset type.
	TypeProperties *AzureSearchIndexDatasetTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type AzureSearchIndexDataset.
func (a *AzureSearchIndexDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 a.Type,
		Description:          a.Description,
		Structure:            a.Structure,
		Schema:               a.Schema,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		Folder:               a.Folder,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureSearchIndexDatasetTypeProperties - Properties specific to this dataset type.
type AzureSearchIndexDatasetTypeProperties struct {
	// REQUIRED; The name of the Azure Search Index. Type: string (or Expression with resultType string).
	IndexName interface{} `json:"indexName,omitempty"`
}

// AzureSearchIndexSink - A copy activity Azure Search Index sink.
type AzureSearchIndexSink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`

	// Specify the write behavior when upserting documents into Azure Search Index.
	WriteBehavior *AzureSearchIndexWriteBehaviorType `json:"writeBehavior,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type AzureSearchIndexSink.
func (a *AzureSearchIndexSink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     a.Type,
		WriteBatchSize:           a.WriteBatchSize,
		WriteBatchTimeout:        a.WriteBatchTimeout,
		SinkRetryCount:           a.SinkRetryCount,
		SinkRetryWait:            a.SinkRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AzureSearchLinkedService - Linked service for Windows Azure Search Service.
type AzureSearchLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Windows Azure Search Service linked service properties.
	TypeProperties *AzureSearchLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureSearchLinkedService.
func (a *AzureSearchLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureSearchLinkedServiceTypeProperties - Windows Azure Search Service linked service properties.
type AzureSearchLinkedServiceTypeProperties struct {
	// REQUIRED; URL for Azure Search service. Type: string (or Expression with resultType string).
	URL interface{} `json:"url,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// Admin Key for Azure Search service
	Key SecretBaseClassification `json:"key,omitempty"`
}

// AzureStorageLinkedService - The storage account linked service.
type AzureStorageLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure Storage linked service properties.
	TypeProperties *AzureStorageLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureStorageLinkedService.
func (a *AzureStorageLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureStorageLinkedServiceTypeProperties - Azure Storage linked service properties.
type AzureStorageLinkedServiceTypeProperties struct {
	// The Azure key vault secret reference of accountKey in connection string.
	AccountKey *AzureKeyVaultSecretReference `json:"accountKey,omitempty"`

	// The connection string. It is mutually exclusive with sasUri property. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential *string `json:"encryptedCredential,omitempty"`

	// The Azure key vault secret reference of sasToken in sas uri.
	SasToken *AzureKeyVaultSecretReference `json:"sasToken,omitempty"`

	// SAS URI of the Azure Storage resource. It is mutually exclusive with connectionString property. Type: string, SecureString
	// or AzureKeyVaultSecretReference.
	SasURI interface{} `json:"sasUri,omitempty"`
}

// AzureSynapseArtifactsLinkedService - Azure Synapse Analytics (Artifacts) linked service.
type AzureSynapseArtifactsLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure Synapse Analytics (Artifacts) linked service properties.
	TypeProperties *AzureSynapseArtifactsLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureSynapseArtifactsLinkedService.
func (a *AzureSynapseArtifactsLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureSynapseArtifactsLinkedServiceTypeProperties - Azure Synapse Analytics (Artifacts) linked service properties.
type AzureSynapseArtifactsLinkedServiceTypeProperties struct {
	// REQUIRED; https://.dev.azuresynapse.net, Azure Synapse Analytics workspace URL. Type: string (or Expression with resultType
	// string).
	Endpoint interface{} `json:"endpoint,omitempty"`

	// Required to specify MSI, if using system assigned managed identity as authentication method. Type: string (or Expression
	// with resultType string).
	Authentication interface{} `json:"authentication,omitempty"`

	// The resource ID of the Synapse workspace. The format should be: /subscriptions/{subscriptionID}/resourceGroups/{resourceGroup}/providers/Microsoft.Synapse/workspaces/{workspaceName}.
	// Type: string (or
	// Expression with resultType string).
	WorkspaceResourceID interface{} `json:"workspaceResourceId,omitempty"`
}

// AzureTableDataset - The Azure Table storage dataset.
type AzureTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure Table dataset properties.
	TypeProperties *AzureTableDatasetTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type AzureTableDataset.
func (a *AzureTableDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 a.Type,
		Description:          a.Description,
		Structure:            a.Structure,
		Schema:               a.Schema,
		LinkedServiceName:    a.LinkedServiceName,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		Folder:               a.Folder,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// AzureTableDatasetTypeProperties - Azure Table dataset properties.
type AzureTableDatasetTypeProperties struct {
	// REQUIRED; The table name of the Azure Table storage. Type: string (or Expression with resultType string).
	TableName interface{} `json:"tableName,omitempty"`
}

// AzureTableSink - A copy activity Azure Table sink.
type AzureTableSink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Azure Table default partition key value. Type: string (or Expression with resultType string).
	AzureTableDefaultPartitionKeyValue interface{} `json:"azureTableDefaultPartitionKeyValue,omitempty"`

	// Azure Table insert type. Type: string (or Expression with resultType string).
	AzureTableInsertType interface{} `json:"azureTableInsertType,omitempty"`

	// Azure Table partition key name. Type: string (or Expression with resultType string).
	AzureTablePartitionKeyName interface{} `json:"azureTablePartitionKeyName,omitempty"`

	// Azure Table row key name. Type: string (or Expression with resultType string).
	AzureTableRowKeyName interface{} `json:"azureTableRowKeyName,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type AzureTableSink.
func (a *AzureTableSink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     a.Type,
		WriteBatchSize:           a.WriteBatchSize,
		WriteBatchTimeout:        a.WriteBatchTimeout,
		SinkRetryCount:           a.SinkRetryCount,
		SinkRetryWait:            a.SinkRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AzureTableSource - A copy activity Azure Table source.
type AzureTableSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Azure Table source ignore table not found. Type: boolean (or Expression with resultType boolean).
	AzureTableSourceIgnoreTableNotFound interface{} `json:"azureTableSourceIgnoreTableNotFound,omitempty"`

	// Azure Table source query. Type: string (or Expression with resultType string).
	AzureTableSourceQuery interface{} `json:"azureTableSourceQuery,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type AzureTableSource.
func (a *AzureTableSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     a.Type,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type AzureTableSource.
func (a *AzureTableSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             a.QueryTimeout,
		AdditionalColumns:        a.AdditionalColumns,
		Type:                     a.Type,
		SourceRetryCount:         a.SourceRetryCount,
		SourceRetryWait:          a.SourceRetryWait,
		MaxConcurrentConnections: a.MaxConcurrentConnections,
		DisableMetricsCollection: a.DisableMetricsCollection,
		AdditionalProperties:     a.AdditionalProperties,
	}
}

// AzureTableStorageLinkedService - The azure table storage linked service.
type AzureTableStorageLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Azure Table Storage linked service properties.
	TypeProperties *AzureStorageLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type AzureTableStorageLinkedService.
func (a *AzureTableStorageLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 a.Type,
		ConnectVia:           a.ConnectVia,
		Description:          a.Description,
		Parameters:           a.Parameters,
		Annotations:          a.Annotations,
		AdditionalProperties: a.AdditionalProperties,
	}
}

// BigDataPoolParametrizationReference - Big data pool reference type.
type BigDataPoolParametrizationReference struct {
	// REQUIRED; Reference big data pool name. Type: string (or Expression with resultType string).
	ReferenceName interface{} `json:"referenceName,omitempty"`

	// REQUIRED; Big data pool reference type.
	Type *BigDataPoolReferenceType `json:"type,omitempty"`
}

// BinaryDataset - Binary dataset.
type BinaryDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Binary dataset properties.
	TypeProperties *BinaryDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type BinaryDataset.
func (b *BinaryDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 b.Type,
		Description:          b.Description,
		Structure:            b.Structure,
		Schema:               b.Schema,
		LinkedServiceName:    b.LinkedServiceName,
		Parameters:           b.Parameters,
		Annotations:          b.Annotations,
		Folder:               b.Folder,
		AdditionalProperties: b.AdditionalProperties,
	}
}

// BinaryDatasetTypeProperties - Binary dataset properties.
type BinaryDatasetTypeProperties struct {
	// REQUIRED; The location of the Binary storage.
	Location DatasetLocationClassification `json:"location,omitempty"`

	// The data compression method used for the binary dataset.
	Compression *DatasetCompression `json:"compression,omitempty"`
}

// BinaryReadSettings - Binary read settings.
type BinaryReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Compression settings.
	CompressionProperties CompressionReadSettingsClassification `json:"compressionProperties,omitempty"`
}

// GetFormatReadSettings implements the FormatReadSettingsClassification interface for type BinaryReadSettings.
func (b *BinaryReadSettings) GetFormatReadSettings() *FormatReadSettings {
	return &FormatReadSettings{
		Type:                 b.Type,
		AdditionalProperties: b.AdditionalProperties,
	}
}

// BinarySink - A copy activity Binary sink.
type BinarySink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// Binary store settings.
	StoreSettings StoreWriteSettingsClassification `json:"storeSettings,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type BinarySink.
func (b *BinarySink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     b.Type,
		WriteBatchSize:           b.WriteBatchSize,
		WriteBatchTimeout:        b.WriteBatchTimeout,
		SinkRetryCount:           b.SinkRetryCount,
		SinkRetryWait:            b.SinkRetryWait,
		MaxConcurrentConnections: b.MaxConcurrentConnections,
		DisableMetricsCollection: b.DisableMetricsCollection,
		AdditionalProperties:     b.AdditionalProperties,
	}
}

// BinarySource - A copy activity Binary source.
type BinarySource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// Binary format settings.
	FormatSettings *BinaryReadSettings `json:"formatSettings,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`

	// Binary store settings.
	StoreSettings StoreReadSettingsClassification `json:"storeSettings,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type BinarySource.
func (b *BinarySource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     b.Type,
		SourceRetryCount:         b.SourceRetryCount,
		SourceRetryWait:          b.SourceRetryWait,
		MaxConcurrentConnections: b.MaxConcurrentConnections,
		DisableMetricsCollection: b.DisableMetricsCollection,
		AdditionalProperties:     b.AdditionalProperties,
	}
}

// BlobEventsTrigger - Trigger that runs every time a Blob event occurs.
type BlobEventsTrigger struct {
	// REQUIRED; Trigger type.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Blob Events Trigger properties.
	TypeProperties *BlobEventsTriggerTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the trigger.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Trigger description.
	Description *string `json:"description,omitempty"`

	// Pipelines that need to be started.
	Pipelines []*TriggerPipelineReference `json:"pipelines,omitempty"`

	// READ-ONLY; Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger.
	RuntimeState *TriggerRuntimeState `json:"runtimeState,omitempty" azure:"ro"`
}

// GetMultiplePipelineTrigger implements the MultiplePipelineTriggerClassification interface for type BlobEventsTrigger.
func (b *BlobEventsTrigger) GetMultiplePipelineTrigger() *MultiplePipelineTrigger {
	return &MultiplePipelineTrigger{
		Pipelines:            b.Pipelines,
		Type:                 b.Type,
		Description:          b.Description,
		RuntimeState:         b.RuntimeState,
		Annotations:          b.Annotations,
		AdditionalProperties: b.AdditionalProperties,
	}
}

// GetTrigger implements the TriggerClassification interface for type BlobEventsTrigger.
func (b *BlobEventsTrigger) GetTrigger() *Trigger {
	return &Trigger{
		Type:                 b.Type,
		Description:          b.Description,
		RuntimeState:         b.RuntimeState,
		Annotations:          b.Annotations,
		AdditionalProperties: b.AdditionalProperties,
	}
}

// BlobEventsTriggerTypeProperties - Blob Events Trigger properties.
type BlobEventsTriggerTypeProperties struct {
	// REQUIRED; The type of events that cause this trigger to fire.
	Events []*BlobEventTypes `json:"events,omitempty"`

	// REQUIRED; The ARM resource ID of the Storage Account.
	Scope *string `json:"scope,omitempty"`

	// The blob path must begin with the pattern provided for trigger to fire. For example, '/records/blobs/december/' will only
	// fire the trigger for blobs in the december folder under the records container.
	// At least one of these must be provided: blobPathBeginsWith, blobPathEndsWith.
	BlobPathBeginsWith *string `json:"blobPathBeginsWith,omitempty"`

	// The blob path must end with the pattern provided for trigger to fire. For example, 'december/boxes.csv' will only fire
	// the trigger for blobs named boxes in a december folder. At least one of these
	// must be provided: blobPathBeginsWith, blobPathEndsWith.
	BlobPathEndsWith *string `json:"blobPathEndsWith,omitempty"`

	// If set to true, blobs with zero bytes will be ignored.
	IgnoreEmptyBlobs *bool `json:"ignoreEmptyBlobs,omitempty"`
}

// BlobSink - A copy activity Azure Blob sink.
type BlobSink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Blob writer add header. Type: boolean (or Expression with resultType boolean).
	BlobWriterAddHeader interface{} `json:"blobWriterAddHeader,omitempty"`

	// Blob writer date time format. Type: string (or Expression with resultType string).
	BlobWriterDateTimeFormat interface{} `json:"blobWriterDateTimeFormat,omitempty"`

	// Blob writer overwrite files. Type: boolean (or Expression with resultType boolean).
	BlobWriterOverwriteFiles interface{} `json:"blobWriterOverwriteFiles,omitempty"`

	// The type of copy behavior for copy sink.
	CopyBehavior interface{} `json:"copyBehavior,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Specify the custom metadata to be added to sink data. Type: array of objects (or Expression with resultType array of objects).
	Metadata []*MetadataItem `json:"metadata,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type BlobSink.
func (b *BlobSink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     b.Type,
		WriteBatchSize:           b.WriteBatchSize,
		WriteBatchTimeout:        b.WriteBatchTimeout,
		SinkRetryCount:           b.SinkRetryCount,
		SinkRetryWait:            b.SinkRetryWait,
		MaxConcurrentConnections: b.MaxConcurrentConnections,
		DisableMetricsCollection: b.DisableMetricsCollection,
		AdditionalProperties:     b.AdditionalProperties,
	}
}

// BlobSource - A copy activity Azure Blob source.
type BlobSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive interface{} `json:"recursive,omitempty"`

	// Number of header lines to skip from each blob. Type: integer (or Expression with resultType integer).
	SkipHeaderLineCount interface{} `json:"skipHeaderLineCount,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`

	// Treat empty as null. Type: boolean (or Expression with resultType boolean).
	TreatEmptyAsNull interface{} `json:"treatEmptyAsNull,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type BlobSource.
func (b *BlobSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     b.Type,
		SourceRetryCount:         b.SourceRetryCount,
		SourceRetryWait:          b.SourceRetryWait,
		MaxConcurrentConnections: b.MaxConcurrentConnections,
		DisableMetricsCollection: b.DisableMetricsCollection,
		AdditionalProperties:     b.AdditionalProperties,
	}
}

// BlobTrigger - Trigger that runs every time the selected Blob container changes.
type BlobTrigger struct {
	// REQUIRED; Trigger type.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Blob Trigger properties.
	TypeProperties *BlobTriggerTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the trigger.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Trigger description.
	Description *string `json:"description,omitempty"`

	// Pipelines that need to be started.
	Pipelines []*TriggerPipelineReference `json:"pipelines,omitempty"`

	// READ-ONLY; Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger.
	RuntimeState *TriggerRuntimeState `json:"runtimeState,omitempty" azure:"ro"`
}

// GetMultiplePipelineTrigger implements the MultiplePipelineTriggerClassification interface for type BlobTrigger.
func (b *BlobTrigger) GetMultiplePipelineTrigger() *MultiplePipelineTrigger {
	return &MultiplePipelineTrigger{
		Pipelines:            b.Pipelines,
		Type:                 b.Type,
		Description:          b.Description,
		RuntimeState:         b.RuntimeState,
		Annotations:          b.Annotations,
		AdditionalProperties: b.AdditionalProperties,
	}
}

// GetTrigger implements the TriggerClassification interface for type BlobTrigger.
func (b *BlobTrigger) GetTrigger() *Trigger {
	return &Trigger{
		Type:                 b.Type,
		Description:          b.Description,
		RuntimeState:         b.RuntimeState,
		Annotations:          b.Annotations,
		AdditionalProperties: b.AdditionalProperties,
	}
}

// BlobTriggerTypeProperties - Blob Trigger properties.
type BlobTriggerTypeProperties struct {
	// REQUIRED; The path of the container/folder that will trigger the pipeline.
	FolderPath *string `json:"folderPath,omitempty"`

	// REQUIRED; The Azure Storage linked service reference.
	LinkedService *LinkedServiceReference `json:"linkedService,omitempty"`

	// REQUIRED; The max number of parallel files to handle when it is triggered.
	MaxConcurrency *int32 `json:"maxConcurrency,omitempty"`
}

// CMKIdentityDefinition - Managed Identity used for CMK.
type CMKIdentityDefinition struct {
	// The resource id of the user assigned identity to authenticate to customer's key vault.
	UserAssignedIdentity *string `json:"userAssignedIdentity,omitempty"`
}

// CassandraLinkedService - Linked service for Cassandra data source.
type CassandraLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Cassandra linked service properties.
	TypeProperties *CassandraLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type CassandraLinkedService.
func (c *CassandraLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 c.Type,
		ConnectVia:           c.ConnectVia,
		Description:          c.Description,
		Parameters:           c.Parameters,
		Annotations:          c.Annotations,
		AdditionalProperties: c.AdditionalProperties,
	}
}

// CassandraLinkedServiceTypeProperties - Cassandra linked service properties.
type CassandraLinkedServiceTypeProperties struct {
	// REQUIRED; Host name for connection. Type: string (or Expression with resultType string).
	Host interface{} `json:"host,omitempty"`

	// AuthenticationType to be used for connection. Type: string (or Expression with resultType string).
	AuthenticationType interface{} `json:"authenticationType,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// Password for authentication.
	Password SecretBaseClassification `json:"password,omitempty"`

	// The port for the connection. Type: integer (or Expression with resultType integer).
	Port interface{} `json:"port,omitempty"`

	// Username for authentication. Type: string (or Expression with resultType string).
	Username interface{} `json:"username,omitempty"`
}

// CassandraSource - A copy activity source for a Cassandra database.
type CassandraSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// The consistency level specifies how many Cassandra servers must respond to a read request before returning data to the
	// client application. Cassandra checks the specified number of Cassandra servers
	// for data to satisfy the read request. Must be one of cassandraSourceReadConsistencyLevels. The default value is 'ONE'.
	// It is case-insensitive.
	ConsistencyLevel *CassandraSourceReadConsistencyLevels `json:"consistencyLevel,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Database query. Should be a SQL-92 query expression or Cassandra Query Language (CQL) command. Type: string (or Expression
	// with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type CassandraSource.
func (c *CassandraSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     c.Type,
		SourceRetryCount:         c.SourceRetryCount,
		SourceRetryWait:          c.SourceRetryWait,
		MaxConcurrentConnections: c.MaxConcurrentConnections,
		DisableMetricsCollection: c.DisableMetricsCollection,
		AdditionalProperties:     c.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type CassandraSource.
func (c *CassandraSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             c.QueryTimeout,
		AdditionalColumns:        c.AdditionalColumns,
		Type:                     c.Type,
		SourceRetryCount:         c.SourceRetryCount,
		SourceRetryWait:          c.SourceRetryWait,
		MaxConcurrentConnections: c.MaxConcurrentConnections,
		DisableMetricsCollection: c.DisableMetricsCollection,
		AdditionalProperties:     c.AdditionalProperties,
	}
}

// CassandraTableDataset - The Cassandra database dataset.
type CassandraTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Cassandra dataset properties.
	TypeProperties *CassandraTableDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type CassandraTableDataset.
func (c *CassandraTableDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 c.Type,
		Description:          c.Description,
		Structure:            c.Structure,
		Schema:               c.Schema,
		LinkedServiceName:    c.LinkedServiceName,
		Parameters:           c.Parameters,
		Annotations:          c.Annotations,
		Folder:               c.Folder,
		AdditionalProperties: c.AdditionalProperties,
	}
}

// CassandraTableDatasetTypeProperties - Cassandra dataset properties.
type CassandraTableDatasetTypeProperties struct {
	// The keyspace of the Cassandra database. Type: string (or Expression with resultType string).
	Keyspace interface{} `json:"keyspace,omitempty"`

	// The table name of the Cassandra database. Type: string (or Expression with resultType string).
	TableName interface{} `json:"tableName,omitempty"`
}

// ChainingTrigger - Trigger that allows the referenced pipeline to depend on other pipeline runs based on runDimension Name/Value
// pairs. Upstream pipelines should declare the same runDimension Name and their runs should
// have the values for those runDimensions. The referenced pipeline run would be triggered if the values for the runDimension
// match for all upstream pipeline runs.
type ChainingTrigger struct {
	// REQUIRED; Pipeline for which runs are created when all upstream pipelines complete successfully.
	Pipeline *TriggerPipelineReference `json:"pipeline,omitempty"`

	// REQUIRED; Trigger type.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Chaining Trigger properties.
	TypeProperties *ChainingTriggerTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the trigger.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Trigger description.
	Description *string `json:"description,omitempty"`

	// READ-ONLY; Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger.
	RuntimeState *TriggerRuntimeState `json:"runtimeState,omitempty" azure:"ro"`
}

// GetTrigger implements the TriggerClassification interface for type ChainingTrigger.
func (c *ChainingTrigger) GetTrigger() *Trigger {
	return &Trigger{
		Type:                 c.Type,
		Description:          c.Description,
		RuntimeState:         c.RuntimeState,
		Annotations:          c.Annotations,
		AdditionalProperties: c.AdditionalProperties,
	}
}

// ChainingTriggerTypeProperties - Chaining Trigger properties.
type ChainingTriggerTypeProperties struct {
	// REQUIRED; Upstream Pipelines.
	DependsOn []*PipelineReference `json:"dependsOn,omitempty"`

	// REQUIRED; Run Dimension property that needs to be emitted by upstream pipelines.
	RunDimension *string `json:"runDimension,omitempty"`
}

// CmdkeySetup - The custom setup of running cmdkey commands.
type CmdkeySetup struct {
	// REQUIRED; The type of custom setup.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Cmdkey command custom setup type properties.
	TypeProperties *CmdkeySetupTypeProperties `json:"typeProperties,omitempty"`
}

// GetCustomSetupBase implements the CustomSetupBaseClassification interface for type CmdkeySetup.
func (c *CmdkeySetup) GetCustomSetupBase() *CustomSetupBase {
	return &CustomSetupBase{
		Type: c.Type,
	}
}

// CmdkeySetupTypeProperties - Cmdkey command custom setup type properties.
type CmdkeySetupTypeProperties struct {
	// REQUIRED; The password of data source access.
	Password SecretBaseClassification `json:"password,omitempty"`

	// REQUIRED; The server name of data source access.
	TargetName interface{} `json:"targetName,omitempty"`

	// REQUIRED; The user name of data source access.
	UserName interface{} `json:"userName,omitempty"`
}

// CommonDataServiceForAppsEntityDataset - The Common Data Service for Apps entity dataset.
type CommonDataServiceForAppsEntityDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Common Data Service for Apps entity dataset properties.
	TypeProperties *CommonDataServiceForAppsEntityDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type CommonDataServiceForAppsEntityDataset.
func (c *CommonDataServiceForAppsEntityDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 c.Type,
		Description:          c.Description,
		Structure:            c.Structure,
		Schema:               c.Schema,
		LinkedServiceName:    c.LinkedServiceName,
		Parameters:           c.Parameters,
		Annotations:          c.Annotations,
		Folder:               c.Folder,
		AdditionalProperties: c.AdditionalProperties,
	}
}

// CommonDataServiceForAppsEntityDatasetTypeProperties - Common Data Service for Apps entity dataset properties.
type CommonDataServiceForAppsEntityDatasetTypeProperties struct {
	// The logical name of the entity. Type: string (or Expression with resultType string).
	EntityName interface{} `json:"entityName,omitempty"`
}

// CommonDataServiceForAppsLinkedService - Common Data Service for Apps linked service.
type CommonDataServiceForAppsLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Common Data Service for Apps linked service properties.
	TypeProperties *CommonDataServiceForAppsLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type CommonDataServiceForAppsLinkedService.
func (c *CommonDataServiceForAppsLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 c.Type,
		ConnectVia:           c.ConnectVia,
		Description:          c.Description,
		Parameters:           c.Parameters,
		Annotations:          c.Annotations,
		AdditionalProperties: c.AdditionalProperties,
	}
}

// CommonDataServiceForAppsLinkedServiceTypeProperties - Common Data Service for Apps linked service properties.
type CommonDataServiceForAppsLinkedServiceTypeProperties struct {
	// REQUIRED; The authentication type to connect to Common Data Service for Apps server. 'Office365' for online scenario, 'Ifd'
	// for on-premises with Ifd scenario. 'AADServicePrincipal' for Server-To-Server
	// authentication in online scenario. Type: string (or Expression with resultType string).
	AuthenticationType interface{} `json:"authenticationType,omitempty"`

	// REQUIRED; The deployment type of the Common Data Service for Apps instance. 'Online' for Common Data Service for Apps Online
	// and 'OnPremisesWithIfd' for Common Data Service for Apps on-premises with Ifd. Type:
	// string (or Expression with resultType string).
	DeploymentType interface{} `json:"deploymentType,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The host name of the on-premises Common Data Service for Apps server. The property is required for on-prem and not allowed
	// for online. Type: string (or Expression with resultType string).
	HostName interface{} `json:"hostName,omitempty"`

	// The organization name of the Common Data Service for Apps instance. The property is required for on-prem and required for
	// online when there are more than one Common Data Service for Apps instances
	// associated with the user. Type: string (or Expression with resultType string).
	OrganizationName interface{} `json:"organizationName,omitempty"`

	// Password to access the Common Data Service for Apps instance.
	Password SecretBaseClassification `json:"password,omitempty"`

	// The port of on-premises Common Data Service for Apps server. The property is required for on-prem and not allowed for online.
	// Default is 443. Type: integer (or Expression with resultType integer),
	// minimum: 0.
	Port interface{} `json:"port,omitempty"`

	// The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
	// servicePrincipalCredential can be SecureString or
	// AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can
	// only be AzureKeyVaultSecretReference.
	ServicePrincipalCredential SecretBaseClassification `json:"servicePrincipalCredential,omitempty"`

	// The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret,
	// 'ServicePrincipalCert' for certificate. Type: string (or Expression with
	// resultType string).
	ServicePrincipalCredentialType interface{} `json:"servicePrincipalCredentialType,omitempty"`

	// The client ID of the application in Azure Active Directory used for Server-To-Server authentication. Type: string (or Expression
	// with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`

	// The URL to the Microsoft Common Data Service for Apps server. The property is required for on-line and not allowed for
	// on-prem. Type: string (or Expression with resultType string).
	ServiceURI interface{} `json:"serviceUri,omitempty"`

	// User name to access the Common Data Service for Apps instance. Type: string (or Expression with resultType string).
	Username interface{} `json:"username,omitempty"`
}

// CommonDataServiceForAppsSink - A copy activity Common Data Service for Apps sink.
type CommonDataServiceForAppsSink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// REQUIRED; The write behavior for the operation.
	WriteBehavior *DynamicsSinkWriteBehavior `json:"writeBehavior,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// The logical name of the alternate key which will be used when upserting records. Type: string (or Expression with resultType
	// string).
	AlternateKeyName interface{} `json:"alternateKeyName,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The flag indicating whether to ignore null values from input dataset (except key fields) during write operation. Default
	// is false. Type: boolean (or Expression with resultType boolean).
	IgnoreNullValues interface{} `json:"ignoreNullValues,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type CommonDataServiceForAppsSink.
func (c *CommonDataServiceForAppsSink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     c.Type,
		WriteBatchSize:           c.WriteBatchSize,
		WriteBatchTimeout:        c.WriteBatchTimeout,
		SinkRetryCount:           c.SinkRetryCount,
		SinkRetryWait:            c.SinkRetryWait,
		MaxConcurrentConnections: c.MaxConcurrentConnections,
		DisableMetricsCollection: c.DisableMetricsCollection,
		AdditionalProperties:     c.AdditionalProperties,
	}
}

// CommonDataServiceForAppsSource - A copy activity Common Data Service for Apps source.
type CommonDataServiceForAppsSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// FetchXML is a proprietary query language that is used in Microsoft Common Data Service for Apps (online & on-premises).
	// Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type CommonDataServiceForAppsSource.
func (c *CommonDataServiceForAppsSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     c.Type,
		SourceRetryCount:         c.SourceRetryCount,
		SourceRetryWait:          c.SourceRetryWait,
		MaxConcurrentConnections: c.MaxConcurrentConnections,
		DisableMetricsCollection: c.DisableMetricsCollection,
		AdditionalProperties:     c.AdditionalProperties,
	}
}

// ComponentSetup - The custom setup of installing 3rd party components.
type ComponentSetup struct {
	// REQUIRED; The type of custom setup.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Install 3rd party component type properties.
	TypeProperties *LicensedComponentSetupTypeProperties `json:"typeProperties,omitempty"`
}

// GetCustomSetupBase implements the CustomSetupBaseClassification interface for type ComponentSetup.
func (c *ComponentSetup) GetCustomSetupBase() *CustomSetupBase {
	return &CustomSetupBase{
		Type: c.Type,
	}
}

// CompressionReadSettingsClassification provides polymorphic access to related types.
// Call the interface's GetCompressionReadSettings() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *CompressionReadSettings, *TarGZipReadSettings, *TarReadSettings, *ZipDeflateReadSettings
type CompressionReadSettingsClassification interface {
	// GetCompressionReadSettings returns the CompressionReadSettings content of the underlying type.
	GetCompressionReadSettings() *CompressionReadSettings
}

// CompressionReadSettings - Compression read settings.
type CompressionReadSettings struct {
	// REQUIRED; The Compression setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}
}

// GetCompressionReadSettings implements the CompressionReadSettingsClassification interface for type CompressionReadSettings.
func (c *CompressionReadSettings) GetCompressionReadSettings() *CompressionReadSettings { return c }

// ConcurLinkedService - Concur Service linked service.
type ConcurLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Concur Service linked service properties.
	TypeProperties *ConcurLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type ConcurLinkedService.
func (c *ConcurLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 c.Type,
		ConnectVia:           c.ConnectVia,
		Description:          c.Description,
		Parameters:           c.Parameters,
		Annotations:          c.Annotations,
		AdditionalProperties: c.AdditionalProperties,
	}
}

// ConcurLinkedServiceTypeProperties - Concur Service linked service properties.
type ConcurLinkedServiceTypeProperties struct {
	// REQUIRED; Application client_id supplied by Concur App Management.
	ClientID interface{} `json:"clientId,omitempty"`

	// REQUIRED; The user name that you use to access Concur Service.
	Username interface{} `json:"username,omitempty"`

	// Properties used to connect to Concur. It is mutually exclusive with any other properties in the linked service. Type: object.
	ConnectionProperties interface{} `json:"connectionProperties,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The password corresponding to the user name that you provided in the username field.
	Password SecretBaseClassification `json:"password,omitempty"`

	// Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
	UseEncryptedEndpoints interface{} `json:"useEncryptedEndpoints,omitempty"`

	// Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting
	// over SSL. The default value is true.
	UseHostVerification interface{} `json:"useHostVerification,omitempty"`

	// Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
	UsePeerVerification interface{} `json:"usePeerVerification,omitempty"`
}

// ConcurObjectDataset - Concur Service dataset.
type ConcurObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type ConcurObjectDataset.
func (c *ConcurObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 c.Type,
		Description:          c.Description,
		Structure:            c.Structure,
		Schema:               c.Schema,
		LinkedServiceName:    c.LinkedServiceName,
		Parameters:           c.Parameters,
		Annotations:          c.Annotations,
		Folder:               c.Folder,
		AdditionalProperties: c.AdditionalProperties,
	}
}

// ConcurSource - A copy activity Concur Service source.
type ConcurSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type ConcurSource.
func (c *ConcurSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     c.Type,
		SourceRetryCount:         c.SourceRetryCount,
		SourceRetryWait:          c.SourceRetryWait,
		MaxConcurrentConnections: c.MaxConcurrentConnections,
		DisableMetricsCollection: c.DisableMetricsCollection,
		AdditionalProperties:     c.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type ConcurSource.
func (c *ConcurSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             c.QueryTimeout,
		AdditionalColumns:        c.AdditionalColumns,
		Type:                     c.Type,
		SourceRetryCount:         c.SourceRetryCount,
		SourceRetryWait:          c.SourceRetryWait,
		MaxConcurrentConnections: c.MaxConcurrentConnections,
		DisableMetricsCollection: c.DisableMetricsCollection,
		AdditionalProperties:     c.AdditionalProperties,
	}
}

// ConnectionStateProperties - The connection state of a managed private endpoint
type ConnectionStateProperties struct {
	// READ-ONLY; The actions required on the managed private endpoint
	ActionsRequired *string `json:"actionsRequired,omitempty" azure:"ro"`

	// READ-ONLY; The managed private endpoint description
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The approval status
	Status *string `json:"status,omitempty" azure:"ro"`
}

// ControlActivityClassification provides polymorphic access to related types.
// Call the interface's GetControlActivity() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AppendVariableActivity, *ControlActivity, *ExecutePipelineActivity, *FailActivity, *FilterActivity, *ForEachActivity,
// - *IfConditionActivity, *SetVariableActivity, *SwitchActivity, *UntilActivity, *ValidationActivity, *WaitActivity, *WebHookActivity
type ControlActivityClassification interface {
	ActivityClassification
	// GetControlActivity returns the ControlActivity content of the underlying type.
	GetControlActivity() *ControlActivity
}

// ControlActivity - Base class for all control activities like IfCondition, ForEach , Until.
type ControlActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type ControlActivity.
func (c *ControlActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 c.Name,
		Type:                 c.Type,
		Description:          c.Description,
		DependsOn:            c.DependsOn,
		UserProperties:       c.UserProperties,
		AdditionalProperties: c.AdditionalProperties,
	}
}

// GetControlActivity implements the ControlActivityClassification interface for type ControlActivity.
func (c *ControlActivity) GetControlActivity() *ControlActivity { return c }

// CopyActivity - Copy activity.
type CopyActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Copy activity properties.
	TypeProperties *CopyActivityTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// List of inputs for the activity.
	Inputs []*DatasetReference `json:"inputs,omitempty"`

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// List of outputs for the activity.
	Outputs []*DatasetReference `json:"outputs,omitempty"`

	// Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type CopyActivity.
func (c *CopyActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 c.Name,
		Type:                 c.Type,
		Description:          c.Description,
		DependsOn:            c.DependsOn,
		UserProperties:       c.UserProperties,
		AdditionalProperties: c.AdditionalProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type CopyActivity.
func (c *CopyActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		LinkedServiceName:    c.LinkedServiceName,
		Policy:               c.Policy,
		Name:                 c.Name,
		Type:                 c.Type,
		Description:          c.Description,
		DependsOn:            c.DependsOn,
		UserProperties:       c.UserProperties,
		AdditionalProperties: c.AdditionalProperties,
	}
}

// CopyActivityLogSettings - Settings for copy activity log.
type CopyActivityLogSettings struct {
	// Specifies whether to enable reliable logging. Type: boolean (or Expression with resultType boolean).
	EnableReliableLogging interface{} `json:"enableReliableLogging,omitempty"`

	// Gets or sets the log level, support: Info, Warning. Type: string (or Expression with resultType string).
	LogLevel interface{} `json:"logLevel,omitempty"`
}

// CopyActivityTypeProperties - Copy activity properties.
type CopyActivityTypeProperties struct {
	// REQUIRED; Copy activity sink.
	Sink CopySinkClassification `json:"sink,omitempty"`

	// REQUIRED; Copy activity source.
	Source CopySourceClassification `json:"source,omitempty"`

	// Maximum number of data integration units that can be used to perform this data movement. Type: integer (or Expression with
	// resultType integer), minimum: 0.
	DataIntegrationUnits interface{} `json:"dataIntegrationUnits,omitempty"`

	// Whether to skip incompatible row. Default value is false. Type: boolean (or Expression with resultType boolean).
	EnableSkipIncompatibleRow interface{} `json:"enableSkipIncompatibleRow,omitempty"`

	// Specifies whether to copy data via an interim staging. Default value is false. Type: boolean (or Expression with resultType
	// boolean).
	EnableStaging interface{} `json:"enableStaging,omitempty"`

	// Log settings customer needs provide when enabling log.
	LogSettings *LogSettings `json:"logSettings,omitempty"`

	// (Deprecated. Please use LogSettings) Log storage settings customer need to provide when enabling session log.
	LogStorageSettings *LogStorageSettings `json:"logStorageSettings,omitempty"`

	// Maximum number of concurrent sessions opened on the source or sink to avoid overloading the data store. Type: integer (or
	// Expression with resultType integer), minimum: 0.
	ParallelCopies interface{} `json:"parallelCopies,omitempty"`

	// Preserve rules.
	Preserve []interface{} `json:"preserve,omitempty"`

	// Preserve Rules.
	PreserveRules []interface{} `json:"preserveRules,omitempty"`

	// Redirect incompatible row settings when EnableSkipIncompatibleRow is true.
	RedirectIncompatibleRowSettings *RedirectIncompatibleRowSettings `json:"redirectIncompatibleRowSettings,omitempty"`

	// Specify the fault tolerance for data consistency.
	SkipErrorFile *SkipErrorFile `json:"skipErrorFile,omitempty"`

	// Specifies interim staging settings when EnableStaging is true.
	StagingSettings *StagingSettings `json:"stagingSettings,omitempty"`

	// Copy activity translator. If not specified, tabular translator is used.
	Translator interface{} `json:"translator,omitempty"`

	// Whether to enable Data Consistency validation. Type: boolean (or Expression with resultType boolean).
	ValidateDataConsistency interface{} `json:"validateDataConsistency,omitempty"`
}

// CopySinkClassification provides polymorphic access to related types.
// Call the interface's GetCopySink() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AvroSink, *AzureBlobFSSink, *AzureDataExplorerSink, *AzureDataLakeStoreSink, *AzureDatabricksDeltaLakeSink, *AzureMySQLSink,
// - *AzurePostgreSQLSink, *AzureQueueSink, *AzureSQLSink, *AzureSearchIndexSink, *AzureTableSink, *BinarySink, *BlobSink,
// - *CommonDataServiceForAppsSink, *CopySink, *CosmosDbMongoDbAPISink, *CosmosDbSQLAPISink, *DelimitedTextSink, *DocumentDbCollectionSink,
// - *DynamicsCrmSink, *DynamicsSink, *FileSystemSink, *InformixSink, *JSONSink, *MicrosoftAccessSink, *MongoDbAtlasSink,
// - *MongoDbV2Sink, *OdbcSink, *OracleSink, *OrcSink, *ParquetSink, *RestSink, *SQLDWSink, *SQLMISink, *SQLServerSink, *SQLSink,
// - *SalesforceServiceCloudSink, *SalesforceSink, *SapCloudForCustomerSink, *SnowflakeSink
type CopySinkClassification interface {
	// GetCopySink returns the CopySink content of the underlying type.
	GetCopySink() *CopySink
}

// CopySink - A copy activity sink.
type CopySink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type CopySink.
func (c *CopySink) GetCopySink() *CopySink { return c }

// CopySourceClassification provides polymorphic access to related types.
// Call the interface's GetCopySource() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AmazonMWSSource, *AmazonRdsForOracleSource, *AmazonRdsForSQLServerSource, *AmazonRedshiftSource, *AvroSource, *AzureBlobFSSource,
// - *AzureDataExplorerSource, *AzureDataLakeStoreSource, *AzureDatabricksDeltaLakeSource, *AzureMariaDBSource, *AzureMySQLSource,
// - *AzurePostgreSQLSource, *AzureSQLSource, *AzureTableSource, *BinarySource, *BlobSource, *CassandraSource, *CommonDataServiceForAppsSource,
// - *ConcurSource, *CopySource, *CosmosDbMongoDbAPISource, *CosmosDbSQLAPISource, *CouchbaseSource, *Db2Source, *DelimitedTextSource,
// - *DocumentDbCollectionSource, *DrillSource, *DynamicsAXSource, *DynamicsCrmSource, *DynamicsSource, *EloquaSource, *ExcelSource,
// - *FileSystemSource, *GoogleAdWordsSource, *GoogleBigQuerySource, *GreenplumSource, *HBaseSource, *HTTPSource, *HdfsSource,
// - *HiveSource, *HubspotSource, *ImpalaSource, *InformixSource, *JSONSource, *JiraSource, *MagentoSource, *MariaDBSource,
// - *MarketoSource, *MicrosoftAccessSource, *MongoDbAtlasSource, *MongoDbSource, *MongoDbV2Source, *MySQLSource, *NetezzaSource,
// - *ODataSource, *OdbcSource, *Office365Source, *OracleServiceCloudSource, *OracleSource, *OrcSource, *ParquetSource, *PaypalSource,
// - *PhoenixSource, *PostgreSQLSource, *PrestoSource, *QuickBooksSource, *RelationalSource, *ResponsysSource, *RestSource,
// - *SQLDWSource, *SQLMISource, *SQLServerSource, *SQLSource, *SalesforceMarketingCloudSource, *SalesforceServiceCloudSource,
// - *SalesforceSource, *SapBwSource, *SapCloudForCustomerSource, *SapEccSource, *SapHanaSource, *SapOdpSource, *SapOpenHubSource,
// - *SapTableSource, *ServiceNowSource, *SharePointOnlineListSource, *ShopifySource, *SnowflakeSource, *SparkSource, *SquareSource,
// - *SybaseSource, *TabularSource, *TeradataSource, *VerticaSource, *WebSource, *XMLSource, *XeroSource, *ZohoSource
type CopySourceClassification interface {
	// GetCopySource returns the CopySource content of the underlying type.
	GetCopySource() *CopySource
}

// CopySource - A copy activity source.
type CopySource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type CopySource.
func (c *CopySource) GetCopySource() *CopySource { return c }

// CosmosDbLinkedService - Microsoft Azure Cosmos Database (CosmosDB) linked service.
type CosmosDbLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; CosmosDB linked service properties.
	TypeProperties *CosmosDbLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type CosmosDbLinkedService.
func (c *CosmosDbLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 c.Type,
		ConnectVia:           c.ConnectVia,
		Description:          c.Description,
		Parameters:           c.Parameters,
		Annotations:          c.Annotations,
		AdditionalProperties: c.AdditionalProperties,
	}
}

// CosmosDbLinkedServiceTypeProperties - CosmosDB linked service properties.
type CosmosDbLinkedServiceTypeProperties struct {
	// The endpoint of the Azure CosmosDB account. Type: string (or Expression with resultType string)
	AccountEndpoint interface{} `json:"accountEndpoint,omitempty"`

	// The account key of the Azure CosmosDB account. Type: SecureString or AzureKeyVaultSecretReference.
	AccountKey SecretBaseClassification `json:"accountKey,omitempty"`

	// Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment,
	// AzureGermany. Default value is the data factory regions’ cloud type. Type:
	// string (or Expression with resultType string).
	AzureCloudType interface{} `json:"azureCloudType,omitempty"`

	// The connection mode used to access CosmosDB account. Type: string (or Expression with resultType string).
	ConnectionMode *CosmosDbConnectionMode `json:"connectionMode,omitempty"`

	// The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`

	// The credential reference containing authentication information.
	Credential *CredentialReference `json:"credential,omitempty"`

	// The name of the database. Type: string (or Expression with resultType string)
	Database interface{} `json:"database,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
	// servicePrincipalCredential can be SecureString or
	// AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can
	// only be AzureKeyVaultSecretReference.
	ServicePrincipalCredential SecretBaseClassification `json:"servicePrincipalCredential,omitempty"`

	// The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret,
	// 'ServicePrincipalCert' for certificate. Type: string (or Expression with
	// resultType string).
	ServicePrincipalCredentialType *CosmosDbServicePrincipalCredentialType `json:"servicePrincipalCredentialType,omitempty"`

	// The client ID of the application in Azure Active Directory used for Server-To-Server authentication. Type: string (or Expression
	// with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`

	// The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`
}

// CosmosDbMongoDbAPICollectionDataset - The CosmosDB (MongoDB API) database dataset.
type CosmosDbMongoDbAPICollectionDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// REQUIRED; CosmosDB (MongoDB API) database dataset properties.
	TypeProperties *CosmosDbMongoDbAPICollectionDatasetTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type CosmosDbMongoDbAPICollectionDataset.
func (c *CosmosDbMongoDbAPICollectionDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 c.Type,
		Description:          c.Description,
		Structure:            c.Structure,
		Schema:               c.Schema,
		LinkedServiceName:    c.LinkedServiceName,
		Parameters:           c.Parameters,
		Annotations:          c.Annotations,
		Folder:               c.Folder,
		AdditionalProperties: c.AdditionalProperties,
	}
}

// CosmosDbMongoDbAPICollectionDatasetTypeProperties - CosmosDB (MongoDB API) database dataset properties.
type CosmosDbMongoDbAPICollectionDatasetTypeProperties struct {
	// REQUIRED; The collection name of the CosmosDB (MongoDB API) database. Type: string (or Expression with resultType string).
	Collection interface{} `json:"collection,omitempty"`
}

// CosmosDbMongoDbAPILinkedService - Linked service for CosmosDB (MongoDB API) data source.
type CosmosDbMongoDbAPILinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; CosmosDB (MongoDB API) linked service properties.
	TypeProperties *CosmosDbMongoDbAPILinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type CosmosDbMongoDbAPILinkedService.
func (c *CosmosDbMongoDbAPILinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 c.Type,
		ConnectVia:           c.ConnectVia,
		Description:          c.Description,
		Parameters:           c.Parameters,
		Annotations:          c.Annotations,
		AdditionalProperties: c.AdditionalProperties,
	}
}

// CosmosDbMongoDbAPILinkedServiceTypeProperties - CosmosDB (MongoDB API) linked service properties.
type CosmosDbMongoDbAPILinkedServiceTypeProperties struct {
	// REQUIRED; The CosmosDB (MongoDB API) connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type:
	// string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`

	// REQUIRED; The name of the CosmosDB (MongoDB API) database that you want to access. Type: string (or Expression with resultType
	// string).
	Database interface{} `json:"database,omitempty"`

	// Whether the CosmosDB (MongoDB API) server version is higher than 3.2. The default value is false. Type: boolean (or Expression
	// with resultType boolean).
	IsServerVersionAbove32 interface{} `json:"isServerVersionAbove32,omitempty"`
}

// CosmosDbMongoDbAPISink - A copy activity sink for a CosmosDB (MongoDB API) database.
type CosmosDbMongoDbAPISink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`

	// Specifies whether the document with same key to be overwritten (upsert) rather than throw exception (insert). The default
	// value is "insert". Type: string (or Expression with resultType string). Type:
	// string (or Expression with resultType string).
	WriteBehavior interface{} `json:"writeBehavior,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type CosmosDbMongoDbAPISink.
func (c *CosmosDbMongoDbAPISink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     c.Type,
		WriteBatchSize:           c.WriteBatchSize,
		WriteBatchTimeout:        c.WriteBatchTimeout,
		SinkRetryCount:           c.SinkRetryCount,
		SinkRetryWait:            c.SinkRetryWait,
		MaxConcurrentConnections: c.MaxConcurrentConnections,
		DisableMetricsCollection: c.DisableMetricsCollection,
		AdditionalProperties:     c.AdditionalProperties,
	}
}

// CosmosDbMongoDbAPISource - A copy activity source for a CosmosDB (MongoDB API) database.
type CosmosDbMongoDbAPISource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Specifies the number of documents to return in each batch of the response from MongoDB instance. In most cases, modifying
	// the batch size will not affect the user or the application. This property's
	// main purpose is to avoid hit the limitation of response size. Type: integer (or Expression with resultType integer).
	BatchSize interface{} `json:"batchSize,omitempty"`

	// Cursor methods for Mongodb query.
	CursorMethods *MongoDbCursorMethodsProperties `json:"cursorMethods,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// Specifies selection filter using query operators. To return all documents in a collection, omit this parameter or pass
	// an empty document ({}). Type: string (or Expression with resultType string).
	Filter interface{} `json:"filter,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type CosmosDbMongoDbAPISource.
func (c *CosmosDbMongoDbAPISource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     c.Type,
		SourceRetryCount:         c.SourceRetryCount,
		SourceRetryWait:          c.SourceRetryWait,
		MaxConcurrentConnections: c.MaxConcurrentConnections,
		DisableMetricsCollection: c.DisableMetricsCollection,
		AdditionalProperties:     c.AdditionalProperties,
	}
}

// CosmosDbSQLAPICollectionDataset - Microsoft Azure CosmosDB (SQL API) Collection dataset.
type CosmosDbSQLAPICollectionDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// REQUIRED; CosmosDB (SQL API) Collection dataset properties.
	TypeProperties *CosmosDbSQLAPICollectionDatasetTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type CosmosDbSQLAPICollectionDataset.
func (c *CosmosDbSQLAPICollectionDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 c.Type,
		Description:          c.Description,
		Structure:            c.Structure,
		Schema:               c.Schema,
		LinkedServiceName:    c.LinkedServiceName,
		Parameters:           c.Parameters,
		Annotations:          c.Annotations,
		Folder:               c.Folder,
		AdditionalProperties: c.AdditionalProperties,
	}
}

// CosmosDbSQLAPICollectionDatasetTypeProperties - CosmosDB (SQL API) Collection dataset properties.
type CosmosDbSQLAPICollectionDatasetTypeProperties struct {
	// REQUIRED; CosmosDB (SQL API) collection name. Type: string (or Expression with resultType string).
	CollectionName interface{} `json:"collectionName,omitempty"`
}

// CosmosDbSQLAPISink - A copy activity Azure CosmosDB (SQL API) Collection sink.
type CosmosDbSQLAPISink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`

	// Describes how to write data to Azure Cosmos DB. Type: string (or Expression with resultType string). Allowed values: insert
	// and upsert.
	WriteBehavior interface{} `json:"writeBehavior,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type CosmosDbSQLAPISink.
func (c *CosmosDbSQLAPISink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     c.Type,
		WriteBatchSize:           c.WriteBatchSize,
		WriteBatchTimeout:        c.WriteBatchTimeout,
		SinkRetryCount:           c.SinkRetryCount,
		SinkRetryWait:            c.SinkRetryWait,
		MaxConcurrentConnections: c.MaxConcurrentConnections,
		DisableMetricsCollection: c.DisableMetricsCollection,
		AdditionalProperties:     c.AdditionalProperties,
	}
}

// CosmosDbSQLAPISource - A copy activity Azure CosmosDB (SQL API) Collection source.
type CosmosDbSQLAPISource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Whether detect primitive values as datetime values. Type: boolean (or Expression with resultType boolean).
	DetectDatetime interface{} `json:"detectDatetime,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Page size of the result. Type: integer (or Expression with resultType integer).
	PageSize interface{} `json:"pageSize,omitempty"`

	// Preferred regions. Type: array of strings (or Expression with resultType array of strings).
	PreferredRegions interface{} `json:"preferredRegions,omitempty"`

	// SQL API query. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type CosmosDbSQLAPISource.
func (c *CosmosDbSQLAPISource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     c.Type,
		SourceRetryCount:         c.SourceRetryCount,
		SourceRetryWait:          c.SourceRetryWait,
		MaxConcurrentConnections: c.MaxConcurrentConnections,
		DisableMetricsCollection: c.DisableMetricsCollection,
		AdditionalProperties:     c.AdditionalProperties,
	}
}

// CouchbaseLinkedService - Couchbase server linked service.
type CouchbaseLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Couchbase server linked service properties.
	TypeProperties *CouchbaseLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type CouchbaseLinkedService.
func (c *CouchbaseLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 c.Type,
		ConnectVia:           c.ConnectVia,
		Description:          c.Description,
		Parameters:           c.Parameters,
		Annotations:          c.Annotations,
		AdditionalProperties: c.AdditionalProperties,
	}
}

// CouchbaseLinkedServiceTypeProperties - Couchbase server linked service properties.
type CouchbaseLinkedServiceTypeProperties struct {
	// An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`

	// The Azure key vault secret reference of credString in connection string.
	CredString *AzureKeyVaultSecretReference `json:"credString,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// CouchbaseSource - A copy activity Couchbase server source.
type CouchbaseSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type CouchbaseSource.
func (c *CouchbaseSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     c.Type,
		SourceRetryCount:         c.SourceRetryCount,
		SourceRetryWait:          c.SourceRetryWait,
		MaxConcurrentConnections: c.MaxConcurrentConnections,
		DisableMetricsCollection: c.DisableMetricsCollection,
		AdditionalProperties:     c.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type CouchbaseSource.
func (c *CouchbaseSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             c.QueryTimeout,
		AdditionalColumns:        c.AdditionalColumns,
		Type:                     c.Type,
		SourceRetryCount:         c.SourceRetryCount,
		SourceRetryWait:          c.SourceRetryWait,
		MaxConcurrentConnections: c.MaxConcurrentConnections,
		DisableMetricsCollection: c.DisableMetricsCollection,
		AdditionalProperties:     c.AdditionalProperties,
	}
}

// CouchbaseTableDataset - Couchbase server dataset.
type CouchbaseTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type CouchbaseTableDataset.
func (c *CouchbaseTableDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 c.Type,
		Description:          c.Description,
		Structure:            c.Structure,
		Schema:               c.Schema,
		LinkedServiceName:    c.LinkedServiceName,
		Parameters:           c.Parameters,
		Annotations:          c.Annotations,
		Folder:               c.Folder,
		AdditionalProperties: c.AdditionalProperties,
	}
}

// CreateDataFlowDebugSessionRequest - Request body structure for creating data flow debug session.
type CreateDataFlowDebugSessionRequest struct {
	// Compute type of the cluster. The value will be overwritten by the same setting in integration runtime if provided.
	ComputeType *string `json:"computeType,omitempty"`

	// Core count of the cluster. The value will be overwritten by the same setting in integration runtime if provided.
	CoreCount *int32 `json:"coreCount,omitempty"`

	// Set to use integration runtime setting for data flow debug session.
	IntegrationRuntime *IntegrationRuntimeDebugResource `json:"integrationRuntime,omitempty"`

	// Time to live setting of the cluster in minutes.
	TimeToLive *int32 `json:"timeToLive,omitempty"`
}

// CreateDataFlowDebugSessionResponse - Response body structure for creating data flow debug session.
type CreateDataFlowDebugSessionResponse struct {
	// The ID of data flow debug session.
	SessionID *string `json:"sessionId,omitempty"`

	// The state of the debug session.
	Status *string `json:"status,omitempty"`
}

// CreateLinkedIntegrationRuntimeRequest - The linked integration runtime information.
type CreateLinkedIntegrationRuntimeRequest struct {
	// The location of the data factory that the linked integration runtime belongs to.
	DataFactoryLocation *string `json:"dataFactoryLocation,omitempty"`

	// The name of the data factory that the linked integration runtime belongs to.
	DataFactoryName *string `json:"dataFactoryName,omitempty"`

	// The name of the linked integration runtime.
	Name *string `json:"name,omitempty"`

	// The ID of the subscription that the linked integration runtime belongs to.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
}

// CreateRunResponse - Response body with a run identifier.
type CreateRunResponse struct {
	// REQUIRED; Identifier of a run.
	RunID *string `json:"runId,omitempty"`
}

// CredentialReference - Credential reference type.
type CredentialReference struct {
	// REQUIRED; Reference credential name.
	ReferenceName *string `json:"referenceName,omitempty"`

	// REQUIRED; Credential reference type.
	Type *CredentialReferenceType `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}
}

// CustomActivity - Custom activity type.
type CustomActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Custom activity properties.
	TypeProperties *CustomActivityTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type CustomActivity.
func (c *CustomActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 c.Name,
		Type:                 c.Type,
		Description:          c.Description,
		DependsOn:            c.DependsOn,
		UserProperties:       c.UserProperties,
		AdditionalProperties: c.AdditionalProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type CustomActivity.
func (c *CustomActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		LinkedServiceName:    c.LinkedServiceName,
		Policy:               c.Policy,
		Name:                 c.Name,
		Type:                 c.Type,
		Description:          c.Description,
		DependsOn:            c.DependsOn,
		UserProperties:       c.UserProperties,
		AdditionalProperties: c.AdditionalProperties,
	}
}

// CustomActivityReferenceObject - Reference objects for custom activity
type CustomActivityReferenceObject struct {
	// Dataset references.
	Datasets []*DatasetReference `json:"datasets,omitempty"`

	// Linked service references.
	LinkedServices []*LinkedServiceReference `json:"linkedServices,omitempty"`
}

// CustomActivityTypeProperties - Custom activity properties.
type CustomActivityTypeProperties struct {
	// REQUIRED; Command for custom activity Type: string (or Expression with resultType string).
	Command interface{} `json:"command,omitempty"`

	// Elevation level and scope for the user, default is nonadmin task. Type: string (or Expression with resultType double).
	AutoUserSpecification interface{} `json:"autoUserSpecification,omitempty"`

	// User defined property bag. There is no restriction on the keys or values that can be used. The user specified custom activity
	// has the full responsibility to consume and interpret the content defined.
	ExtendedProperties map[string]interface{} `json:"extendedProperties,omitempty"`

	// Folder path for resource files Type: string (or Expression with resultType string).
	FolderPath interface{} `json:"folderPath,omitempty"`

	// Reference objects
	ReferenceObjects *CustomActivityReferenceObject `json:"referenceObjects,omitempty"`

	// Resource linked service reference.
	ResourceLinkedService *LinkedServiceReference `json:"resourceLinkedService,omitempty"`

	// The retention time for the files submitted for custom activity. Type: double (or Expression with resultType double).
	RetentionTimeInDays interface{} `json:"retentionTimeInDays,omitempty"`
}

// CustomDataSourceLinkedService - Custom linked service.
type CustomDataSourceLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Custom linked service properties.
	TypeProperties interface{} `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type CustomDataSourceLinkedService.
func (c *CustomDataSourceLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 c.Type,
		ConnectVia:           c.ConnectVia,
		Description:          c.Description,
		Parameters:           c.Parameters,
		Annotations:          c.Annotations,
		AdditionalProperties: c.AdditionalProperties,
	}
}

// CustomDataset - The custom dataset.
type CustomDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Custom dataset properties.
	TypeProperties interface{} `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type CustomDataset.
func (c *CustomDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 c.Type,
		Description:          c.Description,
		Structure:            c.Structure,
		Schema:               c.Schema,
		LinkedServiceName:    c.LinkedServiceName,
		Parameters:           c.Parameters,
		Annotations:          c.Annotations,
		Folder:               c.Folder,
		AdditionalProperties: c.AdditionalProperties,
	}
}

// CustomEventsTrigger - Trigger that runs every time a custom event is received.
type CustomEventsTrigger struct {
	// REQUIRED; Trigger type.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Custom Events Trigger properties.
	TypeProperties *CustomEventsTriggerTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the trigger.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Trigger description.
	Description *string `json:"description,omitempty"`

	// Pipelines that need to be started.
	Pipelines []*TriggerPipelineReference `json:"pipelines,omitempty"`

	// READ-ONLY; Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger.
	RuntimeState *TriggerRuntimeState `json:"runtimeState,omitempty" azure:"ro"`
}

// GetMultiplePipelineTrigger implements the MultiplePipelineTriggerClassification interface for type CustomEventsTrigger.
func (c *CustomEventsTrigger) GetMultiplePipelineTrigger() *MultiplePipelineTrigger {
	return &MultiplePipelineTrigger{
		Pipelines:            c.Pipelines,
		Type:                 c.Type,
		Description:          c.Description,
		RuntimeState:         c.RuntimeState,
		Annotations:          c.Annotations,
		AdditionalProperties: c.AdditionalProperties,
	}
}

// GetTrigger implements the TriggerClassification interface for type CustomEventsTrigger.
func (c *CustomEventsTrigger) GetTrigger() *Trigger {
	return &Trigger{
		Type:                 c.Type,
		Description:          c.Description,
		RuntimeState:         c.RuntimeState,
		Annotations:          c.Annotations,
		AdditionalProperties: c.AdditionalProperties,
	}
}

// CustomEventsTriggerTypeProperties - Custom Events Trigger properties.
type CustomEventsTriggerTypeProperties struct {
	// REQUIRED; The list of event types that cause this trigger to fire.
	Events []interface{} `json:"events,omitempty"`

	// REQUIRED; The ARM resource ID of the Azure Event Grid Topic.
	Scope *string `json:"scope,omitempty"`

	// The event subject must begin with the pattern provided for trigger to fire. At least one of these must be provided: subjectBeginsWith,
	// subjectEndsWith.
	SubjectBeginsWith *string `json:"subjectBeginsWith,omitempty"`

	// The event subject must end with the pattern provided for trigger to fire. At least one of these must be provided: subjectBeginsWith,
	// subjectEndsWith.
	SubjectEndsWith *string `json:"subjectEndsWith,omitempty"`
}

// CustomSetupBaseClassification provides polymorphic access to related types.
// Call the interface's GetCustomSetupBase() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzPowerShellSetup, *CmdkeySetup, *ComponentSetup, *CustomSetupBase, *EnvironmentVariableSetup
type CustomSetupBaseClassification interface {
	// GetCustomSetupBase returns the CustomSetupBase content of the underlying type.
	GetCustomSetupBase() *CustomSetupBase
}

// CustomSetupBase - The base definition of the custom setup.
type CustomSetupBase struct {
	// REQUIRED; The type of custom setup.
	Type *string `json:"type,omitempty"`
}

// GetCustomSetupBase implements the CustomSetupBaseClassification interface for type CustomSetupBase.
func (c *CustomSetupBase) GetCustomSetupBase() *CustomSetupBase { return c }

// DWCopyCommandDefaultValue - Default value.
type DWCopyCommandDefaultValue struct {
	// Column name. Type: object (or Expression with resultType string).
	ColumnName interface{} `json:"columnName,omitempty"`

	// The default value of the column. Type: object (or Expression with resultType string).
	DefaultValue interface{} `json:"defaultValue,omitempty"`
}

// DWCopyCommandSettings - DW Copy Command settings.
type DWCopyCommandSettings struct {
	// Additional options directly passed to SQL DW in Copy Command. Type: key value pairs (value should be string type) (or Expression
	// with resultType object). Example: "additionalOptions": { "MAXERRORS":
	// "1000", "DATEFORMAT": "'ymd'" }
	AdditionalOptions map[string]*string `json:"additionalOptions,omitempty"`

	// Specifies the default values for each target column in SQL DW. The default values in the property overwrite the DEFAULT
	// constraint set in the DB, and identity column cannot have a default value. Type:
	// array of objects (or Expression with resultType array of objects).
	DefaultValues []*DWCopyCommandDefaultValue `json:"defaultValues,omitempty"`
}

// DataFlowClassification provides polymorphic access to related types.
// Call the interface's GetDataFlow() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *DataFlow, *Flowlet, *MappingDataFlow, *WranglingDataFlow
type DataFlowClassification interface {
	// GetDataFlow returns the DataFlow content of the underlying type.
	GetDataFlow() *DataFlow
}

// DataFlow - Azure Data Factory nested object which contains a flow with data movements and transformations.
type DataFlow struct {
	// REQUIRED; Type of data flow.
	Type *string `json:"type,omitempty"`

	// List of tags that can be used for describing the data flow.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The description of the data flow.
	Description *string `json:"description,omitempty"`

	// The folder that this data flow is in. If not specified, Data flow will appear at the root level.
	Folder *DataFlowFolder `json:"folder,omitempty"`
}

// GetDataFlow implements the DataFlowClassification interface for type DataFlow.
func (d *DataFlow) GetDataFlow() *DataFlow { return d }

// DataFlowDebugCommandPayload - Structure of command payload.
type DataFlowDebugCommandPayload struct {
	// REQUIRED; The stream name which is used for preview.
	StreamName *string `json:"streamName,omitempty"`

	// Array of column names.
	Columns []*string `json:"columns,omitempty"`

	// The expression which is used for preview.
	Expression *string `json:"expression,omitempty"`

	// Row limits for preview response.
	RowLimits *int32 `json:"rowLimits,omitempty"`
}

// DataFlowDebugCommandRequest - Request body structure for data flow debug command.
type DataFlowDebugCommandRequest struct {
	// The command type.
	Command *DataFlowDebugCommandType `json:"command,omitempty"`

	// The command payload object.
	CommandPayload *DataFlowDebugCommandPayload `json:"commandPayload,omitempty"`

	// The ID of data flow debug session.
	SessionID *string `json:"sessionId,omitempty"`
}

// DataFlowDebugCommandResponse - Response body structure of data flow result for data preview, statistics or expression preview.
type DataFlowDebugCommandResponse struct {
	// The result data of data preview, statistics or expression preview.
	Data *string `json:"data,omitempty"`

	// The run status of data preview, statistics or expression preview.
	Status *string `json:"status,omitempty"`
}

// DataFlowDebugPackage - Request body structure for starting data flow debug session.
type DataFlowDebugPackage struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Data flow instance.
	DataFlow *DataFlowDebugResource `json:"dataFlow,omitempty"`

	// List of Data flows
	DataFlows []*DataFlowDebugResource `json:"dataFlows,omitempty"`

	// List of datasets.
	Datasets []*DatasetDebugResource `json:"datasets,omitempty"`

	// Data flow debug settings.
	DebugSettings *DataFlowDebugPackageDebugSettings `json:"debugSettings,omitempty"`

	// List of linked services.
	LinkedServices []*LinkedServiceDebugResource `json:"linkedServices,omitempty"`

	// The ID of data flow debug session.
	SessionID *string `json:"sessionId,omitempty"`

	// Staging info for debug session.
	Staging *DataFlowStagingInfo `json:"staging,omitempty"`
}

// DataFlowDebugPackageDebugSettings - Data flow debug settings.
type DataFlowDebugPackageDebugSettings struct {
	// Parameters for dataset.
	DatasetParameters interface{} `json:"datasetParameters,omitempty"`

	// Data flow parameters.
	Parameters map[string]interface{} `json:"parameters,omitempty"`

	// Source setting for data flow debug.
	SourceSettings []*DataFlowSourceSetting `json:"sourceSettings,omitempty"`
}

// DataFlowDebugResource - Data flow debug resource.
type DataFlowDebugResource struct {
	// REQUIRED; Data flow properties.
	Properties DataFlowClassification `json:"properties,omitempty"`

	// The resource name.
	Name *string `json:"name,omitempty"`
}

// DataFlowDebugSessionClientAddDataFlowOptions contains the optional parameters for the DataFlowDebugSessionClient.AddDataFlow
// method.
type DataFlowDebugSessionClientAddDataFlowOptions struct {
	// placeholder for future optional parameters
}

// DataFlowDebugSessionClientBeginCreateOptions contains the optional parameters for the DataFlowDebugSessionClient.BeginCreate
// method.
type DataFlowDebugSessionClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DataFlowDebugSessionClientBeginExecuteCommandOptions contains the optional parameters for the DataFlowDebugSessionClient.BeginExecuteCommand
// method.
type DataFlowDebugSessionClientBeginExecuteCommandOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DataFlowDebugSessionClientDeleteOptions contains the optional parameters for the DataFlowDebugSessionClient.Delete method.
type DataFlowDebugSessionClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DataFlowDebugSessionClientQueryByFactoryOptions contains the optional parameters for the DataFlowDebugSessionClient.QueryByFactory
// method.
type DataFlowDebugSessionClientQueryByFactoryOptions struct {
	// placeholder for future optional parameters
}

// DataFlowDebugSessionInfo - Data flow debug session info.
type DataFlowDebugSessionInfo struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Compute type of the cluster.
	ComputeType *string `json:"computeType,omitempty"`

	// Core count of the cluster.
	CoreCount *int32 `json:"coreCount,omitempty"`

	// The name of the data flow.
	DataFlowName *string `json:"dataFlowName,omitempty"`

	// Attached integration runtime name of data flow debug session.
	IntegrationRuntimeName *string `json:"integrationRuntimeName,omitempty"`

	// Last activity time of data flow debug session.
	LastActivityTime *string `json:"lastActivityTime,omitempty"`

	// Node count of the cluster. (deprecated property)
	NodeCount *int32 `json:"nodeCount,omitempty"`

	// The ID of data flow debug session.
	SessionID *string `json:"sessionId,omitempty"`

	// Start time of data flow debug session.
	StartTime *string `json:"startTime,omitempty"`

	// Compute type of the cluster.
	TimeToLiveInMinutes *int32 `json:"timeToLiveInMinutes,omitempty"`
}

// DataFlowFolder - The folder that this data flow is in. If not specified, Data flow will appear at the root level.
type DataFlowFolder struct {
	// The name of the folder that this data flow is in.
	Name *string `json:"name,omitempty"`
}

// DataFlowListResponse - A list of data flow resources.
type DataFlowListResponse struct {
	// REQUIRED; List of data flows.
	Value []*DataFlowResource `json:"value,omitempty"`

	// The link to the next page of results, if any remaining results exist.
	NextLink *string `json:"nextLink,omitempty"`
}

// DataFlowReference - Data flow reference type.
type DataFlowReference struct {
	// REQUIRED; Reference data flow name.
	ReferenceName *string `json:"referenceName,omitempty"`

	// REQUIRED; Data flow reference type.
	Type *DataFlowReferenceType `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Reference data flow parameters from dataset.
	DatasetParameters interface{} `json:"datasetParameters,omitempty"`

	// Data flow parameters
	Parameters map[string]interface{} `json:"parameters,omitempty"`
}

// DataFlowResource - Data flow resource type.
type DataFlowResource struct {
	// REQUIRED; Data flow properties.
	Properties DataFlowClassification `json:"properties,omitempty"`

	// READ-ONLY; Etag identifies change in the resource.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DataFlowSink - Transformation for data flow sink.
type DataFlowSink struct {
	// REQUIRED; Transformation name.
	Name *string `json:"name,omitempty"`

	// Dataset reference.
	Dataset *DatasetReference `json:"dataset,omitempty"`

	// Transformation description.
	Description *string `json:"description,omitempty"`

	// Flowlet Reference
	Flowlet *DataFlowReference `json:"flowlet,omitempty"`

	// Linked service reference.
	LinkedService *LinkedServiceReference `json:"linkedService,omitempty"`

	// Rejected data linked service reference.
	RejectedDataLinkedService *LinkedServiceReference `json:"rejectedDataLinkedService,omitempty"`

	// Schema linked service reference.
	SchemaLinkedService *LinkedServiceReference `json:"schemaLinkedService,omitempty"`
}

// DataFlowSource - Transformation for data flow source.
type DataFlowSource struct {
	// REQUIRED; Transformation name.
	Name *string `json:"name,omitempty"`

	// Dataset reference.
	Dataset *DatasetReference `json:"dataset,omitempty"`

	// Transformation description.
	Description *string `json:"description,omitempty"`

	// Flowlet Reference
	Flowlet *DataFlowReference `json:"flowlet,omitempty"`

	// Linked service reference.
	LinkedService *LinkedServiceReference `json:"linkedService,omitempty"`

	// Schema linked service reference.
	SchemaLinkedService *LinkedServiceReference `json:"schemaLinkedService,omitempty"`
}

// DataFlowSourceSetting - Definition of data flow source setting for debug.
type DataFlowSourceSetting struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Defines the row limit of data flow source in debug.
	RowLimit *int32 `json:"rowLimit,omitempty"`

	// The data flow source name.
	SourceName *string `json:"sourceName,omitempty"`
}

// DataFlowStagingInfo - Staging info for execute data flow activity.
type DataFlowStagingInfo struct {
	// Folder path for staging blob. Type: string (or Expression with resultType string)
	FolderPath interface{} `json:"folderPath,omitempty"`

	// Staging linked service reference.
	LinkedService *LinkedServiceReference `json:"linkedService,omitempty"`
}

// DataFlowsClientCreateOrUpdateOptions contains the optional parameters for the DataFlowsClient.CreateOrUpdate method.
type DataFlowsClientCreateOrUpdateOptions struct {
	// ETag of the data flow entity. Should only be specified for update, for which it should match existing entity or can be
	// * for unconditional update.
	IfMatch *string
}

// DataFlowsClientDeleteOptions contains the optional parameters for the DataFlowsClient.Delete method.
type DataFlowsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DataFlowsClientGetOptions contains the optional parameters for the DataFlowsClient.Get method.
type DataFlowsClientGetOptions struct {
	// ETag of the data flow entity. Should only be specified for get. If the ETag matches the existing entity tag, or if * was
	// provided, then no content will be returned.
	IfNoneMatch *string
}

// DataFlowsClientListByFactoryOptions contains the optional parameters for the DataFlowsClient.ListByFactory method.
type DataFlowsClientListByFactoryOptions struct {
	// placeholder for future optional parameters
}

// DataLakeAnalyticsUSQLActivity - Data Lake Analytics U-SQL activity.
type DataLakeAnalyticsUSQLActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Data Lake Analytics U-SQL activity properties.
	TypeProperties *DataLakeAnalyticsUSQLActivityTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type DataLakeAnalyticsUSQLActivity.
func (d *DataLakeAnalyticsUSQLActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 d.Name,
		Type:                 d.Type,
		Description:          d.Description,
		DependsOn:            d.DependsOn,
		UserProperties:       d.UserProperties,
		AdditionalProperties: d.AdditionalProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type DataLakeAnalyticsUSQLActivity.
func (d *DataLakeAnalyticsUSQLActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		LinkedServiceName:    d.LinkedServiceName,
		Policy:               d.Policy,
		Name:                 d.Name,
		Type:                 d.Type,
		Description:          d.Description,
		DependsOn:            d.DependsOn,
		UserProperties:       d.UserProperties,
		AdditionalProperties: d.AdditionalProperties,
	}
}

// DataLakeAnalyticsUSQLActivityTypeProperties - DataLakeAnalyticsU-SQL activity properties.
type DataLakeAnalyticsUSQLActivityTypeProperties struct {
	// REQUIRED; Script linked service reference.
	ScriptLinkedService *LinkedServiceReference `json:"scriptLinkedService,omitempty"`

	// REQUIRED; Case-sensitive path to folder that contains the U-SQL script. Type: string (or Expression with resultType string).
	ScriptPath interface{} `json:"scriptPath,omitempty"`

	// Compilation mode of U-SQL. Must be one of these values : Semantic, Full and SingleBox. Type: string (or Expression with
	// resultType string).
	CompilationMode interface{} `json:"compilationMode,omitempty"`

	// The maximum number of nodes simultaneously used to run the job. Default value is 1. Type: integer (or Expression with resultType
	// integer), minimum: 1.
	DegreeOfParallelism interface{} `json:"degreeOfParallelism,omitempty"`

	// Parameters for U-SQL job request.
	Parameters map[string]interface{} `json:"parameters,omitempty"`

	// Determines which jobs out of all that are queued should be selected to run first. The lower the number, the higher the
	// priority. Default value is 1000. Type: integer (or Expression with resultType
	// integer), minimum: 1.
	Priority interface{} `json:"priority,omitempty"`

	// Runtime version of the U-SQL engine to use. Type: string (or Expression with resultType string).
	RuntimeVersion interface{} `json:"runtimeVersion,omitempty"`
}

// DatabricksNotebookActivity - DatabricksNotebook activity.
type DatabricksNotebookActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Databricks Notebook activity properties.
	TypeProperties *DatabricksNotebookActivityTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type DatabricksNotebookActivity.
func (d *DatabricksNotebookActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 d.Name,
		Type:                 d.Type,
		Description:          d.Description,
		DependsOn:            d.DependsOn,
		UserProperties:       d.UserProperties,
		AdditionalProperties: d.AdditionalProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type DatabricksNotebookActivity.
func (d *DatabricksNotebookActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		LinkedServiceName:    d.LinkedServiceName,
		Policy:               d.Policy,
		Name:                 d.Name,
		Type:                 d.Type,
		Description:          d.Description,
		DependsOn:            d.DependsOn,
		UserProperties:       d.UserProperties,
		AdditionalProperties: d.AdditionalProperties,
	}
}

// DatabricksNotebookActivityTypeProperties - Databricks Notebook activity properties.
type DatabricksNotebookActivityTypeProperties struct {
	// REQUIRED; The absolute path of the notebook to be run in the Databricks Workspace. This path must begin with a slash. Type:
	// string (or Expression with resultType string).
	NotebookPath interface{} `json:"notebookPath,omitempty"`

	// Base parameters to be used for each run of this job.If the notebook takes a parameter that is not specified, the default
	// value from the notebook will be used.
	BaseParameters map[string]interface{} `json:"baseParameters,omitempty"`

	// A list of libraries to be installed on the cluster that will execute the job.
	Libraries []map[string]interface{} `json:"libraries,omitempty"`
}

// DatabricksSparkJarActivity - DatabricksSparkJar activity.
type DatabricksSparkJarActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Databricks SparkJar activity properties.
	TypeProperties *DatabricksSparkJarActivityTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type DatabricksSparkJarActivity.
func (d *DatabricksSparkJarActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 d.Name,
		Type:                 d.Type,
		Description:          d.Description,
		DependsOn:            d.DependsOn,
		UserProperties:       d.UserProperties,
		AdditionalProperties: d.AdditionalProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type DatabricksSparkJarActivity.
func (d *DatabricksSparkJarActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		LinkedServiceName:    d.LinkedServiceName,
		Policy:               d.Policy,
		Name:                 d.Name,
		Type:                 d.Type,
		Description:          d.Description,
		DependsOn:            d.DependsOn,
		UserProperties:       d.UserProperties,
		AdditionalProperties: d.AdditionalProperties,
	}
}

// DatabricksSparkJarActivityTypeProperties - Databricks SparkJar activity properties.
type DatabricksSparkJarActivityTypeProperties struct {
	// REQUIRED; The full name of the class containing the main method to be executed. This class must be contained in a JAR provided
	// as a library. Type: string (or Expression with resultType string).
	MainClassName interface{} `json:"mainClassName,omitempty"`

	// A list of libraries to be installed on the cluster that will execute the job.
	Libraries []map[string]interface{} `json:"libraries,omitempty"`

	// Parameters that will be passed to the main method.
	Parameters []interface{} `json:"parameters,omitempty"`
}

// DatabricksSparkPythonActivity - DatabricksSparkPython activity.
type DatabricksSparkPythonActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Databricks SparkPython activity properties.
	TypeProperties *DatabricksSparkPythonActivityTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type DatabricksSparkPythonActivity.
func (d *DatabricksSparkPythonActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 d.Name,
		Type:                 d.Type,
		Description:          d.Description,
		DependsOn:            d.DependsOn,
		UserProperties:       d.UserProperties,
		AdditionalProperties: d.AdditionalProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type DatabricksSparkPythonActivity.
func (d *DatabricksSparkPythonActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		LinkedServiceName:    d.LinkedServiceName,
		Policy:               d.Policy,
		Name:                 d.Name,
		Type:                 d.Type,
		Description:          d.Description,
		DependsOn:            d.DependsOn,
		UserProperties:       d.UserProperties,
		AdditionalProperties: d.AdditionalProperties,
	}
}

// DatabricksSparkPythonActivityTypeProperties - Databricks SparkPython activity properties.
type DatabricksSparkPythonActivityTypeProperties struct {
	// REQUIRED; The URI of the Python file to be executed. DBFS paths are supported. Type: string (or Expression with resultType
	// string).
	PythonFile interface{} `json:"pythonFile,omitempty"`

	// A list of libraries to be installed on the cluster that will execute the job.
	Libraries []map[string]interface{} `json:"libraries,omitempty"`

	// Command line parameters that will be passed to the Python file.
	Parameters []interface{} `json:"parameters,omitempty"`
}

// DatasetClassification provides polymorphic access to related types.
// Call the interface's GetDataset() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AmazonMWSObjectDataset, *AmazonRdsForOracleTableDataset, *AmazonRdsForSQLServerTableDataset, *AmazonRedshiftTableDataset,
// - *AmazonS3Dataset, *AvroDataset, *AzureBlobDataset, *AzureBlobFSDataset, *AzureDataExplorerTableDataset, *AzureDataLakeStoreDataset,
// - *AzureDatabricksDeltaLakeDataset, *AzureMariaDBTableDataset, *AzureMySQLTableDataset, *AzurePostgreSQLTableDataset, *AzureSQLDWTableDataset,
// - *AzureSQLMITableDataset, *AzureSQLTableDataset, *AzureSearchIndexDataset, *AzureTableDataset, *BinaryDataset, *CassandraTableDataset,
// - *CommonDataServiceForAppsEntityDataset, *ConcurObjectDataset, *CosmosDbMongoDbAPICollectionDataset, *CosmosDbSQLAPICollectionDataset,
// - *CouchbaseTableDataset, *CustomDataset, *Dataset, *Db2TableDataset, *DelimitedTextDataset, *DocumentDbCollectionDataset,
// - *DrillTableDataset, *DynamicsAXResourceDataset, *DynamicsCrmEntityDataset, *DynamicsEntityDataset, *EloquaObjectDataset,
// - *ExcelDataset, *FileShareDataset, *GoogleAdWordsObjectDataset, *GoogleBigQueryObjectDataset, *GreenplumTableDataset,
// - *HBaseObjectDataset, *HTTPDataset, *HiveObjectDataset, *HubspotObjectDataset, *ImpalaObjectDataset, *InformixTableDataset,
// - *JSONDataset, *JiraObjectDataset, *MagentoObjectDataset, *MariaDBTableDataset, *MarketoObjectDataset, *MicrosoftAccessTableDataset,
// - *MongoDbAtlasCollectionDataset, *MongoDbCollectionDataset, *MongoDbV2CollectionDataset, *MySQLTableDataset, *NetezzaTableDataset,
// - *ODataResourceDataset, *OdbcTableDataset, *Office365Dataset, *OracleServiceCloudObjectDataset, *OracleTableDataset, *OrcDataset,
// - *ParquetDataset, *PaypalObjectDataset, *PhoenixObjectDataset, *PostgreSQLTableDataset, *PrestoObjectDataset, *QuickBooksObjectDataset,
// - *RelationalTableDataset, *ResponsysObjectDataset, *RestResourceDataset, *SQLServerTableDataset, *SalesforceMarketingCloudObjectDataset,
// - *SalesforceObjectDataset, *SalesforceServiceCloudObjectDataset, *SapBwCubeDataset, *SapCloudForCustomerResourceDataset,
// - *SapEccResourceDataset, *SapHanaTableDataset, *SapOdpResourceDataset, *SapOpenHubTableDataset, *SapTableResourceDataset,
// - *ServiceNowObjectDataset, *SharePointOnlineListResourceDataset, *ShopifyObjectDataset, *SnowflakeDataset, *SparkObjectDataset,
// - *SquareObjectDataset, *SybaseTableDataset, *TeradataTableDataset, *VerticaTableDataset, *WebTableDataset, *XMLDataset,
// - *XeroObjectDataset, *ZohoObjectDataset
type DatasetClassification interface {
	// GetDataset returns the Dataset content of the underlying type.
	GetDataset() *Dataset
}

// Dataset - The Azure Data Factory nested object which identifies data within different data stores, such as tables, files,
// folders, and documents.
type Dataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type Dataset.
func (d *Dataset) GetDataset() *Dataset { return d }

// DatasetCompression - The compression method used on a dataset.
type DatasetCompression struct {
	// REQUIRED; Type of dataset compression. Type: string (or Expression with resultType string).
	Type interface{} `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// The dataset compression level. Type: string (or Expression with resultType string).
	Level interface{} `json:"level,omitempty"`
}

// DatasetDebugResource - Dataset debug resource.
type DatasetDebugResource struct {
	// REQUIRED; Dataset properties.
	Properties DatasetClassification `json:"properties,omitempty"`

	// The resource name.
	Name *string `json:"name,omitempty"`
}

// DatasetFolder - The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
type DatasetFolder struct {
	// The name of the folder that this Dataset is in.
	Name *string `json:"name,omitempty"`
}

// DatasetListResponse - A list of dataset resources.
type DatasetListResponse struct {
	// REQUIRED; List of datasets.
	Value []*DatasetResource `json:"value,omitempty"`

	// The link to the next page of results, if any remaining results exist.
	NextLink *string `json:"nextLink,omitempty"`
}

// DatasetLocationClassification provides polymorphic access to related types.
// Call the interface's GetDatasetLocation() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AmazonS3CompatibleLocation, *AmazonS3Location, *AzureBlobFSLocation, *AzureBlobStorageLocation, *AzureDataLakeStoreLocation,
// - *AzureFileStorageLocation, *DatasetLocation, *FileServerLocation, *FtpServerLocation, *GoogleCloudStorageLocation, *HTTPServerLocation,
// - *HdfsLocation, *OracleCloudStorageLocation, *SftpLocation
type DatasetLocationClassification interface {
	// GetDatasetLocation returns the DatasetLocation content of the underlying type.
	GetDatasetLocation() *DatasetLocation
}

// DatasetLocation - Dataset location.
type DatasetLocation struct {
	// REQUIRED; Type of dataset storage location.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`

	// Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath interface{} `json:"folderPath,omitempty"`
}

// GetDatasetLocation implements the DatasetLocationClassification interface for type DatasetLocation.
func (d *DatasetLocation) GetDatasetLocation() *DatasetLocation { return d }

// DatasetReference - Dataset reference type.
type DatasetReference struct {
	// REQUIRED; Reference dataset name.
	ReferenceName *string `json:"referenceName,omitempty"`

	// REQUIRED; Dataset reference type.
	Type *DatasetReferenceType `json:"type,omitempty"`

	// Arguments for dataset.
	Parameters map[string]interface{} `json:"parameters,omitempty"`
}

// DatasetResource - Dataset resource type.
type DatasetResource struct {
	// REQUIRED; Dataset properties.
	Properties DatasetClassification `json:"properties,omitempty"`

	// READ-ONLY; Etag identifies change in the resource.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DatasetStorageFormatClassification provides polymorphic access to related types.
// Call the interface's GetDatasetStorageFormat() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AvroFormat, *DatasetStorageFormat, *JSONFormat, *OrcFormat, *ParquetFormat, *TextFormat
type DatasetStorageFormatClassification interface {
	// GetDatasetStorageFormat returns the DatasetStorageFormat content of the underlying type.
	GetDatasetStorageFormat() *DatasetStorageFormat
}

// DatasetStorageFormat - The format definition of a storage.
type DatasetStorageFormat struct {
	// REQUIRED; Type of dataset storage format.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Deserializer. Type: string (or Expression with resultType string).
	Deserializer interface{} `json:"deserializer,omitempty"`

	// Serializer. Type: string (or Expression with resultType string).
	Serializer interface{} `json:"serializer,omitempty"`
}

// GetDatasetStorageFormat implements the DatasetStorageFormatClassification interface for type DatasetStorageFormat.
func (d *DatasetStorageFormat) GetDatasetStorageFormat() *DatasetStorageFormat { return d }

// DatasetsClientCreateOrUpdateOptions contains the optional parameters for the DatasetsClient.CreateOrUpdate method.
type DatasetsClientCreateOrUpdateOptions struct {
	// ETag of the dataset entity. Should only be specified for update, for which it should match existing entity or can be *
	// for unconditional update.
	IfMatch *string
}

// DatasetsClientDeleteOptions contains the optional parameters for the DatasetsClient.Delete method.
type DatasetsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DatasetsClientGetOptions contains the optional parameters for the DatasetsClient.Get method.
type DatasetsClientGetOptions struct {
	// ETag of the dataset entity. Should only be specified for get. If the ETag matches the existing entity tag, or if * was
	// provided, then no content will be returned.
	IfNoneMatch *string
}

// DatasetsClientListByFactoryOptions contains the optional parameters for the DatasetsClient.ListByFactory method.
type DatasetsClientListByFactoryOptions struct {
	// placeholder for future optional parameters
}

// DataworldLinkedService - Linked service for Dataworld.
type DataworldLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Dataworld linked service properties.
	TypeProperties *DataworldLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type DataworldLinkedService.
func (d *DataworldLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 d.Type,
		ConnectVia:           d.ConnectVia,
		Description:          d.Description,
		Parameters:           d.Parameters,
		Annotations:          d.Annotations,
		AdditionalProperties: d.AdditionalProperties,
	}
}

// DataworldLinkedServiceTypeProperties - Dataworld linked service type properties.
type DataworldLinkedServiceTypeProperties struct {
	// REQUIRED; The api token for the Dataworld source.
	APIToken SecretBaseClassification `json:"apiToken,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// Db2LinkedService - Linked service for DB2 data source.
type Db2LinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; DB2 linked service properties.
	TypeProperties *Db2LinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type Db2LinkedService.
func (d *Db2LinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 d.Type,
		ConnectVia:           d.ConnectVia,
		Description:          d.Description,
		Parameters:           d.Parameters,
		Annotations:          d.Annotations,
		AdditionalProperties: d.AdditionalProperties,
	}
}

// Db2LinkedServiceTypeProperties - DB2 linked service properties.
type Db2LinkedServiceTypeProperties struct {
	// AuthenticationType to be used for connection. It is mutually exclusive with connectionString property.
	AuthenticationType *Db2AuthenticationType `json:"authenticationType,omitempty"`

	// Certificate Common Name when TLS is enabled. It is mutually exclusive with connectionString property. Type: string (or
	// Expression with resultType string).
	CertificateCommonName interface{} `json:"certificateCommonName,omitempty"`

	// The connection string. It is mutually exclusive with server, database, authenticationType, userName, packageCollection
	// and certificateCommonName property. Type: string, SecureString or
	// AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`

	// Database name for connection. It is mutually exclusive with connectionString property. Type: string (or Expression with
	// resultType string).
	Database interface{} `json:"database,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// It is mutually exclusive with connectionString property. Type: string (or
	// Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// Under where packages are created when querying database. It is mutually exclusive with connectionString property. Type:
	// string (or Expression with resultType string).
	PackageCollection interface{} `json:"packageCollection,omitempty"`

	// Password for authentication.
	Password SecretBaseClassification `json:"password,omitempty"`

	// Server name for connection. It is mutually exclusive with connectionString property. Type: string (or Expression with resultType
	// string).
	Server interface{} `json:"server,omitempty"`

	// Username for authentication. It is mutually exclusive with connectionString property. Type: string (or Expression with
	// resultType string).
	Username interface{} `json:"username,omitempty"`
}

// Db2Source - A copy activity source for Db2 databases.
type Db2Source struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Database query. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type Db2Source.
func (d *Db2Source) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     d.Type,
		SourceRetryCount:         d.SourceRetryCount,
		SourceRetryWait:          d.SourceRetryWait,
		MaxConcurrentConnections: d.MaxConcurrentConnections,
		DisableMetricsCollection: d.DisableMetricsCollection,
		AdditionalProperties:     d.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type Db2Source.
func (d *Db2Source) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             d.QueryTimeout,
		AdditionalColumns:        d.AdditionalColumns,
		Type:                     d.Type,
		SourceRetryCount:         d.SourceRetryCount,
		SourceRetryWait:          d.SourceRetryWait,
		MaxConcurrentConnections: d.MaxConcurrentConnections,
		DisableMetricsCollection: d.DisableMetricsCollection,
		AdditionalProperties:     d.AdditionalProperties,
	}
}

// Db2TableDataset - The Db2 table dataset.
type Db2TableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Db2 table dataset properties.
	TypeProperties *Db2TableDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type Db2TableDataset.
func (d *Db2TableDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 d.Type,
		Description:          d.Description,
		Structure:            d.Structure,
		Schema:               d.Schema,
		LinkedServiceName:    d.LinkedServiceName,
		Parameters:           d.Parameters,
		Annotations:          d.Annotations,
		Folder:               d.Folder,
		AdditionalProperties: d.AdditionalProperties,
	}
}

// Db2TableDatasetTypeProperties - Db2 table dataset properties.
type Db2TableDatasetTypeProperties struct {
	// The Db2 schema name. Type: string (or Expression with resultType string).
	Schema interface{} `json:"schema,omitempty"`

	// The Db2 table name. Type: string (or Expression with resultType string).
	Table interface{} `json:"table,omitempty"`

	// This property will be retired. Please consider using schema + table properties instead.
	TableName interface{} `json:"tableName,omitempty"`
}

// DeleteActivity - Delete activity.
type DeleteActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Delete activity properties.
	TypeProperties *DeleteActivityTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type DeleteActivity.
func (d *DeleteActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 d.Name,
		Type:                 d.Type,
		Description:          d.Description,
		DependsOn:            d.DependsOn,
		UserProperties:       d.UserProperties,
		AdditionalProperties: d.AdditionalProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type DeleteActivity.
func (d *DeleteActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		LinkedServiceName:    d.LinkedServiceName,
		Policy:               d.Policy,
		Name:                 d.Name,
		Type:                 d.Type,
		Description:          d.Description,
		DependsOn:            d.DependsOn,
		UserProperties:       d.UserProperties,
		AdditionalProperties: d.AdditionalProperties,
	}
}

// DeleteActivityTypeProperties - Delete activity properties.
type DeleteActivityTypeProperties struct {
	// REQUIRED; Delete activity dataset reference.
	Dataset *DatasetReference `json:"dataset,omitempty"`

	// Whether to record detailed logs of delete-activity execution. Default value is false. Type: boolean (or Expression with
	// resultType boolean).
	EnableLogging interface{} `json:"enableLogging,omitempty"`

	// Log storage settings customer need to provide when enableLogging is true.
	LogStorageSettings *LogStorageSettings `json:"logStorageSettings,omitempty"`

	// The max concurrent connections to connect data source at the same time.
	MaxConcurrentConnections *int32 `json:"maxConcurrentConnections,omitempty"`

	// If true, files or sub-folders under current folder path will be deleted recursively. Default is false. Type: boolean (or
	// Expression with resultType boolean).
	Recursive interface{} `json:"recursive,omitempty"`

	// Delete activity store settings.
	StoreSettings StoreReadSettingsClassification `json:"storeSettings,omitempty"`
}

// DeleteDataFlowDebugSessionRequest - Request body structure for deleting data flow debug session.
type DeleteDataFlowDebugSessionRequest struct {
	// The ID of data flow debug session.
	SessionID *string `json:"sessionId,omitempty"`
}

// DelimitedTextDataset - Delimited text dataset.
type DelimitedTextDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Delimited text dataset properties.
	TypeProperties *DelimitedTextDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type DelimitedTextDataset.
func (d *DelimitedTextDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 d.Type,
		Description:          d.Description,
		Structure:            d.Structure,
		Schema:               d.Schema,
		LinkedServiceName:    d.LinkedServiceName,
		Parameters:           d.Parameters,
		Annotations:          d.Annotations,
		Folder:               d.Folder,
		AdditionalProperties: d.AdditionalProperties,
	}
}

// DelimitedTextDatasetTypeProperties - DelimitedText dataset properties.
type DelimitedTextDatasetTypeProperties struct {
	// REQUIRED; The location of the delimited text storage.
	Location DatasetLocationClassification `json:"location,omitempty"`

	// The column delimiter. Type: string (or Expression with resultType string).
	ColumnDelimiter interface{} `json:"columnDelimiter,omitempty"`

	// The data compressionCodec. Type: string (or Expression with resultType string).
	CompressionCodec interface{} `json:"compressionCodec,omitempty"`

	// The data compression method used for DelimitedText.
	CompressionLevel interface{} `json:"compressionLevel,omitempty"`

	// The code page name of the preferred encoding. If miss, the default value is UTF-8, unless BOM denotes another Unicode encoding.
	// Refer to the name column of the table in the following link to set
	// supported values: https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string (or Expression with resultType
	// string).
	EncodingName interface{} `json:"encodingName,omitempty"`

	// The escape character. Type: string (or Expression with resultType string).
	EscapeChar interface{} `json:"escapeChar,omitempty"`

	// When used as input, treat the first row of data as headers. When used as output,write the headers into the output as the
	// first row of data. The default value is false. Type: boolean (or Expression
	// with resultType boolean).
	FirstRowAsHeader interface{} `json:"firstRowAsHeader,omitempty"`

	// The null value string. Type: string (or Expression with resultType string).
	NullValue interface{} `json:"nullValue,omitempty"`

	// The quote character. Type: string (or Expression with resultType string).
	QuoteChar interface{} `json:"quoteChar,omitempty"`

	// The row delimiter. Type: string (or Expression with resultType string).
	RowDelimiter interface{} `json:"rowDelimiter,omitempty"`
}

// DelimitedTextReadSettings - Delimited text read settings.
type DelimitedTextReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Compression settings.
	CompressionProperties CompressionReadSettingsClassification `json:"compressionProperties,omitempty"`

	// Indicates the number of non-empty rows to skip when reading data from input files. Type: integer (or Expression with resultType
	// integer).
	SkipLineCount interface{} `json:"skipLineCount,omitempty"`
}

// GetFormatReadSettings implements the FormatReadSettingsClassification interface for type DelimitedTextReadSettings.
func (d *DelimitedTextReadSettings) GetFormatReadSettings() *FormatReadSettings {
	return &FormatReadSettings{
		Type:                 d.Type,
		AdditionalProperties: d.AdditionalProperties,
	}
}

// DelimitedTextSink - A copy activity DelimitedText sink.
type DelimitedTextSink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// DelimitedText format settings.
	FormatSettings *DelimitedTextWriteSettings `json:"formatSettings,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// DelimitedText store settings.
	StoreSettings StoreWriteSettingsClassification `json:"storeSettings,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type DelimitedTextSink.
func (d *DelimitedTextSink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     d.Type,
		WriteBatchSize:           d.WriteBatchSize,
		WriteBatchTimeout:        d.WriteBatchTimeout,
		SinkRetryCount:           d.SinkRetryCount,
		SinkRetryWait:            d.SinkRetryWait,
		MaxConcurrentConnections: d.MaxConcurrentConnections,
		DisableMetricsCollection: d.DisableMetricsCollection,
		AdditionalProperties:     d.AdditionalProperties,
	}
}

// DelimitedTextSource - A copy activity DelimitedText source.
type DelimitedTextSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// DelimitedText format settings.
	FormatSettings *DelimitedTextReadSettings `json:"formatSettings,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`

	// DelimitedText store settings.
	StoreSettings StoreReadSettingsClassification `json:"storeSettings,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type DelimitedTextSource.
func (d *DelimitedTextSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     d.Type,
		SourceRetryCount:         d.SourceRetryCount,
		SourceRetryWait:          d.SourceRetryWait,
		MaxConcurrentConnections: d.MaxConcurrentConnections,
		DisableMetricsCollection: d.DisableMetricsCollection,
		AdditionalProperties:     d.AdditionalProperties,
	}
}

// DelimitedTextWriteSettings - Delimited text write settings.
type DelimitedTextWriteSettings struct {
	// REQUIRED; The file extension used to create the files. Type: string (or Expression with resultType string).
	FileExtension interface{} `json:"fileExtension,omitempty"`

	// REQUIRED; The write setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Specifies the file name pattern _. when copy from non-file based store without partitionOptions. Type: string (or Expression
	// with resultType string).
	FileNamePrefix interface{} `json:"fileNamePrefix,omitempty"`

	// Limit the written file's row count to be smaller than or equal to the specified count. Type: integer (or Expression with
	// resultType integer).
	MaxRowsPerFile interface{} `json:"maxRowsPerFile,omitempty"`

	// Indicates whether string values should always be enclosed with quotes. Type: boolean (or Expression with resultType boolean).
	QuoteAllText interface{} `json:"quoteAllText,omitempty"`
}

// GetFormatWriteSettings implements the FormatWriteSettingsClassification interface for type DelimitedTextWriteSettings.
func (d *DelimitedTextWriteSettings) GetFormatWriteSettings() *FormatWriteSettings {
	return &FormatWriteSettings{
		Type:                 d.Type,
		AdditionalProperties: d.AdditionalProperties,
	}
}

// DependencyReferenceClassification provides polymorphic access to related types.
// Call the interface's GetDependencyReference() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *DependencyReference, *SelfDependencyTumblingWindowTriggerReference, *TriggerDependencyReference, *TumblingWindowTriggerDependencyReference
type DependencyReferenceClassification interface {
	// GetDependencyReference returns the DependencyReference content of the underlying type.
	GetDependencyReference() *DependencyReference
}

// DependencyReference - Referenced dependency.
type DependencyReference struct {
	// REQUIRED; The type of dependency reference.
	Type *string `json:"type,omitempty"`
}

// GetDependencyReference implements the DependencyReferenceClassification interface for type DependencyReference.
func (d *DependencyReference) GetDependencyReference() *DependencyReference { return d }

// DistcpSettings - Distcp settings.
type DistcpSettings struct {
	// REQUIRED; Specifies the Yarn ResourceManager endpoint. Type: string (or Expression with resultType string).
	ResourceManagerEndpoint interface{} `json:"resourceManagerEndpoint,omitempty"`

	// REQUIRED; Specifies an existing folder path which will be used to store temp Distcp command script. The script file is
	// generated by ADF and will be removed after Copy job finished. Type: string (or Expression
	// with resultType string).
	TempScriptPath interface{} `json:"tempScriptPath,omitempty"`

	// Specifies the Distcp options. Type: string (or Expression with resultType string).
	DistcpOptions interface{} `json:"distcpOptions,omitempty"`
}

// DocumentDbCollectionDataset - Microsoft Azure Document Database Collection dataset.
type DocumentDbCollectionDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// REQUIRED; DocumentDB Collection dataset properties.
	TypeProperties *DocumentDbCollectionDatasetTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type DocumentDbCollectionDataset.
func (d *DocumentDbCollectionDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 d.Type,
		Description:          d.Description,
		Structure:            d.Structure,
		Schema:               d.Schema,
		LinkedServiceName:    d.LinkedServiceName,
		Parameters:           d.Parameters,
		Annotations:          d.Annotations,
		Folder:               d.Folder,
		AdditionalProperties: d.AdditionalProperties,
	}
}

// DocumentDbCollectionDatasetTypeProperties - DocumentDB Collection dataset properties.
type DocumentDbCollectionDatasetTypeProperties struct {
	// REQUIRED; Document Database collection name. Type: string (or Expression with resultType string).
	CollectionName interface{} `json:"collectionName,omitempty"`
}

// DocumentDbCollectionSink - A copy activity Document Database Collection sink.
type DocumentDbCollectionSink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Nested properties separator. Default is . (dot). Type: string (or Expression with resultType string).
	NestingSeparator interface{} `json:"nestingSeparator,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`

	// Describes how to write data to Azure Cosmos DB. Type: string (or Expression with resultType string). Allowed values: insert
	// and upsert.
	WriteBehavior interface{} `json:"writeBehavior,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type DocumentDbCollectionSink.
func (d *DocumentDbCollectionSink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     d.Type,
		WriteBatchSize:           d.WriteBatchSize,
		WriteBatchTimeout:        d.WriteBatchTimeout,
		SinkRetryCount:           d.SinkRetryCount,
		SinkRetryWait:            d.SinkRetryWait,
		MaxConcurrentConnections: d.MaxConcurrentConnections,
		DisableMetricsCollection: d.DisableMetricsCollection,
		AdditionalProperties:     d.AdditionalProperties,
	}
}

// DocumentDbCollectionSource - A copy activity Document Database Collection source.
type DocumentDbCollectionSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Nested properties separator. Type: string (or Expression with resultType string).
	NestingSeparator interface{} `json:"nestingSeparator,omitempty"`

	// Documents query. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type DocumentDbCollectionSource.
func (d *DocumentDbCollectionSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     d.Type,
		SourceRetryCount:         d.SourceRetryCount,
		SourceRetryWait:          d.SourceRetryWait,
		MaxConcurrentConnections: d.MaxConcurrentConnections,
		DisableMetricsCollection: d.DisableMetricsCollection,
		AdditionalProperties:     d.AdditionalProperties,
	}
}

// DrillDatasetTypeProperties - Drill Dataset Properties
type DrillDatasetTypeProperties struct {
	// The schema name of the Drill. Type: string (or Expression with resultType string).
	Schema interface{} `json:"schema,omitempty"`

	// The table name of the Drill. Type: string (or Expression with resultType string).
	Table interface{} `json:"table,omitempty"`

	// This property will be retired. Please consider using schema + table properties instead.
	TableName interface{} `json:"tableName,omitempty"`
}

// DrillLinkedService - Drill server linked service.
type DrillLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Drill server linked service properties.
	TypeProperties *DrillLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type DrillLinkedService.
func (d *DrillLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 d.Type,
		ConnectVia:           d.ConnectVia,
		Description:          d.Description,
		Parameters:           d.Parameters,
		Annotations:          d.Annotations,
		AdditionalProperties: d.AdditionalProperties,
	}
}

// DrillLinkedServiceTypeProperties - Drill server linked service properties.
type DrillLinkedServiceTypeProperties struct {
	// An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The Azure key vault secret reference of password in connection string.
	Pwd *AzureKeyVaultSecretReference `json:"pwd,omitempty"`
}

// DrillSource - A copy activity Drill server source.
type DrillSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type DrillSource.
func (d *DrillSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     d.Type,
		SourceRetryCount:         d.SourceRetryCount,
		SourceRetryWait:          d.SourceRetryWait,
		MaxConcurrentConnections: d.MaxConcurrentConnections,
		DisableMetricsCollection: d.DisableMetricsCollection,
		AdditionalProperties:     d.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type DrillSource.
func (d *DrillSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             d.QueryTimeout,
		AdditionalColumns:        d.AdditionalColumns,
		Type:                     d.Type,
		SourceRetryCount:         d.SourceRetryCount,
		SourceRetryWait:          d.SourceRetryWait,
		MaxConcurrentConnections: d.MaxConcurrentConnections,
		DisableMetricsCollection: d.DisableMetricsCollection,
		AdditionalProperties:     d.AdditionalProperties,
	}
}

// DrillTableDataset - Drill server dataset.
type DrillTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Properties specific to this dataset type.
	TypeProperties *DrillDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type DrillTableDataset.
func (d *DrillTableDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 d.Type,
		Description:          d.Description,
		Structure:            d.Structure,
		Schema:               d.Schema,
		LinkedServiceName:    d.LinkedServiceName,
		Parameters:           d.Parameters,
		Annotations:          d.Annotations,
		Folder:               d.Folder,
		AdditionalProperties: d.AdditionalProperties,
	}
}

// DynamicsAXLinkedService - Dynamics AX linked service.
type DynamicsAXLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Dynamics AX linked service properties.
	TypeProperties *DynamicsAXLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type DynamicsAXLinkedService.
func (d *DynamicsAXLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 d.Type,
		ConnectVia:           d.ConnectVia,
		Description:          d.Description,
		Parameters:           d.Parameters,
		Annotations:          d.Annotations,
		AdditionalProperties: d.AdditionalProperties,
	}
}

// DynamicsAXLinkedServiceTypeProperties - Dynamics AX linked service properties.
type DynamicsAXLinkedServiceTypeProperties struct {
	// REQUIRED; Specify the resource you are requesting authorization. Type: string (or Expression with resultType string).
	AADResourceID interface{} `json:"aadResourceId,omitempty"`

	// REQUIRED; Specify the application's client ID. Type: string (or Expression with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`

	// REQUIRED; Specify the application's key. Mark this field as a SecureString to store it securely in Data Factory, or reference
	// a secret stored in Azure Key Vault. Type: string (or Expression with resultType
	// string).
	ServicePrincipalKey SecretBaseClassification `json:"servicePrincipalKey,omitempty"`

	// REQUIRED; Specify the tenant information (domain name or tenant ID) under which your application resides. Retrieve it by
	// hovering the mouse in the top-right corner of the Azure portal. Type: string (or
	// Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`

	// REQUIRED; The Dynamics AX (or Dynamics 365 Finance and Operations) instance OData endpoint.
	URL interface{} `json:"url,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// DynamicsAXResourceDataset - The path of the Dynamics AX OData entity.
type DynamicsAXResourceDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Dynamics AX OData resource dataset properties.
	TypeProperties *DynamicsAXResourceDatasetTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type DynamicsAXResourceDataset.
func (d *DynamicsAXResourceDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 d.Type,
		Description:          d.Description,
		Structure:            d.Structure,
		Schema:               d.Schema,
		LinkedServiceName:    d.LinkedServiceName,
		Parameters:           d.Parameters,
		Annotations:          d.Annotations,
		Folder:               d.Folder,
		AdditionalProperties: d.AdditionalProperties,
	}
}

// DynamicsAXResourceDatasetTypeProperties - Dynamics AX OData resource dataset properties.
type DynamicsAXResourceDatasetTypeProperties struct {
	// REQUIRED; The path of the Dynamics AX OData entity. Type: string (or Expression with resultType string).
	Path interface{} `json:"path,omitempty"`
}

// DynamicsAXSource - A copy activity Dynamics AX source.
type DynamicsAXSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The timeout (TimeSpan) to get an HTTP response. It is the timeout to get a response, not the timeout to read response data.
	// Default value: 00:05:00. Type: string (or Expression with resultType
	// string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	HTTPRequestTimeout interface{} `json:"httpRequestTimeout,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type DynamicsAXSource.
func (d *DynamicsAXSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     d.Type,
		SourceRetryCount:         d.SourceRetryCount,
		SourceRetryWait:          d.SourceRetryWait,
		MaxConcurrentConnections: d.MaxConcurrentConnections,
		DisableMetricsCollection: d.DisableMetricsCollection,
		AdditionalProperties:     d.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type DynamicsAXSource.
func (d *DynamicsAXSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             d.QueryTimeout,
		AdditionalColumns:        d.AdditionalColumns,
		Type:                     d.Type,
		SourceRetryCount:         d.SourceRetryCount,
		SourceRetryWait:          d.SourceRetryWait,
		MaxConcurrentConnections: d.MaxConcurrentConnections,
		DisableMetricsCollection: d.DisableMetricsCollection,
		AdditionalProperties:     d.AdditionalProperties,
	}
}

// DynamicsCrmEntityDataset - The Dynamics CRM entity dataset.
type DynamicsCrmEntityDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Dynamics CRM entity dataset properties.
	TypeProperties *DynamicsCrmEntityDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type DynamicsCrmEntityDataset.
func (d *DynamicsCrmEntityDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 d.Type,
		Description:          d.Description,
		Structure:            d.Structure,
		Schema:               d.Schema,
		LinkedServiceName:    d.LinkedServiceName,
		Parameters:           d.Parameters,
		Annotations:          d.Annotations,
		Folder:               d.Folder,
		AdditionalProperties: d.AdditionalProperties,
	}
}

// DynamicsCrmEntityDatasetTypeProperties - Dynamics CRM entity dataset properties.
type DynamicsCrmEntityDatasetTypeProperties struct {
	// The logical name of the entity. Type: string (or Expression with resultType string).
	EntityName interface{} `json:"entityName,omitempty"`
}

// DynamicsCrmLinkedService - Dynamics CRM linked service.
type DynamicsCrmLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Dynamics CRM linked service properties.
	TypeProperties *DynamicsCrmLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type DynamicsCrmLinkedService.
func (d *DynamicsCrmLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 d.Type,
		ConnectVia:           d.ConnectVia,
		Description:          d.Description,
		Parameters:           d.Parameters,
		Annotations:          d.Annotations,
		AdditionalProperties: d.AdditionalProperties,
	}
}

// DynamicsCrmLinkedServiceTypeProperties - Dynamics CRM linked service properties.
type DynamicsCrmLinkedServiceTypeProperties struct {
	// REQUIRED; The authentication type to connect to Dynamics CRM server. 'Office365' for online scenario, 'Ifd' for on-premises
	// with Ifd scenario, 'AADServicePrincipal' for Server-To-Server authentication in online
	// scenario. Type: string (or Expression with resultType string).
	AuthenticationType interface{} `json:"authenticationType,omitempty"`

	// REQUIRED; The deployment type of the Dynamics CRM instance. 'Online' for Dynamics CRM Online and 'OnPremisesWithIfd' for
	// Dynamics CRM on-premises with Ifd. Type: string (or Expression with resultType string).
	DeploymentType interface{} `json:"deploymentType,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The host name of the on-premises Dynamics CRM server. The property is required for on-prem and not allowed for online.
	// Type: string (or Expression with resultType string).
	HostName interface{} `json:"hostName,omitempty"`

	// The organization name of the Dynamics CRM instance. The property is required for on-prem and required for online when there
	// are more than one Dynamics CRM instances associated with the user. Type:
	// string (or Expression with resultType string).
	OrganizationName interface{} `json:"organizationName,omitempty"`

	// Password to access the Dynamics CRM instance.
	Password SecretBaseClassification `json:"password,omitempty"`

	// The port of on-premises Dynamics CRM server. The property is required for on-prem and not allowed for online. Default is
	// 443. Type: integer (or Expression with resultType integer), minimum: 0.
	Port interface{} `json:"port,omitempty"`

	// The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
	// servicePrincipalCredential can be SecureString or
	// AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can
	// only be AzureKeyVaultSecretReference.
	ServicePrincipalCredential SecretBaseClassification `json:"servicePrincipalCredential,omitempty"`

	// The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret,
	// 'ServicePrincipalCert' for certificate. Type: string (or Expression with
	// resultType string).
	ServicePrincipalCredentialType interface{} `json:"servicePrincipalCredentialType,omitempty"`

	// The client ID of the application in Azure Active Directory used for Server-To-Server authentication. Type: string (or Expression
	// with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`

	// The URL to the Microsoft Dynamics CRM server. The property is required for on-line and not allowed for on-prem. Type: string
	// (or Expression with resultType string).
	ServiceURI interface{} `json:"serviceUri,omitempty"`

	// User name to access the Dynamics CRM instance. Type: string (or Expression with resultType string).
	Username interface{} `json:"username,omitempty"`
}

// DynamicsCrmSink - A copy activity Dynamics CRM sink.
type DynamicsCrmSink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// REQUIRED; The write behavior for the operation.
	WriteBehavior *DynamicsSinkWriteBehavior `json:"writeBehavior,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// The logical name of the alternate key which will be used when upserting records. Type: string (or Expression with resultType
	// string).
	AlternateKeyName interface{} `json:"alternateKeyName,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The flag indicating whether to ignore null values from input dataset (except key fields) during write operation. Default
	// is false. Type: boolean (or Expression with resultType boolean).
	IgnoreNullValues interface{} `json:"ignoreNullValues,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type DynamicsCrmSink.
func (d *DynamicsCrmSink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     d.Type,
		WriteBatchSize:           d.WriteBatchSize,
		WriteBatchTimeout:        d.WriteBatchTimeout,
		SinkRetryCount:           d.SinkRetryCount,
		SinkRetryWait:            d.SinkRetryWait,
		MaxConcurrentConnections: d.MaxConcurrentConnections,
		DisableMetricsCollection: d.DisableMetricsCollection,
		AdditionalProperties:     d.AdditionalProperties,
	}
}

// DynamicsCrmSource - A copy activity Dynamics CRM source.
type DynamicsCrmSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// FetchXML is a proprietary query language that is used in Microsoft Dynamics CRM (online & on-premises). Type: string (or
	// Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type DynamicsCrmSource.
func (d *DynamicsCrmSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     d.Type,
		SourceRetryCount:         d.SourceRetryCount,
		SourceRetryWait:          d.SourceRetryWait,
		MaxConcurrentConnections: d.MaxConcurrentConnections,
		DisableMetricsCollection: d.DisableMetricsCollection,
		AdditionalProperties:     d.AdditionalProperties,
	}
}

// DynamicsEntityDataset - The Dynamics entity dataset.
type DynamicsEntityDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Dynamics entity dataset properties.
	TypeProperties *DynamicsEntityDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type DynamicsEntityDataset.
func (d *DynamicsEntityDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 d.Type,
		Description:          d.Description,
		Structure:            d.Structure,
		Schema:               d.Schema,
		LinkedServiceName:    d.LinkedServiceName,
		Parameters:           d.Parameters,
		Annotations:          d.Annotations,
		Folder:               d.Folder,
		AdditionalProperties: d.AdditionalProperties,
	}
}

// DynamicsEntityDatasetTypeProperties - Dynamics entity dataset properties.
type DynamicsEntityDatasetTypeProperties struct {
	// The logical name of the entity. Type: string (or Expression with resultType string).
	EntityName interface{} `json:"entityName,omitempty"`
}

// DynamicsLinkedService - Dynamics linked service.
type DynamicsLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Dynamics linked service properties.
	TypeProperties *DynamicsLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type DynamicsLinkedService.
func (d *DynamicsLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 d.Type,
		ConnectVia:           d.ConnectVia,
		Description:          d.Description,
		Parameters:           d.Parameters,
		Annotations:          d.Annotations,
		AdditionalProperties: d.AdditionalProperties,
	}
}

// DynamicsLinkedServiceTypeProperties - Dynamics linked service properties.
type DynamicsLinkedServiceTypeProperties struct {
	// REQUIRED; The authentication type to connect to Dynamics server. 'Office365' for online scenario, 'Ifd' for on-premises
	// with Ifd scenario, 'AADServicePrincipal' for Server-To-Server authentication in online
	// scenario. Type: string (or Expression with resultType string).
	AuthenticationType interface{} `json:"authenticationType,omitempty"`

	// REQUIRED; The deployment type of the Dynamics instance. 'Online' for Dynamics Online and 'OnPremisesWithIfd' for Dynamics
	// on-premises with Ifd. Type: string (or Expression with resultType string).
	DeploymentType interface{} `json:"deploymentType,omitempty"`

	// The credential reference containing authentication information.
	Credential *CredentialReference `json:"credential,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The host name of the on-premises Dynamics server. The property is required for on-prem and not allowed for online. Type:
	// string (or Expression with resultType string).
	HostName interface{} `json:"hostName,omitempty"`

	// The organization name of the Dynamics instance. The property is required for on-prem and required for online when there
	// are more than one Dynamics instances associated with the user. Type: string (or
	// Expression with resultType string).
	OrganizationName interface{} `json:"organizationName,omitempty"`

	// Password to access the Dynamics instance.
	Password SecretBaseClassification `json:"password,omitempty"`

	// The port of on-premises Dynamics server. The property is required for on-prem and not allowed for online. Default is 443.
	// Type: integer (or Expression with resultType integer), minimum: 0.
	Port interface{} `json:"port,omitempty"`

	// The credential of the service principal object in Azure Active Directory. If servicePrincipalCredentialType is 'ServicePrincipalKey',
	// servicePrincipalCredential can be SecureString or
	// AzureKeyVaultSecretReference. If servicePrincipalCredentialType is 'ServicePrincipalCert', servicePrincipalCredential can
	// only be AzureKeyVaultSecretReference.
	ServicePrincipalCredential SecretBaseClassification `json:"servicePrincipalCredential,omitempty"`

	// The service principal credential type to use in Server-To-Server authentication. 'ServicePrincipalKey' for key/secret,
	// 'ServicePrincipalCert' for certificate. Type: string (or Expression with
	// resultType string).
	ServicePrincipalCredentialType interface{} `json:"servicePrincipalCredentialType,omitempty"`

	// The client ID of the application in Azure Active Directory used for Server-To-Server authentication. Type: string (or Expression
	// with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`

	// The URL to the Microsoft Dynamics server. The property is required for on-line and not allowed for on-prem. Type: string
	// (or Expression with resultType string).
	ServiceURI interface{} `json:"serviceUri,omitempty"`

	// User name to access the Dynamics instance. Type: string (or Expression with resultType string).
	Username interface{} `json:"username,omitempty"`
}

// DynamicsSink - A copy activity Dynamics sink.
type DynamicsSink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// REQUIRED; The write behavior for the operation.
	WriteBehavior *DynamicsSinkWriteBehavior `json:"writeBehavior,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// The logical name of the alternate key which will be used when upserting records. Type: string (or Expression with resultType
	// string).
	AlternateKeyName interface{} `json:"alternateKeyName,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The flag indicating whether ignore null values from input dataset (except key fields) during write operation. Default is
	// false. Type: boolean (or Expression with resultType boolean).
	IgnoreNullValues interface{} `json:"ignoreNullValues,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type DynamicsSink.
func (d *DynamicsSink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     d.Type,
		WriteBatchSize:           d.WriteBatchSize,
		WriteBatchTimeout:        d.WriteBatchTimeout,
		SinkRetryCount:           d.SinkRetryCount,
		SinkRetryWait:            d.SinkRetryWait,
		MaxConcurrentConnections: d.MaxConcurrentConnections,
		DisableMetricsCollection: d.DisableMetricsCollection,
		AdditionalProperties:     d.AdditionalProperties,
	}
}

// DynamicsSource - A copy activity Dynamics source.
type DynamicsSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// FetchXML is a proprietary query language that is used in Microsoft Dynamics (online & on-premises). Type: string (or Expression
	// with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type DynamicsSource.
func (d *DynamicsSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     d.Type,
		SourceRetryCount:         d.SourceRetryCount,
		SourceRetryWait:          d.SourceRetryWait,
		MaxConcurrentConnections: d.MaxConcurrentConnections,
		DisableMetricsCollection: d.DisableMetricsCollection,
		AdditionalProperties:     d.AdditionalProperties,
	}
}

// EloquaLinkedService - Eloqua server linked service.
type EloquaLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Eloqua server linked service properties.
	TypeProperties *EloquaLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type EloquaLinkedService.
func (e *EloquaLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 e.Type,
		ConnectVia:           e.ConnectVia,
		Description:          e.Description,
		Parameters:           e.Parameters,
		Annotations:          e.Annotations,
		AdditionalProperties: e.AdditionalProperties,
	}
}

// EloquaLinkedServiceTypeProperties - Eloqua server linked service properties.
type EloquaLinkedServiceTypeProperties struct {
	// REQUIRED; The endpoint of the Eloqua server. (i.e. eloqua.example.com)
	Endpoint interface{} `json:"endpoint,omitempty"`

	// REQUIRED; The site name and user name of your Eloqua account in the form: sitename/username. (i.e. Eloqua/Alice)
	Username interface{} `json:"username,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The password corresponding to the user name.
	Password SecretBaseClassification `json:"password,omitempty"`

	// Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
	UseEncryptedEndpoints interface{} `json:"useEncryptedEndpoints,omitempty"`

	// Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting
	// over SSL. The default value is true.
	UseHostVerification interface{} `json:"useHostVerification,omitempty"`

	// Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
	UsePeerVerification interface{} `json:"usePeerVerification,omitempty"`
}

// EloquaObjectDataset - Eloqua server dataset.
type EloquaObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type EloquaObjectDataset.
func (e *EloquaObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 e.Type,
		Description:          e.Description,
		Structure:            e.Structure,
		Schema:               e.Schema,
		LinkedServiceName:    e.LinkedServiceName,
		Parameters:           e.Parameters,
		Annotations:          e.Annotations,
		Folder:               e.Folder,
		AdditionalProperties: e.AdditionalProperties,
	}
}

// EloquaSource - A copy activity Eloqua server source.
type EloquaSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type EloquaSource.
func (e *EloquaSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     e.Type,
		SourceRetryCount:         e.SourceRetryCount,
		SourceRetryWait:          e.SourceRetryWait,
		MaxConcurrentConnections: e.MaxConcurrentConnections,
		DisableMetricsCollection: e.DisableMetricsCollection,
		AdditionalProperties:     e.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type EloquaSource.
func (e *EloquaSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             e.QueryTimeout,
		AdditionalColumns:        e.AdditionalColumns,
		Type:                     e.Type,
		SourceRetryCount:         e.SourceRetryCount,
		SourceRetryWait:          e.SourceRetryWait,
		MaxConcurrentConnections: e.MaxConcurrentConnections,
		DisableMetricsCollection: e.DisableMetricsCollection,
		AdditionalProperties:     e.AdditionalProperties,
	}
}

// EncryptionConfiguration - Definition of CMK for the factory.
type EncryptionConfiguration struct {
	// REQUIRED; The name of the key in Azure Key Vault to use as Customer Managed Key.
	KeyName *string `json:"keyName,omitempty"`

	// REQUIRED; The url of the Azure Key Vault used for CMK.
	VaultBaseURL *string `json:"vaultBaseUrl,omitempty"`

	// User assigned identity to use to authenticate to customer's key vault. If not provided Managed Service Identity will be
	// used.
	Identity *CMKIdentityDefinition `json:"identity,omitempty"`

	// The version of the key used for CMK. If not provided, latest version will be used.
	KeyVersion *string `json:"keyVersion,omitempty"`
}

// EntityReference - The entity reference.
type EntityReference struct {
	// The name of this referenced entity.
	ReferenceName *string `json:"referenceName,omitempty"`

	// The type of this referenced entity.
	Type *IntegrationRuntimeEntityReferenceType `json:"type,omitempty"`
}

// EnvironmentVariableSetup - The custom setup of setting environment variable.
type EnvironmentVariableSetup struct {
	// REQUIRED; The type of custom setup.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Add environment variable type properties.
	TypeProperties *EnvironmentVariableSetupTypeProperties `json:"typeProperties,omitempty"`
}

// GetCustomSetupBase implements the CustomSetupBaseClassification interface for type EnvironmentVariableSetup.
func (e *EnvironmentVariableSetup) GetCustomSetupBase() *CustomSetupBase {
	return &CustomSetupBase{
		Type: e.Type,
	}
}

// EnvironmentVariableSetupTypeProperties - Environment variable custom setup type properties.
type EnvironmentVariableSetupTypeProperties struct {
	// REQUIRED; The name of the environment variable.
	VariableName *string `json:"variableName,omitempty"`

	// REQUIRED; The value of the environment variable.
	VariableValue *string `json:"variableValue,omitempty"`
}

// ExcelDataset - Excel dataset.
type ExcelDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Excel dataset properties.
	TypeProperties *ExcelDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type ExcelDataset.
func (e *ExcelDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 e.Type,
		Description:          e.Description,
		Structure:            e.Structure,
		Schema:               e.Schema,
		LinkedServiceName:    e.LinkedServiceName,
		Parameters:           e.Parameters,
		Annotations:          e.Annotations,
		Folder:               e.Folder,
		AdditionalProperties: e.AdditionalProperties,
	}
}

// ExcelDatasetTypeProperties - Excel dataset properties.
type ExcelDatasetTypeProperties struct {
	// REQUIRED; The location of the excel storage.
	Location DatasetLocationClassification `json:"location,omitempty"`

	// The data compression method used for the json dataset.
	Compression *DatasetCompression `json:"compression,omitempty"`

	// When used as input, treat the first row of data as headers. When used as output,write the headers into the output as the
	// first row of data. The default value is false. Type: boolean (or Expression
	// with resultType boolean).
	FirstRowAsHeader interface{} `json:"firstRowAsHeader,omitempty"`

	// The null value string. Type: string (or Expression with resultType string).
	NullValue interface{} `json:"nullValue,omitempty"`

	// The partial data of one sheet. Type: string (or Expression with resultType string).
	Range interface{} `json:"range,omitempty"`

	// The sheet index of excel file and default value is 0. Type: integer (or Expression with resultType integer)
	SheetIndex interface{} `json:"sheetIndex,omitempty"`

	// The sheet name of excel file. Type: string (or Expression with resultType string).
	SheetName interface{} `json:"sheetName,omitempty"`
}

// ExcelSource - A copy activity excel source.
type ExcelSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`

	// Excel store settings.
	StoreSettings StoreReadSettingsClassification `json:"storeSettings,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type ExcelSource.
func (e *ExcelSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     e.Type,
		SourceRetryCount:         e.SourceRetryCount,
		SourceRetryWait:          e.SourceRetryWait,
		MaxConcurrentConnections: e.MaxConcurrentConnections,
		DisableMetricsCollection: e.DisableMetricsCollection,
		AdditionalProperties:     e.AdditionalProperties,
	}
}

// ExecuteDataFlowActivity - Execute data flow activity.
type ExecuteDataFlowActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Execute data flow activity properties.
	TypeProperties *ExecuteDataFlowActivityTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type ExecuteDataFlowActivity.
func (e *ExecuteDataFlowActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 e.Name,
		Type:                 e.Type,
		Description:          e.Description,
		DependsOn:            e.DependsOn,
		UserProperties:       e.UserProperties,
		AdditionalProperties: e.AdditionalProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type ExecuteDataFlowActivity.
func (e *ExecuteDataFlowActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		LinkedServiceName:    e.LinkedServiceName,
		Policy:               e.Policy,
		Name:                 e.Name,
		Type:                 e.Type,
		Description:          e.Description,
		DependsOn:            e.DependsOn,
		UserProperties:       e.UserProperties,
		AdditionalProperties: e.AdditionalProperties,
	}
}

// ExecuteDataFlowActivityTypeProperties - Execute data flow activity properties.
type ExecuteDataFlowActivityTypeProperties struct {
	// REQUIRED; Data flow reference.
	DataFlow *DataFlowReference `json:"dataFlow,omitempty"`

	// Compute properties for data flow activity.
	Compute *ExecuteDataFlowActivityTypePropertiesCompute `json:"compute,omitempty"`

	// Continue on error setting used for data flow execution. Enables processing to continue if a sink fails. Type: boolean (or
	// Expression with resultType boolean)
	ContinueOnError interface{} `json:"continueOnError,omitempty"`

	// The integration runtime reference.
	IntegrationRuntime *IntegrationRuntimeReference `json:"integrationRuntime,omitempty"`

	// Concurrent run setting used for data flow execution. Allows sinks with the same save order to be processed concurrently.
	// Type: boolean (or Expression with resultType boolean)
	RunConcurrently interface{} `json:"runConcurrently,omitempty"`

	// Specify number of parallel staging for sources applicable to the sink. Type: integer (or Expression with resultType integer)
	SourceStagingConcurrency interface{} `json:"sourceStagingConcurrency,omitempty"`

	// Staging info for execute data flow activity.
	Staging *DataFlowStagingInfo `json:"staging,omitempty"`

	// Trace level setting used for data flow monitoring output. Supported values are: 'coarse', 'fine', and 'none'. Type: string
	// (or Expression with resultType string)
	TraceLevel interface{} `json:"traceLevel,omitempty"`
}

// ExecuteDataFlowActivityTypePropertiesCompute - Compute properties for data flow activity.
type ExecuteDataFlowActivityTypePropertiesCompute struct {
	// Compute type of the cluster which will execute data flow job. Possible values include: 'General', 'MemoryOptimized', 'ComputeOptimized'.
	// Type: string (or Expression with resultType string)
	ComputeType interface{} `json:"computeType,omitempty"`

	// Core count of the cluster which will execute data flow job. Supported values are: 8, 16, 32, 48, 80, 144 and 272. Type:
	// integer (or Expression with resultType integer)
	CoreCount interface{} `json:"coreCount,omitempty"`
}

// ExecutePipelineActivity - Execute pipeline activity.
type ExecutePipelineActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Execute pipeline activity properties.
	TypeProperties *ExecutePipelineActivityTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Execute pipeline activity policy.
	Policy *ExecutePipelineActivityPolicy `json:"policy,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type ExecutePipelineActivity.
func (e *ExecutePipelineActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 e.Name,
		Type:                 e.Type,
		Description:          e.Description,
		DependsOn:            e.DependsOn,
		UserProperties:       e.UserProperties,
		AdditionalProperties: e.AdditionalProperties,
	}
}

// GetControlActivity implements the ControlActivityClassification interface for type ExecutePipelineActivity.
func (e *ExecutePipelineActivity) GetControlActivity() *ControlActivity {
	return &ControlActivity{
		Name:                 e.Name,
		Type:                 e.Type,
		Description:          e.Description,
		DependsOn:            e.DependsOn,
		UserProperties:       e.UserProperties,
		AdditionalProperties: e.AdditionalProperties,
	}
}

// ExecutePipelineActivityPolicy - Execution policy for an execute pipeline activity.
type ExecutePipelineActivityPolicy struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// When set to true, Input from activity is considered as secure and will not be logged to monitoring.
	SecureInput *bool `json:"secureInput,omitempty"`
}

// ExecutePipelineActivityTypeProperties - Execute pipeline activity properties.
type ExecutePipelineActivityTypeProperties struct {
	// REQUIRED; Pipeline reference.
	Pipeline *PipelineReference `json:"pipeline,omitempty"`

	// Pipeline parameters.
	Parameters map[string]interface{} `json:"parameters,omitempty"`

	// Defines whether activity execution will wait for the dependent pipeline execution to finish. Default is false.
	WaitOnCompletion *bool `json:"waitOnCompletion,omitempty"`
}

// ExecutePowerQueryActivityTypeProperties - Execute power query data flow activity properties.
type ExecutePowerQueryActivityTypeProperties struct {
	// REQUIRED; Data flow reference.
	DataFlow *DataFlowReference `json:"dataFlow,omitempty"`

	// Compute properties for data flow activity.
	Compute *ExecuteDataFlowActivityTypePropertiesCompute `json:"compute,omitempty"`

	// Continue on error setting used for data flow execution. Enables processing to continue if a sink fails. Type: boolean (or
	// Expression with resultType boolean)
	ContinueOnError interface{} `json:"continueOnError,omitempty"`

	// The integration runtime reference.
	IntegrationRuntime *IntegrationRuntimeReference `json:"integrationRuntime,omitempty"`

	// List of mapping for Power Query mashup query to sink dataset(s).
	Queries []*PowerQuerySinkMapping `json:"queries,omitempty"`

	// Concurrent run setting used for data flow execution. Allows sinks with the same save order to be processed concurrently.
	// Type: boolean (or Expression with resultType boolean)
	RunConcurrently interface{} `json:"runConcurrently,omitempty"`

	// (Deprecated. Please use Queries). List of Power Query activity sinks mapped to a queryName.
	Sinks map[string]*PowerQuerySink `json:"sinks,omitempty"`

	// Specify number of parallel staging for sources applicable to the sink. Type: integer (or Expression with resultType integer)
	SourceStagingConcurrency interface{} `json:"sourceStagingConcurrency,omitempty"`

	// Staging info for execute data flow activity.
	Staging *DataFlowStagingInfo `json:"staging,omitempty"`

	// Trace level setting used for data flow monitoring output. Supported values are: 'coarse', 'fine', and 'none'. Type: string
	// (or Expression with resultType string)
	TraceLevel interface{} `json:"traceLevel,omitempty"`
}

// ExecuteSSISPackageActivity - Execute SSIS package activity.
type ExecuteSSISPackageActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Execute SSIS package activity properties.
	TypeProperties *ExecuteSSISPackageActivityTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type ExecuteSSISPackageActivity.
func (e *ExecuteSSISPackageActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 e.Name,
		Type:                 e.Type,
		Description:          e.Description,
		DependsOn:            e.DependsOn,
		UserProperties:       e.UserProperties,
		AdditionalProperties: e.AdditionalProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type ExecuteSSISPackageActivity.
func (e *ExecuteSSISPackageActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		LinkedServiceName:    e.LinkedServiceName,
		Policy:               e.Policy,
		Name:                 e.Name,
		Type:                 e.Type,
		Description:          e.Description,
		DependsOn:            e.DependsOn,
		UserProperties:       e.UserProperties,
		AdditionalProperties: e.AdditionalProperties,
	}
}

// ExecuteSSISPackageActivityTypeProperties - Execute SSIS package activity properties.
type ExecuteSSISPackageActivityTypeProperties struct {
	// REQUIRED; The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// REQUIRED; SSIS package location.
	PackageLocation *SSISPackageLocation `json:"packageLocation,omitempty"`

	// The environment path to execute the SSIS package. Type: string (or Expression with resultType string).
	EnvironmentPath interface{} `json:"environmentPath,omitempty"`

	// The package execution credential.
	ExecutionCredential *SSISExecutionCredential `json:"executionCredential,omitempty"`

	// SSIS package execution log location.
	LogLocation *SSISLogLocation `json:"logLocation,omitempty"`

	// The logging level of SSIS package execution. Type: string (or Expression with resultType string).
	LoggingLevel interface{} `json:"loggingLevel,omitempty"`

	// The package level connection managers to execute the SSIS package.
	PackageConnectionManagers map[string]map[string]*SSISExecutionParameter `json:"packageConnectionManagers,omitempty"`

	// The package level parameters to execute the SSIS package.
	PackageParameters map[string]*SSISExecutionParameter `json:"packageParameters,omitempty"`

	// The project level connection managers to execute the SSIS package.
	ProjectConnectionManagers map[string]map[string]*SSISExecutionParameter `json:"projectConnectionManagers,omitempty"`

	// The project level parameters to execute the SSIS package.
	ProjectParameters map[string]*SSISExecutionParameter `json:"projectParameters,omitempty"`

	// The property overrides to execute the SSIS package.
	PropertyOverrides map[string]*SSISPropertyOverride `json:"propertyOverrides,omitempty"`

	// Specifies the runtime to execute SSIS package. The value should be "x86" or "x64". Type: string (or Expression with resultType
	// string).
	Runtime interface{} `json:"runtime,omitempty"`
}

// ExecuteWranglingDataflowActivity - Execute power query activity.
type ExecuteWranglingDataflowActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Execute power query activity properties.
	TypeProperties *ExecutePowerQueryActivityTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type ExecuteWranglingDataflowActivity.
func (e *ExecuteWranglingDataflowActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 e.Name,
		Type:                 e.Type,
		Description:          e.Description,
		DependsOn:            e.DependsOn,
		UserProperties:       e.UserProperties,
		AdditionalProperties: e.AdditionalProperties,
	}
}

// ExecutionActivityClassification provides polymorphic access to related types.
// Call the interface's GetExecutionActivity() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureDataExplorerCommandActivity, *AzureFunctionActivity, *AzureMLBatchExecutionActivity, *AzureMLExecutePipelineActivity,
// - *AzureMLUpdateResourceActivity, *CopyActivity, *CustomActivity, *DataLakeAnalyticsUSQLActivity, *DatabricksNotebookActivity,
// - *DatabricksSparkJarActivity, *DatabricksSparkPythonActivity, *DeleteActivity, *ExecuteDataFlowActivity, *ExecuteSSISPackageActivity,
// - *ExecutionActivity, *GetMetadataActivity, *HDInsightHiveActivity, *HDInsightMapReduceActivity, *HDInsightPigActivity,
// - *HDInsightSparkActivity, *HDInsightStreamingActivity, *LookupActivity, *SQLServerStoredProcedureActivity, *ScriptActivity,
// - *SynapseNotebookActivity, *SynapseSparkJobDefinitionActivity, *WebActivity
type ExecutionActivityClassification interface {
	ActivityClassification
	// GetExecutionActivity returns the ExecutionActivity content of the underlying type.
	GetExecutionActivity() *ExecutionActivity
}

// ExecutionActivity - Base class for all execution activities.
type ExecutionActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type ExecutionActivity.
func (e *ExecutionActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 e.Name,
		Type:                 e.Type,
		Description:          e.Description,
		DependsOn:            e.DependsOn,
		UserProperties:       e.UserProperties,
		AdditionalProperties: e.AdditionalProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type ExecutionActivity.
func (e *ExecutionActivity) GetExecutionActivity() *ExecutionActivity { return e }

// ExportSettingsClassification provides polymorphic access to related types.
// Call the interface's GetExportSettings() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureDatabricksDeltaLakeExportCommand, *ExportSettings, *SnowflakeExportCopyCommand
type ExportSettingsClassification interface {
	// GetExportSettings returns the ExportSettings content of the underlying type.
	GetExportSettings() *ExportSettings
}

// ExportSettings - Export command settings.
type ExportSettings struct {
	// REQUIRED; The export setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}
}

// GetExportSettings implements the ExportSettingsClassification interface for type ExportSettings.
func (e *ExportSettings) GetExportSettings() *ExportSettings { return e }

// ExposureControlBatchRequest - A list of exposure control features.
type ExposureControlBatchRequest struct {
	// REQUIRED; List of exposure control features.
	ExposureControlRequests []*ExposureControlRequest `json:"exposureControlRequests,omitempty"`
}

// ExposureControlBatchResponse - A list of exposure control feature values.
type ExposureControlBatchResponse struct {
	// REQUIRED; List of exposure control feature values.
	ExposureControlResponses []*ExposureControlResponse `json:"exposureControlResponses,omitempty"`
}

// ExposureControlClientGetFeatureValueByFactoryOptions contains the optional parameters for the ExposureControlClient.GetFeatureValueByFactory
// method.
type ExposureControlClientGetFeatureValueByFactoryOptions struct {
	// placeholder for future optional parameters
}

// ExposureControlClientGetFeatureValueOptions contains the optional parameters for the ExposureControlClient.GetFeatureValue
// method.
type ExposureControlClientGetFeatureValueOptions struct {
	// placeholder for future optional parameters
}

// ExposureControlClientQueryFeatureValuesByFactoryOptions contains the optional parameters for the ExposureControlClient.QueryFeatureValuesByFactory
// method.
type ExposureControlClientQueryFeatureValuesByFactoryOptions struct {
	// placeholder for future optional parameters
}

// ExposureControlRequest - The exposure control request.
type ExposureControlRequest struct {
	// The feature name.
	FeatureName *string `json:"featureName,omitempty"`

	// The feature type.
	FeatureType *string `json:"featureType,omitempty"`
}

// ExposureControlResponse - The exposure control response.
type ExposureControlResponse struct {
	// READ-ONLY; The feature name.
	FeatureName *string `json:"featureName,omitempty" azure:"ro"`

	// READ-ONLY; The feature value.
	Value *string `json:"value,omitempty" azure:"ro"`
}

// Expression - Azure Data Factory expression definition.
type Expression struct {
	// REQUIRED; Expression type.
	Type *ExpressionType `json:"type,omitempty"`

	// REQUIRED; Expression value.
	Value *string `json:"value,omitempty"`
}

// FactoriesClientConfigureFactoryRepoOptions contains the optional parameters for the FactoriesClient.ConfigureFactoryRepo
// method.
type FactoriesClientConfigureFactoryRepoOptions struct {
	// placeholder for future optional parameters
}

// FactoriesClientCreateOrUpdateOptions contains the optional parameters for the FactoriesClient.CreateOrUpdate method.
type FactoriesClientCreateOrUpdateOptions struct {
	// ETag of the factory entity. Should only be specified for update, for which it should match existing entity or can be *
	// for unconditional update.
	IfMatch *string
}

// FactoriesClientDeleteOptions contains the optional parameters for the FactoriesClient.Delete method.
type FactoriesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// FactoriesClientGetDataPlaneAccessOptions contains the optional parameters for the FactoriesClient.GetDataPlaneAccess method.
type FactoriesClientGetDataPlaneAccessOptions struct {
	// placeholder for future optional parameters
}

// FactoriesClientGetGitHubAccessTokenOptions contains the optional parameters for the FactoriesClient.GetGitHubAccessToken
// method.
type FactoriesClientGetGitHubAccessTokenOptions struct {
	// placeholder for future optional parameters
}

// FactoriesClientGetOptions contains the optional parameters for the FactoriesClient.Get method.
type FactoriesClientGetOptions struct {
	// ETag of the factory entity. Should only be specified for get. If the ETag matches the existing entity tag, or if * was
	// provided, then no content will be returned.
	IfNoneMatch *string
}

// FactoriesClientListByResourceGroupOptions contains the optional parameters for the FactoriesClient.ListByResourceGroup
// method.
type FactoriesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// FactoriesClientListOptions contains the optional parameters for the FactoriesClient.List method.
type FactoriesClientListOptions struct {
	// placeholder for future optional parameters
}

// FactoriesClientUpdateOptions contains the optional parameters for the FactoriesClient.Update method.
type FactoriesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// Factory resource type.
type Factory struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Managed service identity of the factory.
	Identity *FactoryIdentity `json:"identity,omitempty"`

	// The resource location.
	Location *string `json:"location,omitempty"`

	// Properties of the factory.
	Properties *FactoryProperties `json:"properties,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Etag identifies change in the resource.
	ETag *string `json:"eTag,omitempty" azure:"ro"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// FactoryGitHubConfiguration - Factory's GitHub repo information.
type FactoryGitHubConfiguration struct {
	// REQUIRED; Account name.
	AccountName *string `json:"accountName,omitempty"`

	// REQUIRED; Collaboration branch.
	CollaborationBranch *string `json:"collaborationBranch,omitempty"`

	// REQUIRED; Repository name.
	RepositoryName *string `json:"repositoryName,omitempty"`

	// REQUIRED; Root folder.
	RootFolder *string `json:"rootFolder,omitempty"`

	// REQUIRED; Type of repo configuration.
	Type *string `json:"type,omitempty"`

	// GitHub bring your own app client id.
	ClientID *string `json:"clientId,omitempty"`

	// GitHub bring your own app client secret information.
	ClientSecret *GitHubClientSecret `json:"clientSecret,omitempty"`

	// Disable manual publish operation in ADF studio to favor automated publish.
	DisablePublish *bool `json:"disablePublish,omitempty"`

	// GitHub Enterprise host name. For example: https://github.mydomain.com
	HostName *string `json:"hostName,omitempty"`

	// Last commit id.
	LastCommitID *string `json:"lastCommitId,omitempty"`
}

// GetFactoryRepoConfiguration implements the FactoryRepoConfigurationClassification interface for type FactoryGitHubConfiguration.
func (f *FactoryGitHubConfiguration) GetFactoryRepoConfiguration() *FactoryRepoConfiguration {
	return &FactoryRepoConfiguration{
		Type:                f.Type,
		AccountName:         f.AccountName,
		RepositoryName:      f.RepositoryName,
		CollaborationBranch: f.CollaborationBranch,
		RootFolder:          f.RootFolder,
		LastCommitID:        f.LastCommitID,
		DisablePublish:      f.DisablePublish,
	}
}

// FactoryIdentity - Identity properties of the factory resource.
type FactoryIdentity struct {
	// REQUIRED; The identity type.
	Type *FactoryIdentityType `json:"type,omitempty"`

	// List of user assigned identities for the factory.
	UserAssignedIdentities map[string]interface{} `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The principal id of the identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The client tenant id of the identity.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// FactoryListResponse - A list of factory resources.
type FactoryListResponse struct {
	// REQUIRED; List of factories.
	Value []*Factory `json:"value,omitempty"`

	// The link to the next page of results, if any remaining results exist.
	NextLink *string `json:"nextLink,omitempty"`
}

// FactoryProperties - Factory resource properties.
type FactoryProperties struct {
	// Properties to enable Customer Managed Key for the factory.
	Encryption *EncryptionConfiguration `json:"encryption,omitempty"`

	// List of parameters for factory.
	GlobalParameters map[string]*GlobalParameterSpecification `json:"globalParameters,omitempty"`

	// Whether or not public network access is allowed for the data factory.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`

	// Purview information of the factory.
	PurviewConfiguration *PurviewConfiguration `json:"purviewConfiguration,omitempty"`

	// Git repo information of the factory.
	RepoConfiguration FactoryRepoConfigurationClassification `json:"repoConfiguration,omitempty"`

	// READ-ONLY; Time the factory was created in ISO8601 format.
	CreateTime *time.Time `json:"createTime,omitempty" azure:"ro"`

	// READ-ONLY; Factory provisioning state, example Succeeded.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Version of the factory.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// FactoryRepoConfigurationClassification provides polymorphic access to related types.
// Call the interface's GetFactoryRepoConfiguration() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *FactoryGitHubConfiguration, *FactoryRepoConfiguration, *FactoryVSTSConfiguration
type FactoryRepoConfigurationClassification interface {
	// GetFactoryRepoConfiguration returns the FactoryRepoConfiguration content of the underlying type.
	GetFactoryRepoConfiguration() *FactoryRepoConfiguration
}

// FactoryRepoConfiguration - Factory's git repo information.
type FactoryRepoConfiguration struct {
	// REQUIRED; Account name.
	AccountName *string `json:"accountName,omitempty"`

	// REQUIRED; Collaboration branch.
	CollaborationBranch *string `json:"collaborationBranch,omitempty"`

	// REQUIRED; Repository name.
	RepositoryName *string `json:"repositoryName,omitempty"`

	// REQUIRED; Root folder.
	RootFolder *string `json:"rootFolder,omitempty"`

	// REQUIRED; Type of repo configuration.
	Type *string `json:"type,omitempty"`

	// Disable manual publish operation in ADF studio to favor automated publish.
	DisablePublish *bool `json:"disablePublish,omitempty"`

	// Last commit id.
	LastCommitID *string `json:"lastCommitId,omitempty"`
}

// GetFactoryRepoConfiguration implements the FactoryRepoConfigurationClassification interface for type FactoryRepoConfiguration.
func (f *FactoryRepoConfiguration) GetFactoryRepoConfiguration() *FactoryRepoConfiguration { return f }

// FactoryRepoUpdate - Factory's git repo information.
type FactoryRepoUpdate struct {
	// The factory resource id.
	FactoryResourceID *string `json:"factoryResourceId,omitempty"`

	// Git repo information of the factory.
	RepoConfiguration FactoryRepoConfigurationClassification `json:"repoConfiguration,omitempty"`
}

// FactoryUpdateParameters - Parameters for updating a factory resource.
type FactoryUpdateParameters struct {
	// Managed service identity of the factory.
	Identity *FactoryIdentity `json:"identity,omitempty"`

	// Properties of update the factory.
	Properties *FactoryUpdateProperties `json:"properties,omitempty"`

	// The resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// FactoryUpdateProperties - Factory update resource properties.
type FactoryUpdateProperties struct {
	// Whether or not public network access is allowed for the data factory.
	PublicNetworkAccess *PublicNetworkAccess `json:"publicNetworkAccess,omitempty"`
}

// FactoryVSTSConfiguration - Factory's VSTS repo information.
type FactoryVSTSConfiguration struct {
	// REQUIRED; Account name.
	AccountName *string `json:"accountName,omitempty"`

	// REQUIRED; Collaboration branch.
	CollaborationBranch *string `json:"collaborationBranch,omitempty"`

	// REQUIRED; VSTS project name.
	ProjectName *string `json:"projectName,omitempty"`

	// REQUIRED; Repository name.
	RepositoryName *string `json:"repositoryName,omitempty"`

	// REQUIRED; Root folder.
	RootFolder *string `json:"rootFolder,omitempty"`

	// REQUIRED; Type of repo configuration.
	Type *string `json:"type,omitempty"`

	// Disable manual publish operation in ADF studio to favor automated publish.
	DisablePublish *bool `json:"disablePublish,omitempty"`

	// Last commit id.
	LastCommitID *string `json:"lastCommitId,omitempty"`

	// VSTS tenant id.
	TenantID *string `json:"tenantId,omitempty"`
}

// GetFactoryRepoConfiguration implements the FactoryRepoConfigurationClassification interface for type FactoryVSTSConfiguration.
func (f *FactoryVSTSConfiguration) GetFactoryRepoConfiguration() *FactoryRepoConfiguration {
	return &FactoryRepoConfiguration{
		Type:                f.Type,
		AccountName:         f.AccountName,
		RepositoryName:      f.RepositoryName,
		CollaborationBranch: f.CollaborationBranch,
		RootFolder:          f.RootFolder,
		LastCommitID:        f.LastCommitID,
		DisablePublish:      f.DisablePublish,
	}
}

// FailActivity - This activity will fail within its own scope and output a custom error message and error code. The error
// message and code can provided either as a string literal or as an expression that can be
// evaluated to a string at runtime. The activity scope can be the whole pipeline or a control activity (e.g. foreach, switch,
// until), if the fail activity is contained in it.
type FailActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Fail activity properties.
	TypeProperties *FailActivityTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type FailActivity.
func (f *FailActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 f.Name,
		Type:                 f.Type,
		Description:          f.Description,
		DependsOn:            f.DependsOn,
		UserProperties:       f.UserProperties,
		AdditionalProperties: f.AdditionalProperties,
	}
}

// GetControlActivity implements the ControlActivityClassification interface for type FailActivity.
func (f *FailActivity) GetControlActivity() *ControlActivity {
	return &ControlActivity{
		Name:                 f.Name,
		Type:                 f.Type,
		Description:          f.Description,
		DependsOn:            f.DependsOn,
		UserProperties:       f.UserProperties,
		AdditionalProperties: f.AdditionalProperties,
	}
}

// FailActivityTypeProperties - Fail activity properties.
type FailActivityTypeProperties struct {
	// REQUIRED; The error code that categorizes the error type of the Fail activity. It can be dynamic content that's evaluated
	// to a non empty/blank string at runtime. Type: string (or Expression with resultType
	// string).
	ErrorCode interface{} `json:"errorCode,omitempty"`

	// REQUIRED; The error message that surfaced in the Fail activity. It can be dynamic content that's evaluated to a non empty/blank
	// string at runtime. Type: string (or Expression with resultType string).
	Message interface{} `json:"message,omitempty"`
}

// FileServerLinkedService - File system linked service.
type FileServerLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; File system linked service properties.
	TypeProperties *FileServerLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type FileServerLinkedService.
func (f *FileServerLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 f.Type,
		ConnectVia:           f.ConnectVia,
		Description:          f.Description,
		Parameters:           f.Parameters,
		Annotations:          f.Annotations,
		AdditionalProperties: f.AdditionalProperties,
	}
}

// FileServerLinkedServiceTypeProperties - File system linked service properties.
type FileServerLinkedServiceTypeProperties struct {
	// REQUIRED; Host name of the server. Type: string (or Expression with resultType string).
	Host interface{} `json:"host,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// Password to logon the server.
	Password SecretBaseClassification `json:"password,omitempty"`

	// User ID to logon the server. Type: string (or Expression with resultType string).
	UserID interface{} `json:"userId,omitempty"`
}

// FileServerLocation - The location of file server dataset.
type FileServerLocation struct {
	// REQUIRED; Type of dataset storage location.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`

	// Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath interface{} `json:"folderPath,omitempty"`
}

// GetDatasetLocation implements the DatasetLocationClassification interface for type FileServerLocation.
func (f *FileServerLocation) GetDatasetLocation() *DatasetLocation {
	return &DatasetLocation{
		Type:                 f.Type,
		FolderPath:           f.FolderPath,
		FileName:             f.FileName,
		AdditionalProperties: f.AdditionalProperties,
	}
}

// FileServerReadSettings - File server read settings.
type FileServerReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression
	// with resultType boolean).
	DeleteFilesAfterCompletion interface{} `json:"deleteFilesAfterCompletion,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// Indicates whether to enable partition discovery.
	EnablePartitionDiscovery *bool `json:"enablePartitionDiscovery,omitempty"`

	// Specify a filter to be used to select a subset of files in the folderPath rather than all files. Type: string (or Expression
	// with resultType string).
	FileFilter interface{} `json:"fileFilter,omitempty"`

	// Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy.
	// Type: string (or Expression with resultType string).
	FileListPath interface{} `json:"fileListPath,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd interface{} `json:"modifiedDatetimeEnd,omitempty"`

	// The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart interface{} `json:"modifiedDatetimeStart,omitempty"`

	// Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath interface{} `json:"partitionRootPath,omitempty"`

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive interface{} `json:"recursive,omitempty"`

	// FileServer wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName interface{} `json:"wildcardFileName,omitempty"`

	// FileServer wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath interface{} `json:"wildcardFolderPath,omitempty"`
}

// GetStoreReadSettings implements the StoreReadSettingsClassification interface for type FileServerReadSettings.
func (f *FileServerReadSettings) GetStoreReadSettings() *StoreReadSettings {
	return &StoreReadSettings{
		Type:                     f.Type,
		MaxConcurrentConnections: f.MaxConcurrentConnections,
		DisableMetricsCollection: f.DisableMetricsCollection,
		AdditionalProperties:     f.AdditionalProperties,
	}
}

// FileServerWriteSettings - File server write settings.
type FileServerWriteSettings struct {
	// REQUIRED; The write setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// The type of copy behavior for copy sink.
	CopyBehavior interface{} `json:"copyBehavior,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`
}

// GetStoreWriteSettings implements the StoreWriteSettingsClassification interface for type FileServerWriteSettings.
func (f *FileServerWriteSettings) GetStoreWriteSettings() *StoreWriteSettings {
	return &StoreWriteSettings{
		Type:                     f.Type,
		MaxConcurrentConnections: f.MaxConcurrentConnections,
		DisableMetricsCollection: f.DisableMetricsCollection,
		CopyBehavior:             f.CopyBehavior,
		AdditionalProperties:     f.AdditionalProperties,
	}
}

// FileShareDataset - An on-premises file system dataset.
type FileShareDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// On-premises file system dataset properties.
	TypeProperties *FileShareDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type FileShareDataset.
func (f *FileShareDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 f.Type,
		Description:          f.Description,
		Structure:            f.Structure,
		Schema:               f.Schema,
		LinkedServiceName:    f.LinkedServiceName,
		Parameters:           f.Parameters,
		Annotations:          f.Annotations,
		Folder:               f.Folder,
		AdditionalProperties: f.AdditionalProperties,
	}
}

// FileShareDatasetTypeProperties - On-premises file system dataset properties.
type FileShareDatasetTypeProperties struct {
	// The data compression method used for the file system.
	Compression *DatasetCompression `json:"compression,omitempty"`

	// Specify a filter to be used to select a subset of files in the folderPath rather than all files. Type: string (or Expression
	// with resultType string).
	FileFilter interface{} `json:"fileFilter,omitempty"`

	// The name of the on-premises file system. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`

	// The path of the on-premises file system. Type: string (or Expression with resultType string).
	FolderPath interface{} `json:"folderPath,omitempty"`

	// The format of the files.
	Format DatasetStorageFormatClassification `json:"format,omitempty"`

	// The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd interface{} `json:"modifiedDatetimeEnd,omitempty"`

	// The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart interface{} `json:"modifiedDatetimeStart,omitempty"`
}

// FileSystemSink - A copy activity file system sink.
type FileSystemSink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// The type of copy behavior for copy sink.
	CopyBehavior interface{} `json:"copyBehavior,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type FileSystemSink.
func (f *FileSystemSink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     f.Type,
		WriteBatchSize:           f.WriteBatchSize,
		WriteBatchTimeout:        f.WriteBatchTimeout,
		SinkRetryCount:           f.SinkRetryCount,
		SinkRetryWait:            f.SinkRetryWait,
		MaxConcurrentConnections: f.MaxConcurrentConnections,
		DisableMetricsCollection: f.DisableMetricsCollection,
		AdditionalProperties:     f.AdditionalProperties,
	}
}

// FileSystemSource - A copy activity file system source.
type FileSystemSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive interface{} `json:"recursive,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type FileSystemSource.
func (f *FileSystemSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     f.Type,
		SourceRetryCount:         f.SourceRetryCount,
		SourceRetryWait:          f.SourceRetryWait,
		MaxConcurrentConnections: f.MaxConcurrentConnections,
		DisableMetricsCollection: f.DisableMetricsCollection,
		AdditionalProperties:     f.AdditionalProperties,
	}
}

// FilterActivity - Filter and return results from input array based on the conditions.
type FilterActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Filter activity properties.
	TypeProperties *FilterActivityTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type FilterActivity.
func (f *FilterActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 f.Name,
		Type:                 f.Type,
		Description:          f.Description,
		DependsOn:            f.DependsOn,
		UserProperties:       f.UserProperties,
		AdditionalProperties: f.AdditionalProperties,
	}
}

// GetControlActivity implements the ControlActivityClassification interface for type FilterActivity.
func (f *FilterActivity) GetControlActivity() *ControlActivity {
	return &ControlActivity{
		Name:                 f.Name,
		Type:                 f.Type,
		Description:          f.Description,
		DependsOn:            f.DependsOn,
		UserProperties:       f.UserProperties,
		AdditionalProperties: f.AdditionalProperties,
	}
}

// FilterActivityTypeProperties - Filter activity properties.
type FilterActivityTypeProperties struct {
	// REQUIRED; Condition to be used for filtering the input.
	Condition *Expression `json:"condition,omitempty"`

	// REQUIRED; Input array on which filter should be applied.
	Items *Expression `json:"items,omitempty"`
}

// Flowlet - Data flow flowlet
type Flowlet struct {
	// REQUIRED; Type of data flow.
	Type *string `json:"type,omitempty"`

	// List of tags that can be used for describing the data flow.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The description of the data flow.
	Description *string `json:"description,omitempty"`

	// The folder that this data flow is in. If not specified, Data flow will appear at the root level.
	Folder *DataFlowFolder `json:"folder,omitempty"`

	// Flowlet type properties.
	TypeProperties *FlowletTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataFlow implements the DataFlowClassification interface for type Flowlet.
func (f *Flowlet) GetDataFlow() *DataFlow {
	return &DataFlow{
		Type:        f.Type,
		Description: f.Description,
		Annotations: f.Annotations,
		Folder:      f.Folder,
	}
}

// FlowletTypeProperties - Flowlet type properties.
type FlowletTypeProperties struct {
	// Flowlet script.
	Script *string `json:"script,omitempty"`

	// Flowlet script lines.
	ScriptLines []*string `json:"scriptLines,omitempty"`

	// List of sinks in Flowlet.
	Sinks []*DataFlowSink `json:"sinks,omitempty"`

	// List of sources in Flowlet.
	Sources []*DataFlowSource `json:"sources,omitempty"`

	// List of transformations in Flowlet.
	Transformations []*Transformation `json:"transformations,omitempty"`
}

// ForEachActivity - This activity is used for iterating over a collection and execute given activities.
type ForEachActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// REQUIRED; ForEach activity properties.
	TypeProperties *ForEachActivityTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type ForEachActivity.
func (f *ForEachActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 f.Name,
		Type:                 f.Type,
		Description:          f.Description,
		DependsOn:            f.DependsOn,
		UserProperties:       f.UserProperties,
		AdditionalProperties: f.AdditionalProperties,
	}
}

// GetControlActivity implements the ControlActivityClassification interface for type ForEachActivity.
func (f *ForEachActivity) GetControlActivity() *ControlActivity {
	return &ControlActivity{
		Name:                 f.Name,
		Type:                 f.Type,
		Description:          f.Description,
		DependsOn:            f.DependsOn,
		UserProperties:       f.UserProperties,
		AdditionalProperties: f.AdditionalProperties,
	}
}

// ForEachActivityTypeProperties - ForEach activity properties.
type ForEachActivityTypeProperties struct {
	// REQUIRED; List of activities to execute .
	Activities []ActivityClassification `json:"activities,omitempty"`

	// REQUIRED; Collection to iterate.
	Items *Expression `json:"items,omitempty"`

	// Batch count to be used for controlling the number of parallel execution (when isSequential is set to false).
	BatchCount *int32 `json:"batchCount,omitempty"`

	// Should the loop be executed in sequence or in parallel (max 50)
	IsSequential *bool `json:"isSequential,omitempty"`
}

// FormatReadSettingsClassification provides polymorphic access to related types.
// Call the interface's GetFormatReadSettings() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *BinaryReadSettings, *DelimitedTextReadSettings, *FormatReadSettings, *JSONReadSettings, *XMLReadSettings
type FormatReadSettingsClassification interface {
	// GetFormatReadSettings returns the FormatReadSettings content of the underlying type.
	GetFormatReadSettings() *FormatReadSettings
}

// FormatReadSettings - Format read settings.
type FormatReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}
}

// GetFormatReadSettings implements the FormatReadSettingsClassification interface for type FormatReadSettings.
func (f *FormatReadSettings) GetFormatReadSettings() *FormatReadSettings { return f }

// FormatWriteSettingsClassification provides polymorphic access to related types.
// Call the interface's GetFormatWriteSettings() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AvroWriteSettings, *DelimitedTextWriteSettings, *FormatWriteSettings, *JSONWriteSettings, *OrcWriteSettings, *ParquetWriteSettings
type FormatWriteSettingsClassification interface {
	// GetFormatWriteSettings returns the FormatWriteSettings content of the underlying type.
	GetFormatWriteSettings() *FormatWriteSettings
}

// FormatWriteSettings - Format write settings.
type FormatWriteSettings struct {
	// REQUIRED; The write setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}
}

// GetFormatWriteSettings implements the FormatWriteSettingsClassification interface for type FormatWriteSettings.
func (f *FormatWriteSettings) GetFormatWriteSettings() *FormatWriteSettings { return f }

// FtpReadSettings - Ftp read settings.
type FtpReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression
	// with resultType boolean).
	DeleteFilesAfterCompletion interface{} `json:"deleteFilesAfterCompletion,omitempty"`

	// If true, disable parallel reading within each file. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableChunking interface{} `json:"disableChunking,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// Indicates whether to enable partition discovery.
	EnablePartitionDiscovery *bool `json:"enablePartitionDiscovery,omitempty"`

	// Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy.
	// Type: string (or Expression with resultType string).
	FileListPath interface{} `json:"fileListPath,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath interface{} `json:"partitionRootPath,omitempty"`

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive interface{} `json:"recursive,omitempty"`

	// Specify whether to use binary transfer mode for FTP stores.
	UseBinaryTransfer *bool `json:"useBinaryTransfer,omitempty"`

	// Ftp wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName interface{} `json:"wildcardFileName,omitempty"`

	// Ftp wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath interface{} `json:"wildcardFolderPath,omitempty"`
}

// GetStoreReadSettings implements the StoreReadSettingsClassification interface for type FtpReadSettings.
func (f *FtpReadSettings) GetStoreReadSettings() *StoreReadSettings {
	return &StoreReadSettings{
		Type:                     f.Type,
		MaxConcurrentConnections: f.MaxConcurrentConnections,
		DisableMetricsCollection: f.DisableMetricsCollection,
		AdditionalProperties:     f.AdditionalProperties,
	}
}

// FtpServerLinkedService - A FTP server Linked Service.
type FtpServerLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Properties specific to this linked service type.
	TypeProperties *FtpServerLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type FtpServerLinkedService.
func (f *FtpServerLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 f.Type,
		ConnectVia:           f.ConnectVia,
		Description:          f.Description,
		Parameters:           f.Parameters,
		Annotations:          f.Annotations,
		AdditionalProperties: f.AdditionalProperties,
	}
}

// FtpServerLinkedServiceTypeProperties - Properties specific to this linked service type.
type FtpServerLinkedServiceTypeProperties struct {
	// REQUIRED; Host name of the FTP server. Type: string (or Expression with resultType string).
	Host interface{} `json:"host,omitempty"`

	// The authentication type to be used to connect to the FTP server.
	AuthenticationType *FtpAuthenticationType `json:"authenticationType,omitempty"`

	// If true, connect to the FTP server over SSL/TLS channel. Default value is true. Type: boolean (or Expression with resultType
	// boolean).
	EnableSSL interface{} `json:"enableSsl,omitempty"`

	// If true, validate the FTP server SSL certificate when connect over SSL/TLS channel. Default value is true. Type: boolean
	// (or Expression with resultType boolean).
	EnableServerCertificateValidation interface{} `json:"enableServerCertificateValidation,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// Password to logon the FTP server.
	Password SecretBaseClassification `json:"password,omitempty"`

	// The TCP port number that the FTP server uses to listen for client connections. Default value is 21. Type: integer (or Expression
	// with resultType integer), minimum: 0.
	Port interface{} `json:"port,omitempty"`

	// Username to logon the FTP server. Type: string (or Expression with resultType string).
	UserName interface{} `json:"userName,omitempty"`
}

// FtpServerLocation - The location of ftp server dataset.
type FtpServerLocation struct {
	// REQUIRED; Type of dataset storage location.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`

	// Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath interface{} `json:"folderPath,omitempty"`
}

// GetDatasetLocation implements the DatasetLocationClassification interface for type FtpServerLocation.
func (f *FtpServerLocation) GetDatasetLocation() *DatasetLocation {
	return &DatasetLocation{
		Type:                 f.Type,
		FolderPath:           f.FolderPath,
		FileName:             f.FileName,
		AdditionalProperties: f.AdditionalProperties,
	}
}

// GenericDatasetTypeProperties - Properties specific to this dataset type.
type GenericDatasetTypeProperties struct {
	// The table name. Type: string (or Expression with resultType string).
	TableName interface{} `json:"tableName,omitempty"`
}

// GetMetadataActivity - Activity to get metadata of dataset
type GetMetadataActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// REQUIRED; GetMetadata activity properties.
	TypeProperties *GetMetadataActivityTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type GetMetadataActivity.
func (g *GetMetadataActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 g.Name,
		Type:                 g.Type,
		Description:          g.Description,
		DependsOn:            g.DependsOn,
		UserProperties:       g.UserProperties,
		AdditionalProperties: g.AdditionalProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type GetMetadataActivity.
func (g *GetMetadataActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		LinkedServiceName:    g.LinkedServiceName,
		Policy:               g.Policy,
		Name:                 g.Name,
		Type:                 g.Type,
		Description:          g.Description,
		DependsOn:            g.DependsOn,
		UserProperties:       g.UserProperties,
		AdditionalProperties: g.AdditionalProperties,
	}
}

// GetMetadataActivityTypeProperties - GetMetadata activity properties.
type GetMetadataActivityTypeProperties struct {
	// REQUIRED; GetMetadata activity dataset reference.
	Dataset *DatasetReference `json:"dataset,omitempty"`

	// Fields of metadata to get from dataset.
	FieldList []interface{} `json:"fieldList,omitempty"`

	// GetMetadata activity format settings.
	FormatSettings FormatReadSettingsClassification `json:"formatSettings,omitempty"`

	// GetMetadata activity store settings.
	StoreSettings StoreReadSettingsClassification `json:"storeSettings,omitempty"`
}

// GetSsisObjectMetadataRequest - The request payload of get SSIS object metadata.
type GetSsisObjectMetadataRequest struct {
	// Metadata path.
	MetadataPath *string `json:"metadataPath,omitempty"`
}

// GitHubAccessTokenRequest - Get GitHub access token request definition.
type GitHubAccessTokenRequest struct {
	// REQUIRED; GitHub access code.
	GitHubAccessCode *string `json:"gitHubAccessCode,omitempty"`

	// REQUIRED; GitHub access token base URL.
	GitHubAccessTokenBaseURL *string `json:"gitHubAccessTokenBaseUrl,omitempty"`

	// GitHub application client ID.
	GitHubClientID *string `json:"gitHubClientId,omitempty"`

	// GitHub bring your own app client secret information.
	GitHubClientSecret *GitHubClientSecret `json:"gitHubClientSecret,omitempty"`
}

// GitHubAccessTokenResponse - Get GitHub access token response definition.
type GitHubAccessTokenResponse struct {
	// GitHub access token.
	GitHubAccessToken *string `json:"gitHubAccessToken,omitempty"`
}

// GitHubClientSecret - Client secret information for factory's bring your own app repository configuration.
type GitHubClientSecret struct {
	// Bring your own app client secret AKV URL.
	ByoaSecretAkvURL *string `json:"byoaSecretAkvUrl,omitempty"`

	// Bring your own app client secret name in AKV.
	ByoaSecretName *string `json:"byoaSecretName,omitempty"`
}

// GlobalParameterListResponse - A list of Global parameters.
type GlobalParameterListResponse struct {
	// REQUIRED; List of global parameters.
	Value []*GlobalParameterResource `json:"value,omitempty"`

	// The link to the next page of results, if any remaining results exist.
	NextLink *string `json:"nextLink,omitempty"`
}

// GlobalParameterResource - Global parameters resource type.
type GlobalParameterResource struct {
	// REQUIRED; Properties of the global parameter.
	Properties map[string]*GlobalParameterSpecification `json:"properties,omitempty"`

	// READ-ONLY; Etag identifies change in the resource.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GlobalParameterSpecification - Definition of a single parameter for an entity.
type GlobalParameterSpecification struct {
	// REQUIRED; Global Parameter type.
	Type *GlobalParameterType `json:"type,omitempty"`

	// REQUIRED; Value of parameter.
	Value interface{} `json:"value,omitempty"`
}

// GlobalParametersClientCreateOrUpdateOptions contains the optional parameters for the GlobalParametersClient.CreateOrUpdate
// method.
type GlobalParametersClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// GlobalParametersClientDeleteOptions contains the optional parameters for the GlobalParametersClient.Delete method.
type GlobalParametersClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// GlobalParametersClientGetOptions contains the optional parameters for the GlobalParametersClient.Get method.
type GlobalParametersClientGetOptions struct {
	// placeholder for future optional parameters
}

// GlobalParametersClientListByFactoryOptions contains the optional parameters for the GlobalParametersClient.ListByFactory
// method.
type GlobalParametersClientListByFactoryOptions struct {
	// placeholder for future optional parameters
}

// GoogleAdWordsLinkedService - Google AdWords service linked service.
type GoogleAdWordsLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Google AdWords service linked service properties.
	TypeProperties *GoogleAdWordsLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type GoogleAdWordsLinkedService.
func (g *GoogleAdWordsLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 g.Type,
		ConnectVia:           g.ConnectVia,
		Description:          g.Description,
		Parameters:           g.Parameters,
		Annotations:          g.Annotations,
		AdditionalProperties: g.AdditionalProperties,
	}
}

// GoogleAdWordsLinkedServiceTypeProperties - Google AdWords service linked service properties.
type GoogleAdWordsLinkedServiceTypeProperties struct {
	// The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication can only be used on self-hosted IR.
	AuthenticationType *GoogleAdWordsAuthenticationType `json:"authenticationType,omitempty"`

	// The Client customer ID of the AdWords account that you want to fetch report data for.
	ClientCustomerID interface{} `json:"clientCustomerID,omitempty"`

	// The client id of the google application used to acquire the refresh token. Type: string (or Expression with resultType
	// string).
	ClientID interface{} `json:"clientId,omitempty"`

	// The client secret of the google application used to acquire the refresh token.
	ClientSecret SecretBaseClassification `json:"clientSecret,omitempty"`

	// Properties used to connect to GoogleAds. It is mutually exclusive with any other properties in the linked service. Type:
	// object.
	ConnectionProperties interface{} `json:"connectionProperties,omitempty"`

	// The developer token associated with the manager account that you use to grant access to the AdWords API.
	DeveloperToken SecretBaseClassification `json:"developerToken,omitempty"`

	// The service account email ID that is used for ServiceAuthentication and can only be used on self-hosted IR.
	Email interface{} `json:"email,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The full path to the .p12 key file that is used to authenticate the service account email address and can only be used
	// on self-hosted IR.
	KeyFilePath interface{} `json:"keyFilePath,omitempty"`

	// The refresh token obtained from Google for authorizing access to AdWords for UserAuthentication.
	RefreshToken SecretBaseClassification `json:"refreshToken,omitempty"`

	// The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This
	// property can only be set when using SSL on self-hosted IR. The default value
	// is the cacerts.pem file installed with the IR.
	TrustedCertPath interface{} `json:"trustedCertPath,omitempty"`

	// Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is
	// false.
	UseSystemTrustStore interface{} `json:"useSystemTrustStore,omitempty"`
}

// GoogleAdWordsObjectDataset - Google AdWords service dataset.
type GoogleAdWordsObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type GoogleAdWordsObjectDataset.
func (g *GoogleAdWordsObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 g.Type,
		Description:          g.Description,
		Structure:            g.Structure,
		Schema:               g.Schema,
		LinkedServiceName:    g.LinkedServiceName,
		Parameters:           g.Parameters,
		Annotations:          g.Annotations,
		Folder:               g.Folder,
		AdditionalProperties: g.AdditionalProperties,
	}
}

// GoogleAdWordsSource - A copy activity Google AdWords service source.
type GoogleAdWordsSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type GoogleAdWordsSource.
func (g *GoogleAdWordsSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     g.Type,
		SourceRetryCount:         g.SourceRetryCount,
		SourceRetryWait:          g.SourceRetryWait,
		MaxConcurrentConnections: g.MaxConcurrentConnections,
		DisableMetricsCollection: g.DisableMetricsCollection,
		AdditionalProperties:     g.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type GoogleAdWordsSource.
func (g *GoogleAdWordsSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             g.QueryTimeout,
		AdditionalColumns:        g.AdditionalColumns,
		Type:                     g.Type,
		SourceRetryCount:         g.SourceRetryCount,
		SourceRetryWait:          g.SourceRetryWait,
		MaxConcurrentConnections: g.MaxConcurrentConnections,
		DisableMetricsCollection: g.DisableMetricsCollection,
		AdditionalProperties:     g.AdditionalProperties,
	}
}

// GoogleBigQueryDatasetTypeProperties - Google BigQuery Dataset Properties
type GoogleBigQueryDatasetTypeProperties struct {
	// The database name of the Google BigQuery. Type: string (or Expression with resultType string).
	Dataset interface{} `json:"dataset,omitempty"`

	// The table name of the Google BigQuery. Type: string (or Expression with resultType string).
	Table interface{} `json:"table,omitempty"`

	// This property will be retired. Please consider using database + table properties instead.
	TableName interface{} `json:"tableName,omitempty"`
}

// GoogleBigQueryLinkedService - Google BigQuery service linked service.
type GoogleBigQueryLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Google BigQuery service linked service properties.
	TypeProperties *GoogleBigQueryLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type GoogleBigQueryLinkedService.
func (g *GoogleBigQueryLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 g.Type,
		ConnectVia:           g.ConnectVia,
		Description:          g.Description,
		Parameters:           g.Parameters,
		Annotations:          g.Annotations,
		AdditionalProperties: g.AdditionalProperties,
	}
}

// GoogleBigQueryLinkedServiceTypeProperties - Google BigQuery service linked service properties.
type GoogleBigQueryLinkedServiceTypeProperties struct {
	// REQUIRED; The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication can only be used on self-hosted
	// IR.
	AuthenticationType *GoogleBigQueryAuthenticationType `json:"authenticationType,omitempty"`

	// REQUIRED; The default BigQuery project to query against.
	Project interface{} `json:"project,omitempty"`

	// A comma-separated list of public BigQuery projects to access.
	AdditionalProjects interface{} `json:"additionalProjects,omitempty"`

	// The client id of the google application used to acquire the refresh token. Type: string (or Expression with resultType
	// string).
	ClientID interface{} `json:"clientId,omitempty"`

	// The client secret of the google application used to acquire the refresh token.
	ClientSecret SecretBaseClassification `json:"clientSecret,omitempty"`

	// The service account email ID that is used for ServiceAuthentication and can only be used on self-hosted IR.
	Email interface{} `json:"email,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The full path to the .p12 key file that is used to authenticate the service account email address and can only be used
	// on self-hosted IR.
	KeyFilePath interface{} `json:"keyFilePath,omitempty"`

	// The refresh token obtained from Google for authorizing access to BigQuery for UserAuthentication.
	RefreshToken SecretBaseClassification `json:"refreshToken,omitempty"`

	// Whether to request access to Google Drive. Allowing Google Drive access enables support for federated tables that combine
	// BigQuery data with data from Google Drive. The default value is false.
	RequestGoogleDriveScope interface{} `json:"requestGoogleDriveScope,omitempty"`

	// The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This
	// property can only be set when using SSL on self-hosted IR. The default value
	// is the cacerts.pem file installed with the IR.
	TrustedCertPath interface{} `json:"trustedCertPath,omitempty"`

	// Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is
	// false.
	UseSystemTrustStore interface{} `json:"useSystemTrustStore,omitempty"`
}

// GoogleBigQueryObjectDataset - Google BigQuery service dataset.
type GoogleBigQueryObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Properties specific to this dataset type.
	TypeProperties *GoogleBigQueryDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type GoogleBigQueryObjectDataset.
func (g *GoogleBigQueryObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 g.Type,
		Description:          g.Description,
		Structure:            g.Structure,
		Schema:               g.Schema,
		LinkedServiceName:    g.LinkedServiceName,
		Parameters:           g.Parameters,
		Annotations:          g.Annotations,
		Folder:               g.Folder,
		AdditionalProperties: g.AdditionalProperties,
	}
}

// GoogleBigQuerySource - A copy activity Google BigQuery service source.
type GoogleBigQuerySource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type GoogleBigQuerySource.
func (g *GoogleBigQuerySource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     g.Type,
		SourceRetryCount:         g.SourceRetryCount,
		SourceRetryWait:          g.SourceRetryWait,
		MaxConcurrentConnections: g.MaxConcurrentConnections,
		DisableMetricsCollection: g.DisableMetricsCollection,
		AdditionalProperties:     g.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type GoogleBigQuerySource.
func (g *GoogleBigQuerySource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             g.QueryTimeout,
		AdditionalColumns:        g.AdditionalColumns,
		Type:                     g.Type,
		SourceRetryCount:         g.SourceRetryCount,
		SourceRetryWait:          g.SourceRetryWait,
		MaxConcurrentConnections: g.MaxConcurrentConnections,
		DisableMetricsCollection: g.DisableMetricsCollection,
		AdditionalProperties:     g.AdditionalProperties,
	}
}

// GoogleCloudStorageLinkedService - Linked service for Google Cloud Storage.
type GoogleCloudStorageLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Google Cloud Storage linked service properties.
	TypeProperties *GoogleCloudStorageLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type GoogleCloudStorageLinkedService.
func (g *GoogleCloudStorageLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 g.Type,
		ConnectVia:           g.ConnectVia,
		Description:          g.Description,
		Parameters:           g.Parameters,
		Annotations:          g.Annotations,
		AdditionalProperties: g.AdditionalProperties,
	}
}

// GoogleCloudStorageLinkedServiceTypeProperties - Google Cloud Storage linked service properties.
type GoogleCloudStorageLinkedServiceTypeProperties struct {
	// The access key identifier of the Google Cloud Storage Identity and Access Management (IAM) user. Type: string (or Expression
	// with resultType string).
	AccessKeyID interface{} `json:"accessKeyId,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The secret access key of the Google Cloud Storage Identity and Access Management (IAM) user.
	SecretAccessKey SecretBaseClassification `json:"secretAccessKey,omitempty"`

	// This value specifies the endpoint to access with the Google Cloud Storage Connector. This is an optional property; change
	// it only if you want to try a different service endpoint or want to switch
	// between https and http. Type: string (or Expression with resultType string).
	ServiceURL interface{} `json:"serviceUrl,omitempty"`
}

// GoogleCloudStorageLocation - The location of Google Cloud Storage dataset.
type GoogleCloudStorageLocation struct {
	// REQUIRED; Type of dataset storage location.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Specify the bucketName of Google Cloud Storage. Type: string (or Expression with resultType string)
	BucketName interface{} `json:"bucketName,omitempty"`

	// Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`

	// Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath interface{} `json:"folderPath,omitempty"`

	// Specify the version of Google Cloud Storage. Type: string (or Expression with resultType string).
	Version interface{} `json:"version,omitempty"`
}

// GetDatasetLocation implements the DatasetLocationClassification interface for type GoogleCloudStorageLocation.
func (g *GoogleCloudStorageLocation) GetDatasetLocation() *DatasetLocation {
	return &DatasetLocation{
		Type:                 g.Type,
		FolderPath:           g.FolderPath,
		FileName:             g.FileName,
		AdditionalProperties: g.AdditionalProperties,
	}
}

// GoogleCloudStorageReadSettings - Google Cloud Storage read settings.
type GoogleCloudStorageReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression
	// with resultType boolean).
	DeleteFilesAfterCompletion interface{} `json:"deleteFilesAfterCompletion,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// Indicates whether to enable partition discovery.
	EnablePartitionDiscovery *bool `json:"enablePartitionDiscovery,omitempty"`

	// Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy.
	// Type: string (or Expression with resultType string).
	FileListPath interface{} `json:"fileListPath,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd interface{} `json:"modifiedDatetimeEnd,omitempty"`

	// The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart interface{} `json:"modifiedDatetimeStart,omitempty"`

	// Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath interface{} `json:"partitionRootPath,omitempty"`

	// The prefix filter for the Google Cloud Storage object name. Type: string (or Expression with resultType string).
	Prefix interface{} `json:"prefix,omitempty"`

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive interface{} `json:"recursive,omitempty"`

	// Google Cloud Storage wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName interface{} `json:"wildcardFileName,omitempty"`

	// Google Cloud Storage wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath interface{} `json:"wildcardFolderPath,omitempty"`
}

// GetStoreReadSettings implements the StoreReadSettingsClassification interface for type GoogleCloudStorageReadSettings.
func (g *GoogleCloudStorageReadSettings) GetStoreReadSettings() *StoreReadSettings {
	return &StoreReadSettings{
		Type:                     g.Type,
		MaxConcurrentConnections: g.MaxConcurrentConnections,
		DisableMetricsCollection: g.DisableMetricsCollection,
		AdditionalProperties:     g.AdditionalProperties,
	}
}

// GoogleSheetsLinkedService - Linked service for GoogleSheets.
type GoogleSheetsLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; GoogleSheets linked service properties.
	TypeProperties *GoogleSheetsLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type GoogleSheetsLinkedService.
func (g *GoogleSheetsLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 g.Type,
		ConnectVia:           g.ConnectVia,
		Description:          g.Description,
		Parameters:           g.Parameters,
		Annotations:          g.Annotations,
		AdditionalProperties: g.AdditionalProperties,
	}
}

// GoogleSheetsLinkedServiceTypeProperties - GoogleSheets linked service type properties.
type GoogleSheetsLinkedServiceTypeProperties struct {
	// REQUIRED; The api token for the GoogleSheets source.
	APIToken SecretBaseClassification `json:"apiToken,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// GreenplumDatasetTypeProperties - Greenplum Dataset Properties
type GreenplumDatasetTypeProperties struct {
	// The schema name of Greenplum. Type: string (or Expression with resultType string).
	Schema interface{} `json:"schema,omitempty"`

	// The table name of Greenplum. Type: string (or Expression with resultType string).
	Table interface{} `json:"table,omitempty"`

	// This property will be retired. Please consider using schema + table properties instead.
	TableName interface{} `json:"tableName,omitempty"`
}

// GreenplumLinkedService - Greenplum Database linked service.
type GreenplumLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Greenplum Database linked service properties.
	TypeProperties *GreenplumLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type GreenplumLinkedService.
func (g *GreenplumLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 g.Type,
		ConnectVia:           g.ConnectVia,
		Description:          g.Description,
		Parameters:           g.Parameters,
		Annotations:          g.Annotations,
		AdditionalProperties: g.AdditionalProperties,
	}
}

// GreenplumLinkedServiceTypeProperties - Greenplum Database linked service properties.
type GreenplumLinkedServiceTypeProperties struct {
	// An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The Azure key vault secret reference of password in connection string.
	Pwd *AzureKeyVaultSecretReference `json:"pwd,omitempty"`
}

// GreenplumSource - A copy activity Greenplum Database source.
type GreenplumSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type GreenplumSource.
func (g *GreenplumSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     g.Type,
		SourceRetryCount:         g.SourceRetryCount,
		SourceRetryWait:          g.SourceRetryWait,
		MaxConcurrentConnections: g.MaxConcurrentConnections,
		DisableMetricsCollection: g.DisableMetricsCollection,
		AdditionalProperties:     g.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type GreenplumSource.
func (g *GreenplumSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             g.QueryTimeout,
		AdditionalColumns:        g.AdditionalColumns,
		Type:                     g.Type,
		SourceRetryCount:         g.SourceRetryCount,
		SourceRetryWait:          g.SourceRetryWait,
		MaxConcurrentConnections: g.MaxConcurrentConnections,
		DisableMetricsCollection: g.DisableMetricsCollection,
		AdditionalProperties:     g.AdditionalProperties,
	}
}

// GreenplumTableDataset - Greenplum Database dataset.
type GreenplumTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Properties specific to this dataset type.
	TypeProperties *GreenplumDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type GreenplumTableDataset.
func (g *GreenplumTableDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 g.Type,
		Description:          g.Description,
		Structure:            g.Structure,
		Schema:               g.Schema,
		LinkedServiceName:    g.LinkedServiceName,
		Parameters:           g.Parameters,
		Annotations:          g.Annotations,
		Folder:               g.Folder,
		AdditionalProperties: g.AdditionalProperties,
	}
}

// HBaseLinkedService - HBase server linked service.
type HBaseLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; HBase server linked service properties.
	TypeProperties *HBaseLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type HBaseLinkedService.
func (h *HBaseLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 h.Type,
		ConnectVia:           h.ConnectVia,
		Description:          h.Description,
		Parameters:           h.Parameters,
		Annotations:          h.Annotations,
		AdditionalProperties: h.AdditionalProperties,
	}
}

// HBaseLinkedServiceTypeProperties - HBase server linked service properties.
type HBaseLinkedServiceTypeProperties struct {
	// REQUIRED; The authentication mechanism to use to connect to the HBase server.
	AuthenticationType *HBaseAuthenticationType `json:"authenticationType,omitempty"`

	// REQUIRED; The IP address or host name of the HBase server. (i.e. 192.168.222.160)
	Host interface{} `json:"host,omitempty"`

	// Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over
	// SSL. The default value is false.
	AllowHostNameCNMismatch interface{} `json:"allowHostNameCNMismatch,omitempty"`

	// Specifies whether to allow self-signed certificates from the server. The default value is false.
	AllowSelfSignedServerCert interface{} `json:"allowSelfSignedServerCert,omitempty"`

	// Specifies whether the connections to the server are encrypted using SSL. The default value is false.
	EnableSSL interface{} `json:"enableSsl,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The partial URL corresponding to the HBase server. (i.e. /gateway/sandbox/hbase/version)
	HTTPPath interface{} `json:"httpPath,omitempty"`

	// The password corresponding to the user name.
	Password SecretBaseClassification `json:"password,omitempty"`

	// The TCP port that the HBase instance uses to listen for client connections. The default value is 9090.
	Port interface{} `json:"port,omitempty"`

	// The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This
	// property can only be set when using SSL on self-hosted IR. The default value
	// is the cacerts.pem file installed with the IR.
	TrustedCertPath interface{} `json:"trustedCertPath,omitempty"`

	// The user name used to connect to the HBase instance.
	Username interface{} `json:"username,omitempty"`
}

// HBaseObjectDataset - HBase server dataset.
type HBaseObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type HBaseObjectDataset.
func (h *HBaseObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 h.Type,
		Description:          h.Description,
		Structure:            h.Structure,
		Schema:               h.Schema,
		LinkedServiceName:    h.LinkedServiceName,
		Parameters:           h.Parameters,
		Annotations:          h.Annotations,
		Folder:               h.Folder,
		AdditionalProperties: h.AdditionalProperties,
	}
}

// HBaseSource - A copy activity HBase server source.
type HBaseSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type HBaseSource.
func (h *HBaseSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     h.Type,
		SourceRetryCount:         h.SourceRetryCount,
		SourceRetryWait:          h.SourceRetryWait,
		MaxConcurrentConnections: h.MaxConcurrentConnections,
		DisableMetricsCollection: h.DisableMetricsCollection,
		AdditionalProperties:     h.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type HBaseSource.
func (h *HBaseSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             h.QueryTimeout,
		AdditionalColumns:        h.AdditionalColumns,
		Type:                     h.Type,
		SourceRetryCount:         h.SourceRetryCount,
		SourceRetryWait:          h.SourceRetryWait,
		MaxConcurrentConnections: h.MaxConcurrentConnections,
		DisableMetricsCollection: h.DisableMetricsCollection,
		AdditionalProperties:     h.AdditionalProperties,
	}
}

// HDInsightHiveActivity - HDInsight Hive activity type.
type HDInsightHiveActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// REQUIRED; HDInsight Hive activity properties.
	TypeProperties *HDInsightHiveActivityTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type HDInsightHiveActivity.
func (h *HDInsightHiveActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 h.Name,
		Type:                 h.Type,
		Description:          h.Description,
		DependsOn:            h.DependsOn,
		UserProperties:       h.UserProperties,
		AdditionalProperties: h.AdditionalProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type HDInsightHiveActivity.
func (h *HDInsightHiveActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		LinkedServiceName:    h.LinkedServiceName,
		Policy:               h.Policy,
		Name:                 h.Name,
		Type:                 h.Type,
		Description:          h.Description,
		DependsOn:            h.DependsOn,
		UserProperties:       h.UserProperties,
		AdditionalProperties: h.AdditionalProperties,
	}
}

// HDInsightHiveActivityTypeProperties - HDInsight Hive activity properties.
type HDInsightHiveActivityTypeProperties struct {
	// User specified arguments to HDInsightActivity.
	Arguments []interface{} `json:"arguments,omitempty"`

	// Allows user to specify defines for Hive job request.
	Defines map[string]interface{} `json:"defines,omitempty"`

	// Debug info option.
	GetDebugInfo *HDInsightActivityDebugInfoOption `json:"getDebugInfo,omitempty"`

	// Query timeout value (in minutes). Effective when the HDInsight cluster is with ESP (Enterprise Security Package)
	QueryTimeout *int32 `json:"queryTimeout,omitempty"`

	// Script linked service reference.
	ScriptLinkedService *LinkedServiceReference `json:"scriptLinkedService,omitempty"`

	// Script path. Type: string (or Expression with resultType string).
	ScriptPath interface{} `json:"scriptPath,omitempty"`

	// Storage linked service references.
	StorageLinkedServices []*LinkedServiceReference `json:"storageLinkedServices,omitempty"`

	// User specified arguments under hivevar namespace.
	Variables []interface{} `json:"variables,omitempty"`
}

// HDInsightLinkedService - HDInsight linked service.
type HDInsightLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; HDInsight linked service properties.
	TypeProperties *HDInsightLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type HDInsightLinkedService.
func (h *HDInsightLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 h.Type,
		ConnectVia:           h.ConnectVia,
		Description:          h.Description,
		Parameters:           h.Parameters,
		Annotations:          h.Annotations,
		AdditionalProperties: h.AdditionalProperties,
	}
}

// HDInsightLinkedServiceTypeProperties - HDInsight linked service properties.
type HDInsightLinkedServiceTypeProperties struct {
	// REQUIRED; HDInsight cluster URI. Type: string (or Expression with resultType string).
	ClusterURI interface{} `json:"clusterUri,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// Specify the FileSystem if the main storage for the HDInsight is ADLS Gen2. Type: string (or Expression with resultType
	// string).
	FileSystem interface{} `json:"fileSystem,omitempty"`

	// A reference to the Azure SQL linked service that points to the HCatalog database.
	HcatalogLinkedServiceName *LinkedServiceReference `json:"hcatalogLinkedServiceName,omitempty"`

	// Specify if the HDInsight is created with ESP (Enterprise Security Package). Type: Boolean.
	IsEspEnabled interface{} `json:"isEspEnabled,omitempty"`

	// The Azure Storage linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// HDInsight cluster password.
	Password SecretBaseClassification `json:"password,omitempty"`

	// HDInsight cluster user name. Type: string (or Expression with resultType string).
	UserName interface{} `json:"userName,omitempty"`
}

// HDInsightMapReduceActivity - HDInsight MapReduce activity type.
type HDInsightMapReduceActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// REQUIRED; HDInsight MapReduce activity properties.
	TypeProperties *HDInsightMapReduceActivityTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type HDInsightMapReduceActivity.
func (h *HDInsightMapReduceActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 h.Name,
		Type:                 h.Type,
		Description:          h.Description,
		DependsOn:            h.DependsOn,
		UserProperties:       h.UserProperties,
		AdditionalProperties: h.AdditionalProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type HDInsightMapReduceActivity.
func (h *HDInsightMapReduceActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		LinkedServiceName:    h.LinkedServiceName,
		Policy:               h.Policy,
		Name:                 h.Name,
		Type:                 h.Type,
		Description:          h.Description,
		DependsOn:            h.DependsOn,
		UserProperties:       h.UserProperties,
		AdditionalProperties: h.AdditionalProperties,
	}
}

// HDInsightMapReduceActivityTypeProperties - HDInsight MapReduce activity properties.
type HDInsightMapReduceActivityTypeProperties struct {
	// REQUIRED; Class name. Type: string (or Expression with resultType string).
	ClassName interface{} `json:"className,omitempty"`

	// REQUIRED; Jar path. Type: string (or Expression with resultType string).
	JarFilePath interface{} `json:"jarFilePath,omitempty"`

	// User specified arguments to HDInsightActivity.
	Arguments []interface{} `json:"arguments,omitempty"`

	// Allows user to specify defines for the MapReduce job request.
	Defines map[string]interface{} `json:"defines,omitempty"`

	// Debug info option.
	GetDebugInfo *HDInsightActivityDebugInfoOption `json:"getDebugInfo,omitempty"`

	// Jar libs.
	JarLibs []interface{} `json:"jarLibs,omitempty"`

	// Jar linked service reference.
	JarLinkedService *LinkedServiceReference `json:"jarLinkedService,omitempty"`

	// Storage linked service references.
	StorageLinkedServices []*LinkedServiceReference `json:"storageLinkedServices,omitempty"`
}

// HDInsightOnDemandLinkedService - HDInsight ondemand linked service.
type HDInsightOnDemandLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; HDInsight ondemand linked service properties.
	TypeProperties *HDInsightOnDemandLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type HDInsightOnDemandLinkedService.
func (h *HDInsightOnDemandLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 h.Type,
		ConnectVia:           h.ConnectVia,
		Description:          h.Description,
		Parameters:           h.Parameters,
		Annotations:          h.Annotations,
		AdditionalProperties: h.AdditionalProperties,
	}
}

// HDInsightOnDemandLinkedServiceTypeProperties - HDInsight ondemand linked service properties.
type HDInsightOnDemandLinkedServiceTypeProperties struct {
	// REQUIRED; The resource group where the cluster belongs. Type: string (or Expression with resultType string).
	ClusterResourceGroup interface{} `json:"clusterResourceGroup,omitempty"`

	// REQUIRED; Number of worker/data nodes in the cluster. Suggestion value: 4. Type: string (or Expression with resultType
	// string).
	ClusterSize interface{} `json:"clusterSize,omitempty"`

	// REQUIRED; The customer’s subscription to host the cluster. Type: string (or Expression with resultType string).
	HostSubscriptionID interface{} `json:"hostSubscriptionId,omitempty"`

	// REQUIRED; Azure Storage linked service to be used by the on-demand cluster for storing and processing data.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; The Tenant id/name to which the service principal belongs. Type: string (or Expression with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`

	// REQUIRED; The allowed idle time for the on-demand HDInsight cluster. Specifies how long the on-demand HDInsight cluster
	// stays alive after completion of an activity run if there are no other active jobs in the
	// cluster. The minimum value is 5 mins. Type: string (or Expression with resultType string).
	TimeToLive interface{} `json:"timeToLive,omitempty"`

	// REQUIRED; Version of the HDInsight cluster. Type: string (or Expression with resultType string).
	Version interface{} `json:"version,omitempty"`

	// Specifies additional storage accounts for the HDInsight linked service so that the Data Factory service can register them
	// on your behalf.
	AdditionalLinkedServiceNames []*LinkedServiceReference `json:"additionalLinkedServiceNames,omitempty"`

	// The prefix of cluster name, postfix will be distinct with timestamp. Type: string (or Expression with resultType string).
	ClusterNamePrefix interface{} `json:"clusterNamePrefix,omitempty"`

	// The password to access the cluster.
	ClusterPassword SecretBaseClassification `json:"clusterPassword,omitempty"`

	// The password to SSH remotely connect cluster’s node (for Linux).
	ClusterSSHPassword SecretBaseClassification `json:"clusterSshPassword,omitempty"`

	// The username to SSH remotely connect to cluster’s node (for Linux). Type: string (or Expression with resultType string).
	ClusterSSHUserName interface{} `json:"clusterSshUserName,omitempty"`

	// The cluster type. Type: string (or Expression with resultType string).
	ClusterType interface{} `json:"clusterType,omitempty"`

	// The username to access the cluster. Type: string (or Expression with resultType string).
	ClusterUserName interface{} `json:"clusterUserName,omitempty"`

	// Specifies the core configuration parameters (as in core-site.xml) for the HDInsight cluster to be created.
	CoreConfiguration interface{} `json:"coreConfiguration,omitempty"`

	// The credential reference containing authentication information.
	Credential *CredentialReference `json:"credential,omitempty"`

	// Specifies the size of the data node for the HDInsight cluster.
	DataNodeSize interface{} `json:"dataNodeSize,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// Specifies the HBase configuration parameters (hbase-site.xml) for the HDInsight cluster.
	HBaseConfiguration interface{} `json:"hBaseConfiguration,omitempty"`

	// The name of Azure SQL linked service that point to the HCatalog database. The on-demand HDInsight cluster is created by
	// using the Azure SQL database as the metastore.
	HcatalogLinkedServiceName *LinkedServiceReference `json:"hcatalogLinkedServiceName,omitempty"`

	// Specifies the HDFS configuration parameters (hdfs-site.xml) for the HDInsight cluster.
	HdfsConfiguration interface{} `json:"hdfsConfiguration,omitempty"`

	// Specifies the size of the head node for the HDInsight cluster.
	HeadNodeSize interface{} `json:"headNodeSize,omitempty"`

	// Specifies the hive configuration parameters (hive-site.xml) for the HDInsight cluster.
	HiveConfiguration interface{} `json:"hiveConfiguration,omitempty"`

	// Specifies the MapReduce configuration parameters (mapred-site.xml) for the HDInsight cluster.
	MapReduceConfiguration interface{} `json:"mapReduceConfiguration,omitempty"`

	// Specifies the Oozie configuration parameters (oozie-site.xml) for the HDInsight cluster.
	OozieConfiguration interface{} `json:"oozieConfiguration,omitempty"`

	// Custom script actions to run on HDI ondemand cluster once it's up. Please refer to
	// https://docs.microsoft.com/en-us/azure/hdinsight/hdinsight-hadoop-customize-cluster-linux?toc=%2Fen-us%2Fazure%2Fhdinsight%2Fr-server%2FTOC.json&bc=%2Fen-us%2Fazure%2Fbread%2Ftoc.json#understanding-script-actions.
	ScriptActions []*ScriptAction `json:"scriptActions,omitempty"`

	// The service principal id for the hostSubscriptionId. Type: string (or Expression with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`

	// The key for the service principal id.
	ServicePrincipalKey SecretBaseClassification `json:"servicePrincipalKey,omitempty"`

	// The version of spark if the cluster type is 'spark'. Type: string (or Expression with resultType string).
	SparkVersion interface{} `json:"sparkVersion,omitempty"`

	// Specifies the Storm configuration parameters (storm-site.xml) for the HDInsight cluster.
	StormConfiguration interface{} `json:"stormConfiguration,omitempty"`

	// The ARM resource ID for the subnet in the vNet. If virtualNetworkId was specified, then this property is required. Type:
	// string (or Expression with resultType string).
	SubnetName interface{} `json:"subnetName,omitempty"`

	// The ARM resource ID for the vNet to which the cluster should be joined after creation. Type: string (or Expression with
	// resultType string).
	VirtualNetworkID interface{} `json:"virtualNetworkId,omitempty"`

	// Specifies the Yarn configuration parameters (yarn-site.xml) for the HDInsight cluster.
	YarnConfiguration interface{} `json:"yarnConfiguration,omitempty"`

	// Specifies the size of the Zoo Keeper node for the HDInsight cluster.
	ZookeeperNodeSize interface{} `json:"zookeeperNodeSize,omitempty"`
}

// HDInsightPigActivity - HDInsight Pig activity type.
type HDInsightPigActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// REQUIRED; HDInsight Pig activity properties.
	TypeProperties *HDInsightPigActivityTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type HDInsightPigActivity.
func (h *HDInsightPigActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 h.Name,
		Type:                 h.Type,
		Description:          h.Description,
		DependsOn:            h.DependsOn,
		UserProperties:       h.UserProperties,
		AdditionalProperties: h.AdditionalProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type HDInsightPigActivity.
func (h *HDInsightPigActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		LinkedServiceName:    h.LinkedServiceName,
		Policy:               h.Policy,
		Name:                 h.Name,
		Type:                 h.Type,
		Description:          h.Description,
		DependsOn:            h.DependsOn,
		UserProperties:       h.UserProperties,
		AdditionalProperties: h.AdditionalProperties,
	}
}

// HDInsightPigActivityTypeProperties - HDInsight Pig activity properties.
type HDInsightPigActivityTypeProperties struct {
	// User specified arguments to HDInsightActivity. Type: array (or Expression with resultType array).
	Arguments interface{} `json:"arguments,omitempty"`

	// Allows user to specify defines for Pig job request.
	Defines map[string]interface{} `json:"defines,omitempty"`

	// Debug info option.
	GetDebugInfo *HDInsightActivityDebugInfoOption `json:"getDebugInfo,omitempty"`

	// Script linked service reference.
	ScriptLinkedService *LinkedServiceReference `json:"scriptLinkedService,omitempty"`

	// Script path. Type: string (or Expression with resultType string).
	ScriptPath interface{} `json:"scriptPath,omitempty"`

	// Storage linked service references.
	StorageLinkedServices []*LinkedServiceReference `json:"storageLinkedServices,omitempty"`
}

// HDInsightSparkActivity - HDInsight Spark activity.
type HDInsightSparkActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// REQUIRED; HDInsight spark activity properties.
	TypeProperties *HDInsightSparkActivityTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type HDInsightSparkActivity.
func (h *HDInsightSparkActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 h.Name,
		Type:                 h.Type,
		Description:          h.Description,
		DependsOn:            h.DependsOn,
		UserProperties:       h.UserProperties,
		AdditionalProperties: h.AdditionalProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type HDInsightSparkActivity.
func (h *HDInsightSparkActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		LinkedServiceName:    h.LinkedServiceName,
		Policy:               h.Policy,
		Name:                 h.Name,
		Type:                 h.Type,
		Description:          h.Description,
		DependsOn:            h.DependsOn,
		UserProperties:       h.UserProperties,
		AdditionalProperties: h.AdditionalProperties,
	}
}

// HDInsightSparkActivityTypeProperties - HDInsight spark activity properties.
type HDInsightSparkActivityTypeProperties struct {
	// REQUIRED; The relative path to the root folder of the code/package to be executed. Type: string (or Expression with resultType
	// string).
	EntryFilePath interface{} `json:"entryFilePath,omitempty"`

	// REQUIRED; The root path in 'sparkJobLinkedService' for all the job’s files. Type: string (or Expression with resultType
	// string).
	RootPath interface{} `json:"rootPath,omitempty"`

	// The user-specified arguments to HDInsightSparkActivity.
	Arguments []interface{} `json:"arguments,omitempty"`

	// The application's Java/Spark main class.
	ClassName *string `json:"className,omitempty"`

	// Debug info option.
	GetDebugInfo *HDInsightActivityDebugInfoOption `json:"getDebugInfo,omitempty"`

	// The user to impersonate that will execute the job. Type: string (or Expression with resultType string).
	ProxyUser interface{} `json:"proxyUser,omitempty"`

	// Spark configuration property.
	SparkConfig map[string]interface{} `json:"sparkConfig,omitempty"`

	// The storage linked service for uploading the entry file and dependencies, and for receiving logs.
	SparkJobLinkedService *LinkedServiceReference `json:"sparkJobLinkedService,omitempty"`
}

// HDInsightStreamingActivity - HDInsight streaming activity type.
type HDInsightStreamingActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// REQUIRED; HDInsight streaming activity properties.
	TypeProperties *HDInsightStreamingActivityTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type HDInsightStreamingActivity.
func (h *HDInsightStreamingActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 h.Name,
		Type:                 h.Type,
		Description:          h.Description,
		DependsOn:            h.DependsOn,
		UserProperties:       h.UserProperties,
		AdditionalProperties: h.AdditionalProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type HDInsightStreamingActivity.
func (h *HDInsightStreamingActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		LinkedServiceName:    h.LinkedServiceName,
		Policy:               h.Policy,
		Name:                 h.Name,
		Type:                 h.Type,
		Description:          h.Description,
		DependsOn:            h.DependsOn,
		UserProperties:       h.UserProperties,
		AdditionalProperties: h.AdditionalProperties,
	}
}

// HDInsightStreamingActivityTypeProperties - HDInsight streaming activity properties.
type HDInsightStreamingActivityTypeProperties struct {
	// REQUIRED; Paths to streaming job files. Can be directories.
	FilePaths []interface{} `json:"filePaths,omitempty"`

	// REQUIRED; Input blob path. Type: string (or Expression with resultType string).
	Input interface{} `json:"input,omitempty"`

	// REQUIRED; Mapper executable name. Type: string (or Expression with resultType string).
	Mapper interface{} `json:"mapper,omitempty"`

	// REQUIRED; Output blob path. Type: string (or Expression with resultType string).
	Output interface{} `json:"output,omitempty"`

	// REQUIRED; Reducer executable name. Type: string (or Expression with resultType string).
	Reducer interface{} `json:"reducer,omitempty"`

	// User specified arguments to HDInsightActivity.
	Arguments []interface{} `json:"arguments,omitempty"`

	// Combiner executable name. Type: string (or Expression with resultType string).
	Combiner interface{} `json:"combiner,omitempty"`

	// Command line environment values.
	CommandEnvironment []interface{} `json:"commandEnvironment,omitempty"`

	// Allows user to specify defines for streaming job request.
	Defines map[string]interface{} `json:"defines,omitempty"`

	// Linked service reference where the files are located.
	FileLinkedService *LinkedServiceReference `json:"fileLinkedService,omitempty"`

	// Debug info option.
	GetDebugInfo *HDInsightActivityDebugInfoOption `json:"getDebugInfo,omitempty"`

	// Storage linked service references.
	StorageLinkedServices []*LinkedServiceReference `json:"storageLinkedServices,omitempty"`
}

// HTTPDataset - A file in an HTTP web server.
type HTTPDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Properties specific to this dataset type.
	TypeProperties *HTTPDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type HTTPDataset.
func (h *HTTPDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 h.Type,
		Description:          h.Description,
		Structure:            h.Structure,
		Schema:               h.Schema,
		LinkedServiceName:    h.LinkedServiceName,
		Parameters:           h.Parameters,
		Annotations:          h.Annotations,
		Folder:               h.Folder,
		AdditionalProperties: h.AdditionalProperties,
	}
}

// HTTPDatasetTypeProperties - Properties specific to this dataset type.
type HTTPDatasetTypeProperties struct {
	// The headers for the HTTP Request. e.g. request-header-name-1:request-header-value-1 … request-header-name-n:request-header-value-n
	// Type: string (or Expression with resultType string).
	AdditionalHeaders interface{} `json:"additionalHeaders,omitempty"`

	// The data compression method used on files.
	Compression *DatasetCompression `json:"compression,omitempty"`

	// The format of files.
	Format DatasetStorageFormatClassification `json:"format,omitempty"`

	// The relative URL based on the URL in the HttpLinkedService refers to an HTTP file Type: string (or Expression with resultType
	// string).
	RelativeURL interface{} `json:"relativeUrl,omitempty"`

	// The body for the HTTP request. Type: string (or Expression with resultType string).
	RequestBody interface{} `json:"requestBody,omitempty"`

	// The HTTP method for the HTTP request. Type: string (or Expression with resultType string).
	RequestMethod interface{} `json:"requestMethod,omitempty"`
}

// HTTPLinkedService - Linked service for an HTTP source.
type HTTPLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Properties specific to this linked service type.
	TypeProperties *HTTPLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type HTTPLinkedService.
func (h *HTTPLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 h.Type,
		ConnectVia:           h.ConnectVia,
		Description:          h.Description,
		Parameters:           h.Parameters,
		Annotations:          h.Annotations,
		AdditionalProperties: h.AdditionalProperties,
	}
}

// HTTPLinkedServiceTypeProperties - Properties specific to this linked service type.
type HTTPLinkedServiceTypeProperties struct {
	// REQUIRED; The base URL of the HTTP endpoint, e.g. https://www.microsoft.com. Type: string (or Expression with resultType
	// string).
	URL interface{} `json:"url,omitempty"`

	// The additional HTTP headers in the request to RESTful API used for authorization. Type: object (or Expression with resultType
	// object).
	AuthHeaders interface{} `json:"authHeaders,omitempty"`

	// The authentication type to be used to connect to the HTTP server.
	AuthenticationType *HTTPAuthenticationType `json:"authenticationType,omitempty"`

	// Thumbprint of certificate for ClientCertificate authentication. Only valid for on-premises copy. For on-premises copy with
	// ClientCertificate authentication, either CertThumbprint or
	// EmbeddedCertData/Password should be specified. Type: string (or Expression with resultType string).
	CertThumbprint interface{} `json:"certThumbprint,omitempty"`

	// Base64 encoded certificate data for ClientCertificate authentication. For on-premises copy with ClientCertificate authentication,
	// either CertThumbprint or EmbeddedCertData/Password should be
	// specified. Type: string (or Expression with resultType string).
	EmbeddedCertData interface{} `json:"embeddedCertData,omitempty"`

	// If true, validate the HTTPS server SSL certificate. Default value is true. Type: boolean (or Expression with resultType
	// boolean).
	EnableServerCertificateValidation interface{} `json:"enableServerCertificateValidation,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// Password for Basic, Digest, Windows, or ClientCertificate with EmbeddedCertData authentication.
	Password SecretBaseClassification `json:"password,omitempty"`

	// User name for Basic, Digest, or Windows authentication. Type: string (or Expression with resultType string).
	UserName interface{} `json:"userName,omitempty"`
}

// HTTPReadSettings - Sftp read settings.
type HTTPReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string `json:"type,omitempty"`

	// The additional HTTP headers in the request to the RESTful API. Type: string (or Expression with resultType string).
	AdditionalHeaders interface{} `json:"additionalHeaders,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// Indicates whether to enable partition discovery.
	EnablePartitionDiscovery *bool `json:"enablePartitionDiscovery,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath interface{} `json:"partitionRootPath,omitempty"`

	// The HTTP request body to the RESTful API if requestMethod is POST. Type: string (or Expression with resultType string).
	RequestBody interface{} `json:"requestBody,omitempty"`

	// The HTTP method used to call the RESTful API. The default is GET. Type: string (or Expression with resultType string).
	RequestMethod interface{} `json:"requestMethod,omitempty"`

	// Specifies the timeout for a HTTP client to get HTTP response from HTTP server.
	RequestTimeout interface{} `json:"requestTimeout,omitempty"`
}

// GetStoreReadSettings implements the StoreReadSettingsClassification interface for type HTTPReadSettings.
func (h *HTTPReadSettings) GetStoreReadSettings() *StoreReadSettings {
	return &StoreReadSettings{
		Type:                     h.Type,
		MaxConcurrentConnections: h.MaxConcurrentConnections,
		DisableMetricsCollection: h.DisableMetricsCollection,
		AdditionalProperties:     h.AdditionalProperties,
	}
}

// HTTPServerLocation - The location of http server.
type HTTPServerLocation struct {
	// REQUIRED; Type of dataset storage location.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`

	// Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath interface{} `json:"folderPath,omitempty"`

	// Specify the relativeUrl of http server. Type: string (or Expression with resultType string)
	RelativeURL interface{} `json:"relativeUrl,omitempty"`
}

// GetDatasetLocation implements the DatasetLocationClassification interface for type HTTPServerLocation.
func (h *HTTPServerLocation) GetDatasetLocation() *DatasetLocation {
	return &DatasetLocation{
		Type:                 h.Type,
		FolderPath:           h.FolderPath,
		FileName:             h.FileName,
		AdditionalProperties: h.AdditionalProperties,
	}
}

// HTTPSource - A copy activity source for an HTTP file.
type HTTPSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// Specifies the timeout for a HTTP client to get HTTP response from HTTP server. The default value is equivalent to System.Net.HttpWebRequest.Timeout.
	// Type: string (or Expression with resultType
	// string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	HTTPRequestTimeout interface{} `json:"httpRequestTimeout,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type HTTPSource.
func (h *HTTPSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     h.Type,
		SourceRetryCount:         h.SourceRetryCount,
		SourceRetryWait:          h.SourceRetryWait,
		MaxConcurrentConnections: h.MaxConcurrentConnections,
		DisableMetricsCollection: h.DisableMetricsCollection,
		AdditionalProperties:     h.AdditionalProperties,
	}
}

// HdfsLinkedService - Hadoop Distributed File System (HDFS) linked service.
type HdfsLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; HDFS linked service properties.
	TypeProperties *HdfsLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type HdfsLinkedService.
func (h *HdfsLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 h.Type,
		ConnectVia:           h.ConnectVia,
		Description:          h.Description,
		Parameters:           h.Parameters,
		Annotations:          h.Annotations,
		AdditionalProperties: h.AdditionalProperties,
	}
}

// HdfsLinkedServiceTypeProperties - HDFS linked service properties.
type HdfsLinkedServiceTypeProperties struct {
	// REQUIRED; The URL of the HDFS service endpoint, e.g. http://myhostname:50070/webhdfs/v1 . Type: string (or Expression with
	// resultType string).
	URL interface{} `json:"url,omitempty"`

	// Type of authentication used to connect to the HDFS. Possible values are: Anonymous and Windows. Type: string (or Expression
	// with resultType string).
	AuthenticationType interface{} `json:"authenticationType,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// Password for Windows authentication.
	Password SecretBaseClassification `json:"password,omitempty"`

	// User name for Windows authentication. Type: string (or Expression with resultType string).
	UserName interface{} `json:"userName,omitempty"`
}

// HdfsLocation - The location of HDFS.
type HdfsLocation struct {
	// REQUIRED; Type of dataset storage location.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`

	// Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath interface{} `json:"folderPath,omitempty"`
}

// GetDatasetLocation implements the DatasetLocationClassification interface for type HdfsLocation.
func (h *HdfsLocation) GetDatasetLocation() *DatasetLocation {
	return &DatasetLocation{
		Type:                 h.Type,
		FolderPath:           h.FolderPath,
		FileName:             h.FileName,
		AdditionalProperties: h.AdditionalProperties,
	}
}

// HdfsReadSettings - HDFS read settings.
type HdfsReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression
	// with resultType boolean).
	DeleteFilesAfterCompletion interface{} `json:"deleteFilesAfterCompletion,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// Specifies Distcp-related settings.
	DistcpSettings *DistcpSettings `json:"distcpSettings,omitempty"`

	// Indicates whether to enable partition discovery.
	EnablePartitionDiscovery *bool `json:"enablePartitionDiscovery,omitempty"`

	// Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy.
	// Type: string (or Expression with resultType string).
	FileListPath interface{} `json:"fileListPath,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd interface{} `json:"modifiedDatetimeEnd,omitempty"`

	// The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart interface{} `json:"modifiedDatetimeStart,omitempty"`

	// Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath interface{} `json:"partitionRootPath,omitempty"`

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive interface{} `json:"recursive,omitempty"`

	// HDFS wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName interface{} `json:"wildcardFileName,omitempty"`

	// HDFS wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath interface{} `json:"wildcardFolderPath,omitempty"`
}

// GetStoreReadSettings implements the StoreReadSettingsClassification interface for type HdfsReadSettings.
func (h *HdfsReadSettings) GetStoreReadSettings() *StoreReadSettings {
	return &StoreReadSettings{
		Type:                     h.Type,
		MaxConcurrentConnections: h.MaxConcurrentConnections,
		DisableMetricsCollection: h.DisableMetricsCollection,
		AdditionalProperties:     h.AdditionalProperties,
	}
}

// HdfsSource - A copy activity HDFS source.
type HdfsSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// Specifies Distcp-related settings.
	DistcpSettings *DistcpSettings `json:"distcpSettings,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive interface{} `json:"recursive,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type HdfsSource.
func (h *HdfsSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     h.Type,
		SourceRetryCount:         h.SourceRetryCount,
		SourceRetryWait:          h.SourceRetryWait,
		MaxConcurrentConnections: h.MaxConcurrentConnections,
		DisableMetricsCollection: h.DisableMetricsCollection,
		AdditionalProperties:     h.AdditionalProperties,
	}
}

// HiveDatasetTypeProperties - Hive Properties
type HiveDatasetTypeProperties struct {
	// The schema name of the Hive. Type: string (or Expression with resultType string).
	Schema interface{} `json:"schema,omitempty"`

	// The table name of the Hive. Type: string (or Expression with resultType string).
	Table interface{} `json:"table,omitempty"`

	// This property will be retired. Please consider using schema + table properties instead.
	TableName interface{} `json:"tableName,omitempty"`
}

// HiveLinkedService - Hive Server linked service.
type HiveLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Hive Server linked service properties.
	TypeProperties *HiveLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type HiveLinkedService.
func (h *HiveLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 h.Type,
		ConnectVia:           h.ConnectVia,
		Description:          h.Description,
		Parameters:           h.Parameters,
		Annotations:          h.Annotations,
		AdditionalProperties: h.AdditionalProperties,
	}
}

// HiveLinkedServiceTypeProperties - Hive Server linked service properties.
type HiveLinkedServiceTypeProperties struct {
	// REQUIRED; The authentication method used to access the Hive server.
	AuthenticationType *HiveAuthenticationType `json:"authenticationType,omitempty"`

	// REQUIRED; IP address or host name of the Hive server, separated by ';' for multiple hosts (only when serviceDiscoveryMode
	// is enable).
	Host interface{} `json:"host,omitempty"`

	// Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over
	// SSL. The default value is false.
	AllowHostNameCNMismatch interface{} `json:"allowHostNameCNMismatch,omitempty"`

	// Specifies whether to allow self-signed certificates from the server. The default value is false.
	AllowSelfSignedServerCert interface{} `json:"allowSelfSignedServerCert,omitempty"`

	// Specifies whether the connections to the server are encrypted using SSL. The default value is false.
	EnableSSL interface{} `json:"enableSsl,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The partial URL corresponding to the Hive server.
	HTTPPath interface{} `json:"httpPath,omitempty"`

	// The password corresponding to the user name that you provided in the Username field
	Password SecretBaseClassification `json:"password,omitempty"`

	// The TCP port that the Hive server uses to listen for client connections.
	Port interface{} `json:"port,omitempty"`

	// The type of Hive server.
	ServerType *HiveServerType `json:"serverType,omitempty"`

	// true to indicate using the ZooKeeper service, false not.
	ServiceDiscoveryMode interface{} `json:"serviceDiscoveryMode,omitempty"`

	// The transport protocol to use in the Thrift layer.
	ThriftTransportProtocol *HiveThriftTransportProtocol `json:"thriftTransportProtocol,omitempty"`

	// The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This
	// property can only be set when using SSL on self-hosted IR. The default value
	// is the cacerts.pem file installed with the IR.
	TrustedCertPath interface{} `json:"trustedCertPath,omitempty"`

	// Specifies whether the driver uses native HiveQL queries,or converts them into an equivalent form in HiveQL.
	UseNativeQuery interface{} `json:"useNativeQuery,omitempty"`

	// Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is
	// false.
	UseSystemTrustStore interface{} `json:"useSystemTrustStore,omitempty"`

	// The user name that you use to access Hive Server.
	Username interface{} `json:"username,omitempty"`

	// The namespace on ZooKeeper under which Hive Server 2 nodes are added.
	ZooKeeperNameSpace interface{} `json:"zooKeeperNameSpace,omitempty"`
}

// HiveObjectDataset - Hive Server dataset.
type HiveObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Properties specific to this dataset type.
	TypeProperties *HiveDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type HiveObjectDataset.
func (h *HiveObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 h.Type,
		Description:          h.Description,
		Structure:            h.Structure,
		Schema:               h.Schema,
		LinkedServiceName:    h.LinkedServiceName,
		Parameters:           h.Parameters,
		Annotations:          h.Annotations,
		Folder:               h.Folder,
		AdditionalProperties: h.AdditionalProperties,
	}
}

// HiveSource - A copy activity Hive Server source.
type HiveSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type HiveSource.
func (h *HiveSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     h.Type,
		SourceRetryCount:         h.SourceRetryCount,
		SourceRetryWait:          h.SourceRetryWait,
		MaxConcurrentConnections: h.MaxConcurrentConnections,
		DisableMetricsCollection: h.DisableMetricsCollection,
		AdditionalProperties:     h.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type HiveSource.
func (h *HiveSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             h.QueryTimeout,
		AdditionalColumns:        h.AdditionalColumns,
		Type:                     h.Type,
		SourceRetryCount:         h.SourceRetryCount,
		SourceRetryWait:          h.SourceRetryWait,
		MaxConcurrentConnections: h.MaxConcurrentConnections,
		DisableMetricsCollection: h.DisableMetricsCollection,
		AdditionalProperties:     h.AdditionalProperties,
	}
}

// HubspotLinkedService - Hubspot Service linked service.
type HubspotLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Hubspot Service linked service properties.
	TypeProperties *HubspotLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type HubspotLinkedService.
func (h *HubspotLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 h.Type,
		ConnectVia:           h.ConnectVia,
		Description:          h.Description,
		Parameters:           h.Parameters,
		Annotations:          h.Annotations,
		AdditionalProperties: h.AdditionalProperties,
	}
}

// HubspotLinkedServiceTypeProperties - Hubspot Service linked service properties.
type HubspotLinkedServiceTypeProperties struct {
	// REQUIRED; The client ID associated with your Hubspot application.
	ClientID interface{} `json:"clientId,omitempty"`

	// The access token obtained when initially authenticating your OAuth integration.
	AccessToken SecretBaseClassification `json:"accessToken,omitempty"`

	// The client secret associated with your Hubspot application.
	ClientSecret SecretBaseClassification `json:"clientSecret,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The refresh token obtained when initially authenticating your OAuth integration.
	RefreshToken SecretBaseClassification `json:"refreshToken,omitempty"`

	// Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
	UseEncryptedEndpoints interface{} `json:"useEncryptedEndpoints,omitempty"`

	// Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting
	// over SSL. The default value is true.
	UseHostVerification interface{} `json:"useHostVerification,omitempty"`

	// Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
	UsePeerVerification interface{} `json:"usePeerVerification,omitempty"`
}

// HubspotObjectDataset - Hubspot Service dataset.
type HubspotObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type HubspotObjectDataset.
func (h *HubspotObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 h.Type,
		Description:          h.Description,
		Structure:            h.Structure,
		Schema:               h.Schema,
		LinkedServiceName:    h.LinkedServiceName,
		Parameters:           h.Parameters,
		Annotations:          h.Annotations,
		Folder:               h.Folder,
		AdditionalProperties: h.AdditionalProperties,
	}
}

// HubspotSource - A copy activity Hubspot Service source.
type HubspotSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type HubspotSource.
func (h *HubspotSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     h.Type,
		SourceRetryCount:         h.SourceRetryCount,
		SourceRetryWait:          h.SourceRetryWait,
		MaxConcurrentConnections: h.MaxConcurrentConnections,
		DisableMetricsCollection: h.DisableMetricsCollection,
		AdditionalProperties:     h.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type HubspotSource.
func (h *HubspotSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             h.QueryTimeout,
		AdditionalColumns:        h.AdditionalColumns,
		Type:                     h.Type,
		SourceRetryCount:         h.SourceRetryCount,
		SourceRetryWait:          h.SourceRetryWait,
		MaxConcurrentConnections: h.MaxConcurrentConnections,
		DisableMetricsCollection: h.DisableMetricsCollection,
		AdditionalProperties:     h.AdditionalProperties,
	}
}

// IfConditionActivity - This activity evaluates a boolean expression and executes either the activities under the ifTrueActivities
// property or the ifFalseActivities property depending on the result of the expression.
type IfConditionActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// REQUIRED; IfCondition activity properties.
	TypeProperties *IfConditionActivityTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type IfConditionActivity.
func (i *IfConditionActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 i.Name,
		Type:                 i.Type,
		Description:          i.Description,
		DependsOn:            i.DependsOn,
		UserProperties:       i.UserProperties,
		AdditionalProperties: i.AdditionalProperties,
	}
}

// GetControlActivity implements the ControlActivityClassification interface for type IfConditionActivity.
func (i *IfConditionActivity) GetControlActivity() *ControlActivity {
	return &ControlActivity{
		Name:                 i.Name,
		Type:                 i.Type,
		Description:          i.Description,
		DependsOn:            i.DependsOn,
		UserProperties:       i.UserProperties,
		AdditionalProperties: i.AdditionalProperties,
	}
}

// IfConditionActivityTypeProperties - IfCondition activity properties.
type IfConditionActivityTypeProperties struct {
	// REQUIRED; An expression that would evaluate to Boolean. This is used to determine the block of activities (ifTrueActivities
	// or ifFalseActivities) that will be executed.
	Expression *Expression `json:"expression,omitempty"`

	// List of activities to execute if expression is evaluated to false. This is an optional property and if not provided, the
	// activity will exit without any action.
	IfFalseActivities []ActivityClassification `json:"ifFalseActivities,omitempty"`

	// List of activities to execute if expression is evaluated to true. This is an optional property and if not provided, the
	// activity will exit without any action.
	IfTrueActivities []ActivityClassification `json:"ifTrueActivities,omitempty"`
}

// ImpalaDatasetTypeProperties - Impala Dataset Properties
type ImpalaDatasetTypeProperties struct {
	// The schema name of the Impala. Type: string (or Expression with resultType string).
	Schema interface{} `json:"schema,omitempty"`

	// The table name of the Impala. Type: string (or Expression with resultType string).
	Table interface{} `json:"table,omitempty"`

	// This property will be retired. Please consider using schema + table properties instead.
	TableName interface{} `json:"tableName,omitempty"`
}

// ImpalaLinkedService - Impala server linked service.
type ImpalaLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Impala server linked service properties.
	TypeProperties *ImpalaLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type ImpalaLinkedService.
func (i *ImpalaLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 i.Type,
		ConnectVia:           i.ConnectVia,
		Description:          i.Description,
		Parameters:           i.Parameters,
		Annotations:          i.Annotations,
		AdditionalProperties: i.AdditionalProperties,
	}
}

// ImpalaLinkedServiceTypeProperties - Impala server linked service properties.
type ImpalaLinkedServiceTypeProperties struct {
	// REQUIRED; The authentication type to use.
	AuthenticationType *ImpalaAuthenticationType `json:"authenticationType,omitempty"`

	// REQUIRED; The IP address or host name of the Impala server. (i.e. 192.168.222.160)
	Host interface{} `json:"host,omitempty"`

	// Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over
	// SSL. The default value is false.
	AllowHostNameCNMismatch interface{} `json:"allowHostNameCNMismatch,omitempty"`

	// Specifies whether to allow self-signed certificates from the server. The default value is false.
	AllowSelfSignedServerCert interface{} `json:"allowSelfSignedServerCert,omitempty"`

	// Specifies whether the connections to the server are encrypted using SSL. The default value is false.
	EnableSSL interface{} `json:"enableSsl,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The password corresponding to the user name when using UsernameAndPassword.
	Password SecretBaseClassification `json:"password,omitempty"`

	// The TCP port that the Impala server uses to listen for client connections. The default value is 21050.
	Port interface{} `json:"port,omitempty"`

	// The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This
	// property can only be set when using SSL on self-hosted IR. The default value
	// is the cacerts.pem file installed with the IR.
	TrustedCertPath interface{} `json:"trustedCertPath,omitempty"`

	// Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is
	// false.
	UseSystemTrustStore interface{} `json:"useSystemTrustStore,omitempty"`

	// The user name used to access the Impala server. The default value is anonymous when using SASLUsername.
	Username interface{} `json:"username,omitempty"`
}

// ImpalaObjectDataset - Impala server dataset.
type ImpalaObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Properties specific to this dataset type.
	TypeProperties *ImpalaDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type ImpalaObjectDataset.
func (i *ImpalaObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 i.Type,
		Description:          i.Description,
		Structure:            i.Structure,
		Schema:               i.Schema,
		LinkedServiceName:    i.LinkedServiceName,
		Parameters:           i.Parameters,
		Annotations:          i.Annotations,
		Folder:               i.Folder,
		AdditionalProperties: i.AdditionalProperties,
	}
}

// ImpalaSource - A copy activity Impala server source.
type ImpalaSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type ImpalaSource.
func (i *ImpalaSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     i.Type,
		SourceRetryCount:         i.SourceRetryCount,
		SourceRetryWait:          i.SourceRetryWait,
		MaxConcurrentConnections: i.MaxConcurrentConnections,
		DisableMetricsCollection: i.DisableMetricsCollection,
		AdditionalProperties:     i.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type ImpalaSource.
func (i *ImpalaSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             i.QueryTimeout,
		AdditionalColumns:        i.AdditionalColumns,
		Type:                     i.Type,
		SourceRetryCount:         i.SourceRetryCount,
		SourceRetryWait:          i.SourceRetryWait,
		MaxConcurrentConnections: i.MaxConcurrentConnections,
		DisableMetricsCollection: i.DisableMetricsCollection,
		AdditionalProperties:     i.AdditionalProperties,
	}
}

// ImportSettingsClassification provides polymorphic access to related types.
// Call the interface's GetImportSettings() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AzureDatabricksDeltaLakeImportCommand, *ImportSettings, *SnowflakeImportCopyCommand
type ImportSettingsClassification interface {
	// GetImportSettings returns the ImportSettings content of the underlying type.
	GetImportSettings() *ImportSettings
}

// ImportSettings - Import command settings.
type ImportSettings struct {
	// REQUIRED; The import setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}
}

// GetImportSettings implements the ImportSettingsClassification interface for type ImportSettings.
func (i *ImportSettings) GetImportSettings() *ImportSettings { return i }

// InformixLinkedService - Informix linked service.
type InformixLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Informix linked service properties.
	TypeProperties *InformixLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type InformixLinkedService.
func (i *InformixLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 i.Type,
		ConnectVia:           i.ConnectVia,
		Description:          i.Description,
		Parameters:           i.Parameters,
		Annotations:          i.Annotations,
		AdditionalProperties: i.AdditionalProperties,
	}
}

// InformixLinkedServiceTypeProperties - Informix linked service properties.
type InformixLinkedServiceTypeProperties struct {
	// REQUIRED; The non-access credential portion of the connection string as well as an optional encrypted credential. Type:
	// string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`

	// Type of authentication used to connect to the Informix as ODBC data store. Possible values are: Anonymous and Basic. Type:
	// string (or Expression with resultType string).
	AuthenticationType interface{} `json:"authenticationType,omitempty"`

	// The access credential portion of the connection string specified in driver-specific property-value format.
	Credential SecretBaseClassification `json:"credential,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// Password for Basic authentication.
	Password SecretBaseClassification `json:"password,omitempty"`

	// User name for Basic authentication. Type: string (or Expression with resultType string).
	UserName interface{} `json:"userName,omitempty"`
}

// InformixSink - A copy activity Informix sink.
type InformixSink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to execute before starting the copy. Type: string (or Expression with resultType string).
	PreCopyScript interface{} `json:"preCopyScript,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type InformixSink.
func (i *InformixSink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     i.Type,
		WriteBatchSize:           i.WriteBatchSize,
		WriteBatchTimeout:        i.WriteBatchTimeout,
		SinkRetryCount:           i.SinkRetryCount,
		SinkRetryWait:            i.SinkRetryWait,
		MaxConcurrentConnections: i.MaxConcurrentConnections,
		DisableMetricsCollection: i.DisableMetricsCollection,
		AdditionalProperties:     i.AdditionalProperties,
	}
}

// InformixSource - A copy activity source for Informix.
type InformixSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Database query. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type InformixSource.
func (i *InformixSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     i.Type,
		SourceRetryCount:         i.SourceRetryCount,
		SourceRetryWait:          i.SourceRetryWait,
		MaxConcurrentConnections: i.MaxConcurrentConnections,
		DisableMetricsCollection: i.DisableMetricsCollection,
		AdditionalProperties:     i.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type InformixSource.
func (i *InformixSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             i.QueryTimeout,
		AdditionalColumns:        i.AdditionalColumns,
		Type:                     i.Type,
		SourceRetryCount:         i.SourceRetryCount,
		SourceRetryWait:          i.SourceRetryWait,
		MaxConcurrentConnections: i.MaxConcurrentConnections,
		DisableMetricsCollection: i.DisableMetricsCollection,
		AdditionalProperties:     i.AdditionalProperties,
	}
}

// InformixTableDataset - The Informix table dataset.
type InformixTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Informix table dataset properties.
	TypeProperties *InformixTableDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type InformixTableDataset.
func (i *InformixTableDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 i.Type,
		Description:          i.Description,
		Structure:            i.Structure,
		Schema:               i.Schema,
		LinkedServiceName:    i.LinkedServiceName,
		Parameters:           i.Parameters,
		Annotations:          i.Annotations,
		Folder:               i.Folder,
		AdditionalProperties: i.AdditionalProperties,
	}
}

// InformixTableDatasetTypeProperties - Informix table dataset properties.
type InformixTableDatasetTypeProperties struct {
	// The Informix table name. Type: string (or Expression with resultType string).
	TableName interface{} `json:"tableName,omitempty"`
}

// IntegrationRuntimeClassification provides polymorphic access to related types.
// Call the interface's GetIntegrationRuntime() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *IntegrationRuntime, *ManagedIntegrationRuntime, *SelfHostedIntegrationRuntime
type IntegrationRuntimeClassification interface {
	// GetIntegrationRuntime returns the IntegrationRuntime content of the underlying type.
	GetIntegrationRuntime() *IntegrationRuntime
}

// IntegrationRuntime - Azure Data Factory nested object which serves as a compute resource for activities.
type IntegrationRuntime struct {
	// REQUIRED; Type of integration runtime.
	Type *IntegrationRuntimeType `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Integration runtime description.
	Description *string `json:"description,omitempty"`
}

// GetIntegrationRuntime implements the IntegrationRuntimeClassification interface for type IntegrationRuntime.
func (i *IntegrationRuntime) GetIntegrationRuntime() *IntegrationRuntime { return i }

// IntegrationRuntimeAuthKeys - The integration runtime authentication keys.
type IntegrationRuntimeAuthKeys struct {
	// The primary integration runtime authentication key.
	AuthKey1 *string `json:"authKey1,omitempty"`

	// The secondary integration runtime authentication key.
	AuthKey2 *string `json:"authKey2,omitempty"`
}

// IntegrationRuntimeComputeProperties - The compute resource properties for managed integration runtime.
type IntegrationRuntimeComputeProperties struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Data flow properties for managed integration runtime.
	DataFlowProperties *IntegrationRuntimeDataFlowProperties `json:"dataFlowProperties,omitempty"`

	// The location for managed integration runtime. The supported regions could be found on https://docs.microsoft.com/en-us/azure/data-factory/data-factory-data-movement-activities
	Location *string `json:"location,omitempty"`

	// Maximum parallel executions count per node for managed integration runtime.
	MaxParallelExecutionsPerNode *int32 `json:"maxParallelExecutionsPerNode,omitempty"`

	// The node size requirement to managed integration runtime.
	NodeSize *string `json:"nodeSize,omitempty"`

	// The required number of nodes for managed integration runtime.
	NumberOfNodes *int32 `json:"numberOfNodes,omitempty"`

	// VNet properties for managed integration runtime.
	VNetProperties *IntegrationRuntimeVNetProperties `json:"vNetProperties,omitempty"`
}

// IntegrationRuntimeConnectionInfo - Connection information for encrypting the on-premises data source credentials.
type IntegrationRuntimeConnectionInfo struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// READ-ONLY; The on-premises integration runtime host URL.
	HostServiceURI *string `json:"hostServiceUri,omitempty" azure:"ro"`

	// READ-ONLY; The integration runtime SSL certificate thumbprint. Click-Once application uses it to do server validation.
	IdentityCertThumbprint *string `json:"identityCertThumbprint,omitempty" azure:"ro"`

	// READ-ONLY; Whether the identity certificate is expired.
	IsIdentityCertExprired *bool `json:"isIdentityCertExprired,omitempty" azure:"ro"`

	// READ-ONLY; The public key for encrypting a credential when transferring the credential to the integration runtime.
	PublicKey *string `json:"publicKey,omitempty" azure:"ro"`

	// READ-ONLY; The token generated in service. Callers use this token to authenticate to integration runtime.
	ServiceToken *string `json:"serviceToken,omitempty" azure:"ro"`

	// READ-ONLY; The integration runtime version.
	Version *string `json:"version,omitempty" azure:"ro"`
}

// IntegrationRuntimeCustomSetupScriptProperties - Custom setup script properties for a managed dedicated integration runtime.
type IntegrationRuntimeCustomSetupScriptProperties struct {
	// The URI of the Azure blob container that contains the custom setup script.
	BlobContainerURI *string `json:"blobContainerUri,omitempty"`

	// The SAS token of the Azure blob container.
	SasToken *SecureString `json:"sasToken,omitempty"`
}

// IntegrationRuntimeCustomerVirtualNetwork - The definition and properties of virtual network to which Azure-SSIS integration
// runtime will join.
type IntegrationRuntimeCustomerVirtualNetwork struct {
	// The ID of subnet to which Azure-SSIS integration runtime will join.
	SubnetID *string `json:"subnetId,omitempty"`
}

// IntegrationRuntimeDataFlowProperties - Data flow properties for managed integration runtime.
type IntegrationRuntimeDataFlowProperties struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Cluster will not be recycled and it will be used in next data flow activity run until TTL (time to live) is reached if
	// this is set as false. Default is true.
	Cleanup *bool `json:"cleanup,omitempty"`

	// Compute type of the cluster which will execute data flow job.
	ComputeType *DataFlowComputeType `json:"computeType,omitempty"`

	// Core count of the cluster which will execute data flow job. Supported values are: 8, 16, 32, 48, 80, 144 and 272.
	CoreCount *int32 `json:"coreCount,omitempty"`

	// Time to live (in minutes) setting of the cluster which will execute data flow job.
	TimeToLive *int32 `json:"timeToLive,omitempty"`
}

// IntegrationRuntimeDataProxyProperties - Data proxy properties for a managed dedicated integration runtime.
type IntegrationRuntimeDataProxyProperties struct {
	// The self-hosted integration runtime reference.
	ConnectVia *EntityReference `json:"connectVia,omitempty"`

	// The path to contain the staged data in the Blob storage.
	Path *string `json:"path,omitempty"`

	// The staging linked service reference.
	StagingLinkedService *EntityReference `json:"stagingLinkedService,omitempty"`
}

// IntegrationRuntimeDebugResource - Integration runtime debug resource.
type IntegrationRuntimeDebugResource struct {
	// REQUIRED; Integration runtime properties.
	Properties IntegrationRuntimeClassification `json:"properties,omitempty"`

	// The resource name.
	Name *string `json:"name,omitempty"`
}

// IntegrationRuntimeListResponse - A list of integration runtime resources.
type IntegrationRuntimeListResponse struct {
	// REQUIRED; List of integration runtimes.
	Value []*IntegrationRuntimeResource `json:"value,omitempty"`

	// The link to the next page of results, if any remaining results exist.
	NextLink *string `json:"nextLink,omitempty"`
}

// IntegrationRuntimeMonitoringData - Get monitoring data response.
type IntegrationRuntimeMonitoringData struct {
	// Integration runtime name.
	Name *string `json:"name,omitempty"`

	// Integration runtime node monitoring data.
	Nodes []*IntegrationRuntimeNodeMonitoringData `json:"nodes,omitempty"`
}

// IntegrationRuntimeNodeIPAddress - The IP address of self-hosted integration runtime node.
type IntegrationRuntimeNodeIPAddress struct {
	// READ-ONLY; The IP address of self-hosted integration runtime node.
	IPAddress *string `json:"ipAddress,omitempty" azure:"ro"`
}

// IntegrationRuntimeNodeMonitoringData - Monitoring data for integration runtime node.
type IntegrationRuntimeNodeMonitoringData struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// READ-ONLY; Available memory (MB) on the integration runtime node.
	AvailableMemoryInMB *int32 `json:"availableMemoryInMB,omitempty" azure:"ro"`

	// READ-ONLY; CPU percentage on the integration runtime node.
	CPUUtilization *int32 `json:"cpuUtilization,omitempty" azure:"ro"`

	// READ-ONLY; Maximum concurrent jobs on the integration runtime node.
	ConcurrentJobsLimit *int32 `json:"concurrentJobsLimit,omitempty" azure:"ro"`

	// READ-ONLY; The number of jobs currently running on the integration runtime node.
	ConcurrentJobsRunning *int32 `json:"concurrentJobsRunning,omitempty" azure:"ro"`

	// READ-ONLY; The maximum concurrent jobs in this integration runtime.
	MaxConcurrentJobs *int32 `json:"maxConcurrentJobs,omitempty" azure:"ro"`

	// READ-ONLY; Name of the integration runtime node.
	NodeName *string `json:"nodeName,omitempty" azure:"ro"`

	// READ-ONLY; Received bytes on the integration runtime node.
	ReceivedBytes *float32 `json:"receivedBytes,omitempty" azure:"ro"`

	// READ-ONLY; Sent bytes on the integration runtime node.
	SentBytes *float32 `json:"sentBytes,omitempty" azure:"ro"`
}

// IntegrationRuntimeNodesClientDeleteOptions contains the optional parameters for the IntegrationRuntimeNodesClient.Delete
// method.
type IntegrationRuntimeNodesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimeNodesClientGetIPAddressOptions contains the optional parameters for the IntegrationRuntimeNodesClient.GetIPAddress
// method.
type IntegrationRuntimeNodesClientGetIPAddressOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimeNodesClientGetOptions contains the optional parameters for the IntegrationRuntimeNodesClient.Get method.
type IntegrationRuntimeNodesClientGetOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimeNodesClientUpdateOptions contains the optional parameters for the IntegrationRuntimeNodesClient.Update
// method.
type IntegrationRuntimeNodesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimeObjectMetadataClientBeginRefreshOptions contains the optional parameters for the IntegrationRuntimeObjectMetadataClient.BeginRefresh
// method.
type IntegrationRuntimeObjectMetadataClientBeginRefreshOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IntegrationRuntimeObjectMetadataClientGetOptions contains the optional parameters for the IntegrationRuntimeObjectMetadataClient.Get
// method.
type IntegrationRuntimeObjectMetadataClientGetOptions struct {
	// The parameters for getting a SSIS object metadata.
	GetMetadataRequest *GetSsisObjectMetadataRequest
}

// IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint - Azure-SSIS integration runtime outbound network dependency
// endpoints for one category.
type IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint struct {
	// The category of outbound network dependency.
	Category *string `json:"category,omitempty"`

	// The endpoints for outbound network dependency.
	Endpoints []*IntegrationRuntimeOutboundNetworkDependenciesEndpoint `json:"endpoints,omitempty"`
}

// IntegrationRuntimeOutboundNetworkDependenciesEndpoint - The endpoint for Azure-SSIS integration runtime outbound network
// dependency.
type IntegrationRuntimeOutboundNetworkDependenciesEndpoint struct {
	// The domain name of endpoint.
	DomainName *string `json:"domainName,omitempty"`

	// The details of endpoint.
	EndpointDetails []*IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails `json:"endpointDetails,omitempty"`
}

// IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails - The details of Azure-SSIS integration runtime outbound network
// dependency endpoint.
type IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails struct {
	// The port of endpoint.
	Port *int32 `json:"port,omitempty"`
}

// IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponse - Azure-SSIS integration runtime outbound network dependency
// endpoints.
type IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponse struct {
	// The list of outbound network dependency endpoints.
	Value []*IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint `json:"value,omitempty"`
}

// IntegrationRuntimeReference - Integration runtime reference type.
type IntegrationRuntimeReference struct {
	// REQUIRED; Reference integration runtime name.
	ReferenceName *string `json:"referenceName,omitempty"`

	// REQUIRED; Type of integration runtime.
	Type *IntegrationRuntimeReferenceType `json:"type,omitempty"`

	// Arguments for integration runtime.
	Parameters map[string]interface{} `json:"parameters,omitempty"`
}

// IntegrationRuntimeRegenerateKeyParameters - Parameters to regenerate the authentication key.
type IntegrationRuntimeRegenerateKeyParameters struct {
	// The name of the authentication key to regenerate.
	KeyName *IntegrationRuntimeAuthKeyName `json:"keyName,omitempty"`
}

// IntegrationRuntimeResource - Integration runtime resource type.
type IntegrationRuntimeResource struct {
	// REQUIRED; Integration runtime properties.
	Properties IntegrationRuntimeClassification `json:"properties,omitempty"`

	// READ-ONLY; Etag identifies change in the resource.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// IntegrationRuntimeSsisCatalogInfo - Catalog information for managed dedicated integration runtime.
type IntegrationRuntimeSsisCatalogInfo struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// The password of the administrator user account of the catalog database.
	CatalogAdminPassword *SecureString `json:"catalogAdminPassword,omitempty"`

	// The administrator user name of catalog database.
	CatalogAdminUserName *string `json:"catalogAdminUserName,omitempty"`

	// The pricing tier for the catalog database. The valid values could be found in https://azure.microsoft.com/en-us/pricing/details/sql-database/
	CatalogPricingTier *IntegrationRuntimeSsisCatalogPricingTier `json:"catalogPricingTier,omitempty"`

	// The catalog database server URL.
	CatalogServerEndpoint *string `json:"catalogServerEndpoint,omitempty"`

	// The dual standby pair name of Azure-SSIS Integration Runtimes to support SSISDB failover.
	DualStandbyPairName *string `json:"dualStandbyPairName,omitempty"`
}

// IntegrationRuntimeSsisProperties - SSIS properties for managed integration runtime.
type IntegrationRuntimeSsisProperties struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Catalog information for managed dedicated integration runtime.
	CatalogInfo *IntegrationRuntimeSsisCatalogInfo `json:"catalogInfo,omitempty"`

	// The credential reference containing authentication information.
	Credential *CredentialReference `json:"credential,omitempty"`

	// Custom setup script properties for a managed dedicated integration runtime.
	CustomSetupScriptProperties *IntegrationRuntimeCustomSetupScriptProperties `json:"customSetupScriptProperties,omitempty"`

	// Data proxy properties for a managed dedicated integration runtime.
	DataProxyProperties *IntegrationRuntimeDataProxyProperties `json:"dataProxyProperties,omitempty"`

	// The edition for the SSIS Integration Runtime
	Edition *IntegrationRuntimeEdition `json:"edition,omitempty"`

	// Custom setup without script properties for a SSIS integration runtime.
	ExpressCustomSetupProperties []CustomSetupBaseClassification `json:"expressCustomSetupProperties,omitempty"`

	// License type for bringing your own license scenario.
	LicenseType *IntegrationRuntimeLicenseType `json:"licenseType,omitempty"`

	// Package stores for the SSIS Integration Runtime.
	PackageStores []*PackageStore `json:"packageStores,omitempty"`
}

// IntegrationRuntimeStatusClassification provides polymorphic access to related types.
// Call the interface's GetIntegrationRuntimeStatus() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *IntegrationRuntimeStatus, *ManagedIntegrationRuntimeStatus, *SelfHostedIntegrationRuntimeStatus
type IntegrationRuntimeStatusClassification interface {
	// GetIntegrationRuntimeStatus returns the IntegrationRuntimeStatus content of the underlying type.
	GetIntegrationRuntimeStatus() *IntegrationRuntimeStatus
}

// IntegrationRuntimeStatus - Integration runtime status.
type IntegrationRuntimeStatus struct {
	// REQUIRED; Type of integration runtime.
	Type *IntegrationRuntimeType `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// READ-ONLY; The data factory name which the integration runtime belong to.
	DataFactoryName *string `json:"dataFactoryName,omitempty" azure:"ro"`

	// READ-ONLY; The state of integration runtime.
	State *IntegrationRuntimeState `json:"state,omitempty" azure:"ro"`
}

// GetIntegrationRuntimeStatus implements the IntegrationRuntimeStatusClassification interface for type IntegrationRuntimeStatus.
func (i *IntegrationRuntimeStatus) GetIntegrationRuntimeStatus() *IntegrationRuntimeStatus { return i }

// IntegrationRuntimeStatusResponse - Integration runtime status response.
type IntegrationRuntimeStatusResponse struct {
	// REQUIRED; Integration runtime properties.
	Properties IntegrationRuntimeStatusClassification `json:"properties,omitempty"`

	// READ-ONLY; The integration runtime name.
	Name *string `json:"name,omitempty" azure:"ro"`
}

// IntegrationRuntimeVNetProperties - VNet properties for managed integration runtime.
type IntegrationRuntimeVNetProperties struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Resource IDs of the public IP addresses that this integration runtime will use.
	PublicIPs []*string `json:"publicIPs,omitempty"`

	// The name of the subnet this integration runtime will join.
	Subnet *string `json:"subnet,omitempty"`

	// The ID of subnet, to which this Azure-SSIS integration runtime will be joined.
	SubnetID *string `json:"subnetId,omitempty"`

	// The ID of the VNet that this integration runtime will join.
	VNetID *string `json:"vNetId,omitempty"`
}

// IntegrationRuntimesClientBeginStartOptions contains the optional parameters for the IntegrationRuntimesClient.BeginStart
// method.
type IntegrationRuntimesClientBeginStartOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IntegrationRuntimesClientBeginStopOptions contains the optional parameters for the IntegrationRuntimesClient.BeginStop
// method.
type IntegrationRuntimesClientBeginStopOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// IntegrationRuntimesClientCreateLinkedIntegrationRuntimeOptions contains the optional parameters for the IntegrationRuntimesClient.CreateLinkedIntegrationRuntime
// method.
type IntegrationRuntimesClientCreateLinkedIntegrationRuntimeOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimesClientCreateOrUpdateOptions contains the optional parameters for the IntegrationRuntimesClient.CreateOrUpdate
// method.
type IntegrationRuntimesClientCreateOrUpdateOptions struct {
	// ETag of the integration runtime entity. Should only be specified for update, for which it should match existing entity
	// or can be * for unconditional update.
	IfMatch *string
}

// IntegrationRuntimesClientDeleteOptions contains the optional parameters for the IntegrationRuntimesClient.Delete method.
type IntegrationRuntimesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimesClientGetConnectionInfoOptions contains the optional parameters for the IntegrationRuntimesClient.GetConnectionInfo
// method.
type IntegrationRuntimesClientGetConnectionInfoOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimesClientGetMonitoringDataOptions contains the optional parameters for the IntegrationRuntimesClient.GetMonitoringData
// method.
type IntegrationRuntimesClientGetMonitoringDataOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimesClientGetOptions contains the optional parameters for the IntegrationRuntimesClient.Get method.
type IntegrationRuntimesClientGetOptions struct {
	// ETag of the integration runtime entity. Should only be specified for get. If the ETag matches the existing entity tag,
	// or if * was provided, then no content will be returned.
	IfNoneMatch *string
}

// IntegrationRuntimesClientGetStatusOptions contains the optional parameters for the IntegrationRuntimesClient.GetStatus
// method.
type IntegrationRuntimesClientGetStatusOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimesClientListAuthKeysOptions contains the optional parameters for the IntegrationRuntimesClient.ListAuthKeys
// method.
type IntegrationRuntimesClientListAuthKeysOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimesClientListByFactoryOptions contains the optional parameters for the IntegrationRuntimesClient.ListByFactory
// method.
type IntegrationRuntimesClientListByFactoryOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimesClientListOutboundNetworkDependenciesEndpointsOptions contains the optional parameters for the IntegrationRuntimesClient.ListOutboundNetworkDependenciesEndpoints
// method.
type IntegrationRuntimesClientListOutboundNetworkDependenciesEndpointsOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimesClientRegenerateAuthKeyOptions contains the optional parameters for the IntegrationRuntimesClient.RegenerateAuthKey
// method.
type IntegrationRuntimesClientRegenerateAuthKeyOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimesClientRemoveLinksOptions contains the optional parameters for the IntegrationRuntimesClient.RemoveLinks
// method.
type IntegrationRuntimesClientRemoveLinksOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimesClientSyncCredentialsOptions contains the optional parameters for the IntegrationRuntimesClient.SyncCredentials
// method.
type IntegrationRuntimesClientSyncCredentialsOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimesClientUpdateOptions contains the optional parameters for the IntegrationRuntimesClient.Update method.
type IntegrationRuntimesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// IntegrationRuntimesClientUpgradeOptions contains the optional parameters for the IntegrationRuntimesClient.Upgrade method.
type IntegrationRuntimesClientUpgradeOptions struct {
	// placeholder for future optional parameters
}

// JSONDataset - Json dataset.
type JSONDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Json dataset properties.
	TypeProperties *JSONDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type JSONDataset.
func (j *JSONDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 j.Type,
		Description:          j.Description,
		Structure:            j.Structure,
		Schema:               j.Schema,
		LinkedServiceName:    j.LinkedServiceName,
		Parameters:           j.Parameters,
		Annotations:          j.Annotations,
		Folder:               j.Folder,
		AdditionalProperties: j.AdditionalProperties,
	}
}

// JSONDatasetTypeProperties - Json dataset properties.
type JSONDatasetTypeProperties struct {
	// REQUIRED; The location of the json data storage.
	Location DatasetLocationClassification `json:"location,omitempty"`

	// The data compression method used for the json dataset.
	Compression *DatasetCompression `json:"compression,omitempty"`

	// The code page name of the preferred encoding. If not specified, the default value is UTF-8, unless BOM denotes another
	// Unicode encoding. Refer to the name column of the table in the following link to
	// set supported values: https://msdn.microsoft.com/library/system.text.encoding.aspx. Type: string (or Expression with resultType
	// string).
	EncodingName interface{} `json:"encodingName,omitempty"`
}

// JSONFormat - The data stored in JSON format.
type JSONFormat struct {
	// REQUIRED; Type of dataset storage format.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Deserializer. Type: string (or Expression with resultType string).
	Deserializer interface{} `json:"deserializer,omitempty"`

	// The code page name of the preferred encoding. If not provided, the default value is 'utf-8', unless the byte order mark
	// (BOM) denotes another Unicode encoding. The full list of supported values can be
	// found in the 'Name' column of the table of encodings in the following reference: https://go.microsoft.com/fwlink/?linkid=861078.
	// Type: string (or Expression with resultType string).
	EncodingName interface{} `json:"encodingName,omitempty"`

	// File pattern of JSON. To be more specific, the way of separating a collection of JSON objects. The default value is 'setOfObjects'.
	// It is case-sensitive.
	FilePattern interface{} `json:"filePattern,omitempty"`

	// The JSONPath of the JSON array element to be flattened. Example: "$.ArrayPath". Type: string (or Expression with resultType
	// string).
	JSONNodeReference interface{} `json:"jsonNodeReference,omitempty"`

	// The JSONPath definition for each column mapping with a customized column name to extract data from JSON file. For fields
	// under root object, start with "$"; for fields inside the array chosen by
	// jsonNodeReference property, start from the array element. Example: {"Column1": "$.Column1Path", "Column2": "Column2PathInArray"}.
	// Type: object (or Expression with resultType object).
	JSONPathDefinition interface{} `json:"jsonPathDefinition,omitempty"`

	// The character used to separate nesting levels. Default value is '.' (dot). Type: string (or Expression with resultType
	// string).
	NestingSeparator interface{} `json:"nestingSeparator,omitempty"`

	// Serializer. Type: string (or Expression with resultType string).
	Serializer interface{} `json:"serializer,omitempty"`
}

// GetDatasetStorageFormat implements the DatasetStorageFormatClassification interface for type JSONFormat.
func (j *JSONFormat) GetDatasetStorageFormat() *DatasetStorageFormat {
	return &DatasetStorageFormat{
		Type:                 j.Type,
		Serializer:           j.Serializer,
		Deserializer:         j.Deserializer,
		AdditionalProperties: j.AdditionalProperties,
	}
}

// JSONReadSettings - Json read settings.
type JSONReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Compression settings.
	CompressionProperties CompressionReadSettingsClassification `json:"compressionProperties,omitempty"`
}

// GetFormatReadSettings implements the FormatReadSettingsClassification interface for type JSONReadSettings.
func (j *JSONReadSettings) GetFormatReadSettings() *FormatReadSettings {
	return &FormatReadSettings{
		Type:                 j.Type,
		AdditionalProperties: j.AdditionalProperties,
	}
}

// JSONSink - A copy activity Json sink.
type JSONSink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// Json format settings.
	FormatSettings *JSONWriteSettings `json:"formatSettings,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// Json store settings.
	StoreSettings StoreWriteSettingsClassification `json:"storeSettings,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type JSONSink.
func (j *JSONSink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     j.Type,
		WriteBatchSize:           j.WriteBatchSize,
		WriteBatchTimeout:        j.WriteBatchTimeout,
		SinkRetryCount:           j.SinkRetryCount,
		SinkRetryWait:            j.SinkRetryWait,
		MaxConcurrentConnections: j.MaxConcurrentConnections,
		DisableMetricsCollection: j.DisableMetricsCollection,
		AdditionalProperties:     j.AdditionalProperties,
	}
}

// JSONSource - A copy activity Json source.
type JSONSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// Json format settings.
	FormatSettings *JSONReadSettings `json:"formatSettings,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`

	// Json store settings.
	StoreSettings StoreReadSettingsClassification `json:"storeSettings,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type JSONSource.
func (j *JSONSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     j.Type,
		SourceRetryCount:         j.SourceRetryCount,
		SourceRetryWait:          j.SourceRetryWait,
		MaxConcurrentConnections: j.MaxConcurrentConnections,
		DisableMetricsCollection: j.DisableMetricsCollection,
		AdditionalProperties:     j.AdditionalProperties,
	}
}

// JSONWriteSettings - Json write settings.
type JSONWriteSettings struct {
	// REQUIRED; The write setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// File pattern of JSON. This setting controls the way a collection of JSON objects will be treated. The default value is
	// 'setOfObjects'. It is case-sensitive.
	FilePattern interface{} `json:"filePattern,omitempty"`
}

// GetFormatWriteSettings implements the FormatWriteSettingsClassification interface for type JSONWriteSettings.
func (j *JSONWriteSettings) GetFormatWriteSettings() *FormatWriteSettings {
	return &FormatWriteSettings{
		Type:                 j.Type,
		AdditionalProperties: j.AdditionalProperties,
	}
}

// JiraLinkedService - Jira Service linked service.
type JiraLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Jira Service linked service properties.
	TypeProperties *JiraLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type JiraLinkedService.
func (j *JiraLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 j.Type,
		ConnectVia:           j.ConnectVia,
		Description:          j.Description,
		Parameters:           j.Parameters,
		Annotations:          j.Annotations,
		AdditionalProperties: j.AdditionalProperties,
	}
}

// JiraLinkedServiceTypeProperties - Jira Service linked service properties.
type JiraLinkedServiceTypeProperties struct {
	// REQUIRED; The IP address or host name of the Jira service. (e.g. jira.example.com)
	Host interface{} `json:"host,omitempty"`

	// REQUIRED; The user name that you use to access Jira Service.
	Username interface{} `json:"username,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The password corresponding to the user name that you provided in the username field.
	Password SecretBaseClassification `json:"password,omitempty"`

	// The TCP port that the Jira server uses to listen for client connections. The default value is 443 if connecting through
	// HTTPS, or 8080 if connecting through HTTP.
	Port interface{} `json:"port,omitempty"`

	// Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
	UseEncryptedEndpoints interface{} `json:"useEncryptedEndpoints,omitempty"`

	// Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting
	// over SSL. The default value is true.
	UseHostVerification interface{} `json:"useHostVerification,omitempty"`

	// Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
	UsePeerVerification interface{} `json:"usePeerVerification,omitempty"`
}

// JiraObjectDataset - Jira Service dataset.
type JiraObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type JiraObjectDataset.
func (j *JiraObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 j.Type,
		Description:          j.Description,
		Structure:            j.Structure,
		Schema:               j.Schema,
		LinkedServiceName:    j.LinkedServiceName,
		Parameters:           j.Parameters,
		Annotations:          j.Annotations,
		Folder:               j.Folder,
		AdditionalProperties: j.AdditionalProperties,
	}
}

// JiraSource - A copy activity Jira Service source.
type JiraSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type JiraSource.
func (j *JiraSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     j.Type,
		SourceRetryCount:         j.SourceRetryCount,
		SourceRetryWait:          j.SourceRetryWait,
		MaxConcurrentConnections: j.MaxConcurrentConnections,
		DisableMetricsCollection: j.DisableMetricsCollection,
		AdditionalProperties:     j.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type JiraSource.
func (j *JiraSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             j.QueryTimeout,
		AdditionalColumns:        j.AdditionalColumns,
		Type:                     j.Type,
		SourceRetryCount:         j.SourceRetryCount,
		SourceRetryWait:          j.SourceRetryWait,
		MaxConcurrentConnections: j.MaxConcurrentConnections,
		DisableMetricsCollection: j.DisableMetricsCollection,
		AdditionalProperties:     j.AdditionalProperties,
	}
}

// LicensedComponentSetupTypeProperties - Installation of licensed component setup type properties.
type LicensedComponentSetupTypeProperties struct {
	// REQUIRED; The name of the 3rd party component.
	ComponentName *string `json:"componentName,omitempty"`

	// The license key to activate the component.
	LicenseKey SecretBaseClassification `json:"licenseKey,omitempty"`
}

// LinkedIntegrationRuntime - The linked integration runtime information.
type LinkedIntegrationRuntime struct {
	// READ-ONLY; The creating time of the linked integration runtime.
	CreateTime *time.Time `json:"createTime,omitempty" azure:"ro"`

	// READ-ONLY; The location of the data factory for which the linked integration runtime belong to.
	DataFactoryLocation *string `json:"dataFactoryLocation,omitempty" azure:"ro"`

	// READ-ONLY; The name of the data factory for which the linked integration runtime belong to.
	DataFactoryName *string `json:"dataFactoryName,omitempty" azure:"ro"`

	// READ-ONLY; The name of the linked integration runtime.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The subscription ID for which the linked integration runtime belong to.
	SubscriptionID *string `json:"subscriptionId,omitempty" azure:"ro"`
}

// LinkedIntegrationRuntimeKeyAuthorization - The key authorization type integration runtime.
type LinkedIntegrationRuntimeKeyAuthorization struct {
	// REQUIRED; The authorization type for integration runtime sharing.
	AuthorizationType *string `json:"authorizationType,omitempty"`

	// REQUIRED; The key used for authorization.
	Key *SecureString `json:"key,omitempty"`
}

// GetLinkedIntegrationRuntimeType implements the LinkedIntegrationRuntimeTypeClassification interface for type LinkedIntegrationRuntimeKeyAuthorization.
func (l *LinkedIntegrationRuntimeKeyAuthorization) GetLinkedIntegrationRuntimeType() *LinkedIntegrationRuntimeType {
	return &LinkedIntegrationRuntimeType{
		AuthorizationType: l.AuthorizationType,
	}
}

// LinkedIntegrationRuntimeRbacAuthorization - The role based access control (RBAC) authorization type integration runtime.
type LinkedIntegrationRuntimeRbacAuthorization struct {
	// REQUIRED; The authorization type for integration runtime sharing.
	AuthorizationType *string `json:"authorizationType,omitempty"`

	// REQUIRED; The resource identifier of the integration runtime to be shared.
	ResourceID *string `json:"resourceId,omitempty"`

	// The credential reference containing authentication information.
	Credential *CredentialReference `json:"credential,omitempty"`
}

// GetLinkedIntegrationRuntimeType implements the LinkedIntegrationRuntimeTypeClassification interface for type LinkedIntegrationRuntimeRbacAuthorization.
func (l *LinkedIntegrationRuntimeRbacAuthorization) GetLinkedIntegrationRuntimeType() *LinkedIntegrationRuntimeType {
	return &LinkedIntegrationRuntimeType{
		AuthorizationType: l.AuthorizationType,
	}
}

// LinkedIntegrationRuntimeRequest - Data factory name for linked integration runtime request.
type LinkedIntegrationRuntimeRequest struct {
	// REQUIRED; The data factory name for linked integration runtime.
	LinkedFactoryName *string `json:"factoryName,omitempty"`
}

// LinkedIntegrationRuntimeTypeClassification provides polymorphic access to related types.
// Call the interface's GetLinkedIntegrationRuntimeType() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *LinkedIntegrationRuntimeKeyAuthorization, *LinkedIntegrationRuntimeRbacAuthorization, *LinkedIntegrationRuntimeType
type LinkedIntegrationRuntimeTypeClassification interface {
	// GetLinkedIntegrationRuntimeType returns the LinkedIntegrationRuntimeType content of the underlying type.
	GetLinkedIntegrationRuntimeType() *LinkedIntegrationRuntimeType
}

// LinkedIntegrationRuntimeType - The base definition of a linked integration runtime.
type LinkedIntegrationRuntimeType struct {
	// REQUIRED; The authorization type for integration runtime sharing.
	AuthorizationType *string `json:"authorizationType,omitempty"`
}

// GetLinkedIntegrationRuntimeType implements the LinkedIntegrationRuntimeTypeClassification interface for type LinkedIntegrationRuntimeType.
func (l *LinkedIntegrationRuntimeType) GetLinkedIntegrationRuntimeType() *LinkedIntegrationRuntimeType {
	return l
}

// LinkedServiceClassification provides polymorphic access to related types.
// Call the interface's GetLinkedService() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AmazonMWSLinkedService, *AmazonRdsForOracleLinkedService, *AmazonRdsForSQLServerLinkedService, *AmazonRedshiftLinkedService,
// - *AmazonS3CompatibleLinkedService, *AmazonS3LinkedService, *AppFiguresLinkedService, *AsanaLinkedService, *AzureBatchLinkedService,
// - *AzureBlobFSLinkedService, *AzureBlobStorageLinkedService, *AzureDataExplorerLinkedService, *AzureDataLakeAnalyticsLinkedService,
// - *AzureDataLakeStoreLinkedService, *AzureDatabricksDeltaLakeLinkedService, *AzureDatabricksLinkedService, *AzureFileStorageLinkedService,
// - *AzureFunctionLinkedService, *AzureKeyVaultLinkedService, *AzureMLLinkedService, *AzureMLServiceLinkedService, *AzureMariaDBLinkedService,
// - *AzureMySQLLinkedService, *AzurePostgreSQLLinkedService, *AzureSQLDWLinkedService, *AzureSQLDatabaseLinkedService, *AzureSQLMILinkedService,
// - *AzureSearchLinkedService, *AzureStorageLinkedService, *AzureSynapseArtifactsLinkedService, *AzureTableStorageLinkedService,
// - *CassandraLinkedService, *CommonDataServiceForAppsLinkedService, *ConcurLinkedService, *CosmosDbLinkedService, *CosmosDbMongoDbAPILinkedService,
// - *CouchbaseLinkedService, *CustomDataSourceLinkedService, *DataworldLinkedService, *Db2LinkedService, *DrillLinkedService,
// - *DynamicsAXLinkedService, *DynamicsCrmLinkedService, *DynamicsLinkedService, *EloquaLinkedService, *FileServerLinkedService,
// - *FtpServerLinkedService, *GoogleAdWordsLinkedService, *GoogleBigQueryLinkedService, *GoogleCloudStorageLinkedService,
// - *GoogleSheetsLinkedService, *GreenplumLinkedService, *HBaseLinkedService, *HDInsightLinkedService, *HDInsightOnDemandLinkedService,
// - *HTTPLinkedService, *HdfsLinkedService, *HiveLinkedService, *HubspotLinkedService, *ImpalaLinkedService, *InformixLinkedService,
// - *JiraLinkedService, *LinkedService, *MagentoLinkedService, *MariaDBLinkedService, *MarketoLinkedService, *MicrosoftAccessLinkedService,
// - *MongoDbAtlasLinkedService, *MongoDbLinkedService, *MongoDbV2LinkedService, *MySQLLinkedService, *NetezzaLinkedService,
// - *ODataLinkedService, *OdbcLinkedService, *Office365LinkedService, *OracleCloudStorageLinkedService, *OracleLinkedService,
// - *OracleServiceCloudLinkedService, *PaypalLinkedService, *PhoenixLinkedService, *PostgreSQLLinkedService, *PrestoLinkedService,
// - *QuickBooksLinkedService, *QuickbaseLinkedService, *ResponsysLinkedService, *RestServiceLinkedService, *SQLServerLinkedService,
// - *SalesforceLinkedService, *SalesforceMarketingCloudLinkedService, *SalesforceServiceCloudLinkedService, *SapBWLinkedService,
// - *SapCloudForCustomerLinkedService, *SapEccLinkedService, *SapHanaLinkedService, *SapOdpLinkedService, *SapOpenHubLinkedService,
// - *SapTableLinkedService, *ServiceNowLinkedService, *SftpServerLinkedService, *SharePointOnlineListLinkedService, *ShopifyLinkedService,
// - *SmartsheetLinkedService, *SnowflakeLinkedService, *SparkLinkedService, *SquareLinkedService, *SybaseLinkedService, *TeamDeskLinkedService,
// - *TeradataLinkedService, *TwilioLinkedService, *VerticaLinkedService, *WebLinkedService, *XeroLinkedService, *ZendeskLinkedService,
// - *ZohoLinkedService
type LinkedServiceClassification interface {
	// GetLinkedService returns the LinkedService content of the underlying type.
	GetLinkedService() *LinkedService
}

// LinkedService - The nested object which contains the information and credential which can be used to connect with related
// store or compute resource.
type LinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type LinkedService.
func (l *LinkedService) GetLinkedService() *LinkedService { return l }

// LinkedServiceDebugResource - Linked service debug resource.
type LinkedServiceDebugResource struct {
	// REQUIRED; Properties of linked service.
	Properties LinkedServiceClassification `json:"properties,omitempty"`

	// The resource name.
	Name *string `json:"name,omitempty"`
}

// LinkedServiceListResponse - A list of linked service resources.
type LinkedServiceListResponse struct {
	// REQUIRED; List of linked services.
	Value []*LinkedServiceResource `json:"value,omitempty"`

	// The link to the next page of results, if any remaining results exist.
	NextLink *string `json:"nextLink,omitempty"`
}

// LinkedServiceReference - Linked service reference type.
type LinkedServiceReference struct {
	// REQUIRED; Reference LinkedService name.
	ReferenceName *string `json:"referenceName,omitempty"`

	// REQUIRED; Linked service reference type.
	Type *LinkedServiceReferenceType `json:"type,omitempty"`

	// Arguments for LinkedService.
	Parameters map[string]interface{} `json:"parameters,omitempty"`
}

// LinkedServiceResource - Linked service resource type.
type LinkedServiceResource struct {
	// REQUIRED; Properties of linked service.
	Properties LinkedServiceClassification `json:"properties,omitempty"`

	// READ-ONLY; Etag identifies change in the resource.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// LinkedServicesClientCreateOrUpdateOptions contains the optional parameters for the LinkedServicesClient.CreateOrUpdate
// method.
type LinkedServicesClientCreateOrUpdateOptions struct {
	// ETag of the linkedService entity. Should only be specified for update, for which it should match existing entity or can
	// be * for unconditional update.
	IfMatch *string
}

// LinkedServicesClientDeleteOptions contains the optional parameters for the LinkedServicesClient.Delete method.
type LinkedServicesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// LinkedServicesClientGetOptions contains the optional parameters for the LinkedServicesClient.Get method.
type LinkedServicesClientGetOptions struct {
	// ETag of the linked service entity. Should only be specified for get. If the ETag matches the existing entity tag, or if
	// * was provided, then no content will be returned.
	IfNoneMatch *string
}

// LinkedServicesClientListByFactoryOptions contains the optional parameters for the LinkedServicesClient.ListByFactory method.
type LinkedServicesClientListByFactoryOptions struct {
	// placeholder for future optional parameters
}

// LogLocationSettings - Log location settings.
type LogLocationSettings struct {
	// REQUIRED; Log storage linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// The path to storage for storing detailed logs of activity execution. Type: string (or Expression with resultType string).
	Path interface{} `json:"path,omitempty"`
}

// LogSettings - Log settings.
type LogSettings struct {
	// REQUIRED; Log location settings customer needs to provide when enabling log.
	LogLocationSettings *LogLocationSettings `json:"logLocationSettings,omitempty"`

	// Specifies settings for copy activity log.
	CopyActivityLogSettings *CopyActivityLogSettings `json:"copyActivityLogSettings,omitempty"`

	// Specifies whether to enable copy activity log. Type: boolean (or Expression with resultType boolean).
	EnableCopyActivityLog interface{} `json:"enableCopyActivityLog,omitempty"`
}

// LogStorageSettings - (Deprecated. Please use LogSettings) Log storage settings.
type LogStorageSettings struct {
	// REQUIRED; Log storage linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Specifies whether to enable reliable logging. Type: boolean (or Expression with resultType boolean).
	EnableReliableLogging interface{} `json:"enableReliableLogging,omitempty"`

	// Gets or sets the log level, support: Info, Warning. Type: string (or Expression with resultType string).
	LogLevel interface{} `json:"logLevel,omitempty"`

	// The path to storage for storing detailed logs of activity execution. Type: string (or Expression with resultType string).
	Path interface{} `json:"path,omitempty"`
}

// LookupActivity - Lookup activity.
type LookupActivity struct {
	// REQUIRED; Activity name.
	Name *string `json:"name,omitempty"`

	// REQUIRED; Type of activity.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Lookup activity properties.
	TypeProperties *LookupActivityTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Activity depends on condition.
	DependsOn []*ActivityDependency `json:"dependsOn,omitempty"`

	// Activity description.
	Description *string `json:"description,omitempty"`

	// Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// Activity policy.
	Policy *ActivityPolicy `json:"policy,omitempty"`

	// Activity user properties.
	UserProperties []*UserProperty `json:"userProperties,omitempty"`
}

// GetActivity implements the ActivityClassification interface for type LookupActivity.
func (l *LookupActivity) GetActivity() *Activity {
	return &Activity{
		Name:                 l.Name,
		Type:                 l.Type,
		Description:          l.Description,
		DependsOn:            l.DependsOn,
		UserProperties:       l.UserProperties,
		AdditionalProperties: l.AdditionalProperties,
	}
}

// GetExecutionActivity implements the ExecutionActivityClassification interface for type LookupActivity.
func (l *LookupActivity) GetExecutionActivity() *ExecutionActivity {
	return &ExecutionActivity{
		LinkedServiceName:    l.LinkedServiceName,
		Policy:               l.Policy,
		Name:                 l.Name,
		Type:                 l.Type,
		Description:          l.Description,
		DependsOn:            l.DependsOn,
		UserProperties:       l.UserProperties,
		AdditionalProperties: l.AdditionalProperties,
	}
}

// LookupActivityTypeProperties - Lookup activity properties.
type LookupActivityTypeProperties struct {
	// REQUIRED; Lookup activity dataset reference.
	Dataset *DatasetReference `json:"dataset,omitempty"`

	// REQUIRED; Dataset-specific source properties, same as copy activity source.
	Source CopySourceClassification `json:"source,omitempty"`

	// Whether to return first row or all rows. Default value is true. Type: boolean (or Expression with resultType boolean).
	FirstRowOnly interface{} `json:"firstRowOnly,omitempty"`
}

// MagentoLinkedService - Magento server linked service.
type MagentoLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Magento server linked service properties.
	TypeProperties *MagentoLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type MagentoLinkedService.
func (m *MagentoLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 m.Type,
		ConnectVia:           m.ConnectVia,
		Description:          m.Description,
		Parameters:           m.Parameters,
		Annotations:          m.Annotations,
		AdditionalProperties: m.AdditionalProperties,
	}
}

// MagentoLinkedServiceTypeProperties - Magento server linked service properties.
type MagentoLinkedServiceTypeProperties struct {
	// REQUIRED; The URL of the Magento instance. (i.e. 192.168.222.110/magento3)
	Host interface{} `json:"host,omitempty"`

	// The access token from Magento.
	AccessToken SecretBaseClassification `json:"accessToken,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
	UseEncryptedEndpoints interface{} `json:"useEncryptedEndpoints,omitempty"`

	// Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting
	// over SSL. The default value is true.
	UseHostVerification interface{} `json:"useHostVerification,omitempty"`

	// Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
	UsePeerVerification interface{} `json:"usePeerVerification,omitempty"`
}

// MagentoObjectDataset - Magento server dataset.
type MagentoObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type MagentoObjectDataset.
func (m *MagentoObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 m.Type,
		Description:          m.Description,
		Structure:            m.Structure,
		Schema:               m.Schema,
		LinkedServiceName:    m.LinkedServiceName,
		Parameters:           m.Parameters,
		Annotations:          m.Annotations,
		Folder:               m.Folder,
		AdditionalProperties: m.AdditionalProperties,
	}
}

// MagentoSource - A copy activity Magento server source.
type MagentoSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type MagentoSource.
func (m *MagentoSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     m.Type,
		SourceRetryCount:         m.SourceRetryCount,
		SourceRetryWait:          m.SourceRetryWait,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		DisableMetricsCollection: m.DisableMetricsCollection,
		AdditionalProperties:     m.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type MagentoSource.
func (m *MagentoSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             m.QueryTimeout,
		AdditionalColumns:        m.AdditionalColumns,
		Type:                     m.Type,
		SourceRetryCount:         m.SourceRetryCount,
		SourceRetryWait:          m.SourceRetryWait,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		DisableMetricsCollection: m.DisableMetricsCollection,
		AdditionalProperties:     m.AdditionalProperties,
	}
}

// ManagedIntegrationRuntime - Managed integration runtime, including managed elastic and managed dedicated integration runtimes.
type ManagedIntegrationRuntime struct {
	// REQUIRED; Type of integration runtime.
	Type *IntegrationRuntimeType `json:"type,omitempty"`

	// REQUIRED; Managed integration runtime properties.
	TypeProperties *ManagedIntegrationRuntimeTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Integration runtime description.
	Description *string `json:"description,omitempty"`

	// Managed Virtual Network reference.
	ManagedVirtualNetwork *ManagedVirtualNetworkReference `json:"managedVirtualNetwork,omitempty"`

	// READ-ONLY; Integration runtime state, only valid for managed dedicated integration runtime.
	State *IntegrationRuntimeState `json:"state,omitempty" azure:"ro"`
}

// GetIntegrationRuntime implements the IntegrationRuntimeClassification interface for type ManagedIntegrationRuntime.
func (m *ManagedIntegrationRuntime) GetIntegrationRuntime() *IntegrationRuntime {
	return &IntegrationRuntime{
		Type:                 m.Type,
		Description:          m.Description,
		AdditionalProperties: m.AdditionalProperties,
	}
}

// ManagedIntegrationRuntimeError - Error definition for managed integration runtime.
type ManagedIntegrationRuntimeError struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// READ-ONLY; Error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Managed integration runtime error parameters.
	Parameters []*string `json:"parameters,omitempty" azure:"ro"`

	// READ-ONLY; The time when the error occurred.
	Time *time.Time `json:"time,omitempty" azure:"ro"`
}

// ManagedIntegrationRuntimeNode - Properties of integration runtime node.
type ManagedIntegrationRuntimeNode struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// The errors that occurred on this integration runtime node.
	Errors []*ManagedIntegrationRuntimeError `json:"errors,omitempty"`

	// READ-ONLY; The managed integration runtime node id.
	NodeID *string `json:"nodeId,omitempty" azure:"ro"`

	// READ-ONLY; The managed integration runtime node status.
	Status *ManagedIntegrationRuntimeNodeStatus `json:"status,omitempty" azure:"ro"`
}

// ManagedIntegrationRuntimeOperationResult - Properties of managed integration runtime operation result.
type ManagedIntegrationRuntimeOperationResult struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// READ-ONLY; The activity id for the operation request.
	ActivityID *string `json:"activityId,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	ErrorCode *string `json:"errorCode,omitempty" azure:"ro"`

	// READ-ONLY; Managed integration runtime error parameters.
	Parameters []*string `json:"parameters,omitempty" azure:"ro"`

	// READ-ONLY; The operation result.
	Result *string `json:"result,omitempty" azure:"ro"`

	// READ-ONLY; The start time of the operation.
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; The operation type. Could be start or stop.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedIntegrationRuntimeStatus - Managed integration runtime status.
type ManagedIntegrationRuntimeStatus struct {
	// REQUIRED; Type of integration runtime.
	Type *IntegrationRuntimeType `json:"type,omitempty"`

	// REQUIRED; Managed integration runtime status type properties.
	TypeProperties *ManagedIntegrationRuntimeStatusTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// READ-ONLY; The data factory name which the integration runtime belong to.
	DataFactoryName *string `json:"dataFactoryName,omitempty" azure:"ro"`

	// READ-ONLY; The state of integration runtime.
	State *IntegrationRuntimeState `json:"state,omitempty" azure:"ro"`
}

// GetIntegrationRuntimeStatus implements the IntegrationRuntimeStatusClassification interface for type ManagedIntegrationRuntimeStatus.
func (m *ManagedIntegrationRuntimeStatus) GetIntegrationRuntimeStatus() *IntegrationRuntimeStatus {
	return &IntegrationRuntimeStatus{
		Type:                 m.Type,
		DataFactoryName:      m.DataFactoryName,
		State:                m.State,
		AdditionalProperties: m.AdditionalProperties,
	}
}

// ManagedIntegrationRuntimeStatusTypeProperties - Managed integration runtime status type properties.
type ManagedIntegrationRuntimeStatusTypeProperties struct {
	// READ-ONLY; The time at which the integration runtime was created, in ISO8601 format.
	CreateTime *time.Time `json:"createTime,omitempty" azure:"ro"`

	// READ-ONLY; The last operation result that occurred on this integration runtime.
	LastOperation *ManagedIntegrationRuntimeOperationResult `json:"lastOperation,omitempty" azure:"ro"`

	// READ-ONLY; The list of nodes for managed integration runtime.
	Nodes []*ManagedIntegrationRuntimeNode `json:"nodes,omitempty" azure:"ro"`

	// READ-ONLY; The errors that occurred on this integration runtime.
	OtherErrors []*ManagedIntegrationRuntimeError `json:"otherErrors,omitempty" azure:"ro"`
}

// ManagedIntegrationRuntimeTypeProperties - Managed integration runtime type properties.
type ManagedIntegrationRuntimeTypeProperties struct {
	// The compute resource for managed integration runtime.
	ComputeProperties *IntegrationRuntimeComputeProperties `json:"computeProperties,omitempty"`

	// The name of virtual network to which Azure-SSIS integration runtime will join
	CustomerVirtualNetwork *IntegrationRuntimeCustomerVirtualNetwork `json:"customerVirtualNetwork,omitempty"`

	// SSIS properties for managed integration runtime.
	SsisProperties *IntegrationRuntimeSsisProperties `json:"ssisProperties,omitempty"`
}

// ManagedPrivateEndpoint - Properties of a managed private endpoint
type ManagedPrivateEndpoint struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// The managed private endpoint connection state
	ConnectionState *ConnectionStateProperties `json:"connectionState,omitempty"`

	// Fully qualified domain names
	Fqdns []*string `json:"fqdns,omitempty"`

	// The groupId to which the managed private endpoint is created
	GroupID *string `json:"groupId,omitempty"`

	// The ARM resource ID of the resource to which the managed private endpoint is created
	PrivateLinkResourceID *string `json:"privateLinkResourceId,omitempty"`

	// READ-ONLY; Denotes whether the managed private endpoint is reserved
	IsReserved *bool `json:"isReserved,omitempty" azure:"ro"`

	// READ-ONLY; The managed private endpoint provisioning state
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// ManagedPrivateEndpointListResponse - A list of managed private endpoint resources.
type ManagedPrivateEndpointListResponse struct {
	// REQUIRED; List of managed private endpoints.
	Value []*ManagedPrivateEndpointResource `json:"value,omitempty"`

	// The link to the next page of results, if any remaining results exist.
	NextLink *string `json:"nextLink,omitempty"`
}

// ManagedPrivateEndpointResource - Managed private endpoint resource type.
type ManagedPrivateEndpointResource struct {
	// REQUIRED; Managed private endpoint properties.
	Properties *ManagedPrivateEndpoint `json:"properties,omitempty"`

	// READ-ONLY; Etag identifies change in the resource.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedPrivateEndpointsClientCreateOrUpdateOptions contains the optional parameters for the ManagedPrivateEndpointsClient.CreateOrUpdate
// method.
type ManagedPrivateEndpointsClientCreateOrUpdateOptions struct {
	// ETag of the managed private endpoint entity. Should only be specified for update, for which it should match existing entity
	// or can be * for unconditional update.
	IfMatch *string
}

// ManagedPrivateEndpointsClientDeleteOptions contains the optional parameters for the ManagedPrivateEndpointsClient.Delete
// method.
type ManagedPrivateEndpointsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ManagedPrivateEndpointsClientGetOptions contains the optional parameters for the ManagedPrivateEndpointsClient.Get method.
type ManagedPrivateEndpointsClientGetOptions struct {
	// ETag of the managed private endpoint entity. Should only be specified for get. If the ETag matches the existing entity
	// tag, or if * was provided, then no content will be returned.
	IfNoneMatch *string
}

// ManagedPrivateEndpointsClientListByFactoryOptions contains the optional parameters for the ManagedPrivateEndpointsClient.ListByFactory
// method.
type ManagedPrivateEndpointsClientListByFactoryOptions struct {
	// placeholder for future optional parameters
}

// ManagedVirtualNetwork - A managed Virtual Network associated with the Azure Data Factory
type ManagedVirtualNetwork struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// READ-ONLY; Managed Virtual Network alias.
	Alias *string `json:"alias,omitempty" azure:"ro"`

	// READ-ONLY; Managed Virtual Network ID.
	VNetID *string `json:"vNetId,omitempty" azure:"ro"`
}

// ManagedVirtualNetworkListResponse - A list of managed Virtual Network resources.
type ManagedVirtualNetworkListResponse struct {
	// REQUIRED; List of managed Virtual Networks.
	Value []*ManagedVirtualNetworkResource `json:"value,omitempty"`

	// The link to the next page of results, if any remaining results exist.
	NextLink *string `json:"nextLink,omitempty"`
}

// ManagedVirtualNetworkReference - Managed Virtual Network reference type.
type ManagedVirtualNetworkReference struct {
	// REQUIRED; Reference ManagedVirtualNetwork name.
	ReferenceName *string `json:"referenceName,omitempty"`

	// REQUIRED; Managed Virtual Network reference type.
	Type *ManagedVirtualNetworkReferenceType `json:"type,omitempty"`
}

// ManagedVirtualNetworkResource - Managed Virtual Network resource type.
type ManagedVirtualNetworkResource struct {
	// REQUIRED; Managed Virtual Network properties.
	Properties *ManagedVirtualNetwork `json:"properties,omitempty"`

	// READ-ONLY; Etag identifies change in the resource.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ManagedVirtualNetworksClientCreateOrUpdateOptions contains the optional parameters for the ManagedVirtualNetworksClient.CreateOrUpdate
// method.
type ManagedVirtualNetworksClientCreateOrUpdateOptions struct {
	// ETag of the managed Virtual Network entity. Should only be specified for update, for which it should match existing entity
	// or can be * for unconditional update.
	IfMatch *string
}

// ManagedVirtualNetworksClientGetOptions contains the optional parameters for the ManagedVirtualNetworksClient.Get method.
type ManagedVirtualNetworksClientGetOptions struct {
	// ETag of the managed Virtual Network entity. Should only be specified for get. If the ETag matches the existing entity tag,
	// or if * was provided, then no content will be returned.
	IfNoneMatch *string
}

// ManagedVirtualNetworksClientListByFactoryOptions contains the optional parameters for the ManagedVirtualNetworksClient.ListByFactory
// method.
type ManagedVirtualNetworksClientListByFactoryOptions struct {
	// placeholder for future optional parameters
}

// MappingDataFlow - Mapping data flow.
type MappingDataFlow struct {
	// REQUIRED; Type of data flow.
	Type *string `json:"type,omitempty"`

	// List of tags that can be used for describing the data flow.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The description of the data flow.
	Description *string `json:"description,omitempty"`

	// The folder that this data flow is in. If not specified, Data flow will appear at the root level.
	Folder *DataFlowFolder `json:"folder,omitempty"`

	// Mapping data flow type properties.
	TypeProperties *MappingDataFlowTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataFlow implements the DataFlowClassification interface for type MappingDataFlow.
func (m *MappingDataFlow) GetDataFlow() *DataFlow {
	return &DataFlow{
		Type:        m.Type,
		Description: m.Description,
		Annotations: m.Annotations,
		Folder:      m.Folder,
	}
}

// MappingDataFlowTypeProperties - Mapping data flow type properties.
type MappingDataFlowTypeProperties struct {
	// DataFlow script.
	Script *string `json:"script,omitempty"`

	// Data flow script lines.
	ScriptLines []*string `json:"scriptLines,omitempty"`

	// List of sinks in data flow.
	Sinks []*DataFlowSink `json:"sinks,omitempty"`

	// List of sources in data flow.
	Sources []*DataFlowSource `json:"sources,omitempty"`

	// List of transformations in data flow.
	Transformations []*Transformation `json:"transformations,omitempty"`
}

// MariaDBLinkedService - MariaDB server linked service.
type MariaDBLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; MariaDB server linked service properties.
	TypeProperties *MariaDBLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type MariaDBLinkedService.
func (m *MariaDBLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 m.Type,
		ConnectVia:           m.ConnectVia,
		Description:          m.Description,
		Parameters:           m.Parameters,
		Annotations:          m.Annotations,
		AdditionalProperties: m.AdditionalProperties,
	}
}

// MariaDBLinkedServiceTypeProperties - MariaDB server linked service properties.
type MariaDBLinkedServiceTypeProperties struct {
	// An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The Azure key vault secret reference of password in connection string.
	Pwd *AzureKeyVaultSecretReference `json:"pwd,omitempty"`
}

// MariaDBSource - A copy activity MariaDB server source.
type MariaDBSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type MariaDBSource.
func (m *MariaDBSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     m.Type,
		SourceRetryCount:         m.SourceRetryCount,
		SourceRetryWait:          m.SourceRetryWait,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		DisableMetricsCollection: m.DisableMetricsCollection,
		AdditionalProperties:     m.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type MariaDBSource.
func (m *MariaDBSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             m.QueryTimeout,
		AdditionalColumns:        m.AdditionalColumns,
		Type:                     m.Type,
		SourceRetryCount:         m.SourceRetryCount,
		SourceRetryWait:          m.SourceRetryWait,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		DisableMetricsCollection: m.DisableMetricsCollection,
		AdditionalProperties:     m.AdditionalProperties,
	}
}

// MariaDBTableDataset - MariaDB server dataset.
type MariaDBTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type MariaDBTableDataset.
func (m *MariaDBTableDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 m.Type,
		Description:          m.Description,
		Structure:            m.Structure,
		Schema:               m.Schema,
		LinkedServiceName:    m.LinkedServiceName,
		Parameters:           m.Parameters,
		Annotations:          m.Annotations,
		Folder:               m.Folder,
		AdditionalProperties: m.AdditionalProperties,
	}
}

// MarketoLinkedService - Marketo server linked service.
type MarketoLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Marketo server linked service properties.
	TypeProperties *MarketoLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type MarketoLinkedService.
func (m *MarketoLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 m.Type,
		ConnectVia:           m.ConnectVia,
		Description:          m.Description,
		Parameters:           m.Parameters,
		Annotations:          m.Annotations,
		AdditionalProperties: m.AdditionalProperties,
	}
}

// MarketoLinkedServiceTypeProperties - Marketo server linked service properties.
type MarketoLinkedServiceTypeProperties struct {
	// REQUIRED; The client Id of your Marketo service.
	ClientID interface{} `json:"clientId,omitempty"`

	// REQUIRED; The endpoint of the Marketo server. (i.e. 123-ABC-321.mktorest.com)
	Endpoint interface{} `json:"endpoint,omitempty"`

	// The client secret of your Marketo service.
	ClientSecret SecretBaseClassification `json:"clientSecret,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
	UseEncryptedEndpoints interface{} `json:"useEncryptedEndpoints,omitempty"`

	// Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting
	// over SSL. The default value is true.
	UseHostVerification interface{} `json:"useHostVerification,omitempty"`

	// Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
	UsePeerVerification interface{} `json:"usePeerVerification,omitempty"`
}

// MarketoObjectDataset - Marketo server dataset.
type MarketoObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type MarketoObjectDataset.
func (m *MarketoObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 m.Type,
		Description:          m.Description,
		Structure:            m.Structure,
		Schema:               m.Schema,
		LinkedServiceName:    m.LinkedServiceName,
		Parameters:           m.Parameters,
		Annotations:          m.Annotations,
		Folder:               m.Folder,
		AdditionalProperties: m.AdditionalProperties,
	}
}

// MarketoSource - A copy activity Marketo server source.
type MarketoSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type MarketoSource.
func (m *MarketoSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     m.Type,
		SourceRetryCount:         m.SourceRetryCount,
		SourceRetryWait:          m.SourceRetryWait,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		DisableMetricsCollection: m.DisableMetricsCollection,
		AdditionalProperties:     m.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type MarketoSource.
func (m *MarketoSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             m.QueryTimeout,
		AdditionalColumns:        m.AdditionalColumns,
		Type:                     m.Type,
		SourceRetryCount:         m.SourceRetryCount,
		SourceRetryWait:          m.SourceRetryWait,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		DisableMetricsCollection: m.DisableMetricsCollection,
		AdditionalProperties:     m.AdditionalProperties,
	}
}

// MetadataItem - Specify the name and value of custom metadata item.
type MetadataItem struct {
	// Metadata item key name. Type: string (or Expression with resultType string).
	Name interface{} `json:"name,omitempty"`

	// Metadata item value. Type: string (or Expression with resultType string).
	Value interface{} `json:"value,omitempty"`
}

// MicrosoftAccessLinkedService - Microsoft Access linked service.
type MicrosoftAccessLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Microsoft Access linked service properties.
	TypeProperties *MicrosoftAccessLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type MicrosoftAccessLinkedService.
func (m *MicrosoftAccessLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 m.Type,
		ConnectVia:           m.ConnectVia,
		Description:          m.Description,
		Parameters:           m.Parameters,
		Annotations:          m.Annotations,
		AdditionalProperties: m.AdditionalProperties,
	}
}

// MicrosoftAccessLinkedServiceTypeProperties - Microsoft Access linked service properties.
type MicrosoftAccessLinkedServiceTypeProperties struct {
	// REQUIRED; The non-access credential portion of the connection string as well as an optional encrypted credential. Type:
	// string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`

	// Type of authentication used to connect to the Microsoft Access as ODBC data store. Possible values are: Anonymous and Basic.
	// Type: string (or Expression with resultType string).
	AuthenticationType interface{} `json:"authenticationType,omitempty"`

	// The access credential portion of the connection string specified in driver-specific property-value format.
	Credential SecretBaseClassification `json:"credential,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// Password for Basic authentication.
	Password SecretBaseClassification `json:"password,omitempty"`

	// User name for Basic authentication. Type: string (or Expression with resultType string).
	UserName interface{} `json:"userName,omitempty"`
}

// MicrosoftAccessSink - A copy activity Microsoft Access sink.
type MicrosoftAccessSink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to execute before starting the copy. Type: string (or Expression with resultType string).
	PreCopyScript interface{} `json:"preCopyScript,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type MicrosoftAccessSink.
func (m *MicrosoftAccessSink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     m.Type,
		WriteBatchSize:           m.WriteBatchSize,
		WriteBatchTimeout:        m.WriteBatchTimeout,
		SinkRetryCount:           m.SinkRetryCount,
		SinkRetryWait:            m.SinkRetryWait,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		DisableMetricsCollection: m.DisableMetricsCollection,
		AdditionalProperties:     m.AdditionalProperties,
	}
}

// MicrosoftAccessSource - A copy activity source for Microsoft Access.
type MicrosoftAccessSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Database query. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type MicrosoftAccessSource.
func (m *MicrosoftAccessSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     m.Type,
		SourceRetryCount:         m.SourceRetryCount,
		SourceRetryWait:          m.SourceRetryWait,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		DisableMetricsCollection: m.DisableMetricsCollection,
		AdditionalProperties:     m.AdditionalProperties,
	}
}

// MicrosoftAccessTableDataset - The Microsoft Access table dataset.
type MicrosoftAccessTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Microsoft Access table dataset properties.
	TypeProperties *MicrosoftAccessTableDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type MicrosoftAccessTableDataset.
func (m *MicrosoftAccessTableDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 m.Type,
		Description:          m.Description,
		Structure:            m.Structure,
		Schema:               m.Schema,
		LinkedServiceName:    m.LinkedServiceName,
		Parameters:           m.Parameters,
		Annotations:          m.Annotations,
		Folder:               m.Folder,
		AdditionalProperties: m.AdditionalProperties,
	}
}

// MicrosoftAccessTableDatasetTypeProperties - Microsoft Access table dataset properties.
type MicrosoftAccessTableDatasetTypeProperties struct {
	// The Microsoft Access table name. Type: string (or Expression with resultType string).
	TableName interface{} `json:"tableName,omitempty"`
}

// MongoDbAtlasCollectionDataset - The MongoDB Atlas database dataset.
type MongoDbAtlasCollectionDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// REQUIRED; MongoDB Atlas database dataset properties.
	TypeProperties *MongoDbAtlasCollectionDatasetTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type MongoDbAtlasCollectionDataset.
func (m *MongoDbAtlasCollectionDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 m.Type,
		Description:          m.Description,
		Structure:            m.Structure,
		Schema:               m.Schema,
		LinkedServiceName:    m.LinkedServiceName,
		Parameters:           m.Parameters,
		Annotations:          m.Annotations,
		Folder:               m.Folder,
		AdditionalProperties: m.AdditionalProperties,
	}
}

// MongoDbAtlasCollectionDatasetTypeProperties - MongoDB Atlas database dataset properties.
type MongoDbAtlasCollectionDatasetTypeProperties struct {
	// REQUIRED; The collection name of the MongoDB Atlas database. Type: string (or Expression with resultType string).
	Collection interface{} `json:"collection,omitempty"`
}

// MongoDbAtlasLinkedService - Linked service for MongoDB Atlas data source.
type MongoDbAtlasLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; MongoDB Atlas linked service properties.
	TypeProperties *MongoDbAtlasLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type MongoDbAtlasLinkedService.
func (m *MongoDbAtlasLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 m.Type,
		ConnectVia:           m.ConnectVia,
		Description:          m.Description,
		Parameters:           m.Parameters,
		Annotations:          m.Annotations,
		AdditionalProperties: m.AdditionalProperties,
	}
}

// MongoDbAtlasLinkedServiceTypeProperties - MongoDB Atlas linked service properties.
type MongoDbAtlasLinkedServiceTypeProperties struct {
	// REQUIRED; The MongoDB Atlas connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type: string,
	// SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`

	// REQUIRED; The name of the MongoDB Atlas database that you want to access. Type: string (or Expression with resultType string).
	Database interface{} `json:"database,omitempty"`
}

// MongoDbAtlasSink - A copy activity MongoDB Atlas sink.
type MongoDbAtlasSink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`

	// Specifies whether the document with same key to be overwritten (upsert) rather than throw exception (insert). The default
	// value is "insert". Type: string (or Expression with resultType string). Type:
	// string (or Expression with resultType string).
	WriteBehavior interface{} `json:"writeBehavior,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type MongoDbAtlasSink.
func (m *MongoDbAtlasSink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     m.Type,
		WriteBatchSize:           m.WriteBatchSize,
		WriteBatchTimeout:        m.WriteBatchTimeout,
		SinkRetryCount:           m.SinkRetryCount,
		SinkRetryWait:            m.SinkRetryWait,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		DisableMetricsCollection: m.DisableMetricsCollection,
		AdditionalProperties:     m.AdditionalProperties,
	}
}

// MongoDbAtlasSource - A copy activity source for a MongoDB Atlas database.
type MongoDbAtlasSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Specifies the number of documents to return in each batch of the response from MongoDB Atlas instance. In most cases, modifying
	// the batch size will not affect the user or the application. This
	// property's main purpose is to avoid hit the limitation of response size. Type: integer (or Expression with resultType integer).
	BatchSize interface{} `json:"batchSize,omitempty"`

	// Cursor methods for Mongodb query
	CursorMethods *MongoDbCursorMethodsProperties `json:"cursorMethods,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// Specifies selection filter using query operators. To return all documents in a collection, omit this parameter or pass
	// an empty document ({}). Type: string (or Expression with resultType string).
	Filter interface{} `json:"filter,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type MongoDbAtlasSource.
func (m *MongoDbAtlasSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     m.Type,
		SourceRetryCount:         m.SourceRetryCount,
		SourceRetryWait:          m.SourceRetryWait,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		DisableMetricsCollection: m.DisableMetricsCollection,
		AdditionalProperties:     m.AdditionalProperties,
	}
}

// MongoDbCollectionDataset - The MongoDB database dataset.
type MongoDbCollectionDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// REQUIRED; MongoDB database dataset properties.
	TypeProperties *MongoDbCollectionDatasetTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type MongoDbCollectionDataset.
func (m *MongoDbCollectionDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 m.Type,
		Description:          m.Description,
		Structure:            m.Structure,
		Schema:               m.Schema,
		LinkedServiceName:    m.LinkedServiceName,
		Parameters:           m.Parameters,
		Annotations:          m.Annotations,
		Folder:               m.Folder,
		AdditionalProperties: m.AdditionalProperties,
	}
}

// MongoDbCollectionDatasetTypeProperties - MongoDB database dataset properties.
type MongoDbCollectionDatasetTypeProperties struct {
	// REQUIRED; The table name of the MongoDB database. Type: string (or Expression with resultType string).
	CollectionName interface{} `json:"collectionName,omitempty"`
}

// MongoDbCursorMethodsProperties - Cursor methods for Mongodb query
type MongoDbCursorMethodsProperties struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Specifies the maximum number of documents the server returns. limit() is analogous to the LIMIT statement in a SQL database.
	// Type: integer (or Expression with resultType integer).
	Limit interface{} `json:"limit,omitempty"`

	// Specifies the fields to return in the documents that match the query filter. To return all fields in the matching documents,
	// omit this parameter. Type: string (or Expression with resultType string).
	Project interface{} `json:"project,omitempty"`

	// Specifies the how many documents skipped and where MongoDB begins returning results. This approach may be useful in implementing
	// paginated results. Type: integer (or Expression with resultType
	// integer).
	Skip interface{} `json:"skip,omitempty"`

	// Specifies the order in which the query returns matching documents. Type: string (or Expression with resultType string).
	// Type: string (or Expression with resultType string).
	Sort interface{} `json:"sort,omitempty"`
}

// MongoDbLinkedService - Linked service for MongoDb data source.
type MongoDbLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; MongoDB linked service properties.
	TypeProperties *MongoDbLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type MongoDbLinkedService.
func (m *MongoDbLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 m.Type,
		ConnectVia:           m.ConnectVia,
		Description:          m.Description,
		Parameters:           m.Parameters,
		Annotations:          m.Annotations,
		AdditionalProperties: m.AdditionalProperties,
	}
}

// MongoDbLinkedServiceTypeProperties - MongoDB linked service properties.
type MongoDbLinkedServiceTypeProperties struct {
	// REQUIRED; The name of the MongoDB database that you want to access. Type: string (or Expression with resultType string).
	DatabaseName interface{} `json:"databaseName,omitempty"`

	// REQUIRED; The IP address or server name of the MongoDB server. Type: string (or Expression with resultType string).
	Server interface{} `json:"server,omitempty"`

	// Specifies whether to allow self-signed certificates from the server. The default value is false. Type: boolean (or Expression
	// with resultType boolean).
	AllowSelfSignedServerCert interface{} `json:"allowSelfSignedServerCert,omitempty"`

	// Database to verify the username and password. Type: string (or Expression with resultType string).
	AuthSource interface{} `json:"authSource,omitempty"`

	// The authentication type to be used to connect to the MongoDB database.
	AuthenticationType *MongoDbAuthenticationType `json:"authenticationType,omitempty"`

	// Specifies whether the connections to the server are encrypted using SSL. The default value is false. Type: boolean (or
	// Expression with resultType boolean).
	EnableSSL interface{} `json:"enableSsl,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// Password for authentication.
	Password SecretBaseClassification `json:"password,omitempty"`

	// The TCP port number that the MongoDB server uses to listen for client connections. The default value is 27017. Type: integer
	// (or Expression with resultType integer), minimum: 0.
	Port interface{} `json:"port,omitempty"`

	// Username for authentication. Type: string (or Expression with resultType string).
	Username interface{} `json:"username,omitempty"`
}

// MongoDbSource - A copy activity source for a MongoDB database.
type MongoDbSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Database query. Should be a SQL-92 query expression. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type MongoDbSource.
func (m *MongoDbSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     m.Type,
		SourceRetryCount:         m.SourceRetryCount,
		SourceRetryWait:          m.SourceRetryWait,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		DisableMetricsCollection: m.DisableMetricsCollection,
		AdditionalProperties:     m.AdditionalProperties,
	}
}

// MongoDbV2CollectionDataset - The MongoDB database dataset.
type MongoDbV2CollectionDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// REQUIRED; MongoDB database dataset properties.
	TypeProperties *MongoDbV2CollectionDatasetTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type MongoDbV2CollectionDataset.
func (m *MongoDbV2CollectionDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 m.Type,
		Description:          m.Description,
		Structure:            m.Structure,
		Schema:               m.Schema,
		LinkedServiceName:    m.LinkedServiceName,
		Parameters:           m.Parameters,
		Annotations:          m.Annotations,
		Folder:               m.Folder,
		AdditionalProperties: m.AdditionalProperties,
	}
}

// MongoDbV2CollectionDatasetTypeProperties - MongoDB database dataset properties.
type MongoDbV2CollectionDatasetTypeProperties struct {
	// REQUIRED; The collection name of the MongoDB database. Type: string (or Expression with resultType string).
	Collection interface{} `json:"collection,omitempty"`
}

// MongoDbV2LinkedService - Linked service for MongoDB data source.
type MongoDbV2LinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; MongoDB linked service properties.
	TypeProperties *MongoDbV2LinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type MongoDbV2LinkedService.
func (m *MongoDbV2LinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 m.Type,
		ConnectVia:           m.ConnectVia,
		Description:          m.Description,
		Parameters:           m.Parameters,
		Annotations:          m.Annotations,
		AdditionalProperties: m.AdditionalProperties,
	}
}

// MongoDbV2LinkedServiceTypeProperties - MongoDB linked service properties.
type MongoDbV2LinkedServiceTypeProperties struct {
	// REQUIRED; The MongoDB connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type: string, SecureString
	// or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`

	// REQUIRED; The name of the MongoDB database that you want to access. Type: string (or Expression with resultType string).
	Database interface{} `json:"database,omitempty"`
}

// MongoDbV2Sink - A copy activity MongoDB sink.
type MongoDbV2Sink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`

	// Specifies whether the document with same key to be overwritten (upsert) rather than throw exception (insert). The default
	// value is "insert". Type: string (or Expression with resultType string). Type:
	// string (or Expression with resultType string).
	WriteBehavior interface{} `json:"writeBehavior,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type MongoDbV2Sink.
func (m *MongoDbV2Sink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     m.Type,
		WriteBatchSize:           m.WriteBatchSize,
		WriteBatchTimeout:        m.WriteBatchTimeout,
		SinkRetryCount:           m.SinkRetryCount,
		SinkRetryWait:            m.SinkRetryWait,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		DisableMetricsCollection: m.DisableMetricsCollection,
		AdditionalProperties:     m.AdditionalProperties,
	}
}

// MongoDbV2Source - A copy activity source for a MongoDB database.
type MongoDbV2Source struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Specifies the number of documents to return in each batch of the response from MongoDB instance. In most cases, modifying
	// the batch size will not affect the user or the application. This property's
	// main purpose is to avoid hit the limitation of response size. Type: integer (or Expression with resultType integer).
	BatchSize interface{} `json:"batchSize,omitempty"`

	// Cursor methods for Mongodb query
	CursorMethods *MongoDbCursorMethodsProperties `json:"cursorMethods,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// Specifies selection filter using query operators. To return all documents in a collection, omit this parameter or pass
	// an empty document ({}). Type: string (or Expression with resultType string).
	Filter interface{} `json:"filter,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type MongoDbV2Source.
func (m *MongoDbV2Source) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     m.Type,
		SourceRetryCount:         m.SourceRetryCount,
		SourceRetryWait:          m.SourceRetryWait,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		DisableMetricsCollection: m.DisableMetricsCollection,
		AdditionalProperties:     m.AdditionalProperties,
	}
}

// MultiplePipelineTriggerClassification provides polymorphic access to related types.
// Call the interface's GetMultiplePipelineTrigger() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *BlobEventsTrigger, *BlobTrigger, *CustomEventsTrigger, *MultiplePipelineTrigger, *ScheduleTrigger
type MultiplePipelineTriggerClassification interface {
	TriggerClassification
	// GetMultiplePipelineTrigger returns the MultiplePipelineTrigger content of the underlying type.
	GetMultiplePipelineTrigger() *MultiplePipelineTrigger
}

// MultiplePipelineTrigger - Base class for all triggers that support one to many model for trigger to pipeline.
type MultiplePipelineTrigger struct {
	// REQUIRED; Trigger type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the trigger.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Trigger description.
	Description *string `json:"description,omitempty"`

	// Pipelines that need to be started.
	Pipelines []*TriggerPipelineReference `json:"pipelines,omitempty"`

	// READ-ONLY; Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger.
	RuntimeState *TriggerRuntimeState `json:"runtimeState,omitempty" azure:"ro"`
}

// GetMultiplePipelineTrigger implements the MultiplePipelineTriggerClassification interface for type MultiplePipelineTrigger.
func (m *MultiplePipelineTrigger) GetMultiplePipelineTrigger() *MultiplePipelineTrigger { return m }

// GetTrigger implements the TriggerClassification interface for type MultiplePipelineTrigger.
func (m *MultiplePipelineTrigger) GetTrigger() *Trigger {
	return &Trigger{
		Type:                 m.Type,
		Description:          m.Description,
		RuntimeState:         m.RuntimeState,
		Annotations:          m.Annotations,
		AdditionalProperties: m.AdditionalProperties,
	}
}

// MySQLLinkedService - Linked service for MySQL data source.
type MySQLLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; MySQL linked service properties.
	TypeProperties *MySQLLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type MySQLLinkedService.
func (m *MySQLLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 m.Type,
		ConnectVia:           m.ConnectVia,
		Description:          m.Description,
		Parameters:           m.Parameters,
		Annotations:          m.Annotations,
		AdditionalProperties: m.AdditionalProperties,
	}
}

// MySQLLinkedServiceTypeProperties - MySQL linked service properties.
type MySQLLinkedServiceTypeProperties struct {
	// REQUIRED; The connection string.
	ConnectionString interface{} `json:"connectionString,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The Azure key vault secret reference of password in connection string.
	Password *AzureKeyVaultSecretReference `json:"password,omitempty"`
}

// MySQLSource - A copy activity source for MySQL databases.
type MySQLSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Database query. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type MySQLSource.
func (m *MySQLSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     m.Type,
		SourceRetryCount:         m.SourceRetryCount,
		SourceRetryWait:          m.SourceRetryWait,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		DisableMetricsCollection: m.DisableMetricsCollection,
		AdditionalProperties:     m.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type MySQLSource.
func (m *MySQLSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             m.QueryTimeout,
		AdditionalColumns:        m.AdditionalColumns,
		Type:                     m.Type,
		SourceRetryCount:         m.SourceRetryCount,
		SourceRetryWait:          m.SourceRetryWait,
		MaxConcurrentConnections: m.MaxConcurrentConnections,
		DisableMetricsCollection: m.DisableMetricsCollection,
		AdditionalProperties:     m.AdditionalProperties,
	}
}

// MySQLTableDataset - The MySQL table dataset.
type MySQLTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// MySQL table dataset properties.
	TypeProperties *MySQLTableDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type MySQLTableDataset.
func (m *MySQLTableDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 m.Type,
		Description:          m.Description,
		Structure:            m.Structure,
		Schema:               m.Schema,
		LinkedServiceName:    m.LinkedServiceName,
		Parameters:           m.Parameters,
		Annotations:          m.Annotations,
		Folder:               m.Folder,
		AdditionalProperties: m.AdditionalProperties,
	}
}

// MySQLTableDatasetTypeProperties - MySql table dataset properties.
type MySQLTableDatasetTypeProperties struct {
	// The MySQL table name. Type: string (or Expression with resultType string).
	TableName interface{} `json:"tableName,omitempty"`
}

// NetezzaLinkedService - Netezza linked service.
type NetezzaLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Netezza linked service properties.
	TypeProperties *NetezzaLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type NetezzaLinkedService.
func (n *NetezzaLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 n.Type,
		ConnectVia:           n.ConnectVia,
		Description:          n.Description,
		Parameters:           n.Parameters,
		Annotations:          n.Annotations,
		AdditionalProperties: n.AdditionalProperties,
	}
}

// NetezzaLinkedServiceTypeProperties - Netezza linked service properties.
type NetezzaLinkedServiceTypeProperties struct {
	// An ODBC connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The Azure key vault secret reference of password in connection string.
	Pwd *AzureKeyVaultSecretReference `json:"pwd,omitempty"`
}

// NetezzaPartitionSettings - The settings that will be leveraged for Netezza source partitioning.
type NetezzaPartitionSettings struct {
	// The name of the column in integer type that will be used for proceeding range partitioning. Type: string (or Expression
	// with resultType string).
	PartitionColumnName interface{} `json:"partitionColumnName,omitempty"`

	// The minimum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type:
	// string (or Expression with resultType string).
	PartitionLowerBound interface{} `json:"partitionLowerBound,omitempty"`

	// The maximum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type:
	// string (or Expression with resultType string).
	PartitionUpperBound interface{} `json:"partitionUpperBound,omitempty"`
}

// NetezzaSource - A copy activity Netezza source.
type NetezzaSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// The partition mechanism that will be used for Netezza read in parallel. Possible values include: "None", "DataSlice", "DynamicRange".
	PartitionOption interface{} `json:"partitionOption,omitempty"`

	// The settings that will be leveraged for Netezza source partitioning.
	PartitionSettings *NetezzaPartitionSettings `json:"partitionSettings,omitempty"`

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type NetezzaSource.
func (n *NetezzaSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     n.Type,
		SourceRetryCount:         n.SourceRetryCount,
		SourceRetryWait:          n.SourceRetryWait,
		MaxConcurrentConnections: n.MaxConcurrentConnections,
		DisableMetricsCollection: n.DisableMetricsCollection,
		AdditionalProperties:     n.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type NetezzaSource.
func (n *NetezzaSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             n.QueryTimeout,
		AdditionalColumns:        n.AdditionalColumns,
		Type:                     n.Type,
		SourceRetryCount:         n.SourceRetryCount,
		SourceRetryWait:          n.SourceRetryWait,
		MaxConcurrentConnections: n.MaxConcurrentConnections,
		DisableMetricsCollection: n.DisableMetricsCollection,
		AdditionalProperties:     n.AdditionalProperties,
	}
}

// NetezzaTableDataset - Netezza dataset.
type NetezzaTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Properties specific to this dataset type.
	TypeProperties *NetezzaTableDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type NetezzaTableDataset.
func (n *NetezzaTableDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 n.Type,
		Description:          n.Description,
		Structure:            n.Structure,
		Schema:               n.Schema,
		LinkedServiceName:    n.LinkedServiceName,
		Parameters:           n.Parameters,
		Annotations:          n.Annotations,
		Folder:               n.Folder,
		AdditionalProperties: n.AdditionalProperties,
	}
}

// NetezzaTableDatasetTypeProperties - Netezza dataset properties.
type NetezzaTableDatasetTypeProperties struct {
	// The schema name of the Netezza. Type: string (or Expression with resultType string).
	Schema interface{} `json:"schema,omitempty"`

	// The table name of the Netezza. Type: string (or Expression with resultType string).
	Table interface{} `json:"table,omitempty"`

	// This property will be retired. Please consider using schema + table properties instead.
	TableName interface{} `json:"tableName,omitempty"`
}

// NotebookParameter - Notebook parameter.
type NotebookParameter struct {
	// Notebook parameter type.
	Type *NotebookParameterType `json:"type,omitempty"`

	// Notebook parameter value. Type: string (or Expression with resultType string).
	Value interface{} `json:"value,omitempty"`
}

// ODataLinkedService - Open Data Protocol (OData) linked service.
type ODataLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; OData linked service properties.
	TypeProperties *ODataLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type ODataLinkedService.
func (o *ODataLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 o.Type,
		ConnectVia:           o.ConnectVia,
		Description:          o.Description,
		Parameters:           o.Parameters,
		Annotations:          o.Annotations,
		AdditionalProperties: o.AdditionalProperties,
	}
}

// ODataLinkedServiceTypeProperties - OData linked service properties.
type ODataLinkedServiceTypeProperties struct {
	// REQUIRED; The URL of the OData service endpoint. Type: string (or Expression with resultType string).
	URL interface{} `json:"url,omitempty"`

	// Specify the resource you are requesting authorization to use Directory. Type: string (or Expression with resultType string).
	AADResourceID interface{} `json:"aadResourceId,omitempty"`

	// Specify the credential type (key or cert) is used for service principal.
	AADServicePrincipalCredentialType *ODataAADServicePrincipalCredentialType `json:"aadServicePrincipalCredentialType,omitempty"`

	// The additional HTTP headers in the request to RESTful API used for authorization. Type: object (or Expression with resultType
	// object).
	AuthHeaders interface{} `json:"authHeaders,omitempty"`

	// Type of authentication used to connect to the OData service.
	AuthenticationType *ODataAuthenticationType `json:"authenticationType,omitempty"`

	// Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment,
	// AzureGermany. Default value is the data factory regions’ cloud type. Type:
	// string (or Expression with resultType string).
	AzureCloudType interface{} `json:"azureCloudType,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// Password of the OData service.
	Password SecretBaseClassification `json:"password,omitempty"`

	// Specify the base64 encoded certificate of your application registered in Azure Active Directory. Type: string (or Expression
	// with resultType string).
	ServicePrincipalEmbeddedCert SecretBaseClassification `json:"servicePrincipalEmbeddedCert,omitempty"`

	// Specify the password of your certificate if your certificate has a password and you are using AadServicePrincipal authentication.
	// Type: string (or Expression with resultType string).
	ServicePrincipalEmbeddedCertPassword SecretBaseClassification `json:"servicePrincipalEmbeddedCertPassword,omitempty"`

	// Specify the application id of your application registered in Azure Active Directory. Type: string (or Expression with resultType
	// string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`

	// Specify the secret of your application registered in Azure Active Directory. Type: string (or Expression with resultType
	// string).
	ServicePrincipalKey SecretBaseClassification `json:"servicePrincipalKey,omitempty"`

	// Specify the tenant information (domain name or tenant ID) under which your application resides. Type: string (or Expression
	// with resultType string).
	Tenant interface{} `json:"tenant,omitempty"`

	// User name of the OData service. Type: string (or Expression with resultType string).
	UserName interface{} `json:"userName,omitempty"`
}

// ODataResourceDataset - The Open Data Protocol (OData) resource dataset.
type ODataResourceDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// OData dataset properties.
	TypeProperties *ODataResourceDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type ODataResourceDataset.
func (o *ODataResourceDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 o.Type,
		Description:          o.Description,
		Structure:            o.Structure,
		Schema:               o.Schema,
		LinkedServiceName:    o.LinkedServiceName,
		Parameters:           o.Parameters,
		Annotations:          o.Annotations,
		Folder:               o.Folder,
		AdditionalProperties: o.AdditionalProperties,
	}
}

// ODataResourceDatasetTypeProperties - OData dataset properties.
type ODataResourceDatasetTypeProperties struct {
	// The OData resource path. Type: string (or Expression with resultType string).
	Path interface{} `json:"path,omitempty"`
}

// ODataSource - A copy activity source for OData source.
type ODataSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The timeout (TimeSpan) to get an HTTP response. It is the timeout to get a response, not the timeout to read response data.
	// Default value: 00:05:00. Type: string (or Expression with resultType
	// string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	HTTPRequestTimeout interface{} `json:"httpRequestTimeout,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// OData query. For example, "$top=1". Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type ODataSource.
func (o *ODataSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     o.Type,
		SourceRetryCount:         o.SourceRetryCount,
		SourceRetryWait:          o.SourceRetryWait,
		MaxConcurrentConnections: o.MaxConcurrentConnections,
		DisableMetricsCollection: o.DisableMetricsCollection,
		AdditionalProperties:     o.AdditionalProperties,
	}
}

// OdbcLinkedService - Open Database Connectivity (ODBC) linked service.
type OdbcLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; ODBC linked service properties.
	TypeProperties *OdbcLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type OdbcLinkedService.
func (o *OdbcLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 o.Type,
		ConnectVia:           o.ConnectVia,
		Description:          o.Description,
		Parameters:           o.Parameters,
		Annotations:          o.Annotations,
		AdditionalProperties: o.AdditionalProperties,
	}
}

// OdbcLinkedServiceTypeProperties - ODBC linked service properties.
type OdbcLinkedServiceTypeProperties struct {
	// REQUIRED; The non-access credential portion of the connection string as well as an optional encrypted credential. Type:
	// string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`

	// Type of authentication used to connect to the ODBC data store. Possible values are: Anonymous and Basic. Type: string (or
	// Expression with resultType string).
	AuthenticationType interface{} `json:"authenticationType,omitempty"`

	// The access credential portion of the connection string specified in driver-specific property-value format.
	Credential SecretBaseClassification `json:"credential,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// Password for Basic authentication.
	Password SecretBaseClassification `json:"password,omitempty"`

	// User name for Basic authentication. Type: string (or Expression with resultType string).
	UserName interface{} `json:"userName,omitempty"`
}

// OdbcSink - A copy activity ODBC sink.
type OdbcSink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to execute before starting the copy. Type: string (or Expression with resultType string).
	PreCopyScript interface{} `json:"preCopyScript,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type OdbcSink.
func (o *OdbcSink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     o.Type,
		WriteBatchSize:           o.WriteBatchSize,
		WriteBatchTimeout:        o.WriteBatchTimeout,
		SinkRetryCount:           o.SinkRetryCount,
		SinkRetryWait:            o.SinkRetryWait,
		MaxConcurrentConnections: o.MaxConcurrentConnections,
		DisableMetricsCollection: o.DisableMetricsCollection,
		AdditionalProperties:     o.AdditionalProperties,
	}
}

// OdbcSource - A copy activity source for ODBC databases.
type OdbcSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Database query. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type OdbcSource.
func (o *OdbcSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     o.Type,
		SourceRetryCount:         o.SourceRetryCount,
		SourceRetryWait:          o.SourceRetryWait,
		MaxConcurrentConnections: o.MaxConcurrentConnections,
		DisableMetricsCollection: o.DisableMetricsCollection,
		AdditionalProperties:     o.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type OdbcSource.
func (o *OdbcSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             o.QueryTimeout,
		AdditionalColumns:        o.AdditionalColumns,
		Type:                     o.Type,
		SourceRetryCount:         o.SourceRetryCount,
		SourceRetryWait:          o.SourceRetryWait,
		MaxConcurrentConnections: o.MaxConcurrentConnections,
		DisableMetricsCollection: o.DisableMetricsCollection,
		AdditionalProperties:     o.AdditionalProperties,
	}
}

// OdbcTableDataset - The ODBC table dataset.
type OdbcTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// ODBC table dataset properties.
	TypeProperties *OdbcTableDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type OdbcTableDataset.
func (o *OdbcTableDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 o.Type,
		Description:          o.Description,
		Structure:            o.Structure,
		Schema:               o.Schema,
		LinkedServiceName:    o.LinkedServiceName,
		Parameters:           o.Parameters,
		Annotations:          o.Annotations,
		Folder:               o.Folder,
		AdditionalProperties: o.AdditionalProperties,
	}
}

// OdbcTableDatasetTypeProperties - ODBC table dataset properties.
type OdbcTableDatasetTypeProperties struct {
	// The ODBC table name. Type: string (or Expression with resultType string).
	TableName interface{} `json:"tableName,omitempty"`
}

// Office365Dataset - The Office365 account.
type Office365Dataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Office365 dataset properties.
	TypeProperties *Office365DatasetTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type Office365Dataset.
func (o *Office365Dataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 o.Type,
		Description:          o.Description,
		Structure:            o.Structure,
		Schema:               o.Schema,
		LinkedServiceName:    o.LinkedServiceName,
		Parameters:           o.Parameters,
		Annotations:          o.Annotations,
		Folder:               o.Folder,
		AdditionalProperties: o.AdditionalProperties,
	}
}

// Office365DatasetTypeProperties - Office365 dataset properties.
type Office365DatasetTypeProperties struct {
	// REQUIRED; Name of the dataset to extract from Office 365. Type: string (or Expression with resultType string).
	TableName interface{} `json:"tableName,omitempty"`

	// A predicate expression that can be used to filter the specific rows to extract from Office 365. Type: string (or Expression
	// with resultType string).
	Predicate interface{} `json:"predicate,omitempty"`
}

// Office365LinkedService - Office365 linked service.
type Office365LinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Office365 linked service properties.
	TypeProperties *Office365LinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type Office365LinkedService.
func (o *Office365LinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 o.Type,
		ConnectVia:           o.ConnectVia,
		Description:          o.Description,
		Parameters:           o.Parameters,
		Annotations:          o.Annotations,
		AdditionalProperties: o.AdditionalProperties,
	}
}

// Office365LinkedServiceTypeProperties - Office365 linked service properties.
type Office365LinkedServiceTypeProperties struct {
	// REQUIRED; Azure tenant ID to which the Office 365 account belongs. Type: string (or Expression with resultType string).
	Office365TenantID interface{} `json:"office365TenantId,omitempty"`

	// REQUIRED; Specify the application's client ID. Type: string (or Expression with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`

	// REQUIRED; Specify the application's key.
	ServicePrincipalKey SecretBaseClassification `json:"servicePrincipalKey,omitempty"`

	// REQUIRED; Specify the tenant information under which your Azure AD web application resides. Type: string (or Expression
	// with resultType string).
	ServicePrincipalTenantID interface{} `json:"servicePrincipalTenantId,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// Office365Source - A copy activity source for an Office 365 service.
type Office365Source struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// The groups containing all the users. Type: array of strings (or Expression with resultType array of strings).
	AllowedGroups interface{} `json:"allowedGroups,omitempty"`

	// The Column to apply the and . Type: string (or Expression with resultType string).
	DateFilterColumn interface{} `json:"dateFilterColumn,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// End time of the requested range for this dataset. Type: string (or Expression with resultType string).
	EndTime interface{} `json:"endTime,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// The columns to be read out from the Office 365 table. Type: array of objects (or Expression with resultType array of objects).
	// Example: [ { "name": "Id" }, { "name": "CreatedDateTime" } ]
	OutputColumns interface{} `json:"outputColumns,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`

	// Start time of the requested range for this dataset. Type: string (or Expression with resultType string).
	StartTime interface{} `json:"startTime,omitempty"`

	// The user scope uri. Type: string (or Expression with resultType string).
	UserScopeFilterURI interface{} `json:"userScopeFilterUri,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type Office365Source.
func (o *Office365Source) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     o.Type,
		SourceRetryCount:         o.SourceRetryCount,
		SourceRetryWait:          o.SourceRetryWait,
		MaxConcurrentConnections: o.MaxConcurrentConnections,
		DisableMetricsCollection: o.DisableMetricsCollection,
		AdditionalProperties:     o.AdditionalProperties,
	}
}

// Operation - Azure Data Factory API operation definition.
type Operation struct {
	// Metadata associated with the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`

	// The intended executor of the operation.
	Origin *string `json:"origin,omitempty"`

	// Additional details about the operation.
	Properties *OperationProperties `json:"properties,omitempty"`
}

// OperationDisplay - Metadata associated with the operation.
type OperationDisplay struct {
	// The description of the operation.
	Description *string `json:"description,omitempty"`

	// The type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// The name of the provider.
	Provider *string `json:"provider,omitempty"`

	// The name of the resource type on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResponse - A list of operations that can be performed by the Data Factory service.
type OperationListResponse struct {
	// The link to the next page of results, if any remaining results exist.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Data Factory operations supported by the Data Factory resource provider.
	Value []*Operation `json:"value,omitempty"`
}

// OperationLogSpecification - Details about an operation related to logs.
type OperationLogSpecification struct {
	// Blobs created in the customer storage account, per hour.
	BlobDuration *string `json:"blobDuration,omitempty"`

	// Localized display name.
	DisplayName *string `json:"displayName,omitempty"`

	// The name of the log category.
	Name *string `json:"name,omitempty"`
}

// OperationMetricAvailability - Defines how often data for a metric becomes available.
type OperationMetricAvailability struct {
	// Blob created in the customer storage account, per hour.
	BlobDuration *string `json:"blobDuration,omitempty"`

	// The granularity for the metric.
	TimeGrain *string `json:"timeGrain,omitempty"`
}

// OperationMetricDimension - Defines the metric dimension.
type OperationMetricDimension struct {
	// The display name of the metric dimension.
	DisplayName *string `json:"displayName,omitempty"`

	// The name of the dimension for the metric.
	Name *string `json:"name,omitempty"`

	// Whether the dimension should be exported to Azure Monitor.
	ToBeExportedForShoebox *bool `json:"toBeExportedForShoebox,omitempty"`
}

// OperationMetricSpecification - Details about an operation related to metrics.
type OperationMetricSpecification struct {
	// The type of metric aggregation.
	AggregationType *string `json:"aggregationType,omitempty"`

	// Defines how often data for metrics becomes available.
	Availabilities []*OperationMetricAvailability `json:"availabilities,omitempty"`

	// Defines the metric dimension.
	Dimensions []*OperationMetricDimension `json:"dimensions,omitempty"`

	// The description of the metric.
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// Localized display name of the metric.
	DisplayName *string `json:"displayName,omitempty"`

	// Whether or not the service is using regional MDM accounts.
	EnableRegionalMdmAccount *string `json:"enableRegionalMdmAccount,omitempty"`

	// The name of the metric.
	Name *string `json:"name,omitempty"`

	// The name of the MDM account.
	SourceMdmAccount *string `json:"sourceMdmAccount,omitempty"`

	// The name of the MDM namespace.
	SourceMdmNamespace *string `json:"sourceMdmNamespace,omitempty"`

	// The unit that the metric is measured in.
	Unit *string `json:"unit,omitempty"`
}

// OperationProperties - Additional details about an operation.
type OperationProperties struct {
	// Details about a service operation.
	ServiceSpecification *OperationServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationServiceSpecification - Details about a service operation.
type OperationServiceSpecification struct {
	// Details about operations related to logs.
	LogSpecifications []*OperationLogSpecification `json:"logSpecifications,omitempty"`

	// Details about operations related to metrics.
	MetricSpecifications []*OperationMetricSpecification `json:"metricSpecifications,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OracleCloudStorageLinkedService - Linked service for Oracle Cloud Storage.
type OracleCloudStorageLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Oracle Cloud Storage linked service properties.
	TypeProperties *OracleCloudStorageLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type OracleCloudStorageLinkedService.
func (o *OracleCloudStorageLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 o.Type,
		ConnectVia:           o.ConnectVia,
		Description:          o.Description,
		Parameters:           o.Parameters,
		Annotations:          o.Annotations,
		AdditionalProperties: o.AdditionalProperties,
	}
}

// OracleCloudStorageLinkedServiceTypeProperties - Oracle Cloud Storage linked service properties.
type OracleCloudStorageLinkedServiceTypeProperties struct {
	// The access key identifier of the Oracle Cloud Storage Identity and Access Management (IAM) user. Type: string (or Expression
	// with resultType string).
	AccessKeyID interface{} `json:"accessKeyId,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The secret access key of the Oracle Cloud Storage Identity and Access Management (IAM) user.
	SecretAccessKey SecretBaseClassification `json:"secretAccessKey,omitempty"`

	// This value specifies the endpoint to access with the Oracle Cloud Storage Connector. This is an optional property; change
	// it only if you want to try a different service endpoint or want to switch
	// between https and http. Type: string (or Expression with resultType string).
	ServiceURL interface{} `json:"serviceUrl,omitempty"`
}

// OracleCloudStorageLocation - The location of Oracle Cloud Storage dataset.
type OracleCloudStorageLocation struct {
	// REQUIRED; Type of dataset storage location.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Specify the bucketName of Oracle Cloud Storage. Type: string (or Expression with resultType string)
	BucketName interface{} `json:"bucketName,omitempty"`

	// Specify the file name of dataset. Type: string (or Expression with resultType string).
	FileName interface{} `json:"fileName,omitempty"`

	// Specify the folder path of dataset. Type: string (or Expression with resultType string)
	FolderPath interface{} `json:"folderPath,omitempty"`

	// Specify the version of Oracle Cloud Storage. Type: string (or Expression with resultType string).
	Version interface{} `json:"version,omitempty"`
}

// GetDatasetLocation implements the DatasetLocationClassification interface for type OracleCloudStorageLocation.
func (o *OracleCloudStorageLocation) GetDatasetLocation() *DatasetLocation {
	return &DatasetLocation{
		Type:                 o.Type,
		FolderPath:           o.FolderPath,
		FileName:             o.FileName,
		AdditionalProperties: o.AdditionalProperties,
	}
}

// OracleCloudStorageReadSettings - Oracle Cloud Storage read settings.
type OracleCloudStorageReadSettings struct {
	// REQUIRED; The read setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression
	// with resultType boolean).
	DeleteFilesAfterCompletion interface{} `json:"deleteFilesAfterCompletion,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// Indicates whether to enable partition discovery.
	EnablePartitionDiscovery *bool `json:"enablePartitionDiscovery,omitempty"`

	// Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy.
	// Type: string (or Expression with resultType string).
	FileListPath interface{} `json:"fileListPath,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// The end of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeEnd interface{} `json:"modifiedDatetimeEnd,omitempty"`

	// The start of file's modified datetime. Type: string (or Expression with resultType string).
	ModifiedDatetimeStart interface{} `json:"modifiedDatetimeStart,omitempty"`

	// Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
	PartitionRootPath interface{} `json:"partitionRootPath,omitempty"`

	// The prefix filter for the Oracle Cloud Storage object name. Type: string (or Expression with resultType string).
	Prefix interface{} `json:"prefix,omitempty"`

	// If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType
	// boolean).
	Recursive interface{} `json:"recursive,omitempty"`

	// Oracle Cloud Storage wildcardFileName. Type: string (or Expression with resultType string).
	WildcardFileName interface{} `json:"wildcardFileName,omitempty"`

	// Oracle Cloud Storage wildcardFolderPath. Type: string (or Expression with resultType string).
	WildcardFolderPath interface{} `json:"wildcardFolderPath,omitempty"`
}

// GetStoreReadSettings implements the StoreReadSettingsClassification interface for type OracleCloudStorageReadSettings.
func (o *OracleCloudStorageReadSettings) GetStoreReadSettings() *StoreReadSettings {
	return &StoreReadSettings{
		Type:                     o.Type,
		MaxConcurrentConnections: o.MaxConcurrentConnections,
		DisableMetricsCollection: o.DisableMetricsCollection,
		AdditionalProperties:     o.AdditionalProperties,
	}
}

// OracleLinkedService - Oracle database.
type OracleLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Oracle database linked service properties.
	TypeProperties *OracleLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type OracleLinkedService.
func (o *OracleLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 o.Type,
		ConnectVia:           o.ConnectVia,
		Description:          o.Description,
		Parameters:           o.Parameters,
		Annotations:          o.Annotations,
		AdditionalProperties: o.AdditionalProperties,
	}
}

// OracleLinkedServiceTypeProperties - Oracle database linked service properties.
type OracleLinkedServiceTypeProperties struct {
	// REQUIRED; The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The Azure key vault secret reference of password in connection string.
	Password *AzureKeyVaultSecretReference `json:"password,omitempty"`
}

// OraclePartitionSettings - The settings that will be leveraged for Oracle source partitioning.
type OraclePartitionSettings struct {
	// The name of the column in integer type that will be used for proceeding range partitioning. Type: string (or Expression
	// with resultType string).
	PartitionColumnName interface{} `json:"partitionColumnName,omitempty"`

	// The minimum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type:
	// string (or Expression with resultType string).
	PartitionLowerBound interface{} `json:"partitionLowerBound,omitempty"`

	// Names of the physical partitions of Oracle table.
	PartitionNames interface{} `json:"partitionNames,omitempty"`

	// The maximum value of column specified in partitionColumnName that will be used for proceeding range partitioning. Type:
	// string (or Expression with resultType string).
	PartitionUpperBound interface{} `json:"partitionUpperBound,omitempty"`
}

// OracleServiceCloudLinkedService - Oracle Service Cloud linked service.
type OracleServiceCloudLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Oracle Service Cloud linked service properties.
	TypeProperties *OracleServiceCloudLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type OracleServiceCloudLinkedService.
func (o *OracleServiceCloudLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 o.Type,
		ConnectVia:           o.ConnectVia,
		Description:          o.Description,
		Parameters:           o.Parameters,
		Annotations:          o.Annotations,
		AdditionalProperties: o.AdditionalProperties,
	}
}

// OracleServiceCloudLinkedServiceTypeProperties - Oracle Service Cloud linked service properties.
type OracleServiceCloudLinkedServiceTypeProperties struct {
	// REQUIRED; The URL of the Oracle Service Cloud instance.
	Host interface{} `json:"host,omitempty"`

	// REQUIRED; The password corresponding to the user name that you provided in the username key.
	Password SecretBaseClassification `json:"password,omitempty"`

	// REQUIRED; The user name that you use to access Oracle Service Cloud server.
	Username interface{} `json:"username,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true. Type: boolean (or Expression
	// with resultType boolean).
	UseEncryptedEndpoints interface{} `json:"useEncryptedEndpoints,omitempty"`

	// Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting
	// over SSL. The default value is true. Type: boolean (or Expression with
	// resultType boolean).
	UseHostVerification interface{} `json:"useHostVerification,omitempty"`

	// Specifies whether to verify the identity of the server when connecting over SSL. The default value is true. Type: boolean
	// (or Expression with resultType boolean).
	UsePeerVerification interface{} `json:"usePeerVerification,omitempty"`
}

// OracleServiceCloudObjectDataset - Oracle Service Cloud dataset.
type OracleServiceCloudObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type OracleServiceCloudObjectDataset.
func (o *OracleServiceCloudObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 o.Type,
		Description:          o.Description,
		Structure:            o.Structure,
		Schema:               o.Schema,
		LinkedServiceName:    o.LinkedServiceName,
		Parameters:           o.Parameters,
		Annotations:          o.Annotations,
		Folder:               o.Folder,
		AdditionalProperties: o.AdditionalProperties,
	}
}

// OracleServiceCloudSource - A copy activity Oracle Service Cloud source.
type OracleServiceCloudSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type OracleServiceCloudSource.
func (o *OracleServiceCloudSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     o.Type,
		SourceRetryCount:         o.SourceRetryCount,
		SourceRetryWait:          o.SourceRetryWait,
		MaxConcurrentConnections: o.MaxConcurrentConnections,
		DisableMetricsCollection: o.DisableMetricsCollection,
		AdditionalProperties:     o.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type OracleServiceCloudSource.
func (o *OracleServiceCloudSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             o.QueryTimeout,
		AdditionalColumns:        o.AdditionalColumns,
		Type:                     o.Type,
		SourceRetryCount:         o.SourceRetryCount,
		SourceRetryWait:          o.SourceRetryWait,
		MaxConcurrentConnections: o.MaxConcurrentConnections,
		DisableMetricsCollection: o.DisableMetricsCollection,
		AdditionalProperties:     o.AdditionalProperties,
	}
}

// OracleSink - A copy activity Oracle sink.
type OracleSink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// SQL pre-copy script. Type: string (or Expression with resultType string).
	PreCopyScript interface{} `json:"preCopyScript,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type OracleSink.
func (o *OracleSink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     o.Type,
		WriteBatchSize:           o.WriteBatchSize,
		WriteBatchTimeout:        o.WriteBatchTimeout,
		SinkRetryCount:           o.SinkRetryCount,
		SinkRetryWait:            o.SinkRetryWait,
		MaxConcurrentConnections: o.MaxConcurrentConnections,
		DisableMetricsCollection: o.DisableMetricsCollection,
		AdditionalProperties:     o.AdditionalProperties,
	}
}

// OracleSource - A copy activity Oracle source.
type OracleSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Oracle reader query. Type: string (or Expression with resultType string).
	OracleReaderQuery interface{} `json:"oracleReaderQuery,omitempty"`

	// The partition mechanism that will be used for Oracle read in parallel. Possible values include: "None", "PhysicalPartitionsOfTable",
	// "DynamicRange".
	PartitionOption interface{} `json:"partitionOption,omitempty"`

	// The settings that will be leveraged for Oracle source partitioning.
	PartitionSettings *OraclePartitionSettings `json:"partitionSettings,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type OracleSource.
func (o *OracleSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     o.Type,
		SourceRetryCount:         o.SourceRetryCount,
		SourceRetryWait:          o.SourceRetryWait,
		MaxConcurrentConnections: o.MaxConcurrentConnections,
		DisableMetricsCollection: o.DisableMetricsCollection,
		AdditionalProperties:     o.AdditionalProperties,
	}
}

// OracleTableDataset - The on-premises Oracle database dataset.
type OracleTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// On-premises Oracle dataset properties.
	TypeProperties *OracleTableDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type OracleTableDataset.
func (o *OracleTableDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 o.Type,
		Description:          o.Description,
		Structure:            o.Structure,
		Schema:               o.Schema,
		LinkedServiceName:    o.LinkedServiceName,
		Parameters:           o.Parameters,
		Annotations:          o.Annotations,
		Folder:               o.Folder,
		AdditionalProperties: o.AdditionalProperties,
	}
}

// OracleTableDatasetTypeProperties - On-premises Oracle dataset properties.
type OracleTableDatasetTypeProperties struct {
	// The schema name of the on-premises Oracle database. Type: string (or Expression with resultType string).
	Schema interface{} `json:"schema,omitempty"`

	// The table name of the on-premises Oracle database. Type: string (or Expression with resultType string).
	Table interface{} `json:"table,omitempty"`

	// This property will be retired. Please consider using schema + table properties instead.
	TableName interface{} `json:"tableName,omitempty"`
}

// OrcDataset - ORC dataset.
type OrcDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// ORC dataset properties.
	TypeProperties *OrcDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type OrcDataset.
func (o *OrcDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 o.Type,
		Description:          o.Description,
		Structure:            o.Structure,
		Schema:               o.Schema,
		LinkedServiceName:    o.LinkedServiceName,
		Parameters:           o.Parameters,
		Annotations:          o.Annotations,
		Folder:               o.Folder,
		AdditionalProperties: o.AdditionalProperties,
	}
}

// OrcDatasetTypeProperties - ORC dataset properties.
type OrcDatasetTypeProperties struct {
	// REQUIRED; The location of the ORC data storage.
	Location DatasetLocationClassification `json:"location,omitempty"`

	// The data orcCompressionCodec. Type: string (or Expression with resultType string).
	OrcCompressionCodec interface{} `json:"orcCompressionCodec,omitempty"`
}

// OrcFormat - The data stored in Optimized Row Columnar (ORC) format.
type OrcFormat struct {
	// REQUIRED; Type of dataset storage format.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Deserializer. Type: string (or Expression with resultType string).
	Deserializer interface{} `json:"deserializer,omitempty"`

	// Serializer. Type: string (or Expression with resultType string).
	Serializer interface{} `json:"serializer,omitempty"`
}

// GetDatasetStorageFormat implements the DatasetStorageFormatClassification interface for type OrcFormat.
func (o *OrcFormat) GetDatasetStorageFormat() *DatasetStorageFormat {
	return &DatasetStorageFormat{
		Type:                 o.Type,
		Serializer:           o.Serializer,
		Deserializer:         o.Deserializer,
		AdditionalProperties: o.AdditionalProperties,
	}
}

// OrcSink - A copy activity ORC sink.
type OrcSink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// ORC format settings.
	FormatSettings *OrcWriteSettings `json:"formatSettings,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// ORC store settings.
	StoreSettings StoreWriteSettingsClassification `json:"storeSettings,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type OrcSink.
func (o *OrcSink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     o.Type,
		WriteBatchSize:           o.WriteBatchSize,
		WriteBatchTimeout:        o.WriteBatchTimeout,
		SinkRetryCount:           o.SinkRetryCount,
		SinkRetryWait:            o.SinkRetryWait,
		MaxConcurrentConnections: o.MaxConcurrentConnections,
		DisableMetricsCollection: o.DisableMetricsCollection,
		AdditionalProperties:     o.AdditionalProperties,
	}
}

// OrcSource - A copy activity ORC source.
type OrcSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`

	// ORC store settings.
	StoreSettings StoreReadSettingsClassification `json:"storeSettings,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type OrcSource.
func (o *OrcSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     o.Type,
		SourceRetryCount:         o.SourceRetryCount,
		SourceRetryWait:          o.SourceRetryWait,
		MaxConcurrentConnections: o.MaxConcurrentConnections,
		DisableMetricsCollection: o.DisableMetricsCollection,
		AdditionalProperties:     o.AdditionalProperties,
	}
}

// OrcWriteSettings - Orc write settings.
type OrcWriteSettings struct {
	// REQUIRED; The write setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Specifies the file name pattern _. when copy from non-file based store without partitionOptions. Type: string (or Expression
	// with resultType string).
	FileNamePrefix interface{} `json:"fileNamePrefix,omitempty"`

	// Limit the written file's row count to be smaller than or equal to the specified count. Type: integer (or Expression with
	// resultType integer).
	MaxRowsPerFile interface{} `json:"maxRowsPerFile,omitempty"`
}

// GetFormatWriteSettings implements the FormatWriteSettingsClassification interface for type OrcWriteSettings.
func (o *OrcWriteSettings) GetFormatWriteSettings() *FormatWriteSettings {
	return &FormatWriteSettings{
		Type:                 o.Type,
		AdditionalProperties: o.AdditionalProperties,
	}
}

// PackageStore - Package store for the SSIS integration runtime.
type PackageStore struct {
	// REQUIRED; The name of the package store
	Name *string `json:"name,omitempty"`

	// REQUIRED; The package store linked service reference.
	PackageStoreLinkedService *EntityReference `json:"packageStoreLinkedService,omitempty"`
}

// ParameterSpecification - Definition of a single parameter for an entity.
type ParameterSpecification struct {
	// REQUIRED; Parameter type.
	Type *ParameterType `json:"type,omitempty"`

	// Default value of parameter.
	DefaultValue interface{} `json:"defaultValue,omitempty"`
}

// ParquetDataset - Parquet dataset.
type ParquetDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Parquet dataset properties.
	TypeProperties *ParquetDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type ParquetDataset.
func (p *ParquetDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 p.Type,
		Description:          p.Description,
		Structure:            p.Structure,
		Schema:               p.Schema,
		LinkedServiceName:    p.LinkedServiceName,
		Parameters:           p.Parameters,
		Annotations:          p.Annotations,
		Folder:               p.Folder,
		AdditionalProperties: p.AdditionalProperties,
	}
}

// ParquetDatasetTypeProperties - Parquet dataset properties.
type ParquetDatasetTypeProperties struct {
	// REQUIRED; The location of the parquet storage.
	Location DatasetLocationClassification `json:"location,omitempty"`

	// The data compressionCodec. Type: string (or Expression with resultType string).
	CompressionCodec interface{} `json:"compressionCodec,omitempty"`
}

// ParquetFormat - The data stored in Parquet format.
type ParquetFormat struct {
	// REQUIRED; Type of dataset storage format.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Deserializer. Type: string (or Expression with resultType string).
	Deserializer interface{} `json:"deserializer,omitempty"`

	// Serializer. Type: string (or Expression with resultType string).
	Serializer interface{} `json:"serializer,omitempty"`
}

// GetDatasetStorageFormat implements the DatasetStorageFormatClassification interface for type ParquetFormat.
func (p *ParquetFormat) GetDatasetStorageFormat() *DatasetStorageFormat {
	return &DatasetStorageFormat{
		Type:                 p.Type,
		Serializer:           p.Serializer,
		Deserializer:         p.Deserializer,
		AdditionalProperties: p.AdditionalProperties,
	}
}

// ParquetSink - A copy activity Parquet sink.
type ParquetSink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// Parquet format settings.
	FormatSettings *ParquetWriteSettings `json:"formatSettings,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// Parquet store settings.
	StoreSettings StoreWriteSettingsClassification `json:"storeSettings,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type ParquetSink.
func (p *ParquetSink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     p.Type,
		WriteBatchSize:           p.WriteBatchSize,
		WriteBatchTimeout:        p.WriteBatchTimeout,
		SinkRetryCount:           p.SinkRetryCount,
		SinkRetryWait:            p.SinkRetryWait,
		MaxConcurrentConnections: p.MaxConcurrentConnections,
		DisableMetricsCollection: p.DisableMetricsCollection,
		AdditionalProperties:     p.AdditionalProperties,
	}
}

// ParquetSource - A copy activity Parquet source.
type ParquetSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`

	// Parquet store settings.
	StoreSettings StoreReadSettingsClassification `json:"storeSettings,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type ParquetSource.
func (p *ParquetSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     p.Type,
		SourceRetryCount:         p.SourceRetryCount,
		SourceRetryWait:          p.SourceRetryWait,
		MaxConcurrentConnections: p.MaxConcurrentConnections,
		DisableMetricsCollection: p.DisableMetricsCollection,
		AdditionalProperties:     p.AdditionalProperties,
	}
}

// ParquetWriteSettings - Parquet write settings.
type ParquetWriteSettings struct {
	// REQUIRED; The write setting type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Specifies the file name pattern _. when copy from non-file based store without partitionOptions. Type: string (or Expression
	// with resultType string).
	FileNamePrefix interface{} `json:"fileNamePrefix,omitempty"`

	// Limit the written file's row count to be smaller than or equal to the specified count. Type: integer (or Expression with
	// resultType integer).
	MaxRowsPerFile interface{} `json:"maxRowsPerFile,omitempty"`
}

// GetFormatWriteSettings implements the FormatWriteSettingsClassification interface for type ParquetWriteSettings.
func (p *ParquetWriteSettings) GetFormatWriteSettings() *FormatWriteSettings {
	return &FormatWriteSettings{
		Type:                 p.Type,
		AdditionalProperties: p.AdditionalProperties,
	}
}

// PaypalLinkedService - Paypal Service linked service.
type PaypalLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Paypal Service linked service properties.
	TypeProperties *PaypalLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type PaypalLinkedService.
func (p *PaypalLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 p.Type,
		ConnectVia:           p.ConnectVia,
		Description:          p.Description,
		Parameters:           p.Parameters,
		Annotations:          p.Annotations,
		AdditionalProperties: p.AdditionalProperties,
	}
}

// PaypalLinkedServiceTypeProperties - Paypal Service linked service properties.
type PaypalLinkedServiceTypeProperties struct {
	// REQUIRED; The client ID associated with your PayPal application.
	ClientID interface{} `json:"clientId,omitempty"`

	// REQUIRED; The URL of the PayPal instance. (i.e. api.sandbox.paypal.com)
	Host interface{} `json:"host,omitempty"`

	// The client secret associated with your PayPal application.
	ClientSecret SecretBaseClassification `json:"clientSecret,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
	UseEncryptedEndpoints interface{} `json:"useEncryptedEndpoints,omitempty"`

	// Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting
	// over SSL. The default value is true.
	UseHostVerification interface{} `json:"useHostVerification,omitempty"`

	// Specifies whether to verify the identity of the server when connecting over SSL. The default value is true.
	UsePeerVerification interface{} `json:"usePeerVerification,omitempty"`
}

// PaypalObjectDataset - Paypal Service dataset.
type PaypalObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type PaypalObjectDataset.
func (p *PaypalObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 p.Type,
		Description:          p.Description,
		Structure:            p.Structure,
		Schema:               p.Schema,
		LinkedServiceName:    p.LinkedServiceName,
		Parameters:           p.Parameters,
		Annotations:          p.Annotations,
		Folder:               p.Folder,
		AdditionalProperties: p.AdditionalProperties,
	}
}

// PaypalSource - A copy activity Paypal Service source.
type PaypalSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type PaypalSource.
func (p *PaypalSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     p.Type,
		SourceRetryCount:         p.SourceRetryCount,
		SourceRetryWait:          p.SourceRetryWait,
		MaxConcurrentConnections: p.MaxConcurrentConnections,
		DisableMetricsCollection: p.DisableMetricsCollection,
		AdditionalProperties:     p.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type PaypalSource.
func (p *PaypalSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             p.QueryTimeout,
		AdditionalColumns:        p.AdditionalColumns,
		Type:                     p.Type,
		SourceRetryCount:         p.SourceRetryCount,
		SourceRetryWait:          p.SourceRetryWait,
		MaxConcurrentConnections: p.MaxConcurrentConnections,
		DisableMetricsCollection: p.DisableMetricsCollection,
		AdditionalProperties:     p.AdditionalProperties,
	}
}

// PhoenixDatasetTypeProperties - Phoenix Dataset Properties
type PhoenixDatasetTypeProperties struct {
	// The schema name of the Phoenix. Type: string (or Expression with resultType string).
	Schema interface{} `json:"schema,omitempty"`

	// The table name of the Phoenix. Type: string (or Expression with resultType string).
	Table interface{} `json:"table,omitempty"`

	// This property will be retired. Please consider using schema + table properties instead.
	TableName interface{} `json:"tableName,omitempty"`
}

// PhoenixLinkedService - Phoenix server linked service.
type PhoenixLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Phoenix server linked service properties.
	TypeProperties *PhoenixLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type PhoenixLinkedService.
func (p *PhoenixLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 p.Type,
		ConnectVia:           p.ConnectVia,
		Description:          p.Description,
		Parameters:           p.Parameters,
		Annotations:          p.Annotations,
		AdditionalProperties: p.AdditionalProperties,
	}
}

// PhoenixLinkedServiceTypeProperties - Phoenix server linked service properties.
type PhoenixLinkedServiceTypeProperties struct {
	// REQUIRED; The authentication mechanism used to connect to the Phoenix server.
	AuthenticationType *PhoenixAuthenticationType `json:"authenticationType,omitempty"`

	// REQUIRED; The IP address or host name of the Phoenix server. (i.e. 192.168.222.160)
	Host interface{} `json:"host,omitempty"`

	// Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over
	// SSL. The default value is false.
	AllowHostNameCNMismatch interface{} `json:"allowHostNameCNMismatch,omitempty"`

	// Specifies whether to allow self-signed certificates from the server. The default value is false.
	AllowSelfSignedServerCert interface{} `json:"allowSelfSignedServerCert,omitempty"`

	// Specifies whether the connections to the server are encrypted using SSL. The default value is false.
	EnableSSL interface{} `json:"enableSsl,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The partial URL corresponding to the Phoenix server. (i.e. /gateway/sandbox/phoenix/version). The default value is hbasephoenix
	// if using WindowsAzureHDInsightService.
	HTTPPath interface{} `json:"httpPath,omitempty"`

	// The password corresponding to the user name.
	Password SecretBaseClassification `json:"password,omitempty"`

	// The TCP port that the Phoenix server uses to listen for client connections. The default value is 8765.
	Port interface{} `json:"port,omitempty"`

	// The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This
	// property can only be set when using SSL on self-hosted IR. The default value
	// is the cacerts.pem file installed with the IR.
	TrustedCertPath interface{} `json:"trustedCertPath,omitempty"`

	// Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is
	// false.
	UseSystemTrustStore interface{} `json:"useSystemTrustStore,omitempty"`

	// The user name used to connect to the Phoenix server.
	Username interface{} `json:"username,omitempty"`
}

// PhoenixObjectDataset - Phoenix server dataset.
type PhoenixObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Properties specific to this dataset type.
	TypeProperties *PhoenixDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type PhoenixObjectDataset.
func (p *PhoenixObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 p.Type,
		Description:          p.Description,
		Structure:            p.Structure,
		Schema:               p.Schema,
		LinkedServiceName:    p.LinkedServiceName,
		Parameters:           p.Parameters,
		Annotations:          p.Annotations,
		Folder:               p.Folder,
		AdditionalProperties: p.AdditionalProperties,
	}
}

// PhoenixSource - A copy activity Phoenix server source.
type PhoenixSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type PhoenixSource.
func (p *PhoenixSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     p.Type,
		SourceRetryCount:         p.SourceRetryCount,
		SourceRetryWait:          p.SourceRetryWait,
		MaxConcurrentConnections: p.MaxConcurrentConnections,
		DisableMetricsCollection: p.DisableMetricsCollection,
		AdditionalProperties:     p.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type PhoenixSource.
func (p *PhoenixSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             p.QueryTimeout,
		AdditionalColumns:        p.AdditionalColumns,
		Type:                     p.Type,
		SourceRetryCount:         p.SourceRetryCount,
		SourceRetryWait:          p.SourceRetryWait,
		MaxConcurrentConnections: p.MaxConcurrentConnections,
		DisableMetricsCollection: p.DisableMetricsCollection,
		AdditionalProperties:     p.AdditionalProperties,
	}
}

// Pipeline - A data factory pipeline.
type Pipeline struct {
	// List of activities in pipeline.
	Activities []ActivityClassification `json:"activities,omitempty"`

	// List of tags that can be used for describing the Pipeline.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The max number of concurrent runs for the pipeline.
	Concurrency *int32 `json:"concurrency,omitempty"`

	// The description of the pipeline.
	Description *string `json:"description,omitempty"`

	// The folder that this Pipeline is in. If not specified, Pipeline will appear at the root level.
	Folder *PipelineFolder `json:"folder,omitempty"`

	// List of parameters for pipeline.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Pipeline Policy.
	Policy *PipelinePolicy `json:"policy,omitempty"`

	// Dimensions emitted by Pipeline.
	RunDimensions map[string]interface{} `json:"runDimensions,omitempty"`

	// List of variables for pipeline.
	Variables map[string]*VariableSpecification `json:"variables,omitempty"`
}

// PipelineElapsedTimeMetricPolicy - Pipeline ElapsedTime Metric Policy.
type PipelineElapsedTimeMetricPolicy struct {
	// TimeSpan value, after which an Azure Monitoring Metric is fired.
	Duration interface{} `json:"duration,omitempty"`
}

// PipelineFolder - The folder that this Pipeline is in. If not specified, Pipeline will appear at the root level.
type PipelineFolder struct {
	// The name of the folder that this Pipeline is in.
	Name *string `json:"name,omitempty"`
}

// PipelineListResponse - A list of pipeline resources.
type PipelineListResponse struct {
	// REQUIRED; List of pipelines.
	Value []*PipelineResource `json:"value,omitempty"`

	// The link to the next page of results, if any remaining results exist.
	NextLink *string `json:"nextLink,omitempty"`
}

// PipelinePolicy - Pipeline Policy.
type PipelinePolicy struct {
	// Pipeline ElapsedTime Metric Policy.
	ElapsedTimeMetric *PipelineElapsedTimeMetricPolicy `json:"elapsedTimeMetric,omitempty"`
}

// PipelineReference - Pipeline reference type.
type PipelineReference struct {
	// REQUIRED; Reference pipeline name.
	ReferenceName *string `json:"referenceName,omitempty"`

	// REQUIRED; Pipeline reference type.
	Type *PipelineReferenceType `json:"type,omitempty"`

	// Reference name.
	Name *string `json:"name,omitempty"`
}

// PipelineResource - Pipeline resource type.
type PipelineResource struct {
	// REQUIRED; Properties of the pipeline.
	Properties *Pipeline `json:"properties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// READ-ONLY; Etag identifies change in the resource.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PipelineRun - Information about a pipeline run.
type PipelineRun struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// READ-ONLY; The duration of a pipeline run.
	DurationInMs *int32 `json:"durationInMs,omitempty" azure:"ro"`

	// READ-ONLY; Entity that started the pipeline run.
	InvokedBy *PipelineRunInvokedBy `json:"invokedBy,omitempty" azure:"ro"`

	// READ-ONLY; Indicates if the recovered pipeline run is the latest in its group.
	IsLatest *bool `json:"isLatest,omitempty" azure:"ro"`

	// READ-ONLY; The last updated timestamp for the pipeline run event in ISO8601 format.
	LastUpdated *time.Time `json:"lastUpdated,omitempty" azure:"ro"`

	// READ-ONLY; The message from a pipeline run.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The full or partial list of parameter name, value pair used in the pipeline run.
	Parameters map[string]*string `json:"parameters,omitempty" azure:"ro"`

	// READ-ONLY; The pipeline name.
	PipelineName *string `json:"pipelineName,omitempty" azure:"ro"`

	// READ-ONLY; Run dimensions emitted by Pipeline run.
	RunDimensions map[string]*string `json:"runDimensions,omitempty" azure:"ro"`

	// READ-ONLY; The end time of a pipeline run in ISO8601 format.
	RunEnd *time.Time `json:"runEnd,omitempty" azure:"ro"`

	// READ-ONLY; Identifier that correlates all the recovery runs of a pipeline run.
	RunGroupID *string `json:"runGroupId,omitempty" azure:"ro"`

	// READ-ONLY; Identifier of a run.
	RunID *string `json:"runId,omitempty" azure:"ro"`

	// READ-ONLY; The start time of a pipeline run in ISO8601 format.
	RunStart *time.Time `json:"runStart,omitempty" azure:"ro"`

	// READ-ONLY; The status of a pipeline run. Possible values: Queued, InProgress, Succeeded, Failed, Canceling, Cancelled
	Status *string `json:"status,omitempty" azure:"ro"`
}

// PipelineRunInvokedBy - Provides entity name and id that started the pipeline run.
type PipelineRunInvokedBy struct {
	// READ-ONLY; The ID of the entity that started the run.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The type of the entity that started the run.
	InvokedByType *string `json:"invokedByType,omitempty" azure:"ro"`

	// READ-ONLY; Name of the entity that started the pipeline run.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The name of the pipeline that triggered the run, if any.
	PipelineName *string `json:"pipelineName,omitempty" azure:"ro"`

	// READ-ONLY; The run id of the pipeline that triggered the run, if any.
	PipelineRunID *string `json:"pipelineRunId,omitempty" azure:"ro"`
}

// PipelineRunsClientCancelOptions contains the optional parameters for the PipelineRunsClient.Cancel method.
type PipelineRunsClientCancelOptions struct {
	// If true, cancel all the Child pipelines that are triggered by the current pipeline.
	IsRecursive *bool
}

// PipelineRunsClientGetOptions contains the optional parameters for the PipelineRunsClient.Get method.
type PipelineRunsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PipelineRunsClientQueryByFactoryOptions contains the optional parameters for the PipelineRunsClient.QueryByFactory method.
type PipelineRunsClientQueryByFactoryOptions struct {
	// placeholder for future optional parameters
}

// PipelineRunsQueryResponse - A list pipeline runs.
type PipelineRunsQueryResponse struct {
	// REQUIRED; List of pipeline runs.
	Value []*PipelineRun `json:"value,omitempty"`

	// The continuation token for getting the next page of results, if any remaining results exist, null otherwise.
	ContinuationToken *string `json:"continuationToken,omitempty"`
}

// PipelinesClientCreateOrUpdateOptions contains the optional parameters for the PipelinesClient.CreateOrUpdate method.
type PipelinesClientCreateOrUpdateOptions struct {
	// ETag of the pipeline entity. Should only be specified for update, for which it should match existing entity or can be *
	// for unconditional update.
	IfMatch *string
}

// PipelinesClientCreateRunOptions contains the optional parameters for the PipelinesClient.CreateRun method.
type PipelinesClientCreateRunOptions struct {
	// Recovery mode flag. If recovery mode is set to true, the specified referenced pipeline run and the new run will be grouped
	// under the same groupId.
	IsRecovery *bool
	// Parameters of the pipeline run. These parameters will be used only if the runId is not specified.
	Parameters map[string]interface{}
	// The pipeline run identifier. If run ID is specified the parameters of the specified run will be used to create a new run.
	ReferencePipelineRunID *string
	// In recovery mode, the rerun will start from this activity. If not specified, all activities will run.
	StartActivityName *string
	// In recovery mode, if set to true, the rerun will start from failed activities. The property will be used only if startActivityName
	// is not specified.
	StartFromFailure *bool
}

// PipelinesClientDeleteOptions contains the optional parameters for the PipelinesClient.Delete method.
type PipelinesClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// PipelinesClientGetOptions contains the optional parameters for the PipelinesClient.Get method.
type PipelinesClientGetOptions struct {
	// ETag of the pipeline entity. Should only be specified for get. If the ETag matches the existing entity tag, or if * was
	// provided, then no content will be returned.
	IfNoneMatch *string
}

// PipelinesClientListByFactoryOptions contains the optional parameters for the PipelinesClient.ListByFactory method.
type PipelinesClientListByFactoryOptions struct {
	// placeholder for future optional parameters
}

// PolybaseSettings - PolyBase settings.
type PolybaseSettings struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Determines the number of rows to attempt to retrieve before the PolyBase recalculates the percentage of rejected rows.
	// Type: integer (or Expression with resultType integer), minimum: 0.
	RejectSampleValue interface{} `json:"rejectSampleValue,omitempty"`

	// Reject type.
	RejectType *PolybaseSettingsRejectType `json:"rejectType,omitempty"`

	// Specifies the value or the percentage of rows that can be rejected before the query fails. Type: number (or Expression
	// with resultType number), minimum: 0.
	RejectValue interface{} `json:"rejectValue,omitempty"`

	// Specifies how to handle missing values in delimited text files when PolyBase retrieves data from the text file. Type: boolean
	// (or Expression with resultType boolean).
	UseTypeDefault interface{} `json:"useTypeDefault,omitempty"`
}

// PostgreSQLLinkedService - Linked service for PostgreSQL data source.
type PostgreSQLLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; PostgreSQL linked service properties.
	TypeProperties *PostgreSQLLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type PostgreSQLLinkedService.
func (p *PostgreSQLLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 p.Type,
		ConnectVia:           p.ConnectVia,
		Description:          p.Description,
		Parameters:           p.Parameters,
		Annotations:          p.Annotations,
		AdditionalProperties: p.AdditionalProperties,
	}
}

// PostgreSQLLinkedServiceTypeProperties - PostgreSQL linked service properties.
type PostgreSQLLinkedServiceTypeProperties struct {
	// REQUIRED; The connection string.
	ConnectionString interface{} `json:"connectionString,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The Azure key vault secret reference of password in connection string.
	Password *AzureKeyVaultSecretReference `json:"password,omitempty"`
}

// PostgreSQLSource - A copy activity source for PostgreSQL databases.
type PostgreSQLSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Database query. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type PostgreSQLSource.
func (p *PostgreSQLSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     p.Type,
		SourceRetryCount:         p.SourceRetryCount,
		SourceRetryWait:          p.SourceRetryWait,
		MaxConcurrentConnections: p.MaxConcurrentConnections,
		DisableMetricsCollection: p.DisableMetricsCollection,
		AdditionalProperties:     p.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type PostgreSQLSource.
func (p *PostgreSQLSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             p.QueryTimeout,
		AdditionalColumns:        p.AdditionalColumns,
		Type:                     p.Type,
		SourceRetryCount:         p.SourceRetryCount,
		SourceRetryWait:          p.SourceRetryWait,
		MaxConcurrentConnections: p.MaxConcurrentConnections,
		DisableMetricsCollection: p.DisableMetricsCollection,
		AdditionalProperties:     p.AdditionalProperties,
	}
}

// PostgreSQLTableDataset - The PostgreSQL table dataset.
type PostgreSQLTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// PostgreSQL table dataset properties.
	TypeProperties *PostgreSQLTableDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type PostgreSQLTableDataset.
func (p *PostgreSQLTableDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 p.Type,
		Description:          p.Description,
		Structure:            p.Structure,
		Schema:               p.Schema,
		LinkedServiceName:    p.LinkedServiceName,
		Parameters:           p.Parameters,
		Annotations:          p.Annotations,
		Folder:               p.Folder,
		AdditionalProperties: p.AdditionalProperties,
	}
}

// PostgreSQLTableDatasetTypeProperties - PostgreSQL table dataset properties.
type PostgreSQLTableDatasetTypeProperties struct {
	// The PostgreSQL schema name. Type: string (or Expression with resultType string).
	Schema interface{} `json:"schema,omitempty"`

	// The PostgreSQL table name. Type: string (or Expression with resultType string).
	Table interface{} `json:"table,omitempty"`

	// This property will be retired. Please consider using schema + table properties instead.
	TableName interface{} `json:"tableName,omitempty"`
}

// PowerQuerySink - Power query sink.
type PowerQuerySink struct {
	// REQUIRED; Transformation name.
	Name *string `json:"name,omitempty"`

	// Dataset reference.
	Dataset *DatasetReference `json:"dataset,omitempty"`

	// Transformation description.
	Description *string `json:"description,omitempty"`

	// Flowlet Reference
	Flowlet *DataFlowReference `json:"flowlet,omitempty"`

	// Linked service reference.
	LinkedService *LinkedServiceReference `json:"linkedService,omitempty"`

	// Rejected data linked service reference.
	RejectedDataLinkedService *LinkedServiceReference `json:"rejectedDataLinkedService,omitempty"`

	// Schema linked service reference.
	SchemaLinkedService *LinkedServiceReference `json:"schemaLinkedService,omitempty"`

	// sink script.
	Script *string `json:"script,omitempty"`
}

// PowerQuerySinkMapping - Map Power Query mashup query to sink dataset(s).
type PowerQuerySinkMapping struct {
	// List of sinks mapped to Power Query mashup query.
	DataflowSinks []*PowerQuerySink `json:"dataflowSinks,omitempty"`

	// Name of the query in Power Query mashup document.
	QueryName *string `json:"queryName,omitempty"`
}

// PowerQuerySource - Power query source.
type PowerQuerySource struct {
	// REQUIRED; Transformation name.
	Name *string `json:"name,omitempty"`

	// Dataset reference.
	Dataset *DatasetReference `json:"dataset,omitempty"`

	// Transformation description.
	Description *string `json:"description,omitempty"`

	// Flowlet Reference
	Flowlet *DataFlowReference `json:"flowlet,omitempty"`

	// Linked service reference.
	LinkedService *LinkedServiceReference `json:"linkedService,omitempty"`

	// Schema linked service reference.
	SchemaLinkedService *LinkedServiceReference `json:"schemaLinkedService,omitempty"`

	// source script.
	Script *string `json:"script,omitempty"`
}

// PowerQueryTypeProperties - Power Query data flow type properties.
type PowerQueryTypeProperties struct {
	// Locale of the Power query mashup document.
	DocumentLocale *string `json:"documentLocale,omitempty"`

	// Power query mashup script.
	Script *string `json:"script,omitempty"`

	// List of sources in Power Query.
	Sources []*PowerQuerySource `json:"sources,omitempty"`
}

// PrestoDatasetTypeProperties - Presto Dataset Properties
type PrestoDatasetTypeProperties struct {
	// The schema name of the Presto. Type: string (or Expression with resultType string).
	Schema interface{} `json:"schema,omitempty"`

	// The table name of the Presto. Type: string (or Expression with resultType string).
	Table interface{} `json:"table,omitempty"`

	// This property will be retired. Please consider using schema + table properties instead.
	TableName interface{} `json:"tableName,omitempty"`
}

// PrestoLinkedService - Presto server linked service.
type PrestoLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Presto server linked service properties.
	TypeProperties *PrestoLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type PrestoLinkedService.
func (p *PrestoLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 p.Type,
		ConnectVia:           p.ConnectVia,
		Description:          p.Description,
		Parameters:           p.Parameters,
		Annotations:          p.Annotations,
		AdditionalProperties: p.AdditionalProperties,
	}
}

// PrestoLinkedServiceTypeProperties - Presto server linked service properties.
type PrestoLinkedServiceTypeProperties struct {
	// REQUIRED; The authentication mechanism used to connect to the Presto server.
	AuthenticationType *PrestoAuthenticationType `json:"authenticationType,omitempty"`

	// REQUIRED; The catalog context for all request against the server.
	Catalog interface{} `json:"catalog,omitempty"`

	// REQUIRED; The IP address or host name of the Presto server. (i.e. 192.168.222.160)
	Host interface{} `json:"host,omitempty"`

	// REQUIRED; The version of the Presto server. (i.e. 0.148-t)
	ServerVersion interface{} `json:"serverVersion,omitempty"`

	// Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over
	// SSL. The default value is false.
	AllowHostNameCNMismatch interface{} `json:"allowHostNameCNMismatch,omitempty"`

	// Specifies whether to allow self-signed certificates from the server. The default value is false.
	AllowSelfSignedServerCert interface{} `json:"allowSelfSignedServerCert,omitempty"`

	// Specifies whether the connections to the server are encrypted using SSL. The default value is false.
	EnableSSL interface{} `json:"enableSsl,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The password corresponding to the user name.
	Password SecretBaseClassification `json:"password,omitempty"`

	// The TCP port that the Presto server uses to listen for client connections. The default value is 8080.
	Port interface{} `json:"port,omitempty"`

	// The local time zone used by the connection. Valid values for this option are specified in the IANA Time Zone Database.
	// The default value is the system time zone.
	TimeZoneID interface{} `json:"timeZoneID,omitempty"`

	// The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This
	// property can only be set when using SSL on self-hosted IR. The default value
	// is the cacerts.pem file installed with the IR.
	TrustedCertPath interface{} `json:"trustedCertPath,omitempty"`

	// Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is
	// false.
	UseSystemTrustStore interface{} `json:"useSystemTrustStore,omitempty"`

	// The user name used to connect to the Presto server.
	Username interface{} `json:"username,omitempty"`
}

// PrestoObjectDataset - Presto server dataset.
type PrestoObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Properties specific to this dataset type.
	TypeProperties *PrestoDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type PrestoObjectDataset.
func (p *PrestoObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 p.Type,
		Description:          p.Description,
		Structure:            p.Structure,
		Schema:               p.Schema,
		LinkedServiceName:    p.LinkedServiceName,
		Parameters:           p.Parameters,
		Annotations:          p.Annotations,
		Folder:               p.Folder,
		AdditionalProperties: p.AdditionalProperties,
	}
}

// PrestoSource - A copy activity Presto server source.
type PrestoSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type PrestoSource.
func (p *PrestoSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     p.Type,
		SourceRetryCount:         p.SourceRetryCount,
		SourceRetryWait:          p.SourceRetryWait,
		MaxConcurrentConnections: p.MaxConcurrentConnections,
		DisableMetricsCollection: p.DisableMetricsCollection,
		AdditionalProperties:     p.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type PrestoSource.
func (p *PrestoSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             p.QueryTimeout,
		AdditionalColumns:        p.AdditionalColumns,
		Type:                     p.Type,
		SourceRetryCount:         p.SourceRetryCount,
		SourceRetryWait:          p.SourceRetryWait,
		MaxConcurrentConnections: p.MaxConcurrentConnections,
		DisableMetricsCollection: p.DisableMetricsCollection,
		AdditionalProperties:     p.AdditionalProperties,
	}
}

// PrivateEndPointConnectionsClientListByFactoryOptions contains the optional parameters for the PrivateEndPointConnectionsClient.ListByFactory
// method.
type PrivateEndPointConnectionsClientListByFactoryOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpoint - Private endpoint which a connection belongs to.
type PrivateEndpoint struct {
	// The resource Id for private endpoint
	ID *string `json:"id,omitempty"`
}

// PrivateEndpointConnectionClientCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionClient.CreateOrUpdate
// method.
type PrivateEndpointConnectionClientCreateOrUpdateOptions struct {
	// ETag of the private endpoint connection entity. Should only be specified for update, for which it should match existing
	// entity or can be * for unconditional update.
	IfMatch *string
}

// PrivateEndpointConnectionClientDeleteOptions contains the optional parameters for the PrivateEndpointConnectionClient.Delete
// method.
type PrivateEndpointConnectionClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionClientGetOptions contains the optional parameters for the PrivateEndpointConnectionClient.Get
// method.
type PrivateEndpointConnectionClientGetOptions struct {
	// ETag of the private endpoint connection entity. Should only be specified for get. If the ETag matches the existing entity
	// tag, or if * was provided, then no content will be returned.
	IfNoneMatch *string
}

// PrivateEndpointConnectionListResponse - A list of linked service resources.
type PrivateEndpointConnectionListResponse struct {
	// REQUIRED; List of Private Endpoint Connections.
	Value []*PrivateEndpointConnectionResource `json:"value,omitempty"`

	// The link to the next page of results, if any remaining results exist.
	NextLink *string `json:"nextLink,omitempty"`
}

// PrivateEndpointConnectionResource - Private Endpoint Connection ARM resource.
type PrivateEndpointConnectionResource struct {
	// Core resource properties
	Properties *RemotePrivateEndpointConnection `json:"properties,omitempty"`

	// READ-ONLY; Etag identifies change in the resource.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkConnectionApprovalRequest - A request to approve or reject a private endpoint connection
type PrivateLinkConnectionApprovalRequest struct {
	// The resource of private endpoint.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// The state of a private link connection
	PrivateLinkServiceConnectionState *PrivateLinkConnectionState `json:"privateLinkServiceConnectionState,omitempty"`
}

// PrivateLinkConnectionApprovalRequestResource - Private Endpoint Connection Approval ARM resource.
type PrivateLinkConnectionApprovalRequestResource struct {
	// Core resource properties
	Properties *PrivateLinkConnectionApprovalRequest `json:"properties,omitempty"`

	// READ-ONLY; Etag identifies change in the resource.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkConnectionState - The state of a private link connection
type PrivateLinkConnectionState struct {
	// ActionsRequired for a private link connection
	ActionsRequired *string `json:"actionsRequired,omitempty"`

	// Description of a private link connection
	Description *string `json:"description,omitempty"`

	// Status of a private link connection
	Status *string `json:"status,omitempty"`
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Core resource properties
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Etag identifies change in the resource.
	Etag *string `json:"etag,omitempty" azure:"ro"`

	// READ-ONLY; The resource identifier.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceProperties - Properties of a private link resource
type PrivateLinkResourceProperties struct {
	// READ-ONLY; GroupId of a private link resource
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; RequiredMembers of a private link resource
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`

	// READ-ONLY; RequiredZoneNames of a private link resource
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty" azure:"ro"`
}

// PrivateLinkResourcesClientGetOptions contains the optional parameters for the PrivateLinkResourcesClient.Get method.
type PrivateLinkResourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesWrapper - Wrapper for a collection of private link resources
type PrivateLinkResourcesWrapper struct {
	// REQUIRED
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// PurviewConfiguration - Purview configuration.
type PurviewConfiguration struct {
	// Purview resource id.
	PurviewResourceID *string `json:"purviewResourceId,omitempty"`
}

// QueryDataFlowDebugSessionsResponse - A list of active debug sessions.
type QueryDataFlowDebugSessionsResponse struct {
	// The link to the next page of results, if any remaining results exist.
	NextLink *string `json:"nextLink,omitempty"`

	// Array with all active debug sessions.
	Value []*DataFlowDebugSessionInfo `json:"value,omitempty"`
}

// QuickBooksLinkedService - QuickBooks server linked service.
type QuickBooksLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; QuickBooks server linked service properties.
	TypeProperties *QuickBooksLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type QuickBooksLinkedService.
func (q *QuickBooksLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 q.Type,
		ConnectVia:           q.ConnectVia,
		Description:          q.Description,
		Parameters:           q.Parameters,
		Annotations:          q.Annotations,
		AdditionalProperties: q.AdditionalProperties,
	}
}

// QuickBooksLinkedServiceTypeProperties - QuickBooks server linked service properties.
type QuickBooksLinkedServiceTypeProperties struct {
	// The access token for OAuth 1.0 authentication.
	AccessToken SecretBaseClassification `json:"accessToken,omitempty"`

	// The access token secret for OAuth 1.0 authentication.
	AccessTokenSecret SecretBaseClassification `json:"accessTokenSecret,omitempty"`

	// The company ID of the QuickBooks company to authorize.
	CompanyID interface{} `json:"companyId,omitempty"`

	// Properties used to connect to QuickBooks. It is mutually exclusive with any other properties in the linked service. Type:
	// object.
	ConnectionProperties interface{} `json:"connectionProperties,omitempty"`

	// The consumer key for OAuth 1.0 authentication.
	ConsumerKey interface{} `json:"consumerKey,omitempty"`

	// The consumer secret for OAuth 1.0 authentication.
	ConsumerSecret SecretBaseClassification `json:"consumerSecret,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The endpoint of the QuickBooks server. (i.e. quickbooks.api.intuit.com)
	Endpoint interface{} `json:"endpoint,omitempty"`

	// Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true.
	UseEncryptedEndpoints interface{} `json:"useEncryptedEndpoints,omitempty"`
}

// QuickBooksObjectDataset - QuickBooks server dataset.
type QuickBooksObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type QuickBooksObjectDataset.
func (q *QuickBooksObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 q.Type,
		Description:          q.Description,
		Structure:            q.Structure,
		Schema:               q.Schema,
		LinkedServiceName:    q.LinkedServiceName,
		Parameters:           q.Parameters,
		Annotations:          q.Annotations,
		Folder:               q.Folder,
		AdditionalProperties: q.AdditionalProperties,
	}
}

// QuickBooksSource - A copy activity QuickBooks server source.
type QuickBooksSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type QuickBooksSource.
func (q *QuickBooksSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     q.Type,
		SourceRetryCount:         q.SourceRetryCount,
		SourceRetryWait:          q.SourceRetryWait,
		MaxConcurrentConnections: q.MaxConcurrentConnections,
		DisableMetricsCollection: q.DisableMetricsCollection,
		AdditionalProperties:     q.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type QuickBooksSource.
func (q *QuickBooksSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             q.QueryTimeout,
		AdditionalColumns:        q.AdditionalColumns,
		Type:                     q.Type,
		SourceRetryCount:         q.SourceRetryCount,
		SourceRetryWait:          q.SourceRetryWait,
		MaxConcurrentConnections: q.MaxConcurrentConnections,
		DisableMetricsCollection: q.DisableMetricsCollection,
		AdditionalProperties:     q.AdditionalProperties,
	}
}

// QuickbaseLinkedService - Linked service for Quickbase.
type QuickbaseLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Quickbase linked service properties.
	TypeProperties *QuickbaseLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type QuickbaseLinkedService.
func (q *QuickbaseLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 q.Type,
		ConnectVia:           q.ConnectVia,
		Description:          q.Description,
		Parameters:           q.Parameters,
		Annotations:          q.Annotations,
		AdditionalProperties: q.AdditionalProperties,
	}
}

// QuickbaseLinkedServiceTypeProperties - Quickbase linked service type properties.
type QuickbaseLinkedServiceTypeProperties struct {
	// REQUIRED; The url to connect Quickbase source. Type: string (or Expression with resultType string).
	URL interface{} `json:"url,omitempty"`

	// REQUIRED; The user token for the Quickbase source.
	UserToken SecretBaseClassification `json:"userToken,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`
}

// RecurrenceSchedule - The recurrence schedule.
type RecurrenceSchedule struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// The hours.
	Hours []*int32 `json:"hours,omitempty"`

	// The minutes.
	Minutes []*int32 `json:"minutes,omitempty"`

	// The month days.
	MonthDays []*int32 `json:"monthDays,omitempty"`

	// The monthly occurrences.
	MonthlyOccurrences []*RecurrenceScheduleOccurrence `json:"monthlyOccurrences,omitempty"`

	// The days of the week.
	WeekDays []*DaysOfWeek `json:"weekDays,omitempty"`
}

// RecurrenceScheduleOccurrence - The recurrence schedule occurrence.
type RecurrenceScheduleOccurrence struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// The day of the week.
	Day *DayOfWeek `json:"day,omitempty"`

	// The occurrence.
	Occurrence *int32 `json:"occurrence,omitempty"`
}

// RedirectIncompatibleRowSettings - Redirect incompatible row settings
type RedirectIncompatibleRowSettings struct {
	// REQUIRED; Name of the Azure Storage, Storage SAS, or Azure Data Lake Store linked service used for redirecting incompatible
	// row. Must be specified if redirectIncompatibleRowSettings is specified. Type: string
	// (or Expression with resultType string).
	LinkedServiceName interface{} `json:"linkedServiceName,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// The path for storing the redirect incompatible row data. Type: string (or Expression with resultType string).
	Path interface{} `json:"path,omitempty"`
}

// RedshiftUnloadSettings - The Amazon S3 settings needed for the interim Amazon S3 when copying from Amazon Redshift with
// unload. With this, data from Amazon Redshift source will be unloaded into S3 first and then copied into
// the targeted sink from the interim S3.
type RedshiftUnloadSettings struct {
	// REQUIRED; The bucket of the interim Amazon S3 which will be used to store the unloaded data from Amazon Redshift source.
	// The bucket must be in the same region as the Amazon Redshift source. Type: string (or
	// Expression with resultType string).
	BucketName interface{} `json:"bucketName,omitempty"`

	// REQUIRED; The name of the Amazon S3 linked service which will be used for the unload operation when copying from the Amazon
	// Redshift source.
	S3LinkedServiceName *LinkedServiceReference `json:"s3LinkedServiceName,omitempty"`
}

// RelationalSource - A copy activity source for various relational databases.
type RelationalSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Database query. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type RelationalSource.
func (r *RelationalSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     r.Type,
		SourceRetryCount:         r.SourceRetryCount,
		SourceRetryWait:          r.SourceRetryWait,
		MaxConcurrentConnections: r.MaxConcurrentConnections,
		DisableMetricsCollection: r.DisableMetricsCollection,
		AdditionalProperties:     r.AdditionalProperties,
	}
}

// RelationalTableDataset - The relational table dataset.
type RelationalTableDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Relational table dataset properties.
	TypeProperties *RelationalTableDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type RelationalTableDataset.
func (r *RelationalTableDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 r.Type,
		Description:          r.Description,
		Structure:            r.Structure,
		Schema:               r.Schema,
		LinkedServiceName:    r.LinkedServiceName,
		Parameters:           r.Parameters,
		Annotations:          r.Annotations,
		Folder:               r.Folder,
		AdditionalProperties: r.AdditionalProperties,
	}
}

// RelationalTableDatasetTypeProperties - Relational table dataset properties.
type RelationalTableDatasetTypeProperties struct {
	// The relational table name. Type: string (or Expression with resultType string).
	TableName interface{} `json:"tableName,omitempty"`
}

// RemotePrivateEndpointConnection - A remote private endpoint connection
type RemotePrivateEndpointConnection struct {
	// PrivateEndpoint of a remote private endpoint connection
	PrivateEndpoint *ArmIDWrapper `json:"privateEndpoint,omitempty"`

	// The state of a private link connection
	PrivateLinkServiceConnectionState *PrivateLinkConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// READ-ONLY
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// RerunTumblingWindowTrigger - Trigger that schedules pipeline reruns for all fixed time interval windows from a requested
// start time to requested end time.
type RerunTumblingWindowTrigger struct {
	// REQUIRED; Trigger type.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Rerun Trigger properties.
	TypeProperties *RerunTumblingWindowTriggerTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the trigger.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Trigger description.
	Description *string `json:"description,omitempty"`

	// READ-ONLY; Indicates if trigger is running or not. Updated when Start/Stop APIs are called on the Trigger.
	RuntimeState *TriggerRuntimeState `json:"runtimeState,omitempty" azure:"ro"`
}

// GetTrigger implements the TriggerClassification interface for type RerunTumblingWindowTrigger.
func (r *RerunTumblingWindowTrigger) GetTrigger() *Trigger {
	return &Trigger{
		Type:                 r.Type,
		Description:          r.Description,
		RuntimeState:         r.RuntimeState,
		Annotations:          r.Annotations,
		AdditionalProperties: r.AdditionalProperties,
	}
}

// RerunTumblingWindowTriggerTypeProperties - Rerun Trigger properties.
type RerunTumblingWindowTriggerTypeProperties struct {
	// REQUIRED; The parent trigger reference.
	ParentTrigger interface{} `json:"parentTrigger,omitempty"`

	// REQUIRED; The end time for the time period for which restatement is initiated. Only UTC time is currently supported.
	RequestedEndTime *time.Time `json:"requestedEndTime,omitempty"`

	// REQUIRED; The start time for the time period for which restatement is initiated. Only UTC time is currently supported.
	RequestedStartTime *time.Time `json:"requestedStartTime,omitempty"`

	// REQUIRED; The max number of parallel time windows (ready for execution) for which a rerun is triggered.
	RerunConcurrency *int32 `json:"rerunConcurrency,omitempty"`
}

// ResponsysLinkedService - Responsys linked service.
type ResponsysLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Responsys linked service properties.
	TypeProperties *ResponsysLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type ResponsysLinkedService.
func (r *ResponsysLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 r.Type,
		ConnectVia:           r.ConnectVia,
		Description:          r.Description,
		Parameters:           r.Parameters,
		Annotations:          r.Annotations,
		AdditionalProperties: r.AdditionalProperties,
	}
}

// ResponsysLinkedServiceTypeProperties - Responsys linked service properties.
type ResponsysLinkedServiceTypeProperties struct {
	// REQUIRED; The client ID associated with the Responsys application. Type: string (or Expression with resultType string).
	ClientID interface{} `json:"clientId,omitempty"`

	// REQUIRED; The endpoint of the Responsys server.
	Endpoint interface{} `json:"endpoint,omitempty"`

	// The client secret associated with the Responsys application. Type: string (or Expression with resultType string).
	ClientSecret SecretBaseClassification `json:"clientSecret,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// Specifies whether the data source endpoints are encrypted using HTTPS. The default value is true. Type: boolean (or Expression
	// with resultType boolean).
	UseEncryptedEndpoints interface{} `json:"useEncryptedEndpoints,omitempty"`

	// Specifies whether to require the host name in the server's certificate to match the host name of the server when connecting
	// over SSL. The default value is true. Type: boolean (or Expression with
	// resultType boolean).
	UseHostVerification interface{} `json:"useHostVerification,omitempty"`

	// Specifies whether to verify the identity of the server when connecting over SSL. The default value is true. Type: boolean
	// (or Expression with resultType boolean).
	UsePeerVerification interface{} `json:"usePeerVerification,omitempty"`
}

// ResponsysObjectDataset - Responsys dataset.
type ResponsysObjectDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Properties specific to this dataset type.
	TypeProperties *GenericDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type ResponsysObjectDataset.
func (r *ResponsysObjectDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 r.Type,
		Description:          r.Description,
		Structure:            r.Structure,
		Schema:               r.Schema,
		LinkedServiceName:    r.LinkedServiceName,
		Parameters:           r.Parameters,
		Annotations:          r.Annotations,
		Folder:               r.Folder,
		AdditionalProperties: r.AdditionalProperties,
	}
}

// ResponsysSource - A copy activity Responsys source.
type ResponsysSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// A query to retrieve data from source. Type: string (or Expression with resultType string).
	Query interface{} `json:"query,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type ResponsysSource.
func (r *ResponsysSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     r.Type,
		SourceRetryCount:         r.SourceRetryCount,
		SourceRetryWait:          r.SourceRetryWait,
		MaxConcurrentConnections: r.MaxConcurrentConnections,
		DisableMetricsCollection: r.DisableMetricsCollection,
		AdditionalProperties:     r.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type ResponsysSource.
func (r *ResponsysSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             r.QueryTimeout,
		AdditionalColumns:        r.AdditionalColumns,
		Type:                     r.Type,
		SourceRetryCount:         r.SourceRetryCount,
		SourceRetryWait:          r.SourceRetryWait,
		MaxConcurrentConnections: r.MaxConcurrentConnections,
		DisableMetricsCollection: r.DisableMetricsCollection,
		AdditionalProperties:     r.AdditionalProperties,
	}
}

// RestResourceDataset - A Rest service dataset.
type RestResourceDataset struct {
	// REQUIRED; Linked service reference.
	LinkedServiceName *LinkedServiceReference `json:"linkedServiceName,omitempty"`

	// REQUIRED; Type of dataset.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the Dataset.
	Annotations []interface{} `json:"annotations,omitempty"`

	// Dataset description.
	Description *string `json:"description,omitempty"`

	// The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
	Folder *DatasetFolder `json:"folder,omitempty"`

	// Parameters for dataset.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`

	// Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType:
	// DatasetSchemaDataElement.
	Schema interface{} `json:"schema,omitempty"`

	// Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
	Structure interface{} `json:"structure,omitempty"`

	// Properties specific to this dataset type.
	TypeProperties *RestResourceDatasetTypeProperties `json:"typeProperties,omitempty"`
}

// GetDataset implements the DatasetClassification interface for type RestResourceDataset.
func (r *RestResourceDataset) GetDataset() *Dataset {
	return &Dataset{
		Type:                 r.Type,
		Description:          r.Description,
		Structure:            r.Structure,
		Schema:               r.Schema,
		LinkedServiceName:    r.LinkedServiceName,
		Parameters:           r.Parameters,
		Annotations:          r.Annotations,
		Folder:               r.Folder,
		AdditionalProperties: r.AdditionalProperties,
	}
}

// RestResourceDatasetTypeProperties - Properties specific to this dataset type.
type RestResourceDatasetTypeProperties struct {
	// The additional HTTP headers in the request to the RESTful API. Type: string (or Expression with resultType string).
	AdditionalHeaders interface{} `json:"additionalHeaders,omitempty"`

	// The pagination rules to compose next page requests. Type: string (or Expression with resultType string).
	PaginationRules interface{} `json:"paginationRules,omitempty"`

	// The relative URL to the resource that the RESTful API provides. Type: string (or Expression with resultType string).
	RelativeURL interface{} `json:"relativeUrl,omitempty"`

	// The HTTP request body to the RESTful API if requestMethod is POST. Type: string (or Expression with resultType string).
	RequestBody interface{} `json:"requestBody,omitempty"`

	// The HTTP method used to call the RESTful API. The default is GET. Type: string (or Expression with resultType string).
	RequestMethod interface{} `json:"requestMethod,omitempty"`
}

// RestServiceLinkedService - Rest Service linked service.
type RestServiceLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; Rest Service linked service properties.
	TypeProperties *RestServiceLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type RestServiceLinkedService.
func (r *RestServiceLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 r.Type,
		ConnectVia:           r.ConnectVia,
		Description:          r.Description,
		Parameters:           r.Parameters,
		Annotations:          r.Annotations,
		AdditionalProperties: r.AdditionalProperties,
	}
}

// RestServiceLinkedServiceTypeProperties - Rest Service linked service properties.
type RestServiceLinkedServiceTypeProperties struct {
	// REQUIRED; Type of authentication used to connect to the REST service.
	AuthenticationType *RestServiceAuthenticationType `json:"authenticationType,omitempty"`

	// REQUIRED; The base URL of the REST service.
	URL interface{} `json:"url,omitempty"`

	// The resource you are requesting authorization to use.
	AADResourceID interface{} `json:"aadResourceId,omitempty"`

	// The additional HTTP headers in the request to RESTful API used for authorization. Type: object (or Expression with resultType
	// object).
	AuthHeaders interface{} `json:"authHeaders,omitempty"`

	// Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment,
	// AzureGermany. Default value is the data factory regions’ cloud type. Type:
	// string (or Expression with resultType string).
	AzureCloudType interface{} `json:"azureCloudType,omitempty"`

	// The client ID associated with your application. Type: string (or Expression with resultType string).
	ClientID interface{} `json:"clientId,omitempty"`

	// The client secret associated with your application.
	ClientSecret SecretBaseClassification `json:"clientSecret,omitempty"`

	// The credential reference containing authentication information.
	Credential *CredentialReference `json:"credential,omitempty"`

	// Whether to validate server side SSL certificate when connecting to the endpoint.The default value is true. Type: boolean
	// (or Expression with resultType boolean).
	EnableServerCertificateValidation interface{} `json:"enableServerCertificateValidation,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The password used in Basic authentication type.
	Password SecretBaseClassification `json:"password,omitempty"`

	// The target service or resource to which the access will be requested. Type: string (or Expression with resultType string).
	Resource interface{} `json:"resource,omitempty"`

	// The scope of the access required. It describes what kind of access will be requested. Type: string (or Expression with
	// resultType string).
	Scope interface{} `json:"scope,omitempty"`

	// The application's client ID used in AadServicePrincipal authentication type.
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`

	// The application's key used in AadServicePrincipal authentication type.
	ServicePrincipalKey SecretBaseClassification `json:"servicePrincipalKey,omitempty"`

	// The tenant information (domain name or tenant ID) used in AadServicePrincipal authentication type under which your application
	// resides.
	Tenant interface{} `json:"tenant,omitempty"`

	// The token endpoint of the authorization server to acquire access token. Type: string (or Expression with resultType string).
	TokenEndpoint interface{} `json:"tokenEndpoint,omitempty"`

	// The user name used in Basic authentication type.
	UserName interface{} `json:"userName,omitempty"`
}

// RestSink - A copy activity Rest service Sink.
type RestSink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// The additional HTTP headers in the request to the RESTful API. Type: string (or Expression with resultType string).
	AdditionalHeaders interface{} `json:"additionalHeaders,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// Http Compression Type to Send data in compressed format with Optimal Compression Level, Default is None. And The Only Supported
	// option is Gzip.
	HTTPCompressionType interface{} `json:"httpCompressionType,omitempty"`

	// The timeout (TimeSpan) to get an HTTP response. It is the timeout to get a response, not the timeout to read response data.
	// Default value: 00:01:40. Type: string (or Expression with resultType
	// string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	HTTPRequestTimeout interface{} `json:"httpRequestTimeout,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// The time to await before sending next request, in milliseconds
	RequestInterval interface{} `json:"requestInterval,omitempty"`

	// The HTTP method used to call the RESTful API. The default is POST. Type: string (or Expression with resultType string).
	RequestMethod interface{} `json:"requestMethod,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type RestSink.
func (r *RestSink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     r.Type,
		WriteBatchSize:           r.WriteBatchSize,
		WriteBatchTimeout:        r.WriteBatchTimeout,
		SinkRetryCount:           r.SinkRetryCount,
		SinkRetryWait:            r.SinkRetryWait,
		MaxConcurrentConnections: r.MaxConcurrentConnections,
		DisableMetricsCollection: r.DisableMetricsCollection,
		AdditionalProperties:     r.AdditionalProperties,
	}
}

// RestSource - A copy activity Rest service source.
type RestSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// The additional HTTP headers in the request to the RESTful API. Type: string (or Expression with resultType string).
	AdditionalHeaders interface{} `json:"additionalHeaders,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The timeout (TimeSpan) to get an HTTP response. It is the timeout to get a response, not the timeout to read response data.
	// Default value: 00:01:40. Type: string (or Expression with resultType
	// string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	HTTPRequestTimeout interface{} `json:"httpRequestTimeout,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// The pagination rules to compose next page requests. Type: string (or Expression with resultType string).
	PaginationRules interface{} `json:"paginationRules,omitempty"`

	// The HTTP request body to the RESTful API if requestMethod is POST. Type: string (or Expression with resultType string).
	RequestBody interface{} `json:"requestBody,omitempty"`

	// The time to await before sending next page request.
	RequestInterval interface{} `json:"requestInterval,omitempty"`

	// The HTTP method used to call the RESTful API. The default is GET. Type: string (or Expression with resultType string).
	RequestMethod interface{} `json:"requestMethod,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type RestSource.
func (r *RestSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     r.Type,
		SourceRetryCount:         r.SourceRetryCount,
		SourceRetryWait:          r.SourceRetryWait,
		MaxConcurrentConnections: r.MaxConcurrentConnections,
		DisableMetricsCollection: r.DisableMetricsCollection,
		AdditionalProperties:     r.AdditionalProperties,
	}
}

// RetryPolicy - Execution policy for an activity.
type RetryPolicy struct {
	// Maximum ordinary retry attempts. Default is 0. Type: integer (or Expression with resultType integer), minimum: 0.
	Count interface{} `json:"count,omitempty"`

	// Interval between retries in seconds. Default is 30.
	IntervalInSeconds *int32 `json:"intervalInSeconds,omitempty"`
}

// RunFilterParameters - Query parameters for listing runs.
type RunFilterParameters struct {
	// REQUIRED; The time at or after which the run event was updated in 'ISO 8601' format.
	LastUpdatedAfter *time.Time `json:"lastUpdatedAfter,omitempty"`

	// REQUIRED; The time at or before which the run event was updated in 'ISO 8601' format.
	LastUpdatedBefore *time.Time `json:"lastUpdatedBefore,omitempty"`

	// The continuation token for getting the next page of results. Null for first page.
	ContinuationToken *string `json:"continuationToken,omitempty"`

	// List of filters.
	Filters []*RunQueryFilter `json:"filters,omitempty"`

	// List of OrderBy option.
	OrderBy []*RunQueryOrderBy `json:"orderBy,omitempty"`
}

// RunQueryFilter - Query filter option for listing runs.
type RunQueryFilter struct {
	// REQUIRED; Parameter name to be used for filter. The allowed operands to query pipeline runs are PipelineName, RunStart,
	// RunEnd and Status; to query activity runs are ActivityName, ActivityRunStart,
	// ActivityRunEnd, ActivityType and Status, and to query trigger runs are TriggerName, TriggerRunTimestamp and Status.
	Operand *RunQueryFilterOperand `json:"operand,omitempty"`

	// REQUIRED; Operator to be used for filter.
	Operator *RunQueryFilterOperator `json:"operator,omitempty"`

	// REQUIRED; List of filter values.
	Values []*string `json:"values,omitempty"`
}

// RunQueryOrderBy - An object to provide order by options for listing runs.
type RunQueryOrderBy struct {
	// REQUIRED; Sorting order of the parameter.
	Order *RunQueryOrder `json:"order,omitempty"`

	// REQUIRED; Parameter name to be used for order by. The allowed parameters to order by for pipeline runs are PipelineName,
	// RunStart, RunEnd and Status; for activity runs are ActivityName, ActivityRunStart,
	// ActivityRunEnd and Status; for trigger runs are TriggerName, TriggerRunTimestamp and Status.
	OrderBy *RunQueryOrderByField `json:"orderBy,omitempty"`
}

// SQLAlwaysEncryptedProperties - Sql always encrypted properties.
type SQLAlwaysEncryptedProperties struct {
	// REQUIRED; Sql always encrypted AKV authentication type. Type: string (or Expression with resultType string).
	AlwaysEncryptedAkvAuthType *SQLAlwaysEncryptedAkvAuthType `json:"alwaysEncryptedAkvAuthType,omitempty"`

	// The credential reference containing authentication information.
	Credential *CredentialReference `json:"credential,omitempty"`

	// The client ID of the application in Azure Active Directory used for Azure Key Vault authentication. Type: string (or Expression
	// with resultType string).
	ServicePrincipalID interface{} `json:"servicePrincipalId,omitempty"`

	// The key of the service principal used to authenticate against Azure Key Vault.
	ServicePrincipalKey SecretBaseClassification `json:"servicePrincipalKey,omitempty"`
}

// SQLDWSink - A copy activity SQL Data Warehouse sink.
type SQLDWSink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Indicates to use Copy Command to copy data into SQL Data Warehouse. Type: boolean (or Expression with resultType boolean).
	AllowCopyCommand interface{} `json:"allowCopyCommand,omitempty"`

	// Indicates to use PolyBase to copy data into SQL Data Warehouse when applicable. Type: boolean (or Expression with resultType
	// boolean).
	AllowPolyBase interface{} `json:"allowPolyBase,omitempty"`

	// Specifies Copy Command related settings when allowCopyCommand is true.
	CopyCommandSettings *DWCopyCommandSettings `json:"copyCommandSettings,omitempty"`

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// Specifies PolyBase-related settings when allowPolyBase is true.
	PolyBaseSettings *PolybaseSettings `json:"polyBaseSettings,omitempty"`

	// SQL pre-copy script. Type: string (or Expression with resultType string).
	PreCopyScript interface{} `json:"preCopyScript,omitempty"`

	// Whether to use table lock during bulk copy. Type: boolean (or Expression with resultType boolean).
	SQLWriterUseTableLock interface{} `json:"sqlWriterUseTableLock,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// The option to handle sink table, such as autoCreate. For now only 'autoCreate' value is supported. Type: string (or Expression
	// with resultType string).
	TableOption interface{} `json:"tableOption,omitempty"`

	// SQL DW upsert settings.
	UpsertSettings *SQLDWUpsertSettings `json:"upsertSettings,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`

	// Write behavior when copying data into azure SQL DW. Type: SqlDWWriteBehaviorEnum (or Expression with resultType SqlDWWriteBehaviorEnum)
	WriteBehavior interface{} `json:"writeBehavior,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type SQLDWSink.
func (s *SQLDWSink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     s.Type,
		WriteBatchSize:           s.WriteBatchSize,
		WriteBatchTimeout:        s.WriteBatchTimeout,
		SinkRetryCount:           s.SinkRetryCount,
		SinkRetryWait:            s.SinkRetryWait,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		DisableMetricsCollection: s.DisableMetricsCollection,
		AdditionalProperties:     s.AdditionalProperties,
	}
}

// SQLDWSource - A copy activity SQL Data Warehouse source.
type SQLDWSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// The partition mechanism that will be used for Sql read in parallel. Possible values include: "None", "PhysicalPartitionsOfTable",
	// "DynamicRange".
	PartitionOption interface{} `json:"partitionOption,omitempty"`

	// The settings that will be leveraged for Sql source partitioning.
	PartitionSettings *SQLPartitionSettings `json:"partitionSettings,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// SQL Data Warehouse reader query. Type: string (or Expression with resultType string).
	SQLReaderQuery interface{} `json:"sqlReaderQuery,omitempty"`

	// Name of the stored procedure for a SQL Data Warehouse source. This cannot be used at the same time as SqlReaderQuery. Type:
	// string (or Expression with resultType string).
	SQLReaderStoredProcedureName interface{} `json:"sqlReaderStoredProcedureName,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`

	// Value and type setting for stored procedure parameters. Example: "{Parameter1: {value: "1", type: "int"}}". Type: object
	// (or Expression with resultType object), itemType: StoredProcedureParameter.
	StoredProcedureParameters interface{} `json:"storedProcedureParameters,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type SQLDWSource.
func (s *SQLDWSource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     s.Type,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		DisableMetricsCollection: s.DisableMetricsCollection,
		AdditionalProperties:     s.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type SQLDWSource.
func (s *SQLDWSource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             s.QueryTimeout,
		AdditionalColumns:        s.AdditionalColumns,
		Type:                     s.Type,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		DisableMetricsCollection: s.DisableMetricsCollection,
		AdditionalProperties:     s.AdditionalProperties,
	}
}

// SQLDWUpsertSettings - Sql DW upsert option settings
type SQLDWUpsertSettings struct {
	// Schema name for interim table. Type: string (or Expression with resultType string).
	InterimSchemaName interface{} `json:"interimSchemaName,omitempty"`

	// Key column names for unique row identification. Type: array of strings (or Expression with resultType array of strings).
	Keys interface{} `json:"keys,omitempty"`
}

// SQLMISink - A copy activity Azure SQL Managed Instance sink.
type SQLMISink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// SQL pre-copy script. Type: string (or Expression with resultType string).
	PreCopyScript interface{} `json:"preCopyScript,omitempty"`

	// SQL writer stored procedure name. Type: string (or Expression with resultType string).
	SQLWriterStoredProcedureName interface{} `json:"sqlWriterStoredProcedureName,omitempty"`

	// SQL writer table type. Type: string (or Expression with resultType string).
	SQLWriterTableType interface{} `json:"sqlWriterTableType,omitempty"`

	// Whether to use table lock during bulk copy. Type: boolean (or Expression with resultType boolean).
	SQLWriterUseTableLock interface{} `json:"sqlWriterUseTableLock,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// SQL stored procedure parameters.
	StoredProcedureParameters interface{} `json:"storedProcedureParameters,omitempty"`

	// The stored procedure parameter name of the table type. Type: string (or Expression with resultType string).
	StoredProcedureTableTypeParameterName interface{} `json:"storedProcedureTableTypeParameterName,omitempty"`

	// The option to handle sink table, such as autoCreate. For now only 'autoCreate' value is supported. Type: string (or Expression
	// with resultType string).
	TableOption interface{} `json:"tableOption,omitempty"`

	// SQL upsert settings.
	UpsertSettings *SQLUpsertSettings `json:"upsertSettings,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`

	// White behavior when copying data into azure SQL MI. Type: SqlWriteBehaviorEnum (or Expression with resultType SqlWriteBehaviorEnum)
	WriteBehavior interface{} `json:"writeBehavior,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type SQLMISink.
func (s *SQLMISink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     s.Type,
		WriteBatchSize:           s.WriteBatchSize,
		WriteBatchTimeout:        s.WriteBatchTimeout,
		SinkRetryCount:           s.SinkRetryCount,
		SinkRetryWait:            s.SinkRetryWait,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		DisableMetricsCollection: s.DisableMetricsCollection,
		AdditionalProperties:     s.AdditionalProperties,
	}
}

// SQLMISource - A copy activity Azure SQL Managed Instance source.
type SQLMISource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	AdditionalColumns interface{} `json:"additionalColumns,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// The partition mechanism that will be used for Sql read in parallel. Possible values include: "None", "PhysicalPartitionsOfTable",
	// "DynamicRange".
	PartitionOption interface{} `json:"partitionOption,omitempty"`

	// The settings that will be leveraged for Sql source partitioning.
	PartitionSettings *SQLPartitionSettings `json:"partitionSettings,omitempty"`

	// Which additional types to produce.
	ProduceAdditionalTypes interface{} `json:"produceAdditionalTypes,omitempty"`

	// Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	QueryTimeout interface{} `json:"queryTimeout,omitempty"`

	// SQL reader query. Type: string (or Expression with resultType string).
	SQLReaderQuery interface{} `json:"sqlReaderQuery,omitempty"`

	// Name of the stored procedure for a Azure SQL Managed Instance source. This cannot be used at the same time as SqlReaderQuery.
	// Type: string (or Expression with resultType string).
	SQLReaderStoredProcedureName interface{} `json:"sqlReaderStoredProcedureName,omitempty"`

	// Source retry count. Type: integer (or Expression with resultType integer).
	SourceRetryCount interface{} `json:"sourceRetryCount,omitempty"`

	// Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SourceRetryWait interface{} `json:"sourceRetryWait,omitempty"`

	// Value and type setting for stored procedure parameters. Example: "{Parameter1: {value: "1", type: "int"}}".
	StoredProcedureParameters interface{} `json:"storedProcedureParameters,omitempty"`
}

// GetCopySource implements the CopySourceClassification interface for type SQLMISource.
func (s *SQLMISource) GetCopySource() *CopySource {
	return &CopySource{
		Type:                     s.Type,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		DisableMetricsCollection: s.DisableMetricsCollection,
		AdditionalProperties:     s.AdditionalProperties,
	}
}

// GetTabularSource implements the TabularSourceClassification interface for type SQLMISource.
func (s *SQLMISource) GetTabularSource() *TabularSource {
	return &TabularSource{
		QueryTimeout:             s.QueryTimeout,
		AdditionalColumns:        s.AdditionalColumns,
		Type:                     s.Type,
		SourceRetryCount:         s.SourceRetryCount,
		SourceRetryWait:          s.SourceRetryWait,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		DisableMetricsCollection: s.DisableMetricsCollection,
		AdditionalProperties:     s.AdditionalProperties,
	}
}

// SQLPartitionSettings - The settings that will be leveraged for Sql source partitioning.
type SQLPartitionSettings struct {
	// The name of the column in integer or datetime type that will be used for proceeding partitioning. If not specified, the
	// primary key of the table is auto-detected and used as the partition column.
	// Type: string (or Expression with resultType string).
	PartitionColumnName interface{} `json:"partitionColumnName,omitempty"`

	// The minimum value of the partition column for partition range splitting. This value is used to decide the partition stride,
	// not for filtering the rows in table. All rows in the table or query result
	// will be partitioned and copied. Type: string (or Expression with resultType string).
	PartitionLowerBound interface{} `json:"partitionLowerBound,omitempty"`

	// The maximum value of the partition column for partition range splitting. This value is used to decide the partition stride,
	// not for filtering the rows in table. All rows in the table or query result
	// will be partitioned and copied. Type: string (or Expression with resultType string).
	PartitionUpperBound interface{} `json:"partitionUpperBound,omitempty"`
}

// SQLServerLinkedService - SQL Server linked service.
type SQLServerLinkedService struct {
	// REQUIRED; Type of linked service.
	Type *string `json:"type,omitempty"`

	// REQUIRED; SQL Server linked service properties.
	TypeProperties *SQLServerLinkedServiceTypeProperties `json:"typeProperties,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// List of tags that can be used for describing the linked service.
	Annotations []interface{} `json:"annotations,omitempty"`

	// The integration runtime reference.
	ConnectVia *IntegrationRuntimeReference `json:"connectVia,omitempty"`

	// Linked service description.
	Description *string `json:"description,omitempty"`

	// Parameters for linked service.
	Parameters map[string]*ParameterSpecification `json:"parameters,omitempty"`
}

// GetLinkedService implements the LinkedServiceClassification interface for type SQLServerLinkedService.
func (s *SQLServerLinkedService) GetLinkedService() *LinkedService {
	return &LinkedService{
		Type:                 s.Type,
		ConnectVia:           s.ConnectVia,
		Description:          s.Description,
		Parameters:           s.Parameters,
		Annotations:          s.Annotations,
		AdditionalProperties: s.AdditionalProperties,
	}
}

// SQLServerLinkedServiceTypeProperties - SQL Server linked service properties.
type SQLServerLinkedServiceTypeProperties struct {
	// REQUIRED; The connection string. Type: string, SecureString or AzureKeyVaultSecretReference.
	ConnectionString interface{} `json:"connectionString,omitempty"`

	// Sql always encrypted properties.
	AlwaysEncryptedSettings *SQLAlwaysEncryptedProperties `json:"alwaysEncryptedSettings,omitempty"`

	// The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager.
	// Type: string (or Expression with resultType string).
	EncryptedCredential interface{} `json:"encryptedCredential,omitempty"`

	// The on-premises Windows authentication password.
	Password SecretBaseClassification `json:"password,omitempty"`

	// The on-premises Windows authentication user name. Type: string (or Expression with resultType string).
	UserName interface{} `json:"userName,omitempty"`
}

// SQLServerSink - A copy activity SQL server sink.
type SQLServerSink struct {
	// REQUIRED; Copy sink type.
	Type *string `json:"type,omitempty"`

	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
	DisableMetricsCollection interface{} `json:"disableMetricsCollection,omitempty"`

	// The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
	MaxConcurrentConnections interface{} `json:"maxConcurrentConnections,omitempty"`

	// SQL pre-copy script. Type: string (or Expression with resultType string).
	PreCopyScript interface{} `json:"preCopyScript,omitempty"`

	// SQL writer stored procedure name. Type: string (or Expression with resultType string).
	SQLWriterStoredProcedureName interface{} `json:"sqlWriterStoredProcedureName,omitempty"`

	// SQL writer table type. Type: string (or Expression with resultType string).
	SQLWriterTableType interface{} `json:"sqlWriterTableType,omitempty"`

	// Whether to use table lock during bulk copy. Type: boolean (or Expression with resultType boolean).
	SQLWriterUseTableLock interface{} `json:"sqlWriterUseTableLock,omitempty"`

	// Sink retry count. Type: integer (or Expression with resultType integer).
	SinkRetryCount interface{} `json:"sinkRetryCount,omitempty"`

	// Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	SinkRetryWait interface{} `json:"sinkRetryWait,omitempty"`

	// SQL stored procedure parameters.
	StoredProcedureParameters interface{} `json:"storedProcedureParameters,omitempty"`

	// The stored procedure parameter name of the table type. Type: string (or Expression with resultType string).
	StoredProcedureTableTypeParameterName interface{} `json:"storedProcedureTableTypeParameterName,omitempty"`

	// The option to handle sink table, such as autoCreate. For now only 'autoCreate' value is supported. Type: string (or Expression
	// with resultType string).
	TableOption interface{} `json:"tableOption,omitempty"`

	// SQL upsert settings.
	UpsertSettings *SQLUpsertSettings `json:"upsertSettings,omitempty"`

	// Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
	WriteBatchSize interface{} `json:"writeBatchSize,omitempty"`

	// Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+).)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
	WriteBatchTimeout interface{} `json:"writeBatchTimeout,omitempty"`

	// Write behavior when copying data into sql server. Type: SqlWriteBehaviorEnum (or Expression with resultType SqlWriteBehaviorEnum)
	WriteBehavior interface{} `json:"writeBehavior,omitempty"`
}

// GetCopySink implements the CopySinkClassification interface for type SQLServerSink.
func (s *SQLServerSink) GetCopySink() *CopySink {
	return &CopySink{
		Type:                     s.Type,
		WriteBatchSize:           s.WriteBatchSize,
		WriteBatchTimeout:        s.WriteBatchTimeout,
		SinkRetryCount:           s.SinkRetryCount,
		SinkRetryWait:            s.SinkRetryWait,
		MaxConcurrentConnections: s.MaxConcurrentConnections,
		DisableMetricsCollection: s.DisableMetricsCollection,
		AdditionalProperties:     s.AdditionalProperties,
	}
}

// SQLServerSource - A copy activity SQL server source.
type SQLServerSource struct {
	// REQUIRED; Copy source type.
	Type *string `json:"type,omitempty"`

	// Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with
	// resultType array of objects).
	Add