// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package gsuiteaddons

import (
	"bytes"
	"context"
	"fmt"
	"io"
	"math"
	"net/http"
	"net/url"
	"time"

	gsuiteaddonspb "cloud.google.com/go/gsuiteaddons/apiv1/gsuiteaddonspb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/googleapi"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newClientHook clientHook

// CallOptions contains the retry settings for each method of Client.
type CallOptions struct {
	GetAuthorization    []gax.CallOption
	CreateDeployment    []gax.CallOption
	ReplaceDeployment   []gax.CallOption
	GetDeployment       []gax.CallOption
	ListDeployments     []gax.CallOption
	DeleteDeployment    []gax.CallOption
	InstallDeployment   []gax.CallOption
	UninstallDeployment []gax.CallOption
	GetInstallStatus    []gax.CallOption
}

func defaultGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("gsuiteaddons.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("gsuiteaddons.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("gsuiteaddons.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://gsuiteaddons.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultCallOptions() *CallOptions {
	return &CallOptions{
		GetAuthorization: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		CreateDeployment: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		ReplaceDeployment: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.Unknown,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetDeployment: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.Unknown,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListDeployments: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.Unknown,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteDeployment: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		InstallDeployment: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.Unknown,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UninstallDeployment: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.Unknown,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetInstallStatus: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.Unknown,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
	}
}

func defaultRESTCallOptions() *CallOptions {
	return &CallOptions{
		GetAuthorization: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		CreateDeployment: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		ReplaceDeployment: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable,
					http.StatusInternalServerError)
			}),
		},
		GetDeployment: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable,
					http.StatusInternalServerError)
			}),
		},
		ListDeployments: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable,
					http.StatusInternalServerError)
			}),
		},
		DeleteDeployment: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		InstallDeployment: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable,
					http.StatusInternalServerError)
			}),
		},
		UninstallDeployment: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable,
					http.StatusInternalServerError)
			}),
		},
		GetInstallStatus: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable,
					http.StatusInternalServerError)
			}),
		},
	}
}

// internalClient is an interface that defines the methods available from Google Workspace Add-ons API.
type internalClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	GetAuthorization(context.Context, *gsuiteaddonspb.GetAuthorizationRequest, ...gax.CallOption) (*gsuiteaddonspb.Authorization, error)
	CreateDeployment(context.Context, *gsuiteaddonspb.CreateDeploymentRequest, ...gax.CallOption) (*gsuiteaddonspb.Deployment, error)
	ReplaceDeployment(context.Context, *gsuiteaddonspb.ReplaceDeploymentRequest, ...gax.CallOption) (*gsuiteaddonspb.Deployment, error)
	GetDeployment(context.Context, *gsuiteaddonspb.GetDeploymentRequest, ...gax.CallOption) (*gsuiteaddonspb.Deployment, error)
	ListDeployments(context.Context, *gsuiteaddonspb.ListDeploymentsRequest, ...gax.CallOption) *DeploymentIterator
	DeleteDeployment(context.Context, *gsuiteaddonspb.DeleteDeploymentRequest, ...gax.CallOption) error
	InstallDeployment(context.Context, *gsuiteaddonspb.InstallDeploymentRequest, ...gax.CallOption) error
	UninstallDeployment(context.Context, *gsuiteaddonspb.UninstallDeploymentRequest, ...gax.CallOption) error
	GetInstallStatus(context.Context, *gsuiteaddonspb.GetInstallStatusRequest, ...gax.CallOption) (*gsuiteaddonspb.InstallStatus, error)
}

// Client is a client for interacting with Google Workspace Add-ons API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// A service for managing Google Workspace Add-ons deployments.
//
// A Google Workspace Add-on is a third-party embedded component that can be
// installed in Google Workspace Applications like Gmail, Calendar, Drive, and
// the Google Docs, Sheets, and Slides editors. Google Workspace Add-ons can
// display UI cards, receive contextual information from the host application,
// and perform actions in the host application (See:
// https://developers.google.com/gsuite/add-ons/overview (at https://developers.google.com/gsuite/add-ons/overview) for more information).
//
// A Google Workspace Add-on deployment resource specifies metadata about the
// add-on, including a specification of the entry points in the host application
// that trigger add-on executions (see:
// https://developers.google.com/gsuite/add-ons/concepts/gsuite-manifests (at https://developers.google.com/gsuite/add-ons/concepts/gsuite-manifests)).
// Add-on deployments defined via the Google Workspace Add-ons API define their
// entrypoints using HTTPS URLs (See:
// https://developers.google.com/gsuite/add-ons/guides/alternate-runtimes (at https://developers.google.com/gsuite/add-ons/guides/alternate-runtimes)),
//
// A Google Workspace Add-on deployment can be installed in developer mode,
// which allows an add-on developer to test the experience an end-user would see
// when installing and running the add-on in their G Suite applications.  When
// running in developer mode, more detailed error messages are exposed in the
// add-on UI to aid in debugging.
//
// A Google Workspace Add-on deployment can be published to Google Workspace
// Marketplace, which allows other Google Workspace users to discover and
// install the add-on.  See:
// https://developers.google.com/gsuite/add-ons/how-tos/publish-add-on-overview (at https://developers.google.com/gsuite/add-ons/how-tos/publish-add-on-overview)
// for details.
type Client struct {
	// The internal transport-dependent client.
	internalClient internalClient

	// The call options for this service.
	CallOptions *CallOptions
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *Client) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *Client) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *Client) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// GetAuthorization gets the authorization information for deployments in a given project.
func (c *Client) GetAuthorization(ctx context.Context, req *gsuiteaddonspb.GetAuthorizationRequest, opts ...gax.CallOption) (*gsuiteaddonspb.Authorization, error) {
	return c.internalClient.GetAuthorization(ctx, req, opts...)
}

// CreateDeployment creates a deployment with the specified name and configuration.
func (c *Client) CreateDeployment(ctx context.Context, req *gsuiteaddonspb.CreateDeploymentRequest, opts ...gax.CallOption) (*gsuiteaddonspb.Deployment, error) {
	return c.internalClient.CreateDeployment(ctx, req, opts...)
}

// ReplaceDeployment creates or replaces a deployment with the specified name.
func (c *Client) ReplaceDeployment(ctx context.Context, req *gsuiteaddonspb.ReplaceDeploymentRequest, opts ...gax.CallOption) (*gsuiteaddonspb.Deployment, error) {
	return c.internalClient.ReplaceDeployment(ctx, req, opts...)
}

// GetDeployment gets the deployment with the specified name.
func (c *Client) GetDeployment(ctx context.Context, req *gsuiteaddonspb.GetDeploymentRequest, opts ...gax.CallOption) (*gsuiteaddonspb.Deployment, error) {
	return c.internalClient.GetDeployment(ctx, req, opts...)
}

// ListDeployments lists all deployments in a particular project.
func (c *Client) ListDeployments(ctx context.Context, req *gsuiteaddonspb.ListDeploymentsRequest, opts ...gax.CallOption) *DeploymentIterator {
	return c.internalClient.ListDeployments(ctx, req, opts...)
}

// DeleteDeployment deletes the deployment with the given name.
func (c *Client) DeleteDeployment(ctx context.Context, req *gsuiteaddonspb.DeleteDeploymentRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteDeployment(ctx, req, opts...)
}

// InstallDeployment installs a deployment in developer mode.
// See:
// https://developers.google.com/gsuite/add-ons/how-tos/testing-gsuite-addons (at https://developers.google.com/gsuite/add-ons/how-tos/testing-gsuite-addons).
func (c *Client) InstallDeployment(ctx context.Context, req *gsuiteaddonspb.InstallDeploymentRequest, opts ...gax.CallOption) error {
	return c.internalClient.InstallDeployment(ctx, req, opts...)
}

// UninstallDeployment uninstalls a developer mode deployment.
// See:
// https://developers.google.com/gsuite/add-ons/how-tos/testing-gsuite-addons (at https://developers.google.com/gsuite/add-ons/how-tos/testing-gsuite-addons).
func (c *Client) UninstallDeployment(ctx context.Context, req *gsuiteaddonspb.UninstallDeploymentRequest, opts ...gax.CallOption) error {
	return c.internalClient.UninstallDeployment(ctx, req, opts...)
}

// GetInstallStatus fetches the install status of a developer mode deployment.
func (c *Client) GetInstallStatus(ctx context.Context, req *gsuiteaddonspb.GetInstallStatusRequest, opts ...gax.CallOption) (*gsuiteaddonspb.InstallStatus, error) {
	return c.internalClient.GetInstallStatus(ctx, req, opts...)
}

// gRPCClient is a client for interacting with Google Workspace Add-ons API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type gRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions

	// The gRPC API client.
	client gsuiteaddonspb.GSuiteAddOnsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string
}

// NewClient creates a new g suite add ons client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// A service for managing Google Workspace Add-ons deployments.
//
// A Google Workspace Add-on is a third-party embedded component that can be
// installed in Google Workspace Applications like Gmail, Calendar, Drive, and
// the Google Docs, Sheets, and Slides editors. Google Workspace Add-ons can
// display UI cards, receive contextual information from the host application,
// and perform actions in the host application (See:
// https://developers.google.com/gsuite/add-ons/overview (at https://developers.google.com/gsuite/add-ons/overview) for more information).
//
// A Google Workspace Add-on deployment resource specifies metadata about the
// add-on, including a specification of the entry points in the host application
// that trigger add-on executions (see:
// https://developers.google.com/gsuite/add-ons/concepts/gsuite-manifests (at https://developers.google.com/gsuite/add-ons/concepts/gsuite-manifests)).
// Add-on deployments defined via the Google Workspace Add-ons API define their
// entrypoints using HTTPS URLs (See:
// https://developers.google.com/gsuite/add-ons/guides/alternate-runtimes (at https://developers.google.com/gsuite/add-ons/guides/alternate-runtimes)),
//
// A Google Workspace Add-on deployment can be installed in developer mode,
// which allows an add-on developer to test the experience an end-user would see
// when installing and running the add-on in their G Suite applications.  When
// running in developer mode, more detailed error messages are exposed in the
// add-on UI to aid in debugging.
//
// A Google Workspace Add-on deployment can be published to Google Workspace
// Marketplace, which allows other Google Workspace users to discover and
// install the add-on.  See:
// https://developers.google.com/gsuite/add-ons/how-tos/publish-add-on-overview (at https://developers.google.com/gsuite/add-ons/how-tos/publish-add-on-overview)
// for details.
func NewClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := defaultGRPCClientOptions()
	if newClientHook != nil {
		hookOpts, err := newClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := Client{CallOptions: defaultCallOptions()}

	c := &gRPCClient{
		connPool:    connPool,
		client:      gsuiteaddonspb.NewGSuiteAddOnsClient(connPool),
		CallOptions: &client.CallOptions,
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *gRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *gRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{"x-goog-api-client", gax.XGoogHeader(kv...)}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *gRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type restClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions
}

// NewRESTClient creates a new g suite add ons rest client.
//
// A service for managing Google Workspace Add-ons deployments.
//
// A Google Workspace Add-on is a third-party embedded component that can be
// installed in Google Workspace Applications like Gmail, Calendar, Drive, and
// the Google Docs, Sheets, and Slides editors. Google Workspace Add-ons can
// display UI cards, receive contextual information from the host application,
// and perform actions in the host application (See:
// https://developers.google.com/gsuite/add-ons/overview (at https://developers.google.com/gsuite/add-ons/overview) for more information).
//
// A Google Workspace Add-on deployment resource specifies metadata about the
// add-on, including a specification of the entry points in the host application
// that trigger add-on executions (see:
// https://developers.google.com/gsuite/add-ons/concepts/gsuite-manifests (at https://developers.google.com/gsuite/add-ons/concepts/gsuite-manifests)).
// Add-on deployments defined via the Google Workspace Add-ons API define their
// entrypoints using HTTPS URLs (See:
// https://developers.google.com/gsuite/add-ons/guides/alternate-runtimes (at https://developers.google.com/gsuite/add-ons/guides/alternate-runtimes)),
//
// A Google Workspace Add-on deployment can be installed in developer mode,
// which allows an add-on developer to test the experience an end-user would see
// when installing and running the add-on in their G Suite applications.  When
// running in developer mode, more detailed error messages are exposed in the
// add-on UI to aid in debugging.
//
// A Google Workspace Add-on deployment can be published to Google Workspace
// Marketplace, which allows other Google Workspace users to discover and
// install the add-on.  See:
// https://developers.google.com/gsuite/add-ons/how-tos/publish-add-on-overview (at https://developers.google.com/gsuite/add-ons/how-tos/publish-add-on-overview)
// for details.
func NewRESTClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := append(defaultRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultRESTCallOptions()
	c := &restClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
	}
	c.setGoogleClientInfo()

	return &Client{internalClient: c, CallOptions: callOpts}, nil
}

func defaultRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://gsuiteaddons.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://gsuiteaddons.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://gsuiteaddons.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://gsuiteaddons.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *restClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{"x-goog-api-client", gax.XGoogHeader(kv...)}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *restClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *restClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *gRPCClient) GetAuthorization(ctx context.Context, req *gsuiteaddonspb.GetAuthorizationRequest, opts ...gax.CallOption) (*gsuiteaddonspb.Authorization, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetAuthorization[0:len((*c.CallOptions).GetAuthorization):len((*c.CallOptions).GetAuthorization)], opts...)
	var resp *gsuiteaddonspb.Authorization
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetAuthorization(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateDeployment(ctx context.Context, req *gsuiteaddonspb.CreateDeploymentRequest, opts ...gax.CallOption) (*gsuiteaddonspb.Deployment, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateDeployment[0:len((*c.CallOptions).CreateDeployment):len((*c.CallOptions).CreateDeployment)], opts...)
	var resp *gsuiteaddonspb.Deployment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.CreateDeployment(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ReplaceDeployment(ctx context.Context, req *gsuiteaddonspb.ReplaceDeploymentRequest, opts ...gax.CallOption) (*gsuiteaddonspb.Deployment, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "deployment.name", url.QueryEscape(req.GetDeployment().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ReplaceDeployment[0:len((*c.CallOptions).ReplaceDeployment):len((*c.CallOptions).ReplaceDeployment)], opts...)
	var resp *gsuiteaddonspb.Deployment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.ReplaceDeployment(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) GetDeployment(ctx context.Context, req *gsuiteaddonspb.GetDeploymentRequest, opts ...gax.CallOption) (*gsuiteaddonspb.Deployment, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetDeployment[0:len((*c.CallOptions).GetDeployment):len((*c.CallOptions).GetDeployment)], opts...)
	var resp *gsuiteaddonspb.Deployment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetDeployment(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListDeployments(ctx context.Context, req *gsuiteaddonspb.ListDeploymentsRequest, opts ...gax.CallOption) *DeploymentIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListDeployments[0:len((*c.CallOptions).ListDeployments):len((*c.CallOptions).ListDeployments)], opts...)
	it := &DeploymentIterator{}
	req = proto.Clone(req).(*gsuiteaddonspb.ListDeploymentsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*gsuiteaddonspb.Deployment, string, error) {
		resp := &gsuiteaddonspb.ListDeploymentsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.client.ListDeployments(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetDeployments(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) DeleteDeployment(ctx context.Context, req *gsuiteaddonspb.DeleteDeploymentRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteDeployment[0:len((*c.CallOptions).DeleteDeployment):len((*c.CallOptions).DeleteDeployment)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.client.DeleteDeployment(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) InstallDeployment(ctx context.Context, req *gsuiteaddonspb.InstallDeploymentRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).InstallDeployment[0:len((*c.CallOptions).InstallDeployment):len((*c.CallOptions).InstallDeployment)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.client.InstallDeployment(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) UninstallDeployment(ctx context.Context, req *gsuiteaddonspb.UninstallDeploymentRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UninstallDeployment[0:len((*c.CallOptions).UninstallDeployment):len((*c.CallOptions).UninstallDeployment)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.client.UninstallDeployment(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) GetInstallStatus(ctx context.Context, req *gsuiteaddonspb.GetInstallStatusRequest, opts ...gax.CallOption) (*gsuiteaddonspb.InstallStatus, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetInstallStatus[0:len((*c.CallOptions).GetInstallStatus):len((*c.CallOptions).GetInstallStatus)], opts...)
	var resp *gsuiteaddonspb.InstallStatus
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.client.GetInstallStatus(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// GetAuthorization gets the authorization information for deployments in a given project.
func (c *restClient) GetAuthorization(ctx context.Context, req *gsuiteaddonspb.GetAuthorizationRequest, opts ...gax.CallOption) (*gsuiteaddonspb.Authorization, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetAuthorization[0:len((*c.CallOptions).GetAuthorization):len((*c.CallOptions).GetAuthorization)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &gsuiteaddonspb.Authorization{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateDeployment creates a deployment with the specified name and configuration.
func (c *restClient) CreateDeployment(ctx context.Context, req *gsuiteaddonspb.CreateDeploymentRequest, opts ...gax.CallOption) (*gsuiteaddonspb.Deployment, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetDeployment()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/deployments", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("deploymentId", fmt.Sprintf("%v", req.GetDeploymentId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CreateDeployment[0:len((*c.CallOptions).CreateDeployment):len((*c.CallOptions).CreateDeployment)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &gsuiteaddonspb.Deployment{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ReplaceDeployment creates or replaces a deployment with the specified name.
func (c *restClient) ReplaceDeployment(ctx context.Context, req *gsuiteaddonspb.ReplaceDeploymentRequest, opts ...gax.CallOption) (*gsuiteaddonspb.Deployment, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetDeployment()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetDeployment().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "deployment.name", url.QueryEscape(req.GetDeployment().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).ReplaceDeployment[0:len((*c.CallOptions).ReplaceDeployment):len((*c.CallOptions).ReplaceDeployment)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &gsuiteaddonspb.Deployment{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PUT", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// GetDeployment gets the deployment with the specified name.
func (c *restClient) GetDeployment(ctx context.Context, req *gsuiteaddonspb.GetDeploymentRequest, opts ...gax.CallOption) (*gsuiteaddonspb.Deployment, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetDeployment[0:len((*c.CallOptions).GetDeployment):len((*c.CallOptions).GetDeployment)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &gsuiteaddonspb.Deployment{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListDeployments lists all deployments in a particular project.
func (c *restClient) ListDeployments(ctx context.Context, req *gsuiteaddonspb.ListDeploymentsRequest, opts ...gax.CallOption) *DeploymentIterator {
	it := &DeploymentIterator{}
	req = proto.Clone(req).(*gsuiteaddonspb.ListDeploymentsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*gsuiteaddonspb.Deployment, string, error) {
		resp := &gsuiteaddonspb.ListDeploymentsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/deployments", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			httpRsp, err := c.httpClient.Do(httpReq)
			if err != nil {
				return err
			}
			defer httpRsp.Body.Close()

			if err = googleapi.CheckResponse(httpRsp); err != nil {
				return err
			}

			buf, err := io.ReadAll(httpRsp.Body)
			if err != nil {
				return err
			}

			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetDeployments(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// DeleteDeployment deletes the deployment with the given name.
func (c *restClient) DeleteDeployment(ctx context.Context, req *gsuiteaddonspb.DeleteDeploymentRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetEtag() != "" {
		params.Add("etag", fmt.Sprintf("%v", req.GetEtag()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		// Returns nil if there is no error, otherwise wraps
		// the response code and body into a non-nil error
		return googleapi.CheckResponse(httpRsp)
	}, opts...)
}

// InstallDeployment installs a deployment in developer mode.
// See:
// https://developers.google.com/gsuite/add-ons/how-tos/testing-gsuite-addons (at https://developers.google.com/gsuite/add-ons/how-tos/testing-gsuite-addons).
func (c *restClient) InstallDeployment(ctx context.Context, req *gsuiteaddonspb.InstallDeploymentRequest, opts ...gax.CallOption) error {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:install", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		// Returns nil if there is no error, otherwise wraps
		// the response code and body into a non-nil error
		return googleapi.CheckResponse(httpRsp)
	}, opts...)
}

// UninstallDeployment uninstalls a developer mode deployment.
// See:
// https://developers.google.com/gsuite/add-ons/how-tos/testing-gsuite-addons (at https://developers.google.com/gsuite/add-ons/how-tos/testing-gsuite-addons).
func (c *restClient) UninstallDeployment(ctx context.Context, req *gsuiteaddonspb.UninstallDeploymentRequest, opts ...gax.CallOption) error {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:uninstall", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		// Returns nil if there is no error, otherwise wraps
		// the response code and body into a non-nil error
		return googleapi.CheckResponse(httpRsp)
	}, opts...)
}

// GetInstallStatus fetches the install status of a developer mode deployment.
func (c *restClient) GetInstallStatus(ctx context.Context, req *gsuiteaddonspb.GetInstallStatusRequest, opts ...gax.CallOption) (*gsuiteaddonspb.InstallStatus, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetInstallStatus[0:len((*c.CallOptions).GetInstallStatus):len((*c.CallOptions).GetInstallStatus)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &gsuiteaddonspb.InstallStatus{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil {
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := io.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}
