// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/functions/v1/functions.proto

package functionspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	iampb "cloud.google.com/go/iam/apiv1/iampb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Describes the current stage of a deployment.
type CloudFunctionStatus int32

const (
	// Not specified. Invalid state.
	CloudFunctionStatus_CLOUD_FUNCTION_STATUS_UNSPECIFIED CloudFunctionStatus = 0
	// Function has been successfully deployed and is serving.
	CloudFunctionStatus_ACTIVE CloudFunctionStatus = 1
	// Function deployment failed and the function isn’t serving.
	CloudFunctionStatus_OFFLINE CloudFunctionStatus = 2
	// Function is being created or updated.
	CloudFunctionStatus_DEPLOY_IN_PROGRESS CloudFunctionStatus = 3
	// Function is being deleted.
	CloudFunctionStatus_DELETE_IN_PROGRESS CloudFunctionStatus = 4
	// Function deployment failed and the function serving state is undefined.
	// The function should be updated or deleted to move it out of this state.
	CloudFunctionStatus_UNKNOWN CloudFunctionStatus = 5
)

// Enum value maps for CloudFunctionStatus.
var (
	CloudFunctionStatus_name = map[int32]string{
		0: "CLOUD_FUNCTION_STATUS_UNSPECIFIED",
		1: "ACTIVE",
		2: "OFFLINE",
		3: "DEPLOY_IN_PROGRESS",
		4: "DELETE_IN_PROGRESS",
		5: "UNKNOWN",
	}
	CloudFunctionStatus_value = map[string]int32{
		"CLOUD_FUNCTION_STATUS_UNSPECIFIED": 0,
		"ACTIVE":                            1,
		"OFFLINE":                           2,
		"DEPLOY_IN_PROGRESS":                3,
		"DELETE_IN_PROGRESS":                4,
		"UNKNOWN":                           5,
	}
)

func (x CloudFunctionStatus) Enum() *CloudFunctionStatus {
	p := new(CloudFunctionStatus)
	*p = x
	return p
}

func (x CloudFunctionStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CloudFunctionStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_functions_v1_functions_proto_enumTypes[0].Descriptor()
}

func (CloudFunctionStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_functions_v1_functions_proto_enumTypes[0]
}

func (x CloudFunctionStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CloudFunctionStatus.Descriptor instead.
func (CloudFunctionStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1_functions_proto_rawDescGZIP(), []int{0}
}

// Available egress settings.
//
// This controls what traffic is diverted through the VPC Access Connector
// resource. By default PRIVATE_RANGES_ONLY will be used.
type CloudFunction_VpcConnectorEgressSettings int32

const (
	// Unspecified.
	CloudFunction_VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED CloudFunction_VpcConnectorEgressSettings = 0
	// Use the VPC Access Connector only for private IP space from RFC1918.
	CloudFunction_PRIVATE_RANGES_ONLY CloudFunction_VpcConnectorEgressSettings = 1
	// Force the use of VPC Access Connector for all egress traffic from the
	// function.
	CloudFunction_ALL_TRAFFIC CloudFunction_VpcConnectorEgressSettings = 2
)

// Enum value maps for CloudFunction_VpcConnectorEgressSettings.
var (
	CloudFunction_VpcConnectorEgressSettings_name = map[int32]string{
		0: "VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED",
		1: "PRIVATE_RANGES_ONLY",
		2: "ALL_TRAFFIC",
	}
	CloudFunction_VpcConnectorEgressSettings_value = map[string]int32{
		"VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED": 0,
		"PRIVATE_RANGES_ONLY":                       1,
		"ALL_TRAFFIC":                               2,
	}
)

func (x CloudFunction_VpcConnectorEgressSettings) Enum() *CloudFunction_VpcConnectorEgressSettings {
	p := new(CloudFunction_VpcConnectorEgressSettings)
	*p = x
	return p
}

func (x CloudFunction_VpcConnectorEgressSettings) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CloudFunction_VpcConnectorEgressSettings) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_functions_v1_functions_proto_enumTypes[1].Descriptor()
}

func (CloudFunction_VpcConnectorEgressSettings) Type() protoreflect.EnumType {
	return &file_google_cloud_functions_v1_functions_proto_enumTypes[1]
}

func (x CloudFunction_VpcConnectorEgressSettings) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CloudFunction_VpcConnectorEgressSettings.Descriptor instead.
func (CloudFunction_VpcConnectorEgressSettings) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1_functions_proto_rawDescGZIP(), []int{0, 0}
}

// Available ingress settings.
//
// This controls what traffic can reach the function.
//
// If unspecified, ALLOW_ALL will be used.
type CloudFunction_IngressSettings int32

const (
	// Unspecified.
	CloudFunction_INGRESS_SETTINGS_UNSPECIFIED CloudFunction_IngressSettings = 0
	// Allow HTTP traffic from public and private sources.
	CloudFunction_ALLOW_ALL CloudFunction_IngressSettings = 1
	// Allow HTTP traffic from only private VPC sources.
	CloudFunction_ALLOW_INTERNAL_ONLY CloudFunction_IngressSettings = 2
	// Allow HTTP traffic from private VPC sources and through GCLB.
	CloudFunction_ALLOW_INTERNAL_AND_GCLB CloudFunction_IngressSettings = 3
)

// Enum value maps for CloudFunction_IngressSettings.
var (
	CloudFunction_IngressSettings_name = map[int32]string{
		0: "INGRESS_SETTINGS_UNSPECIFIED",
		1: "ALLOW_ALL",
		2: "ALLOW_INTERNAL_ONLY",
		3: "ALLOW_INTERNAL_AND_GCLB",
	}
	CloudFunction_IngressSettings_value = map[string]int32{
		"INGRESS_SETTINGS_UNSPECIFIED": 0,
		"ALLOW_ALL":                    1,
		"ALLOW_INTERNAL_ONLY":          2,
		"ALLOW_INTERNAL_AND_GCLB":      3,
	}
)

func (x CloudFunction_IngressSettings) Enum() *CloudFunction_IngressSettings {
	p := new(CloudFunction_IngressSettings)
	*p = x
	return p
}

func (x CloudFunction_IngressSettings) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CloudFunction_IngressSettings) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_functions_v1_functions_proto_enumTypes[2].Descriptor()
}

func (CloudFunction_IngressSettings) Type() protoreflect.EnumType {
	return &file_google_cloud_functions_v1_functions_proto_enumTypes[2]
}

func (x CloudFunction_IngressSettings) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CloudFunction_IngressSettings.Descriptor instead.
func (CloudFunction_IngressSettings) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1_functions_proto_rawDescGZIP(), []int{0, 1}
}

// Docker Registry to use for storing function Docker images.
type CloudFunction_DockerRegistry int32

const (
	// Unspecified.
	CloudFunction_DOCKER_REGISTRY_UNSPECIFIED CloudFunction_DockerRegistry = 0
	// Docker images will be stored in multi-regional Container Registry
	// repositories named `gcf`.
	CloudFunction_CONTAINER_REGISTRY CloudFunction_DockerRegistry = 1
	// Docker images will be stored in regional Artifact Registry repositories.
	// By default, GCF will create and use repositories named `gcf-artifacts`
	// in every region in which a function is deployed. But the repository to
	// use can also be specified by the user using the `docker_repository`
	// field.
	CloudFunction_ARTIFACT_REGISTRY CloudFunction_DockerRegistry = 2
)

// Enum value maps for CloudFunction_DockerRegistry.
var (
	CloudFunction_DockerRegistry_name = map[int32]string{
		0: "DOCKER_REGISTRY_UNSPECIFIED",
		1: "CONTAINER_REGISTRY",
		2: "ARTIFACT_REGISTRY",
	}
	CloudFunction_DockerRegistry_value = map[string]int32{
		"DOCKER_REGISTRY_UNSPECIFIED": 0,
		"CONTAINER_REGISTRY":          1,
		"ARTIFACT_REGISTRY":           2,
	}
)

func (x CloudFunction_DockerRegistry) Enum() *CloudFunction_DockerRegistry {
	p := new(CloudFunction_DockerRegistry)
	*p = x
	return p
}

func (x CloudFunction_DockerRegistry) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CloudFunction_DockerRegistry) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_functions_v1_functions_proto_enumTypes[3].Descriptor()
}

func (CloudFunction_DockerRegistry) Type() protoreflect.EnumType {
	return &file_google_cloud_functions_v1_functions_proto_enumTypes[3]
}

func (x CloudFunction_DockerRegistry) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CloudFunction_DockerRegistry.Descriptor instead.
func (CloudFunction_DockerRegistry) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1_functions_proto_rawDescGZIP(), []int{0, 2}
}

// Available security level settings.
//
// This controls the methods to enforce security (HTTPS) on a URL.
//
// If unspecified, SECURE_OPTIONAL will be used.
type HttpsTrigger_SecurityLevel int32

const (
	// Unspecified.
	HttpsTrigger_SECURITY_LEVEL_UNSPECIFIED HttpsTrigger_SecurityLevel = 0
	// Requests for a URL that match this handler that do not use HTTPS are
	// automatically redirected to the HTTPS URL with the same path. Query
	// parameters are reserved for the redirect.
	HttpsTrigger_SECURE_ALWAYS HttpsTrigger_SecurityLevel = 1
	// Both HTTP and HTTPS requests with URLs that match the handler succeed
	// without redirects. The application can examine the request to determine
	// which protocol was used and respond accordingly.
	HttpsTrigger_SECURE_OPTIONAL HttpsTrigger_SecurityLevel = 2
)

// Enum value maps for HttpsTrigger_SecurityLevel.
var (
	HttpsTrigger_SecurityLevel_name = map[int32]string{
		0: "SECURITY_LEVEL_UNSPECIFIED",
		1: "SECURE_ALWAYS",
		2: "SECURE_OPTIONAL",
	}
	HttpsTrigger_SecurityLevel_value = map[string]int32{
		"SECURITY_LEVEL_UNSPECIFIED": 0,
		"SECURE_ALWAYS":              1,
		"SECURE_OPTIONAL":            2,
	}
)

func (x HttpsTrigger_SecurityLevel) Enum() *HttpsTrigger_SecurityLevel {
	p := new(HttpsTrigger_SecurityLevel)
	*p = x
	return p
}

func (x HttpsTrigger_SecurityLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HttpsTrigger_SecurityLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_functions_v1_functions_proto_enumTypes[4].Descriptor()
}

func (HttpsTrigger_SecurityLevel) Type() protoreflect.EnumType {
	return &file_google_cloud_functions_v1_functions_proto_enumTypes[4]
}

func (x HttpsTrigger_SecurityLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HttpsTrigger_SecurityLevel.Descriptor instead.
func (HttpsTrigger_SecurityLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1_functions_proto_rawDescGZIP(), []int{2, 0}
}

// Describes a Cloud Function that contains user computation executed in
// response to an event. It encapsulate function and triggers configurations.
type CloudFunction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A user-defined name of the function. Function names must be unique
	// globally and match pattern `projects/*/locations/*/functions/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// User-provided description of a function.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The location of the function source code.
	//
	// Types that are assignable to SourceCode:
	//
	//	*CloudFunction_SourceArchiveUrl
	//	*CloudFunction_SourceRepository
	//	*CloudFunction_SourceUploadUrl
	SourceCode isCloudFunction_SourceCode `protobuf_oneof:"source_code"`
	// An event that triggers the function.
	//
	// Types that are assignable to Trigger:
	//
	//	*CloudFunction_HttpsTrigger
	//	*CloudFunction_EventTrigger
	Trigger isCloudFunction_Trigger `protobuf_oneof:"trigger"`
	// Output only. Status of the function deployment.
	Status CloudFunctionStatus `protobuf:"varint,7,opt,name=status,proto3,enum=google.cloud.functions.v1.CloudFunctionStatus" json:"status,omitempty"`
	// The name of the function (as defined in source code) that will be
	// executed. Defaults to the resource name suffix (ID of the function), if not
	// specified.
	EntryPoint string `protobuf:"bytes,8,opt,name=entry_point,json=entryPoint,proto3" json:"entry_point,omitempty"`
	// The runtime in which to run the function. Required when deploying a new
	// function, optional when updating an existing function. For a complete
	// list of possible choices, see the
	// [`gcloud` command
	// reference](https://cloud.google.com/sdk/gcloud/reference/functions/deploy#--runtime).
	Runtime string `protobuf:"bytes,19,opt,name=runtime,proto3" json:"runtime,omitempty"`
	// The function execution timeout. Execution is considered failed and
	// can be terminated if the function is not completed at the end of the
	// timeout period. Defaults to 60 seconds.
	Timeout *durationpb.Duration `protobuf:"bytes,9,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// The amount of memory in MB available for a function.
	// Defaults to 256MB.
	AvailableMemoryMb int32 `protobuf:"varint,10,opt,name=available_memory_mb,json=availableMemoryMb,proto3" json:"available_memory_mb,omitempty"`
	// The email of the function's service account. If empty, defaults to
	// `{project_id}@appspot.gserviceaccount.com`.
	ServiceAccountEmail string `protobuf:"bytes,11,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
	// Output only. The last update timestamp of a Cloud Function.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The version identifier of the Cloud Function. Each deployment
	// attempt results in a new version of a function being created.
	VersionId int64 `protobuf:"varint,14,opt,name=version_id,json=versionId,proto3" json:"version_id,omitempty"`
	// Labels associated with this Cloud Function.
	Labels map[string]string `protobuf:"bytes,15,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Environment variables that shall be available during function execution.
	EnvironmentVariables map[string]string `protobuf:"bytes,17,rep,name=environment_variables,json=environmentVariables,proto3" json:"environment_variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Build environment variables that shall be available during build time.
	BuildEnvironmentVariables map[string]string `protobuf:"bytes,28,rep,name=build_environment_variables,json=buildEnvironmentVariables,proto3" json:"build_environment_variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deprecated: use vpc_connector
	//
	// Deprecated: Marked as deprecated in google/cloud/functions/v1/functions.proto.
	Network string `protobuf:"bytes,18,opt,name=network,proto3" json:"network,omitempty"`
	// The limit on the maximum number of function instances that may coexist at a
	// given time.
	//
	// In some cases, such as rapid traffic surges, Cloud Functions may, for a
	// short period of time, create more instances than the specified max
	// instances limit. If your function cannot tolerate this temporary behavior,
	// you may want to factor in a safety margin and set a lower max instances
	// value than your function can tolerate.
	//
	// See the [Max
	// Instances](https://cloud.google.com/functions/docs/max-instances) Guide for
	// more details.
	MaxInstances int32 `protobuf:"varint,20,opt,name=max_instances,json=maxInstances,proto3" json:"max_instances,omitempty"`
	// A lower bound for the number function instances that may coexist at a
	// given time.
	MinInstances int32 `protobuf:"varint,32,opt,name=min_instances,json=minInstances,proto3" json:"min_instances,omitempty"`
	// The VPC Network Connector that this cloud function can connect to. It can
	// be either the fully-qualified URI, or the short name of the network
	// connector resource. The format of this field is
	// `projects/*/locations/*/connectors/*`
	//
	// This field is mutually exclusive with `network` field and will eventually
	// replace it.
	//
	// See [the VPC documentation](https://cloud.google.com/compute/docs/vpc) for
	// more information on connecting Cloud projects.
	VpcConnector string `protobuf:"bytes,22,opt,name=vpc_connector,json=vpcConnector,proto3" json:"vpc_connector,omitempty"`
	// The egress settings for the connector, controlling what traffic is diverted
	// through it.
	VpcConnectorEgressSettings CloudFunction_VpcConnectorEgressSettings `protobuf:"varint,23,opt,name=vpc_connector_egress_settings,json=vpcConnectorEgressSettings,proto3,enum=google.cloud.functions.v1.CloudFunction_VpcConnectorEgressSettings" json:"vpc_connector_egress_settings,omitempty"`
	// The ingress settings for the function, controlling what traffic can reach
	// it.
	IngressSettings CloudFunction_IngressSettings `protobuf:"varint,24,opt,name=ingress_settings,json=ingressSettings,proto3,enum=google.cloud.functions.v1.CloudFunction_IngressSettings" json:"ingress_settings,omitempty"`
	// Resource name of a KMS crypto key (managed by the user) used to
	// encrypt/decrypt function resources.
	//
	// It must match the pattern
	// `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
	//
	// If specified, you must also provide an artifact registry repository using
	// the `docker_repository` field that was created with the same KMS crypto
	// key.
	//
	// The following service accounts need to be granted the role 'Cloud KMS
	// CryptoKey Encrypter/Decrypter (roles/cloudkms.cryptoKeyEncrypterDecrypter)'
	// on the Key/KeyRing/Project/Organization (least access preferred).
	//
	//  1. Google Cloud Functions service account
	//     (service-{project_number}@gcf-admin-robot.iam.gserviceaccount.com) -
	//     Required to protect the function's image.
	//  2. Google Storage service account
	//     (service-{project_number}@gs-project-accounts.iam.gserviceaccount.com) -
	//     Required to protect the function's source code.
	//     If this service account does not exist, deploying a function without a
	//     KMS key or retrieving the service agent name provisions it. For more
	//     information, see
	//     https://cloud.google.com/storage/docs/projects#service-agents and
	//     https://cloud.google.com/storage/docs/getting-service-agent#gsutil.
	//
	// Google Cloud Functions delegates access to service agents to protect
	// function resources in internal projects that are not accessible by the
	// end user.
	KmsKeyName string `protobuf:"bytes,25,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
	// Name of the Cloud Build Custom Worker Pool that should be used to build the
	// function. The format of this field is
	// `projects/{project}/locations/{region}/workerPools/{workerPool}` where
	// `{project}` and `{region}` are the project id and region respectively where
	// the worker pool is defined and `{workerPool}` is the short name of the
	// worker pool.
	//
	// If the project id is not the same as the function, then the Cloud
	// Functions Service Agent
	// (`service-<project_number>@gcf-admin-robot.iam.gserviceaccount.com`) must
	// be granted the role Cloud Build Custom Workers Builder
	// (`roles/cloudbuild.customworkers.builder`) in the project.
	BuildWorkerPool string `protobuf:"bytes,26,opt,name=build_worker_pool,json=buildWorkerPool,proto3" json:"build_worker_pool,omitempty"`
	// Output only. The Cloud Build ID of the latest successful deployment of the
	// function.
	BuildId string `protobuf:"bytes,27,opt,name=build_id,json=buildId,proto3" json:"build_id,omitempty"`
	// Output only. The Cloud Build Name of the function deployment.
	// `projects/<project-number>/locations/<region>/builds/<build-id>`.
	BuildName string `protobuf:"bytes,33,opt,name=build_name,json=buildName,proto3" json:"build_name,omitempty"`
	// Secret environment variables configuration.
	SecretEnvironmentVariables []*SecretEnvVar `protobuf:"bytes,29,rep,name=secret_environment_variables,json=secretEnvironmentVariables,proto3" json:"secret_environment_variables,omitempty"`
	// Secret volumes configuration.
	SecretVolumes []*SecretVolume `protobuf:"bytes,30,rep,name=secret_volumes,json=secretVolumes,proto3" json:"secret_volumes,omitempty"`
	// Input only. An identifier for Firebase function sources. Disclaimer: This
	// field is only supported for Firebase function deployments.
	SourceToken string `protobuf:"bytes,31,opt,name=source_token,json=sourceToken,proto3" json:"source_token,omitempty"`
	// User managed repository created in Artifact Registry optionally with a
	// customer managed encryption key. If specified, deployments will use
	// Artifact Registry. If unspecified and the deployment is eligible to use
	// Artifact Registry, GCF will create and use a repository named
	// 'gcf-artifacts' for every deployed region. This is the repository to which
	// the function docker image will be pushed after it is built by Cloud Build.
	//
	// It must match the pattern
	// `projects/{project}/locations/{location}/repositories/{repository}`.
	//
	// Cross-project repositories are not supported.
	// Cross-location repositories are not supported.
	// Repository format must be 'DOCKER'.
	DockerRepository string `protobuf:"bytes,34,opt,name=docker_repository,json=dockerRepository,proto3" json:"docker_repository,omitempty"`
	// Docker Registry to use for this deployment.
	//
	// If unspecified, it defaults to `ARTIFACT_REGISTRY`.
	// If `docker_repository` field is specified, this field should either be left
	// unspecified or set to `ARTIFACT_REGISTRY`.
	DockerRegistry CloudFunction_DockerRegistry `protobuf:"varint,35,opt,name=docker_registry,json=dockerRegistry,proto3,enum=google.cloud.functions.v1.CloudFunction_DockerRegistry" json:"docker_registry,omitempty"`
	// Runtime update policy can be one of the following.
	//
	// Types that are assignable to RuntimeUpdatePolicy:
	//
	//	*CloudFunction_AutomaticUpdatePolicy_
	//	*CloudFunction_OnDeployUpdatePolicy_
	RuntimeUpdatePolicy isCloudFunction_RuntimeUpdatePolicy `protobuf_oneof:"runtime_update_policy"`
}

func (x *CloudFunction) Reset() {
	*x = CloudFunction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudFunction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudFunction) ProtoMessage() {}

func (x *CloudFunction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudFunction.ProtoReflect.Descriptor instead.
func (*CloudFunction) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1_functions_proto_rawDescGZIP(), []int{0}
}

func (x *CloudFunction) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CloudFunction) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (m *CloudFunction) GetSourceCode() isCloudFunction_SourceCode {
	if m != nil {
		return m.SourceCode
	}
	return nil
}

func (x *CloudFunction) GetSourceArchiveUrl() string {
	if x, ok := x.GetSourceCode().(*CloudFunction_SourceArchiveUrl); ok {
		return x.SourceArchiveUrl
	}
	return ""
}

func (x *CloudFunction) GetSourceRepository() *SourceRepository {
	if x, ok := x.GetSourceCode().(*CloudFunction_SourceRepository); ok {
		return x.SourceRepository
	}
	return nil
}

func (x *CloudFunction) GetSourceUploadUrl() string {
	if x, ok := x.GetSourceCode().(*CloudFunction_SourceUploadUrl); ok {
		return x.SourceUploadUrl
	}
	return ""
}

func (m *CloudFunction) GetTrigger() isCloudFunction_Trigger {
	if m != nil {
		return m.Trigger
	}
	return nil
}

func (x *CloudFunction) GetHttpsTrigger() *HttpsTrigger {
	if x, ok := x.GetTrigger().(*CloudFunction_HttpsTrigger); ok {
		return x.HttpsTrigger
	}
	return nil
}

func (x *CloudFunction) GetEventTrigger() *EventTrigger {
	if x, ok := x.GetTrigger().(*CloudFunction_EventTrigger); ok {
		return x.EventTrigger
	}
	return nil
}

func (x *CloudFunction) GetStatus() CloudFunctionStatus {
	if x != nil {
		return x.Status
	}
	return CloudFunctionStatus_CLOUD_FUNCTION_STATUS_UNSPECIFIED
}

func (x *CloudFunction) GetEntryPoint() string {
	if x != nil {
		return x.EntryPoint
	}
	return ""
}

func (x *CloudFunction) GetRuntime() string {
	if x != nil {
		return x.Runtime
	}
	return ""
}

func (x *CloudFunction) GetTimeout() *durationpb.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *CloudFunction) GetAvailableMemoryMb() int32 {
	if x != nil {
		return x.AvailableMemoryMb
	}
	return 0
}

func (x *CloudFunction) GetServiceAccountEmail() string {
	if x != nil {
		return x.ServiceAccountEmail
	}
	return ""
}

func (x *CloudFunction) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *CloudFunction) GetVersionId() int64 {
	if x != nil {
		return x.VersionId
	}
	return 0
}

func (x *CloudFunction) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *CloudFunction) GetEnvironmentVariables() map[string]string {
	if x != nil {
		return x.EnvironmentVariables
	}
	return nil
}

func (x *CloudFunction) GetBuildEnvironmentVariables() map[string]string {
	if x != nil {
		return x.BuildEnvironmentVariables
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/functions/v1/functions.proto.
func (x *CloudFunction) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *CloudFunction) GetMaxInstances() int32 {
	if x != nil {
		return x.MaxInstances
	}
	return 0
}

func (x *CloudFunction) GetMinInstances() int32 {
	if x != nil {
		return x.MinInstances
	}
	return 0
}

func (x *CloudFunction) GetVpcConnector() string {
	if x != nil {
		return x.VpcConnector
	}
	return ""
}

func (x *CloudFunction) GetVpcConnectorEgressSettings() CloudFunction_VpcConnectorEgressSettings {
	if x != nil {
		return x.VpcConnectorEgressSettings
	}
	return CloudFunction_VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED
}

func (x *CloudFunction) GetIngressSettings() CloudFunction_IngressSettings {
	if x != nil {
		return x.IngressSettings
	}
	return CloudFunction_INGRESS_SETTINGS_UNSPECIFIED
}

func (x *CloudFunction) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

func (x *CloudFunction) GetBuildWorkerPool() string {
	if x != nil {
		return x.BuildWorkerPool
	}
	return ""
}

func (x *CloudFunction) GetBuildId() string {
	if x != nil {
		return x.BuildId
	}
	return ""
}

func (x *CloudFunction) GetBuildName() string {
	if x != nil {
		return x.BuildName
	}
	return ""
}

func (x *CloudFunction) GetSecretEnvironmentVariables() []*SecretEnvVar {
	if x != nil {
		return x.SecretEnvironmentVariables
	}
	return nil
}

func (x *CloudFunction) GetSecretVolumes() []*SecretVolume {
	if x != nil {
		return x.SecretVolumes
	}
	return nil
}

func (x *CloudFunction) GetSourceToken() string {
	if x != nil {
		return x.SourceToken
	}
	return ""
}

func (x *CloudFunction) GetDockerRepository() string {
	if x != nil {
		return x.DockerRepository
	}
	return ""
}

func (x *CloudFunction) GetDockerRegistry() CloudFunction_DockerRegistry {
	if x != nil {
		return x.DockerRegistry
	}
	return CloudFunction_DOCKER_REGISTRY_UNSPECIFIED
}

func (m *CloudFunction) GetRuntimeUpdatePolicy() isCloudFunction_RuntimeUpdatePolicy {
	if m != nil {
		return m.RuntimeUpdatePolicy
	}
	return nil
}

func (x *CloudFunction) GetAutomaticUpdatePolicy() *CloudFunction_AutomaticUpdatePolicy {
	if x, ok := x.GetRuntimeUpdatePolicy().(*CloudFunction_AutomaticUpdatePolicy_); ok {
		return x.AutomaticUpdatePolicy
	}
	return nil
}

func (x *CloudFunction) GetOnDeployUpdatePolicy() *CloudFunction_OnDeployUpdatePolicy {
	if x, ok := x.GetRuntimeUpdatePolicy().(*CloudFunction_OnDeployUpdatePolicy_); ok {
		return x.OnDeployUpdatePolicy
	}
	return nil
}

type isCloudFunction_SourceCode interface {
	isCloudFunction_SourceCode()
}

type CloudFunction_SourceArchiveUrl struct {
	// The Google Cloud Storage URL, starting with `gs://`, pointing to the zip
	// archive which contains the function.
	SourceArchiveUrl string `protobuf:"bytes,3,opt,name=source_archive_url,json=sourceArchiveUrl,proto3,oneof"`
}

type CloudFunction_SourceRepository struct {
	// **Beta Feature**
	//
	// The source repository where a function is hosted.
	SourceRepository *SourceRepository `protobuf:"bytes,4,opt,name=source_repository,json=sourceRepository,proto3,oneof"`
}

type CloudFunction_SourceUploadUrl struct {
	// The Google Cloud Storage signed URL used for source uploading, generated
	// by calling [google.cloud.functions.v1.GenerateUploadUrl].
	//
	// The signature is validated on write methods (Create, Update)
	// The signature is stripped from the Function object on read methods (Get,
	// List)
	SourceUploadUrl string `protobuf:"bytes,16,opt,name=source_upload_url,json=sourceUploadUrl,proto3,oneof"`
}

func (*CloudFunction_SourceArchiveUrl) isCloudFunction_SourceCode() {}

func (*CloudFunction_SourceRepository) isCloudFunction_SourceCode() {}

func (*CloudFunction_SourceUploadUrl) isCloudFunction_SourceCode() {}

type isCloudFunction_Trigger interface {
	isCloudFunction_Trigger()
}

type CloudFunction_HttpsTrigger struct {
	// An HTTPS endpoint type of source that can be triggered via URL.
	HttpsTrigger *HttpsTrigger `protobuf:"bytes,5,opt,name=https_trigger,json=httpsTrigger,proto3,oneof"`
}

type CloudFunction_EventTrigger struct {
	// A source that fires events in response to a condition in another service.
	EventTrigger *EventTrigger `protobuf:"bytes,6,opt,name=event_trigger,json=eventTrigger,proto3,oneof"`
}

func (*CloudFunction_HttpsTrigger) isCloudFunction_Trigger() {}

func (*CloudFunction_EventTrigger) isCloudFunction_Trigger() {}

type isCloudFunction_RuntimeUpdatePolicy interface {
	isCloudFunction_RuntimeUpdatePolicy()
}

type CloudFunction_AutomaticUpdatePolicy_ struct {
	// See the comment next to this message for more details.
	AutomaticUpdatePolicy *CloudFunction_AutomaticUpdatePolicy `protobuf:"bytes,40,opt,name=automatic_update_policy,json=automaticUpdatePolicy,proto3,oneof"`
}

type CloudFunction_OnDeployUpdatePolicy_ struct {
	// See the comment next to this message for more details.
	OnDeployUpdatePolicy *CloudFunction_OnDeployUpdatePolicy `protobuf:"bytes,41,opt,name=on_deploy_update_policy,json=onDeployUpdatePolicy,proto3,oneof"`
}

func (*CloudFunction_AutomaticUpdatePolicy_) isCloudFunction_RuntimeUpdatePolicy() {}

func (*CloudFunction_OnDeployUpdatePolicy_) isCloudFunction_RuntimeUpdatePolicy() {}

// Describes SourceRepository, used to represent parameters related to
// source repository where a function is hosted.
type SourceRepository struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URL pointing to the hosted repository where the function is defined.
	// There are supported Cloud Source Repository URLs in the following
	// formats:
	//
	// To refer to a specific commit:
	// `https://source.developers.google.com/projects/*/repos/*/revisions/*/paths/*`
	// To refer to a moveable alias (branch):
	// `https://source.developers.google.com/projects/*/repos/*/moveable-aliases/*/paths/*`
	// In particular, to refer to HEAD use `master` moveable alias.
	// To refer to a specific fixed alias (tag):
	// `https://source.developers.google.com/projects/*/repos/*/fixed-aliases/*/paths/*`
	//
	// You may omit `paths/*` if you want to use the main directory.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// Output only. The URL pointing to the hosted repository where the function
	// were defined at the time of deployment. It always points to a specific
	// commit in the format described above.
	DeployedUrl string `protobuf:"bytes,2,opt,name=deployed_url,json=deployedUrl,proto3" json:"deployed_url,omitempty"`
}

func (x *SourceRepository) Reset() {
	*x = SourceRepository{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SourceRepository) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SourceRepository) ProtoMessage() {}

func (x *SourceRepository) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SourceRepository.ProtoReflect.Descriptor instead.
func (*SourceRepository) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1_functions_proto_rawDescGZIP(), []int{1}
}

func (x *SourceRepository) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *SourceRepository) GetDeployedUrl() string {
	if x != nil {
		return x.DeployedUrl
	}
	return ""
}

// Describes HttpsTrigger, could be used to connect web hooks to function.
type HttpsTrigger struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The deployed URL for the function.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// The security level for the function.
	SecurityLevel HttpsTrigger_SecurityLevel `protobuf:"varint,2,opt,name=security_level,json=securityLevel,proto3,enum=google.cloud.functions.v1.HttpsTrigger_SecurityLevel" json:"security_level,omitempty"`
}

func (x *HttpsTrigger) Reset() {
	*x = HttpsTrigger{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HttpsTrigger) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpsTrigger) ProtoMessage() {}

func (x *HttpsTrigger) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpsTrigger.ProtoReflect.Descriptor instead.
func (*HttpsTrigger) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1_functions_proto_rawDescGZIP(), []int{2}
}

func (x *HttpsTrigger) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *HttpsTrigger) GetSecurityLevel() HttpsTrigger_SecurityLevel {
	if x != nil {
		return x.SecurityLevel
	}
	return HttpsTrigger_SECURITY_LEVEL_UNSPECIFIED
}

// Describes EventTrigger, used to request events be sent from another
// service.
type EventTrigger struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The type of event to observe. For example:
	// `providers/cloud.storage/eventTypes/object.change` and
	// `providers/cloud.pubsub/eventTypes/topic.publish`.
	//
	// Event types match pattern `providers/*/eventTypes/*.*`.
	// The pattern contains:
	//
	//  1. namespace: For example, `cloud.storage` and
	//     `google.firebase.analytics`.
	//  2. resource type: The type of resource on which event occurs. For
	//     example, the Google Cloud Storage API includes the type `object`.
	//  3. action: The action that generates the event. For example, action for
	//     a Google Cloud Storage Object is 'change'.
	//
	// These parts are lower case.
	EventType string `protobuf:"bytes,1,opt,name=event_type,json=eventType,proto3" json:"event_type,omitempty"`
	// Required. The resource(s) from which to observe events, for example,
	// `projects/_/buckets/myBucket`.
	//
	// Not all syntactically correct values are accepted by all services. For
	// example:
	//
	//  1. The authorization model must support it. Google Cloud Functions
	//     only allows EventTriggers to be deployed that observe resources in the
	//     same project as the `CloudFunction`.
	//  2. The resource type must match the pattern expected for an
	//     `event_type`. For example, an `EventTrigger` that has an
	//     `event_type` of "google.pubsub.topic.publish" should have a resource
	//     that matches Google Cloud Pub/Sub topics.
	//
	// Additionally, some services may support short names when creating an
	// `EventTrigger`. These will always be returned in the normalized "long"
	// format.
	//
	// See each *service's* documentation for supported formats.
	Resource string `protobuf:"bytes,2,opt,name=resource,proto3" json:"resource,omitempty"`
	// The hostname of the service that should be observed.
	//
	// If no string is provided, the default service implementing the API will
	// be used. For example, `storage.googleapis.com` is the default for all
	// event types in the `google.storage` namespace.
	Service string `protobuf:"bytes,3,opt,name=service,proto3" json:"service,omitempty"`
	// Specifies policy for failed executions.
	FailurePolicy *FailurePolicy `protobuf:"bytes,5,opt,name=failure_policy,json=failurePolicy,proto3" json:"failure_policy,omitempty"`
}

func (x *EventTrigger) Reset() {
	*x = EventTrigger{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventTrigger) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventTrigger) ProtoMessage() {}

func (x *EventTrigger) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventTrigger.ProtoReflect.Descriptor instead.
func (*EventTrigger) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1_functions_proto_rawDescGZIP(), []int{3}
}

func (x *EventTrigger) GetEventType() string {
	if x != nil {
		return x.EventType
	}
	return ""
}

func (x *EventTrigger) GetResource() string {
	if x != nil {
		return x.Resource
	}
	return ""
}

func (x *EventTrigger) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *EventTrigger) GetFailurePolicy() *FailurePolicy {
	if x != nil {
		return x.FailurePolicy
	}
	return nil
}

// Describes the policy in case of function's execution failure.
// If empty, then defaults to ignoring failures (i.e. not retrying them).
type FailurePolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defines the action taken in case of a function execution failure.
	//
	// Types that are assignable to Action:
	//
	//	*FailurePolicy_Retry_
	Action isFailurePolicy_Action `protobuf_oneof:"action"`
}

func (x *FailurePolicy) Reset() {
	*x = FailurePolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FailurePolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FailurePolicy) ProtoMessage() {}

func (x *FailurePolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FailurePolicy.ProtoReflect.Descriptor instead.
func (*FailurePolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1_functions_proto_rawDescGZIP(), []int{4}
}

func (m *FailurePolicy) GetAction() isFailurePolicy_Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (x *FailurePolicy) GetRetry() *FailurePolicy_Retry {
	if x, ok := x.GetAction().(*FailurePolicy_Retry_); ok {
		return x.Retry
	}
	return nil
}

type isFailurePolicy_Action interface {
	isFailurePolicy_Action()
}

type FailurePolicy_Retry_ struct {
	// If specified, then the function will be retried in case of a failure.
	Retry *FailurePolicy_Retry `protobuf:"bytes,1,opt,name=retry,proto3,oneof"`
}

func (*FailurePolicy_Retry_) isFailurePolicy_Action() {}

// Configuration for a secret environment variable. It has the information
// necessary to fetch the secret value from secret manager and expose it as an
// environment variable.
type SecretEnvVar struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the environment variable.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Project identifier (preferrably project number but can also be the project
	// ID) of the project that contains the secret. If not set, it will be
	// populated with the function's project assuming that the secret exists in
	// the same project as of the function.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Name of the secret in secret manager (not the full resource name).
	Secret string `protobuf:"bytes,3,opt,name=secret,proto3" json:"secret,omitempty"`
	// Version of the secret (version number or the string 'latest'). It is
	// recommended to use a numeric version for secret environment variables as
	// any updates to the secret value is not reflected until new instances start.
	Version string `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *SecretEnvVar) Reset() {
	*x = SecretEnvVar{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecretEnvVar) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretEnvVar) ProtoMessage() {}

func (x *SecretEnvVar) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretEnvVar.ProtoReflect.Descriptor instead.
func (*SecretEnvVar) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1_functions_proto_rawDescGZIP(), []int{5}
}

func (x *SecretEnvVar) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *SecretEnvVar) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *SecretEnvVar) GetSecret() string {
	if x != nil {
		return x.Secret
	}
	return ""
}

func (x *SecretEnvVar) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// Configuration for a secret volume. It has the information necessary to fetch
// the secret value from secret manager and make it available as files mounted
// at the requested paths within the application container. Secret value is not
// a part of the configuration. Every filesystem read operation performs a
// lookup in secret manager to retrieve the secret value.
type SecretVolume struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The path within the container to mount the secret volume. For example,
	// setting the mount_path as `/etc/secrets` would mount the secret value files
	// under the `/etc/secrets` directory. This directory will also be completely
	// shadowed and unavailable to mount any other secrets.
	//
	// Recommended mount paths: /etc/secrets
	// Restricted mount paths: /cloudsql, /dev/log, /pod, /proc, /var/log
	MountPath string `protobuf:"bytes,1,opt,name=mount_path,json=mountPath,proto3" json:"mount_path,omitempty"`
	// Project identifier (preferrably project number but can also be the project
	// ID) of the project that contains the secret. If not set, it will be
	// populated with the function's project assuming that the secret exists in
	// the same project as of the function.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Name of the secret in secret manager (not the full resource name).
	Secret string `protobuf:"bytes,3,opt,name=secret,proto3" json:"secret,omitempty"`
	// List of secret versions to mount for this secret. If empty, the `latest`
	// version of the secret will be made available in a file named after the
	// secret under the mount point.
	Versions []*SecretVolume_SecretVersion `protobuf:"bytes,4,rep,name=versions,proto3" json:"versions,omitempty"`
}

func (x *SecretVolume) Reset() {
	*x = SecretVolume{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecretVolume) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretVolume) ProtoMessage() {}

func (x *SecretVolume) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretVolume.ProtoReflect.Descriptor instead.
func (*SecretVolume) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1_functions_proto_rawDescGZIP(), []int{6}
}

func (x *SecretVolume) GetMountPath() string {
	if x != nil {
		return x.MountPath
	}
	return ""
}

func (x *SecretVolume) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *SecretVolume) GetSecret() string {
	if x != nil {
		return x.Secret
	}
	return ""
}

func (x *SecretVolume) GetVersions() []*SecretVolume_SecretVersion {
	if x != nil {
		return x.Versions
	}
	return nil
}

// Request for the `CreateFunction` method.
type CreateFunctionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location in which the function should be created,
	// specified in the format `projects/*/locations/*`
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// Required. Function to be created.
	Function *CloudFunction `protobuf:"bytes,2,opt,name=function,proto3" json:"function,omitempty"`
}

func (x *CreateFunctionRequest) Reset() {
	*x = CreateFunctionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateFunctionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFunctionRequest) ProtoMessage() {}

func (x *CreateFunctionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFunctionRequest.ProtoReflect.Descriptor instead.
func (*CreateFunctionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1_functions_proto_rawDescGZIP(), []int{7}
}

func (x *CreateFunctionRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *CreateFunctionRequest) GetFunction() *CloudFunction {
	if x != nil {
		return x.Function
	}
	return nil
}

// Request for the `UpdateFunction` method.
type UpdateFunctionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. New version of the function.
	Function *CloudFunction `protobuf:"bytes,1,opt,name=function,proto3" json:"function,omitempty"`
	// Required. The list of fields in `CloudFunction` that have to be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateFunctionRequest) Reset() {
	*x = UpdateFunctionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateFunctionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateFunctionRequest) ProtoMessage() {}

func (x *UpdateFunctionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateFunctionRequest.ProtoReflect.Descriptor instead.
func (*UpdateFunctionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1_functions_proto_rawDescGZIP(), []int{8}
}

func (x *UpdateFunctionRequest) GetFunction() *CloudFunction {
	if x != nil {
		return x.Function
	}
	return nil
}

func (x *UpdateFunctionRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request for the `GetFunction` method.
type GetFunctionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the function which details should be obtained.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The optional version of the function whose details should be
	// obtained. The version of a 1st Gen function is an integer that starts from
	// 1 and gets incremented on redeployments. Each deployment creates a config
	// version of the underlying function. GCF may keep historical configs for old
	// versions. This field can be specified to fetch the historical configs.
	// Leave it blank or set to 0 to get the latest version of the function.
	VersionId int64 `protobuf:"varint,2,opt,name=version_id,json=versionId,proto3" json:"version_id,omitempty"`
}

func (x *GetFunctionRequest) Reset() {
	*x = GetFunctionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetFunctionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFunctionRequest) ProtoMessage() {}

func (x *GetFunctionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFunctionRequest.ProtoReflect.Descriptor instead.
func (*GetFunctionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1_functions_proto_rawDescGZIP(), []int{9}
}

func (x *GetFunctionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetFunctionRequest) GetVersionId() int64 {
	if x != nil {
		return x.VersionId
	}
	return 0
}

// Request for the `ListFunctions` method.
type ListFunctionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The project and location from which the function should be listed,
	// specified in the format `projects/*/locations/*`
	// If you want to list functions in all locations, use "-" in place of a
	// location. When listing functions in all locations, if one or more
	// location(s) are unreachable, the response will contain functions from all
	// reachable locations along with the names of any unreachable locations.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of functions to return per call.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last
	// `ListFunctionsResponse`; indicates that
	// this is a continuation of a prior `ListFunctions` call, and that the
	// system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListFunctionsRequest) Reset() {
	*x = ListFunctionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFunctionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFunctionsRequest) ProtoMessage() {}

func (x *ListFunctionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFunctionsRequest.ProtoReflect.Descriptor instead.
func (*ListFunctionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1_functions_proto_rawDescGZIP(), []int{10}
}

func (x *ListFunctionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListFunctionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListFunctionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for the `ListFunctions` method.
type ListFunctionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The functions that match the request.
	Functions []*CloudFunction `protobuf:"bytes,1,rep,name=functions,proto3" json:"functions,omitempty"`
	// If not empty, indicates that there may be more functions that match
	// the request; this value should be passed in a new
	// [google.cloud.functions.v1.ListFunctionsRequest][google.cloud.functions.v1.ListFunctionsRequest]
	// to get more functions.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached. The response does not include any
	// functions from these locations.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListFunctionsResponse) Reset() {
	*x = ListFunctionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFunctionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFunctionsResponse) ProtoMessage() {}

func (x *ListFunctionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFunctionsResponse.ProtoReflect.Descriptor instead.
func (*ListFunctionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1_functions_proto_rawDescGZIP(), []int{11}
}

func (x *ListFunctionsResponse) GetFunctions() []*CloudFunction {
	if x != nil {
		return x.Functions
	}
	return nil
}

func (x *ListFunctionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListFunctionsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for the `DeleteFunction` method.
type DeleteFunctionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the function which should be deleted.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteFunctionRequest) Reset() {
	*x = DeleteFunctionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteFunctionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFunctionRequest) ProtoMessage() {}

func (x *DeleteFunctionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFunctionRequest.ProtoReflect.Descriptor instead.
func (*DeleteFunctionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1_functions_proto_rawDescGZIP(), []int{12}
}

func (x *DeleteFunctionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for the `CallFunction` method.
type CallFunctionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the function to be called.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Input to be passed to the function.
	Data string `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
}

func (x *CallFunctionRequest) Reset() {
	*x = CallFunctionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CallFunctionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CallFunctionRequest) ProtoMessage() {}

func (x *CallFunctionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CallFunctionRequest.ProtoReflect.Descriptor instead.
func (*CallFunctionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1_functions_proto_rawDescGZIP(), []int{13}
}

func (x *CallFunctionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CallFunctionRequest) GetData() string {
	if x != nil {
		return x.Data
	}
	return ""
}

// Response of `CallFunction` method.
type CallFunctionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Execution id of function invocation.
	ExecutionId string `protobuf:"bytes,1,opt,name=execution_id,json=executionId,proto3" json:"execution_id,omitempty"`
	// Result populated for successful execution of synchronous function. Will
	// not be populated if function does not return a result through context.
	Result string `protobuf:"bytes,2,opt,name=result,proto3" json:"result,omitempty"`
	// Either system or user-function generated error. Set if execution
	// was not successful.
	Error string `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *CallFunctionResponse) Reset() {
	*x = CallFunctionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CallFunctionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CallFunctionResponse) ProtoMessage() {}

func (x *CallFunctionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CallFunctionResponse.ProtoReflect.Descriptor instead.
func (*CallFunctionResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1_functions_proto_rawDescGZIP(), []int{14}
}

func (x *CallFunctionResponse) GetExecutionId() string {
	if x != nil {
		return x.ExecutionId
	}
	return ""
}

func (x *CallFunctionResponse) GetResult() string {
	if x != nil {
		return x.Result
	}
	return ""
}

func (x *CallFunctionResponse) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

// Request of `GenerateSourceUploadUrl` method.
type GenerateUploadUrlRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The project and location in which the Google Cloud Storage signed URL
	// should be generated, specified in the format `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Resource name of a KMS crypto key (managed by the user) used to
	// encrypt/decrypt function source code objects in intermediate Cloud Storage
	// buckets. When you generate an upload url and upload your source code, it
	// gets copied to an intermediate Cloud Storage bucket. The source code is
	// then copied to a versioned directory in the sources bucket in the consumer
	// project during the function deployment.
	//
	// It must match the pattern
	// `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
	//
	// The Google Cloud Functions service account
	// (service-{project_number}@gcf-admin-robot.iam.gserviceaccount.com) must be
	// granted the role 'Cloud KMS CryptoKey Encrypter/Decrypter
	// (roles/cloudkms.cryptoKeyEncrypterDecrypter)' on the
	// Key/KeyRing/Project/Organization (least access preferred). GCF will
	// delegate access to the Google Storage service account in the internal
	// project.
	KmsKeyName string `protobuf:"bytes,2,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
}

func (x *GenerateUploadUrlRequest) Reset() {
	*x = GenerateUploadUrlRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateUploadUrlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateUploadUrlRequest) ProtoMessage() {}

func (x *GenerateUploadUrlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateUploadUrlRequest.ProtoReflect.Descriptor instead.
func (*GenerateUploadUrlRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1_functions_proto_rawDescGZIP(), []int{15}
}

func (x *GenerateUploadUrlRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *GenerateUploadUrlRequest) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

// Response of `GenerateSourceUploadUrl` method.
type GenerateUploadUrlResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The generated Google Cloud Storage signed URL that should be used for a
	// function source code upload. The uploaded file should be a zip archive
	// which contains a function.
	UploadUrl string `protobuf:"bytes,1,opt,name=upload_url,json=uploadUrl,proto3" json:"upload_url,omitempty"`
}

func (x *GenerateUploadUrlResponse) Reset() {
	*x = GenerateUploadUrlResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateUploadUrlResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateUploadUrlResponse) ProtoMessage() {}

func (x *GenerateUploadUrlResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateUploadUrlResponse.ProtoReflect.Descriptor instead.
func (*GenerateUploadUrlResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1_functions_proto_rawDescGZIP(), []int{16}
}

func (x *GenerateUploadUrlResponse) GetUploadUrl() string {
	if x != nil {
		return x.UploadUrl
	}
	return ""
}

// Request of `GenerateDownloadUrl` method.
type GenerateDownloadUrlRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of function for which source code Google Cloud Storage signed
	// URL should be generated.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The optional version of function. If not set, default, current version
	// is used.
	VersionId uint64 `protobuf:"varint,2,opt,name=version_id,json=versionId,proto3" json:"version_id,omitempty"`
}

func (x *GenerateDownloadUrlRequest) Reset() {
	*x = GenerateDownloadUrlRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateDownloadUrlRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateDownloadUrlRequest) ProtoMessage() {}

func (x *GenerateDownloadUrlRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateDownloadUrlRequest.ProtoReflect.Descriptor instead.
func (*GenerateDownloadUrlRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1_functions_proto_rawDescGZIP(), []int{17}
}

func (x *GenerateDownloadUrlRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GenerateDownloadUrlRequest) GetVersionId() uint64 {
	if x != nil {
		return x.VersionId
	}
	return 0
}

// Response of `GenerateDownloadUrl` method.
type GenerateDownloadUrlResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The generated Google Cloud Storage signed URL that should be used for
	// function source code download.
	DownloadUrl string `protobuf:"bytes,1,opt,name=download_url,json=downloadUrl,proto3" json:"download_url,omitempty"`
}

func (x *GenerateDownloadUrlResponse) Reset() {
	*x = GenerateDownloadUrlResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateDownloadUrlResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateDownloadUrlResponse) ProtoMessage() {}

func (x *GenerateDownloadUrlResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateDownloadUrlResponse.ProtoReflect.Descriptor instead.
func (*GenerateDownloadUrlResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1_functions_proto_rawDescGZIP(), []int{18}
}

func (x *GenerateDownloadUrlResponse) GetDownloadUrl() string {
	if x != nil {
		return x.DownloadUrl
	}
	return ""
}

// Security patches are applied automatically to the runtime without requiring
// the function to be redeployed.
type CloudFunction_AutomaticUpdatePolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CloudFunction_AutomaticUpdatePolicy) Reset() {
	*x = CloudFunction_AutomaticUpdatePolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudFunction_AutomaticUpdatePolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudFunction_AutomaticUpdatePolicy) ProtoMessage() {}

func (x *CloudFunction_AutomaticUpdatePolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudFunction_AutomaticUpdatePolicy.ProtoReflect.Descriptor instead.
func (*CloudFunction_AutomaticUpdatePolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1_functions_proto_rawDescGZIP(), []int{0, 0}
}

// Security patches are only applied when a function is redeployed.
type CloudFunction_OnDeployUpdatePolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. contains the runtime version which was used during latest
	// function deployment.
	RuntimeVersion string `protobuf:"bytes,1,opt,name=runtime_version,json=runtimeVersion,proto3" json:"runtime_version,omitempty"`
}

func (x *CloudFunction_OnDeployUpdatePolicy) Reset() {
	*x = CloudFunction_OnDeployUpdatePolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudFunction_OnDeployUpdatePolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudFunction_OnDeployUpdatePolicy) ProtoMessage() {}

func (x *CloudFunction_OnDeployUpdatePolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudFunction_OnDeployUpdatePolicy.ProtoReflect.Descriptor instead.
func (*CloudFunction_OnDeployUpdatePolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1_functions_proto_rawDescGZIP(), []int{0, 1}
}

func (x *CloudFunction_OnDeployUpdatePolicy) GetRuntimeVersion() string {
	if x != nil {
		return x.RuntimeVersion
	}
	return ""
}

// Describes the retry policy in case of function's execution failure.
// A function execution will be retried on any failure.
// A failed execution will be retried up to 7 days with an exponential backoff
// (capped at 10 seconds).
// Retried execution is charged as any other execution.
type FailurePolicy_Retry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *FailurePolicy_Retry) Reset() {
	*x = FailurePolicy_Retry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FailurePolicy_Retry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FailurePolicy_Retry) ProtoMessage() {}

func (x *FailurePolicy_Retry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FailurePolicy_Retry.ProtoReflect.Descriptor instead.
func (*FailurePolicy_Retry) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1_functions_proto_rawDescGZIP(), []int{4, 0}
}

// Configuration for a single version.
type SecretVolume_SecretVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Version of the secret (version number or the string 'latest'). It is
	// preferable to use `latest` version with secret volumes as secret value
	// changes are reflected immediately.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Relative path of the file under the mount path where the secret value for
	// this version will be fetched and made available. For example, setting the
	// mount_path as '/etc/secrets' and path as `/secret_foo` would mount the
	// secret value file at `/etc/secrets/secret_foo`.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *SecretVolume_SecretVersion) Reset() {
	*x = SecretVolume_SecretVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SecretVolume_SecretVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SecretVolume_SecretVersion) ProtoMessage() {}

func (x *SecretVolume_SecretVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_functions_v1_functions_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SecretVolume_SecretVersion.ProtoReflect.Descriptor instead.
func (*SecretVolume_SecretVersion) Descriptor() ([]byte, []int) {
	return file_google_cloud_functions_v1_functions_proto_rawDescGZIP(), []int{6, 0}
}

func (x *SecretVolume_SecretVersion) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *SecretVolume_SecretVersion) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

var File_google_cloud_functions_v1_functions_proto protoreflect.FileDescriptor

var file_google_cloud_functions_v1_functions_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x76, 0x31, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61,
	0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x61, 0x6d, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61,
	0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe8, 0x18, 0x0a, 0x0d, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2e,
	0x0a, 0x12, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65,
	0x5f, 0x75, 0x72, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x10, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x55, 0x72, 0x6c, 0x12, 0x5a,
	0x0a, 0x11, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x48, 0x00, 0x52, 0x10, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x2c, 0x0a, 0x11, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x75, 0x72, 0x6c, 0x18,
	0x10, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x12, 0x4e, 0x0a, 0x0d, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x5f, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70,
	0x73, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x48, 0x01, 0x52, 0x0c, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x4e, 0x0a, 0x0d, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x5f, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x48, 0x01, 0x52, 0x0c, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x4b, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x12, 0x33, 0x0a, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x74, 0x69,
	0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x2e, 0x0a, 0x13, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x6d, 0x62, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x11, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x4d, 0x65, 0x6d,
	0x6f, 0x72, 0x79, 0x4d, 0x62, 0x12, 0x32, 0x0a, 0x15, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x03, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12,
	0x4c, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x77, 0x0a,
	0x15, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x61, 0x72,
	0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x14, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x72,
	0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x87, 0x01, 0x0a, 0x1b, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x5f, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x61, 0x72,
	0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x1c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x45, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x19, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x45, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73,
	0x12, 0x1c, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x12, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x23,
	0x0a, 0x0d, 0x6d, 0x61, 0x78, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18,
	0x14, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x6d, 0x61, 0x78, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x69, 0x6e, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x18, 0x20, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x6d, 0x69, 0x6e, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x70, 0x63, 0x5f,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x16, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x76, 0x70, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x86, 0x01,
	0x0a, 0x1d, 0x76, 0x70, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f,
	0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18,
	0x17, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x56, 0x70, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x45, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x1a, 0x76, 0x70, 0x63, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x63, 0x0a, 0x10, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x6e, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x0f, 0x69, 0x6e, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x48, 0x0a, 0x0c, 0x6b,
	0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x19, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x26, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x4b, 0x65,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x77,
	0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f,
	0x6c, 0x12, 0x1e, 0x0a, 0x08, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x1b, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x49,
	0x64, 0x12, 0x22, 0x0a, 0x0a, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x21, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x69, 0x0a, 0x1c, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f,
	0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x61, 0x72, 0x69,
	0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x1d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x45, 0x6e,
	0x76, 0x56, 0x61, 0x72, 0x52, 0x1a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x45, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73,
	0x12, 0x4e, 0x0a, 0x0e, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x76, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x73, 0x18, 0x1e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x52, 0x0d, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73,
	0x12, 0x26, 0x0a, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x1f, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x0b, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x5c, 0x0a, 0x11, 0x64, 0x6f, 0x63, 0x6b,
	0x65, 0x72, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x22, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2f, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61,
	0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x52, 0x10, 0x64, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x60, 0x0a, 0x0f, 0x64, 0x6f, 0x63, 0x6b, 0x65, 0x72,
	0x5f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x18, 0x23, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x6f, 0x63, 0x6b, 0x65, 0x72,
	0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x52, 0x0e, 0x64, 0x6f, 0x63, 0x6b, 0x65, 0x72,
	0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x12, 0x78, 0x0a, 0x17, 0x61, 0x75, 0x74, 0x6f,
	0x6d, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x18, 0x28, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x48, 0x02, 0x52, 0x15, 0x61, 0x75, 0x74,
	0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x76, 0x0a, 0x17, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x5f,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x29, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4f, 0x6e,
	0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x48, 0x02, 0x52, 0x14, 0x6f, 0x6e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x1a, 0x17, 0x0a, 0x15, 0x41, 0x75,
	0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x1a, 0x44, 0x0a, 0x14, 0x4f, 0x6e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x2c, 0x0a, 0x0f, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x1a, 0x47, 0x0a, 0x19, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x4c, 0x0a,
	0x1e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x75, 0x0a, 0x1a, 0x56,
	0x70, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x45, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x2d, 0x0a, 0x29, 0x56, 0x50, 0x43,
	0x5f, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x4f, 0x52, 0x5f, 0x45, 0x47, 0x52, 0x45, 0x53,
	0x53, 0x5f, 0x53, 0x45, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x50, 0x52, 0x49, 0x56,
	0x41, 0x54, 0x45, 0x5f, 0x52, 0x41, 0x4e, 0x47, 0x45, 0x53, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10,
	0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x4c, 0x4c, 0x5f, 0x54, 0x52, 0x41, 0x46, 0x46, 0x49, 0x43,
	0x10, 0x02, 0x22, 0x78, 0x0a, 0x0f, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x20, 0x0a, 0x1c, 0x49, 0x4e, 0x47, 0x52, 0x45, 0x53, 0x53,
	0x5f, 0x53, 0x45, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x41, 0x4c, 0x4c, 0x4f, 0x57,
	0x5f, 0x41, 0x4c, 0x4c, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x5f,
	0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x02, 0x12,
	0x1b, 0x0a, 0x17, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41,
	0x4c, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x47, 0x43, 0x4c, 0x42, 0x10, 0x03, 0x22, 0x60, 0x0a, 0x0e,
	0x44, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x12, 0x1f,
	0x0a, 0x1b, 0x44, 0x4f, 0x43, 0x4b, 0x45, 0x52, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x53, 0x54, 0x52,
	0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x16, 0x0a, 0x12, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x49, 0x4e, 0x45, 0x52, 0x5f, 0x52, 0x45, 0x47,
	0x49, 0x53, 0x54, 0x52, 0x59, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x41, 0x52, 0x54, 0x49, 0x46,
	0x41, 0x43, 0x54, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x53, 0x54, 0x52, 0x59, 0x10, 0x02, 0x3a, 0x6e,
	0xea, 0x41, 0x6b, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x3c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x42, 0x0d,
	0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x42, 0x09, 0x0a,
	0x07, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x42, 0x17, 0x0a, 0x15, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x22, 0x4c, 0x0a, 0x10, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x65, 0x64, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0b, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x55, 0x72, 0x6c, 0x22,
	0xdc, 0x01, 0x0a, 0x0c, 0x48, 0x74, 0x74, 0x70, 0x73, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72,
	0x12, 0x15, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x5c, 0x0a, 0x0e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70,
	0x73, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x0d, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x4c, 0x65, 0x76, 0x65, 0x6c, 0x22, 0x57, 0x0a, 0x0d, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x1e, 0x0a, 0x1a, 0x53, 0x45, 0x43, 0x55, 0x52, 0x49,
	0x54, 0x59, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x45, 0x43, 0x55, 0x52, 0x45,
	0x5f, 0x41, 0x4c, 0x57, 0x41, 0x59, 0x53, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x53, 0x45, 0x43,
	0x55, 0x52, 0x45, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x10, 0x02, 0x22, 0xb4,
	0x01, 0x0a, 0x0c, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12,
	0x1d, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a,
	0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0x4f, 0x0a, 0x0e, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0d, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x6a, 0x0a, 0x0d, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x46, 0x0a, 0x05, 0x72, 0x65, 0x74, 0x72, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x52, 0x65, 0x74, 0x72, 0x79, 0x48, 0x00, 0x52, 0x05, 0x72, 0x65, 0x74, 0x72, 0x79, 0x1a, 0x07,
	0x0a, 0x05, 0x52, 0x65, 0x74, 0x72, 0x79, 0x42, 0x08, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x71, 0x0a, 0x0c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x45, 0x6e, 0x76, 0x56, 0x61,
	0x72, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x49, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x22, 0xf6, 0x01, 0x0a, 0x0c, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56,
	0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x70,
	0x61, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6d, 0x6f, 0x75, 0x6e, 0x74,
	0x50, 0x61, 0x74, 0x68, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x51, 0x0a, 0x08, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x3d,
	0x0a, 0x0d, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74,
	0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x22, 0xa9, 0x01,
	0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x49,
	0x0a, 0x08, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x08, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9f, 0x01, 0x0a, 0x15, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x08, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x81, 0x01, 0x0a, 0x12,
	0x47, 0x65, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22,
	0x92, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa9, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46,
	0x0a, 0x09, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x66, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20,
	0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x22, 0x60, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a,
	0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x77, 0x0a, 0x13, 0x43, 0x61, 0x6c, 0x6c, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a,
	0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x22, 0x67, 0x0a, 0x14, 0x43,
	0x61, 0x6c, 0x6c, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x65, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x14,
	0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x22, 0x7c, 0x0a, 0x18, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x48, 0x0a, 0x0c, 0x6b, 0x6d, 0x73, 0x5f,
	0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26,
	0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79,
	0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x22, 0x3a, 0x0a, 0x19, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x55, 0x70,
	0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x22, 0x4f,
	0x0a, 0x1a, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f,
	0x61, 0x64, 0x55, 0x72, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x09, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x22,
	0x40, 0x0a, 0x1b, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x77, 0x6e, 0x6c,
	0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x21,
	0x0a, 0x0c, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72,
	0x6c, 0x2a, 0x92, 0x01, 0x0a, 0x13, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x25, 0x0a, 0x21, 0x43, 0x4c, 0x4f,
	0x55, 0x44, 0x5f, 0x46, 0x55, 0x4e, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54,
	0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07,
	0x4f, 0x46, 0x46, 0x4c, 0x49, 0x4e, 0x45, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12, 0x44, 0x45, 0x50,
	0x4c, 0x4f, 0x59, 0x5f, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10,
	0x03, 0x12, 0x16, 0x0a, 0x12, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x49, 0x4e, 0x5f, 0x50,
	0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b,
	0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x05, 0x32, 0x97, 0x11, 0x0a, 0x15, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x12, 0xa9, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x35, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xa4, 0x01, 0x0a,
	0x0b, 0x47, 0x65, 0x74, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x46, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x3c, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xdf, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7c, 0xca, 0x41, 0x24, 0x0a, 0x0d, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x13, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x56, 0x31,
	0xda, 0x41, 0x11, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x3a, 0x08, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xdd, 0x01, 0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7a, 0xca, 0x41, 0x24, 0x0a, 0x0d,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x13, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x56, 0x31, 0xda, 0x41, 0x08, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x42, 0x3a, 0x08, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x32, 0x36, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xce, 0x01, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6b, 0xca, 0x41, 0x2c, 0x0a, 0x15,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x13, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x56, 0x31, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x2a, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xba, 0x01, 0x0a, 0x0c, 0x43, 0x61, 0x6c, 0x6c, 0x46,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x49, 0xda, 0x41, 0x09, 0x6e, 0x61, 0x6d,
	0x65, 0x2c, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x3a, 0x01, 0x2a, 0x22,
	0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63,
	0x61, 0x6c, 0x6c, 0x12, 0xca, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x55, 0x70,
	0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x3a, 0x01, 0x2a, 0x22,
	0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c,
	0x12, 0xd2, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x77,
	0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x77,
	0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x55, 0x72, 0x6c, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x3a,
	0x01, 0x2a, 0x22, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x6f,
	0x61, 0x64, 0x55, 0x72, 0x6c, 0x12, 0x94, 0x01, 0x0a, 0x0c, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x22, 0x49, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x3a, 0x01, 0x2a, 0x22, 0x3e, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x73, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x91, 0x01, 0x0a,
	0x0c, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x46, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40,
	0x12, 0x3e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0xba, 0x01, 0x0a, 0x12, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4f, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x49, 0x3a, 0x01, 0x2a, 0x22, 0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x66, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x74, 0x65, 0x73, 0x74, 0x49,
	0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x51, 0xca,
	0x41, 0x1d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2,
	0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x42, 0xe1, 0x02, 0xea, 0x41, 0x6f, 0x0a, 0x2a, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f,
	0x72, 0x79, 0x12, 0x41, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69,
	0x74, 0x6f, 0x72, 0x79, 0x7d, 0xea, 0x41, 0x78, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b,
	0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x12, 0x53, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6b, 0x65, 0x79, 0x52, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x6b,
	0x65, 0x79, 0x5f, 0x72, 0x69, 0x6e, 0x67, 0x7d, 0x2f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b,
	0x65, 0x79, 0x73, 0x2f, 0x7b, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x7d,
	0x0a, 0x1d, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x42,
	0x0e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x3b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x70, 0x62, 0x3b, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x70, 0x62, 0xa2, 0x02,
	0x03, 0x47, 0x43, 0x46, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_functions_v1_functions_proto_rawDescOnce sync.Once
	file_google_cloud_functions_v1_functions_proto_rawDescData = file_google_cloud_functions_v1_functions_proto_rawDesc
)

func file_google_cloud_functions_v1_functions_proto_rawDescGZIP() []byte {
	file_google_cloud_functions_v1_functions_proto_rawDescOnce.Do(func() {
		file_google_cloud_functions_v1_functions_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_functions_v1_functions_proto_rawDescData)
	})
	return file_google_cloud_functions_v1_functions_proto_rawDescData
}

var file_google_cloud_functions_v1_functions_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_cloud_functions_v1_functions_proto_msgTypes = make([]protoimpl.MessageInfo, 26)
var file_google_cloud_functions_v1_functions_proto_goTypes = []interface{}{
	(CloudFunctionStatus)(0),                      // 0: google.cloud.functions.v1.CloudFunctionStatus
	(CloudFunction_VpcConnectorEgressSettings)(0), // 1: google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings
	(CloudFunction_IngressSettings)(0),            // 2: google.cloud.functions.v1.CloudFunction.IngressSettings
	(CloudFunction_DockerRegistry)(0),             // 3: google.cloud.functions.v1.CloudFunction.DockerRegistry
	(HttpsTrigger_SecurityLevel)(0),               // 4: google.cloud.functions.v1.HttpsTrigger.SecurityLevel
	(*CloudFunction)(nil),                         // 5: google.cloud.functions.v1.CloudFunction
	(*SourceRepository)(nil),                      // 6: google.cloud.functions.v1.SourceRepository
	(*HttpsTrigger)(nil),                          // 7: google.cloud.functions.v1.HttpsTrigger
	(*EventTrigger)(nil),                          // 8: google.cloud.functions.v1.EventTrigger
	(*FailurePolicy)(nil),                         // 9: google.cloud.functions.v1.FailurePolicy
	(*SecretEnvVar)(nil),                          // 10: google.cloud.functions.v1.SecretEnvVar
	(*SecretVolume)(nil),                          // 11: google.cloud.functions.v1.SecretVolume
	(*CreateFunctionRequest)(nil),                 // 12: google.cloud.functions.v1.CreateFunctionRequest
	(*UpdateFunctionRequest)(nil),                 // 13: google.cloud.functions.v1.UpdateFunctionRequest
	(*GetFunctionRequest)(nil),                    // 14: google.cloud.functions.v1.GetFunctionRequest
	(*ListFunctionsRequest)(nil),                  // 15: google.cloud.functions.v1.ListFunctionsRequest
	(*ListFunctionsResponse)(nil),                 // 16: google.cloud.functions.v1.ListFunctionsResponse
	(*DeleteFunctionRequest)(nil),                 // 17: google.cloud.functions.v1.DeleteFunctionRequest
	(*CallFunctionRequest)(nil),                   // 18: google.cloud.functions.v1.CallFunctionRequest
	(*CallFunctionResponse)(nil),                  // 19: google.cloud.functions.v1.CallFunctionResponse
	(*GenerateUploadUrlRequest)(nil),              // 20: google.cloud.functions.v1.GenerateUploadUrlRequest
	(*GenerateUploadUrlResponse)(nil),             // 21: google.cloud.functions.v1.GenerateUploadUrlResponse
	(*GenerateDownloadUrlRequest)(nil),            // 22: google.cloud.functions.v1.GenerateDownloadUrlRequest
	(*GenerateDownloadUrlResponse)(nil),           // 23: google.cloud.functions.v1.GenerateDownloadUrlResponse
	(*CloudFunction_AutomaticUpdatePolicy)(nil),   // 24: google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy
	(*CloudFunction_OnDeployUpdatePolicy)(nil),    // 25: google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy
	nil,                                      // 26: google.cloud.functions.v1.CloudFunction.LabelsEntry
	nil,                                      // 27: google.cloud.functions.v1.CloudFunction.EnvironmentVariablesEntry
	nil,                                      // 28: google.cloud.functions.v1.CloudFunction.BuildEnvironmentVariablesEntry
	(*FailurePolicy_Retry)(nil),              // 29: google.cloud.functions.v1.FailurePolicy.Retry
	(*SecretVolume_SecretVersion)(nil),       // 30: google.cloud.functions.v1.SecretVolume.SecretVersion
	(*durationpb.Duration)(nil),              // 31: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil),            // 32: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),            // 33: google.protobuf.FieldMask
	(*iampb.SetIamPolicyRequest)(nil),        // 34: google.iam.v1.SetIamPolicyRequest
	(*iampb.GetIamPolicyRequest)(nil),        // 35: google.iam.v1.GetIamPolicyRequest
	(*iampb.TestIamPermissionsRequest)(nil),  // 36: google.iam.v1.TestIamPermissionsRequest
	(*longrunningpb.Operation)(nil),          // 37: google.longrunning.Operation
	(*iampb.Policy)(nil),                     // 38: google.iam.v1.Policy
	(*iampb.TestIamPermissionsResponse)(nil), // 39: google.iam.v1.TestIamPermissionsResponse
}
var file_google_cloud_functions_v1_functions_proto_depIdxs = []int32{
	6,  // 0: google.cloud.functions.v1.CloudFunction.source_repository:type_name -> google.cloud.functions.v1.SourceRepository
	7,  // 1: google.cloud.functions.v1.CloudFunction.https_trigger:type_name -> google.cloud.functions.v1.HttpsTrigger
	8,  // 2: google.cloud.functions.v1.CloudFunction.event_trigger:type_name -> google.cloud.functions.v1.EventTrigger
	0,  // 3: google.cloud.functions.v1.CloudFunction.status:type_name -> google.cloud.functions.v1.CloudFunctionStatus
	31, // 4: google.cloud.functions.v1.CloudFunction.timeout:type_name -> google.protobuf.Duration
	32, // 5: google.cloud.functions.v1.CloudFunction.update_time:type_name -> google.protobuf.Timestamp
	26, // 6: google.cloud.functions.v1.CloudFunction.labels:type_name -> google.cloud.functions.v1.CloudFunction.LabelsEntry
	27, // 7: google.cloud.functions.v1.CloudFunction.environment_variables:type_name -> google.cloud.functions.v1.CloudFunction.EnvironmentVariablesEntry
	28, // 8: google.cloud.functions.v1.CloudFunction.build_environment_variables:type_name -> google.cloud.functions.v1.CloudFunction.BuildEnvironmentVariablesEntry
	1,  // 9: google.cloud.functions.v1.CloudFunction.vpc_connector_egress_settings:type_name -> google.cloud.functions.v1.CloudFunction.VpcConnectorEgressSettings
	2,  // 10: google.cloud.functions.v1.CloudFunction.ingress_settings:type_name -> google.cloud.functions.v1.CloudFunction.IngressSettings
	10, // 11: google.cloud.functions.v1.CloudFunction.secret_environment_variables:type_name -> google.cloud.functions.v1.SecretEnvVar
	11, // 12: google.cloud.functions.v1.CloudFunction.secret_volumes:type_name -> google.cloud.functions.v1.SecretVolume
	3,  // 13: google.cloud.functions.v1.CloudFunction.docker_registry:type_name -> google.cloud.functions.v1.CloudFunction.DockerRegistry
	24, // 14: google.cloud.functions.v1.CloudFunction.automatic_update_policy:type_name -> google.cloud.functions.v1.CloudFunction.AutomaticUpdatePolicy
	25, // 15: google.cloud.functions.v1.CloudFunction.on_deploy_update_policy:type_name -> google.cloud.functions.v1.CloudFunction.OnDeployUpdatePolicy
	4,  // 16: google.cloud.functions.v1.HttpsTrigger.security_level:type_name -> google.cloud.functions.v1.HttpsTrigger.SecurityLevel
	9,  // 17: google.cloud.functions.v1.EventTrigger.failure_policy:type_name -> google.cloud.functions.v1.FailurePolicy
	29, // 18: google.cloud.functions.v1.FailurePolicy.retry:type_name -> google.cloud.functions.v1.FailurePolicy.Retry
	30, // 19: google.cloud.functions.v1.SecretVolume.versions:type_name -> google.cloud.functions.v1.SecretVolume.SecretVersion
	5,  // 20: google.cloud.functions.v1.CreateFunctionRequest.function:type_name -> google.cloud.functions.v1.CloudFunction
	5,  // 21: google.cloud.functions.v1.UpdateFunctionRequest.function:type_name -> google.cloud.functions.v1.CloudFunction
	33, // 22: google.cloud.functions.v1.UpdateFunctionRequest.update_mask:type_name -> google.protobuf.FieldMask
	5,  // 23: google.cloud.functions.v1.ListFunctionsResponse.functions:type_name -> google.cloud.functions.v1.CloudFunction
	15, // 24: google.cloud.functions.v1.CloudFunctionsService.ListFunctions:input_type -> google.cloud.functions.v1.ListFunctionsRequest
	14, // 25: google.cloud.functions.v1.CloudFunctionsService.GetFunction:input_type -> google.cloud.functions.v1.GetFunctionRequest
	12, // 26: google.cloud.functions.v1.CloudFunctionsService.CreateFunction:input_type -> google.cloud.functions.v1.CreateFunctionRequest
	13, // 27: google.cloud.functions.v1.CloudFunctionsService.UpdateFunction:input_type -> google.cloud.functions.v1.UpdateFunctionRequest
	17, // 28: google.cloud.functions.v1.CloudFunctionsService.DeleteFunction:input_type -> google.cloud.functions.v1.DeleteFunctionRequest
	18, // 29: google.cloud.functions.v1.CloudFunctionsService.CallFunction:input_type -> google.cloud.functions.v1.CallFunctionRequest
	20, // 30: google.cloud.functions.v1.CloudFunctionsService.GenerateUploadUrl:input_type -> google.cloud.functions.v1.GenerateUploadUrlRequest
	22, // 31: google.cloud.functions.v1.CloudFunctionsService.GenerateDownloadUrl:input_type -> google.cloud.functions.v1.GenerateDownloadUrlRequest
	34, // 32: google.cloud.functions.v1.CloudFunctionsService.SetIamPolicy:input_type -> google.iam.v1.SetIamPolicyRequest
	35, // 33: google.cloud.functions.v1.CloudFunctionsService.GetIamPolicy:input_type -> google.iam.v1.GetIamPolicyRequest
	36, // 34: google.cloud.functions.v1.CloudFunctionsService.TestIamPermissions:input_type -> google.iam.v1.TestIamPermissionsRequest
	16, // 35: google.cloud.functions.v1.CloudFunctionsService.ListFunctions:output_type -> google.cloud.functions.v1.ListFunctionsResponse
	5,  // 36: google.cloud.functions.v1.CloudFunctionsService.GetFunction:output_type -> google.cloud.functions.v1.CloudFunction
	37, // 37: google.cloud.functions.v1.CloudFunctionsService.CreateFunction:output_type -> google.longrunning.Operation
	37, // 38: google.cloud.functions.v1.CloudFunctionsService.UpdateFunction:output_type -> google.longrunning.Operation
	37, // 39: google.cloud.functions.v1.CloudFunctionsService.DeleteFunction:output_type -> google.longrunning.Operation
	19, // 40: google.cloud.functions.v1.CloudFunctionsService.CallFunction:output_type -> google.cloud.functions.v1.CallFunctionResponse
	21, // 41: google.cloud.functions.v1.CloudFunctionsService.GenerateUploadUrl:output_type -> google.cloud.functions.v1.GenerateUploadUrlResponse
	23, // 42: google.cloud.functions.v1.CloudFunctionsService.GenerateDownloadUrl:output_type -> google.cloud.functions.v1.GenerateDownloadUrlResponse
	38, // 43: google.cloud.functions.v1.CloudFunctionsService.SetIamPolicy:output_type -> google.iam.v1.Policy
	38, // 44: google.cloud.functions.v1.CloudFunctionsService.GetIamPolicy:output_type -> google.iam.v1.Policy
	39, // 45: google.cloud.functions.v1.CloudFunctionsService.TestIamPermissions:output_type -> google.iam.v1.TestIamPermissionsResponse
	35, // [35:46] is the sub-list for method output_type
	24, // [24:35] is the sub-list for method input_type
	24, // [24:24] is the sub-list for extension type_name
	24, // [24:24] is the sub-list for extension extendee
	0,  // [0:24] is the sub-list for field type_name
}

func init() { file_google_cloud_functions_v1_functions_proto_init() }
func file_google_cloud_functions_v1_functions_proto_init() {
	if File_google_cloud_functions_v1_functions_proto != nil {
		return
	}
	file_google_cloud_functions_v1_operations_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_functions_v1_functions_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudFunction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1_functions_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SourceRepository); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1_functions_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HttpsTrigger); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1_functions_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventTrigger); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1_functions_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FailurePolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1_functions_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecretEnvVar); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1_functions_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecretVolume); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1_functions_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateFunctionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1_functions_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateFunctionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1_functions_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetFunctionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1_functions_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFunctionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1_functions_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFunctionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1_functions_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteFunctionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1_functions_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CallFunctionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1_functions_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CallFunctionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1_functions_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateUploadUrlRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1_functions_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateUploadUrlResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1_functions_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateDownloadUrlRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1_functions_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateDownloadUrlResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1_functions_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudFunction_AutomaticUpdatePolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1_functions_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudFunction_OnDeployUpdatePolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1_functions_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FailurePolicy_Retry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_functions_v1_functions_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SecretVolume_SecretVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_functions_v1_functions_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*CloudFunction_SourceArchiveUrl)(nil),
		(*CloudFunction_SourceRepository)(nil),
		(*CloudFunction_SourceUploadUrl)(nil),
		(*CloudFunction_HttpsTrigger)(nil),
		(*CloudFunction_EventTrigger)(nil),
		(*CloudFunction_AutomaticUpdatePolicy_)(nil),
		(*CloudFunction_OnDeployUpdatePolicy_)(nil),
	}
	file_google_cloud_functions_v1_functions_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*FailurePolicy_Retry_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_functions_v1_functions_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   26,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_functions_v1_functions_proto_goTypes,
		DependencyIndexes: file_google_cloud_functions_v1_functions_proto_depIdxs,
		EnumInfos:         file_google_cloud_functions_v1_functions_proto_enumTypes,
		MessageInfos:      file_google_cloud_functions_v1_functions_proto_msgTypes,
	}.Build()
	File_google_cloud_functions_v1_functions_proto = out.File
	file_google_cloud_functions_v1_functions_proto_rawDesc = nil
	file_google_cloud_functions_v1_functions_proto_goTypes = nil
	file_google_cloud_functions_v1_functions_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CloudFunctionsServiceClient is the client API for CloudFunctionsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CloudFunctionsServiceClient interface {
	// Returns a list of functions that belong to the requested project.
	ListFunctions(ctx context.Context, in *ListFunctionsRequest, opts ...grpc.CallOption) (*ListFunctionsResponse, error)
	// Returns a function with the given name from the requested project.
	GetFunction(ctx context.Context, in *GetFunctionRequest, opts ...grpc.CallOption) (*CloudFunction, error)
	// Creates a new function. If a function with the given name already exists in
	// the specified project, the long running operation will return
	// `ALREADY_EXISTS` error.
	CreateFunction(ctx context.Context, in *CreateFunctionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates existing function.
	UpdateFunction(ctx context.Context, in *UpdateFunctionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a function with the given name from the specified project. If the
	// given function is used by some trigger, the trigger will be updated to
	// remove this function.
	DeleteFunction(ctx context.Context, in *DeleteFunctionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Synchronously invokes a deployed Cloud Function. To be used for testing
	// purposes as very limited traffic is allowed. For more information on
	// the actual limits, refer to
	// [Rate Limits](https://cloud.google.com/functions/quotas#rate_limits).
	CallFunction(ctx context.Context, in *CallFunctionRequest, opts ...grpc.CallOption) (*CallFunctionResponse, error)
	// Returns a signed URL for uploading a function source code.
	// For more information about the signed URL usage see:
	// https://cloud.google.com/storage/docs/access-control/signed-urls.
	// Once the function source code upload is complete, the used signed
	// URL should be provided in CreateFunction or UpdateFunction request
	// as a reference to the function source code.
	//
	// When uploading source code to the generated signed URL, please follow
	// these restrictions:
	//
	//   - Source file type should be a zip file.
	//   - Source file size should not exceed 100MB limit.
	//   - No credentials should be attached - the signed URLs provide access to the
	//     target bucket using internal service identity; if credentials were
	//     attached, the identity from the credentials would be used, but that
	//     identity does not have permissions to upload files to the URL.
	//
	// When making a HTTP PUT request, these two headers need to be specified:
	//
	// * `content-type: application/zip`
	// * `x-goog-content-length-range: 0,104857600`
	//
	// And this header SHOULD NOT be specified:
	//
	// * `Authorization: Bearer YOUR_TOKEN`
	GenerateUploadUrl(ctx context.Context, in *GenerateUploadUrlRequest, opts ...grpc.CallOption) (*GenerateUploadUrlResponse, error)
	// Returns a signed URL for downloading deployed function source code.
	// The URL is only valid for a limited period and should be used within
	// minutes after generation.
	// For more information about the signed URL usage see:
	// https://cloud.google.com/storage/docs/access-control/signed-urls
	GenerateDownloadUrl(ctx context.Context, in *GenerateDownloadUrlRequest, opts ...grpc.CallOption) (*GenerateDownloadUrlResponse, error)
	// Sets the IAM access control policy on the specified function.
	// Replaces any existing policy.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Gets the IAM access control policy for a function.
	// Returns an empty policy if the function exists and does not have a policy
	// set.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Tests the specified permissions against the IAM access control policy
	// for a function.
	// If the function does not exist, this will return an empty set of
	// permissions, not a NOT_FOUND error.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
}

type cloudFunctionsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCloudFunctionsServiceClient(cc grpc.ClientConnInterface) CloudFunctionsServiceClient {
	return &cloudFunctionsServiceClient{cc}
}

func (c *cloudFunctionsServiceClient) ListFunctions(ctx context.Context, in *ListFunctionsRequest, opts ...grpc.CallOption) (*ListFunctionsResponse, error) {
	out := new(ListFunctionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1.CloudFunctionsService/ListFunctions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) GetFunction(ctx context.Context, in *GetFunctionRequest, opts ...grpc.CallOption) (*CloudFunction, error) {
	out := new(CloudFunction)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1.CloudFunctionsService/GetFunction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) CreateFunction(ctx context.Context, in *CreateFunctionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1.CloudFunctionsService/CreateFunction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) UpdateFunction(ctx context.Context, in *UpdateFunctionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1.CloudFunctionsService/UpdateFunction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) DeleteFunction(ctx context.Context, in *DeleteFunctionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1.CloudFunctionsService/DeleteFunction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) CallFunction(ctx context.Context, in *CallFunctionRequest, opts ...grpc.CallOption) (*CallFunctionResponse, error) {
	out := new(CallFunctionResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1.CloudFunctionsService/CallFunction", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) GenerateUploadUrl(ctx context.Context, in *GenerateUploadUrlRequest, opts ...grpc.CallOption) (*GenerateUploadUrlResponse, error) {
	out := new(GenerateUploadUrlResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1.CloudFunctionsService/GenerateUploadUrl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) GenerateDownloadUrl(ctx context.Context, in *GenerateDownloadUrlRequest, opts ...grpc.CallOption) (*GenerateDownloadUrlResponse, error) {
	out := new(GenerateDownloadUrlResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1.CloudFunctionsService/GenerateDownloadUrl", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1.CloudFunctionsService/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1.CloudFunctionsService/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFunctionsServiceClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.functions.v1.CloudFunctionsService/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudFunctionsServiceServer is the server API for CloudFunctionsService service.
type CloudFunctionsServiceServer interface {
	// Returns a list of functions that belong to the requested project.
	ListFunctions(context.Context, *ListFunctionsRequest) (*ListFunctionsResponse, error)
	// Returns a function with the given name from the requested project.
	GetFunction(context.Context, *GetFunctionRequest) (*CloudFunction, error)
	// Creates a new function. If a function with the given name already exists in
	// the specified project, the long running operation will return
	// `ALREADY_EXISTS` error.
	CreateFunction(context.Context, *CreateFunctionRequest) (*longrunningpb.Operation, error)
	// Updates existing function.
	UpdateFunction(context.Context, *UpdateFunctionRequest) (*longrunningpb.Operation, error)
	// Deletes a function with the given name from the specified project. If the
	// given function is used by some trigger, the trigger will be updated to
	// remove this function.
	DeleteFunction(context.Context, *DeleteFunctionRequest) (*longrunningpb.Operation, error)
	// Synchronously invokes a deployed Cloud Function. To be used for testing
	// purposes as very limited traffic is allowed. For more information on
	// the actual limits, refer to
	// [Rate Limits](https://cloud.google.com/functions/quotas#rate_limits).
	CallFunction(context.Context, *CallFunctionRequest) (*CallFunctionResponse, error)
	// Returns a signed URL for uploading a function source code.
	// For more information about the signed URL usage see:
	// https://cloud.google.com/storage/docs/access-control/signed-urls.
	// Once the function source code upload is complete, the used signed
	// URL should be provided in CreateFunction or UpdateFunction request
	// as a reference to the function source code.
	//
	// When uploading source code to the generated signed URL, please follow
	// these restrictions:
	//
	//   - Source file type should be a zip file.
	//   - Source file size should not exceed 100MB limit.
	//   - No credentials should be attached - the signed URLs provide access to the
	//     target bucket using internal service identity; if credentials were
	//     attached, the identity from the credentials would be used, but that
	//     identity does not have permissions to upload files to the URL.
	//
	// When making a HTTP PUT request, these two headers need to be specified:
	//
	// * `content-type: application/zip`
	// * `x-goog-content-length-range: 0,104857600`
	//
	// And this header SHOULD NOT be specified:
	//
	// * `Authorization: Bearer YOUR_TOKEN`
	GenerateUploadUrl(context.Context, *GenerateUploadUrlRequest) (*GenerateUploadUrlResponse, error)
	// Returns a signed URL for downloading deployed function source code.
	// The URL is only valid for a limited period and should be used within
	// minutes after generation.
	// For more information about the signed URL usage see:
	// https://cloud.google.com/storage/docs/access-control/signed-urls
	GenerateDownloadUrl(context.Context, *GenerateDownloadUrlRequest) (*GenerateDownloadUrlResponse, error)
	// Sets the IAM access control policy on the specified function.
	// Replaces any existing policy.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Gets the IAM access control policy for a function.
	// Returns an empty policy if the function exists and does not have a policy
	// set.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Tests the specified permissions against the IAM access control policy
	// for a function.
	// If the function does not exist, this will return an empty set of
	// permissions, not a NOT_FOUND error.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
}

// UnimplementedCloudFunctionsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedCloudFunctionsServiceServer struct {
}

func (*UnimplementedCloudFunctionsServiceServer) ListFunctions(context.Context, *ListFunctionsRequest) (*ListFunctionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFunctions not implemented")
}
func (*UnimplementedCloudFunctionsServiceServer) GetFunction(context.Context, *GetFunctionRequest) (*CloudFunction, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFunction not implemented")
}
func (*UnimplementedCloudFunctionsServiceServer) CreateFunction(context.Context, *CreateFunctionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFunction not implemented")
}
func (*UnimplementedCloudFunctionsServiceServer) UpdateFunction(context.Context, *UpdateFunctionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFunction not implemented")
}
func (*UnimplementedCloudFunctionsServiceServer) DeleteFunction(context.Context, *DeleteFunctionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFunction not implemented")
}
func (*UnimplementedCloudFunctionsServiceServer) CallFunction(context.Context, *CallFunctionRequest) (*CallFunctionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CallFunction not implemented")
}
func (*UnimplementedCloudFunctionsServiceServer) GenerateUploadUrl(context.Context, *GenerateUploadUrlRequest) (*GenerateUploadUrlResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateUploadUrl not implemented")
}
func (*UnimplementedCloudFunctionsServiceServer) GenerateDownloadUrl(context.Context, *GenerateDownloadUrlRequest) (*GenerateDownloadUrlResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateDownloadUrl not implemented")
}
func (*UnimplementedCloudFunctionsServiceServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedCloudFunctionsServiceServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedCloudFunctionsServiceServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

func RegisterCloudFunctionsServiceServer(s *grpc.Server, srv CloudFunctionsServiceServer) {
	s.RegisterService(&_CloudFunctionsService_serviceDesc, srv)
}

func _CloudFunctionsService_ListFunctions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFunctionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).ListFunctions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1.CloudFunctionsService/ListFunctions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).ListFunctions(ctx, req.(*ListFunctionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_GetFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).GetFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1.CloudFunctionsService/GetFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).GetFunction(ctx, req.(*GetFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_CreateFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).CreateFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1.CloudFunctionsService/CreateFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).CreateFunction(ctx, req.(*CreateFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_UpdateFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).UpdateFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1.CloudFunctionsService/UpdateFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).UpdateFunction(ctx, req.(*UpdateFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_DeleteFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).DeleteFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1.CloudFunctionsService/DeleteFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).DeleteFunction(ctx, req.(*DeleteFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_CallFunction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CallFunctionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).CallFunction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1.CloudFunctionsService/CallFunction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).CallFunction(ctx, req.(*CallFunctionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_GenerateUploadUrl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateUploadUrlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).GenerateUploadUrl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1.CloudFunctionsService/GenerateUploadUrl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).GenerateUploadUrl(ctx, req.(*GenerateUploadUrlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_GenerateDownloadUrl_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateDownloadUrlRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).GenerateDownloadUrl(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1.CloudFunctionsService/GenerateDownloadUrl",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).GenerateDownloadUrl(ctx, req.(*GenerateDownloadUrlRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1.CloudFunctionsService/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1.CloudFunctionsService/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFunctionsService_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFunctionsServiceServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.functions.v1.CloudFunctionsService/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFunctionsServiceServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudFunctionsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.functions.v1.CloudFunctionsService",
	HandlerType: (*CloudFunctionsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListFunctions",
			Handler:    _CloudFunctionsService_ListFunctions_Handler,
		},
		{
			MethodName: "GetFunction",
			Handler:    _CloudFunctionsService_GetFunction_Handler,
		},
		{
			MethodName: "CreateFunction",
			Handler:    _CloudFunctionsService_CreateFunction_Handler,
		},
		{
			MethodName: "UpdateFunction",
			Handler:    _CloudFunctionsService_UpdateFunction_Handler,
		},
		{
			MethodName: "DeleteFunction",
			Handler:    _CloudFunctionsService_DeleteFunction_Handler,
		},
		{
			MethodName: "CallFunction",
			Handler:    _CloudFunctionsService_CallFunction_Handler,
		},
		{
			MethodName: "GenerateUploadUrl",
			Handler:    _CloudFunctionsService_GenerateUploadUrl_Handler,
		},
		{
			MethodName: "GenerateDownloadUrl",
			Handler:    _CloudFunctionsService_GenerateDownloadUrl_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _CloudFunctionsService_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _CloudFunctionsService_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _CloudFunctionsService_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/functions/v1/functions.proto",
}
