// automatically generated by autogen.sh
#include "feenox.h"

int feenox_pde_parse_problem_type(const char *token) {

///kw_pde+PROBLEM+desc Ask FeenoX to solve a partial differential equation problem.
///kw_pde+PROBLEM+usage PROBLEM
///kw_pde+PROBLEM+detail Currently, FeenoX can solve the following types of PDE-casted problems:
///kw_pde+PROBLEM+detail @
///kw_pde+PROBLEM+usage { laplace
///kw_pde+PROBLEM+detail  * `laplace` the Laplace (or Poisson) equation, either steady state or transient
  if (strcasecmp(token, "laplace") == 0) {
    feenox.pde.parse_problem = feenox_problem_parse_problem_laplace;
    
///kw_pde+PROBLEM+usage | mechanical
///kw_pde+PROBLEM+detail  * `mechanical` steady-state solid mechanics with elastic or hyperelastic materials
  } else if (strcasecmp(token, "mechanical") == 0) {
    feenox.pde.parse_problem = feenox_problem_parse_problem_mechanical;
    
///kw_pde+PROBLEM+usage | modal
///kw_pde+PROBLEM+detail  * `modal` natural mechanical frequencies and modes of oscillation
  } else if (strcasecmp(token, "modal") == 0) {
    feenox.pde.parse_problem = feenox_problem_parse_problem_modal;
    
///kw_pde+PROBLEM+usage | neutron_diffusion
///kw_pde+PROBLEM+detail  * `neutron_diffusion` multi-group core-level neutron diffusion with a FEM formulation 
  } else if (strcasecmp(token, "neutron_diffusion") == 0) {
    feenox.pde.parse_problem = feenox_problem_parse_problem_neutron_diffusion;
    
///kw_pde+PROBLEM+usage | neutron_sn
///kw_pde+PROBLEM+detail  * `neutron_sn` multi-group core-level neutron transport using 
///kw_pde+PROBLEM+detail     - discrete ordinates $S_N$ for angular discretization, and
///kw_pde+PROBLEM+detail     - isoparametric finite elements for spatial discretization.
  } else if (strcasecmp(token, "neutron_sn") == 0) {
    feenox.pde.parse_problem = feenox_problem_parse_problem_neutron_sn;
    
///kw_pde+PROBLEM+usage | thermal
///kw_pde+PROBLEM+detail  * `thermal` heat conduction including transients and non-linear conductivity
  } else if (strcasecmp(token, "thermal") == 0) {
    feenox.pde.parse_problem = feenox_problem_parse_problem_thermal;
    
  } else {
    feenox_push_error_message("unknown problem type '%s'", token);
    return FEENOX_ERROR;
      
  }
  
///kw_pde+PROBLEM+usage }@
///kw_pde+PROBLEM+detail @
///kw_pde+PROBLEM+detail > If you are a programmer and want to contribute with another problem type, please do so!
///kw_pde+PROBLEM+detail > Check out the [programming guide in the FeenoX repository](https://github.com/seamplex/feenox/blob/main/doc/programming.md).
///kw_pde+PROBLEM+detail @
    
  return FEENOX_OK;
}
