/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#include "line.h"
#include "dingl.h"

void line::draw () {
  glBegin (GL_LINE_STRIP);
    for (int i = 0, j = points.size(); i < j; ++i) glVertex2f (points[i].x, points[i].y);
  glEnd ();
}

void line::set (int i, int x, int y) {
  points[i].x = x;
  points[i].y = y;
}

void line::insert (int i, int x, int y) {
  points.insert (points.begin() + i, point<int>(x,y));
}

int line::remove (int i) {
  points.erase (points.begin() + i);
  return points.size();
}
