#! /bin/sh

# Copyright (c) 2021 Michael Baeuerle
#
# All rights reserved.
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, and/or sell copies of the Software, and to permit persons
# to whom the Software is furnished to do so, provided that the above
# copyright notice(s) and this permission notice appear in all copies of
# the Software and that both the above copyright notice(s) and this
# permission notice appear in supporting documentation.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
# OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
# HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY
# SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER
# RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
# CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
# CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
# Except as contained in this notice, the name of a copyright holder
# shall not be used in advertising or otherwise to promote the sale, use
# or other dealings in this Software without prior written authorization
# of the copyright holder.
#
# SPDX-License-Identifier: ICU


# Create a <c-lock> element with the canlock utility
# The local secret is loaded from the file "secret_512bits".

# User-ID   : testuser
# Message-ID: <ThisIsAMessageID@example.org>
#
# Note that RFC 8315 uses angle brackets like quotes in the continuous text.
# Therefore <uid> or <mid> does not mean that additional angle brackets are
# required. A User-ID must not contain angle brackets and a Message-ID always
# includes angle brackets (as defined by RFC 5536 in Section 3.1.3).
LOCK=$(canlock -a sha512 -l 'testuser<ThisIsAMessageID@example.org>' \
       <secret_512bits)


# Print (initial) Cancel-Lock header field
#
# For insertion into a message header, the canonical line termination CRLF
# must be used instead.
printf "Cancel-Lock: %s\n" "$LOCK"


# EOF
