/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 12:34:45 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.Graphics;
import java.awt.datatransfer.Clipboard;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.SimpleGotoEventSource;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;
import uk.ac.sanger.artemis.plot.GCFrameAlgorithm;
import uk.ac.sanger.artemis.plot.LineAttributes;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Marker;
import uk.ac.sanger.artemis.sequence.SequenceChangeEvent;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class GCFrameAlgorithm_ESTest extends GCFrameAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("zUD's<zR-d{", "zUD's<zR-d{");
      Bases bases0 = new Bases(fastaStreamSequence0);
      int[] intArray0 = new int[2];
      intArray0[0] = 5;
      intArray0[1] = (-5);
      fastaStreamSequence0.setFastaHeaderPosition(intArray0, intArray0);
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, (-5), 1, "3C`hrQ!fw5{~G&y15=t");
      sequenceChangeEvent0.getBases();
      fastaStreamSequence0.setFromChar(bases0.letter_index);
      Strand strand0 = bases0.getForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      gCFrameAlgorithm0.getDefaultStepSize(1);
      float[] floatArray0 = new float[3];
      floatArray0[0] = (float) 2;
      gCFrameAlgorithm0.getDefaultMaxWindowSize();
      floatArray0[1] = (float) 3;
      FileSystemHandling.appendLineToFile((EvoSuiteFile) null, "3C`hrQ!fw5{~G&y15=t");
      floatArray0[2] = (float) 1;
      Integer integer0 = GVTAttributedCharacterIterator.TextAttribute.ARABIC_INITIAL;
      gCFrameAlgorithm0.getDefaultMaxWindowSize();
      gCFrameAlgorithm0.getValues(3, 2918, floatArray0);
      gCFrameAlgorithm0.getAverage();
      // Undeclared exception!
      try { 
        fastaStreamSequence0.copy();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.RawStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("zUD's<zR-d{", "zUD's<zR-d{");
      Bases bases0 = new Bases(fastaStreamSequence0);
      int[] intArray0 = new int[2];
      intArray0[0] = 5;
      intArray0[1] = (-5);
      fastaStreamSequence0.setFastaHeaderPosition(intArray0, intArray0);
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, (-5), 1, "3C`hrQ!fw5{~G&y15=t");
      Bases bases1 = sequenceChangeEvent0.getBases();
      Strand strand0 = bases1.getReverseStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      float[] floatArray0 = new float[3];
      floatArray0[0] = (float) 2;
      floatArray0[1] = (float) 3;
      floatArray0[2] = (float) 1;
      gCFrameAlgorithm0.getDefaultWindowSize();
      sequenceChangeEvent0.getBases();
      gCFrameAlgorithm0.getValues((-837), 0, floatArray0);
      gCFrameAlgorithm0.getDefaultMaxWindowSize();
      gCFrameAlgorithm0.getValues(3, 2918, floatArray0);
      gCFrameAlgorithm0.getAverage();
      gCFrameAlgorithm0.getDefaultStepSize(645);
      // Undeclared exception!
      gCFrameAlgorithm0.getValues((-1039), 2889, floatArray0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(true, false).when(strand0).isForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      gCFrameAlgorithm0.getDefaultMaxWindowSize();
      gCFrameAlgorithm0.getMaximumInternal();
      gCFrameAlgorithm0.setScalingFlag(false);
      gCFrameAlgorithm0.setRevCompDisplay(true);
      gCFrameAlgorithm0.getValueCount();
      gCFrameAlgorithm0.getDefaultMinWindowSize();
      gCFrameAlgorithm0.getDefaultMaxWindowSize();
      gCFrameAlgorithm0.getDefaultMaxWindowSize();
      gCFrameAlgorithm0.getValueCount();
      gCFrameAlgorithm0.getMaximumInternal();
      gCFrameAlgorithm0.getMaximum();
      gCFrameAlgorithm0.getDefaultStepSize(16777216);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("zUD's<zR-d{", "zUD's<zR-d{");
      Bases bases0 = new Bases(fastaStreamSequence0);
      int[] intArray0 = new int[2];
      intArray0[0] = 5;
      intArray0[1] = (-5);
      fastaStreamSequence0.setFastaHeaderPosition(intArray0, intArray0);
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, (-5), 1, "3C`hrQ!fw5{~G&y15=t");
      Bases bases1 = sequenceChangeEvent0.getBases();
      Strand strand0 = bases1.getReverseStrand();
      bases0.reverseComplement();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      float[] floatArray0 = new float[3];
      floatArray0[0] = (float) 2;
      floatArray0[1] = (float) 3;
      floatArray0[2] = (float) 1;
      // Undeclared exception!
      try { 
        gCFrameAlgorithm0.getValues((-837), 0, floatArray0);
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("The empty alphabet contains nothing");
      assertEquals(26, emblStreamSequence0.getOtherCount());
      assertEquals(35, emblStreamSequence0.length());
      assertEquals(4, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getACount());
      assertNotNull(emblStreamSequence0);
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertEquals(26, emblStreamSequence0.getOtherCount());
      assertEquals(35, emblStreamSequence0.length());
      assertEquals(4, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getACount());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(bases0);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertEquals(26, emblStreamSequence0.getOtherCount());
      assertEquals(35, emblStreamSequence0.length());
      assertEquals(4, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getACount());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(gCFrameAlgorithm0);
      
      gCFrameAlgorithm0.setUserMax(2.0F);
      assertEquals(26, emblStreamSequence0.getOtherCount());
      assertEquals(35, emblStreamSequence0.length());
      assertEquals(4, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getACount());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(2.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      
      gCFrameAlgorithm0.setScalingFlag(true);
      assertEquals(26, emblStreamSequence0.getOtherCount());
      assertEquals(35, emblStreamSequence0.length());
      assertEquals(4, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getACount());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(2.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      
      Graphics graphics0 = mock(Graphics.class, new ViolatedAssumptionAnswer());
      emblStreamSequence0.setHeader("J)/'(=:>");
      assertEquals(26, emblStreamSequence0.getOtherCount());
      assertEquals("J)/'(=:>", emblStreamSequence0.getHeader());
      assertEquals(35, emblStreamSequence0.length());
      assertEquals(4, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(3, emblStreamSequence0.getACount());
      
      LineAttributes[] lineAttributesArray0 = new LineAttributes[3];
      LineAttributes lineAttributes0 = mock(LineAttributes.class, new ViolatedAssumptionAnswer());
      lineAttributesArray0[0] = lineAttributes0;
      lineAttributesArray0[1] = lineAttributes0;
      Integer integer0 = GVTAttributedCharacterIterator.TextAttribute.ADJUST_SPACING;
      assertEquals(0, (int)integer0);
      assertNotNull(integer0);
      
      Integer integer1 = gCFrameAlgorithm0.getDefaultStepSize(58);
      assertEquals(7, (int)integer1);
      assertEquals(26, emblStreamSequence0.getOtherCount());
      assertEquals("J)/'(=:>", emblStreamSequence0.getHeader());
      assertEquals(35, emblStreamSequence0.length());
      assertEquals(4, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(3, emblStreamSequence0.getACount());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(2.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertFalse(integer1.equals((Object)integer0));
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(integer1);
      
      lineAttributesArray0[2] = lineAttributes0;
      gCFrameAlgorithm0.drawLegend(graphics0, 1, 2, lineAttributesArray0, 2);
      assertEquals(26, emblStreamSequence0.getOtherCount());
      assertEquals("J)/'(=:>", emblStreamSequence0.getHeader());
      assertEquals(35, emblStreamSequence0.length());
      assertEquals(4, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(3, emblStreamSequence0.getACount());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(2.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(3, lineAttributesArray0.length);
      
      Integer integer2 = gCFrameAlgorithm0.getDefaultWindowSize();
      assertEquals(120, (int)integer2);
      assertEquals(26, emblStreamSequence0.getOtherCount());
      assertEquals("J)/'(=:>", emblStreamSequence0.getHeader());
      assertEquals(35, emblStreamSequence0.length());
      assertEquals(4, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(3, emblStreamSequence0.getACount());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(2.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertFalse(integer2.equals((Object)integer0));
      assertFalse(integer2.equals((Object)integer1));
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(integer2);
      
      float float0 = bases0.getAverageGCPercent();
      assertEquals(5.714286F, float0, 0.01F);
      assertEquals(26, emblStreamSequence0.getOtherCount());
      assertEquals("J)/'(=:>", emblStreamSequence0.getHeader());
      assertEquals(35, emblStreamSequence0.length());
      assertEquals(4, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(3, emblStreamSequence0.getACount());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      
      float[] floatArray0 = new float[6];
      floatArray0[0] = (float) 1;
      floatArray0[1] = (float) 58;
      floatArray0[2] = (-3792.0F);
      floatArray0[3] = (float) (-340);
      floatArray0[4] = 365.90173F;
      gCFrameAlgorithm0.getValues(3, 2143, floatArray0);
      assertEquals(26, emblStreamSequence0.getOtherCount());
      assertEquals("J)/'(=:>", emblStreamSequence0.getHeader());
      assertEquals(35, emblStreamSequence0.length());
      assertEquals(4, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(3, emblStreamSequence0.getACount());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(2.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertArrayEquals(new float[] {0.2805049F, 0.0F, 0.0F, (-340.0F), 365.90173F, 0.0F}, floatArray0, 0.01F);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(6, floatArray0.length);
      
      floatArray0[5] = 2.0F;
      // Undeclared exception!
      try { 
        gCFrameAlgorithm0.getValues(114, (-340), floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 114 > end: -340
         //
         verifyException("uk.ac.sanger.artemis.plot.GCFrameAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("GC Frame Plot");
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(13, rawStreamSequence0.length());
      assertNotNull(rawStreamSequence0);
      
      Bases bases0 = new Bases(rawStreamSequence0);
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(13, rawStreamSequence0.length());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(bases0);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(true, true).when(strand0).isForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(13, rawStreamSequence0.length());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(gCFrameAlgorithm0);
      
      Integer integer0 = gCFrameAlgorithm0.getDefaultStepSize(83);
      assertEquals(10, (int)integer0);
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(13, rawStreamSequence0.length());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(integer0);
      
      Float float0 = gCFrameAlgorithm0.getAverage();
      assertEquals(0.0F, (float)float0, 0.01F);
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(13, rawStreamSequence0.length());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(float0);
      
      gCFrameAlgorithm0.setRevCompDisplay(false);
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(13, rawStreamSequence0.length());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      Integer integer1 = gCFrameAlgorithm0.getDefaultStepSize(83);
      assertEquals(10, (int)integer1);
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(13, rawStreamSequence0.length());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertTrue(integer1.equals((Object)integer0));
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(integer1);
      
      Integer integer2 = gCFrameAlgorithm0.getDefaultMinWindowSize();
      assertEquals(24, (int)integer2);
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(13, rawStreamSequence0.length());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertFalse(integer2.equals((Object)integer1));
      assertFalse(integer2.equals((Object)integer0));
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(integer2);
      
      Integer integer3 = gCFrameAlgorithm0.getDefaultMinWindowSize();
      assertEquals(24, (int)integer3);
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(13, rawStreamSequence0.length());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertFalse(integer3.equals((Object)integer0));
      assertFalse(integer3.equals((Object)integer1));
      assertTrue(integer3.equals((Object)integer2));
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(integer3);
      
      gCFrameAlgorithm0.setUserMax((-2297.25F));
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(13, rawStreamSequence0.length());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals((-2297.25F), gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      float[] floatArray0 = new float[0];
      // Undeclared exception!
      try { 
        gCFrameAlgorithm0.getValues(2, 83, floatArray0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 0
         //
         verifyException("uk.ac.sanger.artemis.plot.GCFrameAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertFalse(simpleEntryGroup0.hasUnsavedChanges());
      assertEquals(0, simpleEntryGroup0.getAllFeaturesCount());
      assertNotNull(simpleEntryGroup0);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(gCFrameAlgorithm0);
      
      gCFrameAlgorithm0.setRevCompDisplay(false);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      
      Integer integer0 = gCFrameAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(500, (int)integer0);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(integer0);
      
      Float float0 = gCFrameAlgorithm0.getMaximum();
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertNull(float0);
      
      int int0 = 0;
      Integer integer1 = gCFrameAlgorithm0.getDefaultStepSize(0);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertNull(integer1);
      
      Integer integer2 = gCFrameAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(500, (int)integer2);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(integer2.equals((Object)int0));
      assertTrue(integer2.equals((Object)integer0));
      assertNotNull(integer2);
      
      Float float1 = gCFrameAlgorithm0.getMinimumInternal();
      assertEquals(0.0F, (float)float1, 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(float1);
      
      Integer integer3 = gCFrameAlgorithm0.getDefaultWindowSize();
      assertEquals(120, (int)integer3);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(integer3.equals((Object)integer2));
      assertFalse(integer3.equals((Object)integer0));
      assertFalse(integer3.equals((Object)int0));
      assertNotNull(integer3);
      
      Integer integer4 = gCFrameAlgorithm0.getDefaultWindowSize();
      assertEquals(120, (int)integer4);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(integer4.equals((Object)integer0));
      assertFalse(integer4.equals((Object)int0));
      assertTrue(integer4.equals((Object)integer3));
      assertFalse(integer4.equals((Object)integer2));
      assertNotNull(integer4);
      
      gCFrameAlgorithm0.setUserMax(2);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(2.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      
      Integer integer5 = gCFrameAlgorithm0.getDefaultMinWindowSize();
      assertEquals(24, (int)integer5);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(2.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(integer5.equals((Object)integer3));
      assertFalse(integer5.equals((Object)integer2));
      assertFalse(integer5.equals((Object)integer0));
      assertFalse(integer5.equals((Object)integer4));
      assertFalse(integer5.equals((Object)int0));
      assertNotNull(integer5);
      
      gCFrameAlgorithm0.setAlgorithmName("  ");
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("  ", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(2.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      
      Integer integer6 = gCFrameAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(500, (int)integer6);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("  ", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(2.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(integer6.equals((Object)integer2));
      assertFalse(integer6.equals((Object)integer4));
      assertTrue(integer6.equals((Object)integer0));
      assertFalse(integer6.equals((Object)integer3));
      assertFalse(integer6.equals((Object)integer5));
      assertFalse(integer6.equals((Object)int0));
      assertNotNull(integer6);
      
      Integer integer7 = gCFrameAlgorithm0.getDefaultMinWindowSize();
      assertEquals(24, (int)integer7);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("  ", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(2.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(integer7.equals((Object)integer2));
      assertTrue(integer7.equals((Object)integer5));
      assertFalse(integer7.equals((Object)integer4));
      assertFalse(integer7.equals((Object)integer0));
      assertFalse(integer7.equals((Object)integer6));
      assertFalse(integer7.equals((Object)integer3));
      assertFalse(integer7.equals((Object)int0));
      assertNotNull(integer7);
      
      Integer integer8 = gCFrameAlgorithm0.getDefaultStepSize(0);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("  ", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(2.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertNull(integer8);
      
      // Undeclared exception!
      try { 
        gCFrameAlgorithm0.getAverage();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      // Undeclared exception!
      try { 
        Marker.getRawLowest((Marker) null, (Marker) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Marker", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("GC Frame Plot");
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(13, rawStreamSequence0.length());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertNotNull(rawStreamSequence0);
      
      Bases bases0 = new Bases(rawStreamSequence0);
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(13, rawStreamSequence0.length());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(bases0);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(true, true).when(strand0).isForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(13, rawStreamSequence0.length());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(gCFrameAlgorithm0);
      
      Integer integer0 = gCFrameAlgorithm0.getDefaultStepSize(83);
      assertEquals(10, (int)integer0);
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(13, rawStreamSequence0.length());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(integer0);
      
      Float float0 = gCFrameAlgorithm0.getAverage();
      assertEquals(0.0F, (float)float0, 0.01F);
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(13, rawStreamSequence0.length());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(float0);
      
      gCFrameAlgorithm0.setRevCompDisplay(true);
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(13, rawStreamSequence0.length());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      
      Integer integer1 = gCFrameAlgorithm0.getDefaultStepSize(83);
      assertEquals(10, (int)integer1);
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(13, rawStreamSequence0.length());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertTrue(integer1.equals((Object)integer0));
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(integer1);
      
      Integer integer2 = gCFrameAlgorithm0.getDefaultMinWindowSize();
      assertEquals(24, (int)integer2);
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(13, rawStreamSequence0.length());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(integer2.equals((Object)integer1));
      assertFalse(integer2.equals((Object)integer0));
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(integer2);
      
      Integer integer3 = gCFrameAlgorithm0.getDefaultMinWindowSize();
      assertEquals(24, (int)integer3);
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(13, rawStreamSequence0.length());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(integer3.equals((Object)integer1));
      assertFalse(integer3.equals((Object)integer0));
      assertTrue(integer3.equals((Object)integer2));
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(integer3);
      
      int int0 = (-1);
      gCFrameAlgorithm0.setUserMax((-2297.25F));
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(13, rawStreamSequence0.length());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertTrue(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals((-2297.25F), gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      
      float[] floatArray0 = new float[0];
      // Undeclared exception!
      try { 
        gCFrameAlgorithm0.getValues(2, (-1), floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 13 > end: 12
         //
         verifyException("uk.ac.sanger.artemis.plot.GCFrameAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("zUD's<zR-d{", "zUD's<zR-d{");
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertNotNull(fastaStreamSequence0);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertNotNull(bases0);
      
      int[] intArray0 = new int[2];
      intArray0[0] = 5;
      intArray0[1] = (-5);
      fastaStreamSequence0.setFastaHeaderPosition(intArray0, intArray0);
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertArrayEquals(new int[] {5, (-5)}, intArray0);
      assertEquals(2, intArray0.length);
      
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, (-5), 1, "3C`hrQ!fw5{~G&y15=t");
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals((-5), sequenceChangeEvent0.getType());
      assertEquals(1, sequenceChangeEvent0.getPosition());
      assertEquals("3C`hrQ!fw5{~G&y15=t", sequenceChangeEvent0.getSubSequence());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertNotNull(sequenceChangeEvent0);
      
      Bases bases1 = sequenceChangeEvent0.getBases();
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals((-5), sequenceChangeEvent0.getType());
      assertEquals(1, sequenceChangeEvent0.getPosition());
      assertEquals("3C`hrQ!fw5{~G&y15=t", sequenceChangeEvent0.getSubSequence());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(bases1);
      
      Strand strand0 = bases1.getReverseStrand();
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals((-5), sequenceChangeEvent0.getType());
      assertEquals(1, sequenceChangeEvent0.getPosition());
      assertEquals("3C`hrQ!fw5{~G&y15=t", sequenceChangeEvent0.getSubSequence());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(strand0);
      
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals((-5), sequenceChangeEvent0.getType());
      assertEquals(1, sequenceChangeEvent0.getPosition());
      assertEquals("3C`hrQ!fw5{~G&y15=t", sequenceChangeEvent0.getSubSequence());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(gCFrameAlgorithm0);
      
      float[] floatArray0 = new float[3];
      floatArray0[0] = (float) 2;
      floatArray0[1] = (float) 3;
      floatArray0[2] = (float) 1;
      gCFrameAlgorithm0.getValues((-837), 0, floatArray0);
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals((-5), sequenceChangeEvent0.getType());
      assertEquals(1, sequenceChangeEvent0.getPosition());
      assertEquals("3C`hrQ!fw5{~G&y15=t", sequenceChangeEvent0.getSubSequence());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertArrayEquals(new float[] {0.0F, 0.0F, 0.0F}, floatArray0, 0.01F);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertEquals(3, floatArray0.length);
      
      Integer integer0 = gCFrameAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(500, (int)integer0);
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals((-5), sequenceChangeEvent0.getType());
      assertEquals(1, sequenceChangeEvent0.getPosition());
      assertEquals("3C`hrQ!fw5{~G&y15=t", sequenceChangeEvent0.getSubSequence());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertEquals(2, strand0.getDirection());
      assertFalse(strand0.isForwardStrand());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      assertNotNull(integer0);
      
      // Undeclared exception!
      try { 
        fastaStreamSequence0.copy();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.RawStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      Integer integer0 = GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_ANGLE;
      assertEquals(1, (int)integer0);
      assertNotNull(integer0);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(gCFrameAlgorithm0);
      
      Float float0 = gCFrameAlgorithm0.getMinimumInternal();
      assertEquals(0.0F, (float)float0, 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(float0);
      
      // Undeclared exception!
      try { 
        gCFrameAlgorithm0.getAverage();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("GC Frame Plot", "GC Frame Plot");
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(13, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertNotNull(fastaStreamSequence0);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(13, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(bases0);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(13, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(gCFrameAlgorithm0);
      
      Integer integer0 = gCFrameAlgorithm0.getDefaultStepSize(83);
      assertEquals(10, (int)integer0);
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(13, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(integer0);
      
      Float float0 = gCFrameAlgorithm0.getAverage();
      assertEquals(0.0F, (float)float0, 0.01F);
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(13, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(float0);
      
      gCFrameAlgorithm0.setRevCompDisplay(false);
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(13, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      
      Integer integer1 = gCFrameAlgorithm0.getDefaultStepSize(83);
      assertEquals(10, (int)integer1);
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(13, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertTrue(integer1.equals((Object)integer0));
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(integer1);
      
      Integer integer2 = gCFrameAlgorithm0.getDefaultMinWindowSize();
      assertEquals(24, (int)integer2);
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(13, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertFalse(integer2.equals((Object)integer1));
      assertFalse(integer2.equals((Object)integer0));
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(integer2);
      
      Integer integer3 = gCFrameAlgorithm0.getDefaultMinWindowSize();
      assertEquals(24, (int)integer3);
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(13, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertFalse(integer3.equals((Object)integer1));
      assertTrue(integer3.equals((Object)integer2));
      assertFalse(integer3.equals((Object)integer0));
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertNotNull(integer3);
      
      int int0 = (-1);
      gCFrameAlgorithm0.setUserMax((-2297.25F));
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(13, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals((-2297.25F), gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      
      float[] floatArray0 = new float[0];
      // Undeclared exception!
      try { 
        gCFrameAlgorithm0.getValues(2, (-1), floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 0 > end: -1
         //
         verifyException("uk.ac.sanger.artemis.plot.GCFrameAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertNotNull(gCFrameAlgorithm0);
      
      int int0 = 0;
      boolean boolean0 = true;
      Float float0 = gCFrameAlgorithm0.getMinimum();
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertNull(float0);
      
      Float float1 = gCFrameAlgorithm0.getMaximum();
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertNull(float1);
      
      gCFrameAlgorithm0.setUserMaxMin(true);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      
      gCFrameAlgorithm0.setRevCompDisplay(false);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      
      gCFrameAlgorithm0.setAlgorithmName("");
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      
      int int1 = 1723;
      Float float2 = gCFrameAlgorithm0.getMaximumInternal();
      assertEquals(100.0F, (float)float2, 0.01F);
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertNotNull(float2);
      
      // Undeclared exception!
      try { 
        gCFrameAlgorithm0.getAverage();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("GC Frame Plot");
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertEquals(13, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertNotNull(rawStreamSequence0);
      
      Bases bases0 = new Bases(rawStreamSequence0);
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertEquals(13, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(bases0);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(true, true).when(strand0).isForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertEquals(13, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(gCFrameAlgorithm0);
      
      Integer integer0 = gCFrameAlgorithm0.getDefaultStepSize(83);
      assertEquals(10, (int)integer0);
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertEquals(13, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(integer0);
      
      Float float0 = gCFrameAlgorithm0.getAverage();
      assertEquals(0.0F, (float)float0, 0.01F);
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertEquals(13, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(float0);
      
      gCFrameAlgorithm0.setRevCompDisplay(false);
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertEquals(13, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      
      Integer integer1 = gCFrameAlgorithm0.getDefaultStepSize(83);
      assertEquals(10, (int)integer1);
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertEquals(13, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(integer1.equals((Object)integer0));
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(integer1);
      
      Integer integer2 = gCFrameAlgorithm0.getDefaultMinWindowSize();
      assertEquals(24, (int)integer2);
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertEquals(13, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(integer2.equals((Object)integer0));
      assertFalse(integer2.equals((Object)integer1));
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(integer2);
      
      Integer integer3 = gCFrameAlgorithm0.getDefaultMinWindowSize();
      assertEquals(24, (int)integer3);
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertEquals(13, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(integer3.equals((Object)integer0));
      assertFalse(integer3.equals((Object)integer1));
      assertTrue(integer3.equals((Object)integer2));
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(integer3);
      
      int int0 = (-1);
      gCFrameAlgorithm0.setUserMax((-2297.25F));
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(11, rawStreamSequence0.getOtherCount());
      assertEquals(13, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals((-2297.25F), gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(2, Bases.REVERSE);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      
      float[] floatArray0 = new float[0];
      // Undeclared exception!
      try { 
        gCFrameAlgorithm0.getValues(2, (-1), floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 2 > end: 1
         //
         verifyException("uk.ac.sanger.artemis.plot.GCFrameAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("");
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertNull(emblStreamSequence0.getHeader());
      assertNotNull(emblStreamSequence0);
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(bases0);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertNull(emblStreamSequence0.getHeader());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(gCFrameAlgorithm0);
      
      Float float0 = gCFrameAlgorithm0.getMaximum();
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertNull(emblStreamSequence0.getHeader());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNull(float0);
      
      Float float1 = gCFrameAlgorithm0.getAverage();
      assertEquals(Float.NaN, (float)float1, 0.01F);
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertNull(emblStreamSequence0.getHeader());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(float1);
      
      gCFrameAlgorithm0.setAlgorithmName("CFw&^?2Y6");
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertNull(emblStreamSequence0.getHeader());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("CFw&^?2Y6", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      Integer integer0 = gCFrameAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(500, (int)integer0);
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertNull(emblStreamSequence0.getHeader());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("CFw&^?2Y6", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(integer0);
      
      int int0 = gCFrameAlgorithm0.getValueCount();
      assertEquals(3, int0);
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.length());
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(0, emblStreamSequence0.getOtherCount());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertNull(emblStreamSequence0.getHeader());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("CFw&^?2Y6", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      SimpleGotoEventSource simpleGotoEventSource0 = new SimpleGotoEventSource((EntryGroup) null);
      assertNotNull(simpleGotoEventSource0);
      
      EntryGroup entryGroup0 = simpleGotoEventSource0.getEntryGroup();
      assertNull(entryGroup0);
      
      SimpleEntryInformation simpleEntryInformation0 = new SimpleEntryInformation();
      assertFalse(simpleEntryInformation0.useEMBLFormat());
      assertNotNull(simpleEntryInformation0);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertNotNull(gCFrameAlgorithm0);
      
      Float float0 = gCFrameAlgorithm0.getMinimumInternal();
      assertEquals(0.0F, (float)float0, 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertNotNull(float0);
      
      Integer integer0 = gCFrameAlgorithm0.getDefaultStepSize(2);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertNull(integer0);
      
      Integer integer1 = gCFrameAlgorithm0.getDefaultStepSize(2);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertNull(integer1);
      
      gCFrameAlgorithm0.setScalingFlag(false);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.scalingFlag());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      
      Graphics graphics0 = mock(Graphics.class, new ViolatedAssumptionAnswer());
      LineAttributes[] lineAttributesArray0 = new LineAttributes[9];
      LineAttributes lineAttributes0 = mock(LineAttributes.class, new ViolatedAssumptionAnswer());
      Float float1 = gCFrameAlgorithm0.getMinimum();
      assertEquals(0.0F, (float)float1, 0.01F);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.scalingFlag());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals((float)float1, (float)float0, 0.01F);
      assertNotNull(float1);
      
      gCFrameAlgorithm0.setUserMax(1);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(1.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.scalingFlag());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      
      lineAttributesArray0[0] = lineAttributes0;
      lineAttributesArray0[1] = lineAttributes0;
      lineAttributesArray0[2] = lineAttributes0;
      lineAttributesArray0[3] = lineAttributes0;
      lineAttributesArray0[4] = lineAttributes0;
      lineAttributesArray0[5] = lineAttributes0;
      Float float2 = gCFrameAlgorithm0.getMaximum();
      assertEquals(100.0F, (float)float2, 0.01F);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(1.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.scalingFlag());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertNotEquals((float)float2, (float)float1, 0.01F);
      assertNotEquals((float)float2, (float)float0, 0.01F);
      assertNotNull(float2);
      
      lineAttributesArray0[6] = lineAttributes0;
      lineAttributesArray0[7] = lineAttributes0;
      lineAttributesArray0[8] = lineAttributes0;
      gCFrameAlgorithm0.drawLegend(graphics0, 1, 2, lineAttributesArray0, 1862);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(1.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.scalingFlag());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(9, lineAttributesArray0.length);
      
      Integer integer2 = gCFrameAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(500, (int)integer2);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(1.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.scalingFlag());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertNotNull(integer2);
      
      Integer integer3 = gCFrameAlgorithm0.getDefaultMinWindowSize();
      assertEquals(24, (int)integer3);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(1.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.scalingFlag());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertFalse(integer3.equals((Object)integer2));
      assertNotNull(integer3);
      
      Integer integer4 = gCFrameAlgorithm0.getDefaultWindowSize();
      assertEquals(120, (int)integer4);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(1.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.scalingFlag());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertFalse(integer4.equals((Object)integer2));
      assertFalse(integer4.equals((Object)integer3));
      assertNotNull(integer4);
      
      // Undeclared exception!
      try { 
        gCFrameAlgorithm0.getValues(1862, 1, (float[]) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertEquals(0, simpleEntryGroup0.getAllFeaturesCount());
      assertFalse(simpleEntryGroup0.hasUnsavedChanges());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      assertNotNull(simpleEntryGroup0);
      
      Range range0 = new Range(83);
      assertEquals(83, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(83, range0.getEnd());
      assertNotNull(range0);
      
      // Undeclared exception!
      try { 
        simpleEntryGroup0.truncate(range0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("The empty alphabet contains nothing");
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(4, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getACount());
      assertEquals(35, emblStreamSequence0.length());
      assertEquals(26, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertNotNull(emblStreamSequence0);
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(4, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getACount());
      assertEquals(35, emblStreamSequence0.length());
      assertEquals(26, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(bases0);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(4, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getACount());
      assertEquals(35, emblStreamSequence0.length());
      assertEquals(26, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(gCFrameAlgorithm0);
      
      gCFrameAlgorithm0.setUserMax(2.0F);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(4, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getACount());
      assertEquals(35, emblStreamSequence0.length());
      assertEquals(26, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(2.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      
      gCFrameAlgorithm0.setScalingFlag(true);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(4, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getACount());
      assertEquals(35, emblStreamSequence0.length());
      assertEquals(26, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(2.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      
      Graphics graphics0 = mock(Graphics.class, new ViolatedAssumptionAnswer());
      LineAttributes[] lineAttributesArray0 = new LineAttributes[3];
      LineAttributes lineAttributes0 = mock(LineAttributes.class, new ViolatedAssumptionAnswer());
      lineAttributesArray0[0] = lineAttributes0;
      lineAttributesArray0[1] = lineAttributes0;
      Integer integer0 = GVTAttributedCharacterIterator.TextAttribute.ADJUST_SPACING;
      assertEquals(0, (int)integer0);
      assertNotNull(integer0);
      
      Integer integer1 = gCFrameAlgorithm0.getDefaultStepSize(58);
      assertEquals(7, (int)integer1);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(4, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getACount());
      assertEquals(35, emblStreamSequence0.length());
      assertEquals(26, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(2.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertFalse(integer1.equals((Object)integer0));
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(integer1);
      
      lineAttributesArray0[2] = lineAttributes0;
      gCFrameAlgorithm0.drawLegend(graphics0, 1, 2, lineAttributesArray0, 2);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(4, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getACount());
      assertEquals(35, emblStreamSequence0.length());
      assertEquals(26, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(2.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(3, lineAttributesArray0.length);
      
      Integer integer2 = gCFrameAlgorithm0.getDefaultWindowSize();
      assertEquals(120, (int)integer2);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(4, emblStreamSequence0.getTCount());
      assertEquals(3, emblStreamSequence0.getACount());
      assertEquals(35, emblStreamSequence0.length());
      assertEquals(26, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(2.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertFalse(integer2.equals((Object)integer0));
      assertFalse(integer2.equals((Object)integer1));
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(integer2);
      
      float[] floatArray0 = new float[6];
      floatArray0[0] = (float) 1;
      floatArray0[1] = (float) 58;
      floatArray0[2] = (-3792.0F);
      floatArray0[3] = (float) (-319);
      floatArray0[4] = 365.90173F;
      floatArray0[5] = 2.0F;
      // Undeclared exception!
      try { 
        gCFrameAlgorithm0.getValues(114, (-319), floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 114 > end: -319
         //
         verifyException("uk.ac.sanger.artemis.plot.GCFrameAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(bases0);
      
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, 68);
      assertNull(sequenceChangeEvent0.getSubSequence());
      assertEquals(0, sequenceChangeEvent0.getPosition());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertEquals(68, sequenceChangeEvent0.getType());
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertNotNull(sequenceChangeEvent0);
      
      Bases bases1 = sequenceChangeEvent0.getBases();
      assertNull(sequenceChangeEvent0.getSubSequence());
      assertEquals(0, sequenceChangeEvent0.getPosition());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertEquals(68, sequenceChangeEvent0.getType());
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertNotNull(bases1);
      
      Strand strand0 = bases1.getForwardStrand();
      assertNull(sequenceChangeEvent0.getSubSequence());
      assertEquals(0, sequenceChangeEvent0.getPosition());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertEquals(68, sequenceChangeEvent0.getType());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(strand0);
      
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertNull(sequenceChangeEvent0.getSubSequence());
      assertEquals(0, sequenceChangeEvent0.getPosition());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertEquals(68, sequenceChangeEvent0.getType());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(gCFrameAlgorithm0);
      
      // Undeclared exception!
      try { 
        gCFrameAlgorithm0.getValues(1, 5, (float[]) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.getAllFeaturesCount());
      assertFalse(simpleEntryGroup0.hasUnsavedChanges());
      assertNotNull(simpleEntryGroup0);
      
      Bases bases0 = simpleEntryGroup0.getBases();
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.getAllFeaturesCount());
      assertFalse(simpleEntryGroup0.hasUnsavedChanges());
      assertNull(bases0);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(true, true).when(strand0).isForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertNotNull(gCFrameAlgorithm0);
      
      Float float0 = gCFrameAlgorithm0.getMaximum();
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertNull(float0);
      
      gCFrameAlgorithm0.setUserMaxMin(true);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertTrue(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      
      Integer integer0 = gCFrameAlgorithm0.getDefaultStepSize(2);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertTrue(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertNull(integer0);
      
      Integer integer1 = gCFrameAlgorithm0.getDefaultStepSize(1);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertTrue(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertNull(integer1);
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(gCFrameAlgorithm0);
      
      Integer integer0 = gCFrameAlgorithm0.getDefaultStepSize(8);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertNull(integer0);
      
      gCFrameAlgorithm0.setUserMax(1);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      
      Integer integer1 = gCFrameAlgorithm0.getDefaultStepSize(2);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertNull(integer1);
      
      Float float0 = gCFrameAlgorithm0.getMaximumInternal();
      assertEquals(100.0F, (float)float0, 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertNotNull(float0);
      
      Float float1 = gCFrameAlgorithm0.getMinimumInternal();
      assertEquals(0.0F, (float)float1, 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertNotEquals((float)float1, (float)float0, 0.01F);
      assertNotNull(float1);
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(gCFrameAlgorithm0);
      
      gCFrameAlgorithm0.setUserMax(2);
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(2.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      
      Float float0 = gCFrameAlgorithm0.getMaximum();
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(2.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertNull(float0);
      
      Integer integer0 = gCFrameAlgorithm0.getDefaultStepSize(1682);
      assertEquals(210, (int)integer0);
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(2.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertNotNull(integer0);
      
      Float float1 = gCFrameAlgorithm0.getMinimumInternal();
      assertEquals(0.0F, (float)float1, 0.01F);
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(2.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertNotNull(float1);
      
      int int0 = gCFrameAlgorithm0.getValueCount();
      assertEquals(3, int0);
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(2.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(gCFrameAlgorithm0);
      
      int int0 = gCFrameAlgorithm0.getValueCount();
      assertEquals(3, int0);
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(gCFrameAlgorithm0);
      
      Integer integer0 = gCFrameAlgorithm0.getDefaultStepSize(2);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertNull(integer0);
      
      Float float0 = gCFrameAlgorithm0.getMaximumInternal();
      assertEquals(100.0F, (float)float0, 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(float0);
      
      Integer integer1 = gCFrameAlgorithm0.getDefaultStepSize(2);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertNull(integer1);
      
      Float float1 = gCFrameAlgorithm0.getMaximumInternal();
      assertEquals(100.0F, (float)float1, 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals((float)float1, (float)float0, 0.01F);
      assertNotNull(float1);
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(gCFrameAlgorithm0);
      
      gCFrameAlgorithm0.max_min_disabled = true;
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      
      Integer integer0 = gCFrameAlgorithm0.getDefaultWindowSize();
      assertEquals(120, (int)integer0);
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(integer0);
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertNotNull(gCFrameAlgorithm0);
      
      Integer integer0 = gCFrameAlgorithm0.getDefaultStepSize(0);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertNull(integer0);
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertNotNull(gCFrameAlgorithm0);
      
      Integer integer0 = gCFrameAlgorithm0.getDefaultStepSize(62);
      assertEquals(7, (int)integer0);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertNotNull(integer0);
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(gCFrameAlgorithm0);
      
      Integer integer0 = gCFrameAlgorithm0.getDefaultWindowSize();
      assertEquals(120, (int)integer0);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(integer0);
      
      Graphics graphics0 = mock(Graphics.class, new ViolatedAssumptionAnswer());
      LineAttributes[] lineAttributesArray0 = new LineAttributes[7];
      LineAttributes lineAttributes0 = mock(LineAttributes.class, new ViolatedAssumptionAnswer());
      lineAttributesArray0[0] = lineAttributes0;
      lineAttributesArray0[1] = lineAttributes0;
      lineAttributesArray0[2] = lineAttributes0;
      lineAttributesArray0[3] = lineAttributes0;
      lineAttributesArray0[4] = lineAttributes0;
      lineAttributesArray0[5] = lineAttributes0;
      lineAttributesArray0[6] = lineAttributes0;
      Integer integer1 = gCFrameAlgorithm0.getDefaultWindowSize();
      assertEquals(120, (int)integer1);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(integer1.equals((Object)integer0));
      assertNotNull(integer1);
      
      gCFrameAlgorithm0.drawLegend(graphics0, 99, 2, lineAttributesArray0, 2);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(7, lineAttributesArray0.length);
      
      // Undeclared exception!
      try { 
        gCFrameAlgorithm0.getAverage();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      GCFrameAlgorithm gCFrameAlgorithm0 = null;
      try {
        gCFrameAlgorithm0 = new GCFrameAlgorithm((Strand) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.GCFrameAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertNotNull(gCFrameAlgorithm0);
      
      // Undeclared exception!
      try { 
        gCFrameAlgorithm0.getAverage();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(gCFrameAlgorithm0);
      
      Graphics graphics0 = mock(Graphics.class, new ViolatedAssumptionAnswer());
      LineAttributes[] lineAttributesArray0 = new LineAttributes[0];
      gCFrameAlgorithm0.drawLegend(graphics0, 1, 39, lineAttributesArray0, 1);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(0, lineAttributesArray0.length);
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertNotNull(gCFrameAlgorithm0);
      
      Float float0 = gCFrameAlgorithm0.getMaximumInternal();
      assertEquals(100.0F, (float)float0, 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertNotNull(float0);
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertNotNull(gCFrameAlgorithm0);
      
      Float float0 = gCFrameAlgorithm0.getMaximum();
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertNull(float0);
      
      int int0 = gCFrameAlgorithm0.getValueCount();
      assertEquals(3, int0);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      
      Integer integer0 = gCFrameAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(500, (int)integer0);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertFalse(integer0.equals((Object)int0));
      assertNotNull(integer0);
      
      gCFrameAlgorithm0.setRevCompDisplay(true);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCFrameAlgorithm0.isRevCompDisplay());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      
      float[] floatArray0 = new float[5];
      gCFrameAlgorithm0.setUserMin(181.19F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(181.19F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.isRevCompDisplay());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      
      Integer integer1 = gCFrameAlgorithm0.getDefaultWindowSize();
      assertEquals(120, (int)integer1);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(181.19F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.isRevCompDisplay());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertFalse(integer1.equals((Object)int0));
      assertFalse(integer1.equals((Object)integer0));
      assertNotNull(integer1);
      
      floatArray0[0] = (float) (-2495);
      floatArray0[1] = 0.0F;
      floatArray0[2] = (float) 2;
      floatArray0[3] = 3.0F;
      floatArray0[4] = (float) (-2495);
      // Undeclared exception!
      try { 
        gCFrameAlgorithm0.getValues(1, (-2495), floatArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      FeatureVector featureVector0 = new FeatureVector();
      assertNotNull(featureVector0);
      
      float[] floatArray0 = new float[9];
      floatArray0[1] = (-1127.4474F);
      floatArray0[2] = (float) 3991;
      floatArray0[3] = (float) 103;
      floatArray0[6] = (float) 3991;
      floatArray0[7] = (float) 103;
      boolean boolean0 = FileSystemHandling.setPermissions((EvoSuiteFile) null, false, false, false);
      assertFalse(boolean0);
      
      Object object0 = featureVector0.clone();
      assertFalse(object0.equals((Object)featureVector0));
      assertNotSame(featureVector0, object0);
      assertNotSame(object0, featureVector0);
      assertNotNull(object0);
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("zUD's<zR-d{", "zUD's<zR-d{");
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertNotNull(fastaStreamSequence0);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertNotNull(bases0);
      
      int[] intArray0 = new int[2];
      intArray0[0] = 5;
      intArray0[1] = (-5);
      fastaStreamSequence0.setFastaHeaderPosition(intArray0, intArray0);
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertArrayEquals(new int[] {5, (-5)}, intArray0);
      assertEquals(2, intArray0.length);
      
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, (-5), 1, "3C`hrQ!fw5{~G&y15=t");
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertEquals("3C`hrQ!fw5{~G&y15=t", sequenceChangeEvent0.getSubSequence());
      assertEquals(1, sequenceChangeEvent0.getPosition());
      assertEquals((-5), sequenceChangeEvent0.getType());
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertNotNull(sequenceChangeEvent0);
      
      Bases bases1 = sequenceChangeEvent0.getBases();
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertEquals("3C`hrQ!fw5{~G&y15=t", sequenceChangeEvent0.getSubSequence());
      assertEquals(1, sequenceChangeEvent0.getPosition());
      assertEquals((-5), sequenceChangeEvent0.getType());
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(bases1);
      
      fastaStreamSequence0.setFromChar(bases0.letter_index);
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(5, fastaStreamSequence0.length());
      assertEquals(1, fastaStreamSequence0.getOtherCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(1, fastaStreamSequence0.getACount());
      assertSame(bases0, bases1);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      
      Strand strand0 = bases1.getReverseStrand();
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(5, fastaStreamSequence0.length());
      assertEquals(1, fastaStreamSequence0.getOtherCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(1, fastaStreamSequence0.getACount());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertEquals("3C`hrQ!fw5{~G&y15=t", sequenceChangeEvent0.getSubSequence());
      assertEquals(1, sequenceChangeEvent0.getPosition());
      assertEquals((-5), sequenceChangeEvent0.getType());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(strand0);
      
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(5, fastaStreamSequence0.length());
      assertEquals(1, fastaStreamSequence0.getOtherCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(1, fastaStreamSequence0.getACount());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertEquals("3C`hrQ!fw5{~G&y15=t", sequenceChangeEvent0.getSubSequence());
      assertEquals(1, sequenceChangeEvent0.getPosition());
      assertEquals((-5), sequenceChangeEvent0.getType());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(gCFrameAlgorithm0);
      
      float[] floatArray0 = new float[3];
      floatArray0[0] = (float) 2;
      Integer integer0 = gCFrameAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(500, (int)integer0);
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(5, fastaStreamSequence0.length());
      assertEquals(1, fastaStreamSequence0.getOtherCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(1, fastaStreamSequence0.getACount());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertEquals("3C`hrQ!fw5{~G&y15=t", sequenceChangeEvent0.getSubSequence());
      assertEquals(1, sequenceChangeEvent0.getPosition());
      assertEquals((-5), sequenceChangeEvent0.getType());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(integer0);
      
      floatArray0[1] = (float) 3;
      boolean boolean0 = FileSystemHandling.appendLineToFile((EvoSuiteFile) null, "3C`hrQ!fw5{~G&y15=t");
      assertFalse(boolean0);
      
      floatArray0[2] = (float) 1;
      Integer integer1 = gCFrameAlgorithm0.getDefaultWindowSize();
      assertEquals(120, (int)integer1);
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(5, fastaStreamSequence0.length());
      assertEquals(1, fastaStreamSequence0.getOtherCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(1, fastaStreamSequence0.getACount());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertEquals("3C`hrQ!fw5{~G&y15=t", sequenceChangeEvent0.getSubSequence());
      assertEquals(1, sequenceChangeEvent0.getPosition());
      assertEquals((-5), sequenceChangeEvent0.getType());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(integer1.equals((Object)integer0));
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(integer1);
      
      gCFrameAlgorithm0.getValues((-837), 0, floatArray0);
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(5, fastaStreamSequence0.length());
      assertEquals(1, fastaStreamSequence0.getOtherCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(1, fastaStreamSequence0.getACount());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertEquals("3C`hrQ!fw5{~G&y15=t", sequenceChangeEvent0.getSubSequence());
      assertEquals(1, sequenceChangeEvent0.getPosition());
      assertEquals((-5), sequenceChangeEvent0.getType());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertArrayEquals(new float[] {0.0F, 0.0F, 0.0F}, floatArray0, 0.01F);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, floatArray0.length);
      
      Integer integer2 = gCFrameAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(500, (int)integer2);
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(5, fastaStreamSequence0.length());
      assertEquals(1, fastaStreamSequence0.getOtherCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(1, fastaStreamSequence0.getACount());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertEquals("3C`hrQ!fw5{~G&y15=t", sequenceChangeEvent0.getSubSequence());
      assertEquals(1, sequenceChangeEvent0.getPosition());
      assertEquals((-5), sequenceChangeEvent0.getType());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(integer2.equals((Object)integer0));
      assertFalse(integer2.equals((Object)integer1));
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(integer2);
      
      gCFrameAlgorithm0.getValues(3, 2918, floatArray0);
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(5, fastaStreamSequence0.length());
      assertEquals(1, fastaStreamSequence0.getOtherCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(1, fastaStreamSequence0.getACount());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertEquals("3C`hrQ!fw5{~G&y15=t", sequenceChangeEvent0.getSubSequence());
      assertEquals(1, sequenceChangeEvent0.getPosition());
      assertEquals((-5), sequenceChangeEvent0.getType());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertArrayEquals(new float[] {0.0F, 0.0F, 0.10288066F}, floatArray0, 0.01F);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, floatArray0.length);
      
      Float float0 = gCFrameAlgorithm0.getAverage();
      assertEquals(40.0F, (float)float0, 0.01F);
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(5, fastaStreamSequence0.length());
      assertEquals(1, fastaStreamSequence0.getOtherCount());
      assertEquals(1, fastaStreamSequence0.getGCount());
      assertEquals(1, fastaStreamSequence0.getACount());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertEquals("3C`hrQ!fw5{~G&y15=t", sequenceChangeEvent0.getSubSequence());
      assertEquals(1, sequenceChangeEvent0.getPosition());
      assertEquals((-5), sequenceChangeEvent0.getType());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(float0);
      
      // Undeclared exception!
      try { 
        fastaStreamSequence0.copy();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.RawStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("zUD's<zR-d{", "zUD's<zR-d{");
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertNotNull(fastaStreamSequence0);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertNotNull(bases0);
      
      int[] intArray0 = new int[2];
      intArray0[0] = 5;
      intArray0[1] = (-5);
      fastaStreamSequence0.setFastaHeaderPosition(intArray0, intArray0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertArrayEquals(new int[] {5, (-5)}, intArray0);
      assertEquals(2, intArray0.length);
      
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, (-5), 1, "3C`hrQ!fw5{~G&y15=t");
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals("3C`hrQ!fw5{~G&y15=t", sequenceChangeEvent0.getSubSequence());
      assertEquals(1, sequenceChangeEvent0.getPosition());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertEquals((-5), sequenceChangeEvent0.getType());
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertNotNull(sequenceChangeEvent0);
      
      Bases bases1 = sequenceChangeEvent0.getBases();
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals("3C`hrQ!fw5{~G&y15=t", sequenceChangeEvent0.getSubSequence());
      assertEquals(1, sequenceChangeEvent0.getPosition());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertEquals((-5), sequenceChangeEvent0.getType());
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertNotNull(bases1);
      
      Strand strand0 = bases1.getReverseStrand();
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals("3C`hrQ!fw5{~G&y15=t", sequenceChangeEvent0.getSubSequence());
      assertEquals(1, sequenceChangeEvent0.getPosition());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertEquals((-5), sequenceChangeEvent0.getType());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(strand0);
      
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals("3C`hrQ!fw5{~G&y15=t", sequenceChangeEvent0.getSubSequence());
      assertEquals(1, sequenceChangeEvent0.getPosition());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertEquals((-5), sequenceChangeEvent0.getType());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(gCFrameAlgorithm0);
      
      float[] floatArray0 = new float[3];
      floatArray0[0] = (float) 2;
      floatArray0[1] = (float) 3;
      floatArray0[2] = (float) 1;
      Integer integer0 = gCFrameAlgorithm0.getDefaultWindowSize();
      assertEquals(120, (int)integer0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals("3C`hrQ!fw5{~G&y15=t", sequenceChangeEvent0.getSubSequence());
      assertEquals(1, sequenceChangeEvent0.getPosition());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertEquals((-5), sequenceChangeEvent0.getType());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(integer0);
      
      gCFrameAlgorithm0.getValues((-837), 0, floatArray0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals("3C`hrQ!fw5{~G&y15=t", sequenceChangeEvent0.getSubSequence());
      assertEquals(1, sequenceChangeEvent0.getPosition());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertEquals((-5), sequenceChangeEvent0.getType());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertArrayEquals(new float[] {0.0F, 0.0F, 0.0F}, floatArray0, 0.01F);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, floatArray0.length);
      
      Integer integer1 = gCFrameAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(500, (int)integer1);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals("3C`hrQ!fw5{~G&y15=t", sequenceChangeEvent0.getSubSequence());
      assertEquals(1, sequenceChangeEvent0.getPosition());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertEquals((-5), sequenceChangeEvent0.getType());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(integer1.equals((Object)integer0));
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(integer1);
      
      gCFrameAlgorithm0.getValues(3, 2918, floatArray0);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals("3C`hrQ!fw5{~G&y15=t", sequenceChangeEvent0.getSubSequence());
      assertEquals(1, sequenceChangeEvent0.getPosition());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertEquals((-5), sequenceChangeEvent0.getType());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertArrayEquals(new float[] {0.0F, 0.0F, 0.0F}, floatArray0, 0.01F);
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(3, floatArray0.length);
      
      Float float0 = gCFrameAlgorithm0.getAverage();
      assertEquals(0.0F, (float)float0, 0.01F);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals("3C`hrQ!fw5{~G&y15=t", sequenceChangeEvent0.getSubSequence());
      assertEquals(1, sequenceChangeEvent0.getPosition());
      assertEquals(0, sequenceChangeEvent0.getLength());
      assertEquals((-5), sequenceChangeEvent0.getType());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertSame(bases0, bases1);
      assertSame(bases1, bases0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(4, SequenceChangeEvent.CONTIG_REVERSE_COMPLEMENT);
      assertEquals(2, SequenceChangeEvent.INSERTION);
      assertEquals(5, SequenceChangeEvent.CONTIG_REORDER);
      assertEquals(3, SequenceChangeEvent.REVERSE_COMPLEMENT);
      assertEquals(1, SequenceChangeEvent.DELETION);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertNotNull(float0);
      
      // Undeclared exception!
      try { 
        fastaStreamSequence0.copy();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.RawStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertNotNull(gCFrameAlgorithm0);
      
      Integer integer0 = gCFrameAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(500, (int)integer0);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertNotNull(integer0);
      
      Integer integer1 = gCFrameAlgorithm0.getDefaultWindowSize();
      assertEquals(120, (int)integer1);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertFalse(integer1.equals((Object)integer0));
      assertNotNull(integer1);
      
      Integer integer2 = gCFrameAlgorithm0.getDefaultMinWindowSize();
      assertEquals(24, (int)integer2);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertFalse(integer2.equals((Object)integer1));
      assertFalse(integer2.equals((Object)integer0));
      assertNotNull(integer2);
      
      Integer integer3 = gCFrameAlgorithm0.getDefaultStepSize(1);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertNull(integer3);
      
      Integer integer4 = gCFrameAlgorithm0.getDefaultWindowSize();
      assertEquals(120, (int)integer4);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertTrue(integer4.equals((Object)integer1));
      assertFalse(integer4.equals((Object)integer2));
      assertFalse(integer4.equals((Object)integer0));
      assertNotNull(integer4);
      
      float[] floatArray0 = new float[5];
      floatArray0[0] = (float) 2;
      Float float0 = gCFrameAlgorithm0.getMinimumInternal();
      assertEquals(0.0F, (float)float0, 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertNotNull(float0);
      
      floatArray0[1] = (float) 1;
      gCFrameAlgorithm0.setRevCompDisplay(false);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      
      floatArray0[2] = (float) 2;
      floatArray0[3] = (float) 2;
      floatArray0[4] = (float) 1;
      Float float1 = gCFrameAlgorithm0.getMinimum();
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertNull(float1);
      
      // Undeclared exception!
      try { 
        gCFrameAlgorithm0.getValues(2, 1, floatArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("uk.ac.sanger.artemis.plot.GCFrameAlgorithm");
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(42, emblStreamSequence0.length());
      assertEquals(2, emblStreamSequence0.getGCount());
      assertEquals(4, emblStreamSequence0.getACount());
      assertEquals(3, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(32, emblStreamSequence0.getOtherCount());
      assertNotNull(emblStreamSequence0);
      
      EmblStreamSequence emblStreamSequence1 = (EmblStreamSequence)emblStreamSequence0.copy();
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(42, emblStreamSequence0.length());
      assertEquals(2, emblStreamSequence0.getGCount());
      assertEquals(4, emblStreamSequence0.getACount());
      assertEquals(3, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(32, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence1.getFormatType());
      assertEquals(1, emblStreamSequence1.getCCount());
      assertNull(emblStreamSequence1.getHeader());
      assertEquals(2, emblStreamSequence1.getGCount());
      assertEquals(4, emblStreamSequence1.getACount());
      assertEquals(42, emblStreamSequence1.length());
      assertEquals(3, emblStreamSequence1.getTCount());
      assertEquals(32, emblStreamSequence1.getOtherCount());
      assertFalse(emblStreamSequence1.equals((Object)emblStreamSequence0));
      assertNotSame(emblStreamSequence0, emblStreamSequence1);
      assertNotSame(emblStreamSequence1, emblStreamSequence0);
      assertNotNull(emblStreamSequence1);
      
      Bases bases0 = new Bases(emblStreamSequence1);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(42, emblStreamSequence0.length());
      assertEquals(2, emblStreamSequence0.getGCount());
      assertEquals(4, emblStreamSequence0.getACount());
      assertEquals(3, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(32, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence1.getFormatType());
      assertEquals(1, emblStreamSequence1.getCCount());
      assertNull(emblStreamSequence1.getHeader());
      assertEquals(2, emblStreamSequence1.getGCount());
      assertEquals(4, emblStreamSequence1.getACount());
      assertEquals(42, emblStreamSequence1.length());
      assertEquals(3, emblStreamSequence1.getTCount());
      assertEquals(32, emblStreamSequence1.getOtherCount());
      assertFalse(emblStreamSequence0.equals((Object)emblStreamSequence1));
      assertFalse(emblStreamSequence1.equals((Object)emblStreamSequence0));
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(bases0);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(true, false).when(strand0).isForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(42, emblStreamSequence0.length());
      assertEquals(2, emblStreamSequence0.getGCount());
      assertEquals(4, emblStreamSequence0.getACount());
      assertEquals(3, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(32, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence1.getFormatType());
      assertEquals(1, emblStreamSequence1.getCCount());
      assertNull(emblStreamSequence1.getHeader());
      assertEquals(2, emblStreamSequence1.getGCount());
      assertEquals(4, emblStreamSequence1.getACount());
      assertEquals(42, emblStreamSequence1.length());
      assertEquals(3, emblStreamSequence1.getTCount());
      assertEquals(32, emblStreamSequence1.getOtherCount());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertFalse(emblStreamSequence0.equals((Object)emblStreamSequence1));
      assertFalse(emblStreamSequence1.equals((Object)emblStreamSequence0));
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(gCFrameAlgorithm0);
      
      gCFrameAlgorithm0.setUserMaxMin(false);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(42, emblStreamSequence0.length());
      assertEquals(2, emblStreamSequence0.getGCount());
      assertEquals(4, emblStreamSequence0.getACount());
      assertEquals(3, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(32, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence1.getFormatType());
      assertEquals(1, emblStreamSequence1.getCCount());
      assertNull(emblStreamSequence1.getHeader());
      assertEquals(2, emblStreamSequence1.getGCount());
      assertEquals(4, emblStreamSequence1.getACount());
      assertEquals(42, emblStreamSequence1.length());
      assertEquals(3, emblStreamSequence1.getTCount());
      assertEquals(32, emblStreamSequence1.getOtherCount());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertFalse(emblStreamSequence0.equals((Object)emblStreamSequence1));
      assertFalse(emblStreamSequence1.equals((Object)emblStreamSequence0));
      assertNotSame(emblStreamSequence0, emblStreamSequence1);
      assertNotSame(emblStreamSequence1, emblStreamSequence0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      gCFrameAlgorithm0.setUserMaxMin(false);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(42, emblStreamSequence0.length());
      assertEquals(2, emblStreamSequence0.getGCount());
      assertEquals(4, emblStreamSequence0.getACount());
      assertEquals(3, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(32, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence1.getFormatType());
      assertEquals(1, emblStreamSequence1.getCCount());
      assertNull(emblStreamSequence1.getHeader());
      assertEquals(2, emblStreamSequence1.getGCount());
      assertEquals(4, emblStreamSequence1.getACount());
      assertEquals(42, emblStreamSequence1.length());
      assertEquals(3, emblStreamSequence1.getTCount());
      assertEquals(32, emblStreamSequence1.getOtherCount());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertFalse(emblStreamSequence0.equals((Object)emblStreamSequence1));
      assertFalse(emblStreamSequence1.equals((Object)emblStreamSequence0));
      assertNotSame(emblStreamSequence0, emblStreamSequence1);
      assertNotSame(emblStreamSequence1, emblStreamSequence0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      float[] floatArray0 = new float[6];
      floatArray0[0] = (float) 1;
      gCFrameAlgorithm0.setUserMaxMin(false);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(42, emblStreamSequence0.length());
      assertEquals(2, emblStreamSequence0.getGCount());
      assertEquals(4, emblStreamSequence0.getACount());
      assertEquals(3, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(32, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence1.getFormatType());
      assertEquals(1, emblStreamSequence1.getCCount());
      assertNull(emblStreamSequence1.getHeader());
      assertEquals(2, emblStreamSequence1.getGCount());
      assertEquals(4, emblStreamSequence1.getACount());
      assertEquals(42, emblStreamSequence1.length());
      assertEquals(3, emblStreamSequence1.getTCount());
      assertEquals(32, emblStreamSequence1.getOtherCount());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertFalse(emblStreamSequence0.equals((Object)emblStreamSequence1));
      assertFalse(emblStreamSequence1.equals((Object)emblStreamSequence0));
      assertNotSame(emblStreamSequence0, emblStreamSequence1);
      assertNotSame(emblStreamSequence1, emblStreamSequence0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      floatArray0[1] = (float) 0;
      gCFrameAlgorithm0.setRevCompDisplay(true);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(42, emblStreamSequence0.length());
      assertEquals(2, emblStreamSequence0.getGCount());
      assertEquals(4, emblStreamSequence0.getACount());
      assertEquals(3, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(32, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence1.getFormatType());
      assertEquals(1, emblStreamSequence1.getCCount());
      assertNull(emblStreamSequence1.getHeader());
      assertEquals(2, emblStreamSequence1.getGCount());
      assertEquals(4, emblStreamSequence1.getACount());
      assertEquals(42, emblStreamSequence1.length());
      assertEquals(3, emblStreamSequence1.getTCount());
      assertEquals(32, emblStreamSequence1.getOtherCount());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertTrue(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertFalse(emblStreamSequence0.equals((Object)emblStreamSequence1));
      assertFalse(emblStreamSequence1.equals((Object)emblStreamSequence0));
      assertNotSame(emblStreamSequence0, emblStreamSequence1);
      assertNotSame(emblStreamSequence1, emblStreamSequence0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      floatArray0[2] = (float) 0;
      floatArray0[3] = (float) 1;
      floatArray0[4] = (float) 1;
      floatArray0[5] = (float) 2;
      gCFrameAlgorithm0.getValues(0, 2, floatArray0);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(42, emblStreamSequence0.length());
      assertEquals(2, emblStreamSequence0.getGCount());
      assertEquals(4, emblStreamSequence0.getACount());
      assertEquals(3, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(32, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence1.getFormatType());
      assertEquals(1, emblStreamSequence1.getCCount());
      assertNull(emblStreamSequence1.getHeader());
      assertEquals(2, emblStreamSequence1.getGCount());
      assertEquals(4, emblStreamSequence1.getACount());
      assertEquals(42, emblStreamSequence1.length());
      assertEquals(3, emblStreamSequence1.getTCount());
      assertEquals(32, emblStreamSequence1.getOtherCount());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertTrue(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertArrayEquals(new float[] {0.0F, 0.0F, 0.0F, 1.0F, 1.0F, 2.0F}, floatArray0, 0.01F);
      assertFalse(emblStreamSequence0.equals((Object)emblStreamSequence1));
      assertFalse(emblStreamSequence1.equals((Object)emblStreamSequence0));
      assertNotSame(emblStreamSequence0, emblStreamSequence1);
      assertNotSame(emblStreamSequence1, emblStreamSequence0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(6, floatArray0.length);
      
      Integer integer0 = gCFrameAlgorithm0.getDefaultStepSize(0);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(42, emblStreamSequence0.length());
      assertEquals(2, emblStreamSequence0.getGCount());
      assertEquals(4, emblStreamSequence0.getACount());
      assertEquals(3, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(32, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence1.getFormatType());
      assertEquals(1, emblStreamSequence1.getCCount());
      assertNull(emblStreamSequence1.getHeader());
      assertEquals(2, emblStreamSequence1.getGCount());
      assertEquals(4, emblStreamSequence1.getACount());
      assertEquals(42, emblStreamSequence1.length());
      assertEquals(3, emblStreamSequence1.getTCount());
      assertEquals(32, emblStreamSequence1.getOtherCount());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertTrue(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertFalse(emblStreamSequence0.equals((Object)emblStreamSequence1));
      assertFalse(emblStreamSequence1.equals((Object)emblStreamSequence0));
      assertNotSame(emblStreamSequence0, emblStreamSequence1);
      assertNotSame(emblStreamSequence1, emblStreamSequence0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNull(integer0);
      
      Integer integer1 = gCFrameAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(500, (int)integer1);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(42, emblStreamSequence0.length());
      assertEquals(2, emblStreamSequence0.getGCount());
      assertEquals(4, emblStreamSequence0.getACount());
      assertEquals(3, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(32, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence1.getFormatType());
      assertEquals(1, emblStreamSequence1.getCCount());
      assertNull(emblStreamSequence1.getHeader());
      assertEquals(2, emblStreamSequence1.getGCount());
      assertEquals(4, emblStreamSequence1.getACount());
      assertEquals(42, emblStreamSequence1.length());
      assertEquals(3, emblStreamSequence1.getTCount());
      assertEquals(32, emblStreamSequence1.getOtherCount());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertTrue(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertFalse(emblStreamSequence0.equals((Object)emblStreamSequence1));
      assertFalse(emblStreamSequence1.equals((Object)emblStreamSequence0));
      assertNotSame(emblStreamSequence0, emblStreamSequence1);
      assertNotSame(emblStreamSequence1, emblStreamSequence0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNotNull(integer1);
      
      Integer integer2 = gCFrameAlgorithm0.getDefaultStepSize((-5));
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(42, emblStreamSequence0.length());
      assertEquals(2, emblStreamSequence0.getGCount());
      assertEquals(4, emblStreamSequence0.getACount());
      assertEquals(3, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(32, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence1.getFormatType());
      assertEquals(1, emblStreamSequence1.getCCount());
      assertNull(emblStreamSequence1.getHeader());
      assertEquals(2, emblStreamSequence1.getGCount());
      assertEquals(4, emblStreamSequence1.getACount());
      assertEquals(42, emblStreamSequence1.length());
      assertEquals(3, emblStreamSequence1.getTCount());
      assertEquals(32, emblStreamSequence1.getOtherCount());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertTrue(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertFalse(emblStreamSequence0.equals((Object)emblStreamSequence1));
      assertFalse(emblStreamSequence1.equals((Object)emblStreamSequence0));
      assertNotSame(emblStreamSequence0, emblStreamSequence1);
      assertNotSame(emblStreamSequence1, emblStreamSequence0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertNull(integer2);
      
      // Undeclared exception!
      try { 
        gCFrameAlgorithm0.getValues((-3093), 507, floatArray0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("The empty alphabet contains nothing");
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getACount());
      assertEquals(26, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(4, emblStreamSequence0.getTCount());
      assertEquals(35, emblStreamSequence0.length());
      assertNotNull(emblStreamSequence0);
      
      Bases bases0 = new Bases(emblStreamSequence0);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getACount());
      assertEquals(26, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(4, emblStreamSequence0.getTCount());
      assertEquals(35, emblStreamSequence0.length());
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertNotNull(bases0);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getACount());
      assertEquals(26, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(4, emblStreamSequence0.getTCount());
      assertEquals(35, emblStreamSequence0.length());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertNotNull(gCFrameAlgorithm0);
      
      gCFrameAlgorithm0.setUserMax(2.0F);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getACount());
      assertEquals(26, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(4, emblStreamSequence0.getTCount());
      assertEquals(35, emblStreamSequence0.length());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(2.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      
      gCFrameAlgorithm0.setScalingFlag(false);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getACount());
      assertEquals(26, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(4, emblStreamSequence0.getTCount());
      assertEquals(35, emblStreamSequence0.length());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(2.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertFalse(gCFrameAlgorithm0.scalingFlag());
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      
      Graphics graphics0 = mock(Graphics.class, new ViolatedAssumptionAnswer());
      LineAttributes[] lineAttributesArray0 = new LineAttributes[3];
      lineAttributesArray0[1] = lineAttributesArray0[0];
      Integer integer0 = GVTAttributedCharacterIterator.TextAttribute.ADJUST_SPACING;
      assertEquals(0, (int)integer0);
      assertNotNull(integer0);
      
      Integer integer1 = gCFrameAlgorithm0.getDefaultStepSize(58);
      assertEquals(7, (int)integer1);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getACount());
      assertEquals(26, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(4, emblStreamSequence0.getTCount());
      assertEquals(35, emblStreamSequence0.length());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(2.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertFalse(gCFrameAlgorithm0.scalingFlag());
      assertFalse(integer1.equals((Object)integer0));
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertNotNull(integer1);
      
      lineAttributesArray0[2] = lineAttributesArray0[1];
      gCFrameAlgorithm0.drawLegend(graphics0, 1, 2, lineAttributesArray0, 2);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getACount());
      assertEquals(26, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(4, emblStreamSequence0.getTCount());
      assertEquals(35, emblStreamSequence0.length());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(2.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertFalse(gCFrameAlgorithm0.scalingFlag());
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(3, lineAttributesArray0.length);
      
      Integer integer2 = gCFrameAlgorithm0.getDefaultWindowSize();
      assertEquals(120, (int)integer2);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(3, emblStreamSequence0.getACount());
      assertEquals(26, emblStreamSequence0.getOtherCount());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(4, emblStreamSequence0.getTCount());
      assertEquals(35, emblStreamSequence0.length());
      assertEquals("Reverse GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertEquals(2.0F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertFalse(gCFrameAlgorithm0.scalingFlag());
      assertFalse(integer2.equals((Object)integer0));
      assertFalse(integer2.equals((Object)integer1));
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertNotNull(integer2);
      
      float[] floatArray0 = new float[6];
      floatArray0[0] = (float) 1;
      emblStreamSequence0.setFromChar(bases0.letter_index);
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(1, emblStreamSequence0.getGCount());
      assertEquals(5, emblStreamSequence0.length());
      assertEquals(1, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(1, emblStreamSequence0.getTCount());
      assertEquals(1, emblStreamSequence0.getCCount());
      assertEquals(1, emblStreamSequence0.getOtherCount());
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      
      floatArray0[1] = (float) 58;
      floatArray0[2] = (-1.0F);
      floatArray0[3] = (float) (-319);
      boolean boolean0 = FileSystemHandling.setPermissions((EvoSuiteFile) null, false, false, true);
      assertFalse(boolean0);
      
      floatArray0[4] = 365.90173F;
      floatArray0[5] = 2.0F;
      // Undeclared exception!
      try { 
        gCFrameAlgorithm0.getValues(114, (-319), floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 114 > end: -319
         //
         verifyException("uk.ac.sanger.artemis.plot.GCFrameAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(true, false).when(strand0).isForwardStrand();
      GCFrameAlgorithm gCFrameAlgorithm0 = new GCFrameAlgorithm(strand0);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(gCFrameAlgorithm0);
      
      Integer integer0 = gCFrameAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(500, (int)integer0);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(integer0);
      
      Float float0 = gCFrameAlgorithm0.getMinimum();
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertNull(float0);
      
      gCFrameAlgorithm0.setScalingFlag(true);
      assertFalse(gCFrameAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      
      gCFrameAlgorithm0.setRevCompDisplay(true);
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.isRevCompDisplay());
      
      int int0 = gCFrameAlgorithm0.getValueCount();
      assertEquals(3, int0);
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.isRevCompDisplay());
      
      Integer integer1 = gCFrameAlgorithm0.getDefaultMinWindowSize();
      assertEquals(24, (int)integer1);
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.isRevCompDisplay());
      assertFalse(integer1.equals((Object)integer0));
      assertFalse(integer1.equals((Object)int0));
      assertNotNull(integer1);
      
      Integer integer2 = gCFrameAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(500, (int)integer2);
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.isRevCompDisplay());
      assertTrue(integer2.equals((Object)integer0));
      assertFalse(integer2.equals((Object)integer1));
      assertFalse(integer2.equals((Object)int0));
      assertNotNull(integer2);
      
      Integer integer3 = gCFrameAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(500, (int)integer3);
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.isRevCompDisplay());
      assertTrue(integer3.equals((Object)integer2));
      assertFalse(integer3.equals((Object)integer1));
      assertFalse(integer3.equals((Object)int0));
      assertTrue(integer3.equals((Object)integer0));
      assertNotNull(integer3);
      
      int int1 = gCFrameAlgorithm0.getValueCount();
      assertEquals(3, int1);
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.isRevCompDisplay());
      assertTrue(int1 == int0);
      
      Float float1 = gCFrameAlgorithm0.getMaximumInternal();
      assertEquals(100.0F, (float)float1, 0.01F);
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.isRevCompDisplay());
      assertNotNull(float1);
      
      Float float2 = gCFrameAlgorithm0.getMaximum();
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.isRevCompDisplay());
      assertNull(float2);
      
      Integer integer4 = gCFrameAlgorithm0.getDefaultStepSize((-2319));
      assertEquals(3.4028235E38F, gCFrameAlgorithm0.getUserMax(), 0.01F);
      assertTrue(gCFrameAlgorithm0.scalingFlag());
      assertEquals("GC Frame Plot", gCFrameAlgorithm0.getAlgorithmName());
      assertFalse(gCFrameAlgorithm0.isUserMaxMin());
      assertEquals("gc_frame", gCFrameAlgorithm0.getAlgorithmShortName());
      assertEquals(3, gCFrameAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, gCFrameAlgorithm0.getUserMin(), 0.01F);
      assertTrue(gCFrameAlgorithm0.isRevCompDisplay());
      assertNull(integer4);
  }
}
