/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.send;

import java.io.IOException;
import java.io.OutputStream;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.NotLongDataParameterHolder;
import org.mariadb.jdbc.internal.packet.dao.parameters.NullParameter;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.packet.send.InterfaceSendPacket;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;

public class SendExecutePrepareStatementPacket
implements InterfaceSendPacket {
    private final int parameterCount;
    private final ParameterHolder[] parameters;
    private final int statementId;
    private MariaDbType[] parameterTypeHeader;

    public SendExecutePrepareStatementPacket(int statementId, ParameterHolder[] parameters, int parameterCount, MariaDbType[] parameterTypeHeader) {
        this.parameterCount = parameterCount;
        this.parameters = parameters;
        this.statementId = statementId;
        this.parameterTypeHeader = parameterTypeHeader;
    }

    @Override
    public void send(OutputStream os) throws IOException {
        PacketOutputStream buffer = (PacketOutputStream)os;
        buffer.startPacket(0, true);
        buffer.buffer.put((byte)23);
        buffer.buffer.putInt(this.statementId);
        buffer.buffer.put((byte)0);
        buffer.buffer.putInt(1);
        if (this.parameterCount > 0) {
            int i2;
            int nullCount = (this.parameterCount + 7) / 8;
            byte[] nullBitsBuffer = new byte[nullCount];
            for (int i3 = 0; i3 < this.parameterCount; ++i3) {
                if (!(this.parameters[i3] instanceof NullParameter)) continue;
                int n2 = i3 / 8;
                nullBitsBuffer[n2] = (byte)(nullBitsBuffer[n2] | 1 << i3 % 8);
            }
            buffer.write(nullBitsBuffer);
            boolean mustSendHeaderType = false;
            if (this.parameterTypeHeader[0] == null) {
                mustSendHeaderType = true;
            } else {
                for (i2 = 0; i2 < this.parameterCount; ++i2) {
                    if (this.parameterTypeHeader[i2].equals((Object)this.parameters[i2].getMariaDbType())) continue;
                    mustSendHeaderType = true;
                    break;
                }
            }
            if (mustSendHeaderType) {
                buffer.buffer.put((byte)1);
                for (i2 = 0; i2 < this.parameterCount; ++i2) {
                    this.parameterTypeHeader[i2] = this.parameters[i2].getMariaDbType();
                    this.parameters[i2].writeBufferType(buffer);
                }
            } else {
                buffer.buffer.put((byte)0);
            }
        }
        for (int i4 = 0; i4 < this.parameterCount; ++i4) {
            if (!(this.parameters[i4] instanceof NotLongDataParameterHolder)) continue;
            ((NotLongDataParameterHolder)this.parameters[i4]).writeBinary(buffer);
        }
        buffer.finishPacket();
    }
}

