use warnings;
use strict;

use Test::More tests => 752;

use IO::File 1.03;

BEGIN { use_ok "Data::Entropy::Source"; }

my $rawsource = IO::File->new("t/test0.entropy", "r") or die $!;
my $source = Data::Entropy::Source->new($rawsource, "getc");
ok $source;

while(<DATA>) {
	while(/([0-9])/g) {
		is $source->get_prob(3, 1000), $1;
	}
}

1;

__DATA__
111111111111111111111111111111111111111111111111111111111111111111111111111
111111111111110101111111111111111111111111111111111111111111111111111111111
111111111111111111111111111111111111111111111111111111111111111111111111111
111111111111111111111111111111111111111111111111111111111111111111111111111
111111111111111111111111111111111111111111111111111111111111111111111111111
111111111111111111111111111111111111111111111111111111111111111111111111111
111111111111111111111111111111111111111111111111111111111111111111111111111
111111111111111111111111111111111111111111111111111111111111111111111111111
111111111111111111111111111111111111111111111111111111111111111111111111111
111111111111111111111111111111111111111111111111111111111111111111111111111
