package App::BPOMUtils::Table::FoodTypeRBAProducer;

use 5.010001;
use strict 'subs', 'vars';
use utf8;
use warnings;
use Log::ger;

use Exporter 'import';
use Perinci::Sub::Gen::AccessTable qw(gen_read_table_func);

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2025-05-22'; # DATE
our $DIST = 'App-BPOMUtils-Table-FoodType'; # DIST
our $VERSION = '0.021'; # VERSION

our @EXPORT_OK = qw(
                       bpom_list_food_types_rba_producer
               );

our %SPEC;

# BEGIN FRAGMENT id=meta-idn_bpom_jenis_pangan_rba_produsen varname=meta_idn_bpom_jenis_pangan_rba_produsen
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idn_bpom_jenis_pangan_rba_produsen/meta.yaml
# src-revision: e2063114ea985d6735726a9c42fb5fb28050df7e (Tue Feb 14 11:36:11 2023 +0700)
# generate-date: Thu May 22 08:20:01 2025 UTC
# generated-by: update-fragments-in-perl-module
our $meta_idn_bpom_jenis_pangan_rba_produsen = {
  "fields" => {
    category_code => {
      "filterable_regex" => "Yes",
      "pos" => 5,
      "schema" => ["str*"],
      "sortable" => "Yes",
      "summary" => "Food category name",
      "summary.alt.lang.id" => "Nama kategori pangan",
      "unique" => "No",
    },
    dosage_form_code => {
      "filterable_regex" => "Yes",
      "pos" => 2,
      "schema" => ["str*", { match => "^[0-9]+\$" }],
      "sortable" => "Yes",
      "summary" => "Dosage form code",
      "summary.alt.lang.id" => "Kode bentuk sediaan",
      "unique" => "No",
    },
    dosage_form_name => {
      "filterable_regex" => "Yes",
      "pos" => 3,
      "schema" => ["str*"],
      "sortable" => "Yes",
      "summary" => "Dosage form name",
      "summary.alt.lang.id" => "Nama bentuk sediaan",
      "unique" => "No",
    },
    id => {
      filterable_regex => "Yes",
      pos => 0,
      schema => ["posint*"],
      sortable => "Yes",
      summary => "Numeric ID",
      unique => "Yes",
    },
    kbli_code => {
      "filterable_regex" => "Yes",
      "pos" => 1,
      "schema" => ["str*", { match => "^[0-9]+\$" }],
      "sortable" => "Yes",
      "summary" => "KBLI code",
      "summary.alt.lang.id" => "Kode KBLI",
      "unique" => "No",
    },
    mod_price => {
      "filterable_regex" => "Yes",
      "pos" => 8,
      "schema" => ["ufloat*"],
      "sortable" => "Yes",
      "summary" => "Price for modification of product",
      "summary.alt.lang.id" => "Harga perubahan product",
      "unique" => "No",
    },
    new_reg_price => {
      "filterable_regex" => "Yes",
      "pos" => 6,
      "schema" => ["ufloat*"],
      "sortable" => "Yes",
      "summary" => "Price for new registration of new product",
      "summary.alt.lang.id" => "Harga daftar baru produ",
      "unique" => "No",
    },
    rereg_price => {
      "filterable_regex" => "Yes",
      "pos" => 7,
      "schema" => ["ufloat*"],
      "sortable" => "Yes",
      "summary" => "Price for re-registration of product",
      "summary.alt.lang.id" => "Harga daftar ulang produk",
      "unique" => "No",
    },
    status => {
      "filterable_regex" => "Yes",
      "pos" => 9,
      "schema" => ["str*"],
      "sortable" => "Yes",
      "summary" => "Status",
      "summary.alt.lang.id" => "Status",
      "unique" => "No",
    },
  },
  "pk" => "id",
  "summary" => "Food types in BPOM processed food division (RBA version, for importers)",
  "summary.alt.lang.id_ID" => "Jenis pangan di BPOM pangan olahan (versi RBA, importir)",
};
# END FRAGMENT id=meta-idn_bpom_jenis_pangan_rba_produsen

# BEGIN FRAGMENT id=data-idn_bpom_jenis_pangan_rba_produsen varname=data_idn_bpom_jenis_pangan_rba_produsen
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idn_bpom_jenis_pangan_rba_produsen/data.csv
# src-revision: e2063114ea985d6735726a9c42fb5fb28050df7e (Tue Feb 14 11:36:11 2023 +0700)
# generate-date: Thu May 22 08:20:01 2025 UTC
# generated-by: update-fragments-in-perl-module
our $data_idn_bpom_jenis_pangan_rba_produsen = [
  [
    1,
    10510,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010101000001",
    "Susu Lemak Penuh (Full Cream) Murni",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    2,
    10510,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010101000002",
    "Susu Skim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    3,
    10510,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010101000003",
    "Susu Skim Sebagian",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    4,
    10510,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010102000001",
    "Susu Lemak Penuh Rekombinasi (Recombined Full Cream Milk)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    5,
    10520,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010102000001",
    "Susu Lemak Penuh Rekombinasi (Recombined Full Cream Milk)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    6,
    10510,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010102000002",
    "Susu Lemak Penuh Rekonstitusi (Reconstituted Full Cream Milk)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    7,
    10520,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010102000002",
    "Susu Lemak Penuh Rekonstitusi (Reconstituted Full Cream Milk)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    8,
    10510,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010102000003",
    "Susu Skim Rekonstitusi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    9,
    10510,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010102000004",
    "Susu Skim Sebagian Rekonstitusi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    10,
    10510,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010102000005",
    "Susu Skim Sebagian Rekombinasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    11,
    10510,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010102000006",
    "Susu Lemak Nabati/Susu Minyak Nabati (Filled Milk)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    12,
    10510,
    "0116",
    "Minuman susu, kecuali yang disterilisasi",
    "010102000007",
    "Minuman Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    13,
    10510,
    "0129",
    "Minuman susu yang disterilisasi",
    "010102000007",
    "Minuman Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    14,
    10510,
    "0116",
    "Minuman susu, kecuali yang disterilisasi",
    "010102000007",
    "Minuman Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    15,
    10510,
    "0129",
    "Minuman susu yang disterilisasi",
    "010102000007",
    "Minuman Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    16,
    10520,
    "0116",
    "Minuman susu, kecuali yang disterilisasi",
    "010102000007",
    "Minuman Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    17,
    10520,
    "0129",
    "Minuman susu yang disterilisasi",
    "010102000007",
    "Minuman Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    18,
    10520,
    "0116",
    "Minuman susu, kecuali yang disterilisasi",
    "010102000007",
    "Minuman Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    19,
    10520,
    "0129",
    "Minuman susu yang disterilisasi",
    "010102000007",
    "Minuman Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    20,
    10510,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    21,
    10510,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    22,
    10510,
    "0129",
    "Minuman susu yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    23,
    10510,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    24,
    10510,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    25,
    10510,
    "0129",
    "Minuman susu yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    26,
    10510,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    27,
    10510,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    28,
    10510,
    "0129",
    "Minuman susu yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    29,
    10520,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    30,
    10520,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    31,
    10520,
    "0129",
    "Minuman susu yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    32,
    10520,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    33,
    10520,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    34,
    10520,
    "0129",
    "Minuman susu yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    35,
    10520,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    36,
    10520,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    37,
    10520,
    "0129",
    "Minuman susu yang disterilisasi",
    "010102000008",
    "Minuman Mengandung Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    38,
    10510,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010102000009",
    "Minuman Susu Fermentasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    39,
    10510,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010102000009",
    "Minuman Susu Fermentasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    40,
    10510,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010102000009",
    "Minuman Susu Fermentasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    41,
    10510,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010102000009",
    "Minuman Susu Fermentasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    42,
    10590,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010102000009",
    "Minuman Susu Fermentasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    43,
    10590,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010102000009",
    "Minuman Susu Fermentasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    44,
    10590,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010102000009",
    "Minuman Susu Fermentasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    45,
    10590,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010102000009",
    "Minuman Susu Fermentasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    46,
    10590,
    "0113",
    "Lassi",
    "010102000010",
    "Lassi (Plain)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    47,
    10510,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010102000011",
    "Susu Lemak Penuh (Full Cream) dengan Penambahan Bahan Pangan Lain ",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    48,
    10510,
    "0102",
    "Buttermilk (plain) dengan proses pasteurisasi",
    "010103000001",
    "Buttermilk Cair",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    49,
    10510,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010104000001",
    "Susu (Rasa) Lemak Penuh (Full Cream Milk)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    50,
    10510,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010104000002",
    "Susu Berperisa/Susu Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    51,
    10510,
    "0116",
    "Minuman susu, kecuali yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    52,
    10510,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    53,
    10510,
    "0129",
    "Minuman susu yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    54,
    10510,
    "0116",
    "Minuman susu, kecuali yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    55,
    10510,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    56,
    10510,
    "0129",
    "Minuman susu yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    57,
    10520,
    "0116",
    "Minuman susu, kecuali yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    58,
    10520,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    59,
    10520,
    "0129",
    "Minuman susu yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    60,
    10520,
    "0116",
    "Minuman susu, kecuali yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    61,
    10520,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    62,
    10520,
    "0129",
    "Minuman susu yang disterilisasi",
    "010104000003",
    "Minuman Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    63,
    10510,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    64,
    10510,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    65,
    10510,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    66,
    10510,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    67,
    10520,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    68,
    10520,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    69,
    10520,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    70,
    10520,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    71,
    10590,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    72,
    10590,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    73,
    10590,
    "0115",
    "Minuman mengandung susu, kecuali yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    74,
    10590,
    "0128",
    "Minuman mengandung susu yang disterilisasi",
    "010104000004",
    "Minuman Mengandung Susu Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    75,
    10510,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010104000005",
    "Minuman Susu Fermentasi Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    76,
    10510,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010104000005",
    "Minuman Susu Fermentasi Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    77,
    10510,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010104000005",
    "Minuman Susu Fermentasi Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    78,
    10510,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010104000005",
    "Minuman Susu Fermentasi Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    79,
    10590,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010104000005",
    "Minuman Susu Fermentasi Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    80,
    10590,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010104000005",
    "Minuman Susu Fermentasi Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    81,
    10590,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010104000005",
    "Minuman Susu Fermentasi Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    82,
    10590,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010104000005",
    "Minuman Susu Fermentasi Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    83,
    10590,
    "0113",
    "Lassi",
    "010104000006",
    "Lassi (Rasa/Berperisa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    84,
    10510,
    "0104",
    "Cairan whey dan produknya, kecuali keju whey",
    "010104000007",
    "Minuman Berbasis Whey",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    85,
    10520,
    "0122",
    "Susu dan krim bubuk",
    "010104000008",
    "Susu Bubuk (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    86,
    10520,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000008",
    "Susu Bubuk (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    87,
    10520,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000008",
    "Susu Bubuk (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    88,
    10520,
    "0122",
    "Susu dan krim bubuk",
    "010104000008",
    "Susu Bubuk (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    89,
    10520,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000008",
    "Susu Bubuk (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    90,
    10520,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000008",
    "Susu Bubuk (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    91,
    10520,
    "0122",
    "Susu dan krim bubuk",
    "010104000008",
    "Susu Bubuk (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    92,
    10520,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000008",
    "Susu Bubuk (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    93,
    10520,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000008",
    "Susu Bubuk (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    94,
    10520,
    "0122",
    "Susu dan krim bubuk",
    "010104000009",
    "Susu Bubuk Skim (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    95,
    10520,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000009",
    "Susu Bubuk Skim (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    96,
    10520,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000009",
    "Susu Bubuk Skim (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    97,
    10520,
    "0122",
    "Susu dan krim bubuk",
    "010104000009",
    "Susu Bubuk Skim (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    98,
    10520,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000009",
    "Susu Bubuk Skim (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    99,
    10520,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000009",
    "Susu Bubuk Skim (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    100,
    10520,
    "0122",
    "Susu dan krim bubuk",
    "010104000009",
    "Susu Bubuk Skim (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    101,
    10520,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000009",
    "Susu Bubuk Skim (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    102,
    10520,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000009",
    "Susu Bubuk Skim (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    103,
    10520,
    "0122",
    "Susu dan krim bubuk",
    "010104000010",
    "Susu Bubuk Skim Sebagian (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    104,
    10520,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000010",
    "Susu Bubuk Skim Sebagian (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    105,
    10520,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000010",
    "Susu Bubuk Skim Sebagian (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    106,
    10520,
    "0122",
    "Susu dan krim bubuk",
    "010104000011",
    "Susu Bubuk Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    107,
    10520,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000011",
    "Susu Bubuk Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    108,
    10520,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000011",
    "Susu Bubuk Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    109,
    10520,
    "0122",
    "Susu dan krim bubuk",
    "010104000011",
    "Susu Bubuk Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    110,
    10520,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000011",
    "Susu Bubuk Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    111,
    10520,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000011",
    "Susu Bubuk Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    112,
    10520,
    "0122",
    "Susu dan krim bubuk",
    "010104000011",
    "Susu Bubuk Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    113,
    10520,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000011",
    "Susu Bubuk Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    114,
    10520,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000011",
    "Susu Bubuk Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    115,
    10520,
    "0122",
    "Susu dan krim bubuk",
    "010104000012",
    "Susu Bubuk Skim Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    116,
    10520,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000012",
    "Susu Bubuk Skim Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    117,
    10520,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000012",
    "Susu Bubuk Skim Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    118,
    10520,
    "0122",
    "Susu dan krim bubuk",
    "010104000013",
    "Susu Bubuk Skim Sebagian Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    119,
    10520,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000013",
    "Susu Bubuk Skim Sebagian Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    120,
    10520,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000013",
    "Susu Bubuk Skim Sebagian Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    121,
    10520,
    "0122",
    "Susu dan krim bubuk",
    "010104000013",
    "Susu Bubuk Skim Sebagian Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    122,
    10520,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000013",
    "Susu Bubuk Skim Sebagian Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    123,
    10520,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000013",
    "Susu Bubuk Skim Sebagian Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    124,
    10520,
    "0122",
    "Susu dan krim bubuk",
    "010104000014",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    125,
    10520,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000014",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    126,
    10520,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000014",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    127,
    10520,
    "0122",
    "Susu dan krim bubuk",
    "010104000014",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    128,
    10520,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000014",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    129,
    10520,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000014",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    130,
    10520,
    "0122",
    "Susu dan krim bubuk",
    "010104000014",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    131,
    10520,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000014",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    132,
    10520,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000014",
    "Campuran Susu dan Krim Bubuk Berperisa atau (dengan) Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    133,
    10520,
    "0122",
    "Susu dan krim bubuk",
    "010104000015",
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    134,
    10520,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000015",
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    135,
    10520,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000015",
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    136,
    10520,
    "0122",
    "Susu dan krim bubuk",
    "010104000015",
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    137,
    10520,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000015",
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    138,
    10520,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000015",
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    139,
    10520,
    "0122",
    "Susu dan krim bubuk",
    "010104000015",
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    140,
    10520,
    "0131",
    "Susu dan krim bubuk dari bahan baku bubuk",
    "010104000015",
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    141,
    10520,
    "0132",
    "Susu dan krim bubuk dari bahan baku cair",
    "010104000015",
    "Minuman Mengandung Susu Bubuk Berperisa atau dengan (Rasa)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    142,
    10520,
    "0122",
    "Susu dan krim bubuk",
    "010104000016",
    "Susu Bubuk Lemak Nabati/Susu Bubuk Minyak Nabati Rasa/Berperisa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    143,
    10590,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010104000017",
    "Minuman Kefir Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    144,
    10590,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010104000018",
    "Minuman Kumys Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    145,
    10590,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010104000019",
    "Minuman Yogurt Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    146,
    10590,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010104000020",
    "Lassi Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    147,
    10510,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010104000028",
    "Susu Skim Sebagian Rekonstitusi Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    148,
    10590,
    "0127",
    "Susu yang digumpalkan dengan enzim renin",
    "010200000001",
    "Dadih",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    149,
    10590,
    "0125",
    "Susu diasamkan",
    "010201010001",
    "Susu Diasamkan (Tanpa Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    150,
    10590,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010201010002",
    "Susu Asidofilus (Acidophilus Milk) (Tanpa Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    151,
    10590,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010201010003",
    "Yogurt (Tanpa Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    152,
    10590,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010201010004",
    "Yogurt Kultur Lain (Alternate Culture Yogurt) (Tanpa Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    153,
    10590,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010201010005",
    "Kefir (Tanpa Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    154,
    10590,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010201010006",
    "Kumys (Tanpa Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    155,
    10590,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010201010007",
    "Susu Fermentasi atau Susu Berkultur (Cultured Milk) (Tanpa Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    156,
    10590,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010201010008",
    "Minuman Yogurt (Tanpa Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    157,
    10510,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010201010009",
    "Minuman Kefir (Tanpa Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    158,
    10510,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010201010010",
    "Minuman Kumys (Tanpa Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    159,
    10510,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010201010011",
    "Minuman Susu Fermentasi (Tanpa Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    160,
    10590,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010201020001",
    "Susu Diasamkan (Dengan Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    161,
    10590,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010201020002",
    "Susu Asidofilus (Acidophilus Milk) (Dengan Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    162,
    10590,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010201020003",
    "Yogurt (Dengan Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    163,
    10590,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010201020004",
    "Yogurt Kultur Lain (Alternate Culture Yogurt) (Dengan Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    164,
    10590,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010201020005",
    "Kefir (Dengan Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    165,
    10590,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010201020006",
    "Kumys (Dengan Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    166,
    10590,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010201020007",
    "Susu Fermentasi atau Susu Berkultur (Cultured Milk) (Dengan Pemanasan Setelah Proses Fermentasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    167,
    10590,
    "0127",
    "Susu yang digumpalkan dengan enzim renin",
    "010202000001",
    "Susu yang digumpalkan dengan rennet (Plain)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    168,
    10520,
    "0126",
    "Susu evaporasi",
    "010301000001",
    "Susu Evaporasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    169,
    10520,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010301000002",
    "Susu Skim Evaporasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    170,
    10520,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010301000003",
    "Susu Skim Sebagian Evaporasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    171,
    10520,
    "0124",
    "Susu dan krim kental manis",
    "010301000004",
    "Susu Kental Manis",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    172,
    10520,
    "0124",
    "Susu dan krim kental manis",
    "010301000005",
    "Susu Skim Kental Manis",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    173,
    10520,
    "0124",
    "Susu dan krim kental manis",
    "010301000006",
    "Krim Kental Manis",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    174,
    10520,
    "0109",
    "Khoa",
    "010301000007",
    "Khoa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    175,
    10520,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010302000001",
    "Susu Lemak Nabati Evaporasi/ Susu Minyak Nabati Evaporasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    176,
    10520,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010302000002",
    "Susu Kental Manis Lemak Nabati/ Susu Kental Manis Minyak Nabati",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    177,
    10520,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010302000003",
    "Krimer Kental Manis",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    178,
    10795,
    "0112",
    "Krimer nabati",
    "010302000004",
    "Krimer Minuman ",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    179,
    82920,
    "0112",
    "Krimer nabati",
    "010302000004",
    "Krimer Minuman ",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    180,
    10795,
    "0112",
    "Krimer nabati",
    "010302000005",
    "Krimer Minuman Penghasil Buih",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    181,
    10510,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010400000001",
    "Krim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    182,
    10510,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010401000001",
    "Krim Pasteurisasi (Plain)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    183,
    10510,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010401000002",
    "Half and Half",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    184,
    10510,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010402000001",
    "Krim sterilisasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    185,
    10510,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010402000002",
    "Whipping cream",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    186,
    10510,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010402000003",
    "Whipped Cream",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    187,
    10510,
    "0111",
    "Krim yang digumpalkan",
    "010403000001",
    "Krim yang Digumpalkan Dengan Enzim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    188,
    10510,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010403000002",
    "Krim Asam",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    189,
    10510,
    "0117",
    "Pangan kategori 1 risiko sedang lainnya",
    "010403000003",
    "Krim yang Diasamkan",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    190,
    10510,
    "0110",
    "Krim nabati",
    "010404000001",
    "Krim Nabati (Khusus Registrasi Variasi)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    191,
    10510,
    "0110",
    "Krim Nabati",
    "010404000002",
    "Pengganti Krim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    192,
    10520,
    "0122",
    "Susu dan krim bubuk",
    "010501000001",
    "Susu Bubuk Lemak Penuh (Full Cream)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    193,
    10520,
    "0122",
    "Susu dan krim bubuk",
    "010501000002",
    "Susu Bubuk Lemak Penuh (Full Cream) Instan",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    194,
    10520,
    "0122",
    "Susu dan krim bubuk",
    "010501000003",
    "Susu Bubuk Skim Sebagian",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    195,
    10520,
    "0122",
    "Susu dan krim bubuk",
    "010501000004",
    "Susu Bubuk Skim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    196,
    82920,
    "0122",
    "Susu dan krim bubuk",
    "010501000004",
    "Susu Bubuk Skim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    197,
    10520,
    "0122",
    "Susu dan krim bubuk",
    "010501000005",
    "Campuran Susu dan Krim Bubuk (Plain)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    198,
    10520,
    "0122",
    "Susu dan krim bubuk",
    "010501000006",
    "Krim Bubuk",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    199,
    10520,
    "0103",
    "Buttermilk bubuk (plain)",
    "010501000007",
    "Bubuk Buttermilk",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    200,
    10520,
    "0122",
    "Susu dan krim bubuk",
    "010501000008",
    "Minuman Mengandung Susu Bubuk (Plain)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    201,
    10520,
    "0122",
    "Susu dan krim bubuk",
    "010502000001",
    "Susu Bubuk Lemak Nabati/Susu Bubuk Minyak Nabati",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    202,
    10590,
    "0107",
    "Keju olahan",
    "010600000001",
    "Keju",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    203,
    10590,
    "0107",
    "Keju olahan",
    "010600000002",
    "Analog Keju",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    204,
    10590,
    "0108",
    "Keju tanpa pemeraman (keju mentah)",
    "010601000001",
    "Keju Cottage (Cottage Cheese)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    205,
    10590,
    "0108",
    "Keju tanpa pemeraman (keju mentah)",
    "010601000002",
    "Keju Cottage yang Ditambah Krim (Creamed Cottage Cheese)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    206,
    10590,
    "0108",
    "Keju tanpa pemeraman (keju mentah)",
    "010601000003",
    "Keju Krim (Cream Cheese)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    207,
    10590,
    "0108",
    "Keju tanpa pemeraman (keju mentah)",
    "010601000004",
    "Keju Mozzarella",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    208,
    10590,
    "0108",
    "Keju tanpa pemeraman (keju mentah)",
    "010601000005",
    "Keju Bocconcini",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    209,
    10590,
    "0108",
    "Keju tanpa pemeraman (keju mentah)",
    "010601000006",
    "Keju Tanpa Pemeraman (Keju Mentah)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    210,
    10590,
    "0107",
    "Keju olahan",
    "010602010001",
    "Keju Cheddar",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    211,
    10590,
    "0107",
    "Keju olahan",
    "010602010002",
    "Keju Edam",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    212,
    10590,
    "0107",
    "Keju olahan",
    "010602010003",
    "Keju Camembert",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    213,
    10590,
    "0107",
    "Keju olahan",
    "010602010004",
    "Keju Bath",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    214,
    10590,
    "0107",
    "Keju olahan",
    "010602010005",
    "Keju Bondard",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    215,
    10590,
    "0107",
    "Keju olahan",
    "010602010006",
    "Keju Bougon",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    216,
    10590,
    "0107",
    "Keju olahan",
    "010602010007",
    "Keju Bouquet des moines",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    217,
    10590,
    "0107",
    "Keju olahan",
    "010602010008",
    "Keju Biru (Blue Cheese)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    218,
    10590,
    "0107",
    "Keju olahan",
    "010602010009",
    "Keju Bata (Brick Cheese)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    219,
    10590,
    "0107",
    "Keju olahan",
    "010602010010",
    "Keju Gouda",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    220,
    10590,
    "0107",
    "Keju olahan",
    "010602010011",
    "Keju Havarti",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    221,
    10590,
    "0107",
    "Keju olahan",
    "010602010012",
    "Keju Brie",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    222,
    10590,
    "0107",
    "Keju olahan",
    "010602010013",
    "Keju Parmesan",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    223,
    10590,
    "0107",
    "Keju olahan",
    "010602010014",
    "Keju Swiss",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    224,
    10590,
    "0107",
    "Keju olahan",
    "010602010015",
    "Keju Peram Lainnya",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    225,
    10590,
    "0134",
    "Keju Peram",
    "010602010016",
    "Keju Emmental/Keju Swiss",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    226,
    10590,
    "0107",
    "Keju olahan",
    "010602020001",
    "Kulit Keju Peram",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    227,
    10590,
    "0107",
    "Keju olahan",
    "010602030001",
    "Keju Bubuk (Untuk Rekonstitusi Contohnya Dalam Pembuatan Saus Keju)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    228,
    10590,
    "0107",
    "Keju olahan",
    "010603000001",
    "Keju Whey",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    229,
    10590,
    "0107",
    "Keju olahan",
    "010604000001",
    "Keju Olahan",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    230,
    10590,
    "0107",
    "Keju olahan",
    "010604010001",
    "Keju Olahan Plain",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    231,
    10590,
    "0107",
    "Keju olahan",
    "010604020001",
    "Keju Olahan Berperisa, Keju Olahan dengan Tambahan Buah, Sayur dan atau Daging",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    232,
    10590,
    "0107",
    "Keju olahan",
    "010605000001",
    "Analog Keju (Keju lemak nabati)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    233,
    10590,
    "0107",
    "Keju olahan",
    "010606000001",
    "Keju Protein Whey",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    234,
    10531,
    "0105",
    "Es krim",
    "010700000001",
    "Es Krim Susu (Dairy Ice Cream)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    235,
    10531,
    "0105",
    "Es krim",
    "010700000002",
    "Es Krim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    236,
    10531,
    "0106",
    "Es susu / es mengandung susu",
    "010700000003",
    "Es Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    237,
    10590,
    "0121",
    "Premiks bentuk cair",
    "010700000004",
    "Premiks Es Krim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    238,
    10590,
    "0619",
    "Premiks bentuk bubuk (termasuk pada kategori pangan 1, 5, 6, 7, 10, dan 14)",
    "010700000004",
    "Premiks Es Krim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    239,
    10590,
    "0121",
    "Premiks bentuk cair",
    "010700000004",
    "Premiks Es Krim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    240,
    10590,
    "0619",
    "Premiks bentuk bubuk (termasuk pada kategori pangan 1, 5, 6, 7, 10, dan 14)",
    "010700000004",
    "Premiks Es Krim",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    241,
    10590,
    "0121",
    "Premiks bentuk cair",
    "010700000005",
    "Premiks Es Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    242,
    10590,
    "0619",
    "Premiks bentuk bubuk (termasuk pada kategori pangan 1, 5, 6, 7, 10, dan 14)",
    "010700000005",
    "Premiks Es Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    243,
    10590,
    "0121",
    "Premiks bentuk cair",
    "010700000005",
    "Premiks Es Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    244,
    10590,
    "0619",
    "Premiks bentuk bubuk (termasuk pada kategori pangan 1, 5, 6, 7, 10, dan 14)",
    "010700000005",
    "Premiks Es Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    245,
    10590,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010700000006",
    "Yogurt Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    246,
    10590,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010700000007",
    "Yogurt Kultur Lain (Alternate Culture Yogurt) Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    247,
    10590,
    "0114",
    "Makanan pencuci mulut berbahan dasar susu",
    "010700000008",
    "Kefir",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    248,
    10590,
    "0120",
    "Pangan olahan hasil fermentasi susu yang dipasteurisasi",
    "010700000009",
    "Susu Fermentasi atau Susu Berkultur Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    249,
    10590,
    "0114",
    "Makanan pencuci mulut berbahan dasar susu",
    "010700000010",
    "Junket",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    250,
    10590,
    "0114",
    "Makanan pencuci mulut berbahan dasar susu",
    "010700000011",
    "Dulce de leche",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    251,
    10590,
    "0114",
    "Makanan pencuci mulut berbahan dasar susu",
    "010700000012",
    "Puding Butterscotch/Puding Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    252,
    10590,
    "0114",
    "Makanan pencuci mulut berbahan dasar susu",
    "010700000013",
    "Bubuk Puding Butterscotch/Puding Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    253,
    10590,
    "0114",
    "Makanan pencuci mulut berbahan dasar susu",
    "010700000014",
    "Kembang Gula / Permen Susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    254,
    10590,
    "0114",
    "Makanan pencuci mulut berbahan dasar susu",
    "010700000015",
    "Makanan pencuci mulut berbasis susu",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    255,
    10590,
    "0118",
    "Pangan olahan hasil fermentasi susu",
    "010700000016",
    "Kefir Berperisa/Rasa",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    256,
    10590,
    "0114",
    "Makanan pencuci mulut berbahan dasar susu",
    "010700000017",
    "Bola-bola Keju dalam Sirup Gula (Rasgulla/ Rasagola/ Roshogolla/ Rasogolla)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    257,
    10590,
    "0114",
    "Makanan pencuci mulut berbahan dasar susu",
    "010700000018",
    "Bola-Bola Keju Goreng dalam Sirup Gula (Gulab jamun/ gulaab jamun/ gulab ki janu)",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    258,
    10590,
    "0104",
    "Cairan whey dan produknya, kecuali keju whey",
    "010801000001",
    "Whey",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    259,
    10590,
    "0104",
    "Cairan whey dan produknya, kecuali keju whey",
    "010801000002",
    "Whey Asam",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    260,
    10590,
    "0101",
    "Bubuk whey dan produknya, kecuali keju whey",
    "010802000001",
    "Bubuk Whey",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    261,
    10590,
    "0101",
    "Bubuk whey dan produknya, kecuali keju whey",
    "010802000002",
    "Bubuk Whey yang Telah Didemineralisasi",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    262,
    10590,
    "0101",
    "Bubuk whey dan produknya, kecuali keju whey",
    "010802000003",
    "Bubuk Whey Permeate",
    750000,
    600000,
    400000,
    "Aktif",
  ],
  [
    263,
    10590,
    "0209",
    "Pangan kategori 2 risiko sedang lainnya",
    "020101000001",
    "Lemak Susu Anhidrat (AMF), Minyak Mentega (butter oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    264,
    10590,
    "0204",
    "Ghee",
    "020101000002",
    "Ghee",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    265,
    10411,
    "0205",
    "Lemak dan minyak nabati",
    "020102000001",
    "Lemak dan Minyak Nabati",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    266,
    10415,
    "0205",
    "Lemak dan minyak nabati",
    "020102000001",
    "Lemak dan Minyak Nabati",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    267,
    10411,
    "0210",
    "Virgin oil",
    "020102000002",
    "Virgin Oil ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    268,
    10415,
    "0210",
    "Virgin oil",
    "020102000002",
    "Virgin Oil ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    269,
    10422,
    "0210",
    "Virgin oil",
    "020102000002",
    "Virgin Oil ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    270,
    82920,
    "0210",
    "Virgin oil",
    "020102000002",
    "Virgin Oil ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    271,
    10411,
    "0210",
    "Virgin oil",
    "020102000003",
    "Extra Virgin Olive Oil",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    272,
    10415,
    "0210",
    "Virgin oil",
    "020102000003",
    "Extra Virgin Olive Oil",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    273,
    10411,
    "0210",
    "Virgin oil",
    "020102000004",
    "Virgin Olive Oil",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    274,
    10415,
    "0210",
    "Virgin oil",
    "020102000004",
    "Virgin Olive Oil",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    275,
    10411,
    "0210",
    "Virgin oil",
    "020102000005",
    "Ordinary Virgin Olive Oil",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    276,
    10415,
    "0210",
    "Virgin oil",
    "020102000005",
    "Ordinary Virgin Olive Oil",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    277,
    10411,
    "0201",
    "Cold pressed oils",
    "020102000006",
    "Cold Pressed Oils",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    278,
    10415,
    "0201",
    "Cold pressed oils",
    "020102000006",
    "Cold Pressed Oils",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    279,
    82920,
    "0201",
    "Cold pressed oils",
    "020102000006",
    "Cold Pressed Oils",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    280,
    10411,
    "0205",
    "Lemak dan minyak nabati",
    "020102000007",
    "Minyak Goreng (Frying oil) ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    281,
    10415,
    "0205",
    "Lemak dan minyak nabati",
    "020102000007",
    "Minyak Goreng (Frying oil) ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    282,
    82920,
    "0205",
    "Lemak dan minyak nabati",
    "020102000007",
    "Minyak Goreng (Frying oil) ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    283,
    10411,
    "0205",
    "Lemak dan minyak nabati",
    "020102000008",
    "Minyak Goreng Padat (Frying Fat)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    284,
    10415,
    "0205",
    "Lemak dan minyak nabati",
    "020102000008",
    "Minyak Goreng Padat (Frying Fat)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    285,
    10437,
    "0205",
    "Lemak dan minyak nabati",
    "020102000008",
    "Minyak Goreng Padat (Frying Fat)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    286,
    10411,
    "0205",
    "Lemak dan minyak nabati",
    "020102000009",
    "Minyak Masak atau Minyak Sayur (Cooking Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    287,
    10415,
    "0205",
    "Lemak dan minyak nabati",
    "020102000009",
    "Minyak Masak atau Minyak Sayur (Cooking Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    288,
    82920,
    "0205",
    "Lemak dan minyak nabati",
    "020102000009",
    "Minyak Masak atau Minyak Sayur (Cooking Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    289,
    10411,
    "0205",
    "Lemak dan minyak nabati",
    "020102000010",
    "Minyak Salad (Salad Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    290,
    10415,
    "0205",
    "Lemak dan minyak nabati",
    "020102000010",
    "Minyak Salad (Salad Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    291,
    10411,
    "0205",
    "Lemak dan minyak nabati",
    "020102000011",
    "Serbuk Lemak Nabati (Fat Powder)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    292,
    10411,
    "0205",
    "Lemak dan minyak nabati",
    "020102000012",
    "Vanaspati atau Minyak Samin (Vegetable Ghee)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    293,
    10415,
    "0205",
    "Lemak dan minyak nabati",
    "020102000012",
    "Vanaspati atau Minyak Samin (Vegetable Ghee)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    294,
    10411,
    "0205",
    "Lemak dan minyak nabati",
    "020102000013",
    "Lemak Reroti (Shortening)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    295,
    10411,
    "0206",
    "Campuran lemak nabati dan hewani",
    "020102000013",
    "Lemak Reroti (Shortening)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    296,
    10411,
    "0205",
    "Lemak dan minyak nabati",
    "020102000013",
    "Lemak Reroti (Shortening)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    297,
    10411,
    "0206",
    "Campuran lemak nabati dan hewani",
    "020102000013",
    "Lemak Reroti (Shortening)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    298,
    10412,
    "0205",
    "Lemak dan minyak nabati",
    "020102000013",
    "Lemak Reroti (Shortening)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    299,
    10412,
    "0206",
    "Campuran lemak nabati dan hewani",
    "020102000013",
    "Lemak Reroti (Shortening)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    300,
    10412,
    "0205",
    "Lemak dan minyak nabati",
    "020102000013",
    "Lemak Reroti (Shortening)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    301,
    10412,
    "0206",
    "Campuran lemak nabati dan hewani",
    "020102000013",
    "Lemak Reroti (Shortening)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    302,
    10490,
    "0205",
    "Lemak dan minyak nabati",
    "020102000013",
    "Lemak Reroti (Shortening)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    303,
    10490,
    "0206",
    "Campuran lemak nabati dan hewani",
    "020102000013",
    "Lemak Reroti (Shortening)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    304,
    10490,
    "0205",
    "Lemak dan minyak nabati",
    "020102000013",
    "Lemak Reroti (Shortening)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    305,
    10490,
    "0206",
    "Campuran lemak nabati dan hewani",
    "020102000013",
    "Lemak Reroti (Shortening)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    306,
    10411,
    "0206",
    "Campuran lemak nabati dan hewani",
    "020102000014",
    "Pengganti Minyak Mentega (Butter Oil Substitute)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    307,
    10490,
    "0206",
    "Campuran lemak nabati dan hewani",
    "020102000014",
    "Pengganti Minyak Mentega (Butter Oil Substitute)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    308,
    10432,
    "0205",
    "Lemak dan minyak nabati",
    "020102000015",
    "Minyak Inti Kelapa Sawit Mentah (Crude Palm Kernel Oil/CPKO)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    309,
    10434,
    "0205",
    "Lemak dan minyak nabati",
    "020102000016",
    "Minyak Inti Kelapa Sawit (Refined Bleached Deodorized Palm Kernel Oil/RBDPKO)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    310,
    10431,
    "0205",
    "Lemak dan minyak nabati",
    "020102000017",
    "Minyak Kelapa Sawit Mentah (Crude Palm Oil/CPO) atau Pretreated Palm Oil",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    311,
    10434,
    "0205",
    "Lemak dan minyak nabati",
    "020102000018",
    "Minyak Kelapa Sawit (Refined Bleached Deodorized Palm Oil/RBDPO)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    312,
    10437,
    "0205",
    "Lemak dan minyak nabati",
    "020102000018",
    "Minyak Kelapa Sawit (Refined Bleached Deodorized Palm Oil/RBDPO)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    313,
    10433,
    "0205",
    "Lemak dan minyak nabati",
    "020102000019",
    "Minyak Olein Kelapa Sawit Mentah (Crude Palm Olein)",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    314,
    10435,
    "0205",
    "Lemak dan minyak nabati",
    "020102000020",
    "Minyak Stearin Kelapa Sawit Mentah (Crude Palm Stearin)",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    315,
    10435,
    "0205",
    "Lemak dan minyak nabati",
    "020102000021",
    "Minyak Olein Kelapa Sawit (Refined Bleached Deodorized Palm Olein)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    316,
    10435,
    "0205",
    "Lemak dan minyak nabati",
    "020102000022",
    "Stearin Kelapa Sawit (Refined Bleached Deodorized Palm Stearin/RBDPS)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    317,
    10431,
    "0208",
    "Minyak goreng sawit",
    "020102000023",
    "Minyak Goreng Sawit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    318,
    10432,
    "0208",
    "Minyak goreng sawit",
    "020102000023",
    "Minyak Goreng Sawit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    319,
    10433,
    "0208",
    "Minyak goreng sawit",
    "020102000023",
    "Minyak Goreng Sawit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    320,
    10434,
    "0208",
    "Minyak goreng sawit",
    "020102000023",
    "Minyak Goreng Sawit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    321,
    10435,
    "0208",
    "Minyak goreng sawit",
    "020102000023",
    "Minyak Goreng Sawit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    322,
    10436,
    "0208",
    "Minyak goreng sawit",
    "020102000023",
    "Minyak Goreng Sawit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    323,
    10437,
    "0208",
    "Minyak goreng sawit",
    "020102000023",
    "Minyak Goreng Sawit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    324,
    82920,
    "0208",
    "Minyak goreng sawit",
    "020102000023",
    "Minyak Goreng Sawit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    325,
    10422,
    "0205",
    "Lemak dan minyak nabati",
    "020102000024",
    "Minyak Kelapa Mentah atau Unrefined Coconut Oil/Crude Coconut Oil",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    326,
    10423,
    "0205",
    "Lemak dan minyak nabati",
    "020102000025",
    "Minyak Kelapa (Refined Bleached Deodorized Coconut Oil )",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    327,
    10411,
    "0205",
    "Lemak dan minyak nabati",
    "020102000026",
    "Minyak Kacang Tanah (Refined Bleached Deodorized Peanut Oil/Refined Bleached Deodorized Groundnut Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    328,
    10415,
    "0205",
    "Lemak dan minyak nabati",
    "020102000026",
    "Minyak Kacang Tanah (Refined Bleached Deodorized Peanut Oil/Refined Bleached Deodorized Groundnut Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    329,
    10411,
    "0205",
    "Lemak dan minyak nabati",
    "020102000027",
    "Minyak Jagung (Refined Bleached Deodorized Corn Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    330,
    10415,
    "0205",
    "Lemak dan minyak nabati",
    "020102000027",
    "Minyak Jagung (Refined Bleached Deodorized Corn Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    331,
    10411,
    "0205",
    "Lemak dan minyak nabati",
    "020102000028",
    "Minyak Kemiri (Refined Bleached Deodorized Candlenut/Lumbang Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    332,
    10415,
    "0205",
    "Lemak dan minyak nabati",
    "020102000028",
    "Minyak Kemiri (Refined Bleached Deodorized Candlenut/Lumbang Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    333,
    10411,
    "0205",
    "Lemak dan minyak nabati",
    "020102000029",
    "Minyak Kedelai (Refined Bleached Deodorized Soybean Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    334,
    10415,
    "0205",
    "Lemak dan minyak nabati",
    "020102000029",
    "Minyak Kedelai (Refined Bleached Deodorized Soybean Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    335,
    82920,
    "0205",
    "Lemak dan minyak nabati",
    "020102000029",
    "Minyak Kedelai (Refined Bleached Deodorized Soybean Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    336,
    10411,
    "0205",
    "Lemak dan minyak nabati",
    "020102000030",
    "Minyak Wijen (Sesame Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    337,
    10415,
    "0205",
    "Lemak dan minyak nabati",
    "020102000030",
    "Minyak Wijen (Sesame Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    338,
    10411,
    "0205",
    "Lemak dan minyak nabati",
    "020102000031",
    "Minyak Zaitun (Refined Bleached Deodorized Olive Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    339,
    10415,
    "0205",
    "Lemak dan minyak nabati",
    "020102000031",
    "Minyak Zaitun (Refined Bleached Deodorized Olive Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    340,
    82920,
    "0205",
    "Lemak dan minyak nabati",
    "020102000031",
    "Minyak Zaitun (Refined Bleached Deodorized Olive Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    341,
    10411,
    "0205",
    "Lemak dan minyak nabati",
    "020102000032",
    "Minyak Safflower (Refined Bleached Deodorized Safflower Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    342,
    10415,
    "0205",
    "Lemak dan minyak nabati",
    "020102000032",
    "Minyak Safflower (Refined Bleached Deodorized Safflower Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    343,
    10411,
    "0205",
    "Lemak dan minyak nabati",
    "020102000033",
    "Minyak Biji Bunga Matahari (Refined Bleached Deodorized Sunflower Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    344,
    82920,
    "0205",
    "Lemak dan minyak nabati",
    "020102000033",
    "Minyak Biji Bunga Matahari (Refined Bleached Deodorized Sunflower Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    345,
    10415,
    "0205",
    "Lemak dan minyak nabati",
    "020102000034",
    "Minyak Dedak atau Minyak Bekatul atau Minyak Katul (Refined Bleached Deodorized Rice Bran Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    346,
    10411,
    "0205",
    "Lemak dan minyak nabati",
    "020102000035",
    "Minyak Biji Kapas (Refined Bleached Deodorized Cottonseed Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    347,
    10415,
    "0205",
    "Lemak dan minyak nabati",
    "020102000035",
    "Minyak Biji Kapas (Refined Bleached Deodorized Cottonseed Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    348,
    10411,
    "0205",
    "Lemak dan minyak nabati",
    "020102000036",
    "Rapeseed oil (turnip rape oil/colza oil/ravison oil/sarson oil/toria oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    349,
    10415,
    "0205",
    "Lemak dan minyak nabati",
    "020102000036",
    "Rapeseed oil (turnip rape oil/colza oil/ravison oil/sarson oil/toria oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    350,
    10411,
    "0205",
    "Lemak dan minyak nabati",
    "020102000037",
    "Rapeseed oil - low erucic acid (low erucic acid turnip rape oil/low erucic acid colza oil/canola oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    351,
    10415,
    "0205",
    "Lemak dan minyak nabati",
    "020102000037",
    "Rapeseed oil - low erucic acid (low erucic acid turnip rape oil/low erucic acid colza oil/canola oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    352,
    10411,
    "0205",
    "Lemak dan minyak nabati",
    "020102000038",
    "Mustardseed Oil (Refined Bleached Deodorized Mustardseed Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    353,
    10415,
    "0205",
    "Lemak dan minyak nabati",
    "020102000038",
    "Mustardseed Oil (Refined Bleached Deodorized Mustardseed Oil)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    354,
    10415,
    "0205",
    "Lemak dan minyak nabati",
    "020102000039",
    "Minyak Biji Rami/Flaxseed Oil/Flax Oil/Linseed Oil",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    355,
    10431,
    "0205",
    "Lemak dan minyak nabati",
    "020102000040",
    "Minyak Makan Merah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    356,
    10432,
    "0205",
    "Lemak dan minyak nabati",
    "020102000040",
    "Minyak Makan Merah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    357,
    10433,
    "0205",
    "Lemak dan minyak nabati",
    "020102000040",
    "Minyak Makan Merah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    358,
    10434,
    "0205",
    "Lemak dan minyak nabati",
    "020102000040",
    "Minyak Makan Merah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    359,
    10435,
    "0205",
    "Lemak dan minyak nabati",
    "020102000040",
    "Minyak Makan Merah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    360,
    10436,
    "0205",
    "Lemak dan minyak nabati",
    "020102000040",
    "Minyak Makan Merah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    361,
    10437,
    "0205",
    "Lemak dan minyak nabati",
    "020102000040",
    "Minyak Makan Merah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    362,
    10415,
    "0205",
    "Lemak dan minyak nabati",
    "020102000041",
    "Minyak Biji Anggur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    363,
    10423,
    "0210",
    "Virgin oil",
    "020102000042",
    "Minyak Kelapa Virgin (VCO)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    364,
    10423,
    "0210",
    "Virgin oil",
    "020102000043",
    "Minyak Kelapa Virgin (VCO) dengan Bahan Pangan Lain",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    365,
    10436,
    "0205",
    "Lemak dan minyak nabati",
    "020102000044",
    "Stearin Inti Kelapa Sawit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    366,
    10423,
    "0205",
    "Lemak dan minyak nabati",
    "020102000045",
    "Minyak Blondo Kelapa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    367,
    10413,
    "0207",
    "Minyak dan lemak hewani",
    "020103000001",
    "Lemak Hewani",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    368,
    82920,
    "0207",
    "Minyak dan lemak hewani",
    "020103000001",
    "Lemak Hewani",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    369,
    10413,
    "0207",
    "Minyak dan lemak hewani",
    "020103000002",
    "Lemak Babi atau Lard",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    370,
    10413,
    "0207",
    "Minyak dan lemak hewani",
    "020103000003",
    "Rendered Pork Fat",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    371,
    10413,
    "0207",
    "Minyak dan lemak hewani",
    "020103000004",
    "Lemak Sapi Utama (Prime Beef Fat (Premier Jus atau Oleo Stock))",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    372,
    10413,
    "0207",
    "Minyak dan lemak hewani",
    "020103000005",
    "Lemak Sapi (Edible Beef Fat)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    373,
    82920,
    "0207",
    "Minyak dan lemak hewani",
    "020103000005",
    "Lemak Sapi (Edible Beef Fat)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    374,
    10413,
    "0207",
    "Minyak dan lemak hewani",
    "020103000006",
    "Dripping atau Edible Tallow",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    375,
    10413,
    "0207",
    "Minyak dan lemak hewani",
    "020103000007",
    "Secunda Beef Fat",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    376,
    10413,
    "0207",
    "Minyak dan lemak hewani",
    "020103000008",
    "Suet",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    377,
    10414,
    "0207",
    "Minyak dan lemak hewani",
    "020103000009",
    "Minyak Ikan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    378,
    10413,
    "0207",
    "Minyak dan lemak hewani",
    "020103000010",
    "Serbuk Lemak Hewani (Fat Powder)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    379,
    10414,
    "0207",
    "Minyak dan lemak hewani",
    "020103000010",
    "Serbuk Lemak Hewani (Fat Powder)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    380,
    10413,
    "0207",
    "Minyak dan lemak hewani",
    "020103000011",
    "Minyak Krill",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    381,
    10590,
    "0202",
    "Emulsi lemak",
    "020201000001",
    "Mentega dan Konsentrat Mentega",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    382,
    10590,
    "0202",
    "Emulsi lemak",
    "020201000002",
    "Mentega (butter)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    383,
    10590,
    "0202",
    "Emulsi lemak",
    "020201000003",
    "Mentega Rekombinasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    384,
    10412,
    "0202",
    "Emulsi lemak",
    "020202000001",
    "Margarin dan Produk Sejenis",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    385,
    10490,
    "0202",
    "Emulsi lemak",
    "020202000001",
    "Margarin dan Produk Sejenis",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    386,
    10412,
    "0202",
    "Emulsi lemak",
    "020202000002",
    "Margarin",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    387,
    10412,
    "0202",
    "Emulsi lemak",
    "020202000003",
    "Campuran Margarin dan Mentega (Blends of butter and margarine)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    388,
    10490,
    "0202",
    "Emulsi lemak",
    "020202000003",
    "Campuran Margarin dan Mentega (Blends of butter and margarine)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    389,
    10412,
    "0202",
    "Emulsi lemak",
    "020202000004",
    "Margarin Krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    390,
    10490,
    "0202",
    "Emulsi lemak",
    "020202000004",
    "Margarin Krim, Margarin Oles (Fat Spread), Margarine Compound, Bread Compound dan Bakery Compound",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    391,
    10412,
    "0202",
    "Emulsi lemak",
    "020202000005",
    "Minarin atau Halvarine",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    392,
    10490,
    "0202",
    "Emulsi lemak",
    "020202000006",
    "Lemak Oles Loyang (Pan Release)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    393,
    10490,
    "0202",
    "Emulsi lemak",
    "020300000001",
    "Non-Dairy Toppings, Fillings, Frostings",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    394,
    10490,
    "0202",
    "Emulsi lemak",
    "020300000002",
    "Non-Dairy Whipped Cream",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    395,
    10490,
    "0202",
    "Emulsi lemak",
    "020300000003",
    "Krim Nabati (Vegetable Cream)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    396,
    10490,
    "0203",
    "Es krim non-dairy",
    "020400000001",
    "Melorin atau Non-Dairy Ice Cream",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    397,
    10532,
    "0203",
    "Es krim non-dairy",
    "020400000001",
    "Melorin atau Non-Dairy Ice Cream",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    398,
    10490,
    "0203",
    "Es krim non-dairy",
    "020400000002",
    "Non-Dairy Mousse",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    399,
    35302,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000001",
    "Es Batu Untuk Konsumsi ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    400,
    10532,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000002",
    "Water Ices",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    401,
    35302,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000002",
    "Water Ices",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    402,
    10532,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000003",
    "Es Mambo",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    403,
    10532,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000004",
    "Es Stik (Ice Stick) atau Es Loli",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    404,
    10532,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000005",
    "Es Buah (Fruit Ice)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    405,
    10532,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000006",
    "Es Puter",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    406,
    10532,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000007",
    "Es Lilin",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    407,
    10532,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000008",
    "Es Kue",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    408,
    10532,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000009",
    "Sorbet",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    409,
    10532,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000010",
    "Sherbet",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    410,
    10532,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000011",
    "Es Mengandung Susu ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    411,
    10532,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000012",
    "Es Rasa Susu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    412,
    10532,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000013",
    "Premiks Es Bentuk Bubuk ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    413,
    10532,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000014",
    "Premiks Es Bentuk Cair ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    414,
    10532,
    "0301",
    "Es selain es krim dan es susu (contoh: es batu)",
    "030000000015",
    "Sediaan Cair Yang Akan Dikonsumsi Dalam Keadaan Beku",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    415,
    10314,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102010001",
    "Buah Beku dengan Penambahan Bahan Pangan Lain",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    416,
    10313,
    "0403",
    "Buah kering",
    "040102020001",
    "Buah Kering",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    417,
    82920,
    "0403",
    "Buah kering",
    "040102020001",
    "Buah Kering",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    418,
    10313,
    "0403",
    "Buah kering",
    "040102020002",
    "Buah Kering Campur",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    419,
    10421,
    "0403",
    "Buah kering",
    "040102020003",
    "Kopra",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    420,
    10424,
    "0403",
    "Buah kering",
    "040102020004",
    "Kelapa Parut Kering",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    421,
    10773,
    "0403",
    "Buah kering",
    "040102020004",
    "Kelapa Parut Kering",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    422,
    10773,
    "0403",
    "Buah kering",
    "040102020005",
    "Santan Bubuk",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    423,
    10399,
    "0403",
    "Buah kering",
    "040102020006",
    "Tepung Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    424,
    10629,
    "0403",
    "Buah kering",
    "040102020006",
    "Tepung Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    425,
    10311,
    "0410",
    "Manisan/asinan buah",
    "040102030001",
    "Buah Asin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    426,
    10311,
    "0410",
    "Manisan/asinan buah",
    "040102030002",
    "Asinan Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    427,
    10311,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102030003",
    "Rujak",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    428,
    10320,
    "0402",
    "Buah dalam kemasan",
    "040102040001",
    "Buah Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    429,
    10399,
    "0402",
    "Buah dalam kemasan",
    "040102040001",
    "Buah Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    430,
    10320,
    "0402",
    "Buah dalam kemasan",
    "040102040002",
    "Koktil Buah Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    431,
    10399,
    "0402",
    "Buah dalam kemasan",
    "040102040002",
    "Koktil Buah Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    432,
    10312,
    "0408",
    "Jem (selai), jeli dan marmalad",
    "040102050001",
    "Jem Buah atau Selai Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    433,
    10312,
    "0408",
    "Jem (selai), jeli dan marmalad",
    "040102050002",
    "Jeli Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    434,
    10312,
    "0408",
    "Jem (selai), jeli dan marmalad",
    "040102050003",
    "Marmalad",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    435,
    10312,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102060001",
    "Chutney Mangga (Mango Chutney)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    436,
    82920,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102060001",
    "Chutney Mangga (Mango Chutney)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    437,
    10312,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102060002",
    "Produk Buah Oles",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    438,
    82920,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102060002",
    "Produk Buah Oles",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    439,
    10733,
    "0401",
    "Buah bergula",
    "040102070001",
    "Buah Bersalut",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    440,
    10733,
    "0401",
    "Buah bergula",
    "040102070002",
    "Buah Bergula",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    441,
    10733,
    "0401",
    "Buah bergula",
    "040102070003",
    "Buah Berkristal",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    442,
    10733,
    "0401",
    "Buah bergula",
    "040102070004",
    "Kulit Buah Bergula",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    443,
    10733,
    "0401",
    "Buah bergula",
    "040102070005",
    "Bunga Bergula",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    444,
    10312,
    "0404",
    "Bubur/puree/pasta buah dan/atau sayur, kecuali yang disterilisasi",
    "040102080001",
    "Bubur Buah (Fruit Pulp)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    445,
    10312,
    "0404",
    "Bubur/puree/pasta buah dan/atau sayur, kecuali yang disterilisasi",
    "040102080002",
    "Puree Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    446,
    10312,
    "0404",
    "Bubur/puree/pasta buah dan/atau sayur, kecuali yang disterilisasi",
    "040102080003",
    "Pasta Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    447,
    10312,
    "0404",
    "Bubur/puree/pasta buah dan/atau sayur, kecuali yang disterilisasi",
    "040102080004",
    "Saus Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    448,
    10312,
    "0404",
    "Bubur/puree/pasta buah dan/atau sayur, kecuali yang disterilisasi",
    "040102080005",
    "Topping Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    449,
    10773,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102080006",
    "Santan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    450,
    10773,
    "0414",
    "Pangan olahan hasil fermentasi buah/sayur",
    "040102080007",
    "Nata",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    451,
    10330,
    "0404",
    "Bubur/puree/pasta buah dan/atau sayur, kecuali yang disterilisasi",
    "040102080008",
    "Konsentrat Asam Jawa/Tamarin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    452,
    10312,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102080009",
    "Bubuk Asam Jawa/Tamarin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    453,
    10733,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102080010",
    "Bars Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    454,
    10733,
    "0410",
    "Manisan/asinan buah",
    "040102090001",
    "Manisan Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    455,
    10773,
    "0414",
    "Pangan olahan hasil fermentasi buah/sayur",
    "040102090002",
    "Nata Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    456,
    10298,
    "0302",
    "Makanan Pencuci Mulut Berbahan Dasar Selain Susu",
    "040102090003",
    "Jeli Agar",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    457,
    10298,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090003",
    "Jeli Agar",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    458,
    10298,
    "0302",
    "Makanan Pencuci Mulut Berbahan Dasar Selain Susu",
    "040102090003",
    "Jeli Agar",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    459,
    10298,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090003",
    "Jeli Agar",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    460,
    10298,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102090004",
    "Bubuk Agar (Agar-Agar Tepung/Tepung Agar-Agar)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    461,
    10298,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090004",
    "Bubuk Agar (Agar-Agar Tepung/Tepung Agar-Agar)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    462,
    10298,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102090004",
    "Bubuk Agar (Agar-Agar Tepung/Tepung Agar-Agar)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    463,
    10298,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090004",
    "Bubuk Agar (Agar-Agar Tepung/Tepung Agar-Agar)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    464,
    10298,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090005",
    "Agar-Agar Kertas",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    465,
    10298,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090006",
    "Tepung Gelatin (Bubuk Gelatin)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    466,
    10298,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090007",
    "Tepung Karagenan (Bubuk Karagenan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    467,
    10298,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090008",
    "Jeli Agar Bubuk",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    468,
    10779,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090009",
    "Puding Rasa/Berperisa",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    469,
    10298,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102090010",
    "Bubuk Puding Rasa/Berperisa",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    470,
    10298,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090010",
    "Bubuk Puding Rasa/Berperisa",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    471,
    10779,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102090010",
    "Bubuk Puding Rasa/Berperisa",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    472,
    10779,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090010",
    "Bubuk Puding Rasa/Berperisa",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    473,
    10799,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090011",
    "Mitsumame",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    474,
    10733,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090012",
    "Sale Pisang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    475,
    10779,
    "0405",
    "Cincau",
    "040102090013",
    "Cincau Hijau",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    476,
    10779,
    "0405",
    "Cincau",
    "040102090014",
    "Cincau Hitam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    477,
    10320,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090015",
    "Siwalan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    478,
    10399,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090016",
    "Makanan Pencuci Mulut (Dessert) Berbasis Buah Termasuk Makanan Pencuci Mulut Berbasis Air Berflavor Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    479,
    10399,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040102090017",
    "Makanan Pencuci Mulut/ Hidangan Penutup Berbahan Dasar Kelapa",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    480,
    10311,
    "0414",
    "Pangan olahan hasil fermentasi buah/sayur",
    "040102100001",
    "Pikel Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    481,
    10399,
    "0414",
    "Pangan olahan hasil fermentasi buah/sayur",
    "040102100002",
    "Tempoyak/Pakasam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    482,
    10313,
    "0424",
    "Produk Buah Untuk Isi Pastri",
    "040102110001",
    "Produk Buah Untuk Isi Pastri",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    483,
    10733,
    "0424",
    "Produk Buah Untuk Isi Pastri",
    "040102110001",
    "Produk Buah Untuk Isi Pastri",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    484,
    10313,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102120001",
    "Keripik Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    485,
    10773,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102120001",
    "Keripik Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    486,
    82920,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102120001",
    "Keripik Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    487,
    10313,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102120002",
    "Keripik3 Buah Simulasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    488,
    82920,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102120002",
    "Keripik3 Buah Simulasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    489,
    10792,
    "0409",
    "Lempok buah",
    "040102120003",
    "Dodol atau Lempok Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    490,
    10796,
    "0409",
    "Lempok buah",
    "040102120003",
    "Dodol atau Lempok Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    491,
    10792,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102120004",
    "Wajit Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    492,
    82920,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040102120004",
    "Wajit Buah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    493,
    10792,
    "0407",
    "Geplak",
    "040102120005",
    "Geplak",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    494,
    10314,
    "0416",
    "Sayur beku",
    "040202010001",
    "Sayur Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    495,
    82920,
    "0416",
    "Sayur beku",
    "040202010001",
    "Sayur Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    496,
    10314,
    "0416",
    "Sayur beku",
    "040202010002",
    "Kentang Goreng Beku (Frozen French Fries)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    497,
    82920,
    "0416",
    "Sayur beku",
    "040202010002",
    "Kentang Goreng Beku (Frozen French Fries)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    498,
    10314,
    "0416",
    "Sayur beku",
    "040202010003",
    "Perkedel Kentang Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    499,
    10314,
    "0416",
    "Sayur beku",
    "040202010004",
    "Olahan Sayur Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    500,
    10313,
    "0419",
    "Sayur kering",
    "040202020001",
    "Sayur Kering",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    501,
    10299,
    "0415",
    "Rumput laut kering",
    "040202020002",
    "Rumput Laut Kering",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    502,
    10298,
    "0415",
    "Rumput laut kering",
    "040202020003",
    "Nori",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    503,
    10299,
    "0415",
    "Rumput laut kering",
    "040202020003",
    "Nori",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    504,
    10313,
    "0419",
    "Sayur kering",
    "040202020004",
    "Sayur Asin Kering",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    505,
    10313,
    "0419",
    "Sayur kering",
    "040202020005",
    "Kacang Kering dan Polong Kacang Kering",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    506,
    10313,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202020006",
    "Biji Bunga Matahari",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    507,
    82920,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202020006",
    "Biji Bunga Matahari",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    508,
    10313,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202020007",
    "Biji Wijen",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    509,
    82920,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202020007",
    "Biji Wijen",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    510,
    10313,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202020008",
    "Kuaci",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    511,
    82920,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202020008",
    "Kuaci",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    512,
    10793,
    "0406",
    "Emping",
    "040202020009",
    "Emping Melinjo",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    513,
    82920,
    "0406",
    "Emping",
    "040202020009",
    "Emping Melinjo",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    514,
    10793,
    "0406",
    "Emping",
    "040202020010",
    "Emping Jengkol",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    515,
    10793,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202020011",
    "Mete Gelondong",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    516,
    82920,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202020011",
    "Mete Gelondong",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    517,
    10313,
    "0419",
    "Sayur kering",
    "040202020012",
    "Kentang Kering Serpih (Flakes)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    518,
    10312,
    "0418",
    "Sayur bubuk, Sayur kering",
    "040202020013",
    "Tepung Tomat/Bubur Tomat Kering/Pasta Tomat Kering",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    519,
    10613,
    "0417",
    "Sayur bubuk",
    "040202020014",
    "Tepung Bit",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    520,
    10613,
    "0417",
    "Sayur bubuk",
    "040202020015",
    "Tepung Daun Kelor",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    521,
    10399,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030001",
    "Jamur Dalam Minyak Zaitun atau Jamur Dalam Minyak Nabati Lain",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    522,
    10399,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202030001",
    "Jamur Dalam Minyak Zaitun atau Jamur Dalam Minyak Nabati Lain",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    523,
    10399,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030001",
    "Jamur Dalam Minyak Zaitun atau Jamur Dalam Minyak Nabati Lain",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    524,
    10399,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202030001",
    "Jamur Dalam Minyak Zaitun atau Jamur Dalam Minyak Nabati Lain",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    525,
    10399,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030001",
    "Jamur Dalam Minyak Zaitun atau Jamur Dalam Minyak Nabati Lain",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    526,
    10399,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202030001",
    "Jamur Dalam Minyak Zaitun atau Jamur Dalam Minyak Nabati Lain",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    527,
    10399,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030001",
    "Jamur Dalam Minyak Zaitun atau Jamur Dalam Minyak Nabati Lain",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    528,
    10399,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202030001",
    "Jamur Dalam Minyak Zaitun atau Jamur Dalam Minyak Nabati Lain",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    529,
    10311,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030002",
    "Sayur Asin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    530,
    10311,
    "0422",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai, tanpa sterilisasi/pasteurisasi",
    "040202030002",
    "Sayur Asin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    531,
    10311,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030002",
    "Sayur Asin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    532,
    10311,
    "0422",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai, tanpa sterilisasi/pasteurisasi",
    "040202030002",
    "Sayur Asin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    533,
    10311,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030002",
    "Sayur Asin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    534,
    10311,
    "0422",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai, tanpa sterilisasi/pasteurisasi",
    "040202030002",
    "Sayur Asin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    535,
    10311,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030002",
    "Sayur Asin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    536,
    10311,
    "0422",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai, tanpa sterilisasi/pasteurisasi",
    "040202030002",
    "Sayur Asin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    537,
    10311,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030003",
    "Jamur Asin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    538,
    10311,
    "0422",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai, tanpa sterilisasi/pasteurisasi",
    "040202030003",
    "Jamur Asin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    539,
    10311,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030003",
    "Jamur Asin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    540,
    10311,
    "0422",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai, tanpa sterilisasi/pasteurisasi",
    "040202030003",
    "Jamur Asin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    541,
    10311,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    542,
    10311,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    543,
    10311,
    "0422",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai, tanpa sterilisasi/pasteurisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    544,
    10311,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    545,
    10311,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    546,
    10311,
    "0422",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai, tanpa sterilisasi/pasteurisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    547,
    10311,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    548,
    10311,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    549,
    10311,
    "0422",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai, tanpa sterilisasi/pasteurisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    550,
    10311,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    551,
    10311,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    552,
    10311,
    "0422",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai, tanpa sterilisasi/pasteurisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    553,
    10311,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    554,
    10311,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    555,
    10311,
    "0422",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai, tanpa sterilisasi/pasteurisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    556,
    10311,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    557,
    10311,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    558,
    10311,
    "0422",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai, tanpa sterilisasi/pasteurisasi",
    "040202030004",
    "Acar (Sweet Pickle)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    559,
    10311,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030005",
    "Asinan Jahe",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    560,
    10311,
    "0422",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai, tanpa sterilisasi/pasteurisasi",
    "040202030005",
    "Asinan Jahe",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    561,
    10311,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202030005",
    "Asinan Jahe",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    562,
    10311,
    "0422",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai, tanpa sterilisasi/pasteurisasi",
    "040202030005",
    "Asinan Jahe",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    563,
    10320,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040001",
    "Sayur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    564,
    10320,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040001",
    "Sayur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    565,
    10320,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040001",
    "Sayur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    566,
    10320,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040001",
    "Sayur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    567,
    10399,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040001",
    "Sayur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    568,
    10399,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040001",
    "Sayur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    569,
    10399,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040001",
    "Sayur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    570,
    10399,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040001",
    "Sayur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    571,
    10320,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040002",
    "Tomat Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    572,
    10320,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040002",
    "Tomat Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    573,
    10320,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040002",
    "Tomat Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    574,
    10320,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040002",
    "Tomat Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    575,
    10399,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040002",
    "Tomat Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    576,
    10399,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040002",
    "Tomat Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    577,
    10399,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040002",
    "Tomat Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    578,
    10399,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040002",
    "Tomat Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    579,
    10320,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040003",
    "Jagung Manis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    580,
    10320,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040003",
    "Jagung Manis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    581,
    10320,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040003",
    "Jagung Manis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    582,
    10320,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040003",
    "Jagung Manis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    583,
    10399,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040003",
    "Jagung Manis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    584,
    10399,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040003",
    "Jagung Manis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    585,
    10399,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040003",
    "Jagung Manis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    586,
    10399,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040003",
    "Jagung Manis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    587,
    10320,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040003",
    "Jagung Manis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    588,
    10320,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040003",
    "Jagung Manis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    589,
    10320,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040003",
    "Jagung Manis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    590,
    10320,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040003",
    "Jagung Manis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    591,
    10320,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040004",
    "Wortel Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    592,
    10320,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040004",
    "Wortel Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    593,
    10399,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040004",
    "Wortel Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    594,
    10399,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040004",
    "Wortel Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    595,
    10320,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040005",
    "Jamur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    596,
    10320,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040005",
    "Jamur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    597,
    10320,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040005",
    "Jamur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    598,
    10320,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040005",
    "Jamur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    599,
    10399,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040005",
    "Jamur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    600,
    10399,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040005",
    "Jamur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    601,
    10399,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040005",
    "Jamur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    602,
    10399,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040005",
    "Jamur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    603,
    10320,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040006",
    "Buncis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    604,
    10320,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040006",
    "Buncis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    605,
    10399,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040006",
    "Buncis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    606,
    10399,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040006",
    "Buncis Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    607,
    10320,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040007",
    "Asparagus Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    608,
    10320,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040007",
    "Asparagus Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    609,
    10399,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040007",
    "Asparagus Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    610,
    10399,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040007",
    "Asparagus Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    611,
    10320,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040008",
    "Rebung Bambu Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    612,
    10320,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040008",
    "Rebung Bambu Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    613,
    10399,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040008",
    "Rebung Bambu Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    614,
    10399,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040008",
    "Rebung Bambu Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    615,
    10320,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040009",
    "Kacang Kapri (Green Peas) dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    616,
    10320,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040009",
    "Kacang Kapri (Green Peas) dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    617,
    10320,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040009",
    "Kacang Kapri (Green Peas) dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    618,
    10320,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040009",
    "Kacang Kapri (Green Peas) dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    619,
    10399,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040009",
    "Kacang Kapri (Green Peas) dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    620,
    10399,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040009",
    "Kacang Kapri (Green Peas) dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    621,
    10399,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040009",
    "Kacang Kapri (Green Peas) dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    622,
    10399,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040009",
    "Kacang Kapri (Green Peas) dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    623,
    10320,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040010",
    "Akar/Umbi/Polong-polongan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    624,
    10320,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040010",
    "Akar/Umbi/Polong-polongan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    625,
    10320,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040010",
    "Akar/Umbi/Polong-polongan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    626,
    10320,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040010",
    "Akar/Umbi/Polong-polongan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    627,
    10399,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040010",
    "Akar/Umbi/Polong-polongan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    628,
    10399,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040010",
    "Akar/Umbi/Polong-polongan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    629,
    10399,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040010",
    "Akar/Umbi/Polong-polongan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    630,
    10399,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040010",
    "Akar/Umbi/Polong-polongan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    631,
    10750,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040010",
    "Akar/Umbi/Polong-polongan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    632,
    10750,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040010",
    "Akar/Umbi/Polong-polongan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    633,
    10750,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040010",
    "Akar/Umbi/Polong-polongan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    634,
    10750,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040010",
    "Akar/Umbi/Polong-polongan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    635,
    10320,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040011",
    "Manisan Rumput Laut dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    636,
    10320,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040011",
    "Manisan Rumput Laut dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    637,
    10399,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040011",
    "Manisan Rumput Laut dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    638,
    10399,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040011",
    "Manisan Rumput Laut dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    639,
    10320,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040012",
    "Lidah Buaya dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    640,
    10320,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040012",
    "Lidah Buaya dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    641,
    10399,
    "0420",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang dipasteurisasi",
    "040202040012",
    "Lidah Buaya dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    642,
    10399,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040012",
    "Lidah Buaya dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    643,
    10320,
    "0421",
    "Sayur/jamur/buah dalam media minyak, cuka, larutan garam, atau kecap kedelai yang disterilisasi",
    "040202040013",
    "Olahan Sayur Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    644,
    10312,
    "0404",
    "Bubur/puree/pasta buah dan/atau sayur, kecuali yang disterilisasi",
    "040202050001",
    "Puree Tomat",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    645,
    10312,
    "0408",
    "Jem (selai), jeli dan marmalad",
    "040202050002",
    "Selai Kacang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    646,
    10312,
    "0408",
    "Jem (selai), jeli dan marmalad",
    "040202050003",
    "Olesan Kacang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    647,
    10312,
    "0408",
    "Jem (selai), jeli dan marmalad",
    "040202050004",
    "Olesan Mengandung Kacang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    648,
    10312,
    "0408",
    "Jem (selai), jeli dan marmalad",
    "040202050005",
    "Selai Sayur",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    649,
    10312,
    "0408",
    "Jem (selai), jeli dan marmalad",
    "040202050006",
    "Selai Biji-Bijian",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    650,
    10312,
    "0408",
    "Jem (selai), jeli dan marmalad",
    "040202050007",
    "Olesan Wijen",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    651,
    10312,
    "0404",
    "Bubur/puree/pasta buah dan/atau sayur, kecuali yang disterilisasi",
    "040202060001",
    "Pasta Tomat",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    652,
    10312,
    "0404",
    "Bubur/puree/pasta buah dan/atau sayur, kecuali yang disterilisasi",
    "040202060002",
    "Pasta Umbi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    653,
    10312,
    "0404",
    "Bubur/puree/pasta buah dan/atau sayur, kecuali yang disterilisasi",
    "040202060003",
    "Bubur (Pulp) Sayur",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    654,
    10298,
    "0408",
    "Jem (selai), jeli dan marmalad",
    "040202060004",
    "Produk Jeli Tidak Siap Konsumsi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    655,
    10311,
    "0414",
    "Pangan olahan hasil fermentasi buah/sayur",
    "040202070001",
    "Pikel (fermentasi)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    656,
    10311,
    "0414",
    "Pangan olahan hasil fermentasi buah/sayur",
    "040202070002",
    "Sawi Asin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    657,
    10399,
    "0414",
    "Pangan olahan hasil fermentasi buah/sayur",
    "040202070003",
    "Sauerkraut",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    658,
    10399,
    "0414",
    "Pangan olahan hasil fermentasi buah/sayur",
    "040202070004",
    "Jamur Fermentasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    659,
    10399,
    "0414",
    "Pangan olahan hasil fermentasi buah/sayur",
    "040202070005",
    "Kimchi ",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    660,
    10399,
    "0414",
    "Pangan olahan hasil fermentasi buah/sayur",
    "040202070006",
    "Gochujang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    661,
    10393,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202070007",
    "Olahan Kacang Serupa Keju",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    662,
    10393,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040202070007",
    "Olahan Kacang Serupa Keju",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    663,
    10393,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202070007",
    "Olahan Kacang Serupa Keju",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    664,
    10393,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040202070007",
    "Olahan Kacang Serupa Keju",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    665,
    10393,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202070007",
    "Olahan Kacang Serupa Keju",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    666,
    10393,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040202070007",
    "Olahan Kacang Serupa Keju",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    667,
    10393,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202070007",
    "Olahan Kacang Serupa Keju",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    668,
    10393,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040202070007",
    "Olahan Kacang Serupa Keju",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    669,
    10393,
    "0414",
    "Pangan olahan hasil fermentasi buah/sayur",
    "040202070008",
    "Tempe Selain Kedelai",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    670,
    10792,
    "0414",
    "Pangan olahan hasil fermentasi buah/sayur",
    "040202070009",
    "Tape Singkong",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    671,
    10393,
    "0414",
    "Pangan olahan hasil fermentasi buah/sayur",
    "040202070010",
    "Oncom Hitam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    672,
    10313,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080001",
    "Keripik Bayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    673,
    10794,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080001",
    "Keripik Bayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    674,
    82920,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080001",
    "Keripik Bayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    675,
    10313,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080002",
    "Keripik3 Jamur Kancing",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    676,
    10794,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080002",
    "Keripik3 Jamur Kancing",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    677,
    82920,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080002",
    "Keripik3 Jamur Kancing",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    678,
    10792,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080003",
    "Getuk Singkong",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    679,
    82920,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080003",
    "Getuk Singkong",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    680,
    10399,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080004",
    "Vegetable Tsukudani",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    681,
    82920,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080004",
    "Vegetable Tsukudani",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    682,
    10313,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080005",
    "Kerupuk 4Jengkol",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    683,
    10794,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080005",
    "Kerupuk 4Jengkol",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    684,
    82920,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080005",
    "Kerupuk 4Jengkol",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    685,
    10792,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080006",
    "Dodol Rumput Laut",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    686,
    10796,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080006",
    "Dodol Rumput Laut",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    687,
    82920,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080006",
    "Dodol Rumput Laut",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    688,
    10399,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080007",
    "Sayur Olahan Yang Dibentuk",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    689,
    10399,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040202080007",
    "Sayur Olahan Yang Dibentuk",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    690,
    10399,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080007",
    "Sayur Olahan Yang Dibentuk",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    691,
    10399,
    "0413",
    "Pangan kategori 4 risiko sedang lainnya",
    "040202080007",
    "Sayur Olahan Yang Dibentuk",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    692,
    10792,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080008",
    "Produk Olahan Singkong",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    693,
    10794,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080008",
    "Produk Olahan Singkong",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    694,
    10799,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080009",
    "Umbi Panggang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    695,
    10794,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080010",
    "Keripik Bonggol Pisang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    696,
    10313,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    "040202080012",
    "Keripik Sayur",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    697,
    10731,
    "0508",
    "Massa kakao dan cairan kental (liquor) cokelat",
    "050101000001",
    "Kakao Massa (Cocoa liquor)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    698,
    10731,
    "0503",
    "Keik kakao (cocoa press cake)",
    "050101000002",
    "Keik Kakao/Bungkil Kakao",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    699,
    10732,
    "0503",
    "Keik kakao (cocoa press cake)",
    "050101000002",
    "Keik Kakao/Bungkil Kakao",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    700,
    10731,
    "0502",
    "Kakao bubuk",
    "050101000003",
    "Kakao Bubuk",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    701,
    82920,
    "0502",
    "Kakao bubuk",
    "050101000003",
    "Kakao Bubuk",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    702,
    10731,
    "0507",
    "Lemak kakao (cocoa butter)",
    "050101000004",
    "Lemak Kakao (Cocoa Butter)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    703,
    10731,
    "0510",
    "Pangan kategori 5 risiko rendah lainnya",
    "050101000005",
    "Debu Kakao (Cocoa Dust)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    704,
    10732,
    "0510",
    "Pangan kategori 5 risiko rendah lainnya",
    "050101000006",
    "Bubuk Minuman Kakao (Drinking Cocoa Mixes)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    705,
    10732,
    "0510",
    "Pangan kategori 5 risiko rendah lainnya",
    "050101000007",
    "Bubuk Minuman Cokelat (Drinking Chocolate)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    706,
    10731,
    "0510",
    "Pangan kategori 5 risiko rendah lainnya",
    "050101000008",
    "Kakao Instan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    707,
    10732,
    "0510",
    "Pangan kategori 5 risiko rendah lainnya",
    "050101000009",
    "Cokelat Instan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    708,
    10732,
    "0510",
    "Pangan kategori 5 risiko rendah lainnya",
    "050101000010",
    "Cokelat Bubuk",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    709,
    82920,
    "0510",
    "Pangan kategori 5 risiko rendah lainnya",
    "050101000010",
    "Cokelat Bubuk",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    710,
    10732,
    "0510",
    "Pangan kategori 5 risiko rendah lainnya",
    "050102000001",
    "Sirup Cokelat",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    711,
    10732,
    "0512",
    "Pasta coklat",
    "050103000001",
    "Cokelat Pasta (Berbasis Minyak)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    712,
    10732,
    "0512",
    "Pasta coklat",
    "050103000002",
    "Cokelat Pasta (Berbasis Air)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    713,
    10732,
    "0501",
    "Cokelat",
    "050104000001",
    "Cokelat Hitam (Dark Chocolate, Semisweet Chocolate, Bittersweet Chocolate)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    714,
    10732,
    "0501",
    "Cokelat",
    "050104000002",
    "Cokelat Hitam Manis (Sweet Chocolate)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    715,
    10732,
    "0501",
    "Cokelat",
    "050104000003",
    "Cokelat Hitam Kovertur (Dark Chocolate Couverture)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    716,
    10732,
    "0501",
    "Cokelat",
    "050104000004",
    "Cokelat Susu (Milk Chocolate)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    717,
    10732,
    "0501",
    "Cokelat",
    "050104000005",
    "Cokelat Susu Kovertur (Milk Chocolate Couverture)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    718,
    10732,
    "0501",
    "Cokelat",
    "050104000006",
    "Cokelat Putih (White Chocolate)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    719,
    10732,
    "0501",
    "Cokelat",
    "050104000007",
    "Cokelat Putih Kovertur (White Chocolate Couverture)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    720,
    10732,
    "0501",
    "Cokelat",
    "050104000008",
    "Meses/Cokelat Butir/Cokelat Vermicelli /Streusel",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    721,
    10732,
    "0501",
    "Cokelat",
    "050104000009",
    "Meses Susu/Cokelat Susu Butir/Cokelat Susu Vermicelli",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    722,
    10732,
    "0501",
    "Cokelat",
    "050104000010",
    "Bonbon Cokelat /Permen Isi Cokelat",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    723,
    10732,
    "0501",
    "Cokelat",
    "050104000011",
    "Praline",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    724,
    10732,
    "0501",
    "Cokelat",
    "050104000012",
    "Truffles",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    725,
    10732,
    "0501",
    "Cokelat",
    "050104000013",
    "Cokelat Isi (filled chocolate)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    726,
    10732,
    "0501",
    "Cokelat",
    "050104000014",
    "Cokelat Berperisa",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    727,
    10732,
    "0501",
    "Cokelat",
    "050104000015",
    "Cokelat Aerasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    728,
    10732,
    "0501",
    "Cokelat",
    "050104000016",
    "Cokelat Laminasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    729,
    10732,
    "0501",
    "Cokelat",
    "050104000017",
    "Cokelat Komposit",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    730,
    10732,
    "0501",
    "Cokelat",
    "050105000001",
    "Cokelat Paduan/Cokelat Compound",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    731,
    10732,
    "0501",
    "Cokelat",
    "050105000001",
    "Cokelat Paduan/Cokelat Compound",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    732,
    82920,
    "0501",
    "Cokelat",
    "050105000001",
    "Cokelat Paduan/Cokelat Compound",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    733,
    82920,
    "0501",
    "Cokelat",
    "050105000001",
    "Cokelat Paduan/Cokelat Compound",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    734,
    10732,
    "0501",
    "Cokelat",
    "050105000002",
    "Cokelat Paduan/Cokelat Compound Butir",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    735,
    10732,
    "0513",
    "Produk cokelat analog/ pengganti cokelat",
    "050105000002",
    "Cokelat Paduan/Cokelat Compound Butir",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    736,
    10732,
    "0501",
    "Cokelat",
    "050105000002",
    "Cokelat Paduan/Cokelat Compound Butir",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    737,
    10732,
    "0513",
    "Produk cokelat analog/ pengganti cokelat",
    "050105000002",
    "Cokelat Paduan/Cokelat Compound Butir",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    738,
    82920,
    "0501",
    "Cokelat",
    "050105000002",
    "Cokelat Paduan/Cokelat Compound Butir",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    739,
    82920,
    "0513",
    "Produk cokelat analog/ pengganti cokelat",
    "050105000002",
    "Cokelat Paduan/Cokelat Compound Butir",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    740,
    82920,
    "0501",
    "Cokelat",
    "050105000002",
    "Cokelat Paduan/Cokelat Compound Butir",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    741,
    82920,
    "0513",
    "Produk cokelat analog/ pengganti cokelat",
    "050105000002",
    "Cokelat Paduan/Cokelat Compound Butir",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    742,
    10732,
    "0501",
    "Cokelat",
    "050105000003",
    "Minuman Cokelat Paduan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    743,
    10732,
    "0513",
    "Produk cokelat analog/ pengganti cokelat",
    "050105000004",
    "Cokelat Imitasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    744,
    10411,
    "0513",
    "Produk cokelat analog/ pengganti cokelat",
    "050105000005",
    "Cocoa Butter Equivalent",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    745,
    10732,
    "0513",
    "Produk cokelat analog/ pengganti cokelat",
    "050105000005",
    "Cocoa Butter Equivalent",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    746,
    10411,
    "0513",
    "Produk cokelat analog/ pengganti cokelat",
    "050105000006",
    "Pengganti Lemak Kakao Laurat (Lauric Cocoa Butter Replacer/Substitute = CBS Lauric)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    747,
    10411,
    "0513",
    "Produk cokelat analog/ pengganti cokelat",
    "050105000007",
    "Pengganti Lemak Kakao Non-Laurat (Non-lauric Cocoa Butter Replacer/Substitute = CBS Non-Lauric)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    748,
    10732,
    "0513",
    "Produk cokelat analog/ pengganti cokelat",
    "050105000008",
    "Carob Coatings",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    749,
    10732,
    "0513",
    "Produk cokelat analog/ pengganti cokelat",
    "050105000009",
    "Coating Dari Lembaga Gandum Bebas Lemak (Deffated Wheat Germ Coating)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    750,
    10734,
    "0505",
    "Kembang gula/permen keras",
    "050201000001",
    "Kembang Gula Keras/Permen Keras/Hard Candy/Boiled Sweet",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    751,
    10734,
    "0505",
    "Kembang gula/permen keras",
    "050201000002",
    "Pastiles",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    752,
    10739,
    "0505",
    "Kembang gula/permen keras",
    "050201000002",
    "Pastiles",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    753,
    10734,
    "0505",
    "Kembang gula/permen keras",
    "050201000003",
    "Pressed Candy/Lozenges",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    754,
    10734,
    "0505",
    "Kembang gula/permen keras",
    "050201000004",
    "Kembang Gula Isi Susu/Permen Isi Susu",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    755,
    10734,
    "0505",
    "Kembang gula/permen keras",
    "050201000005",
    "Kembang Gula Keras Rasa Susu/Permen Keras Rasa Susu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    756,
    10734,
    "0505",
    "Kembang gula/permen keras",
    "050201000006",
    "Kembang Gula Serbuk/Permen Serbuk",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    757,
    10734,
    "0506",
    "Kembang gula/permen lunak",
    "050202000001",
    "Kembang Gula Lunak/Permen Lunak",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    758,
    10734,
    "0506",
    "Kembang gula/permen lunak",
    "050202000002",
    "Kembang Gula Karamel/Permen Karamel",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    759,
    10734,
    "0506",
    "Kembang gula/permen lunak",
    "050202000003",
    "Fudge",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    760,
    10734,
    "0506",
    "Kembang gula/permen lunak",
    "050202000004",
    "Butterscotch",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    761,
    10734,
    "0506",
    "Kembang gula/permen lunak",
    "050202000005",
    "Licorice",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    762,
    10734,
    "0506",
    "Kembang gula/permen lunak",
    "050202000006",
    "Toffee",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    763,
    10734,
    "0506",
    "Kembang gula/permen lunak",
    "050202000007",
    "Krokant/Brittles",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    764,
    10734,
    "0506",
    "Kembang gula/permen lunak",
    "050202000008",
    "Marshmallow",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    765,
    10734,
    "0506",
    "Kembang gula/permen lunak",
    "050202000009",
    "Kembang Gula Jeli Pati (Starch Jelly)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    766,
    10734,
    "0506",
    "Kembang gula/permen lunak",
    "050202000010",
    "Kembang Gula Jeli Agar dan Gelatin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    767,
    82920,
    "0506",
    "Kembang gula/permen lunak",
    "050202000010",
    "Kembang Gula Jeli Agar dan Gelatin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    768,
    10734,
    "0506",
    "Kembang gula/permen lunak",
    "050202000011",
    "Gula Kapas (Cotton Candy)/Arumanis",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    769,
    10734,
    "0506",
    "Kembang gula/permen lunak",
    "050202000012",
    "Gulali",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    770,
    10734,
    "0506",
    "Kembang gula/permen lunak",
    "050202000013",
    "Kembang Gula Lunak Rasa Susu/Permen Lunak Rasa Susu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    771,
    10734,
    "0506",
    "Kembang gula/permen lunak",
    "050202000014",
    "Kembang Gula Cair/Permen Cair",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    772,
    10734,
    "0509",
    "Nougat, marzipan",
    "050203000001",
    "Permen Enting-Enting atau Nut Brittles",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    773,
    10734,
    "0509",
    "Nougat, marzipan",
    "050203000002",
    "Raw Marzipan, Base Almond Paste",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    774,
    10734,
    "0509",
    "Nougat, marzipan",
    "050203000003",
    "Marzipan, Almond Paste",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    775,
    10734,
    "0509",
    "Nougat, marzipan",
    "050203000004",
    "Nougat",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    776,
    10734,
    "0504",
    "Kembang gula/permen karet",
    "050300000001",
    "Kembang Gula Karet/Permen Karet",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    777,
    10739,
    "0504",
    "Kembang gula/permen karet",
    "050300000001",
    "Kembang Gula Karet/Permen Karet",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    778,
    10734,
    "0504",
    "Kembang gula/permen karet",
    "050300000002",
    "Kembang Gula Karet Rasa Susu/Permen Karet Rasa Susu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    779,
    10739,
    "0504",
    "Kembang gula/permen karet",
    "050300000002",
    "Kembang Gula Karet Rasa Susu/Permen Karet Rasa Susu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    780,
    10729,
    "0511",
    "Pangan kategori 5 risiko sedang lainnya",
    "050400000001",
    "Icing",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    781,
    10734,
    "0511",
    "Pangan kategori 5 risiko sedang lainnya",
    "050400000001",
    "Icing",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    782,
    10729,
    "0511",
    "Pangan kategori 5 risiko sedang lainnya",
    "050400000002",
    "Frosting",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    783,
    10412,
    "0511",
    "Pangan kategori 5 risiko sedang lainnya",
    "050400000003",
    "Saus Butterstotch",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    784,
    10732,
    "0511",
    "Pangan kategori 5 risiko sedang lainnya",
    "050400000004",
    "Saus/Topping/Olesan Cokelat",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    785,
    10732,
    "0514",
    "Dekorasi, Topping (Non-Buah) dan Saus Manis",
    "050400000004",
    "Saus/Topping/Olesan Cokelat",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    786,
    10732,
    "0511",
    "Pangan kategori 5 risiko sedang lainnya",
    "050400000004",
    "Saus/Topping/Olesan Cokelat",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    787,
    10732,
    "0514",
    "Dekorasi, Topping (Non-Buah) dan Saus Manis",
    "050400000004",
    "Saus/Topping/Olesan Cokelat",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    788,
    10729,
    "0511",
    "Pangan kategori 5 risiko sedang lainnya",
    "050400000005",
    "Saus/Topping/Olesan Manis",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    789,
    10729,
    "0514",
    "Dekorasi, Topping (Non-Buah) dan Saus Manis",
    "050400000005",
    "Saus/Topping/Olesan Manis",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    790,
    10729,
    "0511",
    "Pangan kategori 5 risiko sedang lainnya",
    "050400000005",
    "Saus/Topping/Olesan Manis",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    791,
    10729,
    "0514",
    "Dekorasi, Topping (Non-Buah) dan Saus Manis",
    "050400000005",
    "Saus/Topping/Olesan Manis",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    792,
    10732,
    "0511",
    "Pangan kategori 5 risiko sedang lainnya",
    "050400000005",
    "Saus/Topping/Olesan Manis",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    793,
    10732,
    "0514",
    "Dekorasi, Topping (Non-Buah) dan Saus Manis",
    "050400000005",
    "Saus/Topping/Olesan Manis",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    794,
    10732,
    "0511",
    "Pangan kategori 5 risiko sedang lainnya",
    "050400000005",
    "Saus/Topping/Olesan Manis",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    795,
    10732,
    "0514",
    "Dekorasi, Topping (Non-Buah) dan Saus Manis",
    "050400000005",
    "Saus/Topping/Olesan Manis",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    796,
    10729,
    "0511",
    "Pangan kategori 5 risiko sedang lainnya",
    "050400000006",
    "Saus/Topping/Olesan (non buah)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    797,
    10729,
    "0511",
    "Pangan kategori 5 risiko sedang lainnya",
    "050400000007",
    "Taburan Berbasis Gula",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    798,
    10732,
    "0511",
    "Pangan kategori 5 risiko sedang lainnya",
    "050400000007",
    "Taburan Berbasis Gula",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    799,
    10615,
    "0601",
    "Biji-bijian / kacang-kacangan kering",
    "060100000001",
    "Nasi Instan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    800,
    10615,
    "0633",
    "Nasi Instan (dikeringkan)",
    "060100000001",
    "Nasi Instan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    801,
    10631,
    "0601",
    "Biji-bijian / kacang-kacangan kering",
    "060100000002",
    "Emping Beras",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    802,
    10615,
    "0603",
    "Bubur instan, kecuali yang disterilisasi",
    "060100000003",
    "Bubur Instan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    803,
    10611,
    "0602",
    "Biji-bijian dan kacang-kacangan (utuh, patahan, atau serpihan)",
    "060100000004",
    "Gandum Hancur (Crushed Wheat)",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    804,
    10632,
    "0602",
    "Biji-bijian dan kacang-kacangan (utuh, patahan, atau serpihan)",
    "060100000005",
    "Jagung Pipil",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    805,
    10611,
    "0602",
    "Biji-bijian dan kacang-kacangan (utuh, patahan, atau serpihan)",
    "060100000006",
    "Biji Oats",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    806,
    10611,
    "0602",
    "Biji-bijian dan kacang-kacangan (utuh, patahan, atau serpihan)",
    "060100000007",
    "Jewawut (Pearl Millet)",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    807,
    10611,
    "0601",
    "Biji-bijian / kacang-kacangan kering",
    "060100000008",
    "Sorgum",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    808,
    10613,
    "0601",
    "Biji-bijian / kacang-kacangan kering",
    "060100000009",
    "Gaplek",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    809,
    10615,
    "0601",
    "Biji-bijian / kacang-kacangan kering",
    "060100000010",
    "Beras Pecah Kulit Pratanak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    810,
    10611,
    "0602",
    "Biji-bijian dan kacang-kacangan (utuh, patahan, atau serpihan)",
    "060100000011",
    "Gandum Patah (Cracked Wheat)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    811,
    10611,
    "0602",
    "Biji-bijian dan kacang-kacangan (utuh, patahan, atau serpihan)",
    "060100000012",
    "Lembaga Gandum",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    812,
    10633,
    "0625",
    "Tepung",
    "060201000001",
    "Tepung Beras",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    813,
    82920,
    "0625",
    "Tepung",
    "060201000001",
    "Tepung Beras",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    814,
    10633,
    "0625",
    "Tepung",
    "060201000002",
    "Tepung Beras Ketan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    815,
    10633,
    "0625",
    "Tepung",
    "060201000003",
    "Tepung Jagung",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    816,
    10612,
    "0625",
    "Tepung",
    "060201000004",
    "Tepung Kacang Hijau Tanpa Kulit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    817,
    10612,
    "0625",
    "Tepung",
    "060201000005",
    "Tepung Kacang Hijau Utuh",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    818,
    10612,
    "0625",
    "Tepung",
    "060201000006",
    "Tepung Kacang Merah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    819,
    10612,
    "0625",
    "Tepung",
    "060201000007",
    "Tepung Kedelai (Soybean Flour)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    820,
    10611,
    "0625",
    "Tepung",
    "060201000008",
    "Semolina Gandum Durum ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    821,
    10616,
    "0625",
    "Tepung",
    "060201000008",
    "Semolina Gandum Durum ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    822,
    10611,
    "0625",
    "Tepung",
    "060201000009",
    "Tepung Gandum Durum",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    823,
    10616,
    "0625",
    "Tepung",
    "060201000009",
    "Tepung Gandum Durum",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    824,
    10611,
    "0625",
    "Tepung",
    "060201000010",
    "Semolina Gandum Durum Utuh dan Tepung Gandum Durum Utuh",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    825,
    10616,
    "0625",
    "Tepung",
    "060201000010",
    "Semolina Gandum Durum Utuh dan Tepung Gandum Durum Utuh",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    826,
    10611,
    "0625",
    "Tepung",
    "060201000011",
    "Tepung Jewawut (Pearl Millet Flour)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    827,
    10611,
    "0625",
    "Tepung",
    "060201000012",
    "Tepung Sorgum",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    828,
    10616,
    "0627",
    "Tepung terigu",
    "060201000013",
    "Tepung Terigu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    829,
    82920,
    "0627",
    "Tepung terigu",
    "060201000013",
    "Tepung Terigu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    830,
    10616,
    "0627",
    "Tepung terigu",
    "060201000013",
    "Tepung Terigu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    831,
    82920,
    "0627",
    "Tepung terigu",
    "060201000013",
    "Tepung Terigu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    832,
    10614,
    "0627",
    "Tepung terigu",
    "060201000014",
    "Tepung Terigu Self-Raising",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    833,
    10616,
    "0627",
    "Tepung terigu",
    "060201000014",
    "Tepung Terigu Self-Raising",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    834,
    10614,
    "0627",
    "Tepung terigu",
    "060201000014",
    "Tepung Terigu Self-Raising",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    835,
    10616,
    "0627",
    "Tepung terigu",
    "060201000014",
    "Tepung Terigu Self-Raising",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    836,
    10616,
    "0627",
    "Tepung terigu",
    "060201000015",
    "Tepung Terigu Termodifikasi ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    837,
    10616,
    "0627",
    "Tepung terigu",
    "060201000015",
    "Tepung Terigu Termodifikasi ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    838,
    10616,
    "0627",
    "Tepung terigu",
    "060201000016",
    "Tepung Gluten Terigu (Wheat Gluten Powder)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    839,
    10616,
    "0627",
    "Tepung terigu",
    "060201000016",
    "Tepung Gluten Terigu (Wheat Gluten Powder)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    840,
    10616,
    "0627",
    "Tepung terigu",
    "060201000017",
    "Tepung Terigu dengan Penambahan Protein",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    841,
    10616,
    "0627",
    "Tepung terigu",
    "060201000017",
    "Tepung Terigu dengan Penambahan Protein",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    842,
    10616,
    "0625",
    "Tepung",
    "060201000018",
    "Tepung Terigu Utuh (Wholemeal Wheat Flour)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    843,
    10611,
    "0625",
    "Tepung",
    "060201000019",
    "Tepung Kulit Ari (Fine Bran)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    844,
    10616,
    "0625",
    "Tepung",
    "060201000019",
    "Tepung Kulit Ari (Fine Bran)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    845,
    10613,
    "0625",
    "Tepung",
    "060201000020",
    "Tepung Singkong",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    846,
    10613,
    "0625",
    "Tepung",
    "060201000021",
    "Tepung Mokaf",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    847,
    10621,
    "0625",
    "Tepung",
    "060201000021",
    "Tepung Mokaf",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    848,
    82920,
    "0625",
    "Tepung",
    "060201000021",
    "Tepung Mokaf",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    849,
    10613,
    "0625",
    "Tepung",
    "060201000022",
    "Tepung Gaplek",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    850,
    10613,
    "0625",
    "Tepung",
    "060201000023",
    "Tepung Umbi Lainnya (Tepung Kentang, Tepung Ubi Jalar, Tepung Garut, Tepung Ganyong dan lain-lain.)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    851,
    10622,
    "0625",
    "Tepung",
    "060201000024",
    "Tepung Aren",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    852,
    10612,
    "0625",
    "Tepung",
    "060201000025",
    "Kinako",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    853,
    10613,
    "0625",
    "Tepung",
    "060201000026",
    "Konjac Flour",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    854,
    10611,
    "0625",
    "Tepung",
    "060201000027",
    "Maida",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    855,
    10613,
    "0625",
    "Tepung",
    "060201000028",
    "Tepung Iles-iles",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    856,
    10612,
    "0625",
    "Tepung",
    "060201000029",
    "Tepung Kacang Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    857,
    10614,
    "0625",
    "Tepung",
    "060201000030",
    "Tepung Campur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    858,
    10612,
    "0625",
    "Tepung",
    "060201000031",
    "Tepung Kedelai Lemak Penuh/ Tepung Kedelai (Soybean Flour)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    859,
    10612,
    "0625",
    "Tepung",
    "060201000032",
    "Tepung kedelai yang telah dipisahkan lemaknya (deffated soy flour)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    860,
    10611,
    "0625",
    "Tepung",
    "060201000033",
    "Tepung Pragelatinisasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    861,
    10612,
    "0625",
    "Tepung",
    "060201000033",
    "Tepung Pragelatinisasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    862,
    10613,
    "0625",
    "Tepung",
    "060201000033",
    "Tepung Pragelatinisasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    863,
    10629,
    "0617",
    "Pati",
    "060202000001",
    "Pati Garut",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    864,
    10634,
    "0617",
    "Pati",
    "060202000002",
    "Pati Jagung atau Maizena",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    865,
    82920,
    "0617",
    "Pati",
    "060202000002",
    "Pati Jagung atau Maizena",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    866,
    10622,
    "0617",
    "Pati",
    "060202000003",
    "Pati Sagu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    867,
    82920,
    "0617",
    "Pati",
    "060202000003",
    "Pati Sagu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    868,
    10612,
    "0617",
    "Pati",
    "060202000004",
    "Pati Kacang Hijau/Hunkwee",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    869,
    10629,
    "0617",
    "Pati",
    "060202000004",
    "Pati Kacang Hijau/Hunkwee",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    870,
    10613,
    "0617",
    "Pati",
    "060202000005",
    "Tapioka/Pati Singkong/Pati Ubi Kayu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    871,
    10621,
    "0617",
    "Pati",
    "060202000005",
    "Tapioka/Pati Singkong/Pati Ubi Kayu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    872,
    82920,
    "0617",
    "Pati",
    "060202000005",
    "Tapioka/Pati Singkong/Pati Ubi Kayu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    873,
    10613,
    "0605",
    "Dekstrin",
    "060202000006",
    "Dekstrin",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    874,
    10621,
    "0605",
    "Dekstrin",
    "060202000006",
    "Dekstrin",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    875,
    10613,
    "0618",
    "Pati termodifikasi",
    "060202000007",
    "Pati Termodifikasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    876,
    10621,
    "0618",
    "Pati termodifikasi",
    "060202000007",
    "Pati Termodifikasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    877,
    10611,
    "0617",
    "Pati",
    "060202000008",
    "Pati Pragelatinisasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    878,
    10615,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060300000001",
    "Bulgur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    879,
    10615,
    "0602",
    "Biji-bijian dan kacang-kacangan (utuh, patahan, atau serpihan)",
    "060300000002",
    "Keping Jagung (Corn Flake)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    880,
    10615,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060300000003",
    "Meal",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    881,
    10615,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060300000004",
    "Meal Lembaga Gandum (Wheat Germ Meal)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    882,
    10615,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060300000005",
    "Oatmeal",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    883,
    82920,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060300000005",
    "Oatmeal",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    884,
    10615,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060300000006",
    "Whole Maize (Corn) Meal",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    885,
    10615,
    "0604",
    "Degermed maize",
    "060300000007",
    "Degermed Maize (Corn) Meal",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    886,
    10615,
    "0611",
    "Nasi jagung (dikeringkan)",
    "060300000008",
    "Nasi Jagung",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    887,
    10615,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060300000009",
    "Sereal Siap Santap",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    888,
    10615,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060300000010",
    "Sereal Siap Santap dengan Serealia Utuh (Whole Grain Ready To Eat Cereal)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    889,
    10615,
    "0610",
    "Minuman serbuk biji-bijian dan sereal",
    "060300000011",
    "Serbuk Minuman Sereal",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    890,
    11090,
    "0610",
    "Minuman serbuk biji-bijian dan sereal",
    "060300000011",
    "Serbuk Minuman Sereal",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    891,
    10615,
    "0628",
    "Tiwul",
    "060300000012",
    "Tiwul",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    892,
    10615,
    "0628",
    "Tiwul",
    "060300000012",
    "Tiwul",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    893,
    10615,
    "0604",
    "Degermed maize",
    "060300000013",
    "Degermed Maize (Corn) Grits",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    894,
    10615,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060300000014",
    "Gari",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    895,
    10615,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060300000015",
    "Granola",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    896,
    10615,
    "0610",
    "Minuman serbuk biji-bijian dan sereal",
    "060300000016",
    "Minuman Sereal/ Minuman Serealia",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    897,
    10615,
    "0610",
    "Minuman serbuk biji-bijian dan sereal",
    "060300000016",
    "Minuman Sereal/ Minuman Serealia",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    898,
    11090,
    "0610",
    "Minuman serbuk biji-bijian dan sereal",
    "060300000016",
    "Minuman Sereal/ Minuman Serealia",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    899,
    10740,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000001",
    "Mi Basah Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    900,
    10740,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000002",
    "Mi Basah Mentah lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    901,
    10740,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060401000003",
    "Kulit Pangsit/Risol/Lumpia  ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    902,
    10740,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000003",
    "Kulit Pangsit/Risol/Lumpia  ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    903,
    10740,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060401000003",
    "Kulit Pangsit/Risol/Lumpia  ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    904,
    10740,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000003",
    "Kulit Pangsit/Risol/Lumpia  ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    905,
    10740,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    906,
    10740,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    907,
    10740,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    908,
    10740,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    909,
    10750,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    910,
    10750,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    911,
    10750,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    912,
    10750,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    913,
    10792,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    914,
    10792,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    915,
    10792,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    916,
    10792,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    917,
    10740,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    918,
    10740,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    919,
    10740,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    920,
    10740,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    921,
    10750,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    922,
    10750,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    923,
    10750,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    924,
    10750,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    925,
    10792,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    926,
    10792,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    927,
    10792,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    928,
    10792,
    "0616",
    "Pasta dan mi mentah serta produk sejenisnya",
    "060401000004",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    929,
    10740,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060402000001",
    "Kuetiaw Kering",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    930,
    10740,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060402000002",
    "Pasta",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    931,
    10740,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060402000003",
    "Pasta Gandum Utuh",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    932,
    10740,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060402000004",
    "Produk Pasta Gandum dan Kedelai",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    933,
    10740,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060402000005",
    "Produk Pasta Sayur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    934,
    82920,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060402000005",
    "Produk Pasta Sayur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    935,
    10740,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060402000006",
    "Pasta Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    936,
    10740,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060402000007",
    "Produk Mi Gandum dan Kedelai",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    937,
    10740,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060402000008",
    "Produk Mi Sayur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    938,
    82920,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060402000008",
    "Produk Mi Sayur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    939,
    10740,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000001",
    "Sohun",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    940,
    10740,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000002",
    "Sohun Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    941,
    10740,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000003",
    "Bihun",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    942,
    10740,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000004",
    "Bihun Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    943,
    10740,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000005",
    "Pasta Instan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    944,
    10740,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000006",
    "Pasta Instan Lainnya ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    945,
    10740,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000007",
    "Mi Kering ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    946,
    10740,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000008",
    "Bihun Instan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    947,
    10740,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000009",
    "Kuetiaw Instan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    948,
    10740,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000010",
    "Makaroni Instan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    949,
    10740,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000011",
    "Mi Basah Matang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    950,
    10740,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000012",
    "Mi Basah Matang Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    951,
    10740,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000013",
    "Mi Instan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    952,
    10740,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000014",
    "Mi Instan Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    953,
    10740,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000015",
    "Mi Kering Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    954,
    10740,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000016",
    "Mi Soa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    955,
    10792,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000017",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Pramasak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    956,
    10792,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000017",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Pramasak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    957,
    10792,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000017",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Pramasak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    958,
    10792,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000017",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Pramasak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    959,
    10799,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000017",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Pramasak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    960,
    10799,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000017",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Pramasak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    961,
    10799,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000017",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Pramasak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    962,
    10799,
    "0615",
    "Pasta dan mi kering serta produk sejenis",
    "060403000017",
    "Pangsit/Pastel/Lumpia/Risol/Samosa Pramasak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    963,
    10794,
    "0606",
    "Kerupuk mentah",
    "060403000018",
    "Kerupuk Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    964,
    82920,
    "0606",
    "Kerupuk mentah",
    "060403000018",
    "Kerupuk Mentah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    965,
    10750,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060403000019",
    "Tepung Olahan / Pati Olahan / Protein Olahan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    966,
    10750,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000019",
    "Tepung Olahan / Pati Olahan / Protein Olahan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    967,
    10750,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060403000019",
    "Tepung Olahan / Pati Olahan / Protein Olahan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    968,
    10750,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000019",
    "Tepung Olahan / Pati Olahan / Protein Olahan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    969,
    10799,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060403000019",
    "Tepung Olahan / Pati Olahan / Protein Olahan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    970,
    10799,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000019",
    "Tepung Olahan / Pati Olahan / Protein Olahan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    971,
    10799,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060403000019",
    "Tepung Olahan / Pati Olahan / Protein Olahan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    972,
    10799,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000019",
    "Tepung Olahan / Pati Olahan / Protein Olahan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    973,
    10799,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060403000020",
    "Cilok",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    974,
    10799,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000020",
    "Cilok",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    975,
    10799,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060403000020",
    "Cilok",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    976,
    10799,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000020",
    "Cilok",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    977,
    10799,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060403000021",
    "Cireng/Cireng Isi",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    978,
    10799,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000021",
    "Cireng/Cireng Isi",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    979,
    10799,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060403000021",
    "Cireng/Cireng Isi",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    980,
    10799,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000021",
    "Cireng/Cireng Isi",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    981,
    10750,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060403000022",
    "Nasi Siap Saji",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    982,
    10750,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000022",
    "Nasi Siap Saji",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    983,
    10615,
    "0639",
    "Pangan olahan lainnya yang diproses dan dikemas secara aseptik dengan pH>4,6",
    "060403000023",
    "Bubur Siap Saji Dalam Kemasan (khusus Steril Komersil)",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    984,
    10615,
    "0639",
    "Pangan olahan lainnya yang diproses dan dikemas secara aseptik dengan pH>4,6",
    "060403000023",
    "Bubur Siap Saji Dalam Kemasan (khusus Steril Komersil)",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    985,
    10799,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060403000024",
    "Butiran Tepung dan/atau Pati",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    986,
    10799,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000024",
    "Butiran Tepung dan/atau Pati",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    987,
    10799,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060403000024",
    "Butiran Tepung dan/atau Pati",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    988,
    10799,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000024",
    "Butiran Tepung dan/atau Pati",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    989,
    10799,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060403000025",
    "Olahan Tepung/Pati",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    990,
    10799,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000025",
    "Olahan Tepung/Pati",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    991,
    10799,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060403000025",
    "Olahan Tepung/Pati",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    992,
    10799,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000025",
    "Olahan Tepung/Pati",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    993,
    10740,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000026",
    "Pasta Basah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    994,
    10740,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000027",
    "Pasta Basah Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    995,
    10750,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060403000028",
    "Olahan Tepung/Pati Siap Konsumsi (Latiao dan Produk Sejenis)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    996,
    10614,
    "0608",
    "Makanan pencuci mulut berbasis serealia dan pati bentuk bubuk",
    "060500000001",
    "Tepung Custard Tanpa Telur (Eggless Custard)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    997,
    10622,
    "0608",
    "Makanan pencuci mulut berbasis serealia dan pati bentuk bubuk",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    998,
    10622,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    999,
    10622,
    "0608",
    "Makanan pencuci mulut berbasis serealia dan pati bentuk bubuk",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1000,
    10622,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1001,
    10799,
    "0608",
    "Makanan pencuci mulut berbasis serealia dan pati bentuk bubuk",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1002,
    10799,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1003,
    10799,
    "0608",
    "Makanan pencuci mulut berbasis serealia dan pati bentuk bubuk",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1004,
    10799,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1005,
    10622,
    "0608",
    "Makanan pencuci mulut berbasis serealia dan pati bentuk bubuk",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1006,
    10622,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1007,
    10622,
    "0608",
    "Makanan pencuci mulut berbasis serealia dan pati bentuk bubuk",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1008,
    10622,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1009,
    10799,
    "0608",
    "Makanan pencuci mulut berbasis serealia dan pati bentuk bubuk",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1010,
    10799,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1011,
    10799,
    "0608",
    "Makanan pencuci mulut berbasis serealia dan pati bentuk bubuk",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1012,
    10799,
    "0612",
    "Pangan kategori 6 risiko rendah lainnya",
    "060500000002",
    "Sagu/Pati Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1013,
    10614,
    "0619",
    "Premiks bentuk bubuk (termasuk pada kategori pangan 1, 5, 6, 7, 10, dan 14)",
    "060500000003",
    "Premiks Untuk Makanan Pencuci Mulut Berbasis Serealia dan Pati",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1014,
    10614,
    "0626",
    "Tepung adonan",
    "060600000001",
    "Tepung Pelapis",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1015,
    10614,
    "0626",
    "Tepung adonan",
    "060600000001",
    "Tepung Pelapis",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1016,
    10614,
    "0626",
    "Tepung adonan",
    "060600000002",
    "Tepung Bumbu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1017,
    10614,
    "0626",
    "Tepung adonan",
    "060600000002",
    "Tepung Bumbu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1018,
    10614,
    "0626",
    "Tepung adonan",
    "060600000003",
    "Tepung Bakwan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1019,
    10614,
    "0626",
    "Tepung adonan",
    "060600000003",
    "Tepung Bakwan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1020,
    10614,
    "0626",
    "Tepung adonan",
    "060600000004",
    "Tepung Bakso",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1021,
    10614,
    "0626",
    "Tepung adonan",
    "060600000004",
    "Tepung Bakso",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1022,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000001",
    "Dodol/Jenang/Gelamai",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1023,
    10796,
    "0607",
    "Kue berbahan dasar beras",
    "060700000001",
    "Dodol/Jenang/Gelamai",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1024,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000001",
    "Dodol/Jenang/Gelamai",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1025,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000002",
    "Wajik/Wajit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1026,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000002",
    "Wajik/Wajit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1027,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000003",
    "Kue Mochi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1028,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000003",
    "Kue Mochi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1029,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000004",
    "Kue Teuck/Tteok",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1030,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000004",
    "Kue Teuck/Tteok",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1031,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000005",
    "Nagasari/Kue Pisang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1032,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000005",
    "Nagasari/Kue Pisang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1033,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000006",
    "Putu Ayu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1034,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000006",
    "Putu Ayu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1035,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000007",
    "Kue Mangkok",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1036,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000007",
    "Kue Mangkok",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1037,
    10424,
    "0607",
    "Kue berbahan dasar beras",
    "060700000008",
    "Jongkong Kelapa Muda",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1038,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000008",
    "Jongkong Kelapa Muda",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1039,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000008",
    "Jongkong Kelapa Muda",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1040,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000009",
    "Talam Ebi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1041,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000009",
    "Talam Ebi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1042,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000010",
    "Kue Lapis Beras",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1043,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000010",
    "Kue Lapis Beras",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1044,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000011",
    "Juadah Kering/Mayang Papan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1045,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000011",
    "Juadah Kering/Mayang Papan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1046,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000012",
    "Petah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1047,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000012",
    "Petah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1048,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000013",
    "Amparan Tatak Pisang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1049,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000013",
    "Amparan Tatak Pisang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1050,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000014",
    "Lampu-Lampu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1051,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000014",
    "Lampu-Lampu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1052,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000015",
    "Pisang Hijau",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1053,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000015",
    "Pisang Hijau",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1054,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000016",
    "Temo Coe",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1055,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000016",
    "Temo Coe",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1056,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000017",
    "Lemper Ayam",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1057,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000017",
    "Lemper Ayam",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1058,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000018",
    "Semar Mendem",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1059,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000018",
    "Semar Mendem",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1060,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000019",
    "Jadah Manten",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1061,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000019",
    "Jadah Manten",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1062,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000020",
    "Lepet Ketan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1063,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000020",
    "Lepet Ketan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1064,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000021",
    "Kue Ku",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1065,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000021",
    "Kue Ku",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1066,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000022",
    "Legondo",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1067,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000022",
    "Legondo",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1068,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000023",
    "Onde-Onde",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1069,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000023",
    "Onde-Onde",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1070,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000024",
    "Seri Muka",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1071,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000024",
    "Seri Muka",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1072,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000025",
    "Kekicak/Gegicak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1073,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000025",
    "Kekicak/Gegicak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1074,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000026",
    "Lalampa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1075,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000026",
    "Lalampa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1076,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000027",
    "Katrisolo",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1077,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000027",
    "Katrisolo",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1078,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000028",
    "Lapek Bugis",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1079,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000028",
    "Lapek Bugis",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1080,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000029",
    "Lamang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1081,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000029",
    "Lamang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1082,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000030",
    "Ombus-ombus",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1083,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000030",
    "Ombus-ombus",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1084,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000031",
    "Legomoro",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1085,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000031",
    "Legomoro",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1086,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000032",
    "Kue Berbahan Dasar Beras Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1087,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000032",
    "Kue Berbahan Dasar Beras Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1088,
    10799,
    "0607",
    "Kue berbahan dasar beras",
    "060700000033",
    "Brem Padat",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1089,
    10799,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060700000034",
    "Nasi Siap konsumsi/Siap Santap/Siap Saji",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1090,
    10750,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060700000035",
    "Bubur Beras Siap Konsumsi/Siap Santap/Siap Saji",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1091,
    10799,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060700000035",
    "Bubur Beras Siap Konsumsi/Siap Santap/Siap Saji",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1092,
    10792,
    "0607",
    "Kue berbahan dasar beras",
    "060700000036",
    "Tape Ketan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1093,
    11040,
    "0609",
    "Minuman kedelai",
    "060801000001",
    "Sari Kedelai ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1094,
    11090,
    "0609",
    "Minuman kedelai",
    "060801000001",
    "Sari Kedelai ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1095,
    11090,
    "0610",
    "Minuman serbuk biji-bijian dan sereal",
    "060801000002",
    "Serbuk Minuman Kedelai",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1096,
    11090,
    "0609",
    "Minuman kedelai",
    "060801000003",
    "Konsentrat Sari Kedelai",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1097,
    11040,
    "0609",
    "Minuman kedelai",
    "060801000004",
    "Sari Kedelai Fermentasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1098,
    11090,
    "0609",
    "Minuman kedelai",
    "060801000004",
    "Sari Kedelai Fermentasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1099,
    10392,
    "0614",
    "Pangan kategori 6 risiko sedang lainnya",
    "060802000001",
    "Lapisan Tipis Cairan Kedelai",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1100,
    10392,
    "0623",
    "Tahu segar",
    "060803000001",
    "Tahu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1101,
    10392,
    "0623",
    "Tahu segar",
    "060803000001",
    "Tahu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1102,
    10392,
    "0624",
    "Tahu semi-kering",
    "060804000001",
    "Tahu Semi-Kering",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1103,
    10392,
    "0624",
    "Tahu semi-kering",
    "060804010001",
    "Tahu Semi-Kering yang Diolah Dengan Saus Kental",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1104,
    10392,
    "0624",
    "Tahu semi-kering",
    "060804010001",
    "Tahu Semi-Kering yang Diolah Dengan Saus Kental",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1105,
    10392,
    "0624",
    "Tahu semi-kering",
    "060804020001",
    "Tahu Semi-Kering yang Digoreng Dengan Minyak Banyak (DeepFried)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1106,
    10392,
    "0624",
    "Tahu semi-kering",
    "060804030001",
    "Tahu Semi-Kering, Selain Dari Kategori 0608040001 dan 0608040002",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1107,
    10392,
    "0622",
    "Tahu kering",
    "060805000001",
    "Tahu Kering",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1108,
    10393,
    "0622",
    "Tahu kering",
    "060805000001",
    "Tahu Kering",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1109,
    10393,
    "0620",
    "Produk kedelai fermentasi",
    "060806000001",
    "Dou chi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1110,
    10393,
    "0620",
    "Produk kedelai fermentasi",
    "060806000002",
    "Natto",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1111,
    10391,
    "0620",
    "Produk kedelai fermentasi",
    "060806000003",
    "Tempe",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1112,
    10771,
    "0620",
    "Produk kedelai fermentasi",
    "060806000004",
    "Tauco",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    1113,
    10391,
    "0620",
    "Produk kedelai fermentasi",
    "060806000005",
    "Abon Tempe",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1114,
    10393,
    "0620",
    "Produk kedelai fermentasi",
    "060806000005",
    "Abon Tempe",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1115,
    10392,
    "0620",
    "Produk kedelai fermentasi",
    "060806000006",
    "Oncom Merah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1116,
    10393,
    "0620",
    "Produk kedelai fermentasi",
    "060806000006",
    "Oncom Merah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1117,
    10771,
    "0620",
    "Produk kedelai fermentasi",
    "060807000001",
    "Tahu Fermentasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1118,
    10793,
    "0621",
    "Produk protein kedelai lainnya",
    "060808000001",
    "Produk Protein Kedelai",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1119,
    10799,
    "0621",
    "Produk protein kedelai lainnya",
    "060808000001",
    "Produk Protein Kedelai",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1120,
    10793,
    "0621",
    "Produk protein kedelai lainnya",
    "060808000002",
    "Texturized Vegetable Protein (TVP)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1121,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010001",
    "Roti Tawar",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1122,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010002",
    "Roti Tawar Dengan Penambahan Bahan Pangan Lain",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1123,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010003",
    "Roti Tawar Kupas",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1124,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010004",
    "Roti Rye",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1125,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010005",
    "Roti Pumpernickel",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1126,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010006",
    "Roti Buah/Roti Kismis/Roti Chocochips",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1127,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010007",
    "Roti Gandum Utuh (Whole Wheat)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1128,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010008",
    "Roti Campuran Tepung Terigu dan Kulit Gandum/Roti dengan Kulit Gandum (Fine Bran)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1129,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010009",
    "Roti Perancis (Baguette/pain courant francais)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1130,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010010",
    "Roti Malt",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1131,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010011",
    "Roti Kadet",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1132,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010012",
    "Roti Kadet Gandum",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1133,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010013",
    "Roti Kadet Susu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1134,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010014",
    "Roti Wheat-Germ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1135,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010015",
    "Roti Meal",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1136,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010016",
    "Roti Meal Utuh (Whole Meal)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1137,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101010017",
    "Roti Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1138,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070101020001",
    "Roti Soda",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1139,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070102000001",
    "Krekers",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1140,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070102000002",
    "Krekers Krim",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1141,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070102000003",
    "Water Biscuit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1142,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070102000004",
    "Krekers Soda",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1143,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070103000001",
    "Shortened Bread",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1144,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070103000002",
    "Bagel",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1145,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070103000003",
    "Roti Pita",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1146,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070103000004",
    "Muffin Inggris (English Muffin)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1147,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070103000005",
    "Roti Canai/Roti Cane/Roti Kane/Roti Kanai/Roti Maryam",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1148,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070103000006",
    "Roti Jala",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1149,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070103000007",
    "Roti Tortila/ Kulit Tortila/ Tortilla Wraps",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1150,
    10710,
    "0704",
    "Produk serupa roti termasuk roti untuk isi (stuffing) dan tepung roti, tepung panir",
    "070104000001",
    "Crouton",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1151,
    10614,
    "0704",
    "Produk serupa roti termasuk roti untuk isi (stuffing) dan tepung roti, tepung panir",
    "070104000002",
    "Tepung Panir",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1152,
    10614,
    "0704",
    "Produk serupa roti termasuk roti untuk isi (stuffing) dan tepung roti, tepung panir",
    "070104000003",
    "Tepung Roti/Bread Crumb",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1153,
    82920,
    "0704",
    "Produk serupa roti termasuk roti untuk isi (stuffing) dan tepung roti, tepung panir",
    "070104000003",
    "Tepung Roti/Bread Crumb",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1154,
    10710,
    "0704",
    "Produk serupa roti termasuk roti untuk isi (stuffing) dan tepung roti, tepung panir",
    "070104000004",
    "Roti Untuk Stuffing",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1155,
    10614,
    "0704",
    "Produk serupa roti termasuk roti untuk isi (stuffing) dan tepung roti, tepung panir",
    "070104000005",
    "Premiks Untuk Stuffing",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1156,
    10614,
    "0704",
    "Produk serupa roti termasuk roti untuk isi (stuffing) dan tepung roti, tepung panir",
    "070104000006",
    "Adonan Shortened Bread",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1157,
    10710,
    "0702",
    "Pangan kategori 7 risiko sedang lainnya",
    "070105000001",
    "Mantao",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1158,
    10792,
    "0702",
    "Pangan kategori 7 risiko sedang lainnya",
    "070105000001",
    "Mantao",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1159,
    10710,
    "0702",
    "Pangan kategori 7 risiko sedang lainnya",
    "070105000002",
    "Bakpao/Pao",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1160,
    10792,
    "0702",
    "Pangan kategori 7 risiko sedang lainnya",
    "070105000002",
    "Bakpao/Pao",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1161,
    10792,
    "0702",
    "Pangan kategori 7 risiko sedang lainnya",
    "070105000003",
    "Apem",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1162,
    10792,
    "0702",
    "Pangan kategori 7 risiko sedang lainnya",
    "070105000004",
    "Kue Mangkok",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1163,
    10792,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070105000005",
    "Bun Kukus",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1164,
    10614,
    "0701",
    "Pangan kategori 7 risiko rendah lainnya",
    "070106000001",
    "Premiks Untuk Roti Tawar dan Produk Bakeri Tawar",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1165,
    10710,
    "0701",
    "Pangan kategori 7 risiko rendah lainnya",
    "070106000001",
    "Premiks Untuk Roti Tawar dan Produk Bakeri Tawar",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1166,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000001",
    "Keik (Cake)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1167,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000001",
    "Keik (Cake)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1168,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000002",
    "Keik Mentega (Butter Cake)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1169,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000002",
    "Keik Mentega (Butter Cake)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1170,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000003",
    "Keik Keju (Cheese Cake)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1171,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000003",
    "Keik Keju (Cheese Cake)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1172,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000004",
    "Keik Pound (Pound Cake atau Quatre Quarts)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1173,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000004",
    "Keik Pound (Pound Cake atau Quatre Quarts)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1174,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000005",
    "Brownies",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1175,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000006",
    "Biskuit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1176,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000006",
    "Biskuit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1177,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000007",
    "Biskuit Non Terigu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1178,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000007",
    "Biskuit Non Terigu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1179,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000008",
    "Biskuit Marie",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1180,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000008",
    "Biskuit Marie",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1181,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000009",
    "Biskuit Marie Salut",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1182,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000009",
    "Biskuit Marie Salut",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1183,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000010",
    "Biskuit Lapis/Biskuit Sandwich",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1184,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000010",
    "Biskuit Lapis/Biskuit Sandwich",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1185,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000011",
    "Biskuit Colek",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1186,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000011",
    "Biskuit Colek",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1187,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000012",
    "Kukis",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1188,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000013",
    "Kukis Lunak (Soft Cookies)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1189,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000014",
    "Kukis Gula",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1190,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000015",
    "Kukis Oatmeal",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1191,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000016",
    "Nastar",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1192,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000017",
    "Kastengel",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1193,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000018",
    "Wafer",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1194,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000019",
    "Wafer Roll/Wafer Stick",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1195,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000020",
    "Wafer Salut",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1196,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000021",
    "Pai",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1197,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000022",
    "Pai Isi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1198,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000023",
    "Bolu Kukus",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1199,
    10792,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000024",
    "Bika Ambon",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1200,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000025",
    "Egg Roll",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1201,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000026",
    "Biskuit Bar Sereal Isi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1202,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000026",
    "Biskuit Bar Sereal Isi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1203,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000027",
    "Crepes",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1204,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000028",
    "Roti Bagelen",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1205,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070201000029",
    "Kue Semprong/Kapit/Gapit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1206,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000001",
    "Pastri",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1207,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000002",
    "Roti Manis",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1208,
    10710,
    "0705",
    "Adonan/produk bakeri beku",
    "070202000002",
    "Roti Manis",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1209,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000002",
    "Roti Manis",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1210,
    10710,
    "0705",
    "Adonan/produk bakeri beku",
    "070202000002",
    "Roti Manis",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1211,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000003",
    "Roti Isi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1212,
    10710,
    "0705",
    "Adonan/produk bakeri beku",
    "070202000003",
    "Roti Isi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1213,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000003",
    "Roti Isi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1214,
    10710,
    "0705",
    "Adonan/produk bakeri beku",
    "070202000003",
    "Roti Isi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1215,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000004",
    "Scone",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1216,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000005",
    "Donat",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1217,
    10792,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000005",
    "Donat",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1218,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000006",
    "Muffin Amerika (American Muffin)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1219,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000007",
    "Roti Buaya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1220,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000008",
    "Kue Tambang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1221,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000009",
    "Wafel",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1222,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000010",
    "Stroopwafel",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1223,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000011",
    "Cone untuk Es Krim",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1224,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000012",
    "Panekuk",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1225,
    10792,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000012",
    "Panekuk",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1226,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000013",
    "Bakpia",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1227,
    10792,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000013",
    "Bakpia",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1228,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000014",
    "Bolu Emprit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1229,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000015",
    "Remahan Biskuit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1230,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000015",
    "Remahan Biskuit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1231,
    10710,
    "0703",
    "Produk bakeri (roti, biskuit krekers, wafer dan sejenisnya)",
    "070202000017",
    "Piza/Pizza",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1232,
    10614,
    "0701",
    "Pangan kategori 7 risiko rendah lainnya",
    "070203000001",
    "Premiks Untuk Produk Bakeri Istimewa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1233,
    82920,
    "0701",
    "Pangan kategori 7 risiko rendah lainnya",
    "070203000001",
    "Premiks Untuk Produk Bakeri Istimewa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    1234,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000001",
    "Karkas Hewan Mamalia",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1235,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000002",
    "Karkas Sapi",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1236,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000003",
    "Karkas Paruh Sapi (Half Carcass)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1237,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000004",
    "Karkas Perempat Sapi",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1238,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000005",
    "Seperempat Karkas Bagian Belakang/Karkas Bagian Paha (Hind Quarter/Leg Quarter)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1239,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000006",
    "Forequarter",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1240,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000007",
    "Hindquarter",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1241,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000008",
    "Forequarter dan Hindquarter",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1242,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000009",
    "Tulang Iga Pendek (Short Ribs)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1243,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000010",
    "Tulang Iga Utama (Prime Rib)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1244,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000011",
    "Karkas Kerbau",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1245,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000012",
    "Karkas Kambing/Domba",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1246,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000013",
    "Karkas Paruh Depan dan Karkas Paruh Belakang Kambing/Domba",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1247,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000014",
    "Karkas Paruh Kiri dan Karkas Paruh Kanan Kambing/Domba",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1248,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000015",
    "Karkas Perempat Kambing/Domba",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1249,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000016",
    "Leg kambing/Domba",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1250,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000017",
    "Shoulder Kambing/Domba",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1251,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000018",
    "Karkas Babi",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1252,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000019",
    "Bagian Mamalia Non Karkas",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1253,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000020",
    "Offal",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1254,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000021",
    "Jeroan",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1255,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000022",
    "Rack",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1256,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000023",
    "Breast",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1257,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000024",
    "Foreshank Domba",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1258,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000025",
    "Karkas Ayam",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1259,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000026",
    "Separuh Karkas (Half Poultry)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1260,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000027",
    "Seperempat Karkas Bagian Depan/Karkas Bagian Dada (Front Quarter/Breast Quarter)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1261,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000028",
    "Seperempat Karkas Bagian Belakang/Karkas Bagian Paha (Hind Quarter/ Leg Quarter)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1262,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000029",
    "Punggung Utuh (Whole Back)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1263,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000030",
    "Ekor (Brutu)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1264,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000031",
    "Punggung (Back)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1265,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000032",
    "Punggung Terkupas (Stripped Back)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1266,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000033",
    "Dada Utuh (Full Breast)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1267,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000034",
    "Dada Depan (Wishbone)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1268,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000035",
    "Dada Hasil Trimming (Trimmed Breast)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1269,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000036",
    "Separuh Dada Hasil Trimming (Half Trimmed Breast)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1270,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000037",
    "Sayap (Wing)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1271,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000038",
    "Sayap Atas (Wing Drumette)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1272,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000039",
    "Sayap Bawah (Winglet atau V-Wing)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1273,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000040",
    "Paha (Leg) Unggas",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1274,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000041",
    "Paha Atas (Thigh)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1275,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000042",
    "Paha Bawah (Drumstick)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1276,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000043",
    "Bagian Unggas Non Karkas",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1277,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000044",
    "Kepala",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1278,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000045",
    "Leher",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1279,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000046",
    "Kaki atau Cakar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1280,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000047",
    "Jeroan Unggas (Poultry Giblets)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1281,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000048",
    "Daging",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1282,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000049",
    "Daging Dingin",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1283,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000050",
    "Daging Beku",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1284,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000051",
    "Steik (Steaks) Daging Sapi Beku",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1285,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000052",
    "Daging Sapi/Kerbau",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1286,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000053",
    "Daging Kambing/Domba",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1287,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000054",
    "Daging Iga (Rib Meat)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1288,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000055",
    "Jenis Potongan Bagian Daging",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1289,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000056",
    "Lamusir (Rib Eye)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1290,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000057",
    "Lamusir (Cuberoll)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1291,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000058",
    "Sandung Lamur (Brisket)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1292,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000059",
    "Sengkel (Shin dan Shank)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1293,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000060",
    "Sengkel (Shank/Foreshank)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1294,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000061",
    "Samcan (Thin Flank)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1295,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000062",
    "Flank",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1296,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000063",
    "Has Dalam (Tenderloin)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1297,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000064",
    "Has Luar (Striploin/Sirloin)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1298,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000065",
    "Has (Tenderloin) Kambing/Domba",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1299,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000066",
    "Loin Kambing/Domba",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1300,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000067",
    "Penutup (Top side)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1301,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000068",
    "Pendasar (Riverside)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1302,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000069",
    "Gandik (Eye Round)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1303,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000070",
    "Tanjung (Rump)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1304,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000071",
    "Kelapa (Round)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1305,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000072",
    "Kijen (Chuck Tender)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1306,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000073",
    "Sampil Besar (Chuck)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1307,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000074",
    "Sampil Kecil (Blade)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1308,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000075",
    "Daging Tanpa Tulang yang Dijual dalam Bentuk Kemasan Besar (Bulk Pack)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1309,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000076",
    "Tetelan",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1310,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080101000077",
    "Potongan Daging Unggas",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1311,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080101000078",
    "Filet Dada (Breast Fillet)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1312,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080101000079",
    "Lemak",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1313,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080102000001",
    "Patties",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1314,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080102000002",
    "Sosis Mentah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1315,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080102000003",
    "Sosis Mentah Daging Babi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1316,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080102000004",
    "Daging Cincang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1317,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080102000005",
    "Daging Giling",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1318,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080102000006",
    "Daging Murni Giling Tanpa Lemak",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1319,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080102000007",
    "Potongan Daging Unggas dan Daging Hewan Buruan yang Dilepaskan dari Tulangnya, Digiling Mekanik dan Dibentuk (Dengan atau Tanpa Pembaluran atau Pelapisan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1320,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080102000008",
    "Mechanically Deboned Meat (MDM)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1321,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080102000009",
    "Desinewed Minced Meat (DMM)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1322,
    10130,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201010001",
    "Bacon",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1323,
    10130,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201010002",
    "Bacon Sapi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1324,
    10130,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201010003",
    "Daging Marinasi",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1325,
    10130,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201010004",
    "Daging Sapi yang Dimarinasi",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1326,
    10130,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201010005",
    "Daging Ayam yang Dimarinasi",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1327,
    10130,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1328,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1329,
    10130,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1330,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1331,
    10310,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1332,
    10310,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1333,
    10310,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1334,
    10310,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1335,
    10130,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1336,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1337,
    10130,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1338,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1339,
    10130,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1340,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1341,
    10130,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1342,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080201010006",
    "Daging Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1343,
    10130,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201010007",
    "Daging Sei",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1344,
    10130,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201020001",
    "Daging Paha Babi Curing Mentah",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1345,
    10130,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080201020002",
    "Dendeng Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1346,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080201030001",
    "Daging Sapi yang Difermentasi Dalam Wadah Keramik (Potted Beef)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1347,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080201030002",
    "Daging Cangkuk",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1348,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080202000001",
    "Daging Paha Babi Curing Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1349,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080202000001",
    "Daging Paha Babi Curing Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1350,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080202000002",
    "Ham Sapi (Daging Paha Sapi Curing) Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1351,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080202000002",
    "Ham Sapi (Daging Paha Sapi Curing) Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1352,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080202000003",
    "Bahu Babi Curing Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1353,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080202000003",
    "Bahu Babi Curing Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1354,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080202000004",
    "Bahu Sapi Curing Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1355,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080202000004",
    "Bahu Sapi Curing Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1356,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080202000005",
    "Daging Olahan Berbumbu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1357,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080202000005",
    "Daging Olahan Berbumbu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1358,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080202000006",
    "Daging Kuah dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1359,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080202000006",
    "Daging Kuah dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1360,
    10130,
    "0801",
    "Daging dalam Kaleng",
    "080202000007",
    "Daging dalam Kaleng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1361,
    10750,
    "0801",
    "Daging dalam Kaleng",
    "080202000007",
    "Daging dalam Kaleng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1362,
    10130,
    "0803",
    "Pangan kategori 8 risiko rendah lainnya",
    "080202000008",
    "Abon Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1363,
    10750,
    "0803",
    "Pangan kategori 8 risiko rendah lainnya",
    "080202000008",
    "Abon Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1364,
    10794,
    "0803",
    "Pangan kategori 8 risiko rendah lainnya",
    "080202000009",
    "Kerupuk4  Kulit/Rambak",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1365,
    82920,
    "0803",
    "Pangan kategori 8 risiko rendah lainnya",
    "080202000009",
    "Kerupuk4  Kulit/Rambak",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1366,
    10794,
    "0803",
    "Pangan kategori 8 risiko rendah lainnya",
    "080202000010",
    "Keripik3 Paru",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1367,
    82920,
    "0803",
    "Pangan kategori 8 risiko rendah lainnya",
    "080202000010",
    "Keripik3 Paru",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1368,
    10794,
    "0803",
    "Pangan kategori 8 risiko rendah lainnya",
    "080202000011",
    "Kerupuk4 Berbasis Daging, Daging Unggas dan Daging Hewan Buruan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1369,
    10794,
    "0803",
    "Pangan kategori 8 risiko rendah lainnya",
    "080202000012",
    "Usus Ayam Goreng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1370,
    10799,
    "0803",
    "Pangan kategori 8 risiko rendah lainnya",
    "080202000012",
    "Usus Ayam Goreng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1371,
    10130,
    "0803",
    "Pangan kategori 8 risiko rendah lainnya",
    "080202000013",
    "Foie Gras and Pates",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1372,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080203000001",
    "Ayam Katsu (Chicken Katsu)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1373,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080203000001",
    "Ayam Katsu (Chicken Katsu)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1374,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080203000002",
    "Ayam Karage (Chicken Karage)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1375,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080203000002",
    "Ayam Karage (Chicken Karage)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1376,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080203000003",
    "Ayam Goreng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1377,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080203000003",
    "Ayam Goreng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1378,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080203000004",
    "Daging Marinasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1379,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080203000004",
    "Daging Marinasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1380,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080203000005",
    "Chicken Strip Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1381,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080203000005",
    "Chicken Strip Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1382,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080203000006",
    "Ayam Cordon Bleu (Chicken Cordon Bleu)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1383,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080203000006",
    "Ayam Cordon Bleu (Chicken Cordon Bleu)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1384,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080203000007",
    "Kulit Ayam Goreng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1385,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080203000007",
    "Kulit Ayam Goreng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1386,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080203000008",
    "Potongan Daging dengan Saus dalam Kemasan yang Dibekukan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1387,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080203000008",
    "Potongan Daging dengan Saus dalam Kemasan yang Dibekukan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1388,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1389,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1390,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1391,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1392,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1393,
    10750,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1394,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1395,
    10750,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1396,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1397,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1398,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1399,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1400,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1401,
    10750,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1402,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1403,
    10750,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1404,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1405,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1406,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1407,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1408,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1409,
    10750,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1410,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1411,
    10750,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080203000009",
    "Daging Olahan Berbumbu Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1412,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080301010001",
    "Sosis Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1413,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080301010001",
    "Sosis Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1414,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080301010001",
    "Sosis Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1415,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080301010001",
    "Sosis Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1416,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080301010002",
    "Sosis Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1417,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080301010002",
    "Sosis Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1418,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080301010002",
    "Sosis Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1419,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080301010002",
    "Sosis Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1420,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080301010003",
    "Kornet Daging Non Sterilisasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1421,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080301010004",
    "Urutan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1422,
    10130,
    "0805",
    "Produk olahan daging dan unggas yang di-curing tanpa perlakuan panas",
    "080301020001",
    "Sosis Cina (Termasuk Sosis Tradisional yang Dicuring atau Diasap) atau LupCheong",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1423,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080301030001",
    "Salami",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1424,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080301030002",
    "Chorizos",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1425,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080302000001",
    "Pate Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1426,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080302000001",
    "Pate Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1427,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080302000002",
    "Bakso Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1428,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080302000002",
    "Bakso Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1429,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080302000002",
    "Bakso Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1430,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080302000002",
    "Bakso Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1431,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080302000003",
    "Daging Cincang Olahan Berbumbu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1432,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080302000003",
    "Daging Cincang Olahan Berbumbu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1433,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080302000004",
    "Patties Daging Panggang Setengah Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1434,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080302000005",
    "Brawn and Head Cheese",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1435,
    10130,
    "0802",
    "Kornet Daging Sterilisasi",
    "080302000006",
    "Kornet Daging Sterilisasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1436,
    10750,
    "0802",
    "Kornet Daging Sterilisasi",
    "080302000006",
    "Kornet Daging Sterilisasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1437,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080302000007",
    "Daging Luncheon Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1438,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080302000007",
    "Daging Luncheon Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1439,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080302000008",
    "Pasta Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1440,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080302000009",
    "Salami Matang / Pepperoni Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1441,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080302000009",
    "Salami Matang / Pepperoni Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1442,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080302000010",
    "Sosis Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1443,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080302000010",
    "Sosis Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1444,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080302000010",
    "Sosis Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1445,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080302000010",
    "Sosis Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1446,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080302000011",
    "Sosis Daging Non Casing",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1447,
    10130,
    "0807",
    "Sosis Daging Siap Makan",
    "080302000012",
    "Sosis Daging Siap Makan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1448,
    10750,
    "0807",
    "Sosis Daging Siap Makan",
    "080302000012",
    "Sosis Daging Siap Makan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1449,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080302000013",
    "Terrines (Campuran Cacahan Daging Matang)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1450,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080302000013",
    "Terrines (Campuran Cacahan Daging Matang)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1451,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080302000014",
    "Rolade Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1452,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080302000014",
    "Rolade Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1453,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080302000015",
    "Daging Halus Olahan Berbumbu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1454,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080302000015",
    "Daging Halus Olahan Berbumbu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1455,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080302000016",
    "Potongan Daging/Daging Cincang/Daging Giling dengan Saus dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1456,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080302000016",
    "Potongan Daging/Daging Cincang/Daging Giling dengan Saus dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1457,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080302000017",
    "Dendeng Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1458,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080302000017",
    "Dendeng Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1459,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080302000018",
    "Pepperoni",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1460,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080302000018",
    "Pepperoni",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1461,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080302000018",
    "Pepperoni",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1462,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080302000018",
    "Pepperoni",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1463,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080302000018",
    "Pepperoni",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1464,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080302000018",
    "Pepperoni",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1465,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080302000019",
    "Tahu Bakso",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1466,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080302000019",
    "Tahu Bakso",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1467,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080302000019",
    "Tahu Bakso",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1468,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080302000019",
    "Tahu Bakso",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1469,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080302000019",
    "Tahu Bakso",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1470,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080302000019",
    "Tahu Bakso",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1471,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080302000020",
    "Sosis Daging dengan Proses Pasteurisasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1472,
    10130,
    "0807",
    "Sosis Daging Siap Makan",
    "080302000020",
    "Sosis Daging dengan Proses Pasteurisasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1473,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080302000020",
    "Sosis Daging dengan Proses Pasteurisasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1474,
    10130,
    "0807",
    "Sosis Daging Siap Makan",
    "080302000020",
    "Sosis Daging dengan Proses Pasteurisasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1475,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080302000020",
    "Sosis Daging dengan Proses Pasteurisasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1476,
    10750,
    "0807",
    "Sosis Daging Siap Makan",
    "080302000020",
    "Sosis Daging dengan Proses Pasteurisasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1477,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080302000020",
    "Sosis Daging dengan Proses Pasteurisasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1478,
    10750,
    "0807",
    "Sosis Daging Siap Makan",
    "080302000020",
    "Sosis Daging dengan Proses Pasteurisasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1479,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080302000021",
    "Bakso Daging dengan Proses Pasteurisasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1480,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080303000001",
    "Burger Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1481,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000001",
    "Burger Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1482,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080303000001",
    "Burger Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1483,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000001",
    "Burger Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1484,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080303000001",
    "Burger Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1485,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000001",
    "Burger Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1486,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080303000001",
    "Burger Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1487,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000001",
    "Burger Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1488,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080303000001",
    "Burger Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1489,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000001",
    "Burger Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1490,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080303000001",
    "Burger Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1491,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000001",
    "Burger Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1492,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1493,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1494,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1495,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1496,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1497,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1498,
    10130,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1499,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1500,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1501,
    10750,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1502,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1503,
    10750,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1504,
    10750,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1505,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1506,
    10750,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1507,
    10750,
    "0804",
    "Pangan kategori 8 risiko sedang lainnya",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1508,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1509,
    10750,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000002",
    "Naget Ayam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1510,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080303000003",
    "Kornet Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1511,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080303000004",
    "Naget Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1512,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080303000004",
    "Naget Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1513,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080303000005",
    "Smoked Chicken Breast (Daging Dada Ayam Asap)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1514,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1515,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1516,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1517,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1518,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1519,
    10750,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1520,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1521,
    10750,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1522,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1523,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1524,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1525,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1526,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1527,
    10750,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1528,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1529,
    10750,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1530,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1531,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1532,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1533,
    10130,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1534,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1535,
    10750,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1536,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1537,
    10750,
    "0809",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 08)",
    "080303000006",
    "Siomay Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1538,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080303000007",
    "Gyoza",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1539,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080303000007",
    "Gyoza",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1540,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080303000008",
    "Swikiau/Kuotieh Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1541,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080303000008",
    "Swikiau/Kuotieh Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1542,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080303000009",
    "Ebi Katsu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1543,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080303000009",
    "Ebi Katsu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1544,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080303000010",
    "Keecho/Heecho",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1545,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080303000010",
    "Keecho/Heecho",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1546,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080303000011",
    "Telur Bungkus Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1547,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080303000011",
    "Telur Bungkus Daging",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1548,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080303000012",
    "Bakso Goreng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1549,
    10750,
    "0806",
    "Produk olahan daging lainnya",
    "080303000012",
    "Bakso Goreng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1550,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080303000013",
    "Tahu Bakso Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1551,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080303000013",
    "Tahu Bakso Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1552,
    10130,
    "0806",
    "Produk olahan daging lainnya",
    "080303000013",
    "Tahu Bakso Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1553,
    10217,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090101000001",
    "Ikan Segar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1554,
    10217,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090101000002",
    "Sashimi Segar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1555,
    10217,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090101000003",
    "Tuna Loin Segar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1556,
    10217,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090101000004",
    "Fillet Ikan Segar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1557,
    "03111",
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090101000005",
    "Ikan Hidup untuk Konsumsi",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1558,
    "03121",
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090101000005",
    "Ikan Hidup untuk Konsumsi",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1559,
    10217,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090101000006",
    "Bandeng Segar Cabut Tulang dan Duri",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1560,
    "03113",
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090102000001",
    "Keong Hidup",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1561,
    "03113",
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090102000002",
    "Kerang Hidup",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1562,
    10297,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090102000003",
    "Kerang Segar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1563,
    "03113",
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090102000004",
    "Tiram Hidup",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1564,
    10297,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090102000005",
    "Bulu Babi Segar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1565,
    10297,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090102000006",
    "Cumi-cumi Segar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1566,
    10297,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090102000007",
    "Rajungan Segar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1567,
    10297,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090102000008",
    "Teripang Segar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1568,
    10297,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090102000009",
    "Udang Segar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1569,
    10297,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090102000010",
    "Kepiting Hidup untuk Konsumsi",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1570,
    10297,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090102000011",
    "Lobster dan Udang Kipas Hidup Untuk Konsumsi",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1571,
    10212,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090201000001",
    "Sidat Panggang Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1572,
    10750,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090201000001",
    "Sidat Panggang Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1573,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090201000002",
    "Pempek Ikan Rebus Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1574,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090201000003",
    "Bakso Ikan Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1575,
    10216,
    "0908",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 09)",
    "090201000003",
    "Bakso Ikan Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1576,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090201000003",
    "Bakso Ikan Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1577,
    10216,
    "0908",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 09)",
    "090201000003",
    "Bakso Ikan Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1578,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090201000004",
    "Cumi-Cumi / Kerang / Ikan / ... Beku dengan Penambahan Bahan Pangan Lain",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1579,
    10217,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090201000005",
    "Telur ikan beku dengan penambahan bahan pangan lain",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1580,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090201000006",
    "Tahu Bakso Ikan Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1581,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090202000004",
    "Stik, Filet,dan Lumatan Daging Ikan Berlapis Tepung Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1582,
    10219,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090202000004",
    "Stik, Filet,dan Lumatan Daging Ikan Berlapis Tepung Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1583,
    10296,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090202000005",
    "Udang Berlapis Tepung (Breaded) Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1584,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090202000006",
    "Naget Ikan/Udang/Cumi/Kerang Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1585,
    10296,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090202000006",
    "Naget Ikan/Udang/Cumi/Kerang Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1586,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010001",
    "Ikan dan Produk Ikan Kukus atau Rebus",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1587,
    10214,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010002",
    "Ikan Pindang Air Garam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1588,
    10214,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010003",
    "Ikan Pindang Garam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1589,
    10212,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010004",
    "Bandeng Presto",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1590,
    10214,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010004",
    "Bandeng Presto",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1591,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010005",
    "Kue Ikan/Kamaboko/Fish Cake (rebus atau kukus)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1592,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010006",
    "Bakwan Ikan (Rebus Atau Kukus)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1593,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010007",
    "Stik Kepiting Analog atau Imitation Crab Stick",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1594,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010007",
    "Stik Kepiting Analog atau Imitation Crab Stick",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1595,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010007",
    "Stik Kepiting Analog atau Imitation Crab Stick",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1596,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010008",
    "Bakso Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1597,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010009",
    "Otak-Otak Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1598,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010010",
    "Bandeng Isi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1599,
    10219,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010010",
    "Bandeng Isi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1600,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010011",
    "Dimsum Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1601,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010012",
    "Pempek Ikan (Rebus)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1602,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010013",
    "Tekwan Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1603,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010014",
    "Pepes Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1604,
    10750,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010014",
    "Pepes Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1605,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010015",
    "Sosis Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1606,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010016",
    "Sosis Ikan Kombinasi",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1607,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010017",
    "Rolade Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1608,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010018",
    "Burger Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1609,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010019",
    "Tsukudani",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1610,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010020",
    "Telur Ikan Masak",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1611,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010021",
    "Olahan Ikan Berbumbu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1612,
    10219,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010021",
    "Olahan Ikan Berbumbu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1613,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204010022",
    "Tahu Bakso Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1614,
    10296,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204020001",
    "Kue Cumi/Sotong/Udang Kukus",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1615,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204020002",
    "Dimsum Udang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1616,
    10216,
    "0908",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 09)",
    "090204020002",
    "Dimsum Udang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1617,
    10216,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204020002",
    "Dimsum Udang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1618,
    10216,
    "0908",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 09)",
    "090204020002",
    "Dimsum Udang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1619,
    10296,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204020002",
    "Dimsum Udang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1620,
    10296,
    "0908",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 09)",
    "090204020002",
    "Dimsum Udang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1621,
    10296,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204020002",
    "Dimsum Udang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1622,
    10296,
    "0908",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 09)",
    "090204020002",
    "Dimsum Udang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1623,
    10296,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204020003",
    "Bakso Moluska/Krustase/Ekinodermata",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1624,
    10296,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204020004",
    "Sosis Udang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1625,
    10296,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204020005",
    "Daging Rajungan Rebus Dingin",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1626,
    10296,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204030001",
    "Udang Popcorn",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1627,
    10296,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204030002",
    "Bakso Ikan/Moluska/Krustase/Ekinodermata (Kering)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1628,
    10750,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204030002",
    "Bakso Ikan/Moluska/Krustase/Ekinodermata (Kering)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1629,
    10292,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204030003",
    "Kue Ikan/Kamaboko/Fish Cake (goreng atau panggang)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1630,
    10296,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204030003",
    "Kue Ikan/Kamaboko/Fish Cake (goreng atau panggang)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1631,
    10750,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204030003",
    "Kue Ikan/Kamaboko/Fish Cake (goreng atau panggang)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1632,
    10750,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204030004",
    "Sambal Goreng Udang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1633,
    10750,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204030005",
    "Sambal Goreng Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1634,
    10794,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090204030006",
    "Keripik3 Kulit Ikan Goreng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1635,
    10211,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090204030007",
    "Abon Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1636,
    10219,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090204030007",
    "Abon Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1637,
    10216,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090204030008",
    "Pempek Ikan (Goreng atau Panggang)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1638,
    10296,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090204030008",
    "Pempek Ikan (Goreng atau Panggang)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1639,
    10292,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090204030009",
    "Ikan Renyah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1640,
    10750,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090204030009",
    "Ikan Renyah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1641,
    10794,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090204030010",
    "Keripik3 Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1642,
    10794,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090204030011",
    "Keripik3 Belut",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1643,
    10750,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090204030012",
    "Tortila Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1644,
    10750,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204030013",
    "Rendang Ikan Tuna",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1645,
    10750,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090204030014",
    "Rendang Kerang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1646,
    10212,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000001",
    "Ikan Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1647,
    10212,
    "0908",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 09)",
    "090205000001",
    "Ikan Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1648,
    10212,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000001",
    "Ikan Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1649,
    10212,
    "0908",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 09)",
    "090205000001",
    "Ikan Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1650,
    10292,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000001",
    "Ikan Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1651,
    10292,
    "0908",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 09)",
    "090205000001",
    "Ikan Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1652,
    10292,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000001",
    "Ikan Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1653,
    10292,
    "0908",
    "Pangan Olahan Daging, Ikan, Unggas dan produk hewani beku lainnya (Kategori 09)",
    "090205000001",
    "Ikan Asap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1654,
    10212,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000002",
    "Ikan Kayu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1655,
    10292,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000002",
    "Ikan Kayu",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1656,
    10211,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000003",
    "Ikan Kering (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1657,
    10291,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000003",
    "Ikan Kering (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1658,
    82920,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000003",
    "Ikan Kering (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1659,
    10211,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000004",
    "Ikan Asin Kering (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1660,
    10291,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000004",
    "Ikan Asin Kering (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1661,
    10211,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000005",
    "Teri Asin Kering (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1662,
    10291,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000005",
    "Teri Asin Kering (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1663,
    10211,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000006",
    "Teri Nasi Setengah Kering",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1664,
    10291,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000006",
    "Teri Nasi Setengah Kering",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1665,
    10794,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000007",
    "Kerupuk4 Ikan, Udang, Moluska (Mentah)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1666,
    10794,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000008",
    "Kerupuk4 Kulit Ikan Mentah",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1667,
    10750,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000009",
    "Dendeng Ikan (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1668,
    10291,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000010",
    "Belut Kering",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1669,
    10291,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000011",
    "Udang Kering Tanpa Kulit (Ebi) (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1670,
    10750,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000012",
    "Ebi Bubuk (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1671,
    10291,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000013",
    "Cumi dan Sotong Kering (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1672,
    10291,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000014",
    "Ubur-Ubur Asin (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1673,
    10291,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000015",
    "Teripang Kering (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1674,
    10211,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000016",
    "Daging Kerang Abalon Kering (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1675,
    10291,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000016",
    "Daging Kerang Abalon Kering (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1676,
    10211,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000017",
    "Sirip Hiu Kering",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1677,
    10291,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000017",
    "Sirip Hiu Kering",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1678,
    10211,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000018",
    "Telur Ikan Terbang Kering (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1679,
    10291,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000018",
    "Telur Ikan Terbang Kering (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1680,
    10295,
    "0903",
    "Ikan dan produk perikanan yang difermentasi, termasuk moluska, krustase dan ekinodermata",
    "090205000019",
    "Terasi Udang (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1681,
    10779,
    "0903",
    "Ikan dan produk perikanan yang difermentasi, termasuk moluska, krustase dan ekinodermata",
    "090205000019",
    "Terasi Udang (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1682,
    10779,
    "0903",
    "Ikan dan produk perikanan yang difermentasi, termasuk moluska, krustase dan ekinodermata",
    "090205000020",
    "Pasta Ikan (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1683,
    10291,
    "0903",
    "Ikan dan produk perikanan yang difermentasi, termasuk moluska, krustase dan ekinodermata",
    "090205000021",
    "Ikan Asin Jambal Roti (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1684,
    10215,
    "0903",
    "Ikan dan produk perikanan yang difermentasi, termasuk moluska, krustase dan ekinodermata",
    "090205000022",
    "Ikan Peda (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1685,
    10215,
    "0903",
    "Ikan dan produk perikanan yang difermentasi, termasuk moluska, krustase dan ekinodermata",
    "090205000023",
    "Bekasam/Bekasang (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1686,
    10295,
    "0903",
    "Ikan dan produk perikanan yang difermentasi, termasuk moluska, krustase dan ekinodermata",
    "090205000023",
    "Bekasam/Bekasang (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1687,
    10215,
    "0903",
    "Ikan dan produk perikanan yang difermentasi, termasuk moluska, krustase dan ekinodermata",
    "090205000024",
    "Rusip (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1688,
    10295,
    "0903",
    "Ikan dan produk perikanan yang difermentasi, termasuk moluska, krustase dan ekinodermata",
    "090205000024",
    "Rusip (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1689,
    10215,
    "0903",
    "Ikan dan produk perikanan yang difermentasi, termasuk moluska, krustase dan ekinodermata",
    "090205000025",
    "Masin (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1690,
    10295,
    "0903",
    "Ikan dan produk perikanan yang difermentasi, termasuk moluska, krustase dan ekinodermata",
    "090205000025",
    "Masin (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1691,
    10299,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000026",
    "Tepung Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1692,
    10295,
    "0903",
    "Ikan dan produk perikanan yang difermentasi, termasuk moluska, krustase dan ekinodermata",
    "090205000027",
    "Pasta Gonad Bulu Babi (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1693,
    10291,
    "0904",
    "Pangan kategori 9 risiko rendah lainnya",
    "090205000028",
    "Rebon (dengan proses pemasakan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1694,
    10750,
    "0901",
    "Ikan dan produk perikanan termasuk moluska, krustase dan ekinodermata semi awet",
    "090301000001",
    "Rollmops",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1695,
    10750,
    "0901",
    "Ikan dan produk perikanan termasuk moluska, krustase dan ekinodermata semi awet",
    "090301000002",
    "Gel Ikan (Sea Gel)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1696,
    10750,
    "0901",
    "Ikan dan produk perikanan termasuk moluska, krustase dan ekinodermata semi awet",
    "090301000003",
    "Aspic Ikan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1697,
    10750,
    "0901",
    "Ikan dan produk perikanan termasuk moluska, krustase dan ekinodermata semi awet",
    "090302000001",
    "Ikan dan Produk Perikanan Termasuk Moluska, Krustase, dan Ekinodermata yang Diolah Menjadi Pikel dan/atau Direndam Dalam Larutan Garam",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1698,
    10779,
    "0901",
    "Ikan dan produk perikanan termasuk moluska, krustase dan ekinodermata semi awet",
    "090303000001",
    "Caviar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1699,
    10779,
    "0901",
    "Ikan dan produk perikanan termasuk moluska, krustase dan ekinodermata semi awet",
    "090303000002",
    "Red Caviar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1700,
    10779,
    "0901",
    "Ikan dan produk perikanan termasuk moluska, krustase dan ekinodermata semi awet",
    "090303000003",
    "Golden Caviar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1701,
    10779,
    "0901",
    "Ikan dan produk perikanan termasuk moluska, krustase dan ekinodermata semi awet",
    "090303000004",
    "Pengganti Kaviar (Caviar Substitute)",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1702,
    10779,
    "0901",
    "Ikan dan produk perikanan termasuk moluska, krustase dan ekinodermata semi awet",
    "090303000005",
    "Telur Ikan Dengan Penambahan Bahan Pangan Lain",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1703,
    10779,
    "0901",
    "Ikan dan produk perikanan termasuk moluska, krustase dan ekinodermata semi awet",
    "090304000001",
    "Petis Udang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1704,
    10216,
    "0906",
    "Pangan olahan Daging, Ikan, Unggas dan pangan olahan lain yang disterilisasi setelah dikemas (Kategori 09)",
    "090400000001",
    "Sosis Ikan/Moluska/Krustase/Ekinodermata Siap Santap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1705,
    10296,
    "0906",
    "Pangan olahan Daging, Ikan, Unggas dan pangan olahan lain yang disterilisasi setelah dikemas (Kategori 09)",
    "090400000001",
    "Sosis Ikan/Moluska/Krustase/Ekinodermata Siap Santap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1706,
    10750,
    "0906",
    "Pangan olahan Daging, Ikan, Unggas dan pangan olahan lain yang disterilisasi setelah dikemas (Kategori 09)",
    "090400000001",
    "Sosis Ikan/Moluska/Krustase/Ekinodermata Siap Santap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1707,
    10216,
    "0906",
    "Pangan olahan Daging, Ikan, Unggas dan pangan olahan lain yang disterilisasi setelah dikemas (Kategori 09)",
    "090400000002",
    "Otak-Otak Ikan/Moluska/Krustase/Ekinodermata Siap Santap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1708,
    10296,
    "0906",
    "Pangan olahan Daging, Ikan, Unggas dan pangan olahan lain yang disterilisasi setelah dikemas (Kategori 09)",
    "090400000002",
    "Otak-Otak Ikan/Moluska/Krustase/Ekinodermata Siap Santap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1709,
    10750,
    "0906",
    "Pangan olahan Daging, Ikan, Unggas dan pangan olahan lain yang disterilisasi setelah dikemas (Kategori 09)",
    "090400000002",
    "Otak-Otak Ikan/Moluska/Krustase/Ekinodermata Siap Santap",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1710,
    10221,
    "0906",
    "Pangan olahan Daging, Ikan, Unggas dan pangan olahan lain yang disterilisasi setelah dikemas (Kategori 09)",
    "090400000003",
    "Tuna dalam Kemasan Kaleng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1711,
    10222,
    "0906",
    "Pangan olahan Daging, Ikan, Unggas dan pangan olahan lain yang disterilisasi setelah dikemas (Kategori 09)",
    "090400000004",
    "Udang Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1712,
    10221,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000005",
    "Kerang Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1713,
    10750,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000005",
    "Kerang Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1714,
    10221,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000006",
    "Daging Rajungan Sterilisasi dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1715,
    10221,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000007",
    "Daging Rajungan Pasteurisasi Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1716,
    10221,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090400000007",
    "Daging Rajungan Pasteurisasi Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1717,
    10221,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000007",
    "Daging Rajungan Pasteurisasi Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1718,
    10221,
    "0905",
    "Pangan kategori 9 risiko sedang lainnya",
    "090400000007",
    "Daging Rajungan Pasteurisasi Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1719,
    10221,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000008",
    "Tiram Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1720,
    10750,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000008",
    "Tiram Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1721,
    10221,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000009",
    "Salmon Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1722,
    10221,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000010",
    "Sarden Dan Makerel Dalam Kemasan Kaleng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1723,
    10221,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000011",
    "Bekicot Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1724,
    10221,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000012",
    "Cumi-cumi Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1725,
    10221,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000013",
    "Sotong Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1726,
    10221,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000014",
    "Ikan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1727,
    10221,
    "0906",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000014",
    "Ikan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1728,
    10221,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000014",
    "Ikan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1729,
    10221,
    "0906",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000014",
    "Ikan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1730,
    10750,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000014",
    "Ikan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1731,
    10750,
    "0906",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000014",
    "Ikan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1732,
    10750,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000014",
    "Ikan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1733,
    10750,
    "0906",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000014",
    "Ikan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1734,
    10221,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000015",
    "Olahan Ikan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1735,
    10750,
    "0902",
    "Ikan dan Produk Perikanan yang Diawetkan, Termasuk Ikan dan Produk Perikanan yang Dikalengkan atau Difermentasi, Termasuk Moluska, Krustase dan Ekinodermata",
    "090400000015",
    "Olahan Ikan Dalam Kemasan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1736,
    10221,
    "0906",
    "Pangan olahan Daging, Ikan, Unggas dan pangan olahan lain yang disterilisasi setelah dikemas (Kategori 09)",
    "090400000016",
    "Tuna dalam Kemasan Selain Kaleng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1737,
    10221,
    "0906",
    "Pangan olahan Daging, Ikan, Unggas dan pangan olahan lain yang disterilisasi setelah dikemas (Kategori 09)",
    "090400000017",
    "Sarden Dan Makerel Dalam Kemasan Selain Kaleng",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1738,
    10799,
    1005,
    "Telur segar",
    100100000001,
    "Telur Segar",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1739,
    10799,
    1003,
    "Produk Telur Cair",
    100201000001,
    "Telur Cair Utuh",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1740,
    10799,
    1003,
    "Produk Telur Cair",
    100201000002,
    "Putih Telur Cair",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1741,
    10799,
    1003,
    "Produk Telur Cair",
    100201000003,
    "Kuning Telur Cair",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1742,
    10799,
    1003,
    "Produk Telur Cair",
    100201000004,
    "Telur Cair Campuran /Premiks Telur Cair",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1743,
    10799,
    1002,
    "Produk Telur Beku",
    100202000001,
    "Telur Beku Utuh",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1744,
    10799,
    1002,
    "Produk Telur Beku",
    100202000002,
    "Putih Telur Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1745,
    10799,
    1002,
    "Produk Telur Beku",
    100202000003,
    "Kuning Telur Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1746,
    10799,
    1002,
    "Produk Telur Beku",
    100202000004,
    "Telur Campuran Beku/Premiks Telur Beku",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1747,
    10799,
    1004,
    "Produk-Produk Telur yang Dikeringkan dan/atau Dipanaskan Hingga Terkoagulasi",
    100203000001,
    "Tepung Telur Utuh",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1748,
    10799,
    1004,
    "Produk-Produk Telur yang Dikeringkan dan/atau Dipanaskan Hingga Terkoagulasi",
    100203000002,
    "Tepung Putih Telur",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1749,
    10799,
    1004,
    "Produk-Produk Telur yang Dikeringkan dan/atau Dipanaskan Hingga Terkoagulasi",
    100203000003,
    "Tepung Kuning Telur",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1750,
    10799,
    1004,
    "Produk-Produk Telur yang Dikeringkan dan/atau Dipanaskan Hingga Terkoagulasi",
    100203000004,
    "Telur Matang/Setengah Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1751,
    10799,
    1004,
    "Produk-Produk Telur yang Dikeringkan dan/atau Dipanaskan Hingga Terkoagulasi",
    100203000005,
    "Telur Pindang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1752,
    10799,
    1004,
    "Produk-Produk Telur yang Dikeringkan dan/atau Dipanaskan Hingga Terkoagulasi",
    100203000006,
    "Tepung Telur Campuran/Premiks Tepung Telur",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1753,
    10799,
    1004,
    "Produk-Produk Telur yang Dikeringkan dan/atau Dipanaskan Hingga Terkoagulasi",
    100203000007,
    "Rendang Telur",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1754,
    10799,
    1006,
    "\"Telur yang Diawetkan, Termasuk Produk Tradisional Telur Yang Diawetkan, Termasuk Dengan Cara Dibasakan, Diasinkan dan Dikalengkan\"",
    100300000001,
    "Telur Asin Mentah",
    500000,
    400000,
    250000,
    "Nonaktif",
  ],
  [
    1755,
    10799,
    1006,
    "\"Telur yang Diawetkan, Termasuk Produk Tradisional Telur Yang Diawetkan, Termasuk Dengan Cara Dibasakan, Diasinkan dan Dikalengkan\"",
    100300000002,
    "Telur Asin Matang",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1756,
    10799,
    1006,
    "\"Telur yang Diawetkan, Termasuk Produk Tradisional Telur Yang Diawetkan, Termasuk Dengan Cara Dibasakan, Diasinkan dan Dikalengkan\"",
    100300000003,
    "Telur Olahan Steril",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1757,
    10799,
    1006,
    "\"Telur yang Diawetkan, Termasuk Produk Tradisional Telur Yang Diawetkan, Termasuk Dengan Cara Dibasakan, Diasinkan dan Dikalengkan\"",
    100300000004,
    "Telur Hitam (Pidan/Pitan/Bitan)",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1758,
    10799,
    1006,
    "\"Telur yang Diawetkan, Termasuk Produk Tradisional Telur Yang Diawetkan, Termasuk Dengan Cara Dibasakan, Diasinkan dan Dikalengkan\"",
    100300000005,
    "Hulidan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1759,
    10799,
    1006,
    "\"Telur yang Diawetkan, Termasuk Produk Tradisional Telur Yang Diawetkan, Termasuk Dengan Cara Dibasakan, Diasinkan dan Dikalengkan\"",
    100300000006,
    "Dsaudan",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1760,
    10799,
    1001,
    "Makanan Pencuci Mulut Berbahan Dasar Telur (Misalnya Custard)",
    100400000001,
    "Selai Kaya",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1761,
    10799,
    1001,
    "Makanan Pencuci Mulut Berbahan Dasar Telur (Misalnya Custard)",
    100400000002,
    "Custard",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1762,
    10799,
    1001,
    "Makanan Pencuci Mulut Berbahan Dasar Telur (Misalnya Custard)",
    100400000003,
    "Tepung Custard",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1763,
    10750,
    1001,
    "Makanan Pencuci Mulut Berbahan Dasar Telur (Misalnya Custard)",
    100400000004,
    "Martabak Telur",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1764,
    10792,
    1001,
    "Makanan Pencuci Mulut Berbahan Dasar Telur (Misalnya Custard)",
    100400000004,
    "Martabak Telur",
    500000,
    400000,
    250000,
    "Aktif",
  ],
  [
    1765,
    10721,
    1111,
    "Gula dan Pemanis",
    110101000001,
    "Gula Kristal Rafinasi",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1766,
    10623,
    1111,
    "Gula dan Pemanis",
    110101000002,
    "Dekstrosa Anhidrat",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1767,
    10635,
    1111,
    "Gula dan Pemanis",
    110101000002,
    "Dekstrosa Anhidrat",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1768,
    10623,
    1111,
    "Gula dan Pemanis",
    110101000003,
    "Dekstrosa Monohidrat",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1769,
    10635,
    1111,
    "Gula dan Pemanis",
    110101000003,
    "Dekstrosa Monohidrat",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1770,
    10623,
    1111,
    "Gula dan Pemanis",
    110101000004,
    "Fruktosa",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1771,
    10635,
    1111,
    "Gula dan Pemanis",
    110101000004,
    "Fruktosa",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1772,
    82920,
    1111,
    "Gula dan Pemanis",
    110101000004,
    "Fruktosa",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1773,
    10729,
    1111,
    "Gula dan Pemanis",
    110102000001,
    "Gula Serbuk (Icing Sugar) ",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1774,
    82920,
    1111,
    "Gula dan Pemanis",
    110102000001,
    "Gula Serbuk (Icing Sugar) ",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1775,
    10623,
    1111,
    "Gula dan Pemanis",
    110102000002,
    "Dektrosa Serbuk (Icing Dextrose)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1776,
    10635,
    1111,
    "Gula dan Pemanis",
    110102000002,
    "Dektrosa Serbuk (Icing Dextrose)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1777,
    10729,
    1111,
    "Gula dan Pemanis",
    110103000001,
    "Gula Putih Lembab atau Soft White Sugar",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1778,
    10722,
    1111,
    "Gula dan Pemanis",
    110103000002,
    "Gula Merah Lembab atau Soft Brown Sugar ",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1779,
    10729,
    1111,
    "Gula dan Pemanis",
    110103000003,
    "Gula Tebu Mentah",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1780,
    82920,
    1111,
    "Gula dan Pemanis",
    110103000003,
    "Gula Tebu Mentah",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1781,
    10623,
    1114,
    "Sirup Glukosa",
    110103000004,
    "Glukosa",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1782,
    10635,
    1114,
    "Sirup Glukosa",
    110103000004,
    "Glukosa",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1783,
    10723,
    1114,
    "Sirup Glukosa",
    110103010001,
    "Sirup Glukosa Kering ",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1784,
    10635,
    1111,
    "Gula dan Pemanis",
    110103010002,
    "Sirup Jagung Terfermentasi Kering",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1785,
    10635,
    1114,
    "Sirup Glukosa",
    110103010002,
    "Sirup Jagung Terfermentasi Kering",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1786,
    10723,
    1111,
    "Gula dan Pemanis",
    110103010002,
    "Sirup Jagung Terfermentasi Kering",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1787,
    10723,
    1114,
    "Sirup Glukosa",
    110103010002,
    "Sirup Jagung Terfermentasi Kering",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1788,
    10723,
    1114,
    "Sirup Glukosa",
    110103020001,
    "Sirup glukosa ",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1789,
    10623,
    1107,
    "Laktosa",
    110104000001,
    "Laktosa",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1790,
    10721,
    1111,
    "Gula dan Pemanis",
    110105000001,
    "Gula Kristal Putih atau Gula Pasir",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1791,
    82920,
    1111,
    "Gula dan Pemanis",
    110105000001,
    "Gula Kristal Putih atau Gula Pasir",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1792,
    10722,
    1111,
    "Gula dan Pemanis",
    110200000001,
    "Gula Palma Cetak",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1793,
    10729,
    1111,
    "Gula dan Pemanis",
    110200000001,
    "Gula Palma Cetak",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1794,
    82920,
    1111,
    "Gula dan Pemanis",
    110200000001,
    "Gula Palma Cetak",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1795,
    10722,
    1111,
    "Gula dan Pemanis",
    110200000002,
    "Gula Palma Serbuk (Gula Semut)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1796,
    10729,
    1111,
    "Gula dan Pemanis",
    110200000002,
    "Gula Palma Serbuk (Gula Semut)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1797,
    82920,
    1111,
    "Gula dan Pemanis",
    110200000002,
    "Gula Palma Serbuk (Gula Semut)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1798,
    10722,
    1111,
    "Gula dan Pemanis",
    110200000003,
    "Gula Merah Tebu/Saka",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1799,
    82920,
    1111,
    "Gula dan Pemanis",
    110200000003,
    "Gula Merah Tebu/Saka",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1800,
    10722,
    1111,
    "Gula dan Pemanis",
    110200000004,
    "Gula Coklat Sukrosa",
    150000,
    100000,
    400000,
    "Aktif",
  ],
  [
    1801,
    10729,
    1111,
    "Gula dan Pemanis",
    110200000004,
    "Gula Coklat Sukrosa",
    150000,
    100000,
    400000,
    "Aktif",
  ],
  [
    1802,
    82920,
    1111,
    "Gula dan Pemanis",
    110200000004,
    "Gula Coklat Sukrosa",
    150000,
    100000,
    400000,
    "Aktif",
  ],
  [
    1803,
    10729,
    1111,
    "Gula dan Pemanis",
    110200000005,
    "Gula Serbuk Campuran",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1804,
    10729,
    1111,
    "Gula dan Pemanis",
    110300000001,
    "Tetes Tebu atau Molases",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1805,
    10729,
    1111,
    "Gula dan Pemanis",
    110300000002,
    "Gula Invert",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1806,
    10723,
    1111,
    "Gula dan Pemanis",
    110300000003,
    "Sirup Fruktosa (High Fructose Syrup/HFS)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1807,
    82920,
    1111,
    "Gula dan Pemanis",
    110300000003,
    "Sirup Fruktosa (High Fructose Syrup/HFS)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1808,
    10723,
    1111,
    "Gula dan Pemanis",
    110300000004,
    "Sirup Fruktosa-Glukosa (High Fructose Glucose Syrup)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1809,
    10635,
    1111,
    "Gula dan Pemanis",
    110300000005,
    "Sirup Jagung",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1810,
    10635,
    1111,
    "Gula dan Pemanis",
    110300000005,
    "Sirup Jagung",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1811,
    82920,
    1111,
    "Gula dan Pemanis",
    110300000005,
    "Sirup Jagung",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1812,
    82920,
    1111,
    "Gula dan Pemanis",
    110300000005,
    "Sirup Jagung",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1813,
    10723,
    1111,
    "Gula dan Pemanis",
    110300000006,
    "Sirup Tebu (Cane Syrup)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1814,
    10723,
    1111,
    "Gula dan Pemanis",
    110300000007,
    "Gula Sukrosa Cair ",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1815,
    10729,
    1111,
    "Gula dan Pemanis",
    110400000001,
    "Sirup Maple (Maple Syrup)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1816,
    10729,
    1111,
    "Gula dan Pemanis",
    110400000002,
    "Sirup Sorgum (Shorgum Syrup)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1817,
    10723,
    1111,
    "Gula dan Pemanis",
    110400000003,
    "Sirup/Sirup Meja (Table Syrup)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1818,
    10729,
    1111,
    "Gula dan Pemanis",
    110400000003,
    "Sirup/Sirup Meja (Table Syrup)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1819,
    10729,
    1111,
    "Gula dan Pemanis",
    110400000004,
    "Gula Hias ",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1820,
    82920,
    1111,
    "Gula dan Pemanis",
    110400000004,
    "Gula Hias ",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1821,
    10729,
    1111,
    "Gula dan Pemanis",
    110400000005,
    "Sirup Agave",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1822,
    10722,
    1111,
    "Gula dan Pemanis",
    110400000006,
    "Gula Merah Cair",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1823,
    10722,
    1111,
    "Gula dan Pemanis",
    110400000007,
    "Gula Palma Cair",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1824,
    10729,
    1111,
    "Gula dan Pemanis",
    110400000007,
    "Gula Palma Cair",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1825,
    "01493",
    1109,
    "Madu",
    110500000001,
    "Madu",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1826,
    "01493",
    1109,
    "Madu",
    110500000001,
    "Madu",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1827,
    10779,
    1109,
    "Madu",
    110500000001,
    "Madu",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1828,
    82920,
    1109,
    "Madu",
    110500000001,
    "Madu",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1829,
    10779,
    1113,
    "Madu Bubuk",
    110500000002,
    "Madu Serbuk",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1830,
    10779,
    1109,
    "Madu",
    110500000003,
    "Madu dengan penambahan bahan lain",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1831,
    10779,
    1109,
    "Madu",
    110500000003,
    "Madu dengan penambahan bahan lain",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1832,
    10623,
    1111,
    "Gula dan Pemanis",
    110600000001,
    "Sediaan Pemanis Alami",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1833,
    10623,
    1111,
    "Gula dan Pemanis",
    110600000002,
    "Sediaan Pemanis Alami dan Buatan",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1834,
    82920,
    1111,
    "Gula dan Pemanis",
    110600000002,
    "Sediaan Pemanis Alami dan Buatan",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1835,
    10623,
    1111,
    "Gula dan Pemanis",
    110600000003,
    "Sediaan Pemanis Buatan",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1836,
    10774,
    1204,
    "Garam",
    120101000001,
    "Garam Konsumsi Beriodium",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1837,
    82920,
    1204,
    "Garam",
    120101000001,
    "Garam Konsumsi Beriodium",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1838,
    10774,
    1204,
    "Garam",
    120101000002,
    "Garam Konsumsi Cair Beriodium",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1839,
    10774,
    1204,
    "Garam",
    120101000003,
    "Garam Gurih",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1840,
    10774,
    1204,
    "Garam",
    120101000004,
    "Garam Industri Aneka Pangan",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1841,
    10774,
    1204,
    "Garam",
    120101000005,
    "Garam Diet",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1842,
    10774,
    1204,
    "Garam",
    120101000006,
    "Garam Kurang Natrium",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1843,
    10774,
    1204,
    "Garam",
    120101000007,
    "Garam Bahan Baku Untuk Garam Konsumsi Beriodium",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1844,
    10774,
    1204,
    "Garam",
    120101000008,
    "Garam Campuran",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1845,
    10774,
    1204,
    "Garam",
    120101000009,
    "Garam Berbumbu",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1846,
    10772,
    1212,
    "Pengganti Garam",
    120102000001,
    "Pengganti Garam ",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1847,
    10772,
    1217,
    "Rempah",
    120201000001,
    "Rempah Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1848,
    10772,
    1217,
    "Rempah",
    120201000002,
    "Adas, Adas Pedas, Fennel, Jinten Manis",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1849,
    10772,
    1217,
    "Rempah",
    120201000003,
    "Adas Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1850,
    10772,
    1217,
    "Rempah",
    120201000004,
    "Akar Chicory",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1851,
    10772,
    1217,
    "Rempah",
    120201000005,
    "Andaliman",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1852,
    10772,
    1217,
    "Rempah",
    120201000006,
    "Asam Gelugur",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1853,
    10772,
    1217,
    "Rempah",
    120201000007,
    "Asam Sunti",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1854,
    10772,
    1217,
    "Rempah",
    120201000008,
    "Asam Jawa",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1855,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000009,
    "Asam Kandis",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1856,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000010,
    "Allspice/Pimento",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1857,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000011,
    "Basil",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1858,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000012,
    "Ruku-Ruku",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1859,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000013,
    "Kemangi",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1860,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000014,
    "Basilla",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1861,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000015,
    "Bay Leaves",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1862,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000016,
    "Bawang Putih",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1863,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000017,
    "Bawang Merah (Shallot)",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1864,
    82920,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000017,
    "Bawang Merah (Shallot)",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1865,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000018,
    "Bawang Batak/Lokio",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1866,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000019,
    "Bawang Daun",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1867,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000020,
    "Biji Seledri",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1868,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000021,
    "Daun Seledri",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1869,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000022,
    "Biji Sawi/Biji Mustard",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1870,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000023,
    "Biji Sawi Bubuk atau Biji Mustard Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1871,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000024,
    "Cabe Jawa",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1872,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000025,
    "Cabe Segar",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1873,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000026,
    "Bubur Cabe",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1874,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000027,
    "Cabe Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1875,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000028,
    "Kucai/Chives",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1876,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000029,
    "Cengkeh",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1877,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000030,
    "Cengkeh Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1878,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000031,
    "Biji Dill (Dill Seed), Adas Manis, Adas Sowa, Adas Cina, Ender",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1879,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000032,
    "Dill Weed",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1880,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000033,
    "Daun Jeruk Purut (Kaffir lime)",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1881,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000034,
    "Daun Pandan",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1882,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000035,
    "Daun Peterseli",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1883,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000036,
    "Daun Salam",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1884,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000037,
    "Daun Sembung",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1885,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000038,
    "Daun Suji",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1886,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000039,
    "Fenugreek, Kelabat, Kelabet, Klabat",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1887,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000040,
    "Fenugreek Bubuk, Kelabat Bubuk, Kelabet Bubuk, Klabat Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1888,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000041,
    "Fuli Kering (Bunga Pala)",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1889,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000042,
    "Fuli Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1890,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000043,
    "Jahe Segar",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1891,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000044,
    "Jahe Kering",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1892,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000045,
    "Bubur Jahe",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1893,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000046,
    "Jahe Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1894,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000047,
    "Jintan/Caraway",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1895,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000048,
    "Jintan Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1896,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000049,
    "Jintan Manis",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1897,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000050,
    "Jintan Hitam",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1898,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000051,
    "Jintan Hitam Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1899,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000052,
    "Jintan Putih, Cumin",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1900,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000053,
    "Jintan Putih Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1901,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000054,
    "Kapulaga",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1902,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000055,
    "Biji Kapulaga",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1903,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000056,
    "Kapulaga Lokal",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1904,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000057,
    "Kapulaga (Cardamom) Amomum",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1905,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000058,
    "Biji Kapulaga (Cardamom) Amomum",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1906,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000059,
    "Kapulaga Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1907,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000060,
    "Kapulaga (Cardamom) Amomum Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1908,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000061,
    "Kayu Manis",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1909,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000062,
    "Kayu Manis Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1910,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000063,
    "Kemiri",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1911,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000064,
    "Kencur",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1912,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000065,
    "Kencur Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1913,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000066,
    "Ketumbar",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1914,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000067,
    "Daun Ketumbar",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1915,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000068,
    "Ketumbar Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1916,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000069,
    "Lempuyang",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1917,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000070,
    "Picung",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1918,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000071,
    "Kluwek",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1919,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000072,
    "Kunyit",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1920,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000073,
    "Kunyit Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1921,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000074,
    "Lada Hitam",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1922,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000075,
    "Lada Hitam Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1923,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000076,
    "Lada Putih",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1924,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000077,
    "Lada Putih Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1925,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000078,
    "Lada Bubuk Campuran",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1926,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000079,
    "Lengkuas/Laos",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1927,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000080,
    "Lengkuas/Laos Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1928,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000081,
    "Kecombrang/Sambuang/Kincung/Honje",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1929,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000082,
    "Marjoram",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1930,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000083,
    "Mesoyi",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1931,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000084,
    "Mint",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1932,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000085,
    "Onion/Bawang Bombay",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1933,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000086,
    "Oregano",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1934,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000087,
    "Pala",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1935,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000088,
    "Pala Untuk Destilasi",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1936,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000089,
    "Pala Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1937,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000090,
    "Parsley",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1938,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000091,
    "Paprika Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1939,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000092,
    "Sweet Paprika Bubuk",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1940,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000093,
    "Rosemari",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1941,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000094,
    "Sereh",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1942,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000095,
    "Pekak/Bunga Lawang/Star Anise",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1943,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000096,
    "Temu Kunci",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1944,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000097,
    "Thymi/Thyme",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1945,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000098,
    "Wasabi",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1946,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000099,
    "Wijen",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1947,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000100,
    "Herba dan Rempah Olahan",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1948,
    10772,
    1217,
    "Rempah",
    120201000100,
    "Herba dan Rempah Olahan",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1949,
    10772,
    1209,
    "Pangan kategori 12 risiko rendah lainnya",
    120201000100,
    "Herba dan Rempah Olahan",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1950,
    10772,
    1217,
    "Rempah",
    120201000100,
    "Herba dan Rempah Olahan",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1951,
    10772,
    1202,
    "Bumbu dan kondimen",
    120202000001,
    "Bubuk Ngohyang",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1952,
    10772,
    1202,
    "Bumbu dan kondimen",
    120202000002,
    "Bumbu Siap Pakai",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1953,
    82920,
    1202,
    "Bumbu dan kondimen",
    120202000002,
    "Bumbu Siap Pakai",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1954,
    10772,
    1202,
    "Bumbu dan kondimen",
    120202000003,
    "Bumbu Ekstrak Daging Sapi",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1955,
    10772,
    1202,
    "Bumbu dan kondimen",
    120202000004,
    "Bumbu Rasa Sapi",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1956,
    10772,
    1202,
    "Bumbu dan kondimen",
    120202000005,
    "Bumbu Ekstrak Daging Ayam",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1957,
    10772,
    1202,
    "Bumbu dan kondimen",
    120202000006,
    "Bumbu Ekstrak Udang",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1958,
    10772,
    1202,
    "Bumbu dan kondimen",
    120202000007,
    "Bumbu Ekstrak Cumi",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1959,
    10772,
    1202,
    "Bumbu dan kondimen",
    120202000008,
    "Bumbu Pasta Ekstrak Daging (Misalnya Bumbu Pasta Ekstrak Daging Sapi dan Daging Ayam)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1960,
    10772,
    1202,
    "Bumbu dan kondimen",
    120202000009,
    "Bumbu Rasa Ikan",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1961,
    10772,
    1202,
    "Bumbu dan kondimen",
    120202000010,
    "Bumbu Rasa Udang",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1962,
    10772,
    1202,
    "Bumbu dan kondimen",
    120202000011,
    "Bumbu Rasa Ayam",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    1963,
    10772,
    1202,
    "Bumbu dan kondimen",
    120202000012,
    "Bubuk/Blok/Kubus/Pasta Ekstrak Ayam/Sapi/Udang/Keju",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1964,
    10772,
    1202,
    "Bumbu dan kondimen",
    120202000013,
    "Ragi Kering (Tidak Aktif)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1965,
    10799,
    1202,
    "Bumbu dan kondimen",
    120202000013,
    "Ragi Kering (Tidak Aktif)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1966,
    10772,
    1202,
    "Bumbu dan kondimen",
    120202000014,
    "Bawang hitam (Black Garlic)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1967,
    82920,
    1202,
    "Bumbu dan kondimen",
    120202000014,
    "Bawang hitam (Black Garlic)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1968,
    10772,
    1202,
    "Bumbu dan kondimen",
    120202000015,
    "Kondimen Berperisa",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1969,
    10772,
    1202,
    "Bumbu dan kondimen",
    120202000016,
    "Bumbu Rasa",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1970,
    10772,
    1202,
    "Bumbu dan kondimen",
    120202000017,
    "Bumbu Tabur",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1971,
    10779,
    1203,
    "Cuka makan",
    120300000001,
    "Cuka Fermentasi (Vinegar)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1972,
    10779,
    1203,
    "Cuka makan",
    120300000002,
    "Cuka Hasil Pengenceran Asam Asetat Glasial",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1973,
    10779,
    1201,
    "Arak masak",
    120300000003,
    "Arak Masak",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1974,
    10772,
    1207,
    "Mustard",
    120400000001,
    "Mustard/Saus Mustard",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1975,
    10799,
    1223,
    "Sup dan kaldu cair yang disterilisasi, Sup dan kaldu cair kecuali yang disterilisasi",
    120501000001,
    "Sari Pati Ayam",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1976,
    10799,
    1222,
    "Sup dan kaldu bubuk",
    120501000002,
    "Kaldu dan Konsome",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1977,
    10799,
    1223,
    "Sup dan kaldu cair yang disterilisasi, Sup dan kaldu cair kecuali yang disterilisasi",
    120501000002,
    "Kaldu dan Konsome",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1978,
    10799,
    1222,
    "Sup dan kaldu bubuk",
    120501000002,
    "Kaldu dan Konsome",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1979,
    10799,
    1223,
    "Sup dan kaldu cair yang disterilisasi, Sup dan kaldu cair kecuali yang disterilisasi",
    120501000002,
    "Kaldu dan Konsome",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1980,
    82920,
    1222,
    "Sup dan kaldu bubuk",
    120501000002,
    "Kaldu dan Konsome",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1981,
    82920,
    1223,
    "Sup dan kaldu cair yang disterilisasi, Sup dan kaldu cair kecuali yang disterilisasi",
    120501000002,
    "Kaldu dan Konsome",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1982,
    82920,
    1222,
    "Sup dan kaldu bubuk",
    120501000002,
    "Kaldu dan Konsome",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1983,
    82920,
    1223,
    "Sup dan kaldu cair yang disterilisasi, Sup dan kaldu cair kecuali yang disterilisasi",
    120501000002,
    "Kaldu dan Konsome",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1984,
    10799,
    1223,
    "Sup dan kaldu cair yang disterilisasi, Sup dan kaldu cair kecuali yang disterilisasi",
    120501000003,
    "Sup Siap Konsumsi",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1985,
    82920,
    1223,
    "Sup dan kaldu cair yang disterilisasi, Sup dan kaldu cair kecuali yang disterilisasi",
    120501000003,
    "Sup Siap Konsumsi",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1986,
    10779,
    1222,
    "Sup dan kaldu bubuk",
    120502000001,
    "Sup Instan",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1987,
    10799,
    1222,
    "Sup dan kaldu bubuk",
    120502000001,
    "Sup Instan",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1988,
    10779,
    1222,
    "Sup dan kaldu bubuk",
    120502000002,
    "Sup Pasta Instan (Misalnya Sup Makaroni Instan)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1989,
    10799,
    1222,
    "Sup dan kaldu bubuk",
    120502000002,
    "Sup Pasta Instan (Misalnya Sup Makaroni Instan)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1990,
    10779,
    1222,
    "Sup dan kaldu bubuk",
    120502000003,
    "Sup Krim Instan",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1991,
    10799,
    1222,
    "Sup dan kaldu bubuk",
    120502000003,
    "Sup Krim Instan",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1992,
    10779,
    1222,
    "Sup dan kaldu bubuk",
    120502000004,
    "Sup Krim Pasta Instan (Misalnya Sup Krim Makaroni Instan)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1993,
    10799,
    1222,
    "Sup dan kaldu bubuk",
    120502000004,
    "Sup Krim Pasta Instan (Misalnya Sup Krim Makaroni Instan)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1994,
    10772,
    1206,
    "Mayonais/salad dressing",
    120601000001,
    "Mayonais, Mayonnaise",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1995,
    10772,
    1206,
    "Mayonais/salad dressing",
    120601000002,
    "Salad Dressing (Misalnya Thousand Island, Blue Cheese, Burger Dressing, Saus Siram Caesar)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1996,
    82920,
    1206,
    "Mayonais/salad dressing",
    120601000002,
    "Salad Dressing (Misalnya Thousand Island, Blue Cheese, Burger Dressing, Saus Siram Caesar)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1997,
    10772,
    1206,
    "Mayonais/salad dressing",
    120601000003,
    "Saus Tar Tar (Tar Tar Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1998,
    10772,
    1206,
    "Mayonais/salad dressing",
    120601000004,
    "French Dressing (Italian Dressing, Greek Dressing, Ranch Style Dressing)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    1999,
    10772,
    1206,
    "Mayonais/salad dressing",
    120601000005,
    "Sandwich Spread",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2000,
    10772,
    1206,
    "Mayonais/salad dressing",
    120601000006,
    "Mayones/Mayonais Tanpa Telur (Eggless Mayonnaise/Eggfree Mayonnaise",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2001,
    10772,
    1218,
    "Sambal",
    120602000001,
    "Sambal",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2002,
    10772,
    1219,
    "Saus bumbu",
    120602000002,
    "Saus Cabe",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2003,
    82920,
    1219,
    "Saus Bumbu",
    120602000002,
    "Saus Cabe",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2004,
    10772,
    1219,
    "Saus bumbu",
    120602000003,
    "Bumbu Kacang",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2005,
    82920,
    1219,
    "Saus Bumbu",
    120602000003,
    "Bumbu Kacang",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2006,
    10772,
    1219,
    "Saus bumbu",
    120602000004,
    "Saus Keju (Cheese Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2007,
    82920,
    1219,
    "Saus Bumbu",
    120602000004,
    "Saus Keju (Cheese Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2008,
    10772,
    1219,
    "Saus bumbu",
    120602000005,
    "Saus Lobak",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2009,
    82920,
    1219,
    "Saus Bumbu",
    120602000005,
    "Saus Lobak",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2010,
    10772,
    1219,
    "Saus bumbu",
    120602000006,
    "Saus Panggang/Saus Barbekue (BBQ Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2011,
    82920,
    1219,
    "Saus Bumbu",
    120602000006,
    "Saus Panggang/Saus Barbekue (BBQ Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2012,
    10772,
    1219,
    "Saus bumbu",
    120602000007,
    "Saus Pizza",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2013,
    82920,
    1219,
    "Saus Bumbu",
    120602000007,
    "Saus Pizza",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2014,
    10772,
    1216,
    "Ragi",
    120602000008,
    "Saus Spagheti (Spaghetti Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2015,
    10772,
    1219,
    "Saus Bumbu",
    120602000008,
    "Saus Spagheti (Spaghetti Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2016,
    82920,
    1216,
    "Ragi",
    120602000008,
    "Saus Spagheti (Spaghetti Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2017,
    82920,
    1219,
    "Saus Bumbu",
    120602000008,
    "Saus Spagheti (Spaghetti Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2018,
    10772,
    1216,
    "Ragi",
    120602000008,
    "Saus Spagheti (Spaghetti Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2019,
    10772,
    1219,
    "Saus Bumbu",
    120602000008,
    "Saus Spagheti (Spaghetti Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2020,
    82920,
    1216,
    "Ragi",
    120602000008,
    "Saus Spagheti (Spaghetti Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2021,
    82920,
    1219,
    "Saus Bumbu",
    120602000008,
    "Saus Spagheti (Spaghetti Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2022,
    82920,
    1219,
    "Saus bumbu",
    120602000009,
    "Saus Tiram",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2023,
    10772,
    1219,
    "Saus Bumbu",
    120602000009,
    "Saus Tiram",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2024,
    10779,
    1219,
    "Saus bumbu",
    120602000009,
    "Saus Tiram",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2025,
    10772,
    1219,
    "Saus Bumbu",
    120602000010,
    "Saus Perendam/Saus Marinasi (Marinated Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2026,
    82920,
    1219,
    "Saus bumbu",
    120602000010,
    "Saus Perendam/Saus Marinasi (Marinated Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2027,
    10772,
    1221,
    "Saus tomat",
    120602000011,
    "Saus Tomat",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2028,
    82920,
    1221,
    "Saus tomat",
    120602000011,
    "Saus Tomat",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2029,
    10772,
    1219,
    "Saus bumbu",
    120602000012,
    "Saus Asam Manis",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2030,
    82920,
    1219,
    "Saus Bumbu",
    120602000012,
    "Saus Asam Manis",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2031,
    10772,
    1205,
    "Kecap selain kedelai",
    120602000013,
    "Kecap Inggris, Saus Worchester",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2032,
    10772,
    1219,
    "Saus bumbu",
    120602000014,
    "Saus Teriyaki",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2033,
    82920,
    1219,
    "Saus Bumbu",
    120602000014,
    "Saus Teriyaki",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2034,
    10772,
    1219,
    "Saus bumbu",
    120602000015,
    "Saus Topping/Saus Siram",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2035,
    82920,
    1219,
    "Saus Bumbu",
    120602000015,
    "Saus Topping/Saus Siram",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2036,
    10772,
    1219,
    "Saus bumbu",
    120602000016,
    "Saus Salsa",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2037,
    82920,
    1219,
    "Saus Bumbu",
    120602000016,
    "Saus Salsa",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2038,
    10772,
    1219,
    "Saus bumbu",
    120602000017,
    "Saus Putih (Berbasis Krim)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2039,
    82920,
    1219,
    "Saus Bumbu",
    120602000017,
    "Saus Putih (Berbasis Krim)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2040,
    10773,
    1205,
    "Kecap selain kedelai",
    120602000018,
    "Kecap Air Kelapa",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    2041,
    82920,
    1205,
    "Kecap selain kedelai",
    120602000018,
    "Kecap Air Kelapa",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    2042,
    10772,
    1205,
    "Kecap selain kedelai",
    120602000019,
    "Kecap Gula Aren",
    200000,
    150000,
    100000,
    "Nonaktif",
  ],
  [
    2043,
    10772,
    1205,
    "Kecap selain kedelai",
    120602000020,
    "Pengganti kecap (non-kedelai)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2044,
    10772,
    1226,
    "Bubuk Untuk Saus dan Gravies",
    120603000001,
    "Campuran Untuk Saus, Gravies, dan Dressing",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2045,
    10215,
    1205,
    "Kecap selain kedelai",
    120604000001,
    "Kecap Ikan",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2046,
    10779,
    1210,
    "Pangan kategori 12 risiko sedang lainnya",
    120604000002,
    "Saus Tiram Bening",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2047,
    10772,
    1213,
    "Produk oles untuk salad",
    120700000001,
    "Olesan/Saus",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2048,
    10779,
    1213,
    "Produk oles untuk salad",
    120700000001,
    "Olesan/Saus",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2049,
    10799,
    1216,
    "Ragi",
    120800000001,
    "Ragi Roti Kering",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2050,
    10799,
    1216,
    "Ragi",
    120800000002,
    "Ragi Roti Semi Kering",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2051,
    10799,
    1216,
    "Ragi",
    120800000003,
    "Ragi Roti Cair (cream yeast)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2052,
    10799,
    1216,
    "Ragi",
    120800000004,
    "Ragi Roti Padat (Compressed Yeast)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2053,
    10799,
    1216,
    "Ragi",
    120800000005,
    "Ragi Tape",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2054,
    10799,
    1216,
    "Ragi",
    120800000006,
    "Ragi Tempe",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2055,
    10799,
    1216,
    "Ragi",
    120800000007,
    "Koji atau Ragi Tauco atau Ragi Kecap",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2056,
    10799,
    1216,
    "Ragi",
    120800000008,
    "Ragi Untuk Minuman Beralkohol",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2057,
    10799,
    1216,
    "Ragi",
    120800000009,
    "Ragi Oncom Merah",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2058,
    10799,
    1216,
    "Ragi",
    120800000010,
    "Ragi Oncom Hitam",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2059,
    10393,
    1211,
    "Pasta kedelai fermentasi",
    120901000001,
    "Miso",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2060,
    10771,
    1211,
    "Pasta kedelai fermentasi",
    120901000001,
    "Miso",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2061,
    10771,
    1211,
    "Pasta kedelai fermentasi",
    120901000002,
    "Tauco",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2062,
    10771,
    1220,
    "Saus kedelai, termasuk kecap",
    120902010001,
    "Kecap Kedelai Asin (Salty Soy Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2063,
    82920,
    1220,
    "Saus kedelai, termasuk kecap",
    120902010001,
    "Kecap Kedelai Asin (Salty Soy Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2064,
    10771,
    1220,
    "Saus kedelai, termasuk kecap",
    120902020001,
    "Kecap Kedelai Asin Non Fermentasi/Hidrolisat",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2065,
    82920,
    1220,
    "Saus kedelai, termasuk kecap",
    120902020001,
    "Kecap Kedelai Asin Non Fermentasi/Hidrolisat",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2066,
    10771,
    1220,
    "Saus kedelai, termasuk kecap",
    120902020002,
    "Saus Protein Nabati Terhidrolisis",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2067,
    82920,
    1220,
    "Saus kedelai, termasuk kecap",
    120902020002,
    "Saus Protein Nabati Terhidrolisis",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2068,
    10771,
    1220,
    "Saus kedelai, termasuk kecap",
    120902030001,
    "Saus Kedelai Lainnya",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2069,
    82920,
    1220,
    "Saus kedelai, termasuk kecap",
    120902030001,
    "Saus Kedelai Lainnya",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2070,
    10771,
    1220,
    "Saus kedelai, termasuk kecap",
    120902030002,
    "Kecap Kedelai Manis (Sweet Soy Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2071,
    82920,
    1220,
    "Saus kedelai, termasuk kecap",
    120902030002,
    "Kecap Kedelai Manis (Sweet Soy Sauce)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2072,
    10771,
    1220,
    "Saus kedelai, termasuk kecap",
    120902030003,
    "Kecap yang Dikeringkan/Bubuk Kecap (Fermented Soy Sauce Powder)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2073,
    82920,
    1220,
    "Saus kedelai, termasuk kecap",
    120902030003,
    "Kecap yang Dikeringkan/Bubuk Kecap (Fermented Soy Sauce Powder)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2074,
    10771,
    1220,
    "Saus kedelai, termasuk kecap",
    120902030004,
    "Kecap Pedas",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2075,
    82920,
    1220,
    "Saus kedelai, termasuk kecap",
    120902030004,
    "Kecap Pedas",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2076,
    10771,
    1220,
    "Saus kedelai, termasuk kecap",
    120902030005,
    "Kecap Bumbu",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2077,
    82920,
    1220,
    "Saus kedelai, termasuk kecap",
    120902030005,
    "Kecap Bumbu",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2078,
    10771,
    1220,
    "Saus kedelai, termasuk kecap",
    120902030006,
    "Saus Campuran Protein Nabati Terhidrolisis",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2079,
    82920,
    1220,
    "Saus kedelai, termasuk kecap",
    120902030006,
    "Saus Campuran Protein Nabati Terhidrolisis",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2080,
    10799,
    1214,
    "Produk protein",
    121000000001,
    "Produk Protein Gandum",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2081,
    10779,
    1215,
    "Produk protein ",
    121000000002,
    "Hydrolised Vegetable Protein (HVP)",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2082,
    10614,
    1208,
    "Olahan gluten ",
    121000000003,
    "Produk Olahan Gluten",
    200000,
    150000,
    100000,
    "Aktif",
  ],
  [
    2083,
    10791,
    1301,
    "Formula bayi bentuk bubuk",
    130101000001,
    "Formula Bayi (Padat)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2084,
    10791,
    1302,
    "Formula bayi bentuk cair (steril)",
    130101000002,
    "Formula Bayi (Cair)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2085,
    10791,
    1303,
    "Formula lanjutan bentuk bubuk",
    130102000001,
    "Formula Lanjutan (Padat)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2086,
    10791,
    1304,
    "Formula lanjutan bentuk cair (steril)",
    130102000002,
    "Formula Lanjutan (Cair)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2087,
    10791,
    1305,
    "Formula pertumbuhan bentuk bubuk",
    130102000003,
    "Formula Pertumbuhan ",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2088,
    10791,
    1306,
    "Formula pertumbuhan bentuk cair (UHT)",
    130102000004,
    "Formula Pertumbuhan (Cair)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2089,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000001,
    "PKMK untuk Pasien Kelainan Metabolik (Inborn Errors of Metabolism)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2090,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000001,
    "PKMK untuk Pasien Kelainan Metabolik (Inborn Errors of Metabolism)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2091,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000002,
    "PKMK untuk Pasien Kelainan Metabolik Isovaleric Acidemia",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2092,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000002,
    "PKMK untuk Pasien Kelainan Metabolik Isovaleric Acidemia",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2093,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000003,
    "PKMK untuk Pasien Kelainan Metabolik Tyrosinemia ",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2094,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000003,
    "PKMK untuk Pasien Kelainan Metabolik Tyrosinemia ",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2095,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000004,
    "PKMK untuk Pasien Kelainan Metabolik Phenylketonuria (PKU) ",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2096,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000004,
    "PKMK untuk Pasien Kelainan Metabolik Phenylketonuria (PKU) ",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2097,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000005,
    "PKMK untuk Pasien Kelainan Metabolik Maple Syrup Urine Disease (MSUD)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2098,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000005,
    "PKMK untuk Pasien Kelainan Metabolik Maple Syrup Urine Disease (MSUD)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2099,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000006,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (0-12 Bulan)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2100,
    10791,
    1322,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk cair (steril)",
    130103000006,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (0-12 Bulan)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2101,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000006,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (0-12 Bulan)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2102,
    10791,
    1322,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk cair (steril)",
    130103000006,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (0-12 Bulan)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2103,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000006,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (0-12 Bulan)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2104,
    10791,
    1322,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk cair (steril)",
    130103000006,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (0-12 Bulan)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2105,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000006,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (0-12 Bulan)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2106,
    10791,
    1322,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk cair (steril)",
    130103000006,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (0-12 Bulan)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2107,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000007,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (di Atas 1 tahun)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2108,
    10791,
    1322,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk cair (steril)",
    130103000007,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (di Atas 1 tahun)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2109,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000007,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (di Atas 1 tahun)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2110,
    10791,
    1322,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk cair (steril)",
    130103000007,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (di Atas 1 tahun)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2111,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000007,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (di Atas 1 tahun)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2112,
    10791,
    1322,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk cair (steril)",
    130103000007,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (di Atas 1 tahun)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2113,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000007,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (di Atas 1 tahun)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2114,
    10791,
    1322,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk cair (steril)",
    130103000007,
    "PKMK untuk Dukungan Nutrisi bagi Anak Berisiko Gagal Tumbuh, Gizi Kurang atau Gizi Buruk (di Atas 1 tahun)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2115,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000008,
    "PKMK untuk Bayi Prematur",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2116,
    10791,
    1322,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk cair (steril)",
    130103000008,
    "PKMK untuk Bayi Prematur",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2117,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000008,
    "PKMK untuk Bayi Prematur",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2118,
    10791,
    1322,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk cair (steril)",
    130103000008,
    "PKMK untuk Bayi Prematur",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2119,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000009,
    "PKMK untuk Pelengkap Gizi Air Susu Ibu (Human Milk Fortifier/HMF)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2120,
    10791,
    1322,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000009,
    "PKMK untuk Pelengkap Gizi Air Susu Ibu (Human Milk Fortifier/HMF)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2121,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000009,
    "PKMK untuk Pelengkap Gizi Air Susu Ibu (Human Milk Fortifier/HMF)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2122,
    10791,
    1322,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000009,
    "PKMK untuk Pelengkap Gizi Air Susu Ibu (Human Milk Fortifier/HMF)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2123,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000010,
    "PKMK untuk Pasien Alergi Protein Susu Sapi (bagi bayi usia 0-6bulan)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2124,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000010,
    "PKMK untuk Pasien Alergi Protein Susu Sapi (bagi bayi usia 0-6bulan)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2125,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000011,
    "PKMK untuk Pasien Alergi Protein Susu Sapi (bagi bayi 6 \x{2013} 12 bulan)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2126,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000011,
    "PKMK untuk Pasien Alergi Protein Susu Sapi (bagi bayi 6 \x{2013} 12 bulan)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2127,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000012,
    "PKMK untuk Pasien Alergi Protein Susu Sapi (bagi anak usia 1-3 tahun)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2128,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000012,
    "PKMK untuk Pasien Alergi Protein Susu Sapi (bagi anak usia 1-3 tahun)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2129,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000013,
    "PKMK untuk Diet Ketogenik Anak",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2130,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000013,
    "PKMK untuk Diet Ketogenik Anak",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2131,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000014,
    "PKMK untuk Bayi Intoleransi Laktosa",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2132,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000014,
    "PKMK untuk Bayi Intoleransi Laktosa",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2133,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000015,
    "PKMK untuk Pasien Malabsorpsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2134,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000015,
    "PKMK untuk Pasien Malabsorpsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2135,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000016,
    "PKMK untuk Pasien Inflammatory Bowel Diseases",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2136,
    10791,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130103000016,
    "PKMK untuk Pasien Inflammatory Bowel Diseases",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2137,
    10791,
    1323,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130103000017,
    "PKMK untuk Pasien Malabsorpsi",
    3000000,
    2500000,
    1500000,
    "Nonaktif",
  ],
  [
    2138,
    10791,
    1311,
    "Pangan diet khusus bayi/ anak (MPASI bentuk ekstrudat)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2139,
    10791,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2140,
    10791,
    1313,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk biskuit)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2141,
    10791,
    1327,
    "Repacking Sekunder MPASI",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2142,
    10791,
    1311,
    "Pangan diet khusus bayi/ anak (MPASI bentuk ekstrudat)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2143,
    10791,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2144,
    10791,
    1313,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk biskuit)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2145,
    10791,
    1327,
    "Repacking Sekunder MPASI",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2146,
    82920,
    1311,
    "Pangan diet khusus bayi/ anak (MPASI bentuk ekstrudat)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2147,
    82920,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2148,
    82920,
    1313,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk biskuit)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2149,
    82920,
    1327,
    "Repacking Sekunder MPASI",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2150,
    82920,
    1311,
    "Pangan diet khusus bayi/ anak (MPASI bentuk ekstrudat)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2151,
    82920,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2152,
    82920,
    1313,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk biskuit)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2153,
    82920,
    1327,
    "Repacking Sekunder MPASI",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2154,
    10791,
    1311,
    "Pangan diet khusus bayi/ anak (MPASI bentuk ekstrudat)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2155,
    10791,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2156,
    10791,
    1313,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk biskuit)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2157,
    10791,
    1327,
    "Repacking Sekunder MPASI",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2158,
    10791,
    1311,
    "Pangan diet khusus bayi/ anak (MPASI bentuk ekstrudat)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2159,
    10791,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2160,
    10791,
    1313,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk biskuit)",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2161,
    10791,
    1327,
    "Repacking Sekunder MPASI",
    130200000001,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2162,
    10791,
    1310,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk bubuk)",
    130200000002,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok - Siap Masak",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2163,
    10791,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000002,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok - Siap Masak",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2164,
    10791,
    1310,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk bubuk)",
    130200000002,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok - Siap Masak",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2165,
    10791,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000002,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok - Siap Masak",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2166,
    10791,
    1310,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk bubuk)",
    130200000002,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok - Siap Masak",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2167,
    10791,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000002,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok - Siap Masak",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2168,
    10791,
    1310,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk bubuk)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2169,
    10791,
    1311,
    "Pangan diet khusus bayi/ anak (MPASI bentuk ekstrudat)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2170,
    10791,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2171,
    10791,
    1313,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk biskuit)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2172,
    10791,
    1310,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk bubuk)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2173,
    10791,
    1311,
    "Pangan diet khusus bayi/ anak (MPASI bentuk ekstrudat)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2174,
    10791,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2175,
    10791,
    1313,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk biskuit)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2176,
    10791,
    1310,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk bubuk)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2177,
    10791,
    1311,
    "Pangan diet khusus bayi/ anak (MPASI bentuk ekstrudat)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2178,
    10791,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2179,
    10791,
    1313,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk biskuit)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2180,
    10791,
    1310,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk bubuk)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2181,
    10791,
    1311,
    "Pangan diet khusus bayi/ anak (MPASI bentuk ekstrudat)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2182,
    10791,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2183,
    10791,
    1313,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk biskuit)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2184,
    10791,
    1310,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk bubuk)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2185,
    10791,
    1311,
    "Pangan diet khusus bayi/ anak (MPASI bentuk ekstrudat)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2186,
    10791,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2187,
    10791,
    1313,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk biskuit)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2188,
    10791,
    1310,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk bubuk)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2189,
    10791,
    1311,
    "Pangan diet khusus bayi/ anak (MPASI bentuk ekstrudat)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2190,
    10791,
    1312,
    "Pangan diet khusus bayi/ anak (MPASI bentuk pasta/puree)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2191,
    10791,
    1313,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk biskuit)",
    130200000003,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Kudapan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2192,
    10791,
    1309,
    "Makanan selingan untuk anak",
    130200000004,
    "Makanan Selingan Untuk Anak",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2193,
    10791,
    1309,
    "Makanan selingan untuk anak",
    130200000004,
    "Makanan Selingan Untuk Anak",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2194,
    10791,
    1310,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk bubuk)",
    130200000005,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi (Bubuk Instan)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2195,
    10791,
    1310,
    "Pangan Diet Khusus Bayi/ Anak (MPASI bentuk bubuk)",
    130200000005,
    "Makanan Pendamping Air Susu Ibu (MP-ASI) Pokok Siap Konsumsi (Bubuk Instan)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2196,
    10799,
    1307,
    "Makanan diet diabetes bentuk bubuk",
    130300000001,
    "PKMK untuk Penyandang Diabetes",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2197,
    10799,
    1308,
    "Makanan diet diabetes bentuk cair (UHT)",
    130300000001,
    "PKMK untuk Penyandang Diabetes",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2198,
    10799,
    1323,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000002,
    "PKMK untuk Pasien Penyakit Ginjal Kronik Pradialisis)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2199,
    10799,
    1324,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk cair (steril)",
    130300000002,
    "PKMK untuk Pasien Penyakit Ginjal Kronik Pradialisis)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2200,
    10799,
    1323,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000003,
    "PKMK untuk Pasien Penyakit Ginjal Kronik (dengan Terapi Dialisis)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2201,
    10799,
    1324,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk cair (steril)",
    130300000003,
    "PKMK untuk Pasien Penyakit Ginjal Kronik (dengan Terapi Dialisis)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2202,
    10799,
    1323,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000004,
    "PKMK untuk Pasien Penyakit Hati Kronik",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2203,
    10799,
    1324,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk cair (steril)",
    130300000004,
    "PKMK untuk Pasien Penyakit Hati Kronik",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2204,
    10799,
    1323,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000005,
    "PKMK untuk Pasien Penyakit Hati Kronik dengan Ensefalopati Hepatik (EH)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2205,
    10799,
    1324,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk cair (steril)",
    130300000005,
    "PKMK untuk Pasien Penyakit Hati Kronik dengan Ensefalopati Hepatik (EH)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2206,
    10799,
    1323,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000006,
    "PKMK untuk Dukungan Nutrisi bagi Pasien Dewasa Malnutrisi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2207,
    10799,
    1324,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk cair (steril)",
    130300000006,
    "PKMK untuk Dukungan Nutrisi bagi Pasien Dewasa Malnutrisi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2208,
    10799,
    1323,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000006,
    "PKMK untuk Dukungan Nutrisi bagi Pasien Dewasa Malnutrisi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2209,
    10799,
    1324,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk cair (steril)",
    130300000006,
    "PKMK untuk Dukungan Nutrisi bagi Pasien Dewasa Malnutrisi",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2210,
    10799,
    1323,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000007,
    "PKMK untuk Diet Ketogenik",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2211,
    10799,
    1323,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000008,
    "PKMK untuk Pasien Kelainan Metabolik (Inborn Errors of Metabolism)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2212,
    10799,
    1323,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000008,
    "PKMK untuk Pasien Kelainan Metabolik (Inborn Errors of Metabolism)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2213,
    10799,
    1321,
    "Pangan olahan untuk keperluan medis khusus bayi/ anak bentuk bubuk",
    130300000009,
    "PKMK untuk Anak (Program Pemerintah)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2214,
    10799,
    1315,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000010,
    "PKMK untuk Dewasa (Program Pemerintah)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2215,
    10799,
    1323,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000010,
    "PKMK untuk Dewasa (Program Pemerintah)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2216,
    10799,
    1315,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000010,
    "PKMK untuk Dewasa (Program Pemerintah)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2217,
    10799,
    1323,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000010,
    "PKMK untuk Dewasa (Program Pemerintah)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2218,
    10799,
    1315,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000010,
    "PKMK untuk Dewasa (Program Pemerintah)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2219,
    10799,
    1323,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000010,
    "PKMK untuk Dewasa (Program Pemerintah)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2220,
    10799,
    1315,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000010,
    "PKMK untuk Dewasa (Program Pemerintah)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2221,
    10799,
    1323,
    "Pangan olahan untuk keperluan medis khusus dewasa bentuk bubuk",
    130300000010,
    "PKMK untuk Dewasa (Program Pemerintah)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2222,
    10799,
    1318,
    "Pangan olahan diet untuk kontrol berat badan bentuk biskuit",
    130400000001,
    "Pangan Diet Khusus untuk Kontrol Berat Badan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2223,
    10799,
    1319,
    "Pangan olahan diet untuk kontrol berat badan bentuk bubuk",
    130400000001,
    "Pangan Diet Khusus untuk Kontrol Berat Badan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2224,
    10799,
    1320,
    "Pangan olahan diet untuk kontrol berat badan bentuk cair (UHT)",
    130400000001,
    "Pangan Diet Khusus untuk Kontrol Berat Badan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2225,
    10799,
    1318,
    "Pangan olahan diet untuk kontrol berat badan bentuk biskuit",
    130400000001,
    "Pangan Diet Khusus untuk Kontrol Berat Badan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2226,
    10799,
    1319,
    "Pangan olahan diet untuk kontrol berat badan bentuk bubuk",
    130400000001,
    "Pangan Diet Khusus untuk Kontrol Berat Badan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2227,
    10799,
    1320,
    "Pangan olahan diet untuk kontrol berat badan bentuk cair (UHT)",
    130400000001,
    "Pangan Diet Khusus untuk Kontrol Berat Badan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2228,
    10799,
    1318,
    "Pangan olahan diet untuk kontrol berat badan bentuk biskuit",
    130400000001,
    "Pangan Diet Khusus untuk Kontrol Berat Badan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2229,
    10799,
    1319,
    "Pangan olahan diet untuk kontrol berat badan bentuk bubuk",
    130400000001,
    "Pangan Diet Khusus untuk Kontrol Berat Badan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2230,
    10799,
    1320,
    "Pangan olahan diet untuk kontrol berat badan bentuk cair (UHT)",
    130400000001,
    "Pangan Diet Khusus untuk Kontrol Berat Badan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2231,
    10799,
    1315,
    "Pangan ibu hamil dan pangan ibu menyusui bentuk biskuit",
    130500000001,
    "Minuman Khusus Ibu Hamil  ",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2232,
    10799,
    1316,
    "Pangan ibu hamil dan pangan ibu menyusui bentuk bubuk",
    130500000001,
    "Minuman Khusus Ibu Hamil  ",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2233,
    10799,
    1317,
    "Pangan ibu hamil dan pangan ibu menyusui bentuk cair (UHT)",
    130500000001,
    "Minuman Khusus Ibu Hamil  ",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2234,
    10799,
    1315,
    "Pangan ibu hamil dan pangan ibu menyusui bentuk biskuit",
    130500000002,
    "Minuman Khusus Ibu Menyusui ",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2235,
    10799,
    1316,
    "Pangan ibu hamil dan pangan ibu menyusui bentuk bubuk",
    130500000002,
    "Minuman Khusus Ibu Menyusui ",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2236,
    10799,
    1317,
    "Pangan ibu hamil dan pangan ibu menyusui bentuk cair (UHT)",
    130500000002,
    "Minuman Khusus Ibu Menyusui ",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2237,
    10799,
    1325,
    "Pangan tambahan untuk olahragawan bentuk bubuk",
    130500000003,
    "Minuman Olahraga",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2238,
    10799,
    1326,
    "Pangan tambahan untuk olahragawan bentuk cair (UHT)",
    130500000003,
    "Minuman Olahraga",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2239,
    10799,
    1325,
    "Pangan tambahan untuk olahragawan bentuk bubuk",
    130500000004,
    "Pangan Tambahan Untuk Olahragawan Berbasis Karbohidrat",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2240,
    10799,
    1326,
    "Pangan tambahan untuk olahragawan bentuk cair (UHT)",
    130500000004,
    "Pangan Tambahan Untuk Olahragawan Berbasis Karbohidrat",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2241,
    10799,
    1325,
    "Pangan tambahan untuk olahragawan bentuk bubuk",
    130500000004,
    "Pangan Tambahan Untuk Olahragawan Berbasis Karbohidrat",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2242,
    10799,
    1326,
    "Pangan tambahan untuk olahragawan bentuk cair (UHT)",
    130500000004,
    "Pangan Tambahan Untuk Olahragawan Berbasis Karbohidrat",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2243,
    10799,
    1325,
    "Pangan tambahan untuk olahragawan bentuk bubuk",
    130500000005,
    "Pangan Tambahan Untuk Olahragawan Berbasis Protein",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2244,
    10799,
    1326,
    "Pangan tambahan untuk olahragawan bentuk cair (UHT)",
    130500000005,
    "Pangan Tambahan Untuk Olahragawan Berbasis Protein",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2245,
    10799,
    1325,
    "Pangan tambahan untuk olahragawan bentuk bubuk",
    130500000006,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi Protein",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2246,
    10799,
    1326,
    "Pangan tambahan untuk olahragawan bentuk cair (UHT)",
    130500000006,
    "Pangan Tambahan Untuk Olahragawan Tinggi Energi Protein",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2247,
    11051,
    1401,
    "Air minum dalam kemasan",
    140101010001,
    "Air Mineral Alami",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2248,
    11051,
    1401,
    "Air minum dalam kemasan",
    140101020001,
    "Air Mineral",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2249,
    11051,
    1401,
    "Air minum dalam kemasan",
    140101020002,
    "Air Demineral",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2250,
    11051,
    1401,
    "Air minum dalam kemasan",
    140101020003,
    "Air Minum Embun",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2251,
    11051,
    1401,
    "Air minum dalam kemasan",
    140101020004,
    "Air Minum Embun/Mineral/Demineral Beroksigen",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    2252,
    11051,
    1403,
    "Air soda/air berkarbonat/sparkling water",
    140101020005,
    "Air Minum Embun/Mineral/Demineral Berkarbonat",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    2253,
    11040,
    1403,
    "Air soda/air berkarbonat/sparkling water",
    140101020006,
    "Air Soda",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2254,
    11051,
    1402,
    "Air minum ph tinggi",
    140101020007,
    "Air Minum pH Tinggi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2255,
    11040,
    1410,
    "Minuman ringan karbonasi",
    140101020008,
    "Air Minum Olahan dengan Penambahan Garam Mineral",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2256,
    11040,
    1412,
    "Minuman ringan non-karbonasi/minuman rasa/minuman botanikal",
    140101020008,
    "Air Minum Olahan dengan Penambahan Garam Mineral",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2257,
    11040,
    1410,
    "Minuman ringan karbonasi",
    140101020008,
    "Air Minum Olahan dengan Penambahan Garam Mineral",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2258,
    11040,
    1412,
    "Minuman ringan non-karbonasi/minuman rasa/minuman botanikal",
    140101020008,
    "Air Minum Olahan dengan Penambahan Garam Mineral",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2259,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010001,
    "Sari Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2260,
    82920,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010001,
    "Sari Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2261,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010002,
    "Sari Buah Campuran",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2262,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010003,
    "Sari Buah dan Sari Sayur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2263,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010004,
    "Sari Jeruk Nipis (Lime Juice)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2264,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010005,
    "Sari Buah Apel",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2265,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010006,
    "Sari Buah Jeruk Bali",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2266,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010007,
    "Sari Buah Jeruk Orange, Valencia",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2267,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010008,
    "Sari Buah Jeruk Siam, Tangerine, Jeruk Pontianak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2268,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010009,
    "Sari Buah Jeruk Garut",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2269,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010010,
    "Sari Buah Jeruk Medan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2270,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010011,
    "Sari Buah Nanas",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2271,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010012,
    "Sari Buah Lemon",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2272,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010013,
    "Sari Buah Markisa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2273,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010014,
    "Sari Buah Anggur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2274,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010015,
    "Sari Buah Prune (Prune Juice)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2275,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010016,
    "Sari Buah Blackcurrant",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2276,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010017,
    "Sari Buah Mangga",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2277,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010018,
    "Sari Buah Sirsak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2278,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010019,
    "Sari Buah Belimbing",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2279,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010020,
    "Sari Buah Plum",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2280,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010021,
    "Sari Buah Peach",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2281,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010022,
    "Sari Buah Jambu Biji",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2282,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010023,
    "Sari Buah Delima",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2283,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010024,
    "Sari Buah Pir",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2284,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010025,
    "Sari Buah Redcurrant",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2285,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010026,
    "Sari Buah Blackberry",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2286,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010027,
    "Sari Buah Raspberry",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2287,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010028,
    "Sari Buah Stroberi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2288,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010029,
    "Sari Buah Blueberry",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2289,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010030,
    "Sari Buah Manggis",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2290,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010031,
    "Sari Buah Terong Belanda",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2291,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010032,
    "Sari Buah Leci",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2292,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010033,
    "Sari Buah Kiwi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2293,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010034,
    "Sari Buah Naga",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2294,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010035,
    "Sari Sayur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2295,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010036,
    "Sari Tomat",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2296,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010037,
    "Sari Wortel",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2297,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010038,
    "Sari Sayur Campuran",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2298,
    10330,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140102010039,
    "Sari Sayur dan Sari Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2299,
    10330,
    1405,
    "Konsentrat sari buah dan/atau sari sayuran",
    140102030001,
    "Konsentrat Sari Buah Jeruk Orange, Valencia",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2300,
    10330,
    1405,
    "Konsentrat sari buah dan/atau sari sayuran",
    140102030002,
    "Konsentrat Sari Buah Jeruk Siam, Tangerine",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2301,
    10330,
    1405,
    "Konsentrat sari buah dan/atau sari sayuran",
    140102030003,
    "Konsentrat Sari Buah Apel",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2302,
    10330,
    1405,
    "Konsentrat sari buah dan/atau sari sayuran",
    140102030004,
    "Konsentrat Sari Buah Anggur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2303,
    10330,
    1405,
    "Konsentrat sari buah dan/atau sari sayuran",
    140102030005,
    "Konsentrat Sari Buah Anggur Manis",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2304,
    10330,
    1405,
    "Konsentrat sari buah dan/atau sari sayuran",
    140102030006,
    "Konsentrat Sari Buah Blackcurrant",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2305,
    10330,
    1405,
    "Konsentrat sari buah dan/atau sari sayuran",
    140102030007,
    "Konsentrat Sari Buah Nanas",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2306,
    10330,
    1405,
    "Konsentrat sari buah dan/atau sari sayuran",
    140102030008,
    "Konsentrat Minuman Sari Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2307,
    10330,
    1405,
    "Konsentrat sari buah dan/atau sari sayuran",
    140102030009,
    "Konsentrat Minuman Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2308,
    10330,
    1405,
    "Konsentrat sari buah dan/atau sari sayuran",
    140102030010,
    "Konsentrat Sari Buah dan Sari Sayur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2309,
    10330,
    1405,
    "Konsentrat sari buah dan/atau sari sayuran",
    140102040001,
    "Konsentrat Sari Tomat",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2310,
    10330,
    1415,
    "Nektar buah/sayur",
    140103010001,
    "Nektar Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2311,
    10330,
    1415,
    "Nektar buah/sayur",
    140103010002,
    "Nektar Buah Kecil",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2312,
    10330,
    1415,
    "Nektar buah/sayur",
    140103010003,
    "Nektar Buah Campuran",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2313,
    10330,
    1415,
    "Nektar buah/sayur",
    140103010004,
    "Nektar Aprikot, Nektar Peach atau Nektar Pear/Pir",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2314,
    10330,
    1415,
    "Nektar buah/sayur",
    140103010005,
    "Nektar Blackcurrant",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2315,
    10330,
    1415,
    "Nektar buah/sayur",
    140103010006,
    "Nektar Buah Citrus",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2316,
    10330,
    1415,
    "Nektar buah/sayur",
    140103010007,
    "Nektar Jambu Biji",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2317,
    10330,
    1415,
    "Nektar buah/sayur",
    140103010008,
    "Nektar Mangga",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2318,
    10330,
    1415,
    "Nektar buah/sayur",
    140103010009,
    "Nektar Sirsak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2319,
    10330,
    1415,
    "Nektar buah/sayur",
    140103020001,
    "Nektar Sayur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2320,
    10330,
    1415,
    "Nektar buah/sayur",
    140103030001,
    "Konsentrat Nektar Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2321,
    10330,
    1415,
    "Nektar buah/sayur",
    140103040001,
    "Konsentrat Nektar Sayur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2322,
    10330,
    1413,
    "Minuman sari buah",
    140104010001,
    "Minuman Sari Buah Berkarbonat",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2323,
    10330,
    1409,
    "Minuman buah",
    140104010002,
    "Minuman Buah Berkarbonat",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2324,
    11040,
    1410,
    "Minuman ringan karbonasi",
    140104010003,
    "Minuman Berperisa Berkarbonat",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2325,
    11090,
    1410,
    "Minuman ringan karbonasi",
    140104010004,
    "Minuman Rasa Susu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2326,
    11040,
    1410,
    "Minuman ringan karbonasi",
    140104010005,
    "Ginger Ale",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2327,
    11040,
    1410,
    "Minuman ringan karbonasi",
    140104010006,
    "Sarsaparilla",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2328,
    11040,
    1410,
    "Minuman ringan karbonasi",
    140104010007,
    "Root Beer",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2329,
    11040,
    1410,
    "Minuman ringan karbonasi",
    140104010008,
    "Birch Beer",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2330,
    11040,
    1410,
    "Minuman ringan karbonasi",
    140104010009,
    "Soda Krim (Cream soda)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2331,
    11040,
    1410,
    "Minuman ringan karbonasi",
    140104010010,
    "Minuman Citrus",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2332,
    11040,
    1410,
    "Minuman ringan karbonasi",
    140104010011,
    "Minuman Citrus Comminutes",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2333,
    11040,
    1410,
    "Minuman ringan karbonasi",
    140104010012,
    "Minuman Kola",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2334,
    11040,
    1410,
    "Minuman ringan karbonasi",
    140104010013,
    "Limun",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2335,
    11040,
    1410,
    "Minuman ringan karbonasi",
    140104010014,
    "Minuman Fermentasi Berkarbonasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2336,
    11040,
    1410,
    "Minuman ringan karbonasi",
    140104010015,
    "Minuman Teh Fermentasi (Kombucha) Berkarbonasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2337,
    11040,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020001,
    "Punches/Ades",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2338,
    11040,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020002,
    "Crush",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2339,
    10330,
    1413,
    "Minuman sari buah",
    140104020003,
    "Minuman Sari Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2340,
    11040,
    1413,
    "Minuman Sari Buah",
    140104020003,
    "Minuman Sari Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2341,
    10330,
    1409,
    "Minuman buah",
    140104020004,
    "Minuman Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2342,
    11040,
    1409,
    "Minuman buah",
    140104020004,
    "Minuman Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2343,
    11040,
    1411,
    "Minuman ringan non karbonasi pH = 4,6",
    140104020005,
    "Minuman Rasa Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2344,
    11040,
    1412,
    "Minuman ringan non-karbonasi/minuman rasa/minuman botanikal",
    140104020005,
    "Minuman Rasa Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2345,
    11040,
    1411,
    "Minuman ringan non karbonasi pH = 4,6",
    140104020005,
    "Minuman Rasa Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2346,
    11040,
    1412,
    "Minuman ringan non-karbonasi/minuman rasa/minuman botanikal",
    140104020005,
    "Minuman Rasa Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2347,
    11040,
    1412,
    "Minuman ringan non-karbonasi/minuman rasa/minuman botanikal",
    140104020006,
    "Minuman Berperisa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2348,
    11090,
    1412,
    "Minuman ringan non-karbonasi/minuman rasa/minuman botanikal",
    140104020006,
    "Minuman Berperisa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2349,
    11040,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020007,
    "Minuman Jeli",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2350,
    11090,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020007,
    "Minuman Jeli",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2351,
    10763,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020008,
    "Minuman Teh",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2352,
    11040,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020008,
    "Minuman Teh",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2353,
    11090,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020008,
    "Minuman Teh",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2354,
    10761,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020009,
    "Minuman Kopi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2355,
    11040,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020009,
    "Minuman Kopi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2356,
    11090,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020009,
    "Minuman Kopi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2357,
    10761,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020009,
    "Minuman Kopi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2358,
    11040,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020009,
    "Minuman Kopi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2359,
    11090,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020009,
    "Minuman Kopi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2360,
    11090,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020010,
    "Kapucino",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2361,
    11090,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020011,
    "Minuman Rasa Susu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2362,
    11040,
    1409,
    "Minuman buah",
    140104020012,
    "Minuman Citrus Comminutes",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2363,
    11040,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020013,
    "Minuman Teh Fermentasi (Kombucha)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2364,
    11090,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020013,
    "Minuman Teh Fermentasi (Kombucha)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2365,
    11040,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020014,
    "Minuman Fermentasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2366,
    11090,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020014,
    "Minuman Fermentasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2367,
    11040,
    1412,
    "Minuman ringan non-karbonasi/minuman rasa/minuman botanikal",
    140104020015,
    "Minuman dengan Penambahan Garam Mineral",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2368,
    11040,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020016,
    "Minuman Teh Fermentasi (Kombucha)",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    2369,
    11090,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020016,
    "Minuman Teh Fermentasi (Kombucha)",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    2370,
    11040,
    1412,
    "Minuman ringan non-karbonasi/minuman rasa/minuman botanikal ",
    140104020017,
    "Minuman dengan Larutan Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2371,
    11040,
    1417,
    "Pangan kategori 14 risiko sedang lainnya ",
    140104020017,
    "Minuman dengan Larutan Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2372,
    11090,
    1412,
    "Minuman ringan non-karbonasi/minuman rasa/minuman botanikal ",
    140104020017,
    "Minuman dengan Larutan Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2373,
    11090,
    1417,
    "Pangan kategori 14 risiko sedang lainnya ",
    140104020017,
    "Minuman dengan Larutan Mutiara",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2374,
    11040,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104020019,
    "Minuman Kacang-Kacangan, Biji-bijian, dan Bahan Nabati Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2375,
    11040,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030001,
    "Konsentrat Lemonade Beku",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2376,
    10723,
    1414,
    "Minuman serbuk",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2377,
    10723,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2378,
    10723,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2379,
    10723,
    1414,
    "Minuman serbuk",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2380,
    10723,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2381,
    10723,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2382,
    10723,
    1414,
    "Minuman serbuk",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2383,
    10723,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2384,
    10723,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2385,
    11040,
    1414,
    "Minuman serbuk",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2386,
    11040,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2387,
    11040,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2388,
    11040,
    1414,
    "Minuman serbuk",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2389,
    11040,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2390,
    11040,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2391,
    11040,
    1414,
    "Minuman serbuk",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2392,
    11040,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2393,
    11040,
    1417,
    "Pangan kategori 14 risiko sedang lainnya",
    140104030002,
    "Konsentrat Minuman Rasa/Berperisa Berkarbonat atau Tidak Berkarbonat (Serbuk/ Cair/ Pasta)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2394,
    10723,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030003,
    "Squash",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2395,
    10723,
    1422,
    "Sirup dan Squash",
    140104030003,
    "Squash",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2396,
    10723,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030003,
    "Squash",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2397,
    10723,
    1422,
    "Sirup dan Squash",
    140104030003,
    "Squash",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2398,
    10723,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030004,
    "Squash Berperisa/Rasa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2399,
    10723,
    1422,
    "Sirup dan Squash",
    140104030004,
    "Squash Berperisa/Rasa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2400,
    10723,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030004,
    "Squash Berperisa/Rasa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2401,
    10723,
    1422,
    "Sirup dan Squash",
    140104030004,
    "Squash Berperisa/Rasa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2402,
    10723,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030005,
    "Sirup Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2403,
    10723,
    1422,
    "Sirup dan Squash",
    140104030005,
    "Sirup Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2404,
    10723,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030005,
    "Sirup Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2405,
    10723,
    1422,
    "Sirup dan Squash",
    140104030005,
    "Sirup Buah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2406,
    10723,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030006,
    "Sirup Berperisa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2407,
    10723,
    1422,
    "Sirup dan Squash",
    140104030006,
    "Sirup Berperisa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2408,
    10723,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030006,
    "Sirup Berperisa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2409,
    10723,
    1422,
    "Sirup dan Squash",
    140104030006,
    "Sirup Berperisa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2410,
    10723,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030007,
    "Sirup Encer Berperisa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2411,
    10723,
    1422,
    "Sirup dan Squash",
    140104030007,
    "Sirup Encer Berperisa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2412,
    10723,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030007,
    "Sirup Encer Berperisa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2413,
    10723,
    1422,
    "Sirup dan Squash",
    140104030007,
    "Sirup Encer Berperisa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2414,
    10723,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030008,
    "Sirup Teh",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2415,
    10723,
    1422,
    "Sirup dan Squash",
    140104030008,
    "Sirup Teh",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2416,
    10723,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030008,
    "Sirup Teh",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2417,
    10723,
    1422,
    "Sirup dan Squash",
    140104030008,
    "Sirup Teh",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2418,
    10723,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030009,
    "Sirup Kopi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2419,
    10723,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030010,
    "Pengganti Sirup Berperisa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2420,
    10723,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030011,
    "Pengganti Squash Berperisa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2421,
    10723,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030012,
    "Pengganti Sirup Encer Berperisa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2422,
    11040,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140104030013,
    "Konsentrat Minuman Cuka/ Konsentrat Minuman Vinegar",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2423,
    10763,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000001,
    "Teh Hitam",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2424,
    82920,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000001,
    "Teh Hitam",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2425,
    10763,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000002,
    "Teh Hijau",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2426,
    82920,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000002,
    "Teh Hijau",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2427,
    10763,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000003,
    "Teh Putih",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2428,
    82920,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000003,
    "Teh Putih",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2429,
    10763,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000004,
    "Teh Wangi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2430,
    82920,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000004,
    "Teh Wangi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2431,
    10763,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000005,
    "Teh Olong atau Teh Semi Fermentasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2432,
    82920,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000005,
    "Teh Olong atau Teh Semi Fermentasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2433,
    10763,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000006,
    "Teh Hijau Bubuk",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2434,
    82920,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000006,
    "Teh Hijau Bubuk",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2435,
    10763,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000007,
    "Teh Kering",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2436,
    82920,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000007,
    "Teh Kering",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2437,
    10763,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000008,
    "Teh Hitam Celup",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2438,
    82920,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000008,
    "Teh Hitam Celup",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2439,
    10763,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000009,
    "Teh Wangi Celup",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2440,
    82920,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000009,
    "Teh Wangi Celup",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2441,
    10763,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000010,
    "Teh Hijau Celup",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2442,
    82920,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000010,
    "Teh Hijau Celup",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2443,
    10763,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000011,
    "Teh Instan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2444,
    82920,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000011,
    "Teh Instan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2445,
    10763,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000012,
    "Teh Instan Dekafein",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2446,
    82920,
    1418,
    "Teh kering/celup, termasuk teh berperisa",
    140105000012,
    "Teh Instan Dekafein",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2447,
    11040,
    1406,
    "Konsentrat teh",
    140105000013,
    "Konsentrat Minuman Teh",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2448,
    10763,
    1414,
    "Minuman serbuk",
    140105000014,
    "Minuman Serbuk Teh",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2449,
    11040,
    1414,
    "Minuman serbuk",
    140105000014,
    "Minuman Serbuk Teh",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2450,
    10761,
    1407,
    "Kopi",
    140105000015,
    "Biji Kopi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2451,
    10761,
    1407,
    "Kopi",
    140105000016,
    "Kopi Bubuk",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2452,
    82920,
    1407,
    "Kopi",
    140105000016,
    "Kopi Bubuk",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2453,
    10761,
    1407,
    "Kopi",
    140105000017,
    "Kopi Instan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2454,
    82920,
    1407,
    "Kopi",
    140105000017,
    "Kopi Instan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2455,
    10761,
    1407,
    "Kopi",
    140105000018,
    "Kopi Campur",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2456,
    10761,
    1407,
    "Kopi",
    140105000019,
    "Minuman Berkafein Formulasi (Formulated Caffeinated Beverages)",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    2457,
    10761,
    1412,
    "Minuman ringan non-karbonasi/minuman rasa/minuman botanikal",
    140105000019,
    "Minuman Berkafein Formulasi (Formulated Caffeinated Beverages)",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    2458,
    11040,
    1407,
    "Kopi",
    140105000019,
    "Minuman Berkafein Formulasi (Formulated Caffeinated Beverages)",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    2459,
    11040,
    1412,
    "Minuman ringan non-karbonasi/minuman rasa/minuman botanikal",
    140105000019,
    "Minuman Berkafein Formulasi (Formulated Caffeinated Beverages)",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    2460,
    10761,
    1404,
    "Konsentrat kopi",
    140105000020,
    "Konsentrat Minuman Kopi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2461,
    10761,
    1407,
    "Kopi",
    140105000021,
    "Kopi Celup",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2462,
    82920,
    1407,
    "Kopi",
    140105000021,
    "Kopi Celup",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2463,
    10761,
    1407,
    "Kopi",
    140105000022,
    "Kopi Dekafein",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2464,
    10761,
    1407,
    "Kopi",
    140105000023,
    "Kopi Instan Dekafein",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2465,
    82920,
    1407,
    "Kopi",
    140105000023,
    "Kopi Instan Dekafein",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2466,
    10761,
    1414,
    "Minuman serbuk",
    140105000024,
    "Minuman Serbuk Kopi Susu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2467,
    11040,
    1414,
    "Minuman serbuk",
    140105000024,
    "Minuman Serbuk Kopi Susu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2468,
    10761,
    1414,
    "Minuman serbuk",
    140105000025,
    "Minuman Serbuk Kopi Krimer",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2469,
    11040,
    1414,
    "Minuman serbuk",
    140105000025,
    "Minuman Serbuk Kopi Krimer",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2470,
    10761,
    1414,
    "Minuman serbuk",
    140105000026,
    "Minuman Serbuk Kopi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2471,
    11040,
    1414,
    "Minuman serbuk",
    140105000026,
    "Minuman Serbuk Kopi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2472,
    11040,
    1412,
    "Minuman ringan non-karbonasi/minuman rasa/minuman botanikal",
    140105000027,
    "Minuman Botanikal/Minuman Rempah (Bentuk Padat atau Cair)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2473,
    11090,
    1412,
    "Minuman ringan non-karbonasi/minuman rasa/minuman botanikal",
    140105000027,
    "Minuman Botanikal/Minuman Rempah (Bentuk Padat atau Cair)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2474,
    82920,
    1412,
    "Minuman ringan non-karbonasi/minuman rasa/minuman botanikal",
    140105000027,
    "Minuman Botanikal/Minuman Rempah (Bentuk Padat atau Cair)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2475,
    11090,
    1414,
    "Minuman serbuk",
    140105000028,
    "Serbuk Sekoteng",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2476,
    10330,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140105000029,
    "Minuman Sari Kacang Hijau",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2477,
    11040,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140105000029,
    "Minuman Sari Kacang Hijau",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2478,
    11090,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140105000029,
    "Minuman Sari Kacang Hijau",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2479,
    11090,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140105000030,
    "Serealia Celup",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2480,
    11090,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140105000031,
    "Minuman Serealia",
    300000,
    200000,
    150000,
    "Nonaktif",
  ],
  [
    2481,
    10615,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140105000032,
    "Minuman Mengandung Sereal/Minuman Mengandung Serealia",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2482,
    11090,
    1416,
    "Pangan kategori 14 risiko rendah lainnya",
    140105000032,
    "Minuman Mengandung Sereal/Minuman Mengandung Serealia",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2483,
    11040,
    1414,
    "Minuman serbuk ",
    140105000033,
    "Minuman Teh Fermentasi (Kombucha) Serbuk",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2484,
    11090,
    1414,
    "Minuman serbuk ",
    140105000033,
    "Minuman Teh Fermentasi (Kombucha) Serbuk",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2485,
    11040,
    1414,
    "Minuman serbuk ",
    140105000033,
    "Minuman Teh Fermentasi (Kombucha) Serbuk",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2486,
    11090,
    1414,
    "Minuman serbuk ",
    140105000033,
    "Minuman Teh Fermentasi (Kombucha) Serbuk",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2487,
    11040,
    1414,
    "Minuman serbuk ",
    140105000034,
    "Minuman Serbuk Biji Salak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2488,
    11090,
    1414,
    "Minuman serbuk ",
    140105000034,
    "Minuman Serbuk Biji Salak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2489,
    11040,
    1414,
    "Minuman serbuk ",
    140105000035,
    "Minuman Serbuk Kulit Pisang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2490,
    11090,
    1414,
    "Minuman serbuk ",
    140105000035,
    "Minuman Serbuk Kulit Pisang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2491,
    11031,
    1408,
    "Minuman beralkohol",
    140201000001,
    "Bir",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2492,
    11031,
    1408,
    "Minuman beralkohol",
    140201000002,
    "Bir Hitam (Stout)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2493,
    11020,
    1408,
    "Minuman beralkohol",
    140202000001,
    "Cider atau Anggur Apel",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2494,
    11020,
    1408,
    "Minuman beralkohol",
    140202000002,
    "Perry",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2495,
    11020,
    1408,
    "Minuman beralkohol",
    140203000001,
    "Anggur (Grape Wine)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2496,
    11020,
    1408,
    "Minuman beralkohol",
    140203010001,
    "Still Grape Wine",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2497,
    11020,
    1408,
    "Minuman beralkohol",
    140203020001,
    "Anggur Sparkling dan Semi Sparkling",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2498,
    11020,
    1408,
    "Minuman beralkohol",
    140203030001,
    "Anggur Fortifikasi, Anggur Liqueur dan Anggur Manis",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2499,
    11020,
    1408,
    "Minuman beralkohol",
    140204000001,
    "Anggur Buah",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2500,
    11020,
    1408,
    "Minuman beralkohol",
    140204000002,
    "Anggur Beras",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2501,
    11020,
    1408,
    "Minuman beralkohol",
    140204000003,
    "Anggur Beras Ketan",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2502,
    11020,
    1408,
    "Minuman beralkohol",
    140204000004,
    "Anggur Brem Bali",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2503,
    11020,
    1408,
    "Minuman beralkohol",
    140204000005,
    "Anggur Sayur (Vegetable Wine)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2504,
    11020,
    1408,
    "Minuman beralkohol",
    140204000006,
    "Tuak",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2505,
    11020,
    1408,
    "Minuman beralkohol",
    140204000007,
    "Anggur Tonikum Kinina",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2506,
    11020,
    1408,
    "Minuman beralkohol",
    140204000008,
    "Sake",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2507,
    11020,
    1408,
    "Minuman beralkohol",
    140205000001,
    "Mead, Anggur Madu",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2508,
    11010,
    1408,
    "Minuman beralkohol",
    140206000001,
    "Minuman Spirit",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2509,
    11010,
    1408,
    "Minuman beralkohol",
    140206000002,
    "Brandy",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2510,
    11010,
    1408,
    "Minuman beralkohol",
    140206000003,
    "Brandy Buah",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2511,
    11010,
    1408,
    "Minuman beralkohol",
    140206000004,
    "Cognac",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2512,
    11010,
    1408,
    "Minuman beralkohol",
    140206000005,
    "Rum",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2513,
    11010,
    1408,
    "Minuman beralkohol",
    140206000006,
    "Whisky",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2514,
    11010,
    1408,
    "Minuman beralkohol",
    140206000007,
    "Gin",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2515,
    11010,
    1408,
    "Minuman beralkohol",
    140206000008,
    "Vodka",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2516,
    11010,
    1408,
    "Minuman beralkohol",
    140206000009,
    "Tequila",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2517,
    11010,
    1408,
    "Minuman beralkohol",
    140206000010,
    "Arak",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2518,
    11010,
    1408,
    "Minuman beralkohol",
    140206000011,
    "Genever",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2519,
    11010,
    1408,
    "Minuman beralkohol",
    140206000012,
    "Liqueur",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2520,
    11010,
    1408,
    "Minuman beralkohol",
    140206000013,
    "Soju",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2521,
    11020,
    1408,
    "Minuman beralkohol",
    140207000001,
    "Minuman Ringan Beralkohol",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2522,
    11020,
    1408,
    "Minuman beralkohol",
    140207000002,
    "Shandy",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2523,
    11020,
    1408,
    "Minuman beralkohol",
    140207000003,
    "Anggur Rendah Alkohol",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2524,
    11020,
    1408,
    "Minuman beralkohol",
    140207000004,
    "Koktail Anggur (Wine Cocktail)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2525,
    11020,
    1408,
    "Minuman beralkohol",
    140207000005,
    "Meat Wine",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2526,
    11020,
    1408,
    "Minuman beralkohol",
    140207000006,
    "Anggur Mengandung bahan pangan lain (antara lain : Ginseng/kolesom/temulawak)",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2527,
    11010,
    1408,
    "Minuman beralkohol",
    140207000007,
    "Minuman Beralkohol Golongan A",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2528,
    11020,
    1408,
    "Minuman beralkohol",
    140207000007,
    "Minuman Beralkohol Golongan A",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2529,
    11031,
    1408,
    "Minuman beralkohol",
    140207000007,
    "Minuman Beralkohol Golongan A",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2530,
    11010,
    1408,
    "Minuman beralkohol",
    140207000008,
    "Minuman Beralkohol Golongan B",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2531,
    11020,
    1408,
    "Minuman beralkohol",
    140207000008,
    "Minuman Beralkohol Golongan B",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2532,
    11031,
    1408,
    "Minuman beralkohol",
    140207000008,
    "Minuman Beralkohol Golongan B",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2533,
    11010,
    1408,
    "Minuman beralkohol",
    140207000009,
    "Minuman Beralkohol Golongan C",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2534,
    11020,
    1408,
    "Minuman beralkohol",
    140207000009,
    "Minuman Beralkohol Golongan C",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2535,
    11031,
    1408,
    "Minuman beralkohol",
    140207000009,
    "Minuman Beralkohol Golongan C",
    3000000,
    2500000,
    1500000,
    "Aktif",
  ],
  [
    2536,
    10313,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000001,
    "Keripik Kentang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2537,
    10399,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000001,
    "Keripik Kentang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2538,
    10794,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000001,
    "Keripik Kentang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2539,
    82920,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000001,
    "Keripik Kentang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2540,
    10794,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000002,
    "Keripik Gadung",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2541,
    10710,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000003,
    "Krekers Beras (Senbei)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2542,
    10794,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000003,
    "Krekers Beras (Senbei)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2543,
    10794,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000004,
    "Keripik Singkong ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2544,
    82920,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000004,
    "Keripik Singkong ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2545,
    10794,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000005,
    "Dakak-dakak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2546,
    10794,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000006,
    "Lanting/Karak Kaliang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2547,
    10794,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000007,
    "Keripik Ubi Jalar  ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2548,
    10793,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000008,
    "Keripik Tempe ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2549,
    10793,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000009,
    "Keripik Oncom ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2550,
    10793,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000010,
    "Keripik Tahu/Keripik Produk Tahu/Keripik Kembang Tahu",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2551,
    10794,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000011,
    "Keripik Talas",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2552,
    10313,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000012,
    "Makanan Ringan Simulasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2553,
    10710,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000012,
    "Makanan Ringan Simulasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2554,
    10740,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000012,
    "Makanan Ringan Simulasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2555,
    10794,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000012,
    "Makanan Ringan Simulasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2556,
    82920,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000012,
    "Makanan Ringan Simulasi",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2557,
    10794,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000013,
    "Kecimpring ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2558,
    10794,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000014,
    "Opak",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2559,
    10794,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000015,
    "Simping",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2560,
    10794,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000016,
    "Slondok",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2561,
    10710,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000017,
    "Pilus",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2562,
    10313,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000018,
    "Jagung Berondong",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2563,
    10794,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000018,
    "Jagung Berondong",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2564,
    10313,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000019,
    "Jagung Marning",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2565,
    10794,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000019,
    "Jagung Marning",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2566,
    10313,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000020,
    "Jipang Jagung ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2567,
    10794,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000020,
    "Jipang Jagung ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2568,
    10794,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000021,
    "Jipang Beras",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2569,
    10793,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000022,
    "Jipang Melinjo ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2570,
    10313,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000023,
    "Kerupuk Beras ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2571,
    10794,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000023,
    "Kerupuk Beras ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2572,
    10794,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000024,
    "Kerupuk Karak ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2573,
    10794,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000025,
    "Kerupuk Intip ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2574,
    10794,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000026,
    "Rengginang/Batiah",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2575,
    10794,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000027,
    "Patilo / Rengginang Singkong",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2576,
    10793,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000028,
    "Rempeyek ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2577,
    10710,
    1504,
    "Makanan ringan ekstrudat",
    150100000029,
    "Makanan Ringan Ekstrudat",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2578,
    10793,
    1504,
    "Makanan ringan ekstrudat",
    150100000029,
    "Makanan Ringan Ekstrudat",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2579,
    10794,
    1504,
    "Makanan ringan ekstrudat",
    150100000029,
    "Makanan Ringan Ekstrudat",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2580,
    10793,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000030,
    "Emping Melinjo Goreng",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2581,
    10313,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000031,
    "Makanan Ringan Berbentuk Batang/Bar",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2582,
    10710,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000031,
    "Makanan Ringan Berbentuk Batang/Bar",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2583,
    10793,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000031,
    "Makanan Ringan Berbentuk Batang/Bar",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2584,
    10794,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000031,
    "Makanan Ringan Berbentuk Batang/Bar",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2585,
    10710,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000032,
    "Krekers Rasa",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2586,
    10710,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000033,
    "Krekers Sandwich ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2587,
    10710,
    1502,
    "Makanan ringan \x{2013} berbahan dasar kentang, umbi, serealia, tepung atau pati (dari umbi dan kacang)",
    150100000034,
    "Malkist ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2588,
    10298,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2589,
    10298,
    "0415",
    "Rumput laut kering",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2590,
    10298,
    1505,
    "Makanan ringan siap santap lainnya",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2591,
    10298,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2592,
    10298,
    "0415",
    "Rumput laut kering",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2593,
    10298,
    1505,
    "Makanan ringan siap santap lainnya",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2594,
    10298,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2595,
    10298,
    "0415",
    "Rumput laut kering",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2596,
    10298,
    1505,
    "Makanan ringan siap santap lainnya",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2597,
    10794,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2598,
    10794,
    "0415",
    "Rumput laut kering",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2599,
    10794,
    1505,
    "Makanan ringan siap santap lainnya",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2600,
    10794,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2601,
    10794,
    "0415",
    "Rumput laut kering",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2602,
    10794,
    1505,
    "Makanan ringan siap santap lainnya",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2603,
    10794,
    "0411",
    "Pangan kategori 4 risiko rendah lainnya",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2604,
    10794,
    "0415",
    "Rumput laut kering",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2605,
    10794,
    1505,
    "Makanan ringan siap santap lainnya",
    150100000035,
    "Keripik Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2606,
    10793,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000001,
    "Kacang Garing/Kacang Kulit",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2607,
    10793,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000002,
    "Kacang Sangrai ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2608,
    10793,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000003,
    "Kacang Goreng",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2609,
    82920,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000004,
    "Kacang Goreng Lainnya ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2610,
    10793,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000004,
    "Kacang Goreng Lainnya ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2611,
    10793,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000005,
    "Kacang Bawang / Kacang Tojin",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2612,
    10793,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000006,
    "Kacang Panggang ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2613,
    10793,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000007,
    "Kacang Panggang Lainnya ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2614,
    82920,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000007,
    "Kacang Panggang Lainnya ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2615,
    10793,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000008,
    "Kacang Atom/Sukro ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2616,
    10793,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000009,
    "Kacang Atom Lainnya",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2617,
    10793,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000010,
    "Kacang Telur ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2618,
    10793,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000011,
    "Kacang Goyang ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2619,
    10793,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000012,
    "Jipang/Kipang Kacang ",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2620,
    10793,
    1505,
    "Makanan ringan siap santap lainnya",
    150200000013,
    "Kacang Bersalut",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2621,
    10794,
    1503,
    "Makanan ringan berbasis ikan",
    150300000001,
    "Kerupuk Hasil Perikanan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2622,
    82920,
    1503,
    "Makanan ringan berbasis ikan",
    150300000001,
    "Kerupuk Hasil Perikanan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2623,
    10794,
    1503,
    "Makanan ringan berbasis ikan",
    150300000002,
    "Rempeyek Ikan",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2624,
    10794,
    1503,
    "Makanan ringan berbasis ikan",
    150300000003,
    "Sumpia Udang",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2625,
    10750,
    1601,
    "Pangan siap saji terkemas",
    160000000001,
    "Makanan Siap Saji Berbasis Nasi (Terkemas)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2626,
    10750,
    1601,
    "Pangan siap saji terkemas",
    160000000002,
    "Makanan Siap Saji Berbasis Mi/Bihun (Terkemas)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2627,
    10750,
    1601,
    "Pangan siap saji terkemas",
    160000000003,
    "Makanan Siap Saji Berbasis Kentang (Terkemas)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2628,
    10750,
    1601,
    "Pangan siap saji terkemas",
    160000000004,
    "Makanan Siap Saji Berbasis Pasta (Terkemas)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2629,
    10750,
    1601,
    "Pangan siap saji terkemas",
    160000000005,
    "Makanan Siap Saji Berbasis Umbi (Terkemas)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2630,
    10710,
    1601,
    "Pangan siap saji terkemas",
    160000000006,
    "Makanan Siap Saji Berbasis Roti (Terkemas)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2631,
    10750,
    1601,
    "Pangan siap saji terkemas",
    160000000006,
    "Makanan Siap Saji Berbasis Roti (Terkemas)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2632,
    10750,
    1601,
    "Pangan siap saji terkemas",
    160000000007,
    "Makanan Siap Saji Berbasis Kuah (Terkemas)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2633,
    10750,
    1601,
    "Pangan siap saji terkemas",
    160000000008,
    "Makanan Siap Saji Berbasis Sayuran (Terkemas)",
    300000,
    200000,
    150000,
    "Aktif",
  ],
  [
    2634,
    10750,
    1601,
    "Pangan siap saji terkemas",
    160000000009,
    "Makanan Siap Saji Berbasis Bahan Lain",
    300000,
    200000,
    150000,
    "Aktif",
  ],
];
# END FRAGMENT id=data-idn_bpom_jenis_pangan_rba_produsen

my $res = gen_read_table_func(
    name => 'bpom_list_food_types_rba_producer',
    summary => 'List food types in BPOM processed food division (RBA version, for producers)',
    table_data => $data_idn_bpom_jenis_pangan_rba_produsen,
    table_spec => $meta_idn_bpom_jenis_pangan_rba_produsen,
    description => <<'_',
_
    extra_props => {
        examples => [
        ],
    },
);
die "Can't generate function: $res->[0] - $res->[1]" unless $res->[0] == 200;

1;
# ABSTRACT: List food types in BPOM processed food division (RBA version, for producers)

__END__

=pod

=encoding UTF-8

=head1 NAME

App::BPOMUtils::Table::FoodTypeRBAProducer - List food types in BPOM processed food division (RBA version, for producers)

=head1 VERSION

This document describes version 0.021 of App::BPOMUtils::Table::FoodTypeRBAProducer (from Perl distribution App-BPOMUtils-Table-FoodType), released on 2025-05-22.

=head1 FUNCTIONS


=head2 bpom_list_food_types_rba_producer

Usage:

 bpom_list_food_types_rba_producer(%args) -> [$status_code, $reason, $payload, \%result_meta]

List food types in BPOM processed food division (RBA version, for producers).

This function is not exported by default, but exportable.

Arguments ('*' denotes required arguments):

=over 4

=item * B<category_code> => I<str>

Only return records where the 'category_code' field equals specified value.

=item * B<category_code.contains> => I<str>

Only return records where the 'category_code' field contains specified text.

=item * B<category_code.in> => I<array[str]>

Only return records where the 'category_code' field is in the specified values.

=item * B<category_code.is> => I<str>

Only return records where the 'category_code' field equals specified value.

=item * B<category_code.isnt> => I<str>

Only return records where the 'category_code' field does not equal specified value.

=item * B<category_code.matches> => I<str>

Only return records where the 'category_code' field matches specified regular expression pattern.

=item * B<category_code.max> => I<str>

Only return records where the 'category_code' field is less than or equal to specified value.

=item * B<category_code.min> => I<str>

Only return records where the 'category_code' field is greater than or equal to specified value.

=item * B<category_code.not_contains> => I<str>

Only return records where the 'category_code' field does not contain specified text.

=item * B<category_code.not_in> => I<array[str]>

Only return records where the 'category_code' field is not in the specified values.

=item * B<category_code.not_matches> => I<str>

Only return records where the 'category_code' field does not match specified regular expression.

=item * B<category_code.xmax> => I<str>

Only return records where the 'category_code' field is less than specified value.

=item * B<category_code.xmin> => I<str>

Only return records where the 'category_code' field is greater than specified value.

=item * B<detail> => I<bool> (default: 0)

Return array of full records instead of just ID fields.

By default, only the key (ID) field is returned per result entry.

=item * B<dosage_form_code> => I<str>

Only return records where the 'dosage_form_code' field equals specified value.

=item * B<dosage_form_code.contains> => I<str>

Only return records where the 'dosage_form_code' field contains specified text.

=item * B<dosage_form_code.in> => I<array[str]>

Only return records where the 'dosage_form_code' field is in the specified values.

=item * B<dosage_form_code.is> => I<str>

Only return records where the 'dosage_form_code' field equals specified value.

=item * B<dosage_form_code.isnt> => I<str>

Only return records where the 'dosage_form_code' field does not equal specified value.

=item * B<dosage_form_code.matches> => I<str>

Only return records where the 'dosage_form_code' field matches specified regular expression pattern.

=item * B<dosage_form_code.max> => I<str>

Only return records where the 'dosage_form_code' field is less than or equal to specified value.

=item * B<dosage_form_code.min> => I<str>

Only return records where the 'dosage_form_code' field is greater than or equal to specified value.

=item * B<dosage_form_code.not_contains> => I<str>

Only return records where the 'dosage_form_code' field does not contain specified text.

=item * B<dosage_form_code.not_in> => I<array[str]>

Only return records where the 'dosage_form_code' field is not in the specified values.

=item * B<dosage_form_code.not_matches> => I<str>

Only return records where the 'dosage_form_code' field does not match specified regular expression.

=item * B<dosage_form_code.xmax> => I<str>

Only return records where the 'dosage_form_code' field is less than specified value.

=item * B<dosage_form_code.xmin> => I<str>

Only return records where the 'dosage_form_code' field is greater than specified value.

=item * B<dosage_form_name> => I<str>

Only return records where the 'dosage_form_name' field equals specified value.

=item * B<dosage_form_name.contains> => I<str>

Only return records where the 'dosage_form_name' field contains specified text.

=item * B<dosage_form_name.in> => I<array[str]>

Only return records where the 'dosage_form_name' field is in the specified values.

=item * B<dosage_form_name.is> => I<str>

Only return records where the 'dosage_form_name' field equals specified value.

=item * B<dosage_form_name.isnt> => I<str>

Only return records where the 'dosage_form_name' field does not equal specified value.

=item * B<dosage_form_name.matches> => I<str>

Only return records where the 'dosage_form_name' field matches specified regular expression pattern.

=item * B<dosage_form_name.max> => I<str>

Only return records where the 'dosage_form_name' field is less than or equal to specified value.

=item * B<dosage_form_name.min> => I<str>

Only return records where the 'dosage_form_name' field is greater than or equal to specified value.

=item * B<dosage_form_name.not_contains> => I<str>

Only return records where the 'dosage_form_name' field does not contain specified text.

=item * B<dosage_form_name.not_in> => I<array[str]>

Only return records where the 'dosage_form_name' field is not in the specified values.

=item * B<dosage_form_name.not_matches> => I<str>

Only return records where the 'dosage_form_name' field does not match specified regular expression.

=item * B<dosage_form_name.xmax> => I<str>

Only return records where the 'dosage_form_name' field is less than specified value.

=item * B<dosage_form_name.xmin> => I<str>

Only return records where the 'dosage_form_name' field is greater than specified value.

=item * B<exclude_fields> => I<array[str]>

Select fields to return.

=item * B<fields> => I<array[str]>

Select fields to return.

=item * B<id> => I<int>

Only return records where the 'id' field equals specified value.

=item * B<id.in> => I<array[int]>

Only return records where the 'id' field is in the specified values.

=item * B<id.is> => I<int>

Only return records where the 'id' field equals specified value.

=item * B<id.isnt> => I<int>

Only return records where the 'id' field does not equal specified value.

=item * B<id.max> => I<int>

Only return records where the 'id' field is less than or equal to specified value.

=item * B<id.min> => I<int>

Only return records where the 'id' field is greater than or equal to specified value.

=item * B<id.not_in> => I<array[int]>

Only return records where the 'id' field is not in the specified values.

=item * B<id.xmax> => I<int>

Only return records where the 'id' field is less than specified value.

=item * B<id.xmin> => I<int>

Only return records where the 'id' field is greater than specified value.

=item * B<kbli_code> => I<str>

Only return records where the 'kbli_code' field equals specified value.

=item * B<kbli_code.contains> => I<str>

Only return records where the 'kbli_code' field contains specified text.

=item * B<kbli_code.in> => I<array[str]>

Only return records where the 'kbli_code' field is in the specified values.

=item * B<kbli_code.is> => I<str>

Only return records where the 'kbli_code' field equals specified value.

=item * B<kbli_code.isnt> => I<str>

Only return records where the 'kbli_code' field does not equal specified value.

=item * B<kbli_code.matches> => I<str>

Only return records where the 'kbli_code' field matches specified regular expression pattern.

=item * B<kbli_code.max> => I<str>

Only return records where the 'kbli_code' field is less than or equal to specified value.

=item * B<kbli_code.min> => I<str>

Only return records where the 'kbli_code' field is greater than or equal to specified value.

=item * B<kbli_code.not_contains> => I<str>

Only return records where the 'kbli_code' field does not contain specified text.

=item * B<kbli_code.not_in> => I<array[str]>

Only return records where the 'kbli_code' field is not in the specified values.

=item * B<kbli_code.not_matches> => I<str>

Only return records where the 'kbli_code' field does not match specified regular expression.

=item * B<kbli_code.xmax> => I<str>

Only return records where the 'kbli_code' field is less than specified value.

=item * B<kbli_code.xmin> => I<str>

Only return records where the 'kbli_code' field is greater than specified value.

=item * B<mod_price> => I<float>

Only return records where the 'mod_price' field equals specified value.

=item * B<mod_price.in> => I<array[float]>

Only return records where the 'mod_price' field is in the specified values.

=item * B<mod_price.is> => I<float>

Only return records where the 'mod_price' field equals specified value.

=item * B<mod_price.isnt> => I<float>

Only return records where the 'mod_price' field does not equal specified value.

=item * B<mod_price.max> => I<float>

Only return records where the 'mod_price' field is less than or equal to specified value.

=item * B<mod_price.min> => I<float>

Only return records where the 'mod_price' field is greater than or equal to specified value.

=item * B<mod_price.not_in> => I<array[float]>

Only return records where the 'mod_price' field is not in the specified values.

=item * B<mod_price.xmax> => I<float>

Only return records where the 'mod_price' field is less than specified value.

=item * B<mod_price.xmin> => I<float>

Only return records where the 'mod_price' field is greater than specified value.

=item * B<new_reg_price> => I<float>

Only return records where the 'new_reg_price' field equals specified value.

=item * B<new_reg_price.in> => I<array[float]>

Only return records where the 'new_reg_price' field is in the specified values.

=item * B<new_reg_price.is> => I<float>

Only return records where the 'new_reg_price' field equals specified value.

=item * B<new_reg_price.isnt> => I<float>

Only return records where the 'new_reg_price' field does not equal specified value.

=item * B<new_reg_price.max> => I<float>

Only return records where the 'new_reg_price' field is less than or equal to specified value.

=item * B<new_reg_price.min> => I<float>

Only return records where the 'new_reg_price' field is greater than or equal to specified value.

=item * B<new_reg_price.not_in> => I<array[float]>

Only return records where the 'new_reg_price' field is not in the specified values.

=item * B<new_reg_price.xmax> => I<float>

Only return records where the 'new_reg_price' field is less than specified value.

=item * B<new_reg_price.xmin> => I<float>

Only return records where the 'new_reg_price' field is greater than specified value.

=item * B<queries> => I<array[str]>

Search.

This will search all searchable fields with one or more specified queries. Each
query can be in the form of C<-FOO> (dash prefix notation) to require that the
fields do not contain specified string, or C</FOO/> to use regular expression.
All queries must match if the C<query_boolean> option is set to C<and>; only one
query should match if the C<query_boolean> option is set to C<or>.

=item * B<query_boolean> => I<str> (default: "and")

Whether records must match all search queries ('and') or just one ('or').

If set to C<and>, all queries must match; if set to C<or>, only one query should
match. See the C<queries> option for more details on searching.

=item * B<random> => I<bool> (default: 0)

Return records in random order.

=item * B<rereg_price> => I<float>

Only return records where the 'rereg_price' field equals specified value.

=item * B<rereg_price.in> => I<array[float]>

Only return records where the 'rereg_price' field is in the specified values.

=item * B<rereg_price.is> => I<float>

Only return records where the 'rereg_price' field equals specified value.

=item * B<rereg_price.isnt> => I<float>

Only return records where the 'rereg_price' field does not equal specified value.

=item * B<rereg_price.max> => I<float>

Only return records where the 'rereg_price' field is less than or equal to specified value.

=item * B<rereg_price.min> => I<float>

Only return records where the 'rereg_price' field is greater than or equal to specified value.

=item * B<rereg_price.not_in> => I<array[float]>

Only return records where the 'rereg_price' field is not in the specified values.

=item * B<rereg_price.xmax> => I<float>

Only return records where the 'rereg_price' field is less than specified value.

=item * B<rereg_price.xmin> => I<float>

Only return records where the 'rereg_price' field is greater than specified value.

=item * B<result_limit> => I<int>

Only return a certain number of records.

=item * B<result_start> => I<int> (default: 1)

Only return starting from the n'th record.

=item * B<sort> => I<array[str]>

Order records according to certain field(s).

A list of field names separated by comma. Each field can be prefixed with '-' to
specify descending order instead of the default ascending.

=item * B<status> => I<str>

Only return records where the 'status' field equals specified value.

=item * B<status.contains> => I<str>

Only return records where the 'status' field contains specified text.

=item * B<status.in> => I<array[str]>

Only return records where the 'status' field is in the specified values.

=item * B<status.is> => I<str>

Only return records where the 'status' field equals specified value.

=item * B<status.isnt> => I<str>

Only return records where the 'status' field does not equal specified value.

=item * B<status.matches> => I<str>

Only return records where the 'status' field matches specified regular expression pattern.

=item * B<status.max> => I<str>

Only return records where the 'status' field is less than or equal to specified value.

=item * B<status.min> => I<str>

Only return records where the 'status' field is greater than or equal to specified value.

=item * B<status.not_contains> => I<str>

Only return records where the 'status' field does not contain specified text.

=item * B<status.not_in> => I<array[str]>

Only return records where the 'status' field is not in the specified values.

=item * B<status.not_matches> => I<str>

Only return records where the 'status' field does not match specified regular expression.

=item * B<status.xmax> => I<str>

Only return records where the 'status' field is less than specified value.

=item * B<status.xmin> => I<str>

Only return records where the 'status' field is greater than specified value.

=item * B<with_field_names> => I<bool>

Return field names in each record (as hashE<sol>associative array).

When enabled, function will return each record as hash/associative array
(field name => value pairs). Otherwise, function will return each record
as list/array (field value, field value, ...).


=back

Returns an enveloped result (an array).

First element ($status_code) is an integer containing HTTP-like status code
(200 means OK, 4xx caller error, 5xx function error). Second element
($reason) is a string containing error message, or something like "OK" if status is
200. Third element ($payload) is the actual result, but usually not present when enveloped result is an error response ($status_code is not 2xx). Fourth
element (%result_meta) is called result metadata and is optional, a hash
that contains extra information, much like how HTTP response headers provide additional metadata.

Return value:  (any)

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/App-BPOMUtils-Table-FoodType>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-App-BPOMUtils-Table-FoodType>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2025 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=App-BPOMUtils-Table-FoodType>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
