/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.Attribute;
import au.id.jericho.lib.html.Attributes;
import au.id.jericho.lib.html.Element;
import au.id.jericho.lib.html.FormControlType;
import au.id.jericho.lib.html.FormField;
import au.id.jericho.lib.html.Segment;
import au.id.jericho.lib.html.StartTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class FormFields {
    private HashMap map = new HashMap();
    private ArrayList list = new ArrayList();

    private FormFields() {
    }

    static FormFields construct(Segment segment) {
        FormFields formFields = new FormFields();
        formFields.loadInputControls(segment);
        formFields.loadTextAreaControls(segment);
        formFields.loadButtonControls(segment);
        formFields.loadSelectControls(segment);
        Collections.sort(formFields.list, FormField.COMPARATOR);
        return formFields;
    }

    public int getCount() {
        return this.list.size();
    }

    public int size() {
        return this.getCount();
    }

    public FormField get(String string) {
        return (FormField)this.map.get(string.toLowerCase());
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    public void merge(FormFields formFields) {
        Iterator iterator = formFields.iterator();
        while (iterator.hasNext()) {
            FormField formField = (FormField)iterator.next();
            String string = formField.getName();
            FormField formField2 = this.get(string);
            if (formField2 == null) {
                this.add(formField);
                continue;
            }
            formField2.merge(formField);
        }
        Collections.sort(this.list, FormField.COMPARATOR);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
        }
        return stringBuffer.toString();
    }

    private void add(FormField formField) {
        this.map.put(formField.getName().toLowerCase(), formField);
        this.list.add(formField);
    }

    private void loadInputControls(Segment segment) {
        Iterator iterator = segment.findAllStartTags("input").iterator();
        while (iterator.hasNext()) {
            Object object;
            FormControlType formControlType;
            StartTag startTag = (StartTag)iterator.next();
            Attributes attributes = startTag.getAttributes();
            Attribute attribute = attributes.get("name");
            if (attribute == null || (formControlType = startTag.getFormControlType()) == null) continue;
            String string = null;
            if (formControlType.isPredefinedValue() && (object = attributes.get("value")) != null) {
                string = ((Attribute)object).getValue();
            }
            object = attribute.getValue();
            this.registerField((String)object, startTag.begin, string, formControlType);
            String[] stringArray = formControlType.getAdditionalSubmitNames((String)object);
            if (stringArray == null) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                this.registerUserValueField(stringArray[i], startTag.begin);
            }
        }
    }

    private void loadTextAreaControls(Segment segment) {
        Iterator iterator = segment.findAllStartTags("textarea").iterator();
        while (iterator.hasNext()) {
            StartTag startTag = (StartTag)iterator.next();
            Attributes attributes = startTag.getAttributes();
            Attribute attribute = attributes.get("name");
            if (attribute == null) continue;
            String string = attribute.getValue();
            this.registerUserValueField(string, startTag.begin);
        }
    }

    private void loadButtonControls(Segment segment) {
        Iterator iterator = segment.findAllStartTags("button").iterator();
        while (iterator.hasNext()) {
            Attributes attributes;
            Attribute attribute;
            StartTag startTag = (StartTag)iterator.next();
            FormControlType formControlType = startTag.getFormControlType();
            if (formControlType == null || (attribute = (attributes = startTag.getAttributes()).get("name")) == null) continue;
            String string = attribute.getValue();
            String string2 = null;
            Attribute attribute2 = attributes.get("value");
            if (attribute2 != null) {
                string2 = attribute2.getValue();
            }
            this.registerField(string, startTag.begin, string2, formControlType);
        }
    }

    private void loadSelectControls(Segment segment) {
        List list = segment.findAllElements("select");
        if (list.isEmpty()) {
            return;
        }
        List list2 = segment.findAllStartTags("option");
        if (list2.isEmpty()) {
            return;
        }
        Iterator iterator = list.iterator();
        Element element = (Element)iterator.next();
        Element element2 = null;
        String string = null;
        FormControlType formControlType = null;
        Iterator iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            Attribute attribute;
            Object object;
            StartTag startTag = (StartTag)iterator2.next();
            while (startTag.begin > element.end) {
                if (!iterator.hasNext()) {
                    return;
                }
                element = (Element)iterator.next();
            }
            if (element != element2) {
                if (startTag.begin < element.begin) continue;
                object = element.getStartTag();
                formControlType = ((StartTag)object).getFormControlType();
                if (formControlType == null) {
                    throw new RuntimeException("Internal Error: FormControlType not recognised for select tag " + object);
                }
                attribute = ((StartTag)object).getAttributes().get("name");
                if (attribute == null) {
                    if (!iterator.hasNext()) {
                        return;
                    }
                    element = (Element)iterator.next();
                    element2 = null;
                    continue;
                }
                string = attribute.getValue();
                if (string == null) continue;
            }
            element2 = element;
            attribute = startTag.getAttributes().get("value");
            if (attribute != null) {
                object = attribute.getValue();
            } else {
                Segment segment2 = startTag.getFollowingTextSegment();
                object = segment2.getSourceTextNoWhitespace();
                if (((String)object).length() == 0) continue;
            }
            this.registerPredefinedValueField(string, element.begin, (String)object, formControlType);
        }
    }

    private void registerField(String string, int n, String string2, FormControlType formControlType) {
        if (string2 == null) {
            this.registerUserValueField(string, n);
        } else {
            this.registerPredefinedValueField(string, n, string2, formControlType);
        }
    }

    private void registerUserValueField(String string, int n) {
        FormField formField = this.get(string);
        if (formField == null) {
            formField = new FormField(string, n, null);
            this.add(formField);
        } else {
            formField.setMultipleValues();
            formField.setLowerPosition(n);
        }
        formField.incrementUserValueCount();
    }

    private void registerPredefinedValueField(String string, int n, String string2, FormControlType formControlType) {
        FormField formField = this.get(string);
        if (formField == null) {
            formField = new FormField(string, n, formControlType);
            this.add(formField);
        } else {
            formField.setMultipleValues(formControlType);
            formField.setLowerPosition(n);
        }
        formField.addPredefinedValue(string2);
    }
}

