use strict;
use warnings;
use utf8;

use FindBin;
use lib ("lib", "$FindBin::Bin/../blib/lib", "$FindBin::Bin/../blib/arch");

use Lingua::RU::Money::XS qw(rur2words);
use Test::Spec;

describe "Convert rubles to word, amount: " => sub {
	it "1.00" => sub { is rur2words(1.00), "один рубль 00 копеек"; };
	it "2.00" => sub { is rur2words(2.00), "два рубля 00 копеек"; };
	it "3.00" => sub { is rur2words(3.00), "три рубля 00 копеек"; };
	it "4.00" => sub { is rur2words(4.00), "четыре рубля 00 копеек"; };
	it "5.00" => sub { is rur2words(5.00), "пять рублей 00 копеек"; };
	it "6.00" => sub { is rur2words(6.00), "шесть рублей 00 копеек"; };
	it "7.00" => sub { is rur2words(7.00), "семь рублей 00 копеек"; };
	it "8.00" => sub { is rur2words(8.00), "восемь рублей 00 копеек"; };
	it "9.00" => sub { is rur2words(9.00), "девять рублей 00 копеек"; };
	it "10.00" => sub { is rur2words(10.00), "десять рублей 00 копеек"; };
	it "11.00" => sub { is rur2words(11.00), "одиннадцать рублей 00 копеек"; };
	it "12.00" => sub { is rur2words(12.00), "двенадцать рублей 00 копеек"; };
	it "13.00" => sub { is rur2words(13.00), "тринадцать рублей 00 копеек"; };
	it "14.00" => sub { is rur2words(14.00), "четырнадцать рублей 00 копеек"; };
	it "15.00" => sub { is rur2words(15.00), "пятнадцать рублей 00 копеек"; };
	it "16.00" => sub { is rur2words(16.00), "шестнадцать рублей 00 копеек"; };
	it "17.00" => sub { is rur2words(17.00), "семнадцать рублей 00 копеек"; };
	it "18.00" => sub { is rur2words(18.00), "восемнадцать рублей 00 копеек"; };
	it "19.00" => sub { is rur2words(19.00), "девятнадцать рублей 00 копеек"; };
	it "20.00" => sub { is rur2words(20.00), "двадцать рублей 00 копеек"; };
	it "21.00" => sub { is rur2words(21.00), "двадцать один рубль 00 копеек"; };
	it "22.00" => sub { is rur2words(22.00), "двадцать два рубля 00 копеек"; };
	it "23.00" => sub { is rur2words(23.00), "двадцать три рубля 00 копеек"; };
	it "24.00" => sub { is rur2words(24.00), "двадцать четыре рубля 00 копеек"; };
	it "25.00" => sub { is rur2words(25.00), "двадцать пять рублей 00 копеек"; };
	it "26.00" => sub { is rur2words(26.00), "двадцать шесть рублей 00 копеек"; };
	it "27.00" => sub { is rur2words(27.00), "двадцать семь рублей 00 копеек"; };
	it "28.00" => sub { is rur2words(28.00), "двадцать восемь рублей 00 копеек"; };
	it "29.00" => sub { is rur2words(29.00), "двадцать девять рублей 00 копеек"; };
	it "30.00" => sub { is rur2words(30.00), "тридцать рублей 00 копеек"; };
	it "31.00" => sub { is rur2words(31.00), "тридцать один рубль 00 копеек"; };
	it "32.00" => sub { is rur2words(32.00), "тридцать два рубля 00 копеек"; };
	it "33.00" => sub { is rur2words(33.00), "тридцать три рубля 00 копеек"; };
	it "34.00" => sub { is rur2words(34.00), "тридцать четыре рубля 00 копеек"; };
	it "35.00" => sub { is rur2words(35.00), "тридцать пять рублей 00 копеек"; };
	it "36.00" => sub { is rur2words(36.00), "тридцать шесть рублей 00 копеек"; };
	it "37.00" => sub { is rur2words(37.00), "тридцать семь рублей 00 копеек"; };
	it "38.00" => sub { is rur2words(38.00), "тридцать восемь рублей 00 копеек"; };
	it "39.00" => sub { is rur2words(39.00), "тридцать девять рублей 00 копеек"; };
	it "40.00" => sub { is rur2words(40.00), "сорок рублей 00 копеек"; };
	it "41.00" => sub { is rur2words(41.00), "сорок один рубль 00 копеек"; };
	it "42.00" => sub { is rur2words(42.00), "сорок два рубля 00 копеек"; };
	it "43.00" => sub { is rur2words(43.00), "сорок три рубля 00 копеек"; };
	it "44.00" => sub { is rur2words(44.00), "сорок четыре рубля 00 копеек"; };
	it "45.00" => sub { is rur2words(45.00), "сорок пять рублей 00 копеек"; };
	it "46.00" => sub { is rur2words(46.00), "сорок шесть рублей 00 копеек"; };
	it "47.00" => sub { is rur2words(47.00), "сорок семь рублей 00 копеек"; };
	it "48.00" => sub { is rur2words(48.00), "сорок восемь рублей 00 копеек"; };
	it "49.00" => sub { is rur2words(49.00), "сорок девять рублей 00 копеек"; };
	it "50.00" => sub { is rur2words(50.00), "пятьдесят рублей 00 копеек"; };
	it "51.00" => sub { is rur2words(51.00), "пятьдесят один рубль 00 копеек"; };
	it "52.00" => sub { is rur2words(52.00), "пятьдесят два рубля 00 копеек"; };
	it "53.00" => sub { is rur2words(53.00), "пятьдесят три рубля 00 копеек"; };
	it "54.00" => sub { is rur2words(54.00), "пятьдесят четыре рубля 00 копеек"; };
	it "55.00" => sub { is rur2words(55.00), "пятьдесят пять рублей 00 копеек"; };
	it "56.00" => sub { is rur2words(56.00), "пятьдесят шесть рублей 00 копеек"; };
	it "57.00" => sub { is rur2words(57.00), "пятьдесят семь рублей 00 копеек"; };
	it "58.00" => sub { is rur2words(58.00), "пятьдесят восемь рублей 00 копеек"; };
	it "59.00" => sub { is rur2words(59.00), "пятьдесят девять рублей 00 копеек"; };
	it "60.00" => sub { is rur2words(60.00), "шестьдесят рублей 00 копеек"; };
	it "61.00" => sub { is rur2words(61.00), "шестьдесят один рубль 00 копеек"; };
	it "62.00" => sub { is rur2words(62.00), "шестьдесят два рубля 00 копеек"; };
	it "63.00" => sub { is rur2words(63.00), "шестьдесят три рубля 00 копеек"; };
	it "64.00" => sub { is rur2words(64.00), "шестьдесят четыре рубля 00 копеек"; };
	it "65.00" => sub { is rur2words(65.00), "шестьдесят пять рублей 00 копеек"; };
	it "66.00" => sub { is rur2words(66.00), "шестьдесят шесть рублей 00 копеек"; };
	it "67.00" => sub { is rur2words(67.00), "шестьдесят семь рублей 00 копеек"; };
	it "68.00" => sub { is rur2words(68.00), "шестьдесят восемь рублей 00 копеек"; };
	it "69.00" => sub { is rur2words(69.00), "шестьдесят девять рублей 00 копеек"; };
	it "70.00" => sub { is rur2words(70.00), "семьдесят рублей 00 копеек"; };
	it "71.00" => sub { is rur2words(71.00), "семьдесят один рубль 00 копеек"; };
	it "72.00" => sub { is rur2words(72.00), "семьдесят два рубля 00 копеек"; };
	it "73.00" => sub { is rur2words(73.00), "семьдесят три рубля 00 копеек"; };
	it "74.00" => sub { is rur2words(74.00), "семьдесят четыре рубля 00 копеек"; };
	it "75.00" => sub { is rur2words(75.00), "семьдесят пять рублей 00 копеек"; };
	it "76.00" => sub { is rur2words(76.00), "семьдесят шесть рублей 00 копеек"; };
	it "77.00" => sub { is rur2words(77.00), "семьдесят семь рублей 00 копеек"; };
	it "78.00" => sub { is rur2words(78.00), "семьдесят восемь рублей 00 копеек"; };
	it "79.00" => sub { is rur2words(79.00), "семьдесят девять рублей 00 копеек"; };
	it "80.00" => sub { is rur2words(80.00), "восемьдесят рублей 00 копеек"; };
	it "81.00" => sub { is rur2words(81.00), "восемьдесят один рубль 00 копеек"; };
	it "82.00" => sub { is rur2words(82.00), "восемьдесят два рубля 00 копеек"; };
	it "83.00" => sub { is rur2words(83.00), "восемьдесят три рубля 00 копеек"; };
	it "84.00" => sub { is rur2words(84.00), "восемьдесят четыре рубля 00 копеек"; };
	it "85.00" => sub { is rur2words(85.00), "восемьдесят пять рублей 00 копеек"; };
	it "86.00" => sub { is rur2words(86.00), "восемьдесят шесть рублей 00 копеек"; };
	it "87.00" => sub { is rur2words(87.00), "восемьдесят семь рублей 00 копеек"; };
	it "88.00" => sub { is rur2words(88.00), "восемьдесят восемь рублей 00 копеек"; };
	it "89.00" => sub { is rur2words(89.00), "восемьдесят девять рублей 00 копеек"; };
	it "90.00" => sub { is rur2words(90.00), "девяносто рублей 00 копеек"; };
	it "91.00" => sub { is rur2words(91.00), "девяносто один рубль 00 копеек"; };
	it "92.00" => sub { is rur2words(92.00), "девяносто два рубля 00 копеек"; };
	it "93.00" => sub { is rur2words(93.00), "девяносто три рубля 00 копеек"; };
	it "94.00" => sub { is rur2words(94.00), "девяносто четыре рубля 00 копеек"; };
	it "95.00" => sub { is rur2words(95.00), "девяносто пять рублей 00 копеек"; };
	it "96.00" => sub { is rur2words(96.00), "девяносто шесть рублей 00 копеек"; };
	it "97.00" => sub { is rur2words(97.00), "девяносто семь рублей 00 копеек"; };
	it "98.00" => sub { is rur2words(98.00), "девяносто восемь рублей 00 копеек"; };
	it "99.00" => sub { is rur2words(99.00), "девяносто девять рублей 00 копеек"; };
	it "100.00" => sub { is rur2words(100.00), "сто рублей 00 копеек"; };
	it "101.00" => sub { is rur2words(101.00), "сто один рубль 00 копеек"; };
	it "102.00" => sub { is rur2words(102.00), "сто два рубля 00 копеек"; };
	it "103.00" => sub { is rur2words(103.00), "сто три рубля 00 копеек"; };
	it "104.00" => sub { is rur2words(104.00), "сто четыре рубля 00 копеек"; };
	it "105.00" => sub { is rur2words(105.00), "сто пять рублей 00 копеек"; };
	it "106.00" => sub { is rur2words(106.00), "сто шесть рублей 00 копеек"; };
	it "107.00" => sub { is rur2words(107.00), "сто семь рублей 00 копеек"; };
	it "108.00" => sub { is rur2words(108.00), "сто восемь рублей 00 копеек"; };
	it "109.00" => sub { is rur2words(109.00), "сто девять рублей 00 копеек"; };
	it "110.00" => sub { is rur2words(110.00), "сто десять рублей 00 копеек"; };
	it "111.00" => sub { is rur2words(111.00), "сто одиннадцать рублей 00 копеек"; };
	it "112.00" => sub { is rur2words(112.00), "сто двенадцать рублей 00 копеек"; };
	it "113.00" => sub { is rur2words(113.00), "сто тринадцать рублей 00 копеек"; };
	it "114.00" => sub { is rur2words(114.00), "сто четырнадцать рублей 00 копеек"; };
	it "115.00" => sub { is rur2words(115.00), "сто пятнадцать рублей 00 копеек"; };
	it "116.00" => sub { is rur2words(116.00), "сто шестнадцать рублей 00 копеек"; };
	it "117.00" => sub { is rur2words(117.00), "сто семнадцать рублей 00 копеек"; };
	it "118.00" => sub { is rur2words(118.00), "сто восемнадцать рублей 00 копеек"; };
	it "119.00" => sub { is rur2words(119.00), "сто девятнадцать рублей 00 копеек"; };
	it "120.00" => sub { is rur2words(120.00), "сто двадцать рублей 00 копеек"; };
	it "121.00" => sub { is rur2words(121.00), "сто двадцать один рубль 00 копеек"; };
	it "122.00" => sub { is rur2words(122.00), "сто двадцать два рубля 00 копеек"; };
	it "123.00" => sub { is rur2words(123.00), "сто двадцать три рубля 00 копеек"; };
	it "124.00" => sub { is rur2words(124.00), "сто двадцать четыре рубля 00 копеек"; };
	it "125.00" => sub { is rur2words(125.00), "сто двадцать пять рублей 00 копеек"; };
	it "126.00" => sub { is rur2words(126.00), "сто двадцать шесть рублей 00 копеек"; };
	it "127.00" => sub { is rur2words(127.00), "сто двадцать семь рублей 00 копеек"; };
	it "128.00" => sub { is rur2words(128.00), "сто двадцать восемь рублей 00 копеек"; };
	it "129.00" => sub { is rur2words(129.00), "сто двадцать девять рублей 00 копеек"; };
	it "130.00" => sub { is rur2words(130.00), "сто тридцать рублей 00 копеек"; };
	it "131.00" => sub { is rur2words(131.00), "сто тридцать один рубль 00 копеек"; };
	it "132.00" => sub { is rur2words(132.00), "сто тридцать два рубля 00 копеек"; };
	it "133.00" => sub { is rur2words(133.00), "сто тридцать три рубля 00 копеек"; };
	it "134.00" => sub { is rur2words(134.00), "сто тридцать четыре рубля 00 копеек"; };
	it "135.00" => sub { is rur2words(135.00), "сто тридцать пять рублей 00 копеек"; };
	it "136.00" => sub { is rur2words(136.00), "сто тридцать шесть рублей 00 копеек"; };
	it "137.00" => sub { is rur2words(137.00), "сто тридцать семь рублей 00 копеек"; };
	it "138.00" => sub { is rur2words(138.00), "сто тридцать восемь рублей 00 копеек"; };
	it "139.00" => sub { is rur2words(139.00), "сто тридцать девять рублей 00 копеек"; };
	it "140.00" => sub { is rur2words(140.00), "сто сорок рублей 00 копеек"; };
	it "141.00" => sub { is rur2words(141.00), "сто сорок один рубль 00 копеек"; };
	it "142.00" => sub { is rur2words(142.00), "сто сорок два рубля 00 копеек"; };
	it "143.00" => sub { is rur2words(143.00), "сто сорок три рубля 00 копеек"; };
	it "144.00" => sub { is rur2words(144.00), "сто сорок четыре рубля 00 копеек"; };
	it "145.00" => sub { is rur2words(145.00), "сто сорок пять рублей 00 копеек"; };
	it "146.00" => sub { is rur2words(146.00), "сто сорок шесть рублей 00 копеек"; };
	it "147.00" => sub { is rur2words(147.00), "сто сорок семь рублей 00 копеек"; };
	it "148.00" => sub { is rur2words(148.00), "сто сорок восемь рублей 00 копеек"; };
	it "149.00" => sub { is rur2words(149.00), "сто сорок девять рублей 00 копеек"; };
	it "150.00" => sub { is rur2words(150.00), "сто пятьдесят рублей 00 копеек"; };
	it "151.00" => sub { is rur2words(151.00), "сто пятьдесят один рубль 00 копеек"; };
	it "152.00" => sub { is rur2words(152.00), "сто пятьдесят два рубля 00 копеек"; };
	it "153.00" => sub { is rur2words(153.00), "сто пятьдесят три рубля 00 копеек"; };
	it "154.00" => sub { is rur2words(154.00), "сто пятьдесят четыре рубля 00 копеек"; };
	it "155.00" => sub { is rur2words(155.00), "сто пятьдесят пять рублей 00 копеек"; };
	it "156.00" => sub { is rur2words(156.00), "сто пятьдесят шесть рублей 00 копеек"; };
	it "157.00" => sub { is rur2words(157.00), "сто пятьдесят семь рублей 00 копеек"; };
	it "158.00" => sub { is rur2words(158.00), "сто пятьдесят восемь рублей 00 копеек"; };
	it "159.00" => sub { is rur2words(159.00), "сто пятьдесят девять рублей 00 копеек"; };
	it "160.00" => sub { is rur2words(160.00), "сто шестьдесят рублей 00 копеек"; };
	it "161.00" => sub { is rur2words(161.00), "сто шестьдесят один рубль 00 копеек"; };
	it "162.00" => sub { is rur2words(162.00), "сто шестьдесят два рубля 00 копеек"; };
	it "163.00" => sub { is rur2words(163.00), "сто шестьдесят три рубля 00 копеек"; };
	it "164.00" => sub { is rur2words(164.00), "сто шестьдесят четыре рубля 00 копеек"; };
	it "165.00" => sub { is rur2words(165.00), "сто шестьдесят пять рублей 00 копеек"; };
	it "166.00" => sub { is rur2words(166.00), "сто шестьдесят шесть рублей 00 копеек"; };
	it "167.00" => sub { is rur2words(167.00), "сто шестьдесят семь рублей 00 копеек"; };
	it "168.00" => sub { is rur2words(168.00), "сто шестьдесят восемь рублей 00 копеек"; };
	it "169.00" => sub { is rur2words(169.00), "сто шестьдесят девять рублей 00 копеек"; };
	it "170.00" => sub { is rur2words(170.00), "сто семьдесят рублей 00 копеек"; };
	it "171.00" => sub { is rur2words(171.00), "сто семьдесят один рубль 00 копеек"; };
	it "172.00" => sub { is rur2words(172.00), "сто семьдесят два рубля 00 копеек"; };
	it "173.00" => sub { is rur2words(173.00), "сто семьдесят три рубля 00 копеек"; };
	it "174.00" => sub { is rur2words(174.00), "сто семьдесят четыре рубля 00 копеек"; };
	it "175.00" => sub { is rur2words(175.00), "сто семьдесят пять рублей 00 копеек"; };
	it "176.00" => sub { is rur2words(176.00), "сто семьдесят шесть рублей 00 копеек"; };
	it "177.00" => sub { is rur2words(177.00), "сто семьдесят семь рублей 00 копеек"; };
	it "178.00" => sub { is rur2words(178.00), "сто семьдесят восемь рублей 00 копеек"; };
	it "179.00" => sub { is rur2words(179.00), "сто семьдесят девять рублей 00 копеек"; };
	it "180.00" => sub { is rur2words(180.00), "сто восемьдесят рублей 00 копеек"; };
	it "181.00" => sub { is rur2words(181.00), "сто восемьдесят один рубль 00 копеек"; };
	it "182.00" => sub { is rur2words(182.00), "сто восемьдесят два рубля 00 копеек"; };
	it "183.00" => sub { is rur2words(183.00), "сто восемьдесят три рубля 00 копеек"; };
	it "184.00" => sub { is rur2words(184.00), "сто восемьдесят четыре рубля 00 копеек"; };
	it "185.00" => sub { is rur2words(185.00), "сто восемьдесят пять рублей 00 копеек"; };
	it "186.00" => sub { is rur2words(186.00), "сто восемьдесят шесть рублей 00 копеек"; };
	it "187.00" => sub { is rur2words(187.00), "сто восемьдесят семь рублей 00 копеек"; };
	it "188.00" => sub { is rur2words(188.00), "сто восемьдесят восемь рублей 00 копеек"; };
	it "189.00" => sub { is rur2words(189.00), "сто восемьдесят девять рублей 00 копеек"; };
	it "190.00" => sub { is rur2words(190.00), "сто девяносто рублей 00 копеек"; };
	it "191.00" => sub { is rur2words(191.00), "сто девяносто один рубль 00 копеек"; };
	it "192.00" => sub { is rur2words(192.00), "сто девяносто два рубля 00 копеек"; };
	it "193.00" => sub { is rur2words(193.00), "сто девяносто три рубля 00 копеек"; };
	it "194.00" => sub { is rur2words(194.00), "сто девяносто четыре рубля 00 копеек"; };
	it "195.00" => sub { is rur2words(195.00), "сто девяносто пять рублей 00 копеек"; };
	it "196.00" => sub { is rur2words(196.00), "сто девяносто шесть рублей 00 копеек"; };
	it "197.00" => sub { is rur2words(197.00), "сто девяносто семь рублей 00 копеек"; };
	it "198.00" => sub { is rur2words(198.00), "сто девяносто восемь рублей 00 копеек"; };
	it "199.00" => sub { is rur2words(199.00), "сто девяносто девять рублей 00 копеек"; };
	it "200.00" => sub { is rur2words(200.00), "двести рублей 00 копеек"; };
	it "201.00" => sub { is rur2words(201.00), "двести один рубль 00 копеек"; };
	it "202.00" => sub { is rur2words(202.00), "двести два рубля 00 копеек"; };
	it "203.00" => sub { is rur2words(203.00), "двести три рубля 00 копеек"; };
	it "204.00" => sub { is rur2words(204.00), "двести четыре рубля 00 копеек"; };
	it "205.00" => sub { is rur2words(205.00), "двести пять рублей 00 копеек"; };
	it "206.00" => sub { is rur2words(206.00), "двести шесть рублей 00 копеек"; };
	it "207.00" => sub { is rur2words(207.00), "двести семь рублей 00 копеек"; };
	it "208.00" => sub { is rur2words(208.00), "двести восемь рублей 00 копеек"; };
	it "209.00" => sub { is rur2words(209.00), "двести девять рублей 00 копеек"; };
	it "210.00" => sub { is rur2words(210.00), "двести десять рублей 00 копеек"; };
	it "211.00" => sub { is rur2words(211.00), "двести одиннадцать рублей 00 копеек"; };
	it "212.00" => sub { is rur2words(212.00), "двести двенадцать рублей 00 копеек"; };
	it "213.00" => sub { is rur2words(213.00), "двести тринадцать рублей 00 копеек"; };
	it "214.00" => sub { is rur2words(214.00), "двести четырнадцать рублей 00 копеек"; };
	it "215.00" => sub { is rur2words(215.00), "двести пятнадцать рублей 00 копеек"; };
	it "216.00" => sub { is rur2words(216.00), "двести шестнадцать рублей 00 копеек"; };
	it "217.00" => sub { is rur2words(217.00), "двести семнадцать рублей 00 копеек"; };
	it "218.00" => sub { is rur2words(218.00), "двести восемнадцать рублей 00 копеек"; };
	it "219.00" => sub { is rur2words(219.00), "двести девятнадцать рублей 00 копеек"; };
	it "220.00" => sub { is rur2words(220.00), "двести двадцать рублей 00 копеек"; };
	it "221.00" => sub { is rur2words(221.00), "двести двадцать один рубль 00 копеек"; };
	it "222.00" => sub { is rur2words(222.00), "двести двадцать два рубля 00 копеек"; };
	it "223.00" => sub { is rur2words(223.00), "двести двадцать три рубля 00 копеек"; };
	it "224.00" => sub { is rur2words(224.00), "двести двадцать четыре рубля 00 копеек"; };
	it "225.00" => sub { is rur2words(225.00), "двести двадцать пять рублей 00 копеек"; };
	it "226.00" => sub { is rur2words(226.00), "двести двадцать шесть рублей 00 копеек"; };
	it "227.00" => sub { is rur2words(227.00), "двести двадцать семь рублей 00 копеек"; };
	it "228.00" => sub { is rur2words(228.00), "двести двадцать восемь рублей 00 копеек"; };
	it "229.00" => sub { is rur2words(229.00), "двести двадцать девять рублей 00 копеек"; };
	it "230.00" => sub { is rur2words(230.00), "двести тридцать рублей 00 копеек"; };
	it "231.00" => sub { is rur2words(231.00), "двести тридцать один рубль 00 копеек"; };
	it "232.00" => sub { is rur2words(232.00), "двести тридцать два рубля 00 копеек"; };
	it "233.00" => sub { is rur2words(233.00), "двести тридцать три рубля 00 копеек"; };
	it "234.00" => sub { is rur2words(234.00), "двести тридцать четыре рубля 00 копеек"; };
	it "235.00" => sub { is rur2words(235.00), "двести тридцать пять рублей 00 копеек"; };
	it "236.00" => sub { is rur2words(236.00), "двести тридцать шесть рублей 00 копеек"; };
	it "237.00" => sub { is rur2words(237.00), "двести тридцать семь рублей 00 копеек"; };
	it "238.00" => sub { is rur2words(238.00), "двести тридцать восемь рублей 00 копеек"; };
	it "239.00" => sub { is rur2words(239.00), "двести тридцать девять рублей 00 копеек"; };
	it "240.00" => sub { is rur2words(240.00), "двести сорок рублей 00 копеек"; };
	it "241.00" => sub { is rur2words(241.00), "двести сорок один рубль 00 копеек"; };
	it "242.00" => sub { is rur2words(242.00), "двести сорок два рубля 00 копеек"; };
	it "243.00" => sub { is rur2words(243.00), "двести сорок три рубля 00 копеек"; };
	it "244.00" => sub { is rur2words(244.00), "двести сорок четыре рубля 00 копеек"; };
	it "245.00" => sub { is rur2words(245.00), "двести сорок пять рублей 00 копеек"; };
	it "246.00" => sub { is rur2words(246.00), "двести сорок шесть рублей 00 копеек"; };
	it "247.00" => sub { is rur2words(247.00), "двести сорок семь рублей 00 копеек"; };
	it "248.00" => sub { is rur2words(248.00), "двести сорок восемь рублей 00 копеек"; };
	it "249.00" => sub { is rur2words(249.00), "двести сорок девять рублей 00 копеек"; };
	it "250.00" => sub { is rur2words(250.00), "двести пятьдесят рублей 00 копеек"; };
	it "251.00" => sub { is rur2words(251.00), "двести пятьдесят один рубль 00 копеек"; };
	it "252.00" => sub { is rur2words(252.00), "двести пятьдесят два рубля 00 копеек"; };
	it "253.00" => sub { is rur2words(253.00), "двести пятьдесят три рубля 00 копеек"; };
	it "254.00" => sub { is rur2words(254.00), "двести пятьдесят четыре рубля 00 копеек"; };
	it "255.00" => sub { is rur2words(255.00), "двести пятьдесят пять рублей 00 копеек"; };
	it "256.00" => sub { is rur2words(256.00), "двести пятьдесят шесть рублей 00 копеек"; };
	it "257.00" => sub { is rur2words(257.00), "двести пятьдесят семь рублей 00 копеек"; };
	it "258.00" => sub { is rur2words(258.00), "двести пятьдесят восемь рублей 00 копеек"; };
	it "259.00" => sub { is rur2words(259.00), "двести пятьдесят девять рублей 00 копеек"; };
	it "260.00" => sub { is rur2words(260.00), "двести шестьдесят рублей 00 копеек"; };
	it "261.00" => sub { is rur2words(261.00), "двести шестьдесят один рубль 00 копеек"; };
	it "262.00" => sub { is rur2words(262.00), "двести шестьдесят два рубля 00 копеек"; };
	it "263.00" => sub { is rur2words(263.00), "двести шестьдесят три рубля 00 копеек"; };
	it "264.00" => sub { is rur2words(264.00), "двести шестьдесят четыре рубля 00 копеек"; };
	it "265.00" => sub { is rur2words(265.00), "двести шестьдесят пять рублей 00 копеек"; };
	it "266.00" => sub { is rur2words(266.00), "двести шестьдесят шесть рублей 00 копеек"; };
	it "267.00" => sub { is rur2words(267.00), "двести шестьдесят семь рублей 00 копеек"; };
	it "268.00" => sub { is rur2words(268.00), "двести шестьдесят восемь рублей 00 копеек"; };
	it "269.00" => sub { is rur2words(269.00), "двести шестьдесят девять рублей 00 копеек"; };
	it "270.00" => sub { is rur2words(270.00), "двести семьдесят рублей 00 копеек"; };
	it "271.00" => sub { is rur2words(271.00), "двести семьдесят один рубль 00 копеек"; };
	it "272.00" => sub { is rur2words(272.00), "двести семьдесят два рубля 00 копеек"; };
	it "273.00" => sub { is rur2words(273.00), "двести семьдесят три рубля 00 копеек"; };
	it "274.00" => sub { is rur2words(274.00), "двести семьдесят четыре рубля 00 копеек"; };
	it "275.00" => sub { is rur2words(275.00), "двести семьдесят пять рублей 00 копеек"; };
	it "276.00" => sub { is rur2words(276.00), "двести семьдесят шесть рублей 00 копеек"; };
	it "277.00" => sub { is rur2words(277.00), "двести семьдесят семь рублей 00 копеек"; };
	it "278.00" => sub { is rur2words(278.00), "двести семьдесят восемь рублей 00 копеек"; };
	it "279.00" => sub { is rur2words(279.00), "двести семьдесят девять рублей 00 копеек"; };
	it "280.00" => sub { is rur2words(280.00), "двести восемьдесят рублей 00 копеек"; };
	it "281.00" => sub { is rur2words(281.00), "двести восемьдесят один рубль 00 копеек"; };
	it "282.00" => sub { is rur2words(282.00), "двести восемьдесят два рубля 00 копеек"; };
	it "283.00" => sub { is rur2words(283.00), "двести восемьдесят три рубля 00 копеек"; };
	it "284.00" => sub { is rur2words(284.00), "двести восемьдесят четыре рубля 00 копеек"; };
	it "285.00" => sub { is rur2words(285.00), "двести восемьдесят пять рублей 00 копеек"; };
	it "286.00" => sub { is rur2words(286.00), "двести восемьдесят шесть рублей 00 копеек"; };
	it "287.00" => sub { is rur2words(287.00), "двести восемьдесят семь рублей 00 копеек"; };
	it "288.00" => sub { is rur2words(288.00), "двести восемьдесят восемь рублей 00 копеек"; };
	it "289.00" => sub { is rur2words(289.00), "двести восемьдесят девять рублей 00 копеек"; };
	it "290.00" => sub { is rur2words(290.00), "двести девяносто рублей 00 копеек"; };
	it "291.00" => sub { is rur2words(291.00), "двести девяносто один рубль 00 копеек"; };
	it "292.00" => sub { is rur2words(292.00), "двести девяносто два рубля 00 копеек"; };
	it "293.00" => sub { is rur2words(293.00), "двести девяносто три рубля 00 копеек"; };
	it "294.00" => sub { is rur2words(294.00), "двести девяносто четыре рубля 00 копеек"; };
	it "295.00" => sub { is rur2words(295.00), "двести девяносто пять рублей 00 копеек"; };
	it "296.00" => sub { is rur2words(296.00), "двести девяносто шесть рублей 00 копеек"; };
	it "297.00" => sub { is rur2words(297.00), "двести девяносто семь рублей 00 копеек"; };
	it "298.00" => sub { is rur2words(298.00), "двести девяносто восемь рублей 00 копеек"; };
	it "299.00" => sub { is rur2words(299.00), "двести девяносто девять рублей 00 копеек"; };
	it "300.00" => sub { is rur2words(300.00), "триста рублей 00 копеек"; };
	it "301.00" => sub { is rur2words(301.00), "триста один рубль 00 копеек"; };
	it "302.00" => sub { is rur2words(302.00), "триста два рубля 00 копеек"; };
	it "303.00" => sub { is rur2words(303.00), "триста три рубля 00 копеек"; };
	it "304.00" => sub { is rur2words(304.00), "триста четыре рубля 00 копеек"; };
	it "305.00" => sub { is rur2words(305.00), "триста пять рублей 00 копеек"; };
	it "306.00" => sub { is rur2words(306.00), "триста шесть рублей 00 копеек"; };
	it "307.00" => sub { is rur2words(307.00), "триста семь рублей 00 копеек"; };
	it "308.00" => sub { is rur2words(308.00), "триста восемь рублей 00 копеек"; };
	it "309.00" => sub { is rur2words(309.00), "триста девять рублей 00 копеек"; };
	it "310.00" => sub { is rur2words(310.00), "триста десять рублей 00 копеек"; };
	it "311.00" => sub { is rur2words(311.00), "триста одиннадцать рублей 00 копеек"; };
	it "312.00" => sub { is rur2words(312.00), "триста двенадцать рублей 00 копеек"; };
	it "313.00" => sub { is rur2words(313.00), "триста тринадцать рублей 00 копеек"; };
	it "314.00" => sub { is rur2words(314.00), "триста четырнадцать рублей 00 копеек"; };
	it "315.00" => sub { is rur2words(315.00), "триста пятнадцать рублей 00 копеек"; };
	it "316.00" => sub { is rur2words(316.00), "триста шестнадцать рублей 00 копеек"; };
	it "317.00" => sub { is rur2words(317.00), "триста семнадцать рублей 00 копеек"; };
	it "318.00" => sub { is rur2words(318.00), "триста восемнадцать рублей 00 копеек"; };
	it "319.00" => sub { is rur2words(319.00), "триста девятнадцать рублей 00 копеек"; };
	it "320.00" => sub { is rur2words(320.00), "триста двадцать рублей 00 копеек"; };
	it "321.00" => sub { is rur2words(321.00), "триста двадцать один рубль 00 копеек"; };
	it "322.00" => sub { is rur2words(322.00), "триста двадцать два рубля 00 копеек"; };
	it "323.00" => sub { is rur2words(323.00), "триста двадцать три рубля 00 копеек"; };
	it "324.00" => sub { is rur2words(324.00), "триста двадцать четыре рубля 00 копеек"; };
	it "325.00" => sub { is rur2words(325.00), "триста двадцать пять рублей 00 копеек"; };
	it "326.00" => sub { is rur2words(326.00), "триста двадцать шесть рублей 00 копеек"; };
	it "327.00" => sub { is rur2words(327.00), "триста двадцать семь рублей 00 копеек"; };
	it "328.00" => sub { is rur2words(328.00), "триста двадцать восемь рублей 00 копеек"; };
	it "329.00" => sub { is rur2words(329.00), "триста двадцать девять рублей 00 копеек"; };
	it "330.00" => sub { is rur2words(330.00), "триста тридцать рублей 00 копеек"; };
	it "331.00" => sub { is rur2words(331.00), "триста тридцать один рубль 00 копеек"; };
	it "332.00" => sub { is rur2words(332.00), "триста тридцать два рубля 00 копеек"; };
	it "333.00" => sub { is rur2words(333.00), "триста тридцать три рубля 00 копеек"; };
	it "334.00" => sub { is rur2words(334.00), "триста тридцать четыре рубля 00 копеек"; };
	it "335.00" => sub { is rur2words(335.00), "триста тридцать пять рублей 00 копеек"; };
	it "336.00" => sub { is rur2words(336.00), "триста тридцать шесть рублей 00 копеек"; };
	it "337.00" => sub { is rur2words(337.00), "триста тридцать семь рублей 00 копеек"; };
	it "338.00" => sub { is rur2words(338.00), "триста тридцать восемь рублей 00 копеек"; };
	it "339.00" => sub { is rur2words(339.00), "триста тридцать девять рублей 00 копеек"; };
	it "340.00" => sub { is rur2words(340.00), "триста сорок рублей 00 копеек"; };
	it "341.00" => sub { is rur2words(341.00), "триста сорок один рубль 00 копеек"; };
	it "342.00" => sub { is rur2words(342.00), "триста сорок два рубля 00 копеек"; };
	it "343.00" => sub { is rur2words(343.00), "триста сорок три рубля 00 копеек"; };
	it "344.00" => sub { is rur2words(344.00), "триста сорок четыре рубля 00 копеек"; };
	it "345.00" => sub { is rur2words(345.00), "триста сорок пять рублей 00 копеек"; };
	it "346.00" => sub { is rur2words(346.00), "триста сорок шесть рублей 00 копеек"; };
	it "347.00" => sub { is rur2words(347.00), "триста сорок семь рублей 00 копеек"; };
	it "348.00" => sub { is rur2words(348.00), "триста сорок восемь рублей 00 копеек"; };
	it "349.00" => sub { is rur2words(349.00), "триста сорок девять рублей 00 копеек"; };
	it "350.00" => sub { is rur2words(350.00), "триста пятьдесят рублей 00 копеек"; };
	it "351.00" => sub { is rur2words(351.00), "триста пятьдесят один рубль 00 копеек"; };
	it "352.00" => sub { is rur2words(352.00), "триста пятьдесят два рубля 00 копеек"; };
	it "353.00" => sub { is rur2words(353.00), "триста пятьдесят три рубля 00 копеек"; };
	it "354.00" => sub { is rur2words(354.00), "триста пятьдесят четыре рубля 00 копеек"; };
	it "355.00" => sub { is rur2words(355.00), "триста пятьдесят пять рублей 00 копеек"; };
	it "356.00" => sub { is rur2words(356.00), "триста пятьдесят шесть рублей 00 копеек"; };
	it "357.00" => sub { is rur2words(357.00), "триста пятьдесят семь рублей 00 копеек"; };
	it "358.00" => sub { is rur2words(358.00), "триста пятьдесят восемь рублей 00 копеек"; };
	it "359.00" => sub { is rur2words(359.00), "триста пятьдесят девять рублей 00 копеек"; };
	it "360.00" => sub { is rur2words(360.00), "триста шестьдесят рублей 00 копеек"; };
	it "361.00" => sub { is rur2words(361.00), "триста шестьдесят один рубль 00 копеек"; };
	it "362.00" => sub { is rur2words(362.00), "триста шестьдесят два рубля 00 копеек"; };
	it "363.00" => sub { is rur2words(363.00), "триста шестьдесят три рубля 00 копеек"; };
	it "364.00" => sub { is rur2words(364.00), "триста шестьдесят четыре рубля 00 копеек"; };
	it "365.00" => sub { is rur2words(365.00), "триста шестьдесят пять рублей 00 копеек"; };
	it "366.00" => sub { is rur2words(366.00), "триста шестьдесят шесть рублей 00 копеек"; };
	it "367.00" => sub { is rur2words(367.00), "триста шестьдесят семь рублей 00 копеек"; };
	it "368.00" => sub { is rur2words(368.00), "триста шестьдесят восемь рублей 00 копеек"; };
	it "369.00" => sub { is rur2words(369.00), "триста шестьдесят девять рублей 00 копеек"; };
	it "370.00" => sub { is rur2words(370.00), "триста семьдесят рублей 00 копеек"; };
	it "371.00" => sub { is rur2words(371.00), "триста семьдесят один рубль 00 копеек"; };
	it "372.00" => sub { is rur2words(372.00), "триста семьдесят два рубля 00 копеек"; };
	it "373.00" => sub { is rur2words(373.00), "триста семьдесят три рубля 00 копеек"; };
	it "374.00" => sub { is rur2words(374.00), "триста семьдесят четыре рубля 00 копеек"; };
	it "375.00" => sub { is rur2words(375.00), "триста семьдесят пять рублей 00 копеек"; };
	it "376.00" => sub { is rur2words(376.00), "триста семьдесят шесть рублей 00 копеек"; };
	it "377.00" => sub { is rur2words(377.00), "триста семьдесят семь рублей 00 копеек"; };
	it "378.00" => sub { is rur2words(378.00), "триста семьдесят восемь рублей 00 копеек"; };
	it "379.00" => sub { is rur2words(379.00), "триста семьдесят девять рублей 00 копеек"; };
	it "380.00" => sub { is rur2words(380.00), "триста восемьдесят рублей 00 копеек"; };
	it "381.00" => sub { is rur2words(381.00), "триста восемьдесят один рубль 00 копеек"; };
	it "382.00" => sub { is rur2words(382.00), "триста восемьдесят два рубля 00 копеек"; };
	it "383.00" => sub { is rur2words(383.00), "триста восемьдесят три рубля 00 копеек"; };
	it "384.00" => sub { is rur2words(384.00), "триста восемьдесят четыре рубля 00 копеек"; };
	it "385.00" => sub { is rur2words(385.00), "триста восемьдесят пять рублей 00 копеек"; };
	it "386.00" => sub { is rur2words(386.00), "триста восемьдесят шесть рублей 00 копеек"; };
	it "387.00" => sub { is rur2words(387.00), "триста восемьдесят семь рублей 00 копеек"; };
	it "388.00" => sub { is rur2words(388.00), "триста восемьдесят восемь рублей 00 копеек"; };
	it "389.00" => sub { is rur2words(389.00), "триста восемьдесят девять рублей 00 копеек"; };
	it "390.00" => sub { is rur2words(390.00), "триста девяносто рублей 00 копеек"; };
	it "391.00" => sub { is rur2words(391.00), "триста девяносто один рубль 00 копеек"; };
	it "392.00" => sub { is rur2words(392.00), "триста девяносто два рубля 00 копеек"; };
	it "393.00" => sub { is rur2words(393.00), "триста девяносто три рубля 00 копеек"; };
	it "394.00" => sub { is rur2words(394.00), "триста девяносто четыре рубля 00 копеек"; };
	it "395.00" => sub { is rur2words(395.00), "триста девяносто пять рублей 00 копеек"; };
	it "396.00" => sub { is rur2words(396.00), "триста девяносто шесть рублей 00 копеек"; };
	it "397.00" => sub { is rur2words(397.00), "триста девяносто семь рублей 00 копеек"; };
	it "398.00" => sub { is rur2words(398.00), "триста девяносто восемь рублей 00 копеек"; };
	it "399.00" => sub { is rur2words(399.00), "триста девяносто девять рублей 00 копеек"; };
	it "400.00" => sub { is rur2words(400.00), "четыреста рублей 00 копеек"; };
	it "401.00" => sub { is rur2words(401.00), "четыреста один рубль 00 копеек"; };
	it "402.00" => sub { is rur2words(402.00), "четыреста два рубля 00 копеек"; };
	it "403.00" => sub { is rur2words(403.00), "четыреста три рубля 00 копеек"; };
	it "404.00" => sub { is rur2words(404.00), "четыреста четыре рубля 00 копеек"; };
	it "405.00" => sub { is rur2words(405.00), "четыреста пять рублей 00 копеек"; };
	it "406.00" => sub { is rur2words(406.00), "четыреста шесть рублей 00 копеек"; };
	it "407.00" => sub { is rur2words(407.00), "четыреста семь рублей 00 копеек"; };
	it "408.00" => sub { is rur2words(408.00), "четыреста восемь рублей 00 копеек"; };
	it "409.00" => sub { is rur2words(409.00), "четыреста девять рублей 00 копеек"; };
	it "410.00" => sub { is rur2words(410.00), "четыреста десять рублей 00 копеек"; };
	it "411.00" => sub { is rur2words(411.00), "четыреста одиннадцать рублей 00 копеек"; };
	it "412.00" => sub { is rur2words(412.00), "четыреста двенадцать рублей 00 копеек"; };
	it "413.00" => sub { is rur2words(413.00), "четыреста тринадцать рублей 00 копеек"; };
	it "414.00" => sub { is rur2words(414.00), "четыреста четырнадцать рублей 00 копеек"; };
	it "415.00" => sub { is rur2words(415.00), "четыреста пятнадцать рублей 00 копеек"; };
	it "416.00" => sub { is rur2words(416.00), "четыреста шестнадцать рублей 00 копеек"; };
	it "417.00" => sub { is rur2words(417.00), "четыреста семнадцать рублей 00 копеек"; };
	it "418.00" => sub { is rur2words(418.00), "четыреста восемнадцать рублей 00 копеек"; };
	it "419.00" => sub { is rur2words(419.00), "четыреста девятнадцать рублей 00 копеек"; };
	it "420.00" => sub { is rur2words(420.00), "четыреста двадцать рублей 00 копеек"; };
	it "421.00" => sub { is rur2words(421.00), "четыреста двадцать один рубль 00 копеек"; };
	it "422.00" => sub { is rur2words(422.00), "четыреста двадцать два рубля 00 копеек"; };
	it "423.00" => sub { is rur2words(423.00), "четыреста двадцать три рубля 00 копеек"; };
	it "424.00" => sub { is rur2words(424.00), "четыреста двадцать четыре рубля 00 копеек"; };
	it "425.00" => sub { is rur2words(425.00), "четыреста двадцать пять рублей 00 копеек"; };
	it "426.00" => sub { is rur2words(426.00), "четыреста двадцать шесть рублей 00 копеек"; };
	it "427.00" => sub { is rur2words(427.00), "четыреста двадцать семь рублей 00 копеек"; };
	it "428.00" => sub { is rur2words(428.00), "четыреста двадцать восемь рублей 00 копеек"; };
	it "429.00" => sub { is rur2words(429.00), "четыреста двадцать девять рублей 00 копеек"; };
	it "430.00" => sub { is rur2words(430.00), "четыреста тридцать рублей 00 копеек"; };
	it "431.00" => sub { is rur2words(431.00), "четыреста тридцать один рубль 00 копеек"; };
	it "432.00" => sub { is rur2words(432.00), "четыреста тридцать два рубля 00 копеек"; };
	it "433.00" => sub { is rur2words(433.00), "четыреста тридцать три рубля 00 копеек"; };
	it "434.00" => sub { is rur2words(434.00), "четыреста тридцать четыре рубля 00 копеек"; };
	it "435.00" => sub { is rur2words(435.00), "четыреста тридцать пять рублей 00 копеек"; };
	it "436.00" => sub { is rur2words(436.00), "четыреста тридцать шесть рублей 00 копеек"; };
	it "437.00" => sub { is rur2words(437.00), "четыреста тридцать семь рублей 00 копеек"; };
	it "438.00" => sub { is rur2words(438.00), "четыреста тридцать восемь рублей 00 копеек"; };
	it "439.00" => sub { is rur2words(439.00), "четыреста тридцать девять рублей 00 копеек"; };
	it "440.00" => sub { is rur2words(440.00), "четыреста сорок рублей 00 копеек"; };
	it "441.00" => sub { is rur2words(441.00), "четыреста сорок один рубль 00 копеек"; };
	it "442.00" => sub { is rur2words(442.00), "четыреста сорок два рубля 00 копеек"; };
	it "443.00" => sub { is rur2words(443.00), "четыреста сорок три рубля 00 копеек"; };
	it "444.00" => sub { is rur2words(444.00), "четыреста сорок четыре рубля 00 копеек"; };
	it "445.00" => sub { is rur2words(445.00), "четыреста сорок пять рублей 00 копеек"; };
	it "446.00" => sub { is rur2words(446.00), "четыреста сорок шесть рублей 00 копеек"; };
	it "447.00" => sub { is rur2words(447.00), "четыреста сорок семь рублей 00 копеек"; };
	it "448.00" => sub { is rur2words(448.00), "четыреста сорок восемь рублей 00 копеек"; };
	it "449.00" => sub { is rur2words(449.00), "четыреста сорок девять рублей 00 копеек"; };
	it "450.00" => sub { is rur2words(450.00), "четыреста пятьдесят рублей 00 копеек"; };
	it "451.00" => sub { is rur2words(451.00), "четыреста пятьдесят один рубль 00 копеек"; };
	it "452.00" => sub { is rur2words(452.00), "четыреста пятьдесят два рубля 00 копеек"; };
	it "453.00" => sub { is rur2words(453.00), "четыреста пятьдесят три рубля 00 копеек"; };
	it "454.00" => sub { is rur2words(454.00), "четыреста пятьдесят четыре рубля 00 копеек"; };
	it "455.00" => sub { is rur2words(455.00), "четыреста пятьдесят пять рублей 00 копеек"; };
	it "456.00" => sub { is rur2words(456.00), "четыреста пятьдесят шесть рублей 00 копеек"; };
	it "457.00" => sub { is rur2words(457.00), "четыреста пятьдесят семь рублей 00 копеек"; };
	it "458.00" => sub { is rur2words(458.00), "четыреста пятьдесят восемь рублей 00 копеек"; };
	it "459.00" => sub { is rur2words(459.00), "четыреста пятьдесят девять рублей 00 копеек"; };
	it "460.00" => sub { is rur2words(460.00), "четыреста шестьдесят рублей 00 копеек"; };
	it "461.00" => sub { is rur2words(461.00), "четыреста шестьдесят один рубль 00 копеек"; };
	it "462.00" => sub { is rur2words(462.00), "четыреста шестьдесят два рубля 00 копеек"; };
	it "463.00" => sub { is rur2words(463.00), "четыреста шестьдесят три рубля 00 копеек"; };
	it "464.00" => sub { is rur2words(464.00), "четыреста шестьдесят четыре рубля 00 копеек"; };
	it "465.00" => sub { is rur2words(465.00), "четыреста шестьдесят пять рублей 00 копеек"; };
	it "466.00" => sub { is rur2words(466.00), "четыреста шестьдесят шесть рублей 00 копеек"; };
	it "467.00" => sub { is rur2words(467.00), "четыреста шестьдесят семь рублей 00 копеек"; };
	it "468.00" => sub { is rur2words(468.00), "четыреста шестьдесят восемь рублей 00 копеек"; };
	it "469.00" => sub { is rur2words(469.00), "четыреста шестьдесят девять рублей 00 копеек"; };
	it "470.00" => sub { is rur2words(470.00), "четыреста семьдесят рублей 00 копеек"; };
	it "471.00" => sub { is rur2words(471.00), "четыреста семьдесят один рубль 00 копеек"; };
	it "472.00" => sub { is rur2words(472.00), "четыреста семьдесят два рубля 00 копеек"; };
	it "473.00" => sub { is rur2words(473.00), "четыреста семьдесят три рубля 00 копеек"; };
	it "474.00" => sub { is rur2words(474.00), "четыреста семьдесят четыре рубля 00 копеек"; };
	it "475.00" => sub { is rur2words(475.00), "четыреста семьдесят пять рублей 00 копеек"; };
	it "476.00" => sub { is rur2words(476.00), "четыреста семьдесят шесть рублей 00 копеек"; };
	it "477.00" => sub { is rur2words(477.00), "четыреста семьдесят семь рублей 00 копеек"; };
	it "478.00" => sub { is rur2words(478.00), "четыреста семьдесят восемь рублей 00 копеек"; };
	it "479.00" => sub { is rur2words(479.00), "четыреста семьдесят девять рублей 00 копеек"; };
	it "480.00" => sub { is rur2words(480.00), "четыреста восемьдесят рублей 00 копеек"; };
	it "481.00" => sub { is rur2words(481.00), "четыреста восемьдесят один рубль 00 копеек"; };
	it "482.00" => sub { is rur2words(482.00), "четыреста восемьдесят два рубля 00 копеек"; };
	it "483.00" => sub { is rur2words(483.00), "четыреста восемьдесят три рубля 00 копеек"; };
	it "484.00" => sub { is rur2words(484.00), "четыреста восемьдесят четыре рубля 00 копеек"; };
	it "485.00" => sub { is rur2words(485.00), "четыреста восемьдесят пять рублей 00 копеек"; };
	it "486.00" => sub { is rur2words(486.00), "четыреста восемьдесят шесть рублей 00 копеек"; };
	it "487.00" => sub { is rur2words(487.00), "четыреста восемьдесят семь рублей 00 копеек"; };
	it "488.00" => sub { is rur2words(488.00), "четыреста восемьдесят восемь рублей 00 копеек"; };
	it "489.00" => sub { is rur2words(489.00), "четыреста восемьдесят девять рублей 00 копеек"; };
	it "490.00" => sub { is rur2words(490.00), "четыреста девяносто рублей 00 копеек"; };
	it "491.00" => sub { is rur2words(491.00), "четыреста девяносто один рубль 00 копеек"; };
	it "492.00" => sub { is rur2words(492.00), "четыреста девяносто два рубля 00 копеек"; };
	it "493.00" => sub { is rur2words(493.00), "четыреста девяносто три рубля 00 копеек"; };
	it "494.00" => sub { is rur2words(494.00), "четыреста девяносто четыре рубля 00 копеек"; };
	it "495.00" => sub { is rur2words(495.00), "четыреста девяносто пять рублей 00 копеек"; };
	it "496.00" => sub { is rur2words(496.00), "четыреста девяносто шесть рублей 00 копеек"; };
	it "497.00" => sub { is rur2words(497.00), "четыреста девяносто семь рублей 00 копеек"; };
	it "498.00" => sub { is rur2words(498.00), "четыреста девяносто восемь рублей 00 копеек"; };
	it "499.00" => sub { is rur2words(499.00), "четыреста девяносто девять рублей 00 копеек"; };
	it "500.00" => sub { is rur2words(500.00), "пятьсот рублей 00 копеек"; };
	it "501.00" => sub { is rur2words(501.00), "пятьсот один рубль 00 копеек"; };
	it "502.00" => sub { is rur2words(502.00), "пятьсот два рубля 00 копеек"; };
	it "503.00" => sub { is rur2words(503.00), "пятьсот три рубля 00 копеек"; };
	it "504.00" => sub { is rur2words(504.00), "пятьсот четыре рубля 00 копеек"; };
	it "505.00" => sub { is rur2words(505.00), "пятьсот пять рублей 00 копеек"; };
	it "506.00" => sub { is rur2words(506.00), "пятьсот шесть рублей 00 копеек"; };
	it "507.00" => sub { is rur2words(507.00), "пятьсот семь рублей 00 копеек"; };
	it "508.00" => sub { is rur2words(508.00), "пятьсот восемь рублей 00 копеек"; };
	it "509.00" => sub { is rur2words(509.00), "пятьсот девять рублей 00 копеек"; };
	it "510.00" => sub { is rur2words(510.00), "пятьсот десять рублей 00 копеек"; };
	it "511.00" => sub { is rur2words(511.00), "пятьсот одиннадцать рублей 00 копеек"; };
	it "512.00" => sub { is rur2words(512.00), "пятьсот двенадцать рублей 00 копеек"; };
	it "513.00" => sub { is rur2words(513.00), "пятьсот тринадцать рублей 00 копеек"; };
	it "514.00" => sub { is rur2words(514.00), "пятьсот четырнадцать рублей 00 копеек"; };
	it "515.00" => sub { is rur2words(515.00), "пятьсот пятнадцать рублей 00 копеек"; };
	it "516.00" => sub { is rur2words(516.00), "пятьсот шестнадцать рублей 00 копеек"; };
	it "517.00" => sub { is rur2words(517.00), "пятьсот семнадцать рублей 00 копеек"; };
	it "518.00" => sub { is rur2words(518.00), "пятьсот восемнадцать рублей 00 копеек"; };
	it "519.00" => sub { is rur2words(519.00), "пятьсот девятнадцать рублей 00 копеек"; };
	it "520.00" => sub { is rur2words(520.00), "пятьсот двадцать рублей 00 копеек"; };
	it "521.00" => sub { is rur2words(521.00), "пятьсот двадцать один рубль 00 копеек"; };
	it "522.00" => sub { is rur2words(522.00), "пятьсот двадцать два рубля 00 копеек"; };
	it "523.00" => sub { is rur2words(523.00), "пятьсот двадцать три рубля 00 копеек"; };
	it "524.00" => sub { is rur2words(524.00), "пятьсот двадцать четыре рубля 00 копеек"; };
	it "525.00" => sub { is rur2words(525.00), "пятьсот двадцать пять рублей 00 копеек"; };
	it "526.00" => sub { is rur2words(526.00), "пятьсот двадцать шесть рублей 00 копеек"; };
	it "527.00" => sub { is rur2words(527.00), "пятьсот двадцать семь рублей 00 копеек"; };
	it "528.00" => sub { is rur2words(528.00), "пятьсот двадцать восемь рублей 00 копеек"; };
	it "529.00" => sub { is rur2words(529.00), "пятьсот двадцать девять рублей 00 копеек"; };
	it "530.00" => sub { is rur2words(530.00), "пятьсот тридцать рублей 00 копеек"; };
	it "531.00" => sub { is rur2words(531.00), "пятьсот тридцать один рубль 00 копеек"; };
	it "532.00" => sub { is rur2words(532.00), "пятьсот тридцать два рубля 00 копеек"; };
	it "533.00" => sub { is rur2words(533.00), "пятьсот тридцать три рубля 00 копеек"; };
	it "534.00" => sub { is rur2words(534.00), "пятьсот тридцать четыре рубля 00 копеек"; };
	it "535.00" => sub { is rur2words(535.00), "пятьсот тридцать пять рублей 00 копеек"; };
	it "536.00" => sub { is rur2words(536.00), "пятьсот тридцать шесть рублей 00 копеек"; };
	it "537.00" => sub { is rur2words(537.00), "пятьсот тридцать семь рублей 00 копеек"; };
	it "538.00" => sub { is rur2words(538.00), "пятьсот тридцать восемь рублей 00 копеек"; };
	it "539.00" => sub { is rur2words(539.00), "пятьсот тридцать девять рублей 00 копеек"; };
	it "540.00" => sub { is rur2words(540.00), "пятьсот сорок рублей 00 копеек"; };
	it "541.00" => sub { is rur2words(541.00), "пятьсот сорок один рубль 00 копеек"; };
	it "542.00" => sub { is rur2words(542.00), "пятьсот сорок два рубля 00 копеек"; };
	it "543.00" => sub { is rur2words(543.00), "пятьсот сорок три рубля 00 копеек"; };
	it "544.00" => sub { is rur2words(544.00), "пятьсот сорок четыре рубля 00 копеек"; };
	it "545.00" => sub { is rur2words(545.00), "пятьсот сорок пять рублей 00 копеек"; };
	it "546.00" => sub { is rur2words(546.00), "пятьсот сорок шесть рублей 00 копеек"; };
	it "547.00" => sub { is rur2words(547.00), "пятьсот сорок семь рублей 00 копеек"; };
	it "548.00" => sub { is rur2words(548.00), "пятьсот сорок восемь рублей 00 копеек"; };
	it "549.00" => sub { is rur2words(549.00), "пятьсот сорок девять рублей 00 копеек"; };
	it "550.00" => sub { is rur2words(550.00), "пятьсот пятьдесят рублей 00 копеек"; };
	it "551.00" => sub { is rur2words(551.00), "пятьсот пятьдесят один рубль 00 копеек"; };
	it "552.00" => sub { is rur2words(552.00), "пятьсот пятьдесят два рубля 00 копеек"; };
	it "553.00" => sub { is rur2words(553.00), "пятьсот пятьдесят три рубля 00 копеек"; };
	it "554.00" => sub { is rur2words(554.00), "пятьсот пятьдесят четыре рубля 00 копеек"; };
	it "555.00" => sub { is rur2words(555.00), "пятьсот пятьдесят пять рублей 00 копеек"; };
	it "556.00" => sub { is rur2words(556.00), "пятьсот пятьдесят шесть рублей 00 копеек"; };
	it "557.00" => sub { is rur2words(557.00), "пятьсот пятьдесят семь рублей 00 копеек"; };
	it "558.00" => sub { is rur2words(558.00), "пятьсот пятьдесят восемь рублей 00 копеек"; };
	it "559.00" => sub { is rur2words(559.00), "пятьсот пятьдесят девять рублей 00 копеек"; };
	it "560.00" => sub { is rur2words(560.00), "пятьсот шестьдесят рублей 00 копеек"; };
	it "561.00" => sub { is rur2words(561.00), "пятьсот шестьдесят один рубль 00 копеек"; };
	it "562.00" => sub { is rur2words(562.00), "пятьсот шестьдесят два рубля 00 копеек"; };
	it "563.00" => sub { is rur2words(563.00), "пятьсот шестьдесят три рубля 00 копеек"; };
	it "564.00" => sub { is rur2words(564.00), "пятьсот шестьдесят четыре рубля 00 копеек"; };
	it "565.00" => sub { is rur2words(565.00), "пятьсот шестьдесят пять рублей 00 копеек"; };
	it "566.00" => sub { is rur2words(566.00), "пятьсот шестьдесят шесть рублей 00 копеек"; };
	it "567.00" => sub { is rur2words(567.00), "пятьсот шестьдесят семь рублей 00 копеек"; };
	it "568.00" => sub { is rur2words(568.00), "пятьсот шестьдесят восемь рублей 00 копеек"; };
	it "569.00" => sub { is rur2words(569.00), "пятьсот шестьдесят девять рублей 00 копеек"; };
	it "570.00" => sub { is rur2words(570.00), "пятьсот семьдесят рублей 00 копеек"; };
	it "571.00" => sub { is rur2words(571.00), "пятьсот семьдесят один рубль 00 копеек"; };
	it "572.00" => sub { is rur2words(572.00), "пятьсот семьдесят два рубля 00 копеек"; };
	it "573.00" => sub { is rur2words(573.00), "пятьсот семьдесят три рубля 00 копеек"; };
	it "574.00" => sub { is rur2words(574.00), "пятьсот семьдесят четыре рубля 00 копеек"; };
	it "575.00" => sub { is rur2words(575.00), "пятьсот семьдесят пять рублей 00 копеек"; };
	it "576.00" => sub { is rur2words(576.00), "пятьсот семьдесят шесть рублей 00 копеек"; };
	it "577.00" => sub { is rur2words(577.00), "пятьсот семьдесят семь рублей 00 копеек"; };
	it "578.00" => sub { is rur2words(578.00), "пятьсот семьдесят восемь рублей 00 копеек"; };
	it "579.00" => sub { is rur2words(579.00), "пятьсот семьдесят девять рублей 00 копеек"; };
	it "580.00" => sub { is rur2words(580.00), "пятьсот восемьдесят рублей 00 копеек"; };
	it "581.00" => sub { is rur2words(581.00), "пятьсот восемьдесят один рубль 00 копеек"; };
	it "582.00" => sub { is rur2words(582.00), "пятьсот восемьдесят два рубля 00 копеек"; };
	it "583.00" => sub { is rur2words(583.00), "пятьсот восемьдесят три рубля 00 копеек"; };
	it "584.00" => sub { is rur2words(584.00), "пятьсот восемьдесят четыре рубля 00 копеек"; };
	it "585.00" => sub { is rur2words(585.00), "пятьсот восемьдесят пять рублей 00 копеек"; };
	it "586.00" => sub { is rur2words(586.00), "пятьсот восемьдесят шесть рублей 00 копеек"; };
	it "587.00" => sub { is rur2words(587.00), "пятьсот восемьдесят семь рублей 00 копеек"; };
	it "588.00" => sub { is rur2words(588.00), "пятьсот восемьдесят восемь рублей 00 копеек"; };
	it "589.00" => sub { is rur2words(589.00), "пятьсот восемьдесят девять рублей 00 копеек"; };
	it "590.00" => sub { is rur2words(590.00), "пятьсот девяносто рублей 00 копеек"; };
	it "591.00" => sub { is rur2words(591.00), "пятьсот девяносто один рубль 00 копеек"; };
	it "592.00" => sub { is rur2words(592.00), "пятьсот девяносто два рубля 00 копеек"; };
	it "593.00" => sub { is rur2words(593.00), "пятьсот девяносто три рубля 00 копеек"; };
	it "594.00" => sub { is rur2words(594.00), "пятьсот девяносто четыре рубля 00 копеек"; };
	it "595.00" => sub { is rur2words(595.00), "пятьсот девяносто пять рублей 00 копеек"; };
	it "596.00" => sub { is rur2words(596.00), "пятьсот девяносто шесть рублей 00 копеек"; };
	it "597.00" => sub { is rur2words(597.00), "пятьсот девяносто семь рублей 00 копеек"; };
	it "598.00" => sub { is rur2words(598.00), "пятьсот девяносто восемь рублей 00 копеек"; };
	it "599.00" => sub { is rur2words(599.00), "пятьсот девяносто девять рублей 00 копеек"; };
	it "600.00" => sub { is rur2words(600.00), "шестьсот рублей 00 копеек"; };
	it "601.00" => sub { is rur2words(601.00), "шестьсот один рубль 00 копеек"; };
	it "602.00" => sub { is rur2words(602.00), "шестьсот два рубля 00 копеек"; };
	it "603.00" => sub { is rur2words(603.00), "шестьсот три рубля 00 копеек"; };
	it "604.00" => sub { is rur2words(604.00), "шестьсот четыре рубля 00 копеек"; };
	it "605.00" => sub { is rur2words(605.00), "шестьсот пять рублей 00 копеек"; };
	it "606.00" => sub { is rur2words(606.00), "шестьсот шесть рублей 00 копеек"; };
	it "607.00" => sub { is rur2words(607.00), "шестьсот семь рублей 00 копеек"; };
	it "608.00" => sub { is rur2words(608.00), "шестьсот восемь рублей 00 копеек"; };
	it "609.00" => sub { is rur2words(609.00), "шестьсот девять рублей 00 копеек"; };
	it "610.00" => sub { is rur2words(610.00), "шестьсот десять рублей 00 копеек"; };
	it "611.00" => sub { is rur2words(611.00), "шестьсот одиннадцать рублей 00 копеек"; };
	it "612.00" => sub { is rur2words(612.00), "шестьсот двенадцать рублей 00 копеек"; };
	it "613.00" => sub { is rur2words(613.00), "шестьсот тринадцать рублей 00 копеек"; };
	it "614.00" => sub { is rur2words(614.00), "шестьсот четырнадцать рублей 00 копеек"; };
	it "615.00" => sub { is rur2words(615.00), "шестьсот пятнадцать рублей 00 копеек"; };
	it "616.00" => sub { is rur2words(616.00), "шестьсот шестнадцать рублей 00 копеек"; };
	it "617.00" => sub { is rur2words(617.00), "шестьсот семнадцать рублей 00 копеек"; };
	it "618.00" => sub { is rur2words(618.00), "шестьсот восемнадцать рублей 00 копеек"; };
	it "619.00" => sub { is rur2words(619.00), "шестьсот девятнадцать рублей 00 копеек"; };
	it "620.00" => sub { is rur2words(620.00), "шестьсот двадцать рублей 00 копеек"; };
	it "621.00" => sub { is rur2words(621.00), "шестьсот двадцать один рубль 00 копеек"; };
	it "622.00" => sub { is rur2words(622.00), "шестьсот двадцать два рубля 00 копеек"; };
	it "623.00" => sub { is rur2words(623.00), "шестьсот двадцать три рубля 00 копеек"; };
	it "624.00" => sub { is rur2words(624.00), "шестьсот двадцать четыре рубля 00 копеек"; };
	it "625.00" => sub { is rur2words(625.00), "шестьсот двадцать пять рублей 00 копеек"; };
	it "626.00" => sub { is rur2words(626.00), "шестьсот двадцать шесть рублей 00 копеек"; };
	it "627.00" => sub { is rur2words(627.00), "шестьсот двадцать семь рублей 00 копеек"; };
	it "628.00" => sub { is rur2words(628.00), "шестьсот двадцать восемь рублей 00 копеек"; };
	it "629.00" => sub { is rur2words(629.00), "шестьсот двадцать девять рублей 00 копеек"; };
	it "630.00" => sub { is rur2words(630.00), "шестьсот тридцать рублей 00 копеек"; };
	it "631.00" => sub { is rur2words(631.00), "шестьсот тридцать один рубль 00 копеек"; };
	it "632.00" => sub { is rur2words(632.00), "шестьсот тридцать два рубля 00 копеек"; };
	it "633.00" => sub { is rur2words(633.00), "шестьсот тридцать три рубля 00 копеек"; };
	it "634.00" => sub { is rur2words(634.00), "шестьсот тридцать четыре рубля 00 копеек"; };
	it "635.00" => sub { is rur2words(635.00), "шестьсот тридцать пять рублей 00 копеек"; };
	it "636.00" => sub { is rur2words(636.00), "шестьсот тридцать шесть рублей 00 копеек"; };
	it "637.00" => sub { is rur2words(637.00), "шестьсот тридцать семь рублей 00 копеек"; };
	it "638.00" => sub { is rur2words(638.00), "шестьсот тридцать восемь рублей 00 копеек"; };
	it "639.00" => sub { is rur2words(639.00), "шестьсот тридцать девять рублей 00 копеек"; };
	it "640.00" => sub { is rur2words(640.00), "шестьсот сорок рублей 00 копеек"; };
	it "641.00" => sub { is rur2words(641.00), "шестьсот сорок один рубль 00 копеек"; };
	it "642.00" => sub { is rur2words(642.00), "шестьсот сорок два рубля 00 копеек"; };
	it "643.00" => sub { is rur2words(643.00), "шестьсот сорок три рубля 00 копеек"; };
	it "644.00" => sub { is rur2words(644.00), "шестьсот сорок четыре рубля 00 копеек"; };
	it "645.00" => sub { is rur2words(645.00), "шестьсот сорок пять рублей 00 копеек"; };
	it "646.00" => sub { is rur2words(646.00), "шестьсот сорок шесть рублей 00 копеек"; };
	it "647.00" => sub { is rur2words(647.00), "шестьсот сорок семь рублей 00 копеек"; };
	it "648.00" => sub { is rur2words(648.00), "шестьсот сорок восемь рублей 00 копеек"; };
	it "649.00" => sub { is rur2words(649.00), "шестьсот сорок девять рублей 00 копеек"; };
	it "650.00" => sub { is rur2words(650.00), "шестьсот пятьдесят рублей 00 копеек"; };
	it "651.00" => sub { is rur2words(651.00), "шестьсот пятьдесят один рубль 00 копеек"; };
	it "652.00" => sub { is rur2words(652.00), "шестьсот пятьдесят два рубля 00 копеек"; };
	it "653.00" => sub { is rur2words(653.00), "шестьсот пятьдесят три рубля 00 копеек"; };
	it "654.00" => sub { is rur2words(654.00), "шестьсот пятьдесят четыре рубля 00 копеек"; };
	it "655.00" => sub { is rur2words(655.00), "шестьсот пятьдесят пять рублей 00 копеек"; };
	it "656.00" => sub { is rur2words(656.00), "шестьсот пятьдесят шесть рублей 00 копеек"; };
	it "657.00" => sub { is rur2words(657.00), "шестьсот пятьдесят семь рублей 00 копеек"; };
	it "658.00" => sub { is rur2words(658.00), "шестьсот пятьдесят восемь рублей 00 копеек"; };
	it "659.00" => sub { is rur2words(659.00), "шестьсот пятьдесят девять рублей 00 копеек"; };
	it "660.00" => sub { is rur2words(660.00), "шестьсот шестьдесят рублей 00 копеек"; };
	it "661.00" => sub { is rur2words(661.00), "шестьсот шестьдесят один рубль 00 копеек"; };
	it "662.00" => sub { is rur2words(662.00), "шестьсот шестьдесят два рубля 00 копеек"; };
	it "663.00" => sub { is rur2words(663.00), "шестьсот шестьдесят три рубля 00 копеек"; };
	it "664.00" => sub { is rur2words(664.00), "шестьсот шестьдесят четыре рубля 00 копеек"; };
	it "665.00" => sub { is rur2words(665.00), "шестьсот шестьдесят пять рублей 00 копеек"; };
	it "666.00" => sub { is rur2words(666.00), "шестьсот шестьдесят шесть рублей 00 копеек"; };
	it "667.00" => sub { is rur2words(667.00), "шестьсот шестьдесят семь рублей 00 копеек"; };
	it "668.00" => sub { is rur2words(668.00), "шестьсот шестьдесят восемь рублей 00 копеек"; };
	it "669.00" => sub { is rur2words(669.00), "шестьсот шестьдесят девять рублей 00 копеек"; };
	it "670.00" => sub { is rur2words(670.00), "шестьсот семьдесят рублей 00 копеек"; };
	it "671.00" => sub { is rur2words(671.00), "шестьсот семьдесят один рубль 00 копеек"; };
	it "672.00" => sub { is rur2words(672.00), "шестьсот семьдесят два рубля 00 копеек"; };
	it "673.00" => sub { is rur2words(673.00), "шестьсот семьдесят три рубля 00 копеек"; };
	it "674.00" => sub { is rur2words(674.00), "шестьсот семьдесят четыре рубля 00 копеек"; };
	it "675.00" => sub { is rur2words(675.00), "шестьсот семьдесят пять рублей 00 копеек"; };
	it "676.00" => sub { is rur2words(676.00), "шестьсот семьдесят шесть рублей 00 копеек"; };
	it "677.00" => sub { is rur2words(677.00), "шестьсот семьдесят семь рублей 00 копеек"; };
	it "678.00" => sub { is rur2words(678.00), "шестьсот семьдесят восемь рублей 00 копеек"; };
	it "679.00" => sub { is rur2words(679.00), "шестьсот семьдесят девять рублей 00 копеек"; };
	it "680.00" => sub { is rur2words(680.00), "шестьсот восемьдесят рублей 00 копеек"; };
	it "681.00" => sub { is rur2words(681.00), "шестьсот восемьдесят один рубль 00 копеек"; };
	it "682.00" => sub { is rur2words(682.00), "шестьсот восемьдесят два рубля 00 копеек"; };
	it "683.00" => sub { is rur2words(683.00), "шестьсот восемьдесят три рубля 00 копеек"; };
	it "684.00" => sub { is rur2words(684.00), "шестьсот восемьдесят четыре рубля 00 копеек"; };
	it "685.00" => sub { is rur2words(685.00), "шестьсот восемьдесят пять рублей 00 копеек"; };
	it "686.00" => sub { is rur2words(686.00), "шестьсот восемьдесят шесть рублей 00 копеек"; };
	it "687.00" => sub { is rur2words(687.00), "шестьсот восемьдесят семь рублей 00 копеек"; };
	it "688.00" => sub { is rur2words(688.00), "шестьсот восемьдесят восемь рублей 00 копеек"; };
	it "689.00" => sub { is rur2words(689.00), "шестьсот восемьдесят девять рублей 00 копеек"; };
	it "690.00" => sub { is rur2words(690.00), "шестьсот девяносто рублей 00 копеек"; };
	it "691.00" => sub { is rur2words(691.00), "шестьсот девяносто один рубль 00 копеек"; };
	it "692.00" => sub { is rur2words(692.00), "шестьсот девяносто два рубля 00 копеек"; };
	it "693.00" => sub { is rur2words(693.00), "шестьсот девяносто три рубля 00 копеек"; };
	it "694.00" => sub { is rur2words(694.00), "шестьсот девяносто четыре рубля 00 копеек"; };
	it "695.00" => sub { is rur2words(695.00), "шестьсот девяносто пять рублей 00 копеек"; };
	it "696.00" => sub { is rur2words(696.00), "шестьсот девяносто шесть рублей 00 копеек"; };
	it "697.00" => sub { is rur2words(697.00), "шестьсот девяносто семь рублей 00 копеек"; };
	it "698.00" => sub { is rur2words(698.00), "шестьсот девяносто восемь рублей 00 копеек"; };
	it "699.00" => sub { is rur2words(699.00), "шестьсот девяносто девять рублей 00 копеек"; };
	it "700.00" => sub { is rur2words(700.00), "семьсот рублей 00 копеек"; };
	it "701.00" => sub { is rur2words(701.00), "семьсот один рубль 00 копеек"; };
	it "702.00" => sub { is rur2words(702.00), "семьсот два рубля 00 копеек"; };
	it "703.00" => sub { is rur2words(703.00), "семьсот три рубля 00 копеек"; };
	it "704.00" => sub { is rur2words(704.00), "семьсот четыре рубля 00 копеек"; };
	it "705.00" => sub { is rur2words(705.00), "семьсот пять рублей 00 копеек"; };
	it "706.00" => sub { is rur2words(706.00), "семьсот шесть рублей 00 копеек"; };
	it "707.00" => sub { is rur2words(707.00), "семьсот семь рублей 00 копеек"; };
	it "708.00" => sub { is rur2words(708.00), "семьсот восемь рублей 00 копеек"; };
	it "709.00" => sub { is rur2words(709.00), "семьсот девять рублей 00 копеек"; };
	it "710.00" => sub { is rur2words(710.00), "семьсот десять рублей 00 копеек"; };
	it "711.00" => sub { is rur2words(711.00), "семьсот одиннадцать рублей 00 копеек"; };
	it "712.00" => sub { is rur2words(712.00), "семьсот двенадцать рублей 00 копеек"; };
	it "713.00" => sub { is rur2words(713.00), "семьсот тринадцать рублей 00 копеек"; };
	it "714.00" => sub { is rur2words(714.00), "семьсот четырнадцать рублей 00 копеек"; };
	it "715.00" => sub { is rur2words(715.00), "семьсот пятнадцать рублей 00 копеек"; };
	it "716.00" => sub { is rur2words(716.00), "семьсот шестнадцать рублей 00 копеек"; };
	it "717.00" => sub { is rur2words(717.00), "семьсот семнадцать рублей 00 копеек"; };
	it "718.00" => sub { is rur2words(718.00), "семьсот восемнадцать рублей 00 копеек"; };
	it "719.00" => sub { is rur2words(719.00), "семьсот девятнадцать рублей 00 копеек"; };
	it "720.00" => sub { is rur2words(720.00), "семьсот двадцать рублей 00 копеек"; };
	it "721.00" => sub { is rur2words(721.00), "семьсот двадцать один рубль 00 копеек"; };
	it "722.00" => sub { is rur2words(722.00), "семьсот двадцать два рубля 00 копеек"; };
	it "723.00" => sub { is rur2words(723.00), "семьсот двадцать три рубля 00 копеек"; };
	it "724.00" => sub { is rur2words(724.00), "семьсот двадцать четыре рубля 00 копеек"; };
	it "725.00" => sub { is rur2words(725.00), "семьсот двадцать пять рублей 00 копеек"; };
	it "726.00" => sub { is rur2words(726.00), "семьсот двадцать шесть рублей 00 копеек"; };
	it "727.00" => sub { is rur2words(727.00), "семьсот двадцать семь рублей 00 копеек"; };
	it "728.00" => sub { is rur2words(728.00), "семьсот двадцать восемь рублей 00 копеек"; };
	it "729.00" => sub { is rur2words(729.00), "семьсот двадцать девять рублей 00 копеек"; };
	it "730.00" => sub { is rur2words(730.00), "семьсот тридцать рублей 00 копеек"; };
	it "731.00" => sub { is rur2words(731.00), "семьсот тридцать один рубль 00 копеек"; };
	it "732.00" => sub { is rur2words(732.00), "семьсот тридцать два рубля 00 копеек"; };
	it "733.00" => sub { is rur2words(733.00), "семьсот тридцать три рубля 00 копеек"; };
	it "734.00" => sub { is rur2words(734.00), "семьсот тридцать четыре рубля 00 копеек"; };
	it "735.00" => sub { is rur2words(735.00), "семьсот тридцать пять рублей 00 копеек"; };
	it "736.00" => sub { is rur2words(736.00), "семьсот тридцать шесть рублей 00 копеек"; };
	it "737.00" => sub { is rur2words(737.00), "семьсот тридцать семь рублей 00 копеек"; };
	it "738.00" => sub { is rur2words(738.00), "семьсот тридцать восемь рублей 00 копеек"; };
	it "739.00" => sub { is rur2words(739.00), "семьсот тридцать девять рублей 00 копеек"; };
	it "740.00" => sub { is rur2words(740.00), "семьсот сорок рублей 00 копеек"; };
	it "741.00" => sub { is rur2words(741.00), "семьсот сорок один рубль 00 копеек"; };
	it "742.00" => sub { is rur2words(742.00), "семьсот сорок два рубля 00 копеек"; };
	it "743.00" => sub { is rur2words(743.00), "семьсот сорок три рубля 00 копеек"; };
	it "744.00" => sub { is rur2words(744.00), "семьсот сорок четыре рубля 00 копеек"; };
	it "745.00" => sub { is rur2words(745.00), "семьсот сорок пять рублей 00 копеек"; };
	it "746.00" => sub { is rur2words(746.00), "семьсот сорок шесть рублей 00 копеек"; };
	it "747.00" => sub { is rur2words(747.00), "семьсот сорок семь рублей 00 копеек"; };
	it "748.00" => sub { is rur2words(748.00), "семьсот сорок восемь рублей 00 копеек"; };
	it "749.00" => sub { is rur2words(749.00), "семьсот сорок девять рублей 00 копеек"; };
	it "750.00" => sub { is rur2words(750.00), "семьсот пятьдесят рублей 00 копеек"; };
	it "751.00" => sub { is rur2words(751.00), "семьсот пятьдесят один рубль 00 копеек"; };
	it "752.00" => sub { is rur2words(752.00), "семьсот пятьдесят два рубля 00 копеек"; };
	it "753.00" => sub { is rur2words(753.00), "семьсот пятьдесят три рубля 00 копеек"; };
	it "754.00" => sub { is rur2words(754.00), "семьсот пятьдесят четыре рубля 00 копеек"; };
	it "755.00" => sub { is rur2words(755.00), "семьсот пятьдесят пять рублей 00 копеек"; };
	it "756.00" => sub { is rur2words(756.00), "семьсот пятьдесят шесть рублей 00 копеек"; };
	it "757.00" => sub { is rur2words(757.00), "семьсот пятьдесят семь рублей 00 копеек"; };
	it "758.00" => sub { is rur2words(758.00), "семьсот пятьдесят восемь рублей 00 копеек"; };
	it "759.00" => sub { is rur2words(759.00), "семьсот пятьдесят девять рублей 00 копеек"; };
	it "760.00" => sub { is rur2words(760.00), "семьсот шестьдесят рублей 00 копеек"; };
	it "761.00" => sub { is rur2words(761.00), "семьсот шестьдесят один рубль 00 копеек"; };
	it "762.00" => sub { is rur2words(762.00), "семьсот шестьдесят два рубля 00 копеек"; };
	it "763.00" => sub { is rur2words(763.00), "семьсот шестьдесят три рубля 00 копеек"; };
	it "764.00" => sub { is rur2words(764.00), "семьсот шестьдесят четыре рубля 00 копеек"; };
	it "765.00" => sub { is rur2words(765.00), "семьсот шестьдесят пять рублей 00 копеек"; };
	it "766.00" => sub { is rur2words(766.00), "семьсот шестьдесят шесть рублей 00 копеек"; };
	it "767.00" => sub { is rur2words(767.00), "семьсот шестьдесят семь рублей 00 копеек"; };
	it "768.00" => sub { is rur2words(768.00), "семьсот шестьдесят восемь рублей 00 копеек"; };
	it "769.00" => sub { is rur2words(769.00), "семьсот шестьдесят девять рублей 00 копеек"; };
	it "770.00" => sub { is rur2words(770.00), "семьсот семьдесят рублей 00 копеек"; };
	it "771.00" => sub { is rur2words(771.00), "семьсот семьдесят один рубль 00 копеек"; };
	it "772.00" => sub { is rur2words(772.00), "семьсот семьдесят два рубля 00 копеек"; };
	it "773.00" => sub { is rur2words(773.00), "семьсот семьдесят три рубля 00 копеек"; };
	it "774.00" => sub { is rur2words(774.00), "семьсот семьдесят четыре рубля 00 копеек"; };
	it "775.00" => sub { is rur2words(775.00), "семьсот семьдесят пять рублей 00 копеек"; };
	it "776.00" => sub { is rur2words(776.00), "семьсот семьдесят шесть рублей 00 копеек"; };
	it "777.00" => sub { is rur2words(777.00), "семьсот семьдесят семь рублей 00 копеек"; };
	it "778.00" => sub { is rur2words(778.00), "семьсот семьдесят восемь рублей 00 копеек"; };
	it "779.00" => sub { is rur2words(779.00), "семьсот семьдесят девять рублей 00 копеек"; };
	it "780.00" => sub { is rur2words(780.00), "семьсот восемьдесят рублей 00 копеек"; };
	it "781.00" => sub { is rur2words(781.00), "семьсот восемьдесят один рубль 00 копеек"; };
	it "782.00" => sub { is rur2words(782.00), "семьсот восемьдесят два рубля 00 копеек"; };
	it "783.00" => sub { is rur2words(783.00), "семьсот восемьдесят три рубля 00 копеек"; };
	it "784.00" => sub { is rur2words(784.00), "семьсот восемьдесят четыре рубля 00 копеек"; };
	it "785.00" => sub { is rur2words(785.00), "семьсот восемьдесят пять рублей 00 копеек"; };
	it "786.00" => sub { is rur2words(786.00), "семьсот восемьдесят шесть рублей 00 копеек"; };
	it "787.00" => sub { is rur2words(787.00), "семьсот восемьдесят семь рублей 00 копеек"; };
	it "788.00" => sub { is rur2words(788.00), "семьсот восемьдесят восемь рублей 00 копеек"; };
	it "789.00" => sub { is rur2words(789.00), "семьсот восемьдесят девять рублей 00 копеек"; };
	it "790.00" => sub { is rur2words(790.00), "семьсот девяносто рублей 00 копеек"; };
	it "791.00" => sub { is rur2words(791.00), "семьсот девяносто один рубль 00 копеек"; };
	it "792.00" => sub { is rur2words(792.00), "семьсот девяносто два рубля 00 копеек"; };
	it "793.00" => sub { is rur2words(793.00), "семьсот девяносто три рубля 00 копеек"; };
	it "794.00" => sub { is rur2words(794.00), "семьсот девяносто четыре рубля 00 копеек"; };
	it "795.00" => sub { is rur2words(795.00), "семьсот девяносто пять рублей 00 копеек"; };
	it "796.00" => sub { is rur2words(796.00), "семьсот девяносто шесть рублей 00 копеек"; };
	it "797.00" => sub { is rur2words(797.00), "семьсот девяносто семь рублей 00 копеек"; };
	it "798.00" => sub { is rur2words(798.00), "семьсот девяносто восемь рублей 00 копеек"; };
	it "799.00" => sub { is rur2words(799.00), "семьсот девяносто девять рублей 00 копеек"; };
	it "800.00" => sub { is rur2words(800.00), "восемьсот рублей 00 копеек"; };
	it "801.00" => sub { is rur2words(801.00), "восемьсот один рубль 00 копеек"; };
	it "802.00" => sub { is rur2words(802.00), "восемьсот два рубля 00 копеек"; };
	it "803.00" => sub { is rur2words(803.00), "восемьсот три рубля 00 копеек"; };
	it "804.00" => sub { is rur2words(804.00), "восемьсот четыре рубля 00 копеек"; };
	it "805.00" => sub { is rur2words(805.00), "восемьсот пять рублей 00 копеек"; };
	it "806.00" => sub { is rur2words(806.00), "восемьсот шесть рублей 00 копеек"; };
	it "807.00" => sub { is rur2words(807.00), "восемьсот семь рублей 00 копеек"; };
	it "808.00" => sub { is rur2words(808.00), "восемьсот восемь рублей 00 копеек"; };
	it "809.00" => sub { is rur2words(809.00), "восемьсот девять рублей 00 копеек"; };
	it "810.00" => sub { is rur2words(810.00), "восемьсот десять рублей 00 копеек"; };
	it "811.00" => sub { is rur2words(811.00), "восемьсот одиннадцать рублей 00 копеек"; };
	it "812.00" => sub { is rur2words(812.00), "восемьсот двенадцать рублей 00 копеек"; };
	it "813.00" => sub { is rur2words(813.00), "восемьсот тринадцать рублей 00 копеек"; };
	it "814.00" => sub { is rur2words(814.00), "восемьсот четырнадцать рублей 00 копеек"; };
	it "815.00" => sub { is rur2words(815.00), "восемьсот пятнадцать рублей 00 копеек"; };
	it "816.00" => sub { is rur2words(816.00), "восемьсот шестнадцать рублей 00 копеек"; };
	it "817.00" => sub { is rur2words(817.00), "восемьсот семнадцать рублей 00 копеек"; };
	it "818.00" => sub { is rur2words(818.00), "восемьсот восемнадцать рублей 00 копеек"; };
	it "819.00" => sub { is rur2words(819.00), "восемьсот девятнадцать рублей 00 копеек"; };
	it "820.00" => sub { is rur2words(820.00), "восемьсот двадцать рублей 00 копеек"; };
	it "821.00" => sub { is rur2words(821.00), "восемьсот двадцать один рубль 00 копеек"; };
	it "822.00" => sub { is rur2words(822.00), "восемьсот двадцать два рубля 00 копеек"; };
	it "823.00" => sub { is rur2words(823.00), "восемьсот двадцать три рубля 00 копеек"; };
	it "824.00" => sub { is rur2words(824.00), "восемьсот двадцать четыре рубля 00 копеек"; };
	it "825.00" => sub { is rur2words(825.00), "восемьсот двадцать пять рублей 00 копеек"; };
	it "826.00" => sub { is rur2words(826.00), "восемьсот двадцать шесть рублей 00 копеек"; };
	it "827.00" => sub { is rur2words(827.00), "восемьсот двадцать семь рублей 00 копеек"; };
	it "828.00" => sub { is rur2words(828.00), "восемьсот двадцать восемь рублей 00 копеек"; };
	it "829.00" => sub { is rur2words(829.00), "восемьсот двадцать девять рублей 00 копеек"; };
	it "830.00" => sub { is rur2words(830.00), "восемьсот тридцать рублей 00 копеек"; };
	it "831.00" => sub { is rur2words(831.00), "восемьсот тридцать один рубль 00 копеек"; };
	it "832.00" => sub { is rur2words(832.00), "восемьсот тридцать два рубля 00 копеек"; };
	it "833.00" => sub { is rur2words(833.00), "восемьсот тридцать три рубля 00 копеек"; };
	it "834.00" => sub { is rur2words(834.00), "восемьсот тридцать четыре рубля 00 копеек"; };
	it "835.00" => sub { is rur2words(835.00), "восемьсот тридцать пять рублей 00 копеек"; };
	it "836.00" => sub { is rur2words(836.00), "восемьсот тридцать шесть рублей 00 копеек"; };
	it "837.00" => sub { is rur2words(837.00), "восемьсот тридцать семь рублей 00 копеек"; };
	it "838.00" => sub { is rur2words(838.00), "восемьсот тридцать восемь рублей 00 копеек"; };
	it "839.00" => sub { is rur2words(839.00), "восемьсот тридцать девять рублей 00 копеек"; };
	it "840.00" => sub { is rur2words(840.00), "восемьсот сорок рублей 00 копеек"; };
	it "841.00" => sub { is rur2words(841.00), "восемьсот сорок один рубль 00 копеек"; };
	it "842.00" => sub { is rur2words(842.00), "восемьсот сорок два рубля 00 копеек"; };
	it "843.00" => sub { is rur2words(843.00), "восемьсот сорок три рубля 00 копеек"; };
	it "844.00" => sub { is rur2words(844.00), "восемьсот сорок четыре рубля 00 копеек"; };
	it "845.00" => sub { is rur2words(845.00), "восемьсот сорок пять рублей 00 копеек"; };
	it "846.00" => sub { is rur2words(846.00), "восемьсот сорок шесть рублей 00 копеек"; };
	it "847.00" => sub { is rur2words(847.00), "восемьсот сорок семь рублей 00 копеек"; };
	it "848.00" => sub { is rur2words(848.00), "восемьсот сорок восемь рублей 00 копеек"; };
	it "849.00" => sub { is rur2words(849.00), "восемьсот сорок девять рублей 00 копеек"; };
	it "850.00" => sub { is rur2words(850.00), "восемьсот пятьдесят рублей 00 копеек"; };
	it "851.00" => sub { is rur2words(851.00), "восемьсот пятьдесят один рубль 00 копеек"; };
	it "852.00" => sub { is rur2words(852.00), "восемьсот пятьдесят два рубля 00 копеек"; };
	it "853.00" => sub { is rur2words(853.00), "восемьсот пятьдесят три рубля 00 копеек"; };
	it "854.00" => sub { is rur2words(854.00), "восемьсот пятьдесят четыре рубля 00 копеек"; };
	it "855.00" => sub { is rur2words(855.00), "восемьсот пятьдесят пять рублей 00 копеек"; };
	it "856.00" => sub { is rur2words(856.00), "восемьсот пятьдесят шесть рублей 00 копеек"; };
	it "857.00" => sub { is rur2words(857.00), "восемьсот пятьдесят семь рублей 00 копеек"; };
	it "858.00" => sub { is rur2words(858.00), "восемьсот пятьдесят восемь рублей 00 копеек"; };
	it "859.00" => sub { is rur2words(859.00), "восемьсот пятьдесят девять рублей 00 копеек"; };
	it "860.00" => sub { is rur2words(860.00), "восемьсот шестьдесят рублей 00 копеек"; };
	it "861.00" => sub { is rur2words(861.00), "восемьсот шестьдесят один рубль 00 копеек"; };
	it "862.00" => sub { is rur2words(862.00), "восемьсот шестьдесят два рубля 00 копеек"; };
	it "863.00" => sub { is rur2words(863.00), "восемьсот шестьдесят три рубля 00 копеек"; };
	it "864.00" => sub { is rur2words(864.00), "восемьсот шестьдесят четыре рубля 00 копеек"; };
	it "865.00" => sub { is rur2words(865.00), "восемьсот шестьдесят пять рублей 00 копеек"; };
	it "866.00" => sub { is rur2words(866.00), "восемьсот шестьдесят шесть рублей 00 копеек"; };
	it "867.00" => sub { is rur2words(867.00), "восемьсот шестьдесят семь рублей 00 копеек"; };
	it "868.00" => sub { is rur2words(868.00), "восемьсот шестьдесят восемь рублей 00 копеек"; };
	it "869.00" => sub { is rur2words(869.00), "восемьсот шестьдесят девять рублей 00 копеек"; };
	it "870.00" => sub { is rur2words(870.00), "восемьсот семьдесят рублей 00 копеек"; };
	it "871.00" => sub { is rur2words(871.00), "восемьсот семьдесят один рубль 00 копеек"; };
	it "872.00" => sub { is rur2words(872.00), "восемьсот семьдесят два рубля 00 копеек"; };
	it "873.00" => sub { is rur2words(873.00), "восемьсот семьдесят три рубля 00 копеек"; };
	it "874.00" => sub { is rur2words(874.00), "восемьсот семьдесят четыре рубля 00 копеек"; };
	it "875.00" => sub { is rur2words(875.00), "восемьсот семьдесят пять рублей 00 копеек"; };
	it "876.00" => sub { is rur2words(876.00), "восемьсот семьдесят шесть рублей 00 копеек"; };
	it "877.00" => sub { is rur2words(877.00), "восемьсот семьдесят семь рублей 00 копеек"; };
	it "878.00" => sub { is rur2words(878.00), "восемьсот семьдесят восемь рублей 00 копеек"; };
	it "879.00" => sub { is rur2words(879.00), "восемьсот семьдесят девять рублей 00 копеек"; };
	it "880.00" => sub { is rur2words(880.00), "восемьсот восемьдесят рублей 00 копеек"; };
	it "881.00" => sub { is rur2words(881.00), "восемьсот восемьдесят один рубль 00 копеек"; };
	it "882.00" => sub { is rur2words(882.00), "восемьсот восемьдесят два рубля 00 копеек"; };
	it "883.00" => sub { is rur2words(883.00), "восемьсот восемьдесят три рубля 00 копеек"; };
	it "884.00" => sub { is rur2words(884.00), "восемьсот восемьдесят четыре рубля 00 копеек"; };
	it "885.00" => sub { is rur2words(885.00), "восемьсот восемьдесят пять рублей 00 копеек"; };
	it "886.00" => sub { is rur2words(886.00), "восемьсот восемьдесят шесть рублей 00 копеек"; };
	it "887.00" => sub { is rur2words(887.00), "восемьсот восемьдесят семь рублей 00 копеек"; };
	it "888.00" => sub { is rur2words(888.00), "восемьсот восемьдесят восемь рублей 00 копеек"; };
	it "889.00" => sub { is rur2words(889.00), "восемьсот восемьдесят девять рублей 00 копеек"; };
	it "890.00" => sub { is rur2words(890.00), "восемьсот девяносто рублей 00 копеек"; };
	it "891.00" => sub { is rur2words(891.00), "восемьсот девяносто один рубль 00 копеек"; };
	it "892.00" => sub { is rur2words(892.00), "восемьсот девяносто два рубля 00 копеек"; };
	it "893.00" => sub { is rur2words(893.00), "восемьсот девяносто три рубля 00 копеек"; };
	it "894.00" => sub { is rur2words(894.00), "восемьсот девяносто четыре рубля 00 копеек"; };
	it "895.00" => sub { is rur2words(895.00), "восемьсот девяносто пять рублей 00 копеек"; };
	it "896.00" => sub { is rur2words(896.00), "восемьсот девяносто шесть рублей 00 копеек"; };
	it "897.00" => sub { is rur2words(897.00), "восемьсот девяносто семь рублей 00 копеек"; };
	it "898.00" => sub { is rur2words(898.00), "восемьсот девяносто восемь рублей 00 копеек"; };
	it "899.00" => sub { is rur2words(899.00), "восемьсот девяносто девять рублей 00 копеек"; };
	it "900.00" => sub { is rur2words(900.00), "девятьсот рублей 00 копеек"; };
	it "901.00" => sub { is rur2words(901.00), "девятьсот один рубль 00 копеек"; };
	it "902.00" => sub { is rur2words(902.00), "девятьсот два рубля 00 копеек"; };
	it "903.00" => sub { is rur2words(903.00), "девятьсот три рубля 00 копеек"; };
	it "904.00" => sub { is rur2words(904.00), "девятьсот четыре рубля 00 копеек"; };
	it "905.00" => sub { is rur2words(905.00), "девятьсот пять рублей 00 копеек"; };
	it "906.00" => sub { is rur2words(906.00), "девятьсот шесть рублей 00 копеек"; };
	it "907.00" => sub { is rur2words(907.00), "девятьсот семь рублей 00 копеек"; };
	it "908.00" => sub { is rur2words(908.00), "девятьсот восемь рублей 00 копеек"; };
	it "909.00" => sub { is rur2words(909.00), "девятьсот девять рублей 00 копеек"; };
	it "910.00" => sub { is rur2words(910.00), "девятьсот десять рублей 00 копеек"; };
	it "911.00" => sub { is rur2words(911.00), "девятьсот одиннадцать рублей 00 копеек"; };
	it "912.00" => sub { is rur2words(912.00), "девятьсот двенадцать рублей 00 копеек"; };
	it "913.00" => sub { is rur2words(913.00), "девятьсот тринадцать рублей 00 копеек"; };
	it "914.00" => sub { is rur2words(914.00), "девятьсот четырнадцать рублей 00 копеек"; };
	it "915.00" => sub { is rur2words(915.00), "девятьсот пятнадцать рублей 00 копеек"; };
	it "916.00" => sub { is rur2words(916.00), "девятьсот шестнадцать рублей 00 копеек"; };
	it "917.00" => sub { is rur2words(917.00), "девятьсот семнадцать рублей 00 копеек"; };
	it "918.00" => sub { is rur2words(918.00), "девятьсот восемнадцать рублей 00 копеек"; };
	it "919.00" => sub { is rur2words(919.00), "девятьсот девятнадцать рублей 00 копеек"; };
	it "920.00" => sub { is rur2words(920.00), "девятьсот двадцать рублей 00 копеек"; };
	it "921.00" => sub { is rur2words(921.00), "девятьсот двадцать один рубль 00 копеек"; };
	it "922.00" => sub { is rur2words(922.00), "девятьсот двадцать два рубля 00 копеек"; };
	it "923.00" => sub { is rur2words(923.00), "девятьсот двадцать три рубля 00 копеек"; };
	it "924.00" => sub { is rur2words(924.00), "девятьсот двадцать четыре рубля 00 копеек"; };
	it "925.00" => sub { is rur2words(925.00), "девятьсот двадцать пять рублей 00 копеек"; };
	it "926.00" => sub { is rur2words(926.00), "девятьсот двадцать шесть рублей 00 копеек"; };
	it "927.00" => sub { is rur2words(927.00), "девятьсот двадцать семь рублей 00 копеек"; };
	it "928.00" => sub { is rur2words(928.00), "девятьсот двадцать восемь рублей 00 копеек"; };
	it "929.00" => sub { is rur2words(929.00), "девятьсот двадцать девять рублей 00 копеек"; };
	it "930.00" => sub { is rur2words(930.00), "девятьсот тридцать рублей 00 копеек"; };
	it "931.00" => sub { is rur2words(931.00), "девятьсот тридцать один рубль 00 копеек"; };
	it "932.00" => sub { is rur2words(932.00), "девятьсот тридцать два рубля 00 копеек"; };
	it "933.00" => sub { is rur2words(933.00), "девятьсот тридцать три рубля 00 копеек"; };
	it "934.00" => sub { is rur2words(934.00), "девятьсот тридцать четыре рубля 00 копеек"; };
	it "935.00" => sub { is rur2words(935.00), "девятьсот тридцать пять рублей 00 копеек"; };
	it "936.00" => sub { is rur2words(936.00), "девятьсот тридцать шесть рублей 00 копеек"; };
	it "937.00" => sub { is rur2words(937.00), "девятьсот тридцать семь рублей 00 копеек"; };
	it "938.00" => sub { is rur2words(938.00), "девятьсот тридцать восемь рублей 00 копеек"; };
	it "939.00" => sub { is rur2words(939.00), "девятьсот тридцать девять рублей 00 копеек"; };
	it "940.00" => sub { is rur2words(940.00), "девятьсот сорок рублей 00 копеек"; };
	it "941.00" => sub { is rur2words(941.00), "девятьсот сорок один рубль 00 копеек"; };
	it "942.00" => sub { is rur2words(942.00), "девятьсот сорок два рубля 00 копеек"; };
	it "943.00" => sub { is rur2words(943.00), "девятьсот сорок три рубля 00 копеек"; };
	it "944.00" => sub { is rur2words(944.00), "девятьсот сорок четыре рубля 00 копеек"; };
	it "945.00" => sub { is rur2words(945.00), "девятьсот сорок пять рублей 00 копеек"; };
	it "946.00" => sub { is rur2words(946.00), "девятьсот сорок шесть рублей 00 копеек"; };
	it "947.00" => sub { is rur2words(947.00), "девятьсот сорок семь рублей 00 копеек"; };
	it "948.00" => sub { is rur2words(948.00), "девятьсот сорок восемь рублей 00 копеек"; };
	it "949.00" => sub { is rur2words(949.00), "девятьсот сорок девять рублей 00 копеек"; };
	it "950.00" => sub { is rur2words(950.00), "девятьсот пятьдесят рублей 00 копеек"; };
	it "951.00" => sub { is rur2words(951.00), "девятьсот пятьдесят один рубль 00 копеек"; };
	it "952.00" => sub { is rur2words(952.00), "девятьсот пятьдесят два рубля 00 копеек"; };
	it "953.00" => sub { is rur2words(953.00), "девятьсот пятьдесят три рубля 00 копеек"; };
	it "954.00" => sub { is rur2words(954.00), "девятьсот пятьдесят четыре рубля 00 копеек"; };
	it "955.00" => sub { is rur2words(955.00), "девятьсот пятьдесят пять рублей 00 копеек"; };
	it "956.00" => sub { is rur2words(956.00), "девятьсот пятьдесят шесть рублей 00 копеек"; };
	it "957.00" => sub { is rur2words(957.00), "девятьсот пятьдесят семь рублей 00 копеек"; };
	it "958.00" => sub { is rur2words(958.00), "девятьсот пятьдесят восемь рублей 00 копеек"; };
	it "959.00" => sub { is rur2words(959.00), "девятьсот пятьдесят девять рублей 00 копеек"; };
	it "960.00" => sub { is rur2words(960.00), "девятьсот шестьдесят рублей 00 копеек"; };
	it "961.00" => sub { is rur2words(961.00), "девятьсот шестьдесят один рубль 00 копеек"; };
	it "962.00" => sub { is rur2words(962.00), "девятьсот шестьдесят два рубля 00 копеек"; };
	it "963.00" => sub { is rur2words(963.00), "девятьсот шестьдесят три рубля 00 копеек"; };
	it "964.00" => sub { is rur2words(964.00), "девятьсот шестьдесят четыре рубля 00 копеек"; };
	it "965.00" => sub { is rur2words(965.00), "девятьсот шестьдесят пять рублей 00 копеек"; };
	it "966.00" => sub { is rur2words(966.00), "девятьсот шестьдесят шесть рублей 00 копеек"; };
	it "967.00" => sub { is rur2words(967.00), "девятьсот шестьдесят семь рублей 00 копеек"; };
	it "968.00" => sub { is rur2words(968.00), "девятьсот шестьдесят восемь рублей 00 копеек"; };
	it "969.00" => sub { is rur2words(969.00), "девятьсот шестьдесят девять рублей 00 копеек"; };
	it "970.00" => sub { is rur2words(970.00), "девятьсот семьдесят рублей 00 копеек"; };
	it "971.00" => sub { is rur2words(971.00), "девятьсот семьдесят один рубль 00 копеек"; };
	it "972.00" => sub { is rur2words(972.00), "девятьсот семьдесят два рубля 00 копеек"; };
	it "973.00" => sub { is rur2words(973.00), "девятьсот семьдесят три рубля 00 копеек"; };
	it "974.00" => sub { is rur2words(974.00), "девятьсот семьдесят четыре рубля 00 копеек"; };
	it "975.00" => sub { is rur2words(975.00), "девятьсот семьдесят пять рублей 00 копеек"; };
	it "976.00" => sub { is rur2words(976.00), "девятьсот семьдесят шесть рублей 00 копеек"; };
	it "977.00" => sub { is rur2words(977.00), "девятьсот семьдесят семь рублей 00 копеек"; };
	it "978.00" => sub { is rur2words(978.00), "девятьсот семьдесят восемь рублей 00 копеек"; };
	it "979.00" => sub { is rur2words(979.00), "девятьсот семьдесят девять рублей 00 копеек"; };
	it "980.00" => sub { is rur2words(980.00), "девятьсот восемьдесят рублей 00 копеек"; };
	it "981.00" => sub { is rur2words(981.00), "девятьсот восемьдесят один рубль 00 копеек"; };
	it "982.00" => sub { is rur2words(982.00), "девятьсот восемьдесят два рубля 00 копеек"; };
	it "983.00" => sub { is rur2words(983.00), "девятьсот восемьдесят три рубля 00 копеек"; };
	it "984.00" => sub { is rur2words(984.00), "девятьсот восемьдесят четыре рубля 00 копеек"; };
	it "985.00" => sub { is rur2words(985.00), "девятьсот восемьдесят пять рублей 00 копеек"; };
	it "986.00" => sub { is rur2words(986.00), "девятьсот восемьдесят шесть рублей 00 копеек"; };
	it "987.00" => sub { is rur2words(987.00), "девятьсот восемьдесят семь рублей 00 копеек"; };
	it "988.00" => sub { is rur2words(988.00), "девятьсот восемьдесят восемь рублей 00 копеек"; };
	it "989.00" => sub { is rur2words(989.00), "девятьсот восемьдесят девять рублей 00 копеек"; };
	it "990.00" => sub { is rur2words(990.00), "девятьсот девяносто рублей 00 копеек"; };
	it "991.00" => sub { is rur2words(991.00), "девятьсот девяносто один рубль 00 копеек"; };
	it "992.00" => sub { is rur2words(992.00), "девятьсот девяносто два рубля 00 копеек"; };
	it "993.00" => sub { is rur2words(993.00), "девятьсот девяносто три рубля 00 копеек"; };
	it "994.00" => sub { is rur2words(994.00), "девятьсот девяносто четыре рубля 00 копеек"; };
	it "995.00" => sub { is rur2words(995.00), "девятьсот девяносто пять рублей 00 копеек"; };
	it "996.00" => sub { is rur2words(996.00), "девятьсот девяносто шесть рублей 00 копеек"; };
	it "997.00" => sub { is rur2words(997.00), "девятьсот девяносто семь рублей 00 копеек"; };
	it "998.00" => sub { is rur2words(998.00), "девятьсот девяносто восемь рублей 00 копеек"; };
	it "999.00" => sub { is rur2words(999.00), "девятьсот девяносто девять рублей 00 копеек"; };
};

runtests unless caller;
