use strict;
use warnings;
use Test::More;
use Finance::Quote;

if (not $ENV{ONLINE_TEST}) {
    plan skip_all => 'Set $ENV{ONLINE_TEST} to run this test';
}

my $q      = Finance::Quote->new();

my @q = qw/ AAPL ADSK AFAM AFSI AHS AIG ALG AMBA AMT AMZN AN AP APOG ARCO ARO ASR ATHN ATVI AVAV BBY BIDU BIIB BKE BLX BMC BOOM BPI BR BRK-B BWLD CACC CBRL CBST CGA CINF CME COH COO COST CRH CROX CTAS CVA DDD DGS DNR DOW DVA DVN EBAY EBIX ERJ ESRX EXEL FB FLPKX GD GHDX GILD GOOG GOOGL GTI HAS HI HY IART IBKR ICON INFN INTC INVN IPGP IRM ISCA IYR JACK JBT KMX KNX KORS LDL LF LL LLL LNKD LOW LTM MA MCD MCF MCO MDP MDT MKL MOD MOV MSFT NFLX NOC NOK NVDA O OME ORCL OTEX PACR PAYX PCAR PEB PERY PHYS PNW POT PRAA RLI ROIC RPXC RRGB SAFM SBUX SCTY SE SH SHFL SINA SKX SLAB SNV SONC SPY SSW STON SUP SWPPX SYNA SZYM TECUA TGH TOL TSLA TTC TTS TUP TWI  ULTA UNH USMO VIIIX WFC WFM WM WMT WU XLK YONG ZINC /;

my %quotes = $q->yahoo( @q );

ok(%quotes, "Quote hash defined" );

foreach my $q (@q) {
  my $last = $quotes{$q,"last"};
  ok( $last > 0, "$q: $last>0" );
}

done_testing( 1+@q );
