use 5.006;
use strict;
use warnings;

use ExtUtils::MakeMaker;

WriteMakefile(
    ABSTRACT_FROM => 'lib/Cache/Memcached/Fast.pm',
    AUTHOR        => 'Tomash Brechko <tomash.brechko@gmail.com>',
    LICENSE       => 'perl_5',
    MYEXTLIB      => 'src/libclient$(LIB_EXT)',
    NAME          => 'Cache::Memcached::Fast',
    PREREQ_PM     => { 'Test::More' => 0 },
    VERSION_FROM  => 'lib/Cache/Memcached/Fast.pm',
    META_MERGE    => {
        'meta-spec' => { version => 2 },
        'resources' => {
            repository => {
                type => 'git',
                url  => 'git://github.com/JRaspass/Cache-Memcached-Fast.git',
                web  => 'https://github.com/JRaspass/Cache-Memcached-Fast',
            },
        },
    },
);

sub MY::postamble { <<'MAKE' }
$(MYEXTLIB): src/Makefile
	cd src && $(MAKE) $(PASTHRU)

bench: all
	$(PERL) -I./blib/lib -I./blib/arch script/benchmark.pl \
	    localhost:11211 127.0.0.1:11211
MAKE
