package Travel::Status::DE::HAFAS::Services;

# vim:readonly
# This module has been automatically generated
# by lib/Travel/Status/DE/HAFAS/Services.pm.PL.
# Do not edit, changes will be lost.

use strict;
use warnings;
use 5.014;
use utf8;

our $VERSION = '6.07';

# Most of these have been adapted from
# <https://github.com/public-transport/transport-apis> and
# <https://github.com/public-transport/hafas-client/tree/main/p>.
# Many thanks to Jannis R / @derhuerst and all contributors for maintaining
# these resources.

my $hafas_instance = {'AVV' => {'homepage' => 'https://avv.de/','languages' => ['de'],'mgate' => 'https://auskunft.avv.de/bin/mgate.exe','name' => 'Aachener Verkehrsverbund','productbits' => [['regional-train','Regionalzug'],['long-distance-train','Fernzug'],['express-train','ICE/Thalys'],['fernbus','Fernbus'],['suburban-train','S-Bahn'],['subway','U-Bahn'],['tram',"Stra\x{df}enbahn"],['bus','Bus'],['added-bus',"Bus, Verst\x{e4}rkerfahrt"],['on-call','Bedarfsverkehr'],['ferry',"F\x{e4}hre"]],'request' => {'auth' => {'aid' => '4vV1AcH3N511icH','type' => 'AID'},'client' => {'id' => 'AVV_AACHEN','l' => 'vs_avv','name' => 'webapp','type' => 'WEB'},'lang' => 'deu','ver' => '1.26'},'stopfinder' => 'https://auskunft.avv.de/bin/ajax-getstop.exe','time_zone' => 'Europe/Berlin'},'BART' => {'homepage' => 'https://bart.gov/','languages' => ['en','es'],'mgate' => 'https://planner.bart.gov/bin/mgate.exe','name' => 'Bay Area Rapid Transit','productbits' => [['_',undef],['_',undef],['cable-car','cable car'],['_',undef],['_',undef],['regional-train','regional trains (Caltrain, Capitol Corridor, ACE)'],['_',undef],['_',undef],['_',undef],['bus','Bus'],['_',undef],['_',undef],['_',undef],['ferry','Ferry'],['_',undef],['_',undef],['_',undef],['bart','BART'],['_',undef],['_',undef],['_',undef],['tram','Tram']],'request' => {'auth' => {'aid' => 'kEwHkFUCIL500dym','type' => 'AID'},'client' => {'id' => 'BART','l' => 'vs_webapp','name' => 'webapp','type' => 'WEB'},'lang' => 'en','ver' => '1.40'},'stopfinder' => 'https://planner.bart.gov/bin/ajax-getstop.exe','time_zone' => 'America/Los_Angeles'},'BLS' => {'homepage' => 'https://www.bls.ch/','languages' => ['de','fr','it','en'],'mgate' => 'https://bls.hafas.de/bin/mgate.exe','name' => 'BLS AG','productbits' => [['ice','ICE'],['ic-ec','IC/EC'],['ir','IR'],['local','Nahverkehr'],['watercraft','Schiff'],['s-bahn','S-Bahn'],['bus','Bus'],['gondola','Seilbahn'],['_',undef],['tram','Tram'],['_',undef],['_',undef],['_',undef],['car-shuttle-train','Autoverlad']],'request' => {'auth' => {'aid' => '3jkAncud78HSoqclmN54812A','type' => 'AID'},'client' => {'id' => 'HAFAS','l' => 'vs_webapp','name' => 'webapp','type' => 'WEB'},'lang' => 'deu','ver' => '1.46'},'stopfinder' => 'https://bls.hafas.de/bin/ajax-stopfinder.exe','time_zone' => 'Europe/Zurich'},'BVG' => {'homepage' => 'https://www.bvg.de/','languages' => ['de','en'],'mgate' => 'https://bvg-apps-ext.hafas.de/bin/mgate.exe','name' => 'Berliner Verkehrsbetriebe','productbits' => [['suburban','S-Bahn'],['subway','U-Bahn'],['tram','Tram'],['bus','Bus'],['ferry',"F\x{e4}hre"],['express','IC/ICE'],['regional','RB/RE']],'request' => {'auth' => {'aid' => 'dVg4TZbW8anjx9ztPwe2uk4LVRi9wO','type' => 'AID'},'client' => {'id' => 'VBB','l' => 'vs_webapp','name' => 'webapp','type' => 'WEB','v' => 10002},'ext' => 'BVG.1','lang' => 'deu','ver' => '1.72'},'stopfinder' => 'https://bvg-apps-ext.hafas.de/bin/ajax-getstop.exe','time_zone' => 'Europe/Berlin'},'CMTA' => {'homepage' => 'https://www.capmetro.org/','languages' => ['en'],'mgate' => 'https://capmetro.hafas.cloud/bin/mgate.exe','name' => 'Capital Metro Austin Public Transport','productbits' => [['_',undef],['_',undef],['_',undef],['rail','MetroRail'],['_',undef],['_',undef],['_',undef],['_',undef],['bus','MetroBus'],['_',undef],['_',undef],['_',undef],['_',undef],['_',undef],['_',undef],['_',undef],['_',undef],['_',undef],['_',undef],['rapid','MetroRapid']],'request' => {'auth' => {'aid' => 'ioslaskdcndrjcmlsd','type' => 'AID'},'client' => {'id' => 'CMTA','name' => 'CapMetro','type' => 'IPH','v' => '2'},'lang' => 'en','ver' => '1.40'},'stopfinder' => 'https://capmetro.hafas.cloud/bin/ajax-getstop.exe','time_zone' => 'America/Chicago'},'DB' => {'homepage' => 'https://www.bahn.de/','languages' => ['de','en','fr','es'],'mgate' => 'https://reiseauskunft.bahn.de/bin/mgate.exe','name' => 'Deutsche Bahn','productbits' => [['express-train','Long-distance train (ICE)'],['long-distance-train','Long-Distance Train (IC/EC)'],['local-train','Local Train (D)'],['regional-train','Local Train (RE/RB)'],['rapid-transit','Rapid Transit (S)'],['bus','Bus'],['ferry','Ferry'],['metro','Metro'],['tram','Tram'],['taxi','Taxi']],'request' => {'auth' => {'aid' => 'n91dB8Z77MLdoR0K','type' => 'AID'},'client' => {'id' => 'DB','name' => 'DB Navigator','type' => 'IPH','v' => '20100000'},'ext' => 'DB.R21.12.a','lang' => 'deu','ver' => '1.18'},'salt' => 'bdI8UVj40K5fvxwf','stopfinder' => 'https://reiseauskunft.bahn.de/bin/ajax-getstop.exe','time_zone' => 'Europe/Berlin'},'IE' => {'homepage' => 'https://www.irishrail.ie/','languages' => ['en','ga'],'mgate' => 'https://journeyplanner.irishrail.ie/bin/mgate.exe','micmac' => 1,'name' => "Iarnród Éireann",'productbits' => [['_',undef],['intercity','InterCity'],['_',undef],['_',undef],['commuter','Commuter'],['_',undef],['_',undef],['dart','Dublin Area Rapid Transit'],['_',undef],['_',undef],['_',undef],['luas','LUAS Tram']],'request' => {'auth' => {'aid' => 'P9bplgVCGnozdgQE','type' => 'AID'},'client' => {'id' => 'IRISHRAIL','name' => 'IrishRailPROD-APPSTORE','os' => 'iOS 12.4.8','type' => 'IPA','v' => '4000100'},'lang' => 'en','ver' => '1.33'},'salt' => 'i5s7m3q9z6b4k1c2','stopfinder' => 'https://journeyplanner.irishrail.ie/bin/ajax-getstop.exe','time_zone' => 'Europe/Dublin'},'KVB' => {'homepage' => 'https://kvb.koeln/','languages' => ['de'],'mgate' => 'https://auskunft.kvb.koeln/gate','name' => "Kölner Verkehrs-Betriebe",'productbits' => [['s-bahn','S-Bahn'],['stadtbahn','Stadtbahn'],['_',undef],['bus','Bus'],['_',undef],['regionalverkehr','Regionalverkehr'],['_',undef],['fernverkehr','Fernverkehr'],['_',undef],['_',undef],['_',undef],['taxibus','Taxibus']],'request' => {'auth' => {'aid' => 'Rt6foY5zcTTRXMQs','type' => 'AID'},'client' => {'id' => 'HAFAS','l' => 'vs_webapp','name' => 'webapp','type' => 'WEB','v' => '154'},'lang' => 'deu','ver' => '1.58'},'time_zone' => 'Europe/Berlin'},'NAHSH' => {'homepage' => 'https://www.nah.sh/','languages' => ['de'],'mgate' => 'https://nah.sh.hafas.de/bin/mgate.exe','name' => 'Nahverkehrsverbund Schleswig-Holstein','productbits' => [['highspeed','High-speed rail'],['national','InterCity & EuroCity'],['interregional','Interregional'],['regional','Regional & RegionalExpress'],['suburban','S-Bahn'],['bus','Bus'],['ferry','Ferry'],['subway','U-Bahn'],['tram','Tram'],['onCall','On-call transit']],'request' => {'auth' => {'aid' => 'r0Ot9FLFNAFxijLW','type' => 'AID'},'client' => {'id' => 'NAHSH','name' => 'NAHSHPROD','type' => 'IPH','v' => '3000700'},'ver' => '1.16'},'stopfinder' => 'https://nah.sh.hafas.de/bin/ajax-getstop.exe','time_zone' => 'Europe/Berlin'},'NASA' => {'homepage' => 'https://www.nasa.de/','languages' => ['de','en'],'mgate' => 'https://reiseauskunft.insa.de/bin/mgate.exe','name' => 'Personennahverkehr in Sachsen-Anhalt','productbits' => [['intercityexpress','InterCityExpress'],['national','InterCity & EuroCity'],['_',undef],['regional','RegionalExpress & RegionalBahn'],['_',undef],['suburban','S-Bahn'],['_',undef],['tram','Tram'],['_',undef],['bus','Bus'],['_',undef],['bus','Bus'],['_',undef],['tourismTrain','Tourism Train']],'request' => {'auth' => {'aid' => 'nasa-apps','type' => 'AID'},'client' => {'id' => 'NASA','name' => 'nasaPROD','os' => 'iPhone OS 11.2.5','type' => 'IPH','v' => '4000200'},'lang' => 'deu','ver' => '1.18'},'stopfinder' => 'https://reiseauskunft.insa.de/bin/ajax-getstop.exe','time_zone' => 'Europe/Berlin'},'NVV' => {'homepage' => 'https://www.nvv.de/','languages' => ['de'],'mgate' => 'https://auskunft.nvv.de/auskunft/bin/app/mgate.exe','name' => 'Nordhessischer Verkehrsverbund','productbits' => [['express','InterCityExpress'],['national','EuroCity/InterCity'],['tram','Tram'],['regiotram','RegioTram'],['regiotram','RegioTram'],['tram','Tram'],['bus','Bus'],['bus','Bus'],['_',undef],['on-call','AnrufSammelTaxi'],['_',undef],['regiotram','RegioTram']],'request' => {'auth' => {'aid' => 'Kt8eNOH7qjVeSxNA','type' => 'AID'},'client' => {'id' => 'NVV','name' => 'NVVMobilPROD_APPSTORE','os' => 'iOS 12.1.4','type' => 'IPH','v' => '5000300'},'ext' => 'NVV.6.0','lang' => 'deu','ver' => '1.18'},'stopfinder' => 'https://auskunft.nvv.de/auskunft/bin/jp/ajax-getstop.exe','time_zone' => 'Europe/Berlin'},'RMV' => {'homepage' => 'https://www.rmv.de/','languages' => ['de','en'],'mgate' => 'https://www.rmv.de/auskunft/bin/jp/mgate.exe','name' => 'Rhein-Main-Verkehrsverbund','productbits' => [['express-train','InterCityExpress/Fernzug'],['long-distance-train','EuroCity/InterCity/EuroNight/InterRegio'],['regional-train','RegionalExpress/Regionalbahn'],['s-bahn','S-Bahn'],['u-bahn','U-Bahn'],['tram',"Stra\x{df}enbahn"],['bus','Bus'],['bus','Bus'],['watercraft','Schiff'],['ast','Anruf-Sammel-Taxi'],['cable-car','Seilbahn']],'request' => {'auth' => {'aid' => 'x0k4ZR33ICN9CWmj','type' => 'AID'},'client' => {'id' => 'RMV','name' => 'webapp','type' => 'WEB'},'ext' => 'RMV.1','lang' => 'deu','ver' => '1.18'},'time_zone' => 'Europe/Berlin'},'RSAG' => {'homepage' => 'https://www.rsag-online.de','languages' => ['de','en','fr'],'mgate' => 'https://fahrplan.rsag-online.de/bin/mgate.exe','name' => "Rostocker Stra\x{df}enbahn",'productbits' => [['ice','InterCityExpress'],['ic-ec','InterCity & EuroCity'],['long-distance-train','InterRegio/high-speed train'],['regional-train','regional train'],['s-bahn','S-Bahn'],['bus','Bus'],['ferry','Schiff'],['u-bahn','U-Bahn'],['tram','Tram'],['on-call','Taxi/on-call vehicle']],'request' => {'auth' => {'aid' => 'tF5JTs25rzUhGrrl','type' => 'AID'},'client' => {'id' => 'RSAG','name' => 'webapp','type' => 'WEB'},'ext' => 'VBN.2','lang' => 'deu','ver' => '1.24'},'time_zone' => 'Europe/Berlin'},'STV' => {'homepage' => 'https://verbundlinie.at/','languages' => ['de','en'],'mgate' => 'https://verkehrsauskunft.verbundlinie.at/bin/mgate.exe','name' => 'Steirischer Verkehrsverbund','productbits' => [['trains','Bahn & S-Bahn'],['trains','Bahn & S-Bahn'],['subway','U-Bahn'],['_',undef],['tram',"Stra\x{df}enbahn"],['_',undef],['long-distance-bus','Fernbus'],['_',undef],['regional-bus','Regionalbus'],['_',undef],['city-bus','Stadtbus'],['_',undef],['aerial-lift','Seil-/Zahnradbahn'],['_',undef],['ferry','Schiff'],['_',undef],['on-call','Anrufbus'],['_',undef],['other','Sonstige']],'request' => {'auth' => {'aid' => 'wf7mcf9bv3nv8g5f','type' => 'AID'},'client' => {'id' => 'VAO','l' => 'vs_stv','name' => 'webapp','type' => 'WEB'},'ext' => 'VAO.13','lang' => 'deu','ver' => '1.32'},'time_zone' => 'Europe/Vienna'},'VBB' => {'homepage' => 'https://www.vbb.de/','languages' => ['de','en'],'mgate' => 'https://fahrinfo.vbb.de/bin/mgate.exe','name' => 'Verkehrsverbund Berlin-Brandenburg','productbits' => [['suburban','S-Bahn'],['subway','U-Bahn'],['tram','Tram'],['bus','Bus'],['ferry',"F\x{e4}hre"],['express','IC/ICE'],['regional','RB/RE']],'request' => {'auth' => {'aid' => 'hafas-vbb-webapp','type' => 'AID'},'client' => {'id' => 'VBB','l' => 'vs_webapp_vbb','name' => 'VBB WebApp','type' => 'WEB'},'ext' => 'VBB.1','lang' => 'deu','ver' => '1.33'},'stopfinder' => 'https://fahrinfo.vbb.de/bin/ajax-getstop.exe','time_zone' => 'Europe/Berlin'},'VBN' => {'homepage' => 'https://www.vbn.de/','languages' => ['de','en'],'mgate' => 'https://fahrplaner.vbn.de/bin/mgate.exe','micmac' => 1,'name' => 'Verkehrsverbund Bremen/Niedersachsen','productbits' => [['express-train','InterCityExpress'],['national-train','InterCity, EuroCity, CityNightLine, InterRegio'],['national-train','InterCity, EuroCity, CityNightLine, InterRegio'],['local-train','Nahverkehr'],['suburban','S-Bahn'],['bus','Bus'],['watercraft','Schiff'],['subway','U-Bahn'],['tram','Tram'],['dial-a-ride','Anrufverkehr']],'request' => {'auth' => {'aid' => 'kaoxIXLn03zCr2KR','type' => 'AID'},'client' => {'id' => 'VBN','name' => 'vbn','type' => 'IPH','v' => '6000000'},'lang' => 'deu','ver' => '1.42'},'salt' => 'SP31mBufSyCLmNxp','stopfinder' => 'https://fahrplaner.vbn.de/hafas/ajax-getstop.exe','time_zone' => 'Europe/Berlin'},'VMT' => {'homepage' => 'https://www.vmt-thueringen.de/','languages' => ['de'],'mgate' => 'https://vmt.hafas.de/bin/ticketing/mgate.exe','micmac' => 1,'name' => "Verkehrsverbund Mittelthüringen",'productbits' => [['long-distance-train','long-distance train'],['long-distance-train','long-distance train'],['long-distance-train','long-distance train'],['regional-train','regional train'],['regional-train','regional train'],['tram','tram'],['_',undef],['_',undef],['bus','bus']],'request' => {'auth' => {'aid' => 't2h7u1e6r4i8n3g7e0n','type' => 'AID'},'client' => {'id' => 'HAFAS','name' => 'VMT','type' => 'IPH','v' => '2040100'},'lang' => 'deu','ver' => '1.34'},'salt' => '7x8d3n2a5m1b3c6z','time_zone' => 'Europe/Berlin'},'VOS' => {'homepage' => 'https://vos.info/','languages' => ['de'],'mgate' => 'https://fahrplan.vos.info/bin/mgate.exe','name' => "Verkehrsgemeinschaft Osnabrück",'productbits' => [['ice','ICE'],['national-train','IC/EC'],['express-train','IR, sonstiger Schnellzug'],['local-train','Nahverkehr'],['suburban-train','S-Bahn'],['bus','Bus'],['ferry','Schiff'],['subway','U-Bahn'],['tram','Tram'],['on-call','Anrufverkehr']],'request' => {'auth' => {'aid' => 'PnYowCQP7Tp1V','type' => 'AID'},'client' => {'id' => 'SWO','l' => 'vs_swo','name' => 'webapp','type' => 'WEB'},'lang' => 'deu','ver' => '1.72'},'stopfinder' => 'https://fahrplan.vos.info/bin/ajax-getstop.exe','time_zone' => 'Europe/Berlin'},'VRN' => {'homepage' => 'https://www.vrn.de/','languages' => ['de','en'],'mgate' => 'https://vrn.hafas.de/bin/mgate.exe','name' => 'Verkehrsverbund Rhein-Neckar','productbits' => [['long-distance-train','long-distance train'],['long-distance-train','long-distance train'],['long-distance-train','long-distance train'],['regional-train','regional train'],['urban-train','urban train'],['bus','Bus'],['_',undef],['subway','subway'],['_',undef],['tram','tram'],['_',undef],['dial-a-ride','dial-a-ride']],'request' => {'auth' => {'aid' => 'p091VRNZz79KtUz5','type' => 'AID'},'client' => {'id' => 'DB-REGIO-VRN','name' => 'VRN','type' => 'IPH','v' => '6000400'},'ext' => 'DB.R19.04.a','lang' => 'deu','ver' => '1.24'},'time_zone' => 'Europe/Berlin'},"ÖBB" => {'homepage' => 'https://www.oebb.at/','languages' => ['de'],'mgate' => 'https://fahrplan.oebb.at/bin/mgate.exe','name' => "Österreichische Bundesbahnen",'productbits' => [['express-train','InterCityExpress & RailJet'],['long-distance-train-1','InterCity & EuroCity'],['long-distance-train-2','InterCity & EuroCity'],['long-distance-train-3','Durchgangszug & EuroNight'],['regional-train','Regional & RegionalExpress'],['suburban','S-Bahn'],['bus','Bus'],['ferry','Ferry'],['subway','U-Bahn'],['tram','Tram'],['_',undef],['on-call','on-call transit, lifts, etc'],['_',undef],['long-distance-train-4','Durchgangszug & EuroNight']],'request' => {'auth' => {'aid' => 'OWDL4fE4ixNiPBBm','type' => 'AID'},'client' => {'id' => 'OEBB','name' => 'oebbPROD-ADHOC','type' => 'IPH','v' => '6030600'},'lang' => 'deu','ver' => '1.57'},'stopfinder' => 'https://fahrplan.oebb.at/bin/ajax-getstop.exe','time_zone' => 'Europe/Vienna'}};
sub get_service_ref {
	return $hafas_instance;
}

sub get_service_map {
	return %{$hafas_instance};
}

1;
