/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.MyPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvgAttributes {
    private final Map<String, String> attributes = new TreeMap<String, String>();

    public SvgAttributes() {
    }

    private SvgAttributes(SvgAttributes svgAttributes) {
        this.attributes.putAll(svgAttributes.attributes);
    }

    public SvgAttributes(String string) {
        Pattern pattern = MyPattern.cmpile("(\\w+)\\s*=\\s*([%g][^%g]*[%g]|(?:\\w+))");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            this.attributes.put(matcher.group(1), StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(matcher.group(2)));
        }
    }

    public Map<String, String> attributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public SvgAttributes add(String string, String string2) {
        SvgAttributes svgAttributes = new SvgAttributes(this);
        svgAttributes.attributes.put(string, string2);
        return svgAttributes;
    }

    public SvgAttributes add(SvgAttributes svgAttributes) {
        SvgAttributes svgAttributes2 = new SvgAttributes(this);
        svgAttributes2.attributes.putAll(svgAttributes.attributes);
        return svgAttributes2;
    }
}

