/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.Rule;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.StringUtils;
import java.io.Serializable;

public class UnaryRule
implements Rule,
Comparable<UnaryRule>,
Serializable {
    public int parent;
    public float score;
    public int child;
    private static final char[] charsToEscape = new char[]{'\"'};
    private transient String cached;
    private static final long serialVersionUID = 1L;

    public UnaryRule(int parent, int child) {
        this.parent = parent;
        this.child = child;
        this.score = Float.NaN;
    }

    public UnaryRule(int parent, int child, double score) {
        this.parent = parent;
        this.child = child;
        this.score = (float)score;
    }

    public UnaryRule(String s, Index<String> index) {
        String[] fields = StringUtils.splitOnCharWithQuoting(s, ' ', '\"', '\\');
        this.parent = index.indexOf(fields[0]);
        this.child = index.indexOf(fields[2]);
        this.score = Float.parseFloat(fields[3]);
    }

    @Override
    public float score() {
        return this.score;
    }

    @Override
    public int parent() {
        return this.parent;
    }

    public int hashCode() {
        return this.parent << 16 ^ this.child;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UnaryRule) {
            UnaryRule ur = (UnaryRule)o;
            if (this.parent == ur.parent && this.child == ur.child) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int compareTo(UnaryRule ur) {
        if (this.parent < ur.parent) {
            return -1;
        }
        if (this.parent > ur.parent) {
            return 1;
        }
        if (this.child < ur.child) {
            return -1;
        }
        if (this.child > ur.child) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.parent + " -> " + this.child + ' ' + this.score;
    }

    public String toString(Index<String> index) {
        return '\"' + StringUtils.escapeString(index.get(this.parent), charsToEscape, '\\') + "\" -> \"" + StringUtils.escapeString(index.get(this.child), charsToEscape, '\\') + "\" " + this.score;
    }

    public String toStringNoScore(Index<String> index) {
        if (this.cached == null) {
            this.cached = '\"' + StringUtils.escapeString(index.get(this.parent), charsToEscape, '\\') + "\" -> \"" + StringUtils.escapeString(index.get(this.child), charsToEscape, '\\');
        }
        return this.cached;
    }
}

