/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.dcoref;

import edu.stanford.nlp.dcoref.Dictionaries;
import edu.stanford.nlp.dcoref.Document;
import edu.stanford.nlp.dcoref.Mention;
import edu.stanford.nlp.dcoref.MentionExtractor;
import edu.stanford.nlp.dcoref.Semantics;
import edu.stanford.nlp.dcoref.SieveCoreferenceSystem;
import edu.stanford.nlp.ie.machinereading.domains.ace.AceReader;
import edu.stanford.nlp.ie.machinereading.structure.EntityMention;
import edu.stanford.nlp.ie.machinereading.structure.MachineReadingAnnotations;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.trees.semgraph.SemanticGraph;
import edu.stanford.nlp.trees.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ACEMentionExtractor
extends MentionExtractor {
    private AceReader aceReader;
    private String corpusPath;
    protected int fileIndex = 0;
    protected String[] files;
    private static final Logger logger = SieveCoreferenceSystem.logger;

    public ACEMentionExtractor(Dictionaries dict, Properties props, Semantics semantics) throws Exception {
        super(dict, semantics);
        this.stanfordProcessor = this.loadStanfordProcessor(props);
        if (props.containsKey("dcoref.ace2004")) {
            this.corpusPath = props.getProperty("dcoref.ace2004");
            this.aceReader = new AceReader(this.stanfordProcessor, false, "ACE2004");
        } else if (props.containsKey("dcoref.ace2005")) {
            this.corpusPath = props.getProperty("dcoref.ace2005");
            this.aceReader = new AceReader(this.stanfordProcessor, false);
        }
        this.aceReader.setLoggerLevel(Level.INFO);
        if (this.corpusPath.charAt(this.corpusPath.length() - 1) != File.separatorChar) {
            this.corpusPath = this.corpusPath + File.separatorChar;
        }
        this.files = new File(this.corpusPath).list();
    }

    @Override
    public void resetDocs() {
        super.resetDocs();
        this.fileIndex = 0;
    }

    @Override
    public Document nextDoc() throws Exception {
        List<List<Mention>> allPredictedMentions;
        Annotation anno;
        ArrayList<List<CoreLabel>> allWords = new ArrayList<List<CoreLabel>>();
        ArrayList<List<Mention>> allGoldMentions = new ArrayList<List<Mention>>();
        ArrayList<Tree> allTrees = new ArrayList<Tree>();
        try {
            String filename = "";
            while (this.files.length > this.fileIndex) {
                if (this.files[this.fileIndex].contains("apf.xml")) {
                    filename = this.files[this.fileIndex];
                    ++this.fileIndex;
                    break;
                }
                ++this.fileIndex;
                filename = "";
            }
            if (this.files.length <= this.fileIndex && filename.equals("")) {
                return null;
            }
            anno = this.aceReader.parse(this.corpusPath + filename);
            this.stanfordProcessor.annotate(anno);
            List sentences = (List)anno.get(CoreAnnotations.SentencesAnnotation.class);
            for (CoreMap s : sentences) {
                int i = 1;
                for (CoreLabel w : (List)s.get(CoreAnnotations.TokensAnnotation.class)) {
                    w.set(CoreAnnotations.IndexAnnotation.class, i++);
                    if (w.containsKey(CoreAnnotations.UtteranceAnnotation.class)) continue;
                    w.set(CoreAnnotations.UtteranceAnnotation.class, 0);
                }
                allTrees.add((Tree)s.get(TreeCoreAnnotations.TreeAnnotation.class));
                allWords.add((List<CoreLabel>)s.get(CoreAnnotations.TokensAnnotation.class));
                EntityComparator comparator = new EntityComparator();
                this.extractGoldMentions(s, allGoldMentions, comparator);
            }
            allPredictedMentions = this.mentionFinder.extractPredictedMentions(anno, this.maxID, this.dictionaries);
            ACEMentionExtractor.printRawDoc(sentences, allGoldMentions, filename, true);
            ACEMentionExtractor.printRawDoc(sentences, allPredictedMentions, filename, false);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return this.arrange(anno, allWords, allTrees, allPredictedMentions, allGoldMentions, true);
    }

    private void extractGoldMentions(CoreMap s, List<List<Mention>> allGoldMentions, EntityComparator comparator) {
        ArrayList<Mention> goldMentions = new ArrayList<Mention>();
        allGoldMentions.add(goldMentions);
        List goldMentionList = (List)s.get(MachineReadingAnnotations.EntityMentionsAnnotation.class);
        List words = (List)s.get(CoreAnnotations.TokensAnnotation.class);
        TreeSet<EntityMention> treeForSortGoldMentions = new TreeSet<EntityMention>(comparator);
        if (goldMentionList != null) {
            treeForSortGoldMentions.addAll(goldMentionList);
        }
        if (!treeForSortGoldMentions.isEmpty()) {
            for (EntityMention e : treeForSortGoldMentions) {
                int j;
                Mention men = new Mention();
                men.dependency = (SemanticGraph)s.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class);
                men.startIndex = e.getExtentTokenStart();
                men.endIndex = e.getExtentTokenEnd();
                String[] parseID = e.getObjectId().split("-");
                men.mentionID = Integer.parseInt(parseID[parseID.length - 1]);
                String[] parseCorefID = e.getCorefID().split("-E");
                men.goldCorefClusterID = Integer.parseInt(parseCorefID[parseCorefID.length - 1]);
                men.originalRef = -1;
                for (j = allGoldMentions.size() - 1; j >= 0; --j) {
                    List<Mention> l = allGoldMentions.get(j);
                    for (int k = l.size() - 1; k >= 0; --k) {
                        Mention m = l.get(k);
                        if (men.goldCorefClusterID != m.goldCorefClusterID) continue;
                        men.originalRef = m.mentionID;
                    }
                }
                goldMentions.add(men);
                if (men.mentionID > this.maxID) {
                    this.maxID = men.mentionID;
                }
                for (j = e.getExtentTokenStart(); j < e.getExtentTokenEnd(); ++j) {
                    CoreLabel word = (CoreLabel)words.get(j);
                    String ner = e.getType() + "-" + e.getSubType();
                }
            }
        }
    }

    private static void printRawDoc(List<CoreMap> sentences, List<List<Mention>> allMentions, String filename, boolean gold) throws FileNotFoundException {
        StringBuilder doc = new StringBuilder();
        int previousOffset = 0;
        ClassicCounter<Integer> mentionCount = new ClassicCounter<Integer>();
        for (List<Mention> l : allMentions) {
            for (Mention m : l) {
                mentionCount.incrementCount(m.goldCorefClusterID);
            }
        }
        for (int i = 0; i < sentences.size(); ++i) {
            CoreMap sentence = sentences.get(i);
            List<Mention> mentions = allMentions.get(i);
            String[] tokens = ((String)sentence.get(CoreAnnotations.TextAnnotation.class)).split(" ");
            String sent = "";
            List t = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            if (previousOffset + 2 < (Integer)((CoreLabel)t.get(0)).get(CoreAnnotations.CharacterOffsetBeginAnnotation.class)) {
                sent = sent + "\n";
            }
            previousOffset = (Integer)((CoreLabel)t.get(t.size() - 1)).get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
            ClassicCounter<Integer> startCounts = new ClassicCounter<Integer>();
            ClassicCounter<Integer> endCounts = new ClassicCounter<Integer>();
            HashMap endID = new HashMap();
            for (Mention m : mentions) {
                startCounts.incrementCount(m.startIndex);
                endCounts.incrementCount(m.endIndex);
                if (!endID.containsKey(m.endIndex)) {
                    endID.put(m.endIndex, new HashSet());
                }
                ((Set)endID.get(m.endIndex)).add(m.goldCorefClusterID);
            }
            for (int j = 0; j < tokens.length; ++j) {
                if (endID.containsKey(j)) {
                    for (Integer id : (Set)endID.get(j)) {
                        if (mentionCount.getCount(id) != 1.0 && gold) {
                            sent = sent + "]_" + id;
                            continue;
                        }
                        sent = sent + "]";
                    }
                }
                int k = 0;
                while ((double)k < startCounts.getCount(j)) {
                    if (!sent.endsWith("[")) {
                        sent = sent + " ";
                    }
                    sent = sent + "[";
                    ++k;
                }
                sent = sent + " ";
                sent = sent + tokens[j];
            }
            int k = 0;
            while ((double)k < endCounts.getCount(tokens.length)) {
                sent = sent + "]";
                ++k;
            }
            sent = sent + "\n";
            doc.append(sent);
        }
        if (gold) {
            logger.fine("New DOC: (GOLD MENTIONS) ==================================================");
        } else {
            logger.fine("New DOC: (Predicted Mentions) ==================================================");
        }
        logger.fine(doc.toString());
    }

    private static class EntityComparator
    implements Comparator<EntityMention> {
        private EntityComparator() {
        }

        @Override
        public int compare(EntityMention m1, EntityMention m2) {
            if (m1.getExtentTokenStart() > m2.getExtentTokenStart()) {
                return 1;
            }
            if (m1.getExtentTokenStart() < m2.getExtentTokenStart()) {
                return -1;
            }
            if (m1.getExtentTokenEnd() > m2.getExtentTokenEnd()) {
                return -1;
            }
            if (m1.getExtentTokenEnd() < m2.getExtentTokenEnd()) {
                return 1;
            }
            return 0;
        }
    }
}

