/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.rendering;

import com.github.ajalt.mordant.internal.ConstantsKt;
import com.github.ajalt.mordant.rendering.Line;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.Span;
import com.github.ajalt.mordant.rendering.TextAlign;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.VerticalAlign;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a%\u0010\t\u001a\u00020\u00022\u0016\u0010\n\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\f0\u000b\"\u0004\u0018\u00010\fH\u0000\u00a2\u0006\u0002\u0010\r\u001a.\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001aF\u0010\u0016\u001a\u00020\u0017*\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00012\b\b\u0002\u0010\u0018\u001a\u00020\u00012\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0012\u001a\u00020\u00012\b\b\u0002\u0010\u001b\u001a\u00020\u0001H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"lineWidth", "", "Lcom/github/ajalt/mordant/rendering/Line;", "getLineWidth", "(Lcom/github/ajalt/mordant/rendering/Line;)I", "startStyle", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "getStartStyle", "(Lcom/github/ajalt/mordant/rendering/Line;)Lcom/github/ajalt/mordant/rendering/TextStyle;", "flatLine", "parts", "", "", "([Ljava/lang/Object;)Lcom/github/ajalt/mordant/rendering/Line;", "resizeLine", "", "Lcom/github/ajalt/mordant/rendering/Span;", "line", "scrollRight", "newWidth", "textAlign", "Lcom/github/ajalt/mordant/rendering/TextAlign;", "setSize", "Lcom/github/ajalt/mordant/rendering/Lines;", "newHeight", "verticalAlign", "Lcom/github/ajalt/mordant/rendering/VerticalAlign;", "scrollDown", "mordant"})
@SourceDebugExtension(value={"SMAP\nLines.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lines.kt\ncom/github/ajalt/mordant/rendering/LinesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,198:1\n1#2:199\n1620#3,3:200\n1620#3,3:203\n*S KotlinDebug\n*F\n+ 1 Lines.kt\ncom/github/ajalt/mordant/rendering/LinesKt\n*L\n63#1:200,3\n109#1:203,3\n*E\n"})
public final class LinesKt {
    @NotNull
    public static final TextStyle getStartStyle(@NotNull Line $this$startStyle) {
        Intrinsics.checkNotNullParameter($this$startStyle, "<this>");
        Object object = (Span)CollectionsKt.firstOrNull($this$startStyle);
        if (object == null || (object = ((Span)object).getStyle()) == null) {
            object = ConstantsKt.getDEFAULT_STYLE();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static final int getLineWidth(@NotNull Line $this$lineWidth) {
        Intrinsics.checkNotNullParameter($this$lineWidth, "<this>");
        Iterable iterable = $this$lineWidth.getSpans();
        int n = 0;
        for (Object t : iterable) {
            void it;
            Span span = (Span)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getCellWidth$mordant();
            n = n2 + n3;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Line flatLine(Object ... parts2) {
        Object object;
        Intrinsics.checkNotNullParameter(parts2, "parts");
        Object[] objectArray = parts2;
        int n = 0;
        int n2 = objectArray.length;
        for (int i = 0; i < n2; ++i) {
            void it;
            Object object2 = object = objectArray[i];
            int n3 = n;
            boolean bl = false;
            int n4 = it instanceof Collection ? ((Collection)it).size() : 1;
            n = n3 + n4;
        }
        int size2 = n;
        ArrayList<Object> line = new ArrayList<Object>(size2);
        for (Object part : parts2) {
            object = part;
            if (object == null) continue;
            if (object instanceof Collection) {
                Iterable $this$mapTo$iv = (Iterable)part;
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    Object item$iv;
                    Object t = item$iv = iterator2.next();
                    Collection collection = line;
                    boolean bl = false;
                    Intrinsics.checkNotNull(it, "null cannot be cast to non-null type com.github.ajalt.mordant.rendering.Span");
                    collection.add((Span)it);
                }
                continue;
            }
            if (object instanceof Span) {
                line.add(part);
                continue;
            }
            throw new IllegalStateException(("not a span: " + part).toString());
        }
        return new Line((List<Span>)line);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Lines setSize(@NotNull Lines $this$setSize, int newWidth, int newHeight, @NotNull VerticalAlign verticalAlign2, @NotNull TextAlign textAlign2, int scrollRight, int scrollDown) {
        List<Line> list;
        int n;
        int it;
        int n2;
        List<Line> list2;
        Intrinsics.checkNotNullParameter($this$setSize, "<this>");
        Intrinsics.checkNotNullParameter((Object)verticalAlign2, "verticalAlign");
        Intrinsics.checkNotNullParameter((Object)textAlign2, "textAlign");
        if (newHeight <= 0) {
            return ConstantsKt.getEMPTY_LINES();
        }
        if (newWidth <= 0) {
            ArrayList<Line> arrayList = new ArrayList<Line>(newHeight);
            int n3 = 0;
            while (n3 < newHeight) {
                int n4;
                int n5 = n4 = n3++;
                ArrayList<Line> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(ConstantsKt.getEMPTY_LINE());
            }
            List list3 = arrayList;
            return new Lines(list3);
        }
        Line emptyLine = new Line(CollectionsKt.listOf(Span.Companion.space$default(Span.Companion, newWidth, null, 2, null)));
        if (scrollDown == 0) {
            list2 = $this$setSize.getLines();
        } else {
            int n6 = -CollectionsKt.getLastIndex($this$setSize.getLines());
            if (!(scrollDown <= CollectionsKt.getLastIndex($this$setSize.getLines()) ? n6 <= scrollDown : false)) {
                list2 = CollectionsKt.emptyList();
            } else if (scrollDown < 0) {
                List<Line> it2;
                List<Line> $this$setSize_u24lambda_u245 = it2 = CollectionsKt.createListBuilder($this$setSize.getLines().size() - scrollDown);
                boolean bl = false;
                int n7 = -scrollDown;
                n2 = 0;
                while (n2 < n7) {
                    it = n2++;
                    boolean bl2 = false;
                    $this$setSize_u24lambda_u245.add(emptyLine);
                }
                $this$setSize_u24lambda_u245.addAll((Collection)$this$setSize.getLines());
                list2 = CollectionsKt.build(it2);
            } else {
                list2 = $this$setSize.getLines().subList(scrollDown, $this$setSize.getLines().size());
            }
        }
        List<Line> offsetLines = list2;
        int heightToAdd = RangesKt.coerceAtLeast(newHeight - offsetLines.size(), 0);
        switch (WhenMappings.$EnumSwitchMapping$0[verticalAlign2.ordinal()]) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = heightToAdd / 2 + heightToAdd % 2;
                break;
            }
            case 3: {
                n = heightToAdd;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int topEmptyLineCount = n;
        List<Line> $this$setSize_u24lambda_u249 = list = CollectionsKt.createListBuilder(newHeight);
        boolean bl = false;
        n2 = 0;
        while (n2 < topEmptyLineCount) {
            it = n2++;
            boolean bl3 = false;
            $this$setSize_u24lambda_u249.add(emptyLine);
        }
        Iterable $this$mapTo$iv = offsetLines.subList(0, RangesKt.coerceAtMost(newHeight, offsetLines.size()));
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it3;
            Line line = (Line)item$iv;
            Collection collection = $this$setSize_u24lambda_u249;
            boolean bl4 = false;
            collection.add(new Line(LinesKt.resizeLine((Line)it3, scrollRight, newWidth, textAlign2)));
        }
        int n8 = newHeight - topEmptyLineCount - offsetLines.size();
        int n9 = 0;
        while (n9 < n8) {
            int it4 = n9++;
            boolean bl5 = false;
            $this$setSize_u24lambda_u249.add(emptyLine);
        }
        List<Line> list4 = CollectionsKt.build(list);
        return new Lines(list4);
    }

    public static /* synthetic */ Lines setSize$default(Lines lines, int n, int n2, VerticalAlign verticalAlign2, TextAlign textAlign2, int n3, int n4, int n5, Object object) {
        if ((n5 & 2) != 0) {
            n2 = lines.getLines().size();
        }
        if ((n5 & 4) != 0) {
            verticalAlign2 = VerticalAlign.TOP;
        }
        if ((n5 & 8) != 0) {
            textAlign2 = TextAlign.NONE;
        }
        if ((n5 & 0x10) != 0) {
            n3 = 0;
        }
        if ((n5 & 0x20) != 0) {
            n4 = 0;
        }
        return LinesKt.setSize(lines, n, n2, verticalAlign2, textAlign2, n3, n4);
    }

    private static final List<Span> resizeLine(Line line, int scrollRight, int newWidth, TextAlign textAlign2) {
        List<Span> list;
        List<Span> list2;
        int width = 0;
        int offset = 0;
        List<Span> inputLine = scrollRight < 0 ? CollectionsKt.plus((Collection)CollectionsKt.listOf(Span.Companion.space(-scrollRight, LinesKt.getStartStyle(line))), (Iterable)line.getSpans()) : line.getSpans();
        int startIndex = 0;
        int endIndex = 0;
        endIndex = inputLine.size();
        Span startSpan = null;
        Span endSpan = null;
        Iterator<Span> iterator2 = inputLine.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int j = n++;
            Span span = iterator2.next();
            if (scrollRight > 0 && offset + span.getCellWidth$mordant() < scrollRight) {
                offset += span.getCellWidth$mordant();
                startIndex = j + 1;
                continue;
            }
            if (scrollRight > 0 && offset < scrollRight) {
                if (offset + span.getCellWidth$mordant() > scrollRight) {
                    startSpan = span.drop$mordant(scrollRight - offset).take$mordant(newWidth - width);
                    startIndex = j;
                    width += startSpan.getCellWidth$mordant();
                }
                offset = scrollRight;
                startIndex = j + 1;
                continue;
            }
            if (width + span.getCellWidth$mordant() <= newWidth) {
                width += span.getCellWidth$mordant();
                endIndex = j + 1;
                continue;
            }
            endIndex = j;
            if (width >= newWidth) break;
            endSpan = span.take$mordant(newWidth - width);
            width = newWidth;
            break;
        }
        if (startSpan == null && endSpan == null) {
            list2 = inputLine.subList(startIndex, endIndex);
        } else {
            List<Span> list3;
            List<Span> $this$resizeLine_u24lambda_u2410 = list3 = CollectionsKt.createListBuilder();
            boolean bl = false;
            if (startSpan != null) {
                $this$resizeLine_u24lambda_u2410.add(startSpan);
            }
            $this$resizeLine_u24lambda_u2410.addAll((Collection)inputLine.subList(startIndex, endIndex));
            if (endSpan != null) {
                $this$resizeLine_u24lambda_u2410.add(endSpan);
            }
            list2 = CollectionsKt.build(list3);
        }
        List<Span> outputLine = list2;
        int remainingWidth = newWidth - width;
        if (remainingWidth == 0) {
            return outputLine;
        }
        Object object = CollectionsKt.firstOrNull(outputLine);
        if (object == null || (object = ((Span)object).getStyle()) == null) {
            object = line.getEndStyle();
        }
        Object beginStyle = object;
        TextStyle endStyle = line.getEndStyle();
        switch (WhenMappings.$EnumSwitchMapping$1[textAlign2.ordinal()]) {
            case 1: {
                list = CollectionsKt.plus((Collection)outputLine, Span.Companion.space(remainingWidth, endStyle));
                break;
            }
            case 2: {
                list = CollectionsKt.plus((Collection)outputLine, Span.Companion.space$default(Span.Companion, remainingWidth, null, 2, null));
                break;
            }
            case 3: {
                list = CollectionsKt.plus((Collection)CollectionsKt.listOf(Span.Companion.space(remainingWidth, (TextStyle)beginStyle)), (Iterable)outputLine);
                break;
            }
            case 4: 
            case 5: {
                List<Span> list4;
                Span l = Span.Companion.space(remainingWidth / 2, (TextStyle)beginStyle);
                Span r = Span.Companion.space(remainingWidth / 2 + remainingWidth % 2, endStyle);
                List<Span> $this$resizeLine_u24lambda_u2411 = list4 = CollectionsKt.createListBuilder(outputLine.size() + 2);
                boolean bl = false;
                $this$resizeLine_u24lambda_u2411.add(l);
                $this$resizeLine_u24lambda_u2411.addAll((Collection)outputLine);
                $this$resizeLine_u24lambda_u2411.add(r);
                list = CollectionsKt.build(list4);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[VerticalAlign.values().length];
            try {
                nArray[VerticalAlign.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VerticalAlign.MIDDLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VerticalAlign.BOTTOM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TextAlign.values().length];
            try {
                nArray[TextAlign.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextAlign.NONE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextAlign.RIGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextAlign.CENTER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextAlign.JUSTIFY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

