/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.bib;

import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.bib.BibParser;
import com.dickimawbooks.texparserlib.bib.BibString;
import com.dickimawbooks.texparserlib.bib.BibTeXSyntaxException;
import com.dickimawbooks.texparserlib.bib.BibValue;
import java.io.IOException;

public class BibVariable
implements BibValue {
    private TeXObject string;
    private String variableName;

    public BibVariable(TeXObject teXObject, String string) {
        this.string = teXObject;
        this.variableName = string;
    }

    @Override
    public Object clone() {
        return new BibVariable((TeXObject)this.string.clone(), this.variableName);
    }

    @Override
    public TeXObject getContents() {
        return this.string;
    }

    public String getVariableName() {
        return this.variableName;
    }

    @Override
    public String applyDelim(byte by) {
        return this.string.format();
    }

    @Override
    public TeXObjectList expand(TeXParser teXParser) throws IOException {
        BibParser bibParser = (BibParser)teXParser.getListener();
        BibString bibString = bibParser.getBibString(this.variableName);
        if (bibString == null) {
            throw new BibTeXSyntaxException(teXParser, "bibtex.error.string_name_undefined", this.variableName);
        }
        return bibString.getValue().expand(teXParser);
    }
}

